/*
 * jPlayerAudio Plugin for jQuery JavaScript Library
 * http://www.jplayer.org
 *
 * Copyright (c) 2009 - 2014 Happyworm Ltd
 * Licensed under the MIT license.
 * http://opensource.org/licenses/MIT
 *
 * Author: Mark J Panaghiston
 * Version: 2.9.2
 * Date: 14th December 2014
 */

/* Support for Zepto 1.0 compiled with optional data module.
 * For AMD or NODE/CommonJS support, you will need to manually switch the related 2 lines in the code below.
 * Search terms: "jQuery Switch" and "Zepto Switch"
 */

(function(b,l){"function"===typeof define&&define.amd?define(["jquery"],l):"object"===typeof exports?l(require("jquery")):b.jQuery?l(b.jQuery):l(b.Zepto)})(this,function(b,l){b.fn.jPlayerAudio=function(a){var d="string"===typeof a,c=Array.prototype.slice.call(arguments,1),f=this;a=!d&&c.length?b.extend.apply(null,[!0,a].concat(c)):a;if(d&&"_"===a.charAt(0))return f;d?this.each(function(){var d=b(this).data("jPlayerAudio"),e=d&&b.isFunction(d[a])?d[a].apply(d,c):d;if(e!==d&&e!==l)return f=e,!1}):this.each(function(){var d=
b(this).data("jPlayerAudio");d?d.option(a||{}):b(this).data("jPlayerAudio",new b.jPlayerAudio(a,this))});return f};b.jPlayerAudio=function(a,d){if(arguments.length){this.element=b(d);this.options=b.extend(!0,{},this.options,a);var c=this;this.element.bind("remove.jPlayerAudio",function(){c.destroy()});this._init()}};"function"!==typeof b.fn.stop&&(b.fn.stop=function(){});b.jPlayerAudio.emulateMethods="load play pause";b.jPlayerAudio.emulateStatus="src readyState networkState currentTime duration paused ended playbackRate";
b.jPlayerAudio.emulateOptions="muted volume";b.jPlayerAudio.reservedEvent="ready flashreset resize repeat error warning";b.jPlayerAudio.event={};b.each("ready setmedia flashreset resize repeat click error warning loadstart progress suspend abort emptied stalled play pause loadedmetadata loadeddata waiting playing canplay canplaythrough seeking seeked timeupdate ended ratechange durationchange volumechange".split(" "),function(){b.jPlayerAudio.event[this]="jPlayerAudio_"+this});b.jPlayerAudio.htmlEvent=
"loadstart abort emptied stalled loadedmetadata canplay canplaythrough".split(" ");b.jPlayerAudio.pause=function(){b.jPlayerAudio.prototype.destroyRemoved();b.each(b.jPlayerAudio.prototype.instances,function(a,b){b.data("jPlayerAudio").status.srcSet&&b.jPlayerAudio("pause")})};b.jPlayerAudio.timeFormat={showHour:!1,showMin:!0,showSec:!0,padHour:!1,padMin:!0,padSec:!0,sepHour:":",sepMin:":",sepSec:""};var e=function(){this.init()};e.prototype={init:function(){this.options={timeFormat:b.jPlayerAudio.timeFormat}},
time:function(a){var b=new Date(1E3*(a&&"number"===typeof a?a:0)),c=b.getUTCHours();a=this.options.timeFormat.showHour?b.getUTCMinutes():b.getUTCMinutes()+60*c;b=this.options.timeFormat.showMin?b.getUTCSeconds():b.getUTCSeconds()+60*a;c=this.options.timeFormat.padHour&&10>c?"0"+c:c;a=this.options.timeFormat.padMin&&10>a?"0"+a:a;b=this.options.timeFormat.padSec&&10>b?"0"+b:b;c=""+(this.options.timeFormat.showHour?c+this.options.timeFormat.sepHour:"");c+=this.options.timeFormat.showMin?a+this.options.timeFormat.sepMin:
"";return c+=this.options.timeFormat.showSec?b+this.options.timeFormat.sepSec:""}};var h=new e;b.jPlayerAudio.convertTime=function(a){return h.time(a)};b.jPlayerAudio.uaBrowser=function(a){a=a.toLowerCase();var b=/(opera)(?:.*version)?[ \/]([\w.]+)/,c=/(msie) ([\w.]+)/,f=/(mozilla)(?:.*? rv:([\w.]+))?/;a=/(webkit)[ \/]([\w.]+)/.exec(a)||b.exec(a)||c.exec(a)||0>a.indexOf("compatible")&&f.exec(a)||[];return{browser:a[1]||"",version:a[2]||"0"}};b.jPlayerAudio.uaPlatform=function(a){var b=a.toLowerCase(),
c=/(android)/,f=/(mobile)/;a=/(ipad|iphone|ipod|android|blackberry|playbook|windows ce|webos)/.exec(b)||[];b=/(ipad|playbook)/.exec(b)||!f.exec(b)&&c.exec(b)||[];a[1]&&(a[1]=a[1].replace(/\s/g,"_"));return{platform:a[1]||"",tablet:b[1]||""}};b.jPlayerAudio.browser={};b.jPlayerAudio.platform={};var k=b.jPlayerAudio.uaBrowser(navigator.userAgent);k.browser&&(b.jPlayerAudio.browser[k.browser]=!0,b.jPlayerAudio.browser.version=k.version);k=b.jPlayerAudio.uaPlatform(navigator.userAgent);k.platform&&(b.jPlayerAudio.platform[k.platform]=
!0,b.jPlayerAudio.platform.mobile=!k.tablet,b.jPlayerAudio.platform.tablet=!!k.tablet);b.jPlayerAudio.getDocMode=function(){var a;b.jPlayerAudio.browser.msie&&(document.documentMode?a=document.documentMode:(a=5,document.compatMode&&"CSS1Compat"===document.compatMode&&(a=7)));return a};b.jPlayerAudio.browser.documentMode=b.jPlayerAudio.getDocMode();b.jPlayerAudio.nativeFeatures={init:function(){var a=document,b=a.createElement("video"),c={w3c:"fullscreenEnabled fullscreenElement requestFullscreen exitFullscreen fullscreenchange fullscreenerror".split(" "),
moz:"mozFullScreenEnabled mozFullScreenElement mozRequestFullScreen mozCancelFullScreen mozfullscreenchange mozfullscreenerror".split(" "),webkit:" webkitCurrentFullScreenElement webkitRequestFullScreen webkitCancelFullScreen webkitfullscreenchange ".split(" "),webkitVideo:"webkitSupportsFullscreen webkitDisplayingFullscreen webkitEnterFullscreen webkitExitFullscreen  ".split(" "),ms:" msFullscreenElement msRequestFullscreen msExitFullscreen MSFullscreenChange MSFullscreenError".split(" ")},f=["w3c",
"moz","webkit","webkitVideo","ms"],e,n;this.fullscreen=b={support:{w3c:!!a[c.w3c[0]],moz:!!a[c.moz[0]],webkit:"function"===typeof a[c.webkit[3]],webkitVideo:"function"===typeof b[c.webkitVideo[2]],ms:"function"===typeof b[c.ms[2]]},used:{}};e=0;for(n=f.length;e<n;e++){var g=f[e];if(b.support[g]){b.spec=g;b.used[g]=!0;break}}if(b.spec){var h=c[b.spec];b.api={fullscreenEnabled:!0,fullscreenElement:function(b){b=b?b:a;return b[h[1]]},requestFullscreen:function(a){return a[h[2]]()},exitFullscreen:function(b){b=
b?b:a;return b[h[3]]()}};b.event={fullscreenchange:h[4],fullscreenerror:h[5]}}else b.api={fullscreenEnabled:!1,fullscreenElement:function(){return null},requestFullscreen:function(){},exitFullscreen:function(){}},b.event={}}};b.jPlayerAudio.nativeFeatures.init();b.jPlayerAudio.focus=null;b.jPlayerAudio.keyIgnoreElementNames="A INPUT TEXTAREA SELECT BUTTON";var g=function(a){var d=b.jPlayerAudio.focus,c;d&&(b.each(b.jPlayerAudio.keyIgnoreElementNames.split(/\s+/g),function(b,d){if(a.target.nodeName.toUpperCase()===
d.toUpperCase())return c=!0,!1}),c||b.each(d.options.keyBindings,function(c,e){if(e&&b.isFunction(e.fn)&&("number"===typeof e.key&&a.which===e.key||"string"===typeof e.key&&a.key===e.key))return a.preventDefault(),e.fn(d),!1}))};b.jPlayerAudio.keys=function(a){b(document.documentElement).unbind("keydown.jPlayerAudio");a&&b(document.documentElement).bind("keydown.jPlayerAudio",g)};b.jPlayerAudio.keys(!0);b.jPlayerAudio.prototype={count:0,version:{script:"2.9.2",needFlash:"2.9.0",flash:"unknown"},options:{swfPath:"js",
solution:"html, flash",supplied:"mp3",auroraFormats:"wav",preload:"metadata",volume:.8,muted:!1,remainingDuration:!1,toggleDuration:!1,captureDuration:!0,playbackRate:1,defaultPlaybackRate:1,minPlaybackRate:.5,maxPlaybackRate:4,wmode:"opaque",backgroundColor:"#000000",cssSelectorAncestor:"#jp_audio_container_1",cssSelector:{videoPlay:".mdtc-clnplra-video-play",play:".mdtc-clnplra-play",pause:".mdtc-clnplra-pause",stop:".mdtc-clnplra-stop",seekBar:".mdtc-clnplra-seek-bar",playBar:".mdtc-clnplra-play-bar",
mute:".mdtc-clnplra-mute",unmute:".mdtc-clnplra-unmute",volumeBar:".mdtc-clnplra-volume-bar",volumeBarValue:".mdtc-clnplra-volume-bar-value",volumeMax:".mdtc-clnplra-volume-max",playbackRateBar:".mdtc-clnplra-playback-rate-bar",playbackRateBarValue:".mdtc-clnplra-playback-rate-bar-value",currentTime:".mdtc-clnplra-current-time",duration:".mdtc-clnplra-duration",title:".mdtc-clnplra-title",fullScreen:".mdtc-clnplra-full-screen",restoreScreen:".mdtc-clnplra-restore-screen",repeat:".mdtc-clnplra-repeat",
repeatOff:".mdtc-clnplra-repeat-off",gui:".mdtc-clnplra-gui",noSolution:".mdtc-clnplra-no-solution"},stateClass:{playing:"mdtc-clnplra-state-playing",seeking:"mdtc-clnplra-state-seeking",muted:"mdtc-clnplra-state-muted",looped:"mdtc-clnplra-state-looped",fullScreen:"mdtc-clnplra-state-full-screen",noVolume:"mdtc-clnplra-state-no-volume"},useStateClassSkin:!1,autoBlur:!0,smoothPlayBar:!1,fullScreen:!1,fullWindow:!1,autohide:{restored:!1,full:!0,fadeIn:200,fadeOut:600,hold:1E3},loop:!1,repeat:function(a){a.jPlayerAudio.options.loop?
b(this).unbind(".jPlayerAudioRepeat").bind(b.jPlayerAudio.event.ended+".jPlayerAudio.jPlayerAudioRepeat",function(){b(this).jPlayerAudio("play")}):b(this).unbind(".jPlayerAudioRepeat")},nativeVideoControls:{},noFullWindow:{msie:/msie [0-6]\./,ipad:/ipad.*?os [0-4]\./,iphone:/iphone/,ipod:/ipod/,android_pad:/android [0-3]\.(?!.*?mobile)/,android_phone:/(?=.*android)(?!.*chrome)(?=.*mobile)/,blackberry:/blackberry/,windows_ce:/windows ce/,iemobile:/iemobile/,webos:/webos/},noVolume:{ipad:/ipad/,iphone:/iphone/,
ipod:/ipod/,android_pad:/android(?!.*?mobile)/,android_phone:/android.*?mobile/,blackberry:/blackberry/,windows_ce:/windows ce/,iemobile:/iemobile/,webos:/webos/,playbook:/playbook/},timeFormat:{},keyEnabled:!1,audioFullScreen:!1,keyBindings:{play:{key:80,fn:function(a){a.status.paused?a.play():a.pause()}},fullScreen:{key:70,fn:function(a){(a.status.video||a.options.audioFullScreen)&&a._setOption("fullScreen",!a.options.fullScreen)}},muted:{key:77,fn:function(a){a._muted(!a.options.muted)}},volumeUp:{key:190,
fn:function(a){a.volume(a.options.volume+.1)}},volumeDown:{key:188,fn:function(a){a.volume(a.options.volume-.1)}},loop:{key:76,fn:function(a){a._loop(!a.options.loop)}}},verticalVolume:!1,verticalPlaybackRate:!1,globalVolume:!1,idPrefix:"jp_audio",noConflict:"jQuery",emulateHtml:!1,consoleAlerts:!0,errorAlerts:!1,warningAlerts:!1},optionsAudio:{size:{width:"0px",height:"0px",cssClass:""},sizeFull:{width:"0px",height:"0px",cssClass:""}},optionsVideo:{size:{width:"480px",height:"270px",cssClass:"mdtc-clnplra-video-270p"},
sizeFull:{width:"100%",height:"100%",cssClass:"mdtc-clnplra-video-full"}},instances:{},status:{src:"",media:{},paused:!0,format:{},formatType:"",waitForPlay:!0,waitForLoad:!0,srcSet:!1,video:!1,seekPercent:0,currentPercentRelative:0,currentPercentAbsolute:0,currentTime:0,duration:0,remaining:0,videoWidth:0,videoHeight:0,readyState:0,networkState:0,playbackRate:1,ended:0},internal:{ready:!1},solution:{html:!0,aurora:!0,flash:!0},format:{mp3:{codec:"audio/mpeg",flashCanPlay:!0,media:"audio"},m4a:{codec:'audio/mp4; codecs="mp4a.40.2"',
flashCanPlay:!0,media:"audio"},m3u8a:{codec:'application/vnd.apple.mpegurl; codecs="mp4a.40.2"',flashCanPlay:!1,media:"audio"},m3ua:{codec:"audio/mpegurl",flashCanPlay:!1,media:"audio"},oga:{codec:'audio/ogg; codecs="vorbis, opus"',flashCanPlay:!1,media:"audio"},flac:{codec:"audio/x-flac",flashCanPlay:!1,media:"audio"},wav:{codec:'audio/wav; codecs="1"',flashCanPlay:!1,media:"audio"},webma:{codec:'audio/webm; codecs="vorbis"',flashCanPlay:!1,media:"audio"},fla:{codec:"audio/x-flv",flashCanPlay:!0,
media:"audio"},rtmpa:{codec:'audio/rtmp; codecs="rtmp"',flashCanPlay:!0,media:"audio"},m4v:{codec:'video/mp4; codecs="avc1.42E01E, mp4a.40.2"',flashCanPlay:!0,media:"video"},m3u8v:{codec:'application/vnd.apple.mpegurl; codecs="avc1.42E01E, mp4a.40.2"',flashCanPlay:!1,media:"video"},m3uv:{codec:"audio/mpegurl",flashCanPlay:!1,media:"video"},ogv:{codec:'video/ogg; codecs="theora, vorbis"',flashCanPlay:!1,media:"video"},webmv:{codec:'video/webm; codecs="vorbis, vp8"',flashCanPlay:!1,media:"video"},flv:{codec:"video/x-flv",
flashCanPlay:!0,media:"video"},rtmpv:{codec:'video/rtmp; codecs="rtmp"',flashCanPlay:!0,media:"video"}},_init:function(){var a=this;this.element.empty();this.status=b.extend({},this.status);this.internal=b.extend({},this.internal);this.options.timeFormat=b.extend({},b.jPlayerAudio.timeFormat,this.options.timeFormat);this.internal.cmdsIgnored=b.jPlayerAudio.platform.ipad||b.jPlayerAudio.platform.iphone||b.jPlayerAudio.platform.ipod;this.internal.domNode=this.element.get(0);this.options.keyEnabled&&
!b.jPlayerAudio.focus&&(b.jPlayerAudio.focus=this);this.androidFix={setMedia:!1,play:!1,pause:!1,time:NaN};b.jPlayerAudio.platform.android&&(this.options.preload="auto"!==this.options.preload?"metadata":"auto");this.formats=[];this.solutions=[];this.require={};this.htmlElement={};this.html={};this.html.audio={};this.html.video={};this.aurora={};this.aurora.formats=[];this.aurora.properties=[];this.flash={};this.css={};this.css.cs={};this.css.jq={};this.ancestorJq=[];this.options.volume=this._limitValue(this.options.volume,
0,1);b.each(this.options.supplied.toLowerCase().split(","),function(d,c){var f=c.replace(/^\s+|\s+$/g,"");if(a.format[f]){var e=!1;b.each(a.formats,function(a,b){if(f===b)return e=!0,!1});e||a.formats.push(f)}});b.each(this.options.solution.toLowerCase().split(","),function(d,c){var f=c.replace(/^\s+|\s+$/g,"");if(a.solution[f]){var e=!1;b.each(a.solutions,function(a,b){if(f===b)return e=!0,!1});e||a.solutions.push(f)}});b.each(this.options.auroraFormats.toLowerCase().split(","),function(d,c){var f=
c.replace(/^\s+|\s+$/g,"");if(a.format[f]){var e=!1;b.each(a.aurora.formats,function(a,b){if(f===b)return e=!0,!1});e||a.aurora.formats.push(f)}});this.internal.instance="jp_audio_"+this.count;this.instances[this.internal.instance]=this.element;this.element.attr("id")||this.element.attr("id",this.options.idPrefix+"_jplayer_"+this.count);this.internal.self=b.extend({},{id:this.element.attr("id"),jq:this.element});this.internal.audio=b.extend({},{id:this.options.idPrefix+"_audio_"+this.count,jq:l});
this.internal.video=b.extend({},{id:this.options.idPrefix+"_video_"+this.count,jq:l});this.internal.flash=b.extend({},{id:this.options.idPrefix+"_flash_"+this.count,jq:l,swf:this.options.swfPath+(".swf"!==this.options.swfPath.toLowerCase().slice(-4)?(this.options.swfPath&&"/"!==this.options.swfPath.slice(-1)?"/":"")+"jquery.jplayer.swf":"")});this.internal.poster=b.extend({},{id:this.options.idPrefix+"_poster_"+this.count,jq:l});b.each(b.jPlayerAudio.event,function(b,d){a.options[b]!==l&&(a.element.bind(d+
".jPlayerAudio",a.options[b]),a.options[b]=l)});this.require.audio=!1;this.require.video=!1;b.each(this.formats,function(b,d){a.require[a.format[d].media]=!0});this.options=this.require.video?b.extend(!0,{},this.optionsVideo,this.options):b.extend(!0,{},this.optionsAudio,this.options);this._setSize();this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this.status.noFullWindow=this._uaBlocklist(this.options.noFullWindow);this.status.noVolume=this._uaBlocklist(this.options.noVolume);
b.jPlayerAudio.nativeFeatures.fullscreen.api.fullscreenEnabled&&this._fullscreenAddEventListeners();this._restrictNativeVideoControls();this.htmlElement.poster=document.createElement("img");this.htmlElement.poster.id=this.internal.poster.id;this.htmlElement.poster.onload=function(){a.status.video&&!a.status.waitForPlay||a.internal.poster.jq.show()};this.element.append(this.htmlElement.poster);this.internal.poster.jq=b("#"+this.internal.poster.id);this.internal.poster.jq.css({width:this.status.width,
height:this.status.height});this.internal.poster.jq.hide();this.internal.poster.jq.bind("click.jPlayerAudio",function(){a._trigger(b.jPlayerAudio.event.click)});this.html.audio.available=!1;this.require.audio&&(this.htmlElement.audio=document.createElement("audio"),this.htmlElement.audio.id=this.internal.audio.id,this.html.audio.available=!!this.htmlElement.audio.canPlayType&&this._testCanPlayType(this.htmlElement.audio));this.html.video.available=!1;this.require.video&&(this.htmlElement.video=document.createElement("video"),
this.htmlElement.video.id=this.internal.video.id,this.html.video.available=!!this.htmlElement.video.canPlayType&&this._testCanPlayType(this.htmlElement.video));this.flash.available=this._checkForFlash(10.1);this.html.canPlay={};this.aurora.canPlay={};this.flash.canPlay={};b.each(this.formats,function(d,c){a.html.canPlay[c]=a.html[a.format[c].media].available&&""!==a.htmlElement[a.format[c].media].canPlayType(a.format[c].codec);a.aurora.canPlay[c]=-1<b.inArray(c,a.aurora.formats);a.flash.canPlay[c]=
a.format[c].flashCanPlay&&a.flash.available});this.html.desired=!1;this.aurora.desired=!1;this.flash.desired=!1;b.each(this.solutions,function(d,c){if(0===d)a[c].desired=!0;else{var f=!1,e=!1;b.each(a.formats,function(b,d){a[a.solutions[0]].canPlay[d]&&("video"===a.format[d].media?e=!0:f=!0)});a[c].desired=a.require.audio&&!f||a.require.video&&!e}});this.html.support={};this.aurora.support={};this.flash.support={};b.each(this.formats,function(b,d){a.html.support[d]=a.html.canPlay[d]&&a.html.desired;
a.aurora.support[d]=a.aurora.canPlay[d]&&a.aurora.desired;a.flash.support[d]=a.flash.canPlay[d]&&a.flash.desired});this.html.used=!1;this.aurora.used=!1;this.flash.used=!1;b.each(this.solutions,function(d,c){b.each(a.formats,function(b,d){if(a[c].support[d])return a[c].used=!0,!1})});this._resetActive();this._resetGate();this._cssSelectorAncestor(this.options.cssSelectorAncestor);this.html.used||this.aurora.used||this.flash.used?this.css.jq.noSolution.length&&this.css.jq.noSolution.hide():(this._error({type:b.jPlayerAudio.error.NO_SOLUTION,
context:"{solution:'"+this.options.solution+"', supplied:'"+this.options.supplied+"'}",message:b.jPlayerAudio.errorMsg.NO_SOLUTION,hint:b.jPlayerAudio.errorHint.NO_SOLUTION}),this.css.jq.noSolution.length&&this.css.jq.noSolution.show());if(this.flash.used){var d,c="jQuery="+encodeURI(this.options.noConflict)+"&id="+encodeURI(this.internal.self.id)+"&vol="+this.options.volume+"&muted="+this.options.muted;if(b.jPlayerAudio.browser.msie&&(9>Number(b.jPlayerAudio.browser.version)||9>b.jPlayerAudio.browser.documentMode)){c=
['<param name="movie" value="'+this.internal.flash.swf+'" />','<param name="FlashVars" value="'+c+'" />','<param name="allowScriptAccess" value="always" />','<param name="bgcolor" value="'+this.options.backgroundColor+'" />','<param name="wmode" value="'+this.options.wmode+'" />'];d=document.createElement('<object id="'+this.internal.flash.id+'" classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="0" height="0" tabindex="-1"></object>');for(var f=0;f<c.length;f++)d.appendChild(document.createElement(c[f]))}else f=
function(a,b,d){var c=document.createElement("param");c.setAttribute("name",b);c.setAttribute("value",d);a.appendChild(c)},d=document.createElement("object"),d.setAttribute("id",this.internal.flash.id),d.setAttribute("name",this.internal.flash.id),d.setAttribute("data",this.internal.flash.swf),d.setAttribute("type","application/x-shockwave-flash"),d.setAttribute("width","1"),d.setAttribute("height","1"),d.setAttribute("tabindex","-1"),f(d,"flashvars",c),f(d,"allowscriptaccess","always"),f(d,"bgcolor",
this.options.backgroundColor),f(d,"wmode",this.options.wmode);this.element.append(d);this.internal.flash.jq=b(d)}this.status.playbackRateEnabled=this.html.used&&!this.flash.used?this._testPlaybackRate("audio"):!1;this._updatePlaybackRate();this.html.used&&(this.html.audio.available&&(this._addHtmlEventListeners(this.htmlElement.audio,this.html.audio),this.element.append(this.htmlElement.audio),this.internal.audio.jq=b("#"+this.internal.audio.id)),this.html.video.available&&(this._addHtmlEventListeners(this.htmlElement.video,
this.html.video),this.element.append(this.htmlElement.video),this.internal.video.jq=b("#"+this.internal.video.id),this.status.nativeVideoControls?this.internal.video.jq.css({width:this.status.width,height:this.status.height}):this.internal.video.jq.css({width:"0px",height:"0px"}),this.internal.video.jq.bind("click.jPlayerAudio",function(){a._trigger(b.jPlayerAudio.event.click)})));this.options.emulateHtml&&this._emulateHtmlBridge();!this.html.used&&!this.aurora.used||this.flash.used||setTimeout(function(){a.internal.ready=
!0;a.version.flash="n/a";a._trigger(b.jPlayerAudio.event.repeat);a._trigger(b.jPlayerAudio.event.ready)},100);this._updateNativeVideoControls();this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide();b.jPlayerAudio.prototype.count++},destroy:function(){this.clearMedia();this._removeUiClass();this.css.jq.currentTime.length&&this.css.jq.currentTime.text("");this.css.jq.duration.length&&this.css.jq.duration.text("");b.each(this.css.jq,function(a,b){b.length&&b.unbind(".jPlayerAudio")});this.internal.poster.jq.unbind(".jPlayerAudio");
this.internal.video.jq&&this.internal.video.jq.unbind(".jPlayerAudio");this._fullscreenRemoveEventListeners();this===b.jPlayerAudio.focus&&(b.jPlayerAudio.focus=null);this.options.emulateHtml&&this._destroyHtmlBridge();this.element.removeData("jPlayerAudio");this.element.unbind(".jPlayerAudio");this.element.empty();delete this.instances[this.internal.instance]},destroyRemoved:function(){var a=this;b.each(this.instances,function(b,c){a.element===c||c.data("jPlayerAudio")||(c.jPlayerAudio("destroy"),
delete a.instances[b])})},enable:function(){},disable:function(){},_testCanPlayType:function(a){try{return a.canPlayType(this.format.mp3.codec),!0}catch(b){return!1}},_testPlaybackRate:function(a){a=document.createElement("string"===typeof a?a:"audio");try{return"playbackRate"in a?(a.playbackRate=.5,.5===a.playbackRate):!1}catch(b){return!1}},_uaBlocklist:function(a){var d=navigator.userAgent.toLowerCase(),c=!1;b.each(a,function(a,b){if(b&&b.test(d))return c=!0,!1});return c},_restrictNativeVideoControls:function(){this.require.audio&&
this.status.nativeVideoControls&&(this.status.nativeVideoControls=!1,this.status.noFullWindow=!0)},_updateNativeVideoControls:function(){this.html.video.available&&this.html.used&&(this.htmlElement.video.controls=this.status.nativeVideoControls,this._updateAutohide(),this.status.nativeVideoControls&&this.require.video?(this.internal.poster.jq.hide(),this.internal.video.jq.css({width:this.status.width,height:this.status.height})):this.status.waitForPlay&&this.status.video&&(this.internal.poster.jq.show(),
this.internal.video.jq.css({width:"0px",height:"0px"})))},_addHtmlEventListeners:function(a,d){var c=this;a.preload=this.options.preload;a.muted=this.options.muted;a.volume=this.options.volume;this.status.playbackRateEnabled&&(a.defaultPlaybackRate=this.options.defaultPlaybackRate,a.playbackRate=this.options.playbackRate);a.addEventListener("progress",function(){d.gate&&(c.internal.cmdsIgnored&&0<this.readyState&&(c.internal.cmdsIgnored=!1),c._getHtmlStatus(a),c._updateInterface(),c._trigger(b.jPlayerAudio.event.progress))},
!1);a.addEventListener("loadeddata",function(){d.gate&&(c.androidFix.setMedia=!1,c.androidFix.play&&(c.androidFix.play=!1,c.play(c.androidFix.time)),c.androidFix.pause&&(c.androidFix.pause=!1,c.pause(c.androidFix.time)),c._trigger(b.jPlayerAudio.event.loadeddata))},!1);a.addEventListener("timeupdate",function(){d.gate&&(c._getHtmlStatus(a),c._updateInterface(),c._trigger(b.jPlayerAudio.event.timeupdate))},!1);a.addEventListener("durationchange",function(){d.gate&&(c._getHtmlStatus(a),c._updateInterface(),
c._trigger(b.jPlayerAudio.event.durationchange))},!1);a.addEventListener("play",function(){d.gate&&(c._updateButtons(!0),c._html_checkWaitForPlay(),c._trigger(b.jPlayerAudio.event.play))},!1);a.addEventListener("playing",function(){d.gate&&(c._updateButtons(!0),c._seeked(),c._trigger(b.jPlayerAudio.event.playing))},!1);a.addEventListener("pause",function(){d.gate&&(c._updateButtons(!1),c._trigger(b.jPlayerAudio.event.pause))},!1);a.addEventListener("waiting",function(){d.gate&&(c._seeking(),c._trigger(b.jPlayerAudio.event.waiting))},
!1);a.addEventListener("seeking",function(){d.gate&&(c._seeking(),c._trigger(b.jPlayerAudio.event.seeking))},!1);a.addEventListener("seeked",function(){d.gate&&(c._seeked(),c._trigger(b.jPlayerAudio.event.seeked))},!1);a.addEventListener("volumechange",function(){d.gate&&(c.options.volume=a.volume,c.options.muted=a.muted,c._updateMute(),c._updateVolume(),c._trigger(b.jPlayerAudio.event.volumechange))},!1);a.addEventListener("ratechange",function(){d.gate&&(c.options.defaultPlaybackRate=a.defaultPlaybackRate,
c.options.playbackRate=a.playbackRate,c._updatePlaybackRate(),c._trigger(b.jPlayerAudio.event.ratechange))},!1);a.addEventListener("suspend",function(){d.gate&&(c._seeked(),c._trigger(b.jPlayerAudio.event.suspend))},!1);a.addEventListener("ended",function(){d.gate&&(b.jPlayerAudio.browser.webkit||(c.htmlElement.media.currentTime=0),c.htmlElement.media.pause(),c._updateButtons(!1),c._getHtmlStatus(a,!0),c._updateInterface(),c._trigger(b.jPlayerAudio.event.ended))},!1);a.addEventListener("error",function(){d.gate&&
(c._updateButtons(!1),c._seeked(),c.status.srcSet&&(clearTimeout(c.internal.htmlDlyCmdId),c.status.waitForLoad=!0,c.status.waitForPlay=!0,c.status.video&&!c.status.nativeVideoControls&&c.internal.video.jq.css({width:"0px",height:"0px"}),c._validString(c.status.media.poster)&&!c.status.nativeVideoControls&&c.internal.poster.jq.show(),c.css.jq.videoPlay.length&&c.css.jq.videoPlay.show(),c._error({type:b.jPlayerAudio.error.URL,context:c.status.src,message:b.jPlayerAudio.errorMsg.URL,hint:b.jPlayerAudio.errorHint.URL})))},
!1);b.each(b.jPlayerAudio.htmlEvent,function(f,e){a.addEventListener(this,function(){d.gate&&c._trigger(b.jPlayerAudio.event[e])},!1)})},_addAuroraEventListeners:function(a,d){var c=this;a.volume=100*this.options.volume;a.on("progress",function(){d.gate&&(c.internal.cmdsIgnored&&0<this.readyState&&(c.internal.cmdsIgnored=!1),c._getAuroraStatus(a),c._updateInterface(),c._trigger(b.jPlayerAudio.event.progress),0<a.duration&&c._trigger(b.jPlayerAudio.event.timeupdate))},!1);a.on("ready",function(){d.gate&&
c._trigger(b.jPlayerAudio.event.loadeddata)},!1);a.on("duration",function(){d.gate&&(c._getAuroraStatus(a),c._updateInterface(),c._trigger(b.jPlayerAudio.event.durationchange))},!1);a.on("end",function(){d.gate&&(c._updateButtons(!1),c._getAuroraStatus(a,!0),c._updateInterface(),c._trigger(b.jPlayerAudio.event.ended))},!1);a.on("error",function(){d.gate&&(c._updateButtons(!1),c._seeked(),c.status.srcSet&&(c.status.waitForLoad=!0,c.status.waitForPlay=!0,c.status.video&&!c.status.nativeVideoControls&&
c.internal.video.jq.css({width:"0px",height:"0px"}),c._validString(c.status.media.poster)&&!c.status.nativeVideoControls&&c.internal.poster.jq.show(),c.css.jq.videoPlay.length&&c.css.jq.videoPlay.show(),c._error({type:b.jPlayerAudio.error.URL,context:c.status.src,message:b.jPlayerAudio.errorMsg.URL,hint:b.jPlayerAudio.errorHint.URL})))},!1)},_getHtmlStatus:function(a,b){var c,f,e,g;isFinite(a.duration)&&(this.status.duration=a.duration);c=a.currentTime;f=0<this.status.duration?100*c/this.status.duration:
0;"object"===typeof a.seekable&&0<a.seekable.length?(e=0<this.status.duration?100*a.seekable.end(a.seekable.length-1)/this.status.duration:100,g=0<this.status.duration?100*a.currentTime/a.seekable.end(a.seekable.length-1):0):(e=100,g=f);b&&(f=g=c=0);this.status.seekPercent=e;this.status.currentPercentRelative=g;this.status.currentPercentAbsolute=f;this.status.currentTime=c;this.status.remaining=this.status.duration-this.status.currentTime;this.status.videoWidth=a.videoWidth;this.status.videoHeight=
a.videoHeight;this.status.readyState=a.readyState;this.status.networkState=a.networkState;this.status.playbackRate=a.playbackRate;this.status.ended=a.ended},_getAuroraStatus:function(a,b){var c,f,e,g;this.status.duration=a.duration/1E3;c=a.currentTime/1E3;f=0<this.status.duration?100*c/this.status.duration:0;0<a.buffered?(e=0<this.status.duration?a.buffered*this.status.duration/this.status.duration:100,g=0<this.status.duration?c/(a.buffered*this.status.duration):0):(e=100,g=f);b&&(f=g=c=0);this.status.seekPercent=
e;this.status.currentPercentRelative=g;this.status.currentPercentAbsolute=f;this.status.currentTime=c;this.status.remaining=this.status.duration-this.status.currentTime;this.status.readyState=4;this.status.networkState=0;this.status.playbackRate=1;this.status.ended=!1},_resetStatus:function(){this.status=b.extend({},this.status,b.jPlayerAudio.prototype.status)},_trigger:function(a,d,c){a=b.Event(a);a.jPlayerAudio={};a.jPlayerAudio.version=b.extend({},this.version);a.jPlayerAudio.options=b.extend(!0,
{},this.options);a.jPlayerAudio.status=b.extend(!0,{},this.status);a.jPlayerAudio.html=b.extend(!0,{},this.html);a.jPlayerAudio.aurora=b.extend(!0,{},this.aurora);a.jPlayerAudio.flash=b.extend(!0,{},this.flash);d&&(a.jPlayerAudio.error=b.extend({},d));c&&(a.jPlayerAudio.warning=b.extend({},c));this.element.trigger(a)},jPlayerAudioFlashEvent:function(a,d){if(a===b.jPlayerAudio.event.ready)if(!this.internal.ready)this.internal.ready=!0,this.internal.flash.jq.css({width:"0px",height:"0px"}),this.version.flash=
d.version,this.version.needFlash!==this.version.flash&&this._error({type:b.jPlayerAudio.error.VERSION,context:this.version.flash,message:b.jPlayerAudio.errorMsg.VERSION+this.version.flash,hint:b.jPlayerAudio.errorHint.VERSION}),this._trigger(b.jPlayerAudio.event.repeat),this._trigger(a);else if(this.flash.gate){if(this.status.srcSet){var c=this.status.currentTime,f=this.status.paused;this.setMedia(this.status.media);this.volumeWorker(this.options.volume);0<c&&(f?this.pause(c):this.play(c))}this._trigger(b.jPlayerAudio.event.flashreset)}if(this.flash.gate)switch(a){case b.jPlayerAudio.event.progress:this._getFlashStatus(d);
this._updateInterface();this._trigger(a);break;case b.jPlayerAudio.event.timeupdate:this._getFlashStatus(d);this._updateInterface();this._trigger(a);break;case b.jPlayerAudio.event.play:this._seeked();this._updateButtons(!0);this._trigger(a);break;case b.jPlayerAudio.event.pause:this._updateButtons(!1);this._trigger(a);break;case b.jPlayerAudio.event.ended:this._updateButtons(!1);this._trigger(a);break;case b.jPlayerAudio.event.click:this._trigger(a);break;case b.jPlayerAudio.event.error:this.status.waitForLoad=
!0;this.status.waitForPlay=!0;this.status.video&&this.internal.flash.jq.css({width:"0px",height:"0px"});this._validString(this.status.media.poster)&&this.internal.poster.jq.show();this.css.jq.videoPlay.length&&this.status.video&&this.css.jq.videoPlay.show();this.status.video?this._flash_setVideo(this.status.media):this._flash_setAudio(this.status.media);this._updateButtons(!1);this._error({type:b.jPlayerAudio.error.URL,context:d.src,message:b.jPlayerAudio.errorMsg.URL,hint:b.jPlayerAudio.errorHint.URL});
break;case b.jPlayerAudio.event.seeking:this._seeking();this._trigger(a);break;case b.jPlayerAudio.event.seeked:this._seeked();this._trigger(a);break;case b.jPlayerAudio.event.ready:break;default:this._trigger(a)}return!1},_getFlashStatus:function(a){this.status.seekPercent=a.seekPercent;this.status.currentPercentRelative=a.currentPercentRelative;this.status.currentPercentAbsolute=a.currentPercentAbsolute;this.status.currentTime=a.currentTime;this.status.duration=a.duration;this.status.remaining=
a.duration-a.currentTime;this.status.videoWidth=a.videoWidth;this.status.videoHeight=a.videoHeight;this.status.readyState=4;this.status.networkState=0;this.status.playbackRate=1;this.status.ended=!1},_updateButtons:function(a){a===l?a=!this.status.paused:this.status.paused=!a;a?this.addStateClass("playing"):this.removeStateClass("playing");!this.status.noFullWindow&&this.options.fullWindow?this.addStateClass("fullScreen"):this.removeStateClass("fullScreen");this.options.loop?this.addStateClass("looped"):
this.removeStateClass("looped");this.css.jq.play.length&&this.css.jq.pause.length&&(a?(this.css.jq.play.hide(),this.css.jq.pause.show()):(this.css.jq.play.show(),this.css.jq.pause.hide()));this.css.jq.restoreScreen.length&&this.css.jq.fullScreen.length&&(this.status.noFullWindow?(this.css.jq.fullScreen.hide(),this.css.jq.restoreScreen.hide()):this.options.fullWindow?(this.css.jq.fullScreen.hide(),this.css.jq.restoreScreen.show()):(this.css.jq.fullScreen.show(),this.css.jq.restoreScreen.hide()));this.css.jq.repeat.length&&
this.css.jq.repeatOff.length&&(this.options.loop?(this.css.jq.repeat.hide(),this.css.jq.repeatOff.show()):(this.css.jq.repeat.show(),this.css.jq.repeatOff.hide()))},_updateInterface:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.width(this.status.seekPercent+"%");this.css.jq.playBar.length&&(this.options.smoothPlayBar?this.css.jq.playBar.stop().animate({width:this.status.currentPercentAbsolute+"%"},250,"linear"):this.css.jq.playBar.width(this.status.currentPercentRelative+"%"));var a;
this.css.jq.currentTime.length&&(a=this._convertTime(this.status.currentTime),a!==this.css.jq.currentTime.text()&&this.css.jq.currentTime.text(this._convertTime(this.status.currentTime)));a=this.status.duration;var b=this.status.remaining;this.css.jq.duration.length&&("string"===typeof this.status.media.duration?a=this.status.media.duration:("number"===typeof this.status.media.duration&&(a=this.status.media.duration,b=a-this.status.currentTime),a=this.options.remainingDuration?(0<b?"-":"")+this._convertTime(b):
this._convertTime(a)),a!==this.css.jq.duration.text()&&this.css.jq.duration.text(a))},_convertTime:e.prototype.time,_seeking:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.addClass("mdtc-clnplra-seeking-bg");this.addStateClass("seeking")},_seeked:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.removeClass("mdtc-clnplra-seeking-bg");this.removeStateClass("seeking")},_resetGate:function(){this.html.audio.gate=!1;this.html.video.gate=!1;this.aurora.gate=!1;this.flash.gate=!1},
_resetActive:function(){this.html.active=!1;this.aurora.active=!1;this.flash.active=!1},_escapeHtml:function(a){return a.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;").split('"').join("&quot;")},_qualifyURL:function(a){var b=document.createElement("div");b.innerHTML='<a href="'+this._escapeHtml(a)+'">x</a>';return b.firstChild.href},_absoluteMediaUrls:function(a){var d=this;b.each(a,function(b,f){f&&d.format[b]&&"data:"!==f.substr(0,5)&&(a[b]=d._qualifyURL(f))});return a},
addStateClass:function(a){this.ancestorJq.length&&this.ancestorJq.addClass(this.options.stateClass[a])},removeStateClass:function(a){this.ancestorJq.length&&this.ancestorJq.removeClass(this.options.stateClass[a])},setMedia:function(a){var d=this,c=!1,f=this.status.media.poster!==a.poster;this._resetMedia();this._resetGate();this._resetActive();this.androidFix.setMedia=!1;this.androidFix.play=!1;this.androidFix.pause=!1;a=this._absoluteMediaUrls(a);b.each(this.formats,function(f,e){var g="video"===
d.format[e].media;b.each(d.solutions,function(f,m){if(d[m].support[e]&&d._validString(a[e])){var h="html"===m,k="aurora"===m;g?(h?(d.html.video.gate=!0,d._html_setVideo(a),d.html.active=!0):(d.flash.gate=!0,d._flash_setVideo(a),d.flash.active=!0),d.css.jq.videoPlay.length&&d.css.jq.videoPlay.show(),d.status.video=!0):(h?(d.html.audio.gate=!0,d._html_setAudio(a),d.html.active=!0,b.jPlayerAudio.platform.android&&(d.androidFix.setMedia=!0)):k?(d.aurora.gate=!0,d._aurora_setAudio(a),d.aurora.active=!0):
(d.flash.gate=!0,d._flash_setAudio(a),d.flash.active=!0),d.css.jq.videoPlay.length&&d.css.jq.videoPlay.hide(),d.status.video=!1);c=!0;return!1}});if(c)return!1});c?(this.status.nativeVideoControls&&this.html.video.gate||!this._validString(a.poster)||(f?this.htmlElement.poster.src=a.poster:this.internal.poster.jq.show()),"string"===typeof a.title&&(this.css.jq.title.length&&this.css.jq.title.html(a.title),this.htmlElement.audio&&this.htmlElement.audio.setAttribute("title",a.title),this.htmlElement.video&&
this.htmlElement.video.setAttribute("title",a.title)),this.status.srcSet=!0,this.status.media=b.extend({},a),this._updateButtons(!1),this._updateInterface(),this._trigger(b.jPlayerAudio.event.setmedia)):this._error({type:b.jPlayerAudio.error.NO_SUPPORT,context:"{supplied:'"+this.options.supplied+"'}",message:b.jPlayerAudio.errorMsg.NO_SUPPORT,hint:b.jPlayerAudio.errorHint.NO_SUPPORT})},_resetMedia:function(){this._resetStatus();this._updateButtons(!1);this._updateInterface();this._seeked();this.internal.poster.jq.hide();
clearTimeout(this.internal.htmlDlyCmdId);this.html.active?this._html_resetMedia():this.aurora.active?this._aurora_resetMedia():this.flash.active&&this._flash_resetMedia()},clearMedia:function(){this._resetMedia();this.html.active?this._html_clearMedia():this.aurora.active?this._aurora_clearMedia():this.flash.active&&this._flash_clearMedia();this._resetGate();this._resetActive()},load:function(){this.status.srcSet?this.html.active?this._html_load():this.aurora.active?this._aurora_load():this.flash.active&&
this._flash_load():this._urlNotSetError("load")},focus:function(){this.options.keyEnabled&&(b.jPlayerAudio.focus=this)},play:function(a){"object"===typeof a&&this.options.useStateClassSkin&&!this.status.paused?this.pause(a):(a="number"===typeof a?a:NaN,this.status.srcSet?(this.focus(),this.html.active?this._html_play(a):this.aurora.active?this._aurora_play(a):this.flash.active&&this._flash_play(a)):this._urlNotSetError("play"))},videoPlay:function(){this.play()},pause:function(a){a="number"===typeof a?
a:NaN;this.status.srcSet?this.html.active?this._html_pause(a):this.aurora.active?this._aurora_pause(a):this.flash.active&&this._flash_pause(a):this._urlNotSetError("pause")},tellOthers:function(a,d){var c=this,f="function"===typeof d,e=Array.prototype.slice.call(arguments);"string"===typeof a&&(f&&e.splice(1,1),b.jPlayerAudio.prototype.destroyRemoved(),b.each(this.instances,function(){c.element!==this&&(f&&!d.call(this.data("jPlayerAudio"),c)||this.jPlayerAudio.apply(this,e))}))},pauseOthers:function(a){this.tellOthers("pause",
function(){return this.status.srcSet},a)},stop:function(){this.status.srcSet?this.html.active?this._html_pause(0):this.aurora.active?this._aurora_pause(0):this.flash.active&&this._flash_pause(0):this._urlNotSetError("stop")},playHead:function(a){a=this._limitValue(a,0,100);this.status.srcSet?this.html.active?this._html_playHead(a):this.aurora.active?this._aurora_playHead(a):this.flash.active&&this._flash_playHead(a):this._urlNotSetError("playHead")},_muted:function(a){this.mutedWorker(a);this.options.globalVolume&&
this.tellOthers("mutedWorker",function(){return this.options.globalVolume},a)},mutedWorker:function(a){this.options.muted=a;this.html.used&&this._html_setProperty("muted",a);this.aurora.used&&this._aurora_mute(a);this.flash.used&&this._flash_mute(a);this.html.video.gate||this.html.audio.gate||(this._updateMute(a),this._updateVolume(this.options.volume),this._trigger(b.jPlayerAudio.event.volumechange))},mute:function(a){"object"===typeof a&&this.options.useStateClassSkin&&this.options.muted?this._muted(!1):
(a=a===l?!0:!!a,this._muted(a))},unmute:function(a){a=a===l?!0:!!a;this._muted(!a)},_updateMute:function(a){a===l&&(a=this.options.muted);a?this.addStateClass("muted"):this.removeStateClass("muted");this.css.jq.mute.length&&this.css.jq.unmute.length&&(this.status.noVolume?(this.css.jq.mute.hide(),this.css.jq.unmute.hide()):a?(this.css.jq.mute.hide(),this.css.jq.unmute.show()):(this.css.jq.mute.show(),this.css.jq.unmute.hide()))},volume:function(a){this.volumeWorker(a);this.options.globalVolume&&this.tellOthers("volumeWorker",
function(){return this.options.globalVolume},a)},volumeWorker:function(a){a=this._limitValue(a,0,1);this.options.volume=a;this.html.used&&this._html_setProperty("volume",a);this.aurora.used&&this._aurora_volume(a);this.flash.used&&this._flash_volume(a);this.html.video.gate||this.html.audio.gate||(this._updateVolume(a),this._trigger(b.jPlayerAudio.event.volumechange))},volumeBar:function(a){if(this.css.jq.volumeBar.length){var d=b(a.currentTarget),c=d.offset(),f=a.pageX-c.left,e=d.width();a=d.height()-
a.pageY+c.top;d=d.height();this.options.verticalVolume?this.volume(a/d):this.volume(f/e)}this.options.muted&&this._muted(!1)},_updateVolume:function(a){a===l&&(a=this.options.volume);a=this.options.muted?0:a;this.status.noVolume?(this.addStateClass("noVolume"),this.css.jq.volumeBar.length&&this.css.jq.volumeBar.hide(),this.css.jq.volumeBarValue.length&&this.css.jq.volumeBarValue.hide(),this.css.jq.volumeMax.length&&this.css.jq.volumeMax.hide()):(this.removeStateClass("noVolume"),this.css.jq.volumeBar.length&&
this.css.jq.volumeBar.show(),this.css.jq.volumeBarValue.length&&(this.css.jq.volumeBarValue.show(),this.css.jq.volumeBarValue[this.options.verticalVolume?"height":"width"](100*a+"%")),this.css.jq.volumeMax.length&&this.css.jq.volumeMax.show())},volumeMax:function(){this.volume(1);this.options.muted&&this._muted(!1)},_cssSelectorAncestor:function(a){var d=this;this.options.cssSelectorAncestor=a;this._removeUiClass();this.ancestorJq=a?b(a):[];a&&1!==this.ancestorJq.length&&this._warning({type:b.jPlayerAudio.warning.CSS_SELECTOR_COUNT,
context:a,message:b.jPlayerAudio.warningMsg.CSS_SELECTOR_COUNT+this.ancestorJq.length+" found for cssSelectorAncestor.",hint:b.jPlayerAudio.warningHint.CSS_SELECTOR_COUNT});this._addUiClass();b.each(this.options.cssSelector,function(a,b){d._cssSelector(a,b)});this._updateInterface();this._updateButtons();this._updateAutohide();this._updateVolume();this._updateMute()},_cssSelector:function(a,d){var c=this;"string"===typeof d?b.jPlayerAudio.prototype.options.cssSelector[a]?(this.css.jq[a]&&this.css.jq[a].length&&
this.css.jq[a].unbind(".jPlayerAudio"),this.options.cssSelector[a]=d,this.css.cs[a]=this.options.cssSelectorAncestor+" "+d,this.css.jq[a]=d?b(this.css.cs[a]):[],this.css.jq[a].length&&this[a]&&this.css.jq[a].bind("click.jPlayerAudio",function(d){d.preventDefault();c[a](d);c.options.autoBlur?b(this).blur():b(this).focus()}),d&&1!==this.css.jq[a].length&&this._warning({type:b.jPlayerAudio.warning.CSS_SELECTOR_COUNT,context:this.css.cs[a],message:b.jPlayerAudio.warningMsg.CSS_SELECTOR_COUNT+this.css.jq[a].length+
" found for "+a+" method.",hint:b.jPlayerAudio.warningHint.CSS_SELECTOR_COUNT})):this._warning({type:b.jPlayerAudio.warning.CSS_SELECTOR_METHOD,context:a,message:b.jPlayerAudio.warningMsg.CSS_SELECTOR_METHOD,hint:b.jPlayerAudio.warningHint.CSS_SELECTOR_METHOD}):this._warning({type:b.jPlayerAudio.warning.CSS_SELECTOR_STRING,context:d,message:b.jPlayerAudio.warningMsg.CSS_SELECTOR_STRING,hint:b.jPlayerAudio.warningHint.CSS_SELECTOR_STRING})},duration:function(a){this.options.toggleDuration&&(this.options.captureDuration&&
a.stopPropagation(),this._setOption("remainingDuration",!this.options.remainingDuration))},seekBar:function(a){if(this.css.jq.seekBar.length){var d=b(a.currentTarget),c=d.offset();a=a.pageX-c.left;d=d.width();this.playHead(100*a/d)}},playbackRate:function(a){this._setOption("playbackRate",a)},playbackRateBar:function(a){if(this.css.jq.playbackRateBar.length){var d=b(a.currentTarget),c=d.offset(),f=a.pageX-c.left,e=d.width();a=d.height()-a.pageY+c.top;d=d.height();this.playbackRate((this.options.verticalPlaybackRate?
a/d:f/e)*(this.options.maxPlaybackRate-this.options.minPlaybackRate)+this.options.minPlaybackRate)}},_updatePlaybackRate:function(){var a=(this.options.playbackRate-this.options.minPlaybackRate)/(this.options.maxPlaybackRate-this.options.minPlaybackRate);this.status.playbackRateEnabled?(this.css.jq.playbackRateBar.length&&this.css.jq.playbackRateBar.show(),this.css.jq.playbackRateBarValue.length&&(this.css.jq.playbackRateBarValue.show(),this.css.jq.playbackRateBarValue[this.options.verticalPlaybackRate?
"height":"width"](100*a+"%"))):(this.css.jq.playbackRateBar.length&&this.css.jq.playbackRateBar.hide(),this.css.jq.playbackRateBarValue.length&&this.css.jq.playbackRateBarValue.hide())},repeat:function(a){"object"===typeof a&&this.options.useStateClassSkin&&this.options.loop?this._loop(!1):this._loop(!0)},repeatOff:function(){this._loop(!1)},_loop:function(a){this.options.loop!==a&&(this.options.loop=a,this._updateButtons(),this._trigger(b.jPlayerAudio.event.repeat))},option:function(a,d){var c=a;
if(0===arguments.length)return b.extend(!0,{},this.options);if("string"===typeof a){var f=a.split(".");if(d===l){for(var c=b.extend(!0,{},this.options),e=0;e<f.length;e++)if(c[f[e]]!==l)c=c[f[e]];else return this._warning({type:b.jPlayerAudio.warning.OPTION_KEY,context:a,message:b.jPlayerAudio.warningMsg.OPTION_KEY,hint:b.jPlayerAudio.warningHint.OPTION_KEY}),l;return c}for(var e=c={},g=0;g<f.length;g++)g<f.length-1?(e[f[g]]={},e=e[f[g]]):e[f[g]]=d}this._setOptions(c);return this},_setOptions:function(a){var d=
this;b.each(a,function(a,b){d._setOption(a,b)});return this},_setOption:function(a,d){var c=this;switch(a){case "volume":this.volume(d);break;case "muted":this._muted(d);break;case "globalVolume":this.options[a]=d;break;case "cssSelectorAncestor":this._cssSelectorAncestor(d);break;case "cssSelector":b.each(d,function(a,b){c._cssSelector(a,b)});break;case "playbackRate":this.options[a]=d=this._limitValue(d,this.options.minPlaybackRate,this.options.maxPlaybackRate);this.html.used&&this._html_setProperty("playbackRate",
d);this._updatePlaybackRate();break;case "defaultPlaybackRate":this.options[a]=d=this._limitValue(d,this.options.minPlaybackRate,this.options.maxPlaybackRate);this.html.used&&this._html_setProperty("defaultPlaybackRate",d);this._updatePlaybackRate();break;case "minPlaybackRate":this.options[a]=d=this._limitValue(d,.1,this.options.maxPlaybackRate-.1);this._updatePlaybackRate();break;case "maxPlaybackRate":this.options[a]=d=this._limitValue(d,this.options.minPlaybackRate+.1,16);this._updatePlaybackRate();
break;case "fullScreen":if(this.options[a]!==d){var f=b.jPlayerAudio.nativeFeatures.fullscreen.used.webkitVideo;if(!f||f&&!this.status.waitForPlay)f||(this.options[a]=d),d?this._requestFullscreen():this._exitFullscreen(),f||this._setOption("fullWindow",d)}break;case "fullWindow":this.options[a]!==d&&(this._removeUiClass(),this.options[a]=d,this._refreshSize());break;case "size":this.options.fullWindow||this.options[a].cssClass===d.cssClass||this._removeUiClass();this.options[a]=b.extend({},this.options[a],
d);this._refreshSize();break;case "sizeFull":this.options.fullWindow&&this.options[a].cssClass!==d.cssClass&&this._removeUiClass();this.options[a]=b.extend({},this.options[a],d);this._refreshSize();break;case "autohide":this.options[a]=b.extend({},this.options[a],d);this._updateAutohide();break;case "loop":this._loop(d);break;case "remainingDuration":this.options[a]=d;this._updateInterface();break;case "toggleDuration":this.options[a]=d;break;case "nativeVideoControls":this.options[a]=b.extend({},
this.options[a],d);this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this._restrictNativeVideoControls();this._updateNativeVideoControls();break;case "noFullWindow":this.options[a]=b.extend({},this.options[a],d);this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this.status.noFullWindow=this._uaBlocklist(this.options.noFullWindow);this._restrictNativeVideoControls();this._updateButtons();break;case "noVolume":this.options[a]=b.extend({},
this.options[a],d);this.status.noVolume=this._uaBlocklist(this.options.noVolume);this._updateVolume();this._updateMute();break;case "emulateHtml":this.options[a]!==d&&((this.options[a]=d)?this._emulateHtmlBridge():this._destroyHtmlBridge());break;case "timeFormat":this.options[a]=b.extend({},this.options[a],d);break;case "keyEnabled":this.options[a]=d;d||this!==b.jPlayerAudio.focus||(b.jPlayerAudio.focus=null);break;case "keyBindings":this.options[a]=b.extend(!0,{},this.options[a],d);break;case "audioFullScreen":this.options[a]=
d;break;case "autoBlur":this.options[a]=d}return this},_refreshSize:function(){this._setSize();this._addUiClass();this._updateSize();this._updateButtons();this._updateAutohide();this._trigger(b.jPlayerAudio.event.resize)},_setSize:function(){this.options.fullWindow?(this.status.width=this.options.sizeFull.width,this.status.height=this.options.sizeFull.height,this.status.cssClass=this.options.sizeFull.cssClass):(this.status.width=this.options.size.width,this.status.height=this.options.size.height,
this.status.cssClass=this.options.size.cssClass);this.element.css({width:this.status.width,height:this.status.height})},_addUiClass:function(){this.ancestorJq.length&&this.ancestorJq.addClass(this.status.cssClass)},_removeUiClass:function(){this.ancestorJq.length&&this.ancestorJq.removeClass(this.status.cssClass)},_updateSize:function(){this.internal.poster.jq.css({width:this.status.width,height:this.status.height});!this.status.waitForPlay&&this.html.active&&this.status.video||this.html.video.available&&
this.html.used&&this.status.nativeVideoControls?this.internal.video.jq.css({width:this.status.width,height:this.status.height}):!this.status.waitForPlay&&this.flash.active&&this.status.video&&this.internal.flash.jq.css({width:this.status.width,height:this.status.height})},_updateAutohide:function(){var a=this,b=function(b){var d=!1,e;"undefined"!==typeof a.internal.mouse?(d=a.internal.mouse.x-b.pageX,e=a.internal.mouse.y-b.pageY,d=0<Math.floor(d)||0<Math.floor(e)):d=!0;a.internal.mouse={x:b.pageX,
y:b.pageY};d&&a.css.jq.gui.fadeIn(a.options.autohide.fadeIn,function(){clearTimeout(a.internal.autohideId);a.internal.autohideId=setTimeout(function(){a.css.jq.gui.fadeOut(a.options.autohide.fadeOut)},a.options.autohide.hold)})};this.css.jq.gui.length&&(this.css.jq.gui.stop(!0,!0),clearTimeout(this.internal.autohideId),delete this.internal.mouse,this.element.unbind(".jPlayerAudioAutohide"),this.css.jq.gui.unbind(".jPlayerAudioAutohide"),this.status.nativeVideoControls?this.css.jq.gui.hide():this.options.fullWindow&&
this.options.autohide.full||!this.options.fullWindow&&this.options.autohide.restored?(this.element.bind("mousemove.jPlayerAudio.jPlayerAudioAutohide",b),this.css.jq.gui.bind("mousemove.jPlayerAudio.jPlayerAudioAutohide",b),this.css.jq.gui.hide()):this.css.jq.gui.show())},fullScreen:function(a){"object"===typeof a&&this.options.useStateClassSkin&&this.options.fullScreen?this._setOption("fullScreen",!1):this._setOption("fullScreen",!0)},restoreScreen:function(){this._setOption("fullScreen",!1)},_fullscreenAddEventListeners:function(){var a=
this,d=b.jPlayerAudio.nativeFeatures.fullscreen;d.api.fullscreenEnabled&&d.event.fullscreenchange&&("function"!==typeof this.internal.fullscreenchangeHandler&&(this.internal.fullscreenchangeHandler=function(){a._fullscreenchange()}),document.addEventListener(d.event.fullscreenchange,this.internal.fullscreenchangeHandler,!1))},_fullscreenRemoveEventListeners:function(){var a=b.jPlayerAudio.nativeFeatures.fullscreen;this.internal.fullscreenchangeHandler&&document.removeEventListener(a.event.fullscreenchange,
this.internal.fullscreenchangeHandler,!1)},_fullscreenchange:function(){this.options.fullScreen&&!b.jPlayerAudio.nativeFeatures.fullscreen.api.fullscreenElement()&&this._setOption("fullScreen",!1)},_requestFullscreen:function(){var a=this.ancestorJq.length?this.ancestorJq[0]:this.element[0],d=b.jPlayerAudio.nativeFeatures.fullscreen;d.used.webkitVideo&&(a=this.htmlElement.video);d.api.fullscreenEnabled&&d.api.requestFullscreen(a)},_exitFullscreen:function(){var a=b.jPlayerAudio.nativeFeatures.fullscreen,
d;a.used.webkitVideo&&(d=this.htmlElement.video);a.api.fullscreenEnabled&&a.api.exitFullscreen(d)},_html_initMedia:function(a){var d=b(this.htmlElement.media).empty();b.each(a.track||[],function(a,b){var e=document.createElement("track");e.setAttribute("kind",b.kind?b.kind:"");e.setAttribute("src",b.src?b.src:"");e.setAttribute("srclang",b.srclang?b.srclang:"");e.setAttribute("label",b.label?b.label:"");b.def&&e.setAttribute("default",b.def);d.append(e)});this.htmlElement.media.src=this.status.src;
"none"!==this.options.preload&&this._html_load();this._trigger(b.jPlayerAudio.event.timeupdate)},_html_setFormat:function(a){var d=this;b.each(this.formats,function(b,f){if(d.html.support[f]&&a[f])return d.status.src=a[f],d.status.format[f]=!0,d.status.formatType=f,!1})},_html_setAudio:function(a){this._html_setFormat(a);this.htmlElement.media=this.htmlElement.audio;this._html_initMedia(a)},_html_setVideo:function(a){this._html_setFormat(a);this.status.nativeVideoControls&&(this.htmlElement.video.poster=
this._validString(a.poster)?a.poster:"");this.htmlElement.media=this.htmlElement.video;this._html_initMedia(a)},_html_resetMedia:function(){this.htmlElement.media&&(this.htmlElement.media.id!==this.internal.video.id||this.status.nativeVideoControls||this.internal.video.jq.css({width:"0px",height:"0px"}),this.htmlElement.media.pause())},_html_clearMedia:function(){this.htmlElement.media&&(this.htmlElement.media.src="about:blank",this.htmlElement.media.load())},_html_load:function(){this.status.waitForLoad&&
(this.status.waitForLoad=!1,this.htmlElement.media.load());clearTimeout(this.internal.htmlDlyCmdId)},_html_play:function(a){var b=this,c=this.htmlElement.media;this.androidFix.pause=!1;this._html_load();if(this.androidFix.setMedia)this.androidFix.play=!0,this.androidFix.time=a;else if(isNaN(a))c.play();else{this.internal.cmdsIgnored&&c.play();try{if(!c.seekable||"object"===typeof c.seekable&&0<c.seekable.length)c.currentTime=a,c.play();else throw 1;}catch(f){this.internal.htmlDlyCmdId=setTimeout(function(){b.play(a)},
250);return}}this._html_checkWaitForPlay()},_html_pause:function(a){var b=this,c=this.htmlElement.media;this.androidFix.play=!1;0<a?this._html_load():clearTimeout(this.internal.htmlDlyCmdId);c.pause();if(this.androidFix.setMedia)this.androidFix.pause=!0,this.androidFix.time=a;else if(!isNaN(a))try{if(!c.seekable||"object"===typeof c.seekable&&0<c.seekable.length)c.currentTime=a;else throw 1;}catch(f){this.internal.htmlDlyCmdId=setTimeout(function(){b.pause(a)},250);return}0<a&&this._html_checkWaitForPlay()},
_html_playHead:function(a){var b=this,c=this.htmlElement.media;this._html_load();try{if("object"===typeof c.seekable&&0<c.seekable.length)c.currentTime=a*c.seekable.end(c.seekable.length-1)/100;else if(0<c.duration&&!isNaN(c.duration))c.currentTime=a*c.duration/100;else throw"e";}catch(f){this.internal.htmlDlyCmdId=setTimeout(function(){b.playHead(a)},250);return}this.status.waitForLoad||this._html_checkWaitForPlay()},_html_checkWaitForPlay:function(){this.status.waitForPlay&&(this.status.waitForPlay=
!1,this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide(),this.status.video&&(this.internal.poster.jq.hide(),this.internal.video.jq.css({width:this.status.width,height:this.status.height})))},_html_setProperty:function(a,b){this.html.audio.available&&(this.htmlElement.audio[a]=b);this.html.video.available&&(this.htmlElement.video[a]=b)},_aurora_setAudio:function(a){var d=this;b.each(this.formats,function(b,f){if(d.aurora.support[f]&&a[f])return d.status.src=a[f],d.status.format[f]=!0,d.status.formatType=
f,!1});this.aurora.player=new AV.Player.fromURL(this.status.src);this._addAuroraEventListeners(this.aurora.player,this.aurora);"auto"===this.options.preload&&(this._aurora_load(),this.status.waitForLoad=!1)},_aurora_resetMedia:function(){this.aurora.player&&this.aurora.player.stop()},_aurora_clearMedia:function(){},_aurora_load:function(){this.status.waitForLoad&&(this.status.waitForLoad=!1,this.aurora.player.preload())},_aurora_play:function(a){this.status.waitForLoad||isNaN(a)||this.aurora.player.seek(a);
this.aurora.player.playing||this.aurora.player.play();this.status.waitForLoad=!1;this._aurora_checkWaitForPlay();this._updateButtons(!0);this._trigger(b.jPlayerAudio.event.play)},_aurora_pause:function(a){isNaN(a)||this.aurora.player.seek(1E3*a);this.aurora.player.pause();0<a&&this._aurora_checkWaitForPlay();this._updateButtons(!1);this._trigger(b.jPlayerAudio.event.pause)},_aurora_playHead:function(a){0<this.aurora.player.duration&&this.aurora.player.seek(a*this.aurora.player.duration/100);this.status.waitForLoad||
this._aurora_checkWaitForPlay()},_aurora_checkWaitForPlay:function(){this.status.waitForPlay&&(this.status.waitForPlay=!1)},_aurora_volume:function(a){this.aurora.player.volume=100*a},_aurora_mute:function(a){a?(this.aurora.properties.lastvolume=this.aurora.player.volume,this.aurora.player.volume=0):this.aurora.player.volume=this.aurora.properties.lastvolume;this.aurora.properties.muted=a},_flash_setAudio:function(a){var d=this;try{b.each(this.formats,function(b,f){if(d.flash.support[f]&&a[f]){switch(f){case "m4a":case "fla":d._getMovie().fl_setAudio_m4a(a[f]);
break;case "mp3":d._getMovie().fl_setAudio_mp3(a[f]);break;case "rtmpa":d._getMovie().fl_setAudio_rtmp(a[f])}d.status.src=a[f];d.status.format[f]=!0;d.status.formatType=f;return!1}}),"auto"===this.options.preload&&(this._flash_load(),this.status.waitForLoad=!1)}catch(c){this._flashError(c)}},_flash_setVideo:function(a){var d=this;try{b.each(this.formats,function(b,f){if(d.flash.support[f]&&a[f]){switch(f){case "m4v":case "flv":d._getMovie().fl_setVideo_m4v(a[f]);break;case "rtmpv":d._getMovie().fl_setVideo_rtmp(a[f])}d.status.src=
a[f];d.status.format[f]=!0;d.status.formatType=f;return!1}}),"auto"===this.options.preload&&(this._flash_load(),this.status.waitForLoad=!1)}catch(c){this._flashError(c)}},_flash_resetMedia:function(){this.internal.flash.jq.css({width:"0px",height:"0px"});this._flash_pause(NaN)},_flash_clearMedia:function(){try{this._getMovie().fl_clearMedia()}catch(a){this._flashError(a)}},_flash_load:function(){try{this._getMovie().fl_load()}catch(a){this._flashError(a)}this.status.waitForLoad=!1},_flash_play:function(a){try{this._getMovie().fl_play(a)}catch(b){this._flashError(b)}this.status.waitForLoad=
!1;this._flash_checkWaitForPlay()},_flash_pause:function(a){try{this._getMovie().fl_pause(a)}catch(b){this._flashError(b)}0<a&&(this.status.waitForLoad=!1,this._flash_checkWaitForPlay())},_flash_playHead:function(a){try{this._getMovie().fl_play_head(a)}catch(b){this._flashError(b)}this.status.waitForLoad||this._flash_checkWaitForPlay()},_flash_checkWaitForPlay:function(){this.status.waitForPlay&&(this.status.waitForPlay=!1,this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide(),this.status.video&&
(this.internal.poster.jq.hide(),this.internal.flash.jq.css({width:this.status.width,height:this.status.height})))},_flash_volume:function(a){try{this._getMovie().fl_volume(a)}catch(b){this._flashError(b)}},_flash_mute:function(a){try{this._getMovie().fl_mute(a)}catch(b){this._flashError(b)}},_getMovie:function(){return document[this.internal.flash.id]},_getFlashPluginVersion:function(){var a=0,b;if(window.ActiveXObject)try{b=new ActiveXObject("ShockwaveFlash.ShockwaveFlash");var c=b.GetVariable("$version");
c&&(c=c.split(" ")[1].split(","),a=parseInt(c[0],10)+"."+parseInt(c[1],10))}catch(f){}else navigator.plugins&&0<navigator.mimeTypes.length&&(b=navigator.plugins["Shockwave Flash"])&&(a=navigator.plugins["Shockwave Flash"].description.replace(/.*\s(\d+\.\d+).*/,"$1"));return 1*a},_checkForFlash:function(a){var b=!1;this._getFlashPluginVersion()>=a&&(b=!0);return b},_validString:function(a){return a&&"string"===typeof a},_limitValue:function(a,b,c){return a<b?b:a>c?c:a},_urlNotSetError:function(a){this._error({type:b.jPlayerAudio.error.URL_NOT_SET,
context:a,message:b.jPlayerAudio.errorMsg.URL_NOT_SET,hint:b.jPlayerAudio.errorHint.URL_NOT_SET})},_flashError:function(a){var d;d=this.internal.ready?"FLASH_DISABLED":"FLASH";this._error({type:b.jPlayerAudio.error[d],context:this.internal.flash.swf,message:b.jPlayerAudio.errorMsg[d]+a.message,hint:b.jPlayerAudio.errorHint[d]});this.internal.flash.jq.css({width:"1px",height:"1px"})},_error:function(a){this._trigger(b.jPlayerAudio.event.error,a);this.options.errorAlerts&&this._alert("Error!"+(a.message?
"\n"+a.message:"")+(a.hint?"\n"+a.hint:"")+"\nContext: "+a.context)},_warning:function(a){this._trigger(b.jPlayerAudio.event.warning,l,a);this.options.warningAlerts&&this._alert("Warning!"+(a.message?"\n"+a.message:"")+(a.hint?"\n"+a.hint:"")+"\nContext: "+a.context)},_alert:function(a){a="jPlayerAudio "+this.version.script+" : id='"+this.internal.self.id+"' : "+a;this.options.consoleAlerts?window.console&&window.console.log&&window.console.log(a):alert(a)},_emulateHtmlBridge:function(){var a=this;
b.each(b.jPlayerAudio.emulateMethods.split(/\s+/g),function(b,c){a.internal.domNode[c]=function(b){a[c](b)}});b.each(b.jPlayerAudio.event,function(d,c){var f=!0;b.each(b.jPlayerAudio.reservedEvent.split(/\s+/g),function(a,b){if(b===d)return f=!1});f&&a.element.bind(c+".jPlayerAudio.jPlayerAudioHtml",function(){a._emulateHtmlUpdate();var b=document.createEvent("Event");b.initEvent(d,!1,!0);a.internal.domNode.dispatchEvent(b)})})},_emulateHtmlUpdate:function(){var a=this;b.each(b.jPlayerAudio.emulateStatus.split(/\s+/g),
function(b,c){a.internal.domNode[c]=a.status[c]});b.each(b.jPlayerAudio.emulateOptions.split(/\s+/g),function(b,c){a.internal.domNode[c]=a.options[c]})},_destroyHtmlBridge:function(){var a=this;this.element.unbind(".jPlayerAudioHtml");b.each((b.jPlayerAudio.emulateMethods+" "+b.jPlayerAudio.emulateStatus+" "+b.jPlayerAudio.emulateOptions).split(/\s+/g),function(b,c){delete a.internal.domNode[c]})}};b.jPlayerAudio.error={FLASH:"e_flash",FLASH_DISABLED:"e_flash_disabled",NO_SOLUTION:"e_no_solution",
NO_SUPPORT:"e_no_support",URL:"e_url",URL_NOT_SET:"e_url_not_set",VERSION:"e_version"};b.jPlayerAudio.errorMsg={FLASH:"jPlayerAudio's Flash fallback is not configured correctly, or a command was issued before the jPlayerAudio Ready event. Details: ",FLASH_DISABLED:"jPlayerAudio's Flash fallback has been disabled by the browser due to the CSS rules you have used. Details: ",NO_SOLUTION:"No solution can be found by jPlayerAudio in this browser. Neither HTML nor Flash can be used.",NO_SUPPORT:"It is not possible to play any media format provided in setMedia() on this browser using your current options.",
URL:"Media URL could not be loaded.",URL_NOT_SET:"Attempt to issue media playback commands, while no media url is set.",VERSION:"jPlayerAudio "+b.jPlayerAudio.prototype.version.script+" needs Jplayer.swf version "+b.jPlayerAudio.prototype.version.needFlash+" but found "};b.jPlayerAudio.errorHint={FLASH:"Check your swfPath option and that Jplayer.swf is there.",FLASH_DISABLED:"Check that you have not display:none; the jPlayerAudio entity or any ancestor.",NO_SOLUTION:"Review the jPlayerAudio options: support and supplied.",
NO_SUPPORT:"Video or audio formats defined in the supplied option are missing.",URL:"Check media URL is valid.",URL_NOT_SET:"Use setMedia() to set the media URL.",VERSION:"Update jPlayerAudio files."};b.jPlayerAudio.warning={CSS_SELECTOR_COUNT:"e_css_selector_count",CSS_SELECTOR_METHOD:"e_css_selector_method",CSS_SELECTOR_STRING:"e_css_selector_string",OPTION_KEY:"e_option_key"};b.jPlayerAudio.warningMsg={CSS_SELECTOR_COUNT:"The number of css selectors found did not equal one: ",CSS_SELECTOR_METHOD:"The methodName given in jPlayerAudio('cssSelector') is not a valid jPlayerAudio method.",
CSS_SELECTOR_STRING:"The methodCssSelector given in jPlayerAudio('cssSelector') is not a String or is empty.",OPTION_KEY:"The option requested in jPlayerAudio('option') is undefined."};b.jPlayerAudio.warningHint={CSS_SELECTOR_COUNT:"Check your css selector and the ancestor.",CSS_SELECTOR_METHOD:"Check your method name.",CSS_SELECTOR_STRING:"Check your css selector is a string.",OPTION_KEY:"Check your option name."}});
(function(b,l){jPlayerAudioPlaylist=function(e,h,k){var g=this;this.current=0;this.removing=this.shuffled=this.loop=!1;this.cssSelector=b.extend({},this._cssSelector,e);this.options=b.extend(!0,{keyBindings:{next:{key:221,fn:function(){g.next()}},previous:{key:219,fn:function(){g.previous()}},shuffle:{key:83,fn:function(){g.shuffle()}}},stateClass:{shuffled:"mdtc-clnplra-state-shuffled"}},this._options,k);this.playlist=[];this.original=[];this._initPlaylist(h);this.cssSelector.details=this.cssSelector.cssSelectorAncestor+
" .mdtc-clnplra-details";this.cssSelector.playlist=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplra-playlist";this.cssSelector.next=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplra-next";this.cssSelector.previous=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplra-previous";this.cssSelector.shuffle=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplra-shuffle";this.cssSelector.shuffleOff=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplra-shuffle-off";this.options.cssSelectorAncestor=this.cssSelector.cssSelectorAncestor;
this.options.repeat=function(a){g.loop=a.jPlayerAudio.options.loop};b(this.cssSelector.jPlayerAudio).bind(b.jPlayerAudio.event.ready,function(){g._init()});b(this.cssSelector.jPlayerAudio).bind(b.jPlayerAudio.event.ended,function(){g.next()});b(this.cssSelector.jPlayerAudio).bind(b.jPlayerAudio.event.play,function(){b(this).jPlayerAudio("pauseOthers")});b(this.cssSelector.jPlayerAudio).bind(b.jPlayerAudio.event.resize,function(a){a.jPlayerAudio.options.fullScreen?b(g.cssSelector.details).show():b(g.cssSelector.details).hide()});
b(this.cssSelector.previous).click(function(a){a.preventDefault();g.previous();g.blur(this)});b(this.cssSelector.next).click(function(a){a.preventDefault();g.next();g.blur(this)});b(this.cssSelector.shuffle).click(function(a){a.preventDefault();g.shuffled&&b(g.cssSelector.jPlayerAudio).jPlayerAudio("option","useStateClassSkin")?g.shuffle(!1):g.shuffle(!0);g.blur(this)});b(this.cssSelector.shuffleOff).click(function(a){a.preventDefault();g.shuffle(!1);g.blur(this)}).hide();this.options.fullScreen||
b(this.cssSelector.details).hide();b(this.cssSelector.playlist+" ul").empty();this._createItemHandlers();b(this.cssSelector.jPlayerAudio).jPlayerAudio(this.options)};jPlayerAudioPlaylist.prototype={_cssSelector:{jPlayerAudio:"#jquery_jplayer_1",cssSelectorAncestor:"#jp_audio_container_1"},_options:{playlistOptions:{autoPlay:!1,loopOnPrevious:!1,shuffleOnLoop:!0,enableRemoveControls:!1,displayTime:"slow",addTime:"fast",removeTime:"fast",shuffleTime:"slow",itemClass:"mdtc-clnplra-playlist-item",freeGroupClass:"mdtc-clnplra-free-media",
freeItemClass:"mdtc-clnplra-playlist-item-free",removeItemClass:"mdtc-clnplra-playlist-item-remove"}},option:function(b,h){if(h===l)return this.options.playlistOptions[b];this.options.playlistOptions[b]=h;switch(b){case "enableRemoveControls":this._updateControls();break;case "itemClass":case "freeGroupClass":case "freeItemClass":case "removeItemClass":this._refresh(!0),this._createItemHandlers()}return this},_init:function(){var b=this;this._refresh(function(){b.options.playlistOptions.autoPlay?
b.play(b.current):b.select(b.current)})},_initPlaylist:function(e){this.current=0;this.removing=this.shuffled=!1;this.original=b.extend(!0,[],e);this._originalPlaylist()},_originalPlaylist:function(){var e=this;this.playlist=[];b.each(this.original,function(b){e.playlist[b]=e.original[b]})},_refresh:function(e){var h=this;if(e&&!b.isFunction(e))b(this.cssSelector.playlist+" ul").empty(),b.each(this.playlist,function(e){b(h.cssSelector.playlist+" ul").append(h._createListItem(h.playlist[e]))}),this._updateControls();
else{var k=b(this.cssSelector.playlist+" ul").children().length?this.options.playlistOptions.displayTime:0;b(this.cssSelector.playlist+" ul").slideUp(k,function(){var g=b(this);b(this).empty();b.each(h.playlist,function(a){g.append(h._createListItem(h.playlist[a]))});h._updateControls();b.isFunction(e)&&e();h.playlist.length?b(this).slideDown(h.options.playlistOptions.displayTime):b(this).show()})}},_createListItem:function(e){var h=this,k="<li><div>",k=k+("<a href='javascript:;' class='"+this.options.playlistOptions.removeItemClass+
"'>&times;</a>");if(e.free){var g=!0,k=k+("<span class='"+this.options.playlistOptions.freeGroupClass+"'>(");b.each(e,function(a,d){b.jPlayerAudio.prototype.format[a]&&(g?g=!1:k+=" | ",k+="<a class='"+h.options.playlistOptions.freeItemClass+"' href='"+d+"' tabindex='-1'>"+a+"</a>")});k+=")</span>"}k+="<span href='javascript:;' class='"+this.options.playlistOptions.itemClass+"' tabindex='0'>"+e.title+(e.artist?" <span class='mdtc-clnplra-artist'>by "+e.artist+"</span>":"")+"</span>";return k+="</div></li>"},
_createItemHandlers:function(){var e=this;b(this.cssSelector.playlist).off("click","span."+this.options.playlistOptions.itemClass).on("click","span."+this.options.playlistOptions.itemClass,function(h){h.preventDefault();h=b(this).parent().parent().index();e.current!==h?e.play(h):b(e.cssSelector.jPlayerAudio).jPlayerAudio("play");e.blur(this)});b(this.cssSelector.playlist).off("click","a."+this.options.playlistOptions.freeItemClass).on("click","a."+this.options.playlistOptions.freeItemClass,function(h){h.preventDefault();
b(this).parent().parent().find("."+e.options.playlistOptions.itemClass).click();e.blur(this)});b(this.cssSelector.playlist).off("click","a."+this.options.playlistOptions.removeItemClass).on("click","a."+this.options.playlistOptions.removeItemClass,function(h){h.preventDefault();h=b(this).parent().parent().index();e.remove(h);e.blur(this)})},_updateControls:function(){this.options.playlistOptions.enableRemoveControls?b(this.cssSelector.playlist+" ."+this.options.playlistOptions.removeItemClass).show():
b(this.cssSelector.playlist+" ."+this.options.playlistOptions.removeItemClass).hide();this.shuffled?b(this.cssSelector.jPlayerAudio).jPlayerAudio("addStateClass","shuffled"):b(this.cssSelector.jPlayerAudio).jPlayerAudio("removeStateClass","shuffled");b(this.cssSelector.shuffle).length&&b(this.cssSelector.shuffleOff).length&&(this.shuffled?(b(this.cssSelector.shuffleOff).show(),b(this.cssSelector.shuffle).hide()):(b(this.cssSelector.shuffleOff).hide(),b(this.cssSelector.shuffle).show()))},_highlight:function(e){this.playlist.length&&
e!==l&&(b(this.cssSelector.playlist+" .mdtc-clnplra-playlist-current").removeClass("mdtc-clnplra-playlist-current"),b(this.cssSelector.playlist+" li:nth-child("+(e+1)+")").addClass("mdtc-clnplra-playlist-current").find(".mdtc-clnplra-playlist-item").addClass("mdtc-clnplra-playlist-current"))},setPlaylist:function(b){this._initPlaylist(b);this._init()},add:function(e,h){b(this.cssSelector.playlist+" ul").append(this._createListItem(e)).find("li:last-child").hide().slideDown(this.options.playlistOptions.addTime);
this._updateControls();this.original.push(e);this.playlist.push(e);h?this.play(this.playlist.length-1):1===this.original.length&&this.select(0)},remove:function(e){var h=this;if(e===l)return this._initPlaylist([]),this._refresh(function(){b(h.cssSelector.jPlayerAudio).jPlayerAudio("clearMedia")}),!0;if(this.removing)return!1;e=0>e?h.original.length+e:e;0<=e&&e<this.playlist.length&&(this.removing=!0,b(this.cssSelector.playlist+" li:nth-child("+(e+1)+")").slideUp(this.options.playlistOptions.removeTime,
function(){b(this).remove();if(h.shuffled){var k=h.playlist[e];b.each(h.original,function(b){if(h.original[b]===k)return h.original.splice(b,1),!1})}else h.original.splice(e,1);h.playlist.splice(e,1);h.original.length?e===h.current?(h.current=e<h.original.length?h.current:h.original.length-1,h.select(h.current)):e<h.current&&h.current--:(b(h.cssSelector.jPlayerAudio).jPlayerAudio("clearMedia"),h.current=0,h.shuffled=!1,h._updateControls());h.removing=!1}));return!0},select:function(e){e=0>e?this.original.length+
e:e;0<=e&&e<this.playlist.length?(this.current=e,this._highlight(e),b(this.cssSelector.jPlayerAudio).jPlayerAudio("setMedia",this.playlist[this.current])):this.current=0},play:function(e){e=0>e?this.original.length+e:e;0<=e&&e<this.playlist.length?this.playlist.length&&(this.select(e),b(this.cssSelector.jPlayerAudio).jPlayerAudio("play")):e===l&&b(this.cssSelector.jPlayerAudio).jPlayerAudio("play")},pause:function(){b(this.cssSelector.jPlayerAudio).jPlayerAudio("pause")},next:function(){var b=this.current+
1<this.playlist.length?this.current+1:0;this.loop?0===b&&this.shuffled&&this.options.playlistOptions.shuffleOnLoop&&1<this.playlist.length?this.shuffle(!0,!0):this.play(b):0<b&&this.play(b)},previous:function(){var b=0<=this.current-1?this.current-1:this.playlist.length-1;(this.loop&&this.options.playlistOptions.loopOnPrevious||b<this.playlist.length-1)&&this.play(b)},shuffle:function(e,h){var k=this;e===l&&(e=!this.shuffled);(e||e!==this.shuffled)&&b(this.cssSelector.playlist+" ul").slideUp(this.options.playlistOptions.shuffleTime,
function(){(k.shuffled=e)?k.playlist.sort(function(){return.5-Math.random()}):k._originalPlaylist();k._refresh(!0);h||!b(k.cssSelector.jPlayerAudio).data("jPlayerAudio").status.paused?k.play(0):k.select(0);b(this).slideDown(k.options.playlistOptions.shuffleTime)})},blur:function(e){b(this.cssSelector.jPlayerAudio).jPlayerAudio("option","autoBlur")&&b(e).blur()}}})(jQuery);
(function(b){function l(b){function e(){var g=b.next(),a=g.find(".mdtc-clnplra-song-title-inner"),g=g.find(".mdtc-clnplra-song-title").width(),d=a.width()-g;0<d&&(a.animate({marginLeft:"-="+(d-10)},2500),setTimeout(function(){a.animate({marginLeft:"+="+(d-10)},2500)},4E3))}e();setInterval(function(){e()},8E3)}function e(){for(var b="",e=0;15>e;e++)b+="abcdefghijklmnopqrstuvwxyz0123456789".charAt(Math.floor(36*Math.random()));return b}b.fn.cleanaudioplayer=function(h){(function(e,g,a,d){b("body").on("mousemove",
".mdtc-clnplra-volume-bar",function(c){g&&g[a](b.extend({},c,{currentTarget:d}))}).on("mouseup",function(){g=!1}).on("mousedown",function(c){var f=b(c.target).parents().add(c.currentTarget);c=f.filter(".mdtc-clnplra-volume-bar").first();f=f.filter(".mdtc-clnplra-seek-bar").first();f.length?(a="seekBar",d=f):c.length&&(a="volumeBar",d=c);g=(c=d&&d.closest(".mdtc-clnplra-audio"))&&c.children().first().add(c.prev()).filter(function(){return b(this).data("jPlayerAudio")}).first().data("jPlayerAudio")})})();
return this.each(function(k){var g=b.extend({theme:"default",supplied:"mp3,m4a,oga,wav",disableControls:!1,autoplay:!1,playlistHeight:!1,rssUrl:!1,playlist:!1},h);k=!1;var a="";if(0<b(this).find("> ul").length){var d=b(this).find("> ul");d.data("theme")?g.theme=d.data("theme"):void 0;d.data("supplied")?g.supplied=d.data("supplied"):void 0;d.data("disable-controls")?g.disableControls=d.data("disable-controls"):void 0;d.data("autoplay")?g.autoplay=d.data("autoplay"):void 0;d.data("playlist-height")?
g.playlistHeight=d.data("playlist-height"):void 0;d.data("preload")?g.preload=d.data("preload"):void 0;if(0<b(this).find("> ul li").length){var c=[];b(this).find("> ul li").each(function(){var a=b(this),d=a.data("free")?!0:!1,e=a.data("type"),d={title:a.data("title"),artist:a.data("artist"),free:d};d[e]=a.data("url");c.push(d)});1==b(this).find("> ul li").length&&b(this).find("> ul li").data("free")&&(k=!0,a=b(this).find("> ul li").data("url"));g.playlist=c}}d=e();b(this).html('<div class="mdtc-clnplra-audio mdtc-clnplra-main-player"><div class="mdtc-clnplra-jplayer">\x3c!-- --\x3e</div><div class="mdtc-clnplra-type-playlist"><div class="mdtc-clnplra-gui mdtc-clnplra-interface"><ul class="mdtc-clnplra-controls"><li><a href="javascript:;" class="mdtc-clnplra-previous mdtc-clnplra-icon-prev" tabindex="1"></a></li><li><a href="javascript:;" class="mdtc-clnplra-play mdtc-clnplra-icon-play" tabindex="1"></a></li><li><a href="javascript:;" class="mdtc-clnplra-pause mdtc-clnplra-icon-pause" tabindex="1" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplra-next mdtc-clnplra-icon-next" tabindex="1"></a></li></ul><div class="mdtc-clnplra-seek-container"><div class="mdtc-clnplra-seek-container-inner"><div class="mdtc-clnplra-time"><div class="mdtc-clnplra-current-time">00:00</div><div class="mdtc-clnplra-duration" style="display:none">00:00</div></div><div class="mdtc-clnplra-song-title"><div class="mdtc-clnplra-song-title-inner"><strong id="current-song">\x3c!-- --\x3e</strong></div></div><div class="mdtc-clnplra-progress"><div class="mdtc-clnplra-seek-bar" style="width:0%"><div class="mdtc-clnplra-play-bar" style="width:0%">\x3c!-- --\x3e</div></div></div></div></div><div class="mdtc-clnplra-volume-bar"><div class="mdtc-clnplra-volume-bar-value"><i>\x3c!-- --\x3e</i></div></div><ul class="mdtc-clnplra-toggles"><li><a title="Repeat" tabindex="1" class="mdtc-clnplra-repeat mdtc-clnplra-icon-repeat" href="javascript:;"></a></li><li><a title="Repeat off" tabindex="1" class="mdtc-clnplra-repeat-off mdtc-clnplra-icon-repeat" href="javascript:;" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplra-shuffle mdtc-clnplra-icon-shuffle" tabindex="1" title="Shuffle"></a></li><li><a href="javascript:;" class="mdtc-clnplra-shuffle-off mdtc-clnplra-icon-shuffle" tabindex="1" title="Shuffle off" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplra-download-one mdtc-clnplra-icon-download" tabindex="1" title="Download" style="display:none"></a></li></ul></div><div class="mdtc-clnplra-playlist"><ul></ul></div><div class="mdtc-clnplra-no-solution" style="display:none"><span>Update Required </span>To play the media you will need to either update your browser to a recent version</div></div></div>');
b(this).find(".mdtc-clnplra-main-player").addClass("mdtc-clnplra-cleanaudioplayer-id-"+d);k&&(b(this).find(".mdtc-clnplra-main-player").addClass("mdtc-clnplra-solo-download"),b(this).find(".mdtc-clnplra-download-one").attr("href",a));"dark"==g.theme&&b(this).find(".mdtc-clnplra-main-player").addClass("mdtc-clnplra-dark-theme");g.disableControls&&b(this).find(".mdtc-clnplra-main-player").addClass("mdtc-clnplra-disabled-controls");g.playlistHeight&&b(this).find(".mdtc-clnplra-playlist > ul").css({maxHeight:g.playlistHeight,
overflowY:"auto"});1<g.playlist.length?(playerOptions={solution:"html",supplied:g.supplied,preload:g.preload,wmode:"window",ready:function(a){function d(){c.next().is(":visible")&&(450>c.parent().width()?c.parent().addClass("mdtc-clnplra-responsive"):c.parent().removeClass("mdtc-clnplra-responsive"))}var c=b(this);c.next().find(".mdtc-clnplra-time").on("click",function(){c.next().find(".mdtc-clnplra-current-time, .mdtc-clnplra-duration").toggle()});g.autoplay&&b(this).jPlayerAudio("play");b(window).on("resize",
function(){d()});d();setInterval(function(){d()},250);l(c)},play:function(a){b(this).jPlayerAudio("pauseOthers")},cssSelector:{title:"#current-song"},playlistOptions:{shuffleTime:150}},new jPlayerAudioPlaylist({jPlayerAudio:".mdtc-clnplra-cleanaudioplayer-id-"+d+" .mdtc-clnplra-jplayer",cssSelectorAncestor:".mdtc-clnplra-cleanaudioplayer-id-"+d},g.playlist,playerOptions)):b(".mdtc-clnplra-cleanaudioplayer-id-"+d+" .mdtc-clnplra-jplayer").jPlayerAudio({ready:function(a){function d(){c.next().is(":visible")&&
(450>c.parent().width()?c.parent().addClass("mdtc-clnplra-responsive"):c.parent().removeClass("mdtc-clnplra-responsive"))}b(this).jPlayerAudio("setMedia",g.playlist[0]);var c=b(this);c.next().find(".mdtc-clnplra-time").on("click",function(){c.next().find(".mdtc-clnplra-current-time, .mdtc-clnplra-duration").toggle()});g.autoplay&&b(this).jPlayerAudio("play");b(this).parent().addClass("mdtc-clnplra-disabled-controls mdtc-clnplra-solo-player");b(window).on("resize",function(){d()});d();setInterval(function(){d()},
250);l(c)},play:function(a){b(this).jPlayerAudio("pauseOthers")},cssSelector:{title:"#current-song"},cssSelectorAncestor:".mdtc-clnplra-cleanaudioplayer-id-"+d,supplied:g.supplied})})}})(jQuery);
(function(b,l){"function"===typeof define&&define.amd?define(["jquery"],l):"object"===typeof exports?l(require("jquery")):b.jQuery?l(b.jQuery):l(b.Zepto)})(this,function(b,l){b.fn.jPlayerVideo=function(a){var d="string"===typeof a,c=Array.prototype.slice.call(arguments,1),f=this;a=!d&&c.length?b.extend.apply(null,[!0,a].concat(c)):a;if(d&&"_"===a.charAt(0))return f;d?this.each(function(){var d=b(this).data("jPlayerVideo"),e=d&&b.isFunction(d[a])?d[a].apply(d,c):d;if(e!==d&&e!==l)return f=e,!1}):this.each(function(){var d=
b(this).data("jPlayerVideo");d?d.option(a||{}):b(this).data("jPlayerVideo",new b.jPlayerVideo(a,this))});return f};b.jPlayerVideo=function(a,d){if(arguments.length){this.element=b(d);this.options=b.extend(!0,{},this.options,a);var c=this;this.element.bind("remove.jPlayerVideo",function(){c.destroy()});this._init()}};"function"!==typeof b.fn.stop&&(b.fn.stop=function(){});b.jPlayerVideo.emulateMethods="load play pause";b.jPlayerVideo.emulateStatus="src readyState networkState currentTime duration paused ended playbackRate";
b.jPlayerVideo.emulateOptions="muted volume";b.jPlayerVideo.reservedEvent="ready flashreset resize repeat error warning";b.jPlayerVideo.event={};b.each("ready setmedia flashreset resize repeat click error warning loadstart progress suspend abort emptied stalled play pause loadedmetadata loadeddata waiting playing canplay canplaythrough seeking seeked timeupdate ended ratechange durationchange volumechange".split(" "),function(){b.jPlayerVideo.event[this]="jPlayerVideo_"+this});b.jPlayerVideo.htmlEvent=
"loadstart abort emptied stalled loadedmetadata canplay canplaythrough".split(" ");b.jPlayerVideo.pause=function(){b.jPlayerVideo.prototype.destroyRemoved();b.each(b.jPlayerVideo.prototype.instances,function(a,b){b.data("jPlayerVideo").status.srcSet&&b.jPlayerVideo("pause")})};b.jPlayerVideo.timeFormat={showHour:!1,showMin:!0,showSec:!0,padHour:!1,padMin:!0,padSec:!0,sepHour:":",sepMin:":",sepSec:""};var e=function(){this.init()};e.prototype={init:function(){this.options={timeFormat:b.jPlayerVideo.timeFormat}},
time:function(a){var b=new Date(1E3*(a&&"number"===typeof a?a:0)),c=b.getUTCHours();a=this.options.timeFormat.showHour?b.getUTCMinutes():b.getUTCMinutes()+60*c;b=this.options.timeFormat.showMin?b.getUTCSeconds():b.getUTCSeconds()+60*a;c=this.options.timeFormat.padHour&&10>c?"0"+c:c;a=this.options.timeFormat.padMin&&10>a?"0"+a:a;b=this.options.timeFormat.padSec&&10>b?"0"+b:b;c=""+(this.options.timeFormat.showHour?c+this.options.timeFormat.sepHour:"");c+=this.options.timeFormat.showMin?a+this.options.timeFormat.sepMin:
"";return c+=this.options.timeFormat.showSec?b+this.options.timeFormat.sepSec:""}};var h=new e;b.jPlayerVideo.convertTime=function(a){return h.time(a)};b.jPlayerVideo.uaBrowser=function(a){a=a.toLowerCase();var b=/(opera)(?:.*version)?[ \/]([\w.]+)/,c=/(msie) ([\w.]+)/,f=/(mozilla)(?:.*? rv:([\w.]+))?/;a=/(webkit)[ \/]([\w.]+)/.exec(a)||b.exec(a)||c.exec(a)||0>a.indexOf("compatible")&&f.exec(a)||[];return{browser:a[1]||"",version:a[2]||"0"}};b.jPlayerVideo.uaPlatform=function(a){var b=a.toLowerCase(),
c=/(android)/,f=/(mobile)/;a=/(ipad|iphone|ipod|android|blackberry|playbook|windows ce|webos)/.exec(b)||[];b=/(ipad|playbook)/.exec(b)||!f.exec(b)&&c.exec(b)||[];a[1]&&(a[1]=a[1].replace(/\s/g,"_"));return{platform:a[1]||"",tablet:b[1]||""}};b.jPlayerVideo.browser={};b.jPlayerVideo.platform={};var k=b.jPlayerVideo.uaBrowser(navigator.userAgent);k.browser&&(b.jPlayerVideo.browser[k.browser]=!0,b.jPlayerVideo.browser.version=k.version);k=b.jPlayerVideo.uaPlatform(navigator.userAgent);k.platform&&(b.jPlayerVideo.platform[k.platform]=
!0,b.jPlayerVideo.platform.mobile=!k.tablet,b.jPlayerVideo.platform.tablet=!!k.tablet);b.jPlayerVideo.getDocMode=function(){var a;b.jPlayerVideo.browser.msie&&(document.documentMode?a=document.documentMode:(a=5,document.compatMode&&"CSS1Compat"===document.compatMode&&(a=7)));return a};b.jPlayerVideo.browser.documentMode=b.jPlayerVideo.getDocMode();b.jPlayerVideo.nativeFeatures={init:function(){var a=document,b=a.createElement("video"),c={w3c:"fullscreenEnabled fullscreenElement requestFullscreen exitFullscreen fullscreenchange fullscreenerror".split(" "),
moz:"mozFullScreenEnabled mozFullScreenElement mozRequestFullScreen mozCancelFullScreen mozfullscreenchange mozfullscreenerror".split(" "),webkit:" webkitCurrentFullScreenElement webkitRequestFullScreen webkitCancelFullScreen webkitfullscreenchange ".split(" "),webkitVideo:"webkitSupportsFullscreen webkitDisplayingFullscreen webkitEnterFullscreen webkitExitFullscreen  ".split(" "),ms:" msFullscreenElement msRequestFullscreen msExitFullscreen MSFullscreenChange MSFullscreenError".split(" ")},f=["w3c",
"moz","webkit","webkitVideo","ms"],e,g;this.fullscreen=b={support:{w3c:!!a[c.w3c[0]],moz:!!a[c.moz[0]],webkit:"function"===typeof a[c.webkit[3]],webkitVideo:"function"===typeof b[c.webkitVideo[2]],ms:"function"===typeof b[c.ms[2]]},used:{}};e=0;for(g=f.length;e<g;e++){var h=f[e];if(b.support[h]){b.spec=h;b.used[h]=!0;break}}if(b.spec){var k=c[b.spec];b.api={fullscreenEnabled:!0,fullscreenElement:function(b){b=b?b:a;return b[k[1]]},requestFullscreen:function(a){return a[k[2]]()},exitFullscreen:function(b){b=
b?b:a;return b[k[3]]()}};b.event={fullscreenchange:k[4],fullscreenerror:k[5]}}else b.api={fullscreenEnabled:!1,fullscreenElement:function(){return null},requestFullscreen:function(){},exitFullscreen:function(){}},b.event={}}};b.jPlayerVideo.nativeFeatures.init();b.jPlayerVideo.focus=null;b.jPlayerVideo.keyIgnoreElementNames="A INPUT TEXTAREA SELECT BUTTON";var g=function(a){var d=b.jPlayerVideo.focus,c;d&&(b.each(b.jPlayerVideo.keyIgnoreElementNames.split(/\s+/g),function(b,d){if(a.target.nodeName.toUpperCase()===
d.toUpperCase())return c=!0,!1}),c||b.each(d.options.keyBindings,function(c,e){if(e&&b.isFunction(e.fn)&&("number"===typeof e.key&&a.which===e.key||"string"===typeof e.key&&a.key===e.key))return a.preventDefault(),e.fn(d),!1}))};b.jPlayerVideo.keys=function(a){b(document.documentElement).unbind("keydown.jPlayerVideo");a&&b(document.documentElement).bind("keydown.jPlayerVideo",g)};b.jPlayerVideo.keys(!0);b.jPlayerVideo.prototype={count:0,version:{script:"2.9.2",needFlash:"2.9.0",flash:"unknown"},options:{swfPath:"js",
solution:"html, flash",supplied:"mp3",auroraFormats:"wav",preload:"metadata",volume:.8,muted:!1,remainingDuration:!1,toggleDuration:!1,captureDuration:!0,playbackRate:1,defaultPlaybackRate:1,minPlaybackRate:.5,maxPlaybackRate:4,wmode:"opaque",backgroundColor:"#000000",cssSelectorAncestor:"#jp_video_container_1",cssSelector:{videoPlay:".mdtc-clnplrv-video-play",play:".mdtc-clnplrv-play",pause:".mdtc-clnplrv-pause",stop:".mdtc-clnplrv-stop",seekBar:".mdtc-clnplrv-seek-bar",playBar:".mdtc-clnplrv-play-bar",
mute:".mdtc-clnplrv-mute",unmute:".mdtc-clnplrv-unmute",volumeBar:".mdtc-clnplrv-volume-bar",volumeBarValue:".mdtc-clnplrv-volume-bar-value",volumeMax:".mdtc-clnplrv-volume-max",playbackRateBar:".mdtc-clnplrv-playback-rate-bar",playbackRateBarValue:".mdtc-clnplrv-playback-rate-bar-value",currentTime:".mdtc-clnplrv-current-time",duration:".mdtc-clnplrv-duration",title:".mdtc-clnplrv-title",fullScreen:".mdtc-clnplrv-full-screen",restoreScreen:".mdtc-clnplrv-restore-screen",repeat:".mdtc-clnplrv-repeat",
repeatOff:".mdtc-clnplrv-repeat-off",gui:".mdtc-clnplrv-gui",noSolution:".mdtc-clnplrv-no-solution"},stateClass:{playing:"mdtc-clnplrv-state-playing",seeking:"mdtc-clnplrv-state-seeking",muted:"mdtc-clnplrv-state-muted",looped:"mdtc-clnplrv-state-looped",fullScreen:"mdtc-clnplrv-state-full-screen",noVolume:"mdtc-clnplrv-state-no-volume"},useStateClassSkin:!1,autoBlur:!0,smoothPlayBar:!1,fullScreen:!1,fullWindow:!1,autohide:{restored:!1,full:!0,fadeIn:200,fadeOut:600,hold:1E3},loop:!1,repeat:function(a){a.jPlayerVideo.options.loop?
b(this).unbind(".jPlayerVideoRepeat").bind(b.jPlayerVideo.event.ended+".jPlayerVideo.jPlayerVideoRepeat",function(){b(this).jPlayerVideo("play")}):b(this).unbind(".jPlayerVideoRepeat")},nativeVideoControls:{},noFullWindow:{msie:/msie [0-6]\./,ipad:/ipad.*?os [0-4]\./,iphone:/iphone/,ipod:/ipod/,android_pad:/android [0-3]\.(?!.*?mobile)/,android_phone:/(?=.*android)(?!.*chrome)(?=.*mobile)/,blackberry:/blackberry/,windows_ce:/windows ce/,iemobile:/iemobile/,webos:/webos/},noVolume:{ipad:/ipad/,iphone:/iphone/,
ipod:/ipod/,android_pad:/android(?!.*?mobile)/,android_phone:/android.*?mobile/,blackberry:/blackberry/,windows_ce:/windows ce/,iemobile:/iemobile/,webos:/webos/,playbook:/playbook/},timeFormat:{},keyEnabled:!1,audioFullScreen:!1,keyBindings:{play:{key:80,fn:function(a){a.status.paused?a.play():a.pause()}},fullScreen:{key:70,fn:function(a){(a.status.video||a.options.audioFullScreen)&&a._setOption("fullScreen",!a.options.fullScreen)}},muted:{key:77,fn:function(a){a._muted(!a.options.muted)}},volumeUp:{key:190,
fn:function(a){a.volume(a.options.volume+.1)}},volumeDown:{key:188,fn:function(a){a.volume(a.options.volume-.1)}},loop:{key:76,fn:function(a){a._loop(!a.options.loop)}}},verticalVolume:!1,verticalPlaybackRate:!1,globalVolume:!1,idPrefix:"jp_video_",noConflict:"jQuery",emulateHtml:!1,consoleAlerts:!0,errorAlerts:!1,warningAlerts:!1},optionsAudio:{size:{width:"0px",height:"0px",cssClass:""},sizeFull:{width:"0px",height:"0px",cssClass:""}},optionsVideo:{size:{width:"480px",height:"270px",cssClass:"mdtc-clnplrv-video-270p"},
sizeFull:{width:"100%",height:"100%",cssClass:"mdtc-clnplrv-video-full"}},instances:{},status:{src:"",media:{},paused:!0,format:{},formatType:"",waitForPlay:!0,waitForLoad:!0,srcSet:!1,video:!1,seekPercent:0,currentPercentRelative:0,currentPercentAbsolute:0,currentTime:0,duration:0,remaining:0,videoWidth:0,videoHeight:0,readyState:0,networkState:0,playbackRate:1,ended:0},internal:{ready:!1},solution:{html:!0,aurora:!0,flash:!0},format:{mp3:{codec:"audio/mpeg",flashCanPlay:!0,media:"audio"},m4a:{codec:'audio/mp4; codecs="mp4a.40.2"',
flashCanPlay:!0,media:"audio"},m3u8a:{codec:'application/vnd.apple.mpegurl; codecs="mp4a.40.2"',flashCanPlay:!1,media:"audio"},m3ua:{codec:"audio/mpegurl",flashCanPlay:!1,media:"audio"},oga:{codec:'audio/ogg; codecs="vorbis, opus"',flashCanPlay:!1,media:"audio"},flac:{codec:"audio/x-flac",flashCanPlay:!1,media:"audio"},wav:{codec:'audio/wav; codecs="1"',flashCanPlay:!1,media:"audio"},webma:{codec:'audio/webm; codecs="vorbis"',flashCanPlay:!1,media:"audio"},fla:{codec:"audio/x-flv",flashCanPlay:!0,
media:"audio"},rtmpa:{codec:'audio/rtmp; codecs="rtmp"',flashCanPlay:!0,media:"audio"},m4v:{codec:'video/mp4; codecs="avc1.42E01E, mp4a.40.2"',flashCanPlay:!0,media:"video"},m3u8v:{codec:'application/vnd.apple.mpegurl; codecs="avc1.42E01E, mp4a.40.2"',flashCanPlay:!1,media:"video"},m3uv:{codec:"audio/mpegurl",flashCanPlay:!1,media:"video"},ogv:{codec:'video/ogg; codecs="theora, vorbis"',flashCanPlay:!1,media:"video"},webmv:{codec:'video/webm; codecs="vorbis, vp8"',flashCanPlay:!1,media:"video"},flv:{codec:"video/x-flv",
flashCanPlay:!0,media:"video"},rtmpv:{codec:'video/rtmp; codecs="rtmp"',flashCanPlay:!0,media:"video"}},_init:function(){var a=this;this.element.empty();this.status=b.extend({},this.status);this.internal=b.extend({},this.internal);this.options.timeFormat=b.extend({},b.jPlayerVideo.timeFormat,this.options.timeFormat);this.internal.cmdsIgnored=b.jPlayerVideo.platform.ipad||b.jPlayerVideo.platform.iphone||b.jPlayerVideo.platform.ipod;this.internal.domNode=this.element.get(0);this.options.keyEnabled&&
!b.jPlayerVideo.focus&&(b.jPlayerVideo.focus=this);this.androidFix={setMedia:!1,play:!1,pause:!1,time:NaN};b.jPlayerVideo.platform.android&&(this.options.preload="auto"!==this.options.preload?"metadata":"auto");this.formats=[];this.solutions=[];this.require={};this.htmlElement={};this.html={};this.html.audio={};this.html.video={};this.aurora={};this.aurora.formats=[];this.aurora.properties=[];this.flash={};this.css={};this.css.cs={};this.css.jq={};this.ancestorJq=[];this.options.volume=this._limitValue(this.options.volume,
0,1);b.each(this.options.supplied.toLowerCase().split(","),function(d,c){var f=c.replace(/^\s+|\s+$/g,"");if(a.format[f]){var e=!1;b.each(a.formats,function(a,b){if(f===b)return e=!0,!1});e||a.formats.push(f)}});b.each(this.options.solution.toLowerCase().split(","),function(d,c){var f=c.replace(/^\s+|\s+$/g,"");if(a.solution[f]){var e=!1;b.each(a.solutions,function(a,b){if(f===b)return e=!0,!1});e||a.solutions.push(f)}});b.each(this.options.auroraFormats.toLowerCase().split(","),function(d,c){var f=
c.replace(/^\s+|\s+$/g,"");if(a.format[f]){var e=!1;b.each(a.aurora.formats,function(a,b){if(f===b)return e=!0,!1});e||a.aurora.formats.push(f)}});this.internal.instance="jp_video_"+this.count;this.instances[this.internal.instance]=this.element;this.element.attr("id")||this.element.attr("id",this.options.idPrefix+"_jplayer_"+this.count);this.internal.self=b.extend({},{id:this.element.attr("id"),jq:this.element});this.internal.audio=b.extend({},{id:this.options.idPrefix+"_audio_"+this.count,jq:l});
this.internal.video=b.extend({},{id:this.options.idPrefix+"_video_"+this.count,jq:l});this.internal.flash=b.extend({},{id:this.options.idPrefix+"_flash_"+this.count,jq:l,swf:this.options.swfPath+(".swf"!==this.options.swfPath.toLowerCase().slice(-4)?(this.options.swfPath&&"/"!==this.options.swfPath.slice(-1)?"/":"")+"jquery.jplayer.swf":"")});this.internal.poster=b.extend({},{id:this.options.idPrefix+"_poster_"+this.count,jq:l});b.each(b.jPlayerVideo.event,function(b,d){a.options[b]!==l&&(a.element.bind(d+
".jPlayerVideo",a.options[b]),a.options[b]=l)});this.require.audio=!1;this.require.video=!1;b.each(this.formats,function(b,d){a.require[a.format[d].media]=!0});this.options=this.require.video?b.extend(!0,{},this.optionsVideo,this.options):b.extend(!0,{},this.optionsAudio,this.options);this._setSize();this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this.status.noFullWindow=this._uaBlocklist(this.options.noFullWindow);this.status.noVolume=this._uaBlocklist(this.options.noVolume);
b.jPlayerVideo.nativeFeatures.fullscreen.api.fullscreenEnabled&&this._fullscreenAddEventListeners();this._restrictNativeVideoControls();this.htmlElement.poster=document.createElement("img");this.htmlElement.poster.id=this.internal.poster.id;this.htmlElement.poster.onload=function(){a.status.video&&!a.status.waitForPlay||a.internal.poster.jq.show()};this.element.append(this.htmlElement.poster);this.internal.poster.jq=b("#"+this.internal.poster.id);this.internal.poster.jq.css({width:this.status.width,
height:this.status.height});this.internal.poster.jq.hide();this.internal.poster.jq.bind("click.jPlayerVideo",function(){a._trigger(b.jPlayerVideo.event.click)});this.html.audio.available=!1;this.require.audio&&(this.htmlElement.audio=document.createElement("audio"),this.htmlElement.audio.id=this.internal.audio.id,this.html.audio.available=!!this.htmlElement.audio.canPlayType&&this._testCanPlayType(this.htmlElement.audio));this.html.video.available=!1;this.require.video&&(this.htmlElement.video=document.createElement("video"),
this.htmlElement.video.id=this.internal.video.id,this.html.video.available=!!this.htmlElement.video.canPlayType&&this._testCanPlayType(this.htmlElement.video));this.flash.available=this._checkForFlash(10.1);this.html.canPlay={};this.aurora.canPlay={};this.flash.canPlay={};b.each(this.formats,function(d,c){a.html.canPlay[c]=a.html[a.format[c].media].available&&""!==a.htmlElement[a.format[c].media].canPlayType(a.format[c].codec);a.aurora.canPlay[c]=-1<b.inArray(c,a.aurora.formats);a.flash.canPlay[c]=
a.format[c].flashCanPlay&&a.flash.available});this.html.desired=!1;this.aurora.desired=!1;this.flash.desired=!1;b.each(this.solutions,function(d,c){if(0===d)a[c].desired=!0;else{var f=!1,e=!1;b.each(a.formats,function(b,c){a[a.solutions[0]].canPlay[c]&&("video"===a.format[c].media?e=!0:f=!0)});a[c].desired=a.require.audio&&!f||a.require.video&&!e}});this.html.support={};this.aurora.support={};this.flash.support={};b.each(this.formats,function(b,c){a.html.support[c]=a.html.canPlay[c]&&a.html.desired;
a.aurora.support[c]=a.aurora.canPlay[c]&&a.aurora.desired;a.flash.support[c]=a.flash.canPlay[c]&&a.flash.desired});this.html.used=!1;this.aurora.used=!1;this.flash.used=!1;b.each(this.solutions,function(c,d){b.each(a.formats,function(b,c){if(a[d].support[c])return a[d].used=!0,!1})});this._resetActive();this._resetGate();this._cssSelectorAncestor(this.options.cssSelectorAncestor);this.html.used||this.aurora.used||this.flash.used?this.css.jq.noSolution.length&&this.css.jq.noSolution.hide():(this._error({type:b.jPlayerVideo.error.NO_SOLUTION,
context:"{solution:'"+this.options.solution+"', supplied:'"+this.options.supplied+"'}",message:b.jPlayerVideo.errorMsg.NO_SOLUTION,hint:b.jPlayerVideo.errorHint.NO_SOLUTION}),this.css.jq.noSolution.length&&this.css.jq.noSolution.show());if(this.flash.used){var d,c="jQuery="+encodeURI(this.options.noConflict)+"&id="+encodeURI(this.internal.self.id)+"&vol="+this.options.volume+"&muted="+this.options.muted;if(b.jPlayerVideo.browser.msie&&(9>Number(b.jPlayerVideo.browser.version)||9>b.jPlayerVideo.browser.documentMode)){c=
['<param name="movie" value="'+this.internal.flash.swf+'" />','<param name="FlashVars" value="'+c+'" />','<param name="allowScriptAccess" value="always" />','<param name="bgcolor" value="'+this.options.backgroundColor+'" />','<param name="wmode" value="'+this.options.wmode+'" />'];d=document.createElement('<object id="'+this.internal.flash.id+'" classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="0" height="0" tabindex="-1"></object>');for(var f=0;f<c.length;f++)d.appendChild(document.createElement(c[f]))}else f=
function(a,b,c){var d=document.createElement("param");d.setAttribute("name",b);d.setAttribute("value",c);a.appendChild(d)},d=document.createElement("object"),d.setAttribute("id",this.internal.flash.id),d.setAttribute("name",this.internal.flash.id),d.setAttribute("data",this.internal.flash.swf),d.setAttribute("type","application/x-shockwave-flash"),d.setAttribute("width","1"),d.setAttribute("height","1"),d.setAttribute("tabindex","-1"),f(d,"flashvars",c),f(d,"allowscriptaccess","always"),f(d,"bgcolor",
this.options.backgroundColor),f(d,"wmode",this.options.wmode);this.element.append(d);this.internal.flash.jq=b(d)}this.status.playbackRateEnabled=this.html.used&&!this.flash.used?this._testPlaybackRate("audio"):!1;this._updatePlaybackRate();this.html.used&&(this.html.audio.available&&(this._addHtmlEventListeners(this.htmlElement.audio,this.html.audio),this.element.append(this.htmlElement.audio),this.internal.audio.jq=b("#"+this.internal.audio.id)),this.html.video.available&&(this._addHtmlEventListeners(this.htmlElement.video,
this.html.video),this.element.append(this.htmlElement.video),this.internal.video.jq=b("#"+this.internal.video.id),this.status.nativeVideoControls?this.internal.video.jq.css({width:this.status.width,height:this.status.height}):this.internal.video.jq.css({width:"0px",height:"0px"}),this.internal.video.jq.bind("click.jPlayerVideo",function(){a._trigger(b.jPlayerVideo.event.click)})));this.options.emulateHtml&&this._emulateHtmlBridge();!this.html.used&&!this.aurora.used||this.flash.used||setTimeout(function(){a.internal.ready=
!0;a.version.flash="n/a";a._trigger(b.jPlayerVideo.event.repeat);a._trigger(b.jPlayerVideo.event.ready)},100);this._updateNativeVideoControls();this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide();b.jPlayerVideo.prototype.count++},destroy:function(){this.clearMedia();this._removeUiClass();this.css.jq.currentTime.length&&this.css.jq.currentTime.text("");this.css.jq.duration.length&&this.css.jq.duration.text("");b.each(this.css.jq,function(a,b){b.length&&b.unbind(".jPlayerVideo")});this.internal.poster.jq.unbind(".jPlayerVideo");
this.internal.video.jq&&this.internal.video.jq.unbind(".jPlayerVideo");this._fullscreenRemoveEventListeners();this===b.jPlayerVideo.focus&&(b.jPlayerVideo.focus=null);this.options.emulateHtml&&this._destroyHtmlBridge();this.element.removeData("jPlayerVideo");this.element.unbind(".jPlayerVideo");this.element.empty();delete this.instances[this.internal.instance]},destroyRemoved:function(){var a=this;b.each(this.instances,function(b,c){a.element===c||c.data("jPlayerVideo")||(c.jPlayerVideo("destroy"),
delete a.instances[b])})},enable:function(){},disable:function(){},_testCanPlayType:function(a){try{return a.canPlayType(this.format.mp3.codec),!0}catch(b){return!1}},_testPlaybackRate:function(a){a=document.createElement("string"===typeof a?a:"audio");try{return"playbackRate"in a?(a.playbackRate=.5,.5===a.playbackRate):!1}catch(b){return!1}},_uaBlocklist:function(a){var d=navigator.userAgent.toLowerCase(),c=!1;b.each(a,function(a,b){if(b&&b.test(d))return c=!0,!1});return c},_restrictNativeVideoControls:function(){this.require.audio&&
this.status.nativeVideoControls&&(this.status.nativeVideoControls=!1,this.status.noFullWindow=!0)},_updateNativeVideoControls:function(){this.html.video.available&&this.html.used&&(this.htmlElement.video.controls=this.status.nativeVideoControls,this._updateAutohide(),this.status.nativeVideoControls&&this.require.video?(this.internal.poster.jq.hide(),this.internal.video.jq.css({width:this.status.width,height:this.status.height})):this.status.waitForPlay&&this.status.video&&(this.internal.poster.jq.show(),
this.internal.video.jq.css({width:"0px",height:"0px"})))},_addHtmlEventListeners:function(a,d){var c=this;a.preload=this.options.preload;a.muted=this.options.muted;a.volume=this.options.volume;this.status.playbackRateEnabled&&(a.defaultPlaybackRate=this.options.defaultPlaybackRate,a.playbackRate=this.options.playbackRate);a.addEventListener("progress",function(){d.gate&&(c.internal.cmdsIgnored&&0<this.readyState&&(c.internal.cmdsIgnored=!1),c._getHtmlStatus(a),c._updateInterface(),c._trigger(b.jPlayerVideo.event.progress))},
!1);a.addEventListener("loadeddata",function(){d.gate&&(c.androidFix.setMedia=!1,c.androidFix.play&&(c.androidFix.play=!1,c.play(c.androidFix.time)),c.androidFix.pause&&(c.androidFix.pause=!1,c.pause(c.androidFix.time)),c._trigger(b.jPlayerVideo.event.loadeddata))},!1);a.addEventListener("timeupdate",function(){d.gate&&(c._getHtmlStatus(a),c._updateInterface(),c._trigger(b.jPlayerVideo.event.timeupdate))},!1);a.addEventListener("durationchange",function(){d.gate&&(c._getHtmlStatus(a),c._updateInterface(),
c._trigger(b.jPlayerVideo.event.durationchange))},!1);a.addEventListener("play",function(){d.gate&&(c._updateButtons(!0),c._html_checkWaitForPlay(),c._trigger(b.jPlayerVideo.event.play))},!1);a.addEventListener("playing",function(){d.gate&&(c._updateButtons(!0),c._seeked(),c._trigger(b.jPlayerVideo.event.playing))},!1);a.addEventListener("pause",function(){d.gate&&(c._updateButtons(!1),c._trigger(b.jPlayerVideo.event.pause))},!1);a.addEventListener("waiting",function(){d.gate&&(c._seeking(),c._trigger(b.jPlayerVideo.event.waiting))},
!1);a.addEventListener("seeking",function(){d.gate&&(c._seeking(),c._trigger(b.jPlayerVideo.event.seeking))},!1);a.addEventListener("seeked",function(){d.gate&&(c._seeked(),c._trigger(b.jPlayerVideo.event.seeked))},!1);a.addEventListener("volumechange",function(){d.gate&&(c.options.volume=a.volume,c.options.muted=a.muted,c._updateMute(),c._updateVolume(),c._trigger(b.jPlayerVideo.event.volumechange))},!1);a.addEventListener("ratechange",function(){d.gate&&(c.options.defaultPlaybackRate=a.defaultPlaybackRate,
c.options.playbackRate=a.playbackRate,c._updatePlaybackRate(),c._trigger(b.jPlayerVideo.event.ratechange))},!1);a.addEventListener("suspend",function(){d.gate&&(c._seeked(),c._trigger(b.jPlayerVideo.event.suspend))},!1);a.addEventListener("ended",function(){d.gate&&(b.jPlayerVideo.browser.webkit||(c.htmlElement.media.currentTime=0),c.htmlElement.media.pause(),c._updateButtons(!1),c._getHtmlStatus(a,!0),c._updateInterface(),c._trigger(b.jPlayerVideo.event.ended))},!1);a.addEventListener("error",function(){d.gate&&
(c._updateButtons(!1),c._seeked(),c.status.srcSet&&(clearTimeout(c.internal.htmlDlyCmdId),c.status.waitForLoad=!0,c.status.waitForPlay=!0,c.status.video&&!c.status.nativeVideoControls&&c.internal.video.jq.css({width:"0px",height:"0px"}),c._validString(c.status.media.poster)&&!c.status.nativeVideoControls&&c.internal.poster.jq.show(),c.css.jq.videoPlay.length&&c.css.jq.videoPlay.show(),c._error({type:b.jPlayerVideo.error.URL,context:c.status.src,message:b.jPlayerVideo.errorMsg.URL,hint:b.jPlayerVideo.errorHint.URL})))},
!1);b.each(b.jPlayerVideo.htmlEvent,function(f,e){a.addEventListener(this,function(){d.gate&&c._trigger(b.jPlayerVideo.event[e])},!1)})},_addAuroraEventListeners:function(a,d){var c=this;a.volume=100*this.options.volume;a.on("progress",function(){d.gate&&(c.internal.cmdsIgnored&&0<this.readyState&&(c.internal.cmdsIgnored=!1),c._getAuroraStatus(a),c._updateInterface(),c._trigger(b.jPlayerVideo.event.progress),0<a.duration&&c._trigger(b.jPlayerVideo.event.timeupdate))},!1);a.on("ready",function(){d.gate&&
c._trigger(b.jPlayerVideo.event.loadeddata)},!1);a.on("duration",function(){d.gate&&(c._getAuroraStatus(a),c._updateInterface(),c._trigger(b.jPlayerVideo.event.durationchange))},!1);a.on("end",function(){d.gate&&(c._updateButtons(!1),c._getAuroraStatus(a,!0),c._updateInterface(),c._trigger(b.jPlayerVideo.event.ended))},!1);a.on("error",function(){d.gate&&(c._updateButtons(!1),c._seeked(),c.status.srcSet&&(c.status.waitForLoad=!0,c.status.waitForPlay=!0,c.status.video&&!c.status.nativeVideoControls&&
c.internal.video.jq.css({width:"0px",height:"0px"}),c._validString(c.status.media.poster)&&!c.status.nativeVideoControls&&c.internal.poster.jq.show(),c.css.jq.videoPlay.length&&c.css.jq.videoPlay.show(),c._error({type:b.jPlayerVideo.error.URL,context:c.status.src,message:b.jPlayerVideo.errorMsg.URL,hint:b.jPlayerVideo.errorHint.URL})))},!1)},_getHtmlStatus:function(a,b){var c,f,e,g;isFinite(a.duration)&&(this.status.duration=a.duration);c=a.currentTime;f=0<this.status.duration?100*c/this.status.duration:
0;"object"===typeof a.seekable&&0<a.seekable.length?(e=0<this.status.duration?100*a.seekable.end(a.seekable.length-1)/this.status.duration:100,g=0<this.status.duration?100*a.currentTime/a.seekable.end(a.seekable.length-1):0):(e=100,g=f);b&&(f=g=c=0);this.status.seekPercent=e;this.status.currentPercentRelative=g;this.status.currentPercentAbsolute=f;this.status.currentTime=c;this.status.remaining=this.status.duration-this.status.currentTime;this.status.videoWidth=a.videoWidth;this.status.videoHeight=
a.videoHeight;this.status.readyState=a.readyState;this.status.networkState=a.networkState;this.status.playbackRate=a.playbackRate;this.status.ended=a.ended},_getAuroraStatus:function(a,b){var c,f,e,g;this.status.duration=a.duration/1E3;c=a.currentTime/1E3;f=0<this.status.duration?100*c/this.status.duration:0;0<a.buffered?(e=0<this.status.duration?a.buffered*this.status.duration/this.status.duration:100,g=0<this.status.duration?c/(a.buffered*this.status.duration):0):(e=100,g=f);b&&(f=g=c=0);this.status.seekPercent=
e;this.status.currentPercentRelative=g;this.status.currentPercentAbsolute=f;this.status.currentTime=c;this.status.remaining=this.status.duration-this.status.currentTime;this.status.readyState=4;this.status.networkState=0;this.status.playbackRate=1;this.status.ended=!1},_resetStatus:function(){this.status=b.extend({},this.status,b.jPlayerVideo.prototype.status)},_trigger:function(a,d,c){a=b.Event(a);a.jPlayerVideo={};a.jPlayerVideo.version=b.extend({},this.version);a.jPlayerVideo.options=b.extend(!0,
{},this.options);a.jPlayerVideo.status=b.extend(!0,{},this.status);a.jPlayerVideo.html=b.extend(!0,{},this.html);a.jPlayerVideo.aurora=b.extend(!0,{},this.aurora);a.jPlayerVideo.flash=b.extend(!0,{},this.flash);d&&(a.jPlayerVideo.error=b.extend({},d));c&&(a.jPlayerVideo.warning=b.extend({},c));this.element.trigger(a)},jPlayerVideoFlashEvent:function(a,d){if(a===b.jPlayerVideo.event.ready)if(!this.internal.ready)this.internal.ready=!0,this.internal.flash.jq.css({width:"0px",height:"0px"}),this.version.flash=
d.version,this.version.needFlash!==this.version.flash&&this._error({type:b.jPlayerVideo.error.VERSION,context:this.version.flash,message:b.jPlayerVideo.errorMsg.VERSION+this.version.flash,hint:b.jPlayerVideo.errorHint.VERSION}),this._trigger(b.jPlayerVideo.event.repeat),this._trigger(a);else if(this.flash.gate){if(this.status.srcSet){var c=this.status.currentTime,f=this.status.paused;this.setMedia(this.status.media);this.volumeWorker(this.options.volume);0<c&&(f?this.pause(c):this.play(c))}this._trigger(b.jPlayerVideo.event.flashreset)}if(this.flash.gate)switch(a){case b.jPlayerVideo.event.progress:this._getFlashStatus(d);
this._updateInterface();this._trigger(a);break;case b.jPlayerVideo.event.timeupdate:this._getFlashStatus(d);this._updateInterface();this._trigger(a);break;case b.jPlayerVideo.event.play:this._seeked();this._updateButtons(!0);this._trigger(a);break;case b.jPlayerVideo.event.pause:this._updateButtons(!1);this._trigger(a);break;case b.jPlayerVideo.event.ended:this._updateButtons(!1);this._trigger(a);break;case b.jPlayerVideo.event.click:this._trigger(a);break;case b.jPlayerVideo.event.error:this.status.waitForLoad=
!0;this.status.waitForPlay=!0;this.status.video&&this.internal.flash.jq.css({width:"0px",height:"0px"});this._validString(this.status.media.poster)&&this.internal.poster.jq.show();this.css.jq.videoPlay.length&&this.status.video&&this.css.jq.videoPlay.show();this.status.video?this._flash_setVideo(this.status.media):this._flash_setAudio(this.status.media);this._updateButtons(!1);this._error({type:b.jPlayerVideo.error.URL,context:d.src,message:b.jPlayerVideo.errorMsg.URL,hint:b.jPlayerVideo.errorHint.URL});
break;case b.jPlayerVideo.event.seeking:this._seeking();this._trigger(a);break;case b.jPlayerVideo.event.seeked:this._seeked();this._trigger(a);break;case b.jPlayerVideo.event.ready:break;default:this._trigger(a)}return!1},_getFlashStatus:function(a){this.status.seekPercent=a.seekPercent;this.status.currentPercentRelative=a.currentPercentRelative;this.status.currentPercentAbsolute=a.currentPercentAbsolute;this.status.currentTime=a.currentTime;this.status.duration=a.duration;this.status.remaining=
a.duration-a.currentTime;this.status.videoWidth=a.videoWidth;this.status.videoHeight=a.videoHeight;this.status.readyState=4;this.status.networkState=0;this.status.playbackRate=1;this.status.ended=!1},_updateButtons:function(a){a===l?a=!this.status.paused:this.status.paused=!a;a?this.addStateClass("playing"):this.removeStateClass("playing");!this.status.noFullWindow&&this.options.fullWindow?this.addStateClass("fullScreen"):this.removeStateClass("fullScreen");this.options.loop?this.addStateClass("looped"):
this.removeStateClass("looped");this.css.jq.play.length&&this.css.jq.pause.length&&(a?(this.css.jq.play.hide(),this.css.jq.pause.show()):(this.css.jq.play.show(),this.css.jq.pause.hide()));this.css.jq.restoreScreen.length&&this.css.jq.fullScreen.length&&(this.status.noFullWindow?(this.css.jq.fullScreen.hide(),this.css.jq.restoreScreen.hide()):this.options.fullWindow?(this.css.jq.fullScreen.hide(),this.css.jq.restoreScreen.show()):(this.css.jq.fullScreen.show(),this.css.jq.restoreScreen.hide()));this.css.jq.repeat.length&&
this.css.jq.repeatOff.length&&(this.options.loop?(this.css.jq.repeat.hide(),this.css.jq.repeatOff.show()):(this.css.jq.repeat.show(),this.css.jq.repeatOff.hide()))},_updateInterface:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.width(this.status.seekPercent+"%");this.css.jq.playBar.length&&(this.options.smoothPlayBar?this.css.jq.playBar.stop().animate({width:this.status.currentPercentAbsolute+"%"},250,"linear"):this.css.jq.playBar.width(this.status.currentPercentRelative+"%"));var a;
this.css.jq.currentTime.length&&(a=this._convertTime(this.status.currentTime),a!==this.css.jq.currentTime.text()&&this.css.jq.currentTime.text(this._convertTime(this.status.currentTime)));a=this.status.duration;var b=this.status.remaining;this.css.jq.duration.length&&("string"===typeof this.status.media.duration?a=this.status.media.duration:("number"===typeof this.status.media.duration&&(a=this.status.media.duration,b=a-this.status.currentTime),a=this.options.remainingDuration?(0<b?"-":"")+this._convertTime(b):
this._convertTime(a)),a!==this.css.jq.duration.text()&&this.css.jq.duration.text(a))},_convertTime:e.prototype.time,_seeking:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.addClass("mdtc-clnplrv-seeking-bg");this.addStateClass("seeking")},_seeked:function(){this.css.jq.seekBar.length&&this.css.jq.seekBar.removeClass("mdtc-clnplrv-seeking-bg");this.removeStateClass("seeking")},_resetGate:function(){this.html.audio.gate=!1;this.html.video.gate=!1;this.aurora.gate=!1;this.flash.gate=!1},
_resetActive:function(){this.html.active=!1;this.aurora.active=!1;this.flash.active=!1},_escapeHtml:function(a){return a.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;").split('"').join("&quot;")},_qualifyURL:function(a){var b=document.createElement("div");b.innerHTML='<a href="'+this._escapeHtml(a)+'">x</a>';return b.firstChild.href},_absoluteMediaUrls:function(a){var d=this;b.each(a,function(b,f){f&&d.format[b]&&"data:"!==f.substr(0,5)&&(a[b]=d._qualifyURL(f))});return a},
addStateClass:function(a){this.ancestorJq.length&&this.ancestorJq.addClass(this.options.stateClass[a])},removeStateClass:function(a){this.ancestorJq.length&&this.ancestorJq.removeClass(this.options.stateClass[a])},setMedia:function(a){var d=this,c=!1,f=this.status.media.poster!==a.poster;this._resetMedia();this._resetGate();this._resetActive();this.androidFix.setMedia=!1;this.androidFix.play=!1;this.androidFix.pause=!1;a=this._absoluteMediaUrls(a);b.each(this.formats,function(f,e){var g="video"===
d.format[e].media;b.each(d.solutions,function(f,h){if(d[h].support[e]&&d._validString(a[e])){var k="html"===h,l="aurora"===h;g?(k?(d.html.video.gate=!0,d._html_setVideo(a),d.html.active=!0):(d.flash.gate=!0,d._flash_setVideo(a),d.flash.active=!0),d.css.jq.videoPlay.length&&d.css.jq.videoPlay.show(),d.status.video=!0):(k?(d.html.audio.gate=!0,d._html_setAudio(a),d.html.active=!0,b.jPlayerVideo.platform.android&&(d.androidFix.setMedia=!0)):l?(d.aurora.gate=!0,d._aurora_setAudio(a),d.aurora.active=!0):
(d.flash.gate=!0,d._flash_setAudio(a),d.flash.active=!0),d.css.jq.videoPlay.length&&d.css.jq.videoPlay.hide(),d.status.video=!1);c=!0;return!1}});if(c)return!1});c?(this.status.nativeVideoControls&&this.html.video.gate||!this._validString(a.poster)||(f?this.htmlElement.poster.src=a.poster:this.internal.poster.jq.show()),"string"===typeof a.title&&(this.css.jq.title.length&&this.css.jq.title.html(a.title),this.htmlElement.audio&&this.htmlElement.audio.setAttribute("title",a.title),this.htmlElement.video&&
this.htmlElement.video.setAttribute("title",a.title)),this.status.srcSet=!0,this.status.media=b.extend({},a),this._updateButtons(!1),this._updateInterface(),this._trigger(b.jPlayerVideo.event.setmedia)):this._error({type:b.jPlayerVideo.error.NO_SUPPORT,context:"{supplied:'"+this.options.supplied+"'}",message:b.jPlayerVideo.errorMsg.NO_SUPPORT,hint:b.jPlayerVideo.errorHint.NO_SUPPORT})},_resetMedia:function(){this._resetStatus();this._updateButtons(!1);this._updateInterface();this._seeked();this.internal.poster.jq.hide();
clearTimeout(this.internal.htmlDlyCmdId);this.html.active?this._html_resetMedia():this.aurora.active?this._aurora_resetMedia():this.flash.active&&this._flash_resetMedia()},clearMedia:function(){this._resetMedia();this.html.active?this._html_clearMedia():this.aurora.active?this._aurora_clearMedia():this.flash.active&&this._flash_clearMedia();this._resetGate();this._resetActive()},load:function(){this.status.srcSet?this.html.active?this._html_load():this.aurora.active?this._aurora_load():this.flash.active&&
this._flash_load():this._urlNotSetError("load")},focus:function(){this.options.keyEnabled&&(b.jPlayerVideo.focus=this)},play:function(a){"object"===typeof a&&this.options.useStateClassSkin&&!this.status.paused?this.pause(a):(a="number"===typeof a?a:NaN,this.status.srcSet?(this.focus(),this.html.active?this._html_play(a):this.aurora.active?this._aurora_play(a):this.flash.active&&this._flash_play(a)):this._urlNotSetError("play"))},videoPlay:function(){this.play()},pause:function(a){a="number"===typeof a?
a:NaN;this.status.srcSet?this.html.active?this._html_pause(a):this.aurora.active?this._aurora_pause(a):this.flash.active&&this._flash_pause(a):this._urlNotSetError("pause")},tellOthers:function(a,d){var c=this,f="function"===typeof d,e=Array.prototype.slice.call(arguments);"string"===typeof a&&(f&&e.splice(1,1),b.jPlayerVideo.prototype.destroyRemoved(),b.each(this.instances,function(){c.element!==this&&(f&&!d.call(this.data("jPlayerVideo"),c)||this.jPlayerVideo.apply(this,e))}))},pauseOthers:function(a){this.tellOthers("pause",
function(){return this.status.srcSet},a)},stop:function(){this.status.srcSet?this.html.active?this._html_pause(0):this.aurora.active?this._aurora_pause(0):this.flash.active&&this._flash_pause(0):this._urlNotSetError("stop")},playHead:function(a){a=this._limitValue(a,0,100);this.status.srcSet?this.html.active?this._html_playHead(a):this.aurora.active?this._aurora_playHead(a):this.flash.active&&this._flash_playHead(a):this._urlNotSetError("playHead")},_muted:function(a){this.mutedWorker(a);this.options.globalVolume&&
this.tellOthers("mutedWorker",function(){return this.options.globalVolume},a)},mutedWorker:function(a){this.options.muted=a;this.html.used&&this._html_setProperty("muted",a);this.aurora.used&&this._aurora_mute(a);this.flash.used&&this._flash_mute(a);this.html.video.gate||this.html.audio.gate||(this._updateMute(a),this._updateVolume(this.options.volume),this._trigger(b.jPlayerVideo.event.volumechange))},mute:function(a){"object"===typeof a&&this.options.useStateClassSkin&&this.options.muted?this._muted(!1):
(a=a===l?!0:!!a,this._muted(a))},unmute:function(a){a=a===l?!0:!!a;this._muted(!a)},_updateMute:function(a){a===l&&(a=this.options.muted);a?this.addStateClass("muted"):this.removeStateClass("muted");this.css.jq.mute.length&&this.css.jq.unmute.length&&(this.status.noVolume?(this.css.jq.mute.hide(),this.css.jq.unmute.hide()):a?(this.css.jq.mute.hide(),this.css.jq.unmute.show()):(this.css.jq.mute.show(),this.css.jq.unmute.hide()))},volume:function(a){this.volumeWorker(a);this.options.globalVolume&&this.tellOthers("volumeWorker",
function(){return this.options.globalVolume},a)},volumeWorker:function(a){a=this._limitValue(a,0,1);this.options.volume=a;this.html.used&&this._html_setProperty("volume",a);this.aurora.used&&this._aurora_volume(a);this.flash.used&&this._flash_volume(a);this.html.video.gate||this.html.audio.gate||(this._updateVolume(a),this._trigger(b.jPlayerVideo.event.volumechange))},volumeBar:function(a){if(this.css.jq.volumeBar.length){var d=b(a.currentTarget),c=d.offset(),e=a.pageX-c.left,g=d.width();a=d.height()-
a.pageY+c.top;d=d.height();this.options.verticalVolume?this.volume(a/d):this.volume(e/g)}this.options.muted&&this._muted(!1)},_updateVolume:function(a){a===l&&(a=this.options.volume);a=this.options.muted?0:a;this.status.noVolume?(this.addStateClass("noVolume"),this.css.jq.volumeBar.length&&this.css.jq.volumeBar.hide(),this.css.jq.volumeBarValue.length&&this.css.jq.volumeBarValue.hide(),this.css.jq.volumeMax.length&&this.css.jq.volumeMax.hide()):(this.removeStateClass("noVolume"),this.css.jq.volumeBar.length&&
this.css.jq.volumeBar.show(),this.css.jq.volumeBarValue.length&&(this.css.jq.volumeBarValue.show(),this.css.jq.volumeBarValue[this.options.verticalVolume?"height":"width"](100*a+"%")),this.css.jq.volumeMax.length&&this.css.jq.volumeMax.show())},volumeMax:function(){this.volume(1);this.options.muted&&this._muted(!1)},_cssSelectorAncestor:function(a){var d=this;this.options.cssSelectorAncestor=a;this._removeUiClass();this.ancestorJq=a?b(a):[];a&&1!==this.ancestorJq.length&&this._warning({type:b.jPlayerVideo.warning.CSS_SELECTOR_COUNT,
context:a,message:b.jPlayerVideo.warningMsg.CSS_SELECTOR_COUNT+this.ancestorJq.length+" found for cssSelectorAncestor.",hint:b.jPlayerVideo.warningHint.CSS_SELECTOR_COUNT});this._addUiClass();b.each(this.options.cssSelector,function(a,b){d._cssSelector(a,b)});this._updateInterface();this._updateButtons();this._updateAutohide();this._updateVolume();this._updateMute()},_cssSelector:function(a,d){var c=this;"string"===typeof d?b.jPlayerVideo.prototype.options.cssSelector[a]?(this.css.jq[a]&&this.css.jq[a].length&&
this.css.jq[a].unbind(".jPlayerVideo"),this.options.cssSelector[a]=d,this.css.cs[a]=this.options.cssSelectorAncestor+" "+d,this.css.jq[a]=d?b(this.css.cs[a]):[],this.css.jq[a].length&&this[a]&&this.css.jq[a].bind("click.jPlayerVideo",function(d){d.preventDefault();c[a](d);c.options.autoBlur?b(this).blur():b(this).focus()}),d&&1!==this.css.jq[a].length&&this._warning({type:b.jPlayerVideo.warning.CSS_SELECTOR_COUNT,context:this.css.cs[a],message:b.jPlayerVideo.warningMsg.CSS_SELECTOR_COUNT+this.css.jq[a].length+
" found for "+a+" method.",hint:b.jPlayerVideo.warningHint.CSS_SELECTOR_COUNT})):this._warning({type:b.jPlayerVideo.warning.CSS_SELECTOR_METHOD,context:a,message:b.jPlayerVideo.warningMsg.CSS_SELECTOR_METHOD,hint:b.jPlayerVideo.warningHint.CSS_SELECTOR_METHOD}):this._warning({type:b.jPlayerVideo.warning.CSS_SELECTOR_STRING,context:d,message:b.jPlayerVideo.warningMsg.CSS_SELECTOR_STRING,hint:b.jPlayerVideo.warningHint.CSS_SELECTOR_STRING})},duration:function(a){this.options.toggleDuration&&(this.options.captureDuration&&
a.stopPropagation(),this._setOption("remainingDuration",!this.options.remainingDuration))},seekBar:function(a){if(this.css.jq.seekBar.length){var d=b(a.currentTarget),c=d.offset();a=a.pageX-c.left;d=d.width();this.playHead(100*a/d)}},playbackRate:function(a){this._setOption("playbackRate",a)},playbackRateBar:function(a){if(this.css.jq.playbackRateBar.length){var d=b(a.currentTarget),c=d.offset(),e=a.pageX-c.left,g=d.width();a=d.height()-a.pageY+c.top;d=d.height();this.playbackRate((this.options.verticalPlaybackRate?
a/d:e/g)*(this.options.maxPlaybackRate-this.options.minPlaybackRate)+this.options.minPlaybackRate)}},_updatePlaybackRate:function(){var a=(this.options.playbackRate-this.options.minPlaybackRate)/(this.options.maxPlaybackRate-this.options.minPlaybackRate);this.status.playbackRateEnabled?(this.css.jq.playbackRateBar.length&&this.css.jq.playbackRateBar.show(),this.css.jq.playbackRateBarValue.length&&(this.css.jq.playbackRateBarValue.show(),this.css.jq.playbackRateBarValue[this.options.verticalPlaybackRate?
"height":"width"](100*a+"%"))):(this.css.jq.playbackRateBar.length&&this.css.jq.playbackRateBar.hide(),this.css.jq.playbackRateBarValue.length&&this.css.jq.playbackRateBarValue.hide())},repeat:function(a){"object"===typeof a&&this.options.useStateClassSkin&&this.options.loop?this._loop(!1):this._loop(!0)},repeatOff:function(){this._loop(!1)},_loop:function(a){this.options.loop!==a&&(this.options.loop=a,this._updateButtons(),this._trigger(b.jPlayerVideo.event.repeat))},option:function(a,d){var c=a;
if(0===arguments.length)return b.extend(!0,{},this.options);if("string"===typeof a){var e=a.split(".");if(d===l){for(var c=b.extend(!0,{},this.options),g=0;g<e.length;g++)if(c[e[g]]!==l)c=c[e[g]];else return this._warning({type:b.jPlayerVideo.warning.OPTION_KEY,context:a,message:b.jPlayerVideo.warningMsg.OPTION_KEY,hint:b.jPlayerVideo.warningHint.OPTION_KEY}),l;return c}for(var g=c={},h=0;h<e.length;h++)h<e.length-1?(g[e[h]]={},g=g[e[h]]):g[e[h]]=d}this._setOptions(c);return this},_setOptions:function(a){var d=
this;b.each(a,function(a,b){d._setOption(a,b)});return this},_setOption:function(a,d){var c=this;switch(a){case "volume":this.volume(d);break;case "muted":this._muted(d);break;case "globalVolume":this.options[a]=d;break;case "cssSelectorAncestor":this._cssSelectorAncestor(d);break;case "cssSelector":b.each(d,function(a,b){c._cssSelector(a,b)});break;case "playbackRate":this.options[a]=d=this._limitValue(d,this.options.minPlaybackRate,this.options.maxPlaybackRate);this.html.used&&this._html_setProperty("playbackRate",
d);this._updatePlaybackRate();break;case "defaultPlaybackRate":this.options[a]=d=this._limitValue(d,this.options.minPlaybackRate,this.options.maxPlaybackRate);this.html.used&&this._html_setProperty("defaultPlaybackRate",d);this._updatePlaybackRate();break;case "minPlaybackRate":this.options[a]=d=this._limitValue(d,.1,this.options.maxPlaybackRate-.1);this._updatePlaybackRate();break;case "maxPlaybackRate":this.options[a]=d=this._limitValue(d,this.options.minPlaybackRate+.1,16);this._updatePlaybackRate();
break;case "fullScreen":if(this.options[a]!==d){var e=b.jPlayerVideo.nativeFeatures.fullscreen.used.webkitVideo;if(!e||e&&!this.status.waitForPlay)e||(this.options[a]=d),d?this._requestFullscreen():this._exitFullscreen(),e||this._setOption("fullWindow",d)}break;case "fullWindow":this.options[a]!==d&&(this._removeUiClass(),this.options[a]=d,this._refreshSize());break;case "size":this.options.fullWindow||this.options[a].cssClass===d.cssClass||this._removeUiClass();this.options[a]=b.extend({},this.options[a],
d);this._refreshSize();break;case "sizeFull":this.options.fullWindow&&this.options[a].cssClass!==d.cssClass&&this._removeUiClass();this.options[a]=b.extend({},this.options[a],d);this._refreshSize();break;case "autohide":this.options[a]=b.extend({},this.options[a],d);this._updateAutohide();break;case "loop":this._loop(d);break;case "remainingDuration":this.options[a]=d;this._updateInterface();break;case "toggleDuration":this.options[a]=d;break;case "nativeVideoControls":this.options[a]=b.extend({},
this.options[a],d);this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this._restrictNativeVideoControls();this._updateNativeVideoControls();break;case "noFullWindow":this.options[a]=b.extend({},this.options[a],d);this.status.nativeVideoControls=this._uaBlocklist(this.options.nativeVideoControls);this.status.noFullWindow=this._uaBlocklist(this.options.noFullWindow);this._restrictNativeVideoControls();this._updateButtons();break;case "noVolume":this.options[a]=b.extend({},
this.options[a],d);this.status.noVolume=this._uaBlocklist(this.options.noVolume);this._updateVolume();this._updateMute();break;case "emulateHtml":this.options[a]!==d&&((this.options[a]=d)?this._emulateHtmlBridge():this._destroyHtmlBridge());break;case "timeFormat":this.options[a]=b.extend({},this.options[a],d);break;case "keyEnabled":this.options[a]=d;d||this!==b.jPlayerVideo.focus||(b.jPlayerVideo.focus=null);break;case "keyBindings":this.options[a]=b.extend(!0,{},this.options[a],d);break;case "audioFullScreen":this.options[a]=
d;break;case "autoBlur":this.options[a]=d}return this},_refreshSize:function(){this._setSize();this._addUiClass();this._updateSize();this._updateButtons();this._updateAutohide();this._trigger(b.jPlayerVideo.event.resize)},_setSize:function(){this.options.fullWindow?(this.status.width=this.options.sizeFull.width,this.status.height=this.options.sizeFull.height,this.status.cssClass=this.options.sizeFull.cssClass):(this.status.width=this.options.size.width,this.status.height=this.options.size.height,
this.status.cssClass=this.options.size.cssClass);this.element.css({width:this.status.width,height:this.status.height})},_addUiClass:function(){this.ancestorJq.length&&this.ancestorJq.addClass(this.status.cssClass)},_removeUiClass:function(){this.ancestorJq.length&&this.ancestorJq.removeClass(this.status.cssClass)},_updateSize:function(){this.internal.poster.jq.css({width:this.status.width,height:this.status.height});!this.status.waitForPlay&&this.html.active&&this.status.video||this.html.video.available&&
this.html.used&&this.status.nativeVideoControls?this.internal.video.jq.css({width:this.status.width,height:this.status.height}):!this.status.waitForPlay&&this.flash.active&&this.status.video&&this.internal.flash.jq.css({width:this.status.width,height:this.status.height})},_updateAutohide:function(){var a=this,b=function(b){var d=!1,e;"undefined"!==typeof a.internal.mouse?(d=a.internal.mouse.x-b.pageX,e=a.internal.mouse.y-b.pageY,d=0<Math.floor(d)||0<Math.floor(e)):d=!0;a.internal.mouse={x:b.pageX,
y:b.pageY};d&&a.css.jq.gui.fadeIn(a.options.autohide.fadeIn,function(){clearTimeout(a.internal.autohideId);a.internal.autohideId=setTimeout(function(){a.css.jq.gui.fadeOut(a.options.autohide.fadeOut)},a.options.autohide.hold)})};this.css.jq.gui.length&&(this.css.jq.gui.stop(!0,!0),clearTimeout(this.internal.autohideId),delete this.internal.mouse,this.element.unbind(".jPlayerVideoAutohide"),this.css.jq.gui.unbind(".jPlayerVideoAutohide"),this.status.nativeVideoControls?this.css.jq.gui.hide():this.options.fullWindow&&
this.options.autohide.full||!this.options.fullWindow&&this.options.autohide.restored?(this.element.bind("mousemove.jPlayerVideo.jPlayerVideoAutohide",b),this.css.jq.gui.bind("mousemove.jPlayerVideo.jPlayerVideoAutohide",b),this.css.jq.gui.hide()):this.css.jq.gui.show())},fullScreen:function(a){"object"===typeof a&&this.options.useStateClassSkin&&this.options.fullScreen?this._setOption("fullScreen",!1):this._setOption("fullScreen",!0)},restoreScreen:function(){this._setOption("fullScreen",!1)},_fullscreenAddEventListeners:function(){var a=
this,d=b.jPlayerVideo.nativeFeatures.fullscreen;d.api.fullscreenEnabled&&d.event.fullscreenchange&&("function"!==typeof this.internal.fullscreenchangeHandler&&(this.internal.fullscreenchangeHandler=function(){a._fullscreenchange()}),document.addEventListener(d.event.fullscreenchange,this.internal.fullscreenchangeHandler,!1))},_fullscreenRemoveEventListeners:function(){var a=b.jPlayerVideo.nativeFeatures.fullscreen;this.internal.fullscreenchangeHandler&&document.removeEventListener(a.event.fullscreenchange,
this.internal.fullscreenchangeHandler,!1)},_fullscreenchange:function(){this.options.fullScreen&&!b.jPlayerVideo.nativeFeatures.fullscreen.api.fullscreenElement()&&this._setOption("fullScreen",!1)},_requestFullscreen:function(){var a=this.ancestorJq.length?this.ancestorJq[0]:this.element[0],d=b.jPlayerVideo.nativeFeatures.fullscreen;d.used.webkitVideo&&(a=this.htmlElement.video);d.api.fullscreenEnabled&&d.api.requestFullscreen(a)},_exitFullscreen:function(){var a=b.jPlayerVideo.nativeFeatures.fullscreen,
d;a.used.webkitVideo&&(d=this.htmlElement.video);a.api.fullscreenEnabled&&a.api.exitFullscreen(d)},_html_initMedia:function(a){var d=b(this.htmlElement.media).empty();b.each(a.track||[],function(a,b){var e=document.createElement("track");e.setAttribute("kind",b.kind?b.kind:"");e.setAttribute("src",b.src?b.src:"");e.setAttribute("srclang",b.srclang?b.srclang:"");e.setAttribute("label",b.label?b.label:"");b.def&&e.setAttribute("default",b.def);d.append(e)});this.htmlElement.media.src=this.status.src;
"none"!==this.options.preload&&this._html_load();this._trigger(b.jPlayerVideo.event.timeupdate)},_html_setFormat:function(a){var d=this;b.each(this.formats,function(b,e){if(d.html.support[e]&&a[e])return d.status.src=a[e],d.status.format[e]=!0,d.status.formatType=e,!1})},_html_setAudio:function(a){this._html_setFormat(a);this.htmlElement.media=this.htmlElement.audio;this._html_initMedia(a)},_html_setVideo:function(a){this._html_setFormat(a);this.status.nativeVideoControls&&(this.htmlElement.video.poster=
this._validString(a.poster)?a.poster:"");this.htmlElement.media=this.htmlElement.video;this._html_initMedia(a)},_html_resetMedia:function(){this.htmlElement.media&&(this.htmlElement.media.id!==this.internal.video.id||this.status.nativeVideoControls||this.internal.video.jq.css({width:"0px",height:"0px"}),this.htmlElement.media.pause())},_html_clearMedia:function(){this.htmlElement.media&&(this.htmlElement.media.src="about:blank",this.htmlElement.media.load())},_html_load:function(){this.status.waitForLoad&&
(this.status.waitForLoad=!1,this.htmlElement.media.load());clearTimeout(this.internal.htmlDlyCmdId)},_html_play:function(a){var b=this,c=this.htmlElement.media;this.androidFix.pause=!1;this._html_load();if(this.androidFix.setMedia)this.androidFix.play=!0,this.androidFix.time=a;else if(isNaN(a))c.play();else{this.internal.cmdsIgnored&&c.play();try{if(!c.seekable||"object"===typeof c.seekable&&0<c.seekable.length)c.currentTime=a,c.play();else throw 1;}catch(e){this.internal.htmlDlyCmdId=setTimeout(function(){b.play(a)},
250);return}}this._html_checkWaitForPlay()},_html_pause:function(a){var b=this,c=this.htmlElement.media;this.androidFix.play=!1;0<a?this._html_load():clearTimeout(this.internal.htmlDlyCmdId);c.pause();if(this.androidFix.setMedia)this.androidFix.pause=!0,this.androidFix.time=a;else if(!isNaN(a))try{if(!c.seekable||"object"===typeof c.seekable&&0<c.seekable.length)c.currentTime=a;else throw 1;}catch(e){this.internal.htmlDlyCmdId=setTimeout(function(){b.pause(a)},250);return}0<a&&this._html_checkWaitForPlay()},
_html_playHead:function(a){var b=this,c=this.htmlElement.media;this._html_load();try{if("object"===typeof c.seekable&&0<c.seekable.length)c.currentTime=a*c.seekable.end(c.seekable.length-1)/100;else if(0<c.duration&&!isNaN(c.duration))c.currentTime=a*c.duration/100;else throw"e";}catch(e){this.internal.htmlDlyCmdId=setTimeout(function(){b.playHead(a)},250);return}this.status.waitForLoad||this._html_checkWaitForPlay()},_html_checkWaitForPlay:function(){this.status.waitForPlay&&(this.status.waitForPlay=
!1,this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide(),this.status.video&&(this.internal.poster.jq.hide(),this.internal.video.jq.css({width:this.status.width,height:this.status.height})))},_html_setProperty:function(a,b){this.html.audio.available&&(this.htmlElement.audio[a]=b);this.html.video.available&&(this.htmlElement.video[a]=b)},_aurora_setAudio:function(a){var d=this;b.each(this.formats,function(b,e){if(d.aurora.support[e]&&a[e])return d.status.src=a[e],d.status.format[e]=!0,d.status.formatType=
e,!1});this.aurora.player=new AV.Player.fromURL(this.status.src);this._addAuroraEventListeners(this.aurora.player,this.aurora);"auto"===this.options.preload&&(this._aurora_load(),this.status.waitForLoad=!1)},_aurora_resetMedia:function(){this.aurora.player&&this.aurora.player.stop()},_aurora_clearMedia:function(){},_aurora_load:function(){this.status.waitForLoad&&(this.status.waitForLoad=!1,this.aurora.player.preload())},_aurora_play:function(a){this.status.waitForLoad||isNaN(a)||this.aurora.player.seek(a);
this.aurora.player.playing||this.aurora.player.play();this.status.waitForLoad=!1;this._aurora_checkWaitForPlay();this._updateButtons(!0);this._trigger(b.jPlayerVideo.event.play)},_aurora_pause:function(a){isNaN(a)||this.aurora.player.seek(1E3*a);this.aurora.player.pause();0<a&&this._aurora_checkWaitForPlay();this._updateButtons(!1);this._trigger(b.jPlayerVideo.event.pause)},_aurora_playHead:function(a){0<this.aurora.player.duration&&this.aurora.player.seek(a*this.aurora.player.duration/100);this.status.waitForLoad||
this._aurora_checkWaitForPlay()},_aurora_checkWaitForPlay:function(){this.status.waitForPlay&&(this.status.waitForPlay=!1)},_aurora_volume:function(a){this.aurora.player.volume=100*a},_aurora_mute:function(a){a?(this.aurora.properties.lastvolume=this.aurora.player.volume,this.aurora.player.volume=0):this.aurora.player.volume=this.aurora.properties.lastvolume;this.aurora.properties.muted=a},_flash_setAudio:function(a){var d=this;try{b.each(this.formats,function(b,e){if(d.flash.support[e]&&a[e]){switch(e){case "m4a":case "fla":d._getMovie().fl_setAudio_m4a(a[e]);
break;case "mp3":d._getMovie().fl_setAudio_mp3(a[e]);break;case "rtmpa":d._getMovie().fl_setAudio_rtmp(a[e])}d.status.src=a[e];d.status.format[e]=!0;d.status.formatType=e;return!1}}),"auto"===this.options.preload&&(this._flash_load(),this.status.waitForLoad=!1)}catch(c){this._flashError(c)}},_flash_setVideo:function(a){var d=this;try{b.each(this.formats,function(b,e){if(d.flash.support[e]&&a[e]){switch(e){case "m4v":case "flv":d._getMovie().fl_setVideo_m4v(a[e]);break;case "rtmpv":d._getMovie().fl_setVideo_rtmp(a[e])}d.status.src=
a[e];d.status.format[e]=!0;d.status.formatType=e;return!1}}),"auto"===this.options.preload&&(this._flash_load(),this.status.waitForLoad=!1)}catch(c){this._flashError(c)}},_flash_resetMedia:function(){this.internal.flash.jq.css({width:"0px",height:"0px"});this._flash_pause(NaN)},_flash_clearMedia:function(){try{this._getMovie().fl_clearMedia()}catch(a){this._flashError(a)}},_flash_load:function(){try{this._getMovie().fl_load()}catch(a){this._flashError(a)}this.status.waitForLoad=!1},_flash_play:function(a){try{this._getMovie().fl_play(a)}catch(b){this._flashError(b)}this.status.waitForLoad=
!1;this._flash_checkWaitForPlay()},_flash_pause:function(a){try{this._getMovie().fl_pause(a)}catch(b){this._flashError(b)}0<a&&(this.status.waitForLoad=!1,this._flash_checkWaitForPlay())},_flash_playHead:function(a){try{this._getMovie().fl_play_head(a)}catch(b){this._flashError(b)}this.status.waitForLoad||this._flash_checkWaitForPlay()},_flash_checkWaitForPlay:function(){this.status.waitForPlay&&(this.status.waitForPlay=!1,this.css.jq.videoPlay.length&&this.css.jq.videoPlay.hide(),this.status.video&&
(this.internal.poster.jq.hide(),this.internal.flash.jq.css({width:this.status.width,height:this.status.height})))},_flash_volume:function(a){try{this._getMovie().fl_volume(a)}catch(b){this._flashError(b)}},_flash_mute:function(a){try{this._getMovie().fl_mute(a)}catch(b){this._flashError(b)}},_getMovie:function(){return document[this.internal.flash.id]},_getFlashPluginVersion:function(){var a=0,b;if(window.ActiveXObject)try{b=new ActiveXObject("ShockwaveFlash.ShockwaveFlash");var c=b.GetVariable("$version");
c&&(c=c.split(" ")[1].split(","),a=parseInt(c[0],10)+"."+parseInt(c[1],10))}catch(e){}else navigator.plugins&&0<navigator.mimeTypes.length&&(b=navigator.plugins["Shockwave Flash"])&&(a=navigator.plugins["Shockwave Flash"].description.replace(/.*\s(\d+\.\d+).*/,"$1"));return 1*a},_checkForFlash:function(a){var b=!1;this._getFlashPluginVersion()>=a&&(b=!0);return b},_validString:function(a){return a&&"string"===typeof a},_limitValue:function(a,b,c){return a<b?b:a>c?c:a},_urlNotSetError:function(a){this._error({type:b.jPlayerVideo.error.URL_NOT_SET,
context:a,message:b.jPlayerVideo.errorMsg.URL_NOT_SET,hint:b.jPlayerVideo.errorHint.URL_NOT_SET})},_flashError:function(a){var d;d=this.internal.ready?"FLASH_DISABLED":"FLASH";this._error({type:b.jPlayerVideo.error[d],context:this.internal.flash.swf,message:b.jPlayerVideo.errorMsg[d]+a.message,hint:b.jPlayerVideo.errorHint[d]});this.internal.flash.jq.css({width:"1px",height:"1px"})},_error:function(a){this._trigger(b.jPlayerVideo.event.error,a);this.options.errorAlerts&&this._alert("Error!"+(a.message?
"\n"+a.message:"")+(a.hint?"\n"+a.hint:"")+"\nContext: "+a.context)},_warning:function(a){this._trigger(b.jPlayerVideo.event.warning,l,a);this.options.warningAlerts&&this._alert("Warning!"+(a.message?"\n"+a.message:"")+(a.hint?"\n"+a.hint:"")+"\nContext: "+a.context)},_alert:function(a){a="jPlayerVideo "+this.version.script+" : id='"+this.internal.self.id+"' : "+a;this.options.consoleAlerts?window.console&&window.console.log&&window.console.log(a):alert(a)},_emulateHtmlBridge:function(){var a=this;
b.each(b.jPlayerVideo.emulateMethods.split(/\s+/g),function(b,c){a.internal.domNode[c]=function(b){a[c](b)}});b.each(b.jPlayerVideo.event,function(d,c){var e=!0;b.each(b.jPlayerVideo.reservedEvent.split(/\s+/g),function(a,b){if(b===d)return e=!1});e&&a.element.bind(c+".jPlayerVideo.jPlayerVideoHtml",function(){a._emulateHtmlUpdate();var b=document.createEvent("Event");b.initEvent(d,!1,!0);a.internal.domNode.dispatchEvent(b)})})},_emulateHtmlUpdate:function(){var a=this;b.each(b.jPlayerVideo.emulateStatus.split(/\s+/g),
function(b,c){a.internal.domNode[c]=a.status[c]});b.each(b.jPlayerVideo.emulateOptions.split(/\s+/g),function(b,c){a.internal.domNode[c]=a.options[c]})},_destroyHtmlBridge:function(){var a=this;this.element.unbind(".jPlayerVideoHtml");b.each((b.jPlayerVideo.emulateMethods+" "+b.jPlayerVideo.emulateStatus+" "+b.jPlayerVideo.emulateOptions).split(/\s+/g),function(b,c){delete a.internal.domNode[c]})}};b.jPlayerVideo.error={FLASH:"e_flash",FLASH_DISABLED:"e_flash_disabled",NO_SOLUTION:"e_no_solution",
NO_SUPPORT:"e_no_support",URL:"e_url",URL_NOT_SET:"e_url_not_set",VERSION:"e_version"};b.jPlayerVideo.errorMsg={FLASH:"jPlayerVideo's Flash fallback is not configured correctly, or a command was issued before the jPlayerVideo Ready event. Details: ",FLASH_DISABLED:"jPlayerVideo's Flash fallback has been disabled by the browser due to the CSS rules you have used. Details: ",NO_SOLUTION:"No solution can be found by jPlayerVideo in this browser. Neither HTML nor Flash can be used.",NO_SUPPORT:"It is not possible to play any media format provided in setMedia() on this browser using your current options.",
URL:"Media URL could not be loaded.",URL_NOT_SET:"Attempt to issue media playback commands, while no media url is set.",VERSION:"jPlayerVideo "+b.jPlayerVideo.prototype.version.script+" needs Jplayer.swf version "+b.jPlayerVideo.prototype.version.needFlash+" but found "};b.jPlayerVideo.errorHint={FLASH:"Check your swfPath option and that Jplayer.swf is there.",FLASH_DISABLED:"Check that you have not display:none; the jPlayerVideo entity or any ancestor.",NO_SOLUTION:"Review the jPlayerVideo options: support and supplied.",
NO_SUPPORT:"Video or audio formats defined in the supplied option are missing.",URL:"Check media URL is valid.",URL_NOT_SET:"Use setMedia() to set the media URL.",VERSION:"Update jPlayerVideo files."};b.jPlayerVideo.warning={CSS_SELECTOR_COUNT:"e_css_selector_count",CSS_SELECTOR_METHOD:"e_css_selector_method",CSS_SELECTOR_STRING:"e_css_selector_string",OPTION_KEY:"e_option_key"};b.jPlayerVideo.warningMsg={CSS_SELECTOR_COUNT:"The number of css selectors found did not equal one: ",CSS_SELECTOR_METHOD:"The methodName given in jPlayerVideo('cssSelector') is not a valid jPlayerVideo method.",
CSS_SELECTOR_STRING:"The methodCssSelector given in jPlayerVideo('cssSelector') is not a String or is empty.",OPTION_KEY:"The option requested in jPlayerVideo('option') is undefined."};b.jPlayerVideo.warningHint={CSS_SELECTOR_COUNT:"Check your css selector and the ancestor.",CSS_SELECTOR_METHOD:"Check your method name.",CSS_SELECTOR_STRING:"Check your css selector is a string.",OPTION_KEY:"Check your option name."}});
(function(b,l){jPlayerVideoPlaylist=function(e,h,k){var g=this;this.current=0;this.removing=this.shuffled=this.loop=!1;this.cssSelector=b.extend({},this._cssSelector,e);this.options=b.extend(!0,{keyBindings:{next:{key:221,fn:function(){g.next()}},previous:{key:219,fn:function(){g.previous()}},shuffle:{key:83,fn:function(){g.shuffle()}}},stateClass:{shuffled:"mdtc-clnplrv-state-shuffled"}},this._options,k);this.playlist=[];this.original=[];this._initPlaylist(h);this.cssSelector.details=this.cssSelector.cssSelectorAncestor+
" .mdtc-clnplrv-details";this.cssSelector.playlist=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-playlist";this.cssSelector.next=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-next";this.cssSelector.previous=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-previous";this.cssSelector.shuffle=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-shuffle";this.cssSelector.shuffleOff=this.cssSelector.cssSelectorAncestor+" .mdtc-clnplrv-shuffle-off";this.options.cssSelectorAncestor=this.cssSelector.cssSelectorAncestor;
this.options.repeat=function(a){g.loop=a.jPlayerVideo.options.loop};b(this.cssSelector.jPlayerVideo).bind(b.jPlayerVideo.event.ready,function(){g._init()});b(this.cssSelector.jPlayerVideo).bind(b.jPlayerVideo.event.ended,function(){g.next()});b(this.cssSelector.jPlayerVideo).bind(b.jPlayerVideo.event.play,function(){b(this).jPlayerVideo("pauseOthers")});b(this.cssSelector.jPlayerVideo).bind(b.jPlayerVideo.event.resize,function(a){a.jPlayerVideo.options.fullScreen?b(g.cssSelector.details).show():b(g.cssSelector.details).hide()});
b(this.cssSelector.previous).click(function(a){a.preventDefault();g.previous();g.blur(this)});b(this.cssSelector.next).click(function(a){a.preventDefault();g.next();g.blur(this)});b(this.cssSelector.shuffle).click(function(a){a.preventDefault();g.shuffled&&b(g.cssSelector.jPlayerVideo).jPlayerVideo("option","useStateClassSkin")?g.shuffle(!1):g.shuffle(!0);g.blur(this)});b(this.cssSelector.shuffleOff).click(function(a){a.preventDefault();g.shuffle(!1);g.blur(this)}).hide();this.options.fullScreen||
b(this.cssSelector.details).hide();b(this.cssSelector.playlist+" ul").empty();this._createItemHandlers();b(this.cssSelector.jPlayerVideo).jPlayerVideo(this.options)};jPlayerVideoPlaylist.prototype={_cssSelector:{jPlayerVideo:"#jquery_jplayer_1",cssSelectorAncestor:"#jp_video_container_1"},_options:{playlistOptions:{autoPlay:!1,loopOnPrevious:!1,shuffleOnLoop:!0,enableRemoveControls:!1,displayTime:"slow",addTime:"fast",removeTime:"fast",shuffleTime:"slow",itemClass:"mdtc-clnplrv-playlist-item",freeGroupClass:"mdtc-clnplrv-free-media",
freeItemClass:"mdtc-clnplrv-playlist-item-free",removeItemClass:"mdtc-clnplrv-playlist-item-remove"}},option:function(b,h){if(h===l)return this.options.playlistOptions[b];this.options.playlistOptions[b]=h;switch(b){case "enableRemoveControls":this._updateControls();break;case "itemClass":case "freeGroupClass":case "freeItemClass":case "removeItemClass":this._refresh(!0),this._createItemHandlers()}return this},_init:function(){var b=this;this._refresh(function(){b.options.playlistOptions.autoPlay?
b.play(b.current):b.select(b.current)})},_initPlaylist:function(e){this.current=0;this.removing=this.shuffled=!1;this.original=b.extend(!0,[],e);this._originalPlaylist()},_originalPlaylist:function(){var e=this;this.playlist=[];b.each(this.original,function(b){e.playlist[b]=e.original[b]})},_refresh:function(e){var h=this;if(e&&!b.isFunction(e))b(this.cssSelector.playlist+" ul").empty(),b.each(this.playlist,function(e){b(h.cssSelector.playlist+" ul").append(h._createListItem(h.playlist[e]))}),this._updateControls();
else{var k=b(this.cssSelector.playlist+" ul").children().length?this.options.playlistOptions.displayTime:0;b(this.cssSelector.playlist+" ul").slideUp(k,function(){var g=b(this);b(this).empty();b.each(h.playlist,function(a){g.append(h._createListItem(h.playlist[a]))});h._updateControls();b.isFunction(e)&&e();h.playlist.length?b(this).slideDown(h.options.playlistOptions.displayTime):b(this).show()})}},_createListItem:function(e){var h=this,k="<li><div>",k=k+("<a href='javascript:;' class='"+this.options.playlistOptions.removeItemClass+
"'>&times;</a>");if(e.free){var g=!0,k=k+("<span class='"+this.options.playlistOptions.freeGroupClass+"'>(");b.each(e,function(a,d){b.jPlayerVideo.prototype.format[a]&&(g?g=!1:k+=" | ",k+="<a class='"+h.options.playlistOptions.freeItemClass+"' href='"+d+"' tabindex='-1'>"+a+"</a>")});k+=")</span>"}k+="<span href='javascript:;' class='"+this.options.playlistOptions.itemClass+"' tabindex='0'>"+e.title+(e.artist?" <span class='mdtc-clnplrv-artist'>by "+e.artist+"</span>":"")+"</span>";return k+="</div></li>"},
_createItemHandlers:function(){var e=this;b(this.cssSelector.playlist).off("click","span."+this.options.playlistOptions.itemClass).on("click","span."+this.options.playlistOptions.itemClass,function(h){h.preventDefault();h=b(this).parent().parent().index();e.current!==h?e.play(h):b(e.cssSelector.jPlayerVideo).jPlayerVideo("play");e.blur(this)});b(this.cssSelector.playlist).off("click","a."+this.options.playlistOptions.freeItemClass).on("click","a."+this.options.playlistOptions.freeItemClass,function(h){h.preventDefault();
b(this).parent().parent().find("."+e.options.playlistOptions.itemClass).click();e.blur(this)});b(this.cssSelector.playlist).off("click","a."+this.options.playlistOptions.removeItemClass).on("click","a."+this.options.playlistOptions.removeItemClass,function(h){h.preventDefault();h=b(this).parent().parent().index();e.remove(h);e.blur(this)})},_updateControls:function(){this.options.playlistOptions.enableRemoveControls?b(this.cssSelector.playlist+" ."+this.options.playlistOptions.removeItemClass).show():
b(this.cssSelector.playlist+" ."+this.options.playlistOptions.removeItemClass).hide();this.shuffled?b(this.cssSelector.jPlayerVideo).jPlayerVideo("addStateClass","shuffled"):b(this.cssSelector.jPlayerVideo).jPlayerVideo("removeStateClass","shuffled");b(this.cssSelector.shuffle).length&&b(this.cssSelector.shuffleOff).length&&(this.shuffled?(b(this.cssSelector.shuffleOff).show(),b(this.cssSelector.shuffle).hide()):(b(this.cssSelector.shuffleOff).hide(),b(this.cssSelector.shuffle).show()))},_highlight:function(e){this.playlist.length&&
e!==l&&(b(this.cssSelector.playlist+" .mdtc-clnplrv-playlist-current").removeClass("mdtc-clnplrv-playlist-current"),b(this.cssSelector.playlist+" li:nth-child("+(e+1)+")").addClass("mdtc-clnplrv-playlist-current").find(".mdtc-clnplrv-playlist-item").addClass("mdtc-clnplrv-playlist-current"))},setPlaylist:function(b){this._initPlaylist(b);this._init()},add:function(e,h){b(this.cssSelector.playlist+" ul").append(this._createListItem(e)).find("li:last-child").hide().slideDown(this.options.playlistOptions.addTime);
this._updateControls();this.original.push(e);this.playlist.push(e);h?this.play(this.playlist.length-1):1===this.original.length&&this.select(0)},remove:function(e){var h=this;if(e===l)return this._initPlaylist([]),this._refresh(function(){b(h.cssSelector.jPlayerVideo).jPlayerVideo("clearMedia")}),!0;if(this.removing)return!1;e=0>e?h.original.length+e:e;0<=e&&e<this.playlist.length&&(this.removing=!0,b(this.cssSelector.playlist+" li:nth-child("+(e+1)+")").slideUp(this.options.playlistOptions.removeTime,
function(){b(this).remove();if(h.shuffled){var k=h.playlist[e];b.each(h.original,function(b){if(h.original[b]===k)return h.original.splice(b,1),!1})}else h.original.splice(e,1);h.playlist.splice(e,1);h.original.length?e===h.current?(h.current=e<h.original.length?h.current:h.original.length-1,h.select(h.current)):e<h.current&&h.current--:(b(h.cssSelector.jPlayerVideo).jPlayerVideo("clearMedia"),h.current=0,h.shuffled=!1,h._updateControls());h.removing=!1}));return!0},select:function(e){e=0>e?this.original.length+
e:e;0<=e&&e<this.playlist.length?(this.current=e,this._highlight(e),b(this.cssSelector.jPlayerVideo).jPlayerVideo("setMedia",this.playlist[this.current])):this.current=0},play:function(e){e=0>e?this.original.length+e:e;0<=e&&e<this.playlist.length?this.playlist.length&&(this.select(e),b(this.cssSelector.jPlayerVideo).jPlayerVideo("play")):e===l&&b(this.cssSelector.jPlayerVideo).jPlayerVideo("play")},pause:function(){b(this.cssSelector.jPlayerVideo).jPlayerVideo("pause")},next:function(){var b=this.current+
1<this.playlist.length?this.current+1:0;this.loop?0===b&&this.shuffled&&this.options.playlistOptions.shuffleOnLoop&&1<this.playlist.length?this.shuffle(!0,!0):this.play(b):0<b&&this.play(b)},previous:function(){var b=0<=this.current-1?this.current-1:this.playlist.length-1;(this.loop&&this.options.playlistOptions.loopOnPrevious||b<this.playlist.length-1)&&this.play(b)},shuffle:function(e,h){var k=this;e===l&&(e=!this.shuffled);(e||e!==this.shuffled)&&b(this.cssSelector.playlist+" ul").slideUp(this.options.playlistOptions.shuffleTime,
function(){(k.shuffled=e)?k.playlist.sort(function(){return.5-Math.random()}):k._originalPlaylist();k._refresh(!0);h||!b(k.cssSelector.jPlayerVideo).data("jPlayerVideo").status.paused?k.play(0):k.select(0);b(this).slideDown(k.options.playlistOptions.shuffleTime)})},blur:function(e){b(this.cssSelector.jPlayerVideo).jPlayerVideo("option","autoBlur")&&b(e).blur()}}})(jQuery);
(function(b){function l(b){function e(){var a=b.next(),d=a.find(".mdtc-clnplrv-song-title-inner"),a=a.find(".mdtc-clnplrv-song-title").width(),c=d.width()-a;0<c&&(d.animate({marginLeft:"-="+(c-10)},2500),setTimeout(function(){d.animate({marginLeft:"+="+(c-10)},2500)},4E3))}e();setInterval(function(){e()},8E3)}function e(){for(var b="",e=0;15>e;e++)b+="abcdefghijklmnopqrstuvwxyz0123456789".charAt(Math.floor(36*Math.random()));return b}b.fn.cleanvideoplayer=function(h){(function(e,a,d,c){b("body").on("mousemove",
".mdtc-clnplrv-volume-bar",function(e){a&&a[d](b.extend({},e,{currentTarget:c}))}).on("mouseup",function(){a=!1}).on("mousedown",function(e){var g=b(e.target).parents().add(e.currentTarget);e=g.filter(".mdtc-clnplrv-volume-bar").first();g=g.filter(".mdtc-clnplrv-seek-bar").first();g.length?(d="seekBar",c=g):e.length&&(d="volumeBar",c=e);a=(e=c&&c.closest(".mdtc-clnplrv-video"))&&e.children().first().add(e.prev()).filter(function(){return b(this).data("jPlayerVideo")}).first().data("jPlayerVideo")})})();
return this.each(function(g){var a=b.extend({theme:"default",supplied:"m4v,webmv,youtube",disableControls:!1,autoplay:!1,playlistHeight:"290px",playlist:!1},h);g=!1;var d="";if(0<b(this).find("> ul").length){var c=b(this).find("> ul");c.data("theme")?a.theme=c.data("theme"):void 0;c.data("supplied")?a.supplied=c.data("supplied"):void 0;c.data("disable-controls")?a.disableControls=c.data("disable-controls"):void 0;c.data("autoplay")?a.autoplay=c.data("autoplay"):void 0;c.data("playlist-height")?a.playlistHeight=
c.data("playlist-height"):void 0;c.data("preload")?a.preload=c.data("preload"):void 0;if(0<b(this).find("> ul li").length){var f=[];b(this).find("> ul li").each(function(){var a=b(this),c=a.data("free")?!0:!1,d=a.data("type"),c={title:a.data("title"),artist:a.data("artist"),free:c,poster:a.data("poster")};c[d]=a.data("url");f.push(c)});1==b(this).find("> ul li").length&&b(this).find("> ul li").data("free")&&(g=!0,d=b(this).find("> ul li").data("url"));a.playlist=f}}c=e();b(this).html('<div class="mdtc-clnplrv-video mdtc-clnplrv-main-player"><div class="mdtc-clnplrv-jplayer mdtc-clnplrv-video-container">\x3c!-- --\x3e</div><div class="mdtc-clnplrv-type-playlist"><div class="mdtc-clnplrv-gui mdtc-clnplrv-interface"><ul class="mdtc-clnplrv-controls"><li><a href="javascript:;" class="mdtc-clnplrv-previous mdtc-clnplrv-icon-prev" tabindex="1"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-play mdtc-clnplrv-icon-play" tabindex="1"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-pause mdtc-clnplrv-icon-pause" tabindex="1" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-next mdtc-clnplrv-icon-next" tabindex="1"></a></li></ul><div class="mdtc-clnplrv-seek-container"><div class="mdtc-clnplrv-seek-container-inner"><div class="mdtc-clnplrv-song-title"><div class="mdtc-clnplrv-song-title-inner"><strong id="current-song">\x3c!-- --\x3e</strong></div></div><div class="mdtc-clnplrv-progress"><div class="mdtc-clnplrv-seek-bar" style="width:0%"><div class="mdtc-clnplrv-play-bar" style="width:0%">\x3c!-- --\x3e</div></div></div><div class="mdtc-clnplrv-time"><div class="mdtc-clnplrv-current-time">00:00</div><div class="mdtc-clnplrv-duration">00:00</div></div></div></div><div class="mdtc-clnplrv-volume-bar"><div class="mdtc-clnplrv-volume-bar-value"><i>\x3c!-- --\x3e</i></div></div><ul class="mdtc-clnplrv-toggles"><li><a title="Repeat" tabindex="1" class="mdtc-clnplrv-repeat mdtc-clnplrv-icon-repeat" href="javascript:;"></a></li><li><a title="Repeat off" tabindex="1" class="mdtc-clnplrv-repeat-off mdtc-clnplrv-icon-repeat" href="javascript:;" style="display:none"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-shuffle mdtc-clnplrv-icon-shuffle" tabindex="1" title="Shuffle"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-shuffle-off mdtc-clnplrv-icon-shuffle" tabindex="1" title="Shuffle off" style="display:none"></a></li><li class="mdtc-clnplrv-fullscreen-li"><a href="javascript:;" class="mdtc-clnplrv-fullscreen-btn mdtc-clnplrv-icon-fullscreen" tabindex="1" title="Toggle fullscreen"></a></li><li><a href="javascript:;" class="mdtc-clnplrv-download-one mdtc-clnplrv-icon-download" tabindex="1" title="Download" style="display:none"></a></li></ul></div><div class="mdtc-clnplrv-playlist"><ul></ul></div><div class="mdtc-clnplrv-no-solution" style="display:none"><span>Update Required </span>To play the media you will need to either update your browser to a recent version</div></div></div>');
b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-cleanvideoplayer-id-"+c);g&&(b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-solo-download"),b(this).find(".mdtc-clnplrv-download-one").attr("href",d));"dark"==a.theme&&b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-dark-theme");a.disableControls&&b(this).find(".mdtc-clnplrv-main-player").addClass("mdtc-clnplrv-disabled-controls");a.playlistHeight&&b(this).find(".mdtc-clnplrv-playlist > ul").css({maxHeight:a.playlistHeight,
overflowY:"auto"});1<a.playlist.length?(playerOptions={solution:"html",supplied:a.supplied,preload:a.preload,wmode:"window",ready:function(c){function d(){if(e.next().is(":visible")){var a=e.width(),b=a/16*9;e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.css("cssText","height:100% !important"):e.css("cssText","height:"+b+"px !important");450>a?e.parent().addClass("mdtc-clnplrv-responsive"):e.parent().removeClass("mdtc-clnplrv-responsive")}}var e=b(this);a.autoplay&&e.jPlayerVideo("play");
e.on("click",function(){e.data().jPlayerVideo.status.paused?e.jPlayerVideo("play"):e.jPlayerVideo("pause")});e.on("dblclick",function(){e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.jPlayerVideo("restoreScreen"):e.jPlayerVideo("fullScreen")});e.next().find(".mdtc-clnplrv-fullscreen-btn").on("click",function(){e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.jPlayerVideo("restoreScreen"):e.jPlayerVideo("fullScreen")});"metadata"==a.preload&&e.find("video").css("cssText","background: transparent");
b(window).on("resize",function(){d()});d();setInterval(function(){d()},250);l(e)},play:function(a){b(this).jPlayerVideo("pauseOthers")},cssSelector:{title:"#current-song"},playlistOptions:{shuffleTime:150},size:{width:"100%",height:"100%"}},new jPlayerVideoPlaylist({jPlayerVideo:".mdtc-clnplrv-cleanvideoplayer-id-"+c+" .mdtc-clnplrv-jplayer",cssSelectorAncestor:".mdtc-clnplrv-cleanvideoplayer-id-"+c},a.playlist,playerOptions)):b(".mdtc-clnplrv-cleanvideoplayer-id-"+c+" .mdtc-clnplrv-jplayer").jPlayerVideo({ready:function(c){function d(){if(e.next().is(":visible")){var a=
e.width(),b=a/16*9;e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.css("cssText","height:100% !important"):e.css("cssText","height:"+b+"px !important");450>a?e.parent().addClass("mdtc-clnplrv-responsive"):e.parent().removeClass("mdtc-clnplrv-responsive")}}b(this).jPlayerVideo("setMedia",a.playlist[0]);var e=b(this);a.autoplay&&b(this).jPlayerVideo("play");e.on("click",function(){e.data().jPlayerVideo.status.paused?e.jPlayerVideo("play"):e.jPlayerVideo("pause")});e.on("dblclick",function(){e.parent().hasClass("mdtc-clnplrv-state-full-screen")?
e.jPlayerVideo("restoreScreen"):e.jPlayerVideo("fullScreen")});e.next().find(".mdtc-clnplrv-fullscreen-btn").on("click",function(){e.parent().hasClass("mdtc-clnplrv-state-full-screen")?e.jPlayerVideo("restoreScreen"):e.jPlayerVideo("fullScreen")});b(this).parent().addClass("mdtc-clnplrv-disabled-controls mdtc-clnplrv-solo-player");b(window).on("resize",function(){d()});d();setInterval(function(){d()},250);l(e)},play:function(a){b(this).jPlayerVideo("pauseOthers")},cssSelector:{title:"#current-song"},
cssSelectorAncestor:".mdtc-clnplrv-cleanvideoplayer-id-"+c,supplied:a.supplied,preload:a.preload,size:{width:"100%",height:"100%"}})})};var h={api:"https://www.youtube.com/iframe_api",load:function(b){var e=document.getElementsByTagName("script")[0],a=[],d,c;return function(f){if(c)return a?a.push(f):f();if(b.YT&&b.YT.Player)return f();b.onYouTubeIframeAPIReady&&a.push(b.onYouTubeIframeAPIReady);b.onYouTubeIframeAPIReady=function(){for(;0!==a.length;)try{a.shift()()}catch(b){}a=!1};c=a.push(f);d=
document.createElement("script");d.src=h.api;e.parentNode.insertBefore(d,e)}}((0,eval)("this")),player:function(e,g){var a=b(e),d=e.id+"_youtube",c=function(){return a.data.apply(a,[d].concat([].slice.call(arguments)))},f=c()||c({player:!1,queue:!1})&&c();if(f.player)return g(f.player);if(f.queue)return f.queue.push(g);f.queue=[g];h.load(function(){f.container=e.parentNode.insertBefore(document.createElement("div"),e);f.container.id=d;var c=b.jPlayerVideo.platform.ipad||b.jPlayerVideo.platform.iphone||
b.jPlayerVideo.platform.ipod?1:0;f.player=new YT.Player(d,{height:a.outerHeight(),width:a.outerWidth(),playerVars:{autoplay:0,controls:c,rel:0,iv_load_policy:3,showinfo:0},events:{onReady:function(){for(;0!==f.queue.length;)try{f.queue.shift()(f.player)}catch(c){}delete f.queue;b(window).on("resize",function(){f.player.setSize(a.outerWidth(),a.outerHeight())})},onStateChange:function(b){b="unstarted;ended;playing;paused;buffering;video cued".split(";")[b.data+1];var c,d=e.getJPlayer(),g=function(a){d._getHtmlStatus(c,
a);d._updateInterface();a&&g()};clearInterval(f.interval);"ended"===b?e.emulateEvent("ended"):"paused"===b?e.emulateEvent("pause"):"playing"===b&&(e.emulateEvent("play"),e.emulateEvent("playing"),c={currentTime:f.player.getCurrentTime(),duration:f.player.getDuration(),videoWidth:a.outerWidth(),videoHeight:a.outerHeight(),ended:!1,readyState:4,load:function(){},seekable:{length:1,end:function(){return c.duration}}},g(!0),f.interval=setInterval(function(){c.currentTime=f.player.getCurrentTime();c.ended=
c.currentTime>=c.duration;g()},1E3),f._html_playHead||(f._html_playHead=d._html_playHead),d._html_playHead=function(){var a=this.htmlElement.media,b=f.player.getCurrentTime(),d;a.getVideoId()?(c.currentTime=b,this.htmlElement.media=c,d=f._html_playHead.apply(this,arguments),this.htmlElement.media=a,c.currentTime!==b&&(f.player.seekTo(c.currentTime),g())):d=f._html_playHead.apply(this,arguments);return d})}}})})},hooks:{video:{getVideoId:function(){return function(){var e=b(this);return(String(e.attr("src")||
e.data("src")).match(/(?:youtube\.com\/.*?[?&]v=|youtube:\/{2})([^&]+)/i)||[])[1]}},getJPlayer:function(){return function(){var e=this,g;do g=b.data(e,"jPlayerVideo"),e=e.parentNode;while(e&&!g);return g}},emulateEvent:function(){return function(b){if("function"===typeof this.dispatchEvent){var e=document.createEvent("HTMLEvents");e.initEvent(b,!0,!0,window,0,0,0,0,0,!1,!1,!1,!1,0,this);this.dispatchEvent(e)}else"undefined"!==typeof this.fireEvent&&this.fireEvent("on"+b)}},youtube:function(){return function(b){return h.player(this,
b)}},toggleVideo:function(){return function(e){this.getJPlayer().element.toggleClass("youtube-player",e).find('video,img[id*="poster"]').css(e?{position:"absolute",visibility:"visible",top:"1px"}:{position:"",visibility:"",opacity:"",top:""}).end().find("iframe").toggle(e);var g=b.jPlayerVideo.platform.ipad||b.jPlayerVideo.platform.iphone||b.jPlayerVideo.platform.ipod;e&&g?this.getJPlayer().element.parent().find(".mdtc-clnplrv-interface").toggle(!1):this.getJPlayer().element.parent().find(".mdtc-clnplrv-interface").toggle(!0)}},
addEventListener:function(e){return function(g,a,d){var c=this,f=b(this);return e.call(this,g,function(b){var d=a.apply(this,arguments);c.getVideoId()&&(f.attr("src")&&/(?:abort|emptied|loadstart)/i.test(g)?f.data("src",c.src).attr("src",""):/volumechange/i.test(g)?c.youtube(function(a){a.setVolume(100*c.getJPlayer().options.volume)}):/error/i.test(g)&&(c.getJPlayer().status.waitForLoad=!1));return d},d)}},canPlayType:function(b){return function(e){return/youtube/i.test(e)?"probably":b.apply(this,
arguments)}},pause:function(b){return function(){var e=this;return this.getVideoId()?this.youtube(function(a){e.emulateEvent("pause");a.pauseVideo()}):b.apply(this,arguments)}},play:function(e){return function(){var g=this;if(this.getVideoId())return this.youtube(function(a){g.toggleVideo(!0);a.playVideo()});b(g).data("src")&&this.youtube(function(a){a.stopVideo()});this.toggleVideo(!1);return e.apply(this,arguments)}},load:function(b){return function(){var e=this,a=this.getVideoId();if(a)return this.youtube(function(b){e.toggleVideo(!0);
b.cueVideoById(a)});this.toggleVideo(!1);return b.apply(this,arguments)}}}},initialize:function(){var e=function(b,a){var d=h.hooks[a]||{},c;for(c in d)d.hasOwnProperty(c)&&(b[c]=d[c].call(b,b[c]));return b};b.jPlayerVideo.prototype.format.youtube={flashCanPlay:!1,codec:'video/youtube; codecs="m4v"',media:"video"};"undefined"!==typeof HTMLVideoElement?e(HTMLVideoElement.prototype,"video"):document.createElement=function(b){return function(a){return e(b.apply(this,arguments),String(a).toLowerCase())}}(document.createElement)}};
h.initialize()})(jQuery);$(function(){$(".dleaudioplayer").cleanaudioplayer();$(".dlevideoplayer").cleanvideoplayer()});