<?php

defined('_IN_JOHNCMS') or die('Restricted access');

class bbcode extends core
{
    /*
    -----------------------------------------------------------------
    Обработка тэгов и ссылок
    -----------------------------------------------------------------
    */
    public static function tags($var)
    {
        $var = self::parse_time($var);               // Обработка тэга времени
        $var = self::highlight_code($var);           // Подсветка кода
        $var = self::highlight_bb($var);               // Обработка ссылок
        $var = self::highlight_url($var);            // Обработка ссылок
        $var = self::highlight_bbcode_url($var);       // Обработка ссылок в BBcode
        return $var;
    }

    /**
     * Обработка тэга [time]
     *
     * @param string $var
     * @return string
     */
    private static function parse_time($var)
    {
        return preg_replace_callback(
            '#\[time\](.+?)\[\/time\]#s',
            function ($matches) {
                $shift = (core::$system_set['timeshift'] + core::$user_set['timeshift']) * 3600;
                if (($out = strtotime($matches[1])) !== false) {
                    return date("d.m.Y / H:i", $out + $shift);
                } else {
                    return $matches[1];
                }
            },
            $var
        );
    }

    /**
     * Парсинг ссылок
     * За основу взята доработанная функция от форума phpBB 3.x.x
     *
     * @param $text
     * @return mixed
     */
    public static function highlight_url($text)
    {
        if (!function_exists('url_callback')) {
            function url_callback($type, $whitespace, $url, $relative_url)
            {
                $orig_url = $url;
                $orig_relative = $relative_url;
                $url = htmlspecialchars_decode($url);
                $relative_url = htmlspecialchars_decode($relative_url);
                $text = '';
                $chars = array('<', '>', '"');
                $split = false;
                foreach ($chars as $char) {
                    $next_split = strpos($url, $char);
                    if ($next_split !== false) {
                        $split = ($split !== false) ? min($split, $next_split) : $next_split;
                    }
                }
                if ($split !== false) {
                    $url = substr($url, 0, $split);
                    $relative_url = '';
                } else if ($relative_url) {
                    $split = false;
                    foreach ($chars as $char) {
                        $next_split = strpos($relative_url, $char);
                        if ($next_split !== false) {
                            $split = ($split !== false) ? min($split, $next_split) : $next_split;
                        }
                    }
                    if ($split !== false) {
                        $relative_url = substr($relative_url, 0, $split);
                    }
                }
                $last_char = ($relative_url) ? $relative_url[strlen($relative_url) - 1] : $url[strlen($url) - 1];
                switch ($last_char) {
                    case '.':
                    case '?':
                    case '!':
                    case ':':
                    case ',':
                        $append = $last_char;
                        if ($relative_url) $relative_url = substr($relative_url, 0, -1);
                        else $url = substr($url, 0, -1);
                        break;

                    default:
                        $append = '';
                        break;
                }
                $short_url = (mb_strlen($url) > 40) ? mb_substr($url, 0, 30) . ' ... ' . mb_substr($url, -5) : $url;
                switch ($type) {
                    case 1:
                        $relative_url = preg_replace('/[&?]sid=[0-9a-f]{32}$/', '', preg_replace('/([&?])sid=[0-9a-f]{32}&/', '$1', $relative_url));
                        $url = $url . '/' . $relative_url;
                        $text = $relative_url;
                        if (!$relative_url) {
                            return $whitespace . $orig_url . '/' . $orig_relative;
                        }
                        break;

                    case 2:
                        $text = $short_url;
                        if (!isset(core::$user_set['direct_url']) || !core::$user_set['direct_url']) {
                            $url = core::$system_set['homeurl'] . '/go.php?url=' . rawurlencode($url);
                        }
                        break;

                    case 4:
                        $text = $short_url;
                        $url = 'mailto:' . $url;
                        break;
                }
                $url = htmlspecialchars($url);
                $text = htmlspecialchars($text);
                $append = htmlspecialchars($append);

                return $whitespace . '<a href="' . $url . '">' . $text . '</a>' . $append;
            }
        }

        // Обработка внутренних ссылок
        $text = preg_replace_callback(
            '#(^|[\n\t (>.])(' . preg_quote(core::$system_set['homeurl'], '#') . ')/((?:[a-zа-яё0-9\-._~!$&\'(*+,;=:@|]+|%[\dA-F]{2})*(?:/(?:[a-zа-яё0-9\-._~!$&\'(*+,;=:@|]+|%[\dA-F]{2})*)*(?:\?(?:[a-zа-яё0-9\-._~!$&\'(*+,;=:@/?|]+|%[\dA-F]{2})*)?(?:\#(?:[a-zа-яё0-9\-._~!$&\'(*+,;=:@/?|]+|%[\dA-F]{2})*)?)#iu',
            function ($matches) {
                return url_callback(1, $matches[1], $matches[2], $matches[3]);
            },
            $text
        );

        // Обработка обычных ссылок типа xxxx://aaaaa.bbb.cccc. ...
        $text = preg_replace_callback(
            '#(^|[\n\t (>.])([a-z][a-z\d+]*:/{2}(?:(?:[a-zа-яё0-9\-._~!$&\'(*+,;=:@|]+|%[\dA-F]{2})+|[0-9.]+|\[[a-zа-яё0-9.]+:[a-zа-яё0-9.]+:[a-zа-яё0-9.:]+\])(?::\d*)?(?:/(?:[a-zа-яё0-9\-._~!$&\'(*+,;=:@|]+|%[\dA-F]{2})*)*(?:\?(?:[a-zа-яё0-9\-._~!$&\'(*+,;=:@/?|]+|%[\dA-F]{2})*)?(?:\#(?:[a-zа-яё0-9\-._~!$&\'(*+,;=:@/?|]+|%[\dA-F]{2})*)?)#iu',
            function ($matches) {
                return url_callback(2, $matches[1], $matches[2], '');
            },
            $text
        );

        return $text;
    }

    /*
    -----------------------------------------------------------------
    Удаление bbCode из текста
    -----------------------------------------------------------------
    */
    static function notags($var = '')
    {
        $var = preg_replace('#\[color=(.+?)\](.+?)\[/color]#si', '$2', $var);
        $var = preg_replace('!\[bg=(#[0-9a-f]{3}|#[0-9a-f]{6}|[a-z\-]+)](.+?)\[/bg]!is', '$2', $var);
        $var = preg_replace('#\[spoiler=(.+?)\]#si', '$2', $var);
        $replace = array(
            '[small]'  => '',
            '[/small]' => '',
            '[big]'    => '',
            '[/big]'   => '',
            '[green]'  => '',
            '[/green]' => '',
            '[red]'    => '',
            '[/red]'   => '',
            '[blue]'   => '',
            '[/blue]'  => '',
            '[b]'      => '',
            '[/b]'     => '',
            '[i]'      => '',
            '[/i]'     => '',
            '[u]'      => '',
            '[/u]'     => '',
            '[s]'      => '',
            '[/s]'     => '',
            '[quote]'  => '',
            '[/quote]' => '',
            '[c]'      => '',
            '[/c]'     => '',
            '[*]'      => '',
'[/*]'     => '',
            '[ct]'     => '',
            '[/ct]'     => '',
            '[img]' => '',
            '[/img]' => '',
            '[video]' => '',
            '[/video]' => ''
        );

        return strtr($var, $replace);
    }

    /*
    -----------------------------------------------------------------
    Подсветка кода
    -----------------------------------------------------------------
    */
    private static function highlight_code($var)
    {
        if (!function_exists('process_code')) {
            function process_code($php)
            {
                $php = strtr($php, array('<br />' => '', '\\' => 'slash_JOHNCMS'));
                $php = html_entity_decode(trim($php), ENT_QUOTES, 'UTF-8');
                $php = substr($php, 0, 2) != "<?" ? "<?php\n" . $php . "\n?>" : $php;
                $php = highlight_string(stripslashes($php), true);
                $php = strtr($php, array('slash_JOHNCMS' => '&#92;', ':' => '&#58;', '[' => '&#91;'));

                return '<pre class="phpcode"><code>' . trim($php) . '</code></pre>';
            }
        }

        return preg_replace_callback(
            '#\[php\](.+?)\[\/php\]#s',
            function ($matches) {
                return process_code($matches[1]);
            },
            $var
        );
    }

    /*
    -----------------------------------------------------------------
    Обработка URL в тэгах BBcode
    -----------------------------------------------------------------
    */
    private static function highlight_bbcode_url($var)
    {
        if (!function_exists('process_url')) {
            function process_url($url)
            {
                $home = parse_url(core::$system_set['homeurl']);
                $tmp = parse_url($url[1]);
                if ($home['host'] == $tmp['host'] || isset(core::$user_set['direct_url']) && core::$user_set['direct_url']) {
                    return '<a href="' . $url[1] . '">' . $url[2] . '</a>';
                } else {
                    return '<a href="' . core::$system_set['homeurl'] . '/go.php?url=' . urlencode(htmlspecialchars_decode($url[1])) . '">' . $url[2] . '</a>';
                }
            }
        }

        return preg_replace_callback('~\\[url=(https?://.+?)\\](.+?)\\[/url\\]~', 'process_url', $var);
    }

    /*
    -----------------------------------------------------------------
    Обработка bbCode
    -----------------------------------------------------------------
    */
    private static function highlight_bb($var)
    {
        // Список поиска
        $search = array(
            '#\[b](.+?)\[/b]#is', // Жирный
            '#\[i](.+?)\[/i]#is', // Курсив
            '#\[u](.+?)\[/u]#is', // Подчеркнутый
            '#\[s](.+?)\[/s]#is', // Зачеркнутый
            '#\[small](.+?)\[/small]#is', // Маленький шрифт
            '#\[big](.+?)\[/big]#is', // Большой шрифт
            '#\[red](.+?)\[/red]#is', // Красный
            '#\[green](.+?)\[/green]#is', // Зеленый
            '#\[blue](.+?)\[/blue]#is', // Синий
            '!\[color=(#[0-9a-f]{3}|#[0-9a-f]{6}|[a-z\-]+)](.+?)\[/color]!is', // Цвет шрифта
            '!\[bg=(#[0-9a-f]{3}|#[0-9a-f]{6}|[a-z\-]+)](.+?)\[/bg]!is', // Цвет фона
            '#\[(quote|c)](.+?)\[/(quote|c)]#is', // Цитата
            '#\[\*](.+?)\[/\*]#is', // Список
            '#\[spoiler=(.+?)](.+?)\[/spoiler]#is', // Спойлер
'#\[ct](.+?)\[/ct]#is', // CENTER
            '#\[img](.+?)\[/img]#is', // IMG
            '#\[video](.+?)\[/video]#is' // VIDEO
        );
        // Список замены
        $replace = array(
            '<span style="font-weight: bold">$1</span>', // Жирный
            '<span style="font-style:italic">$1</span>', // Курсив
            '<span style="text-decoration:underline">$1</span>', // Подчеркнутый
            '<span style="text-decoration:line-through">$1</span>', // Зачеркнутый
            '<span style="font-size:x-small">$1</span>', // Маленький шрифт
            '<span style="font-size:large">$1</span>', // Большой шрифт
            '<span style="color:red">$1</span>', // Красный
            '<span style="color:green">$1</span>', // Зеленый
            '<span style="color:blue">$1</span>', // Синий
            '<span style="color:$1">$2</span>', // Цвет шрифта
            '<span style="background-color:$1">$2</span>', // Цвет фона
            '<span class="quote" style="display:block">$2</span>', // Цитата
            '<span class="bblist">$1</span>', // Список
            '<div><div class="spoilerhead" style="cursor:pointer;" onclick="var _n=this.parentNode.getElementsByTagName(\'div\')[1];if(_n.style.display==\'none\'){_n.style.display=\'\';}else{_n.style.display=\'none\';}">$1 (+/-)</div><div class="spoilerbody" style="display:none">$2</div></div>', // Спойлер
'<center>$1</center>', // CENTER
'<a href="$1"><img src="$1" width="260" height="160"></a>',  // IMG
'<video style="cursor: pointer;background-color: #A7E3C1;-webkit-appearance: none !important;width: 240px;height: auto;text-align:center;" src="$1" controls></video>'  // VIDEO
        );

        return preg_replace($search, $replace, $var);
    }

    /*
    -----------------------------------------------------------------
    Панель кнопок bbCode (для компьютеров)
    -----------------------------------------------------------------
    */
    public static function auto_bb($form, $field)
    {

        $out = '<script language="JavaScript" type="text/javascript">
            function tag(text1) {
              if ((document.selection)) {
                document.' . $form . '.' . $field . '.focus();
                document.' . $form . '.document.selection.createRange().text = text1;
              } else if(document.forms[\'' . $form . '\'].elements[\'' . $field . '\'].selectionStart!=undefined) {
                var element = document.forms[\'' . $form . '\'].elements[\'' . $field . '\'];
                var str = element.value;
                var start = element.selectionStart;
                var length = element.selectionEnd - element.selectionStart;
                element.value = str.substr(0, start) + text1;
              } else {
                document.' . $form . '.' . $field . '.value += text1;
              }
            }
            </script>
            <a href="javascript:tag(\':)\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/).png" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-)\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-).gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-D\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-D.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-J\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-J.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-P\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-P.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':=D\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/=D.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-!\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-!.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-@\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-@.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-i\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-i.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':-(\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-(.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-((\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-((.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-r\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-r.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-F\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-F.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':-l\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-l.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':b\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/b.png" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':p\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/p.png" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':,(\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/,(.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-S\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-S.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-0\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-0.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':-E\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-E.gif" alt="*" width="16" height="16" border="0"/></a>    <a href="/pages/faq.php?act=osms">   •••   </a><br/>— <a href="/pages/faq.php?act=smileys">Smayllar</a>    |  <a href="/pages/faq.php?act=tags">BB teglar</a><br/>';


        return $out;
}

    /*
    -----------------------------------------------------------------
    SMAYLLAR PANELI
    -----------------------------------------------------------------
    */

    public static function auto_smileys($form, $field)
    {

        $out = '<script language="JavaScript" type="text/javascript">
            function tag(text1) {
              if ((document.selection)) {
                document.' . $form . '.' . $field . '.focus();
                document.' . $form . '.document.selection.createRange().text = text1;
              } else if(document.forms[\'' . $form . '\'].elements[\'' . $field . '\'].selectionStart!=undefined) {
                var element = document.forms[\'' . $form . '\'].elements[\'' . $field . '\'];
                var str = element.value;
                var start = element.selectionStart;
                var length = element.selectionEnd - element.selectionStart;
                element.value = str.substr(0, start) + text1;
              } else {
                document.' . $form . '.' . $field . '.value += text1;
              }
            }
            </script>
<a href="javascript:tag(\':)\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/).png" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-)\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-).gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-D\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-D.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-J\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-J.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-P\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-P.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':=D\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/=D.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-!\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-!.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-@\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-@.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-i\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-i.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':-(\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-(.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-((\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-((.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-r\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-r.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-F\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-F.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':-l\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-l.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':b\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/b.png" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':p\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/p.png" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':,(\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/,(.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-S\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-S.gif" alt="*" width="16" height="16" border="0"/></a>
            <a href="javascript:tag(\':-0\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-0.gif" alt="*" width="16" height="16" border="0"/></a>
<a href="javascript:tag(\':-E\')"><img src="' . self::$system_set['homeurl'] . '/images/smileys/simply/-E.gif" alt="*" width="16" height="16" border="0"/></a><br/>— <a href="/pages/faq.php?act=smileys">Smayllar</a>    |  <a href="/pages/faq.php?act=tags">BB teglar</a>    <a href="/pages/faq.php?act=osms">   •••   </a><br/>— <a href="/pages/faq.php?act=smileys">Smayllar</a>    |  <a href="/pages/faq.php?act=tags">BB teglar</a><br/>';

        return $out;
    }
}