<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Main extends CI_Controller {

	public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
    }

	public function index()
	{
		$data = array();
		$data['active'] = 'login';
		$this->load->view('index', $data);
	}
	function login()
	{
		$data = array();
		if(isset($_POST['loginbttn']))
		{
			$this->form_validation->set_rules('username', 'Username', 'trim|required|xss_clean');
			$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');
			if($this->form_validation->run() == FALSE) 
			{
				$data['reset'] = FALSE;
			}
			else
			{
				$username = $this->input->post('username');
				$password = sha1($this->input->post('password'));
				if($this->user_model->login($username, $password))
				{
					redirect(base_url().'users');
				}
				else
				{
					$data['error'] = 'Login yoki parol xato, iltimos tekshirib qaytadan urinib ko\'ring!';
				}

			}
		}
		$data['active'] = 'login';
		$this->load->view('index', $data);
	}
	function azo_bolish()
	{
		$data = array();
		if(isset($_POST['registerbttn']))
		{
			$this->form_validation->set_rules('firstname', 'First Name', 'trim|required|xss_clean');
			$this->form_validation->set_rules('lastname', 'Last Name', 'trim|required|xss_clean');
			
			$this->form_validation->set_rules('telefon', 'Telefon raqami', 'trim|required|xss_clean');
			$this->form_validation->set_rules('t_kun', 'Tug\'ilgan kun', 'trim|required|xss_clean');
			$this->form_validation->set_rules('t_oy', 'Tug\'ilgan oy', 'trim|required|xss_clean');
			$this->form_validation->set_rules('t_yil', 'Tug\'ilgan yil', 'trim|required|xss_clean');
			$this->form_validation->set_rules('joylashuv', 'Joylashuv', 'trim|required|xss_clean');
			
			$this->form_validation->set_rules('email', 'Email', 'trim|required|xss_clean|valid_email|callback_email_exists');
			$this->form_validation->set_rules('username', 'Username', 'trim|required|xss_clean|min_length[6]|max_length[20]|callback_username_exists');
			$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean|min_length[6]|max_length[20]');
			$this->form_validation->set_rules('confirmpassword', 'Confirm password', 'trim|required|xss_clean|matches[password]');
			$this->form_validation->set_rules('enterCode', 'Security Code', 'callback_check_captcha');
			$this->form_validation->set_error_delimiters('<span class="fielderror">', '</span>');
		
			if($this->form_validation->run() == FALSE) 
			{
				$data['reset'] = FALSE;
			}
			else
			{
				$userdetails = array('firstname' => $this->input->post('firstname'),
									 'lastname'  => $this->input->post('lastname'),
									 
									 'telefon'  => $this->input->post('telefon'),
									 't_kun'  => $this->input->post('t_kun'),
									 't_oy'  => $this->input->post('t_oy'),
									 't_yil'  => $this->input->post('t_yil'),
									 'joylashuv'  => $this->input->post('joylashuv'),
									 
									 'email'     => $this->input->post('email'),
									 'username'  => $this->input->post('username'),
									 'password'  => sha1($this->input->post('password'))
					);
				if($this->user_model->insert('users', $userdetails))
				{
					$data['success'] = 'Profil yaratildi, iltimos <b>Login</b> va <b>Parol</b>ingizni terib kiring.!';
				}
				else
				{
					$data['error'] = 'An error occurred while creating account, please try again !';
				}

			}
		}
		$data['active'] = 'azo_bolish';
		$this->load->view('azo_bolish', $data);
	}

	function email_exists($email)
	{
		if($this->user_model->email_exists($email))
		{
		$this->form_validation->set_message('email_exists', 'Pochta manzilini ko\'rsatish shart.');
        return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	function username_exists($username)
	{
		if($this->user_model->username_exists($username))
		{
		$this->form_validation->set_message('username_exists', 'Bunday foydalanuvchi mavjud, boshqa login tanlang');
        return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	function logout()
    {
        $this->session->unset_userdata('userdetails');
        $this->index();
    }



}
