-- --------------------------------------------------------
-- 
-- Table structure for table `award_users`
-- 

CREATE TABLE `award_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_award` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_who` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- 
-- Table structure for table `awards`
-- 

CREATE TABLE `awards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `desc` varchar(150) NOT NULL,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `img` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Dumping data for table `awards`
-- 

INSERT INTO `awards` VALUES ('1','Sayt yaratuvchi','Sayt yaratuvchisi sovrini','1','1535100603','1535100603');
INSERT INTO `awards` VALUES ('2','Sayt faoli','Saytimiz faol foydalanuvchilari uchun sovrin','1','1535100806','1535100806');
INSERT INTO `awards` VALUES ('3','Sayt faxri','Saytimizda malakali foydalanuvchilari uchun!','1','1535100863','1535100863');
INSERT INTO `awards` VALUES ('4','Menejer lideri','Futbol menejerimiz liderlari uchun maxsus sovrin!','1','1535100918','1535100918');
INSERT INTO `awards` VALUES ('5','VIP foydalanuvchi','Saytimizda eng ko&#039;p onlayn bo&#039;lgan foydalanuvchilar uchun sovrin!','1','1535100997','1535100997');
INSERT INTO `awards` VALUES ('6','Ajoyib kun','Foydalanuvchilarimiz uchun mahsus sovg&#039;a','1','1535116842','1535116842');

-- --------------------------------------------------------
-- 
-- Table structure for table `book_comments_likes`
-- 

CREATE TABLE `book_comments_likes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sub_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `like` int(1) NOT NULL,
  `dislike` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Table structure for table `book_forecast_likes`
-- 

CREATE TABLE `book_forecast_likes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sub_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `like` int(1) NOT NULL,
  `dislike` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Table structure for table `book_forecasts_comments`
-- 

CREATE TABLE `book_forecasts_comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(11) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Table structure for table `bookmaker_bets`
-- 

CREATE TABLE `bookmaker_bets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `match_id` int(11) NOT NULL,
  `bet` varchar(15) NOT NULL,
  `summ` int(11) NOT NULL,
  `win` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `bookmaker_forecasts`
-- 

CREATE TABLE `bookmaker_forecasts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `match_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `text` text NOT NULL,
  `forec` varchar(15) NOT NULL,
  `time` int(11) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `bookmaker_matches`
-- 

CREATE TABLE `bookmaker_matches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `team_1` varchar(30) NOT NULL,
  `team_2` varchar(30) NOT NULL,
  `champ` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `developments` varchar(1000) NOT NULL,
  `score` varchar(10) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `cms_ads`
-- 

CREATE TABLE `cms_ads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `view` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `layout` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `count_link` int(10) unsigned NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `link` text NOT NULL,
  `to` int(10) unsigned NOT NULL DEFAULT '0',
  `color` varchar(10) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `day` int(10) unsigned NOT NULL DEFAULT '0',
  `mesto` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `bold` tinyint(1) NOT NULL DEFAULT '0',
  `italic` tinyint(1) NOT NULL DEFAULT '0',
  `underline` tinyint(1) NOT NULL DEFAULT '0',
  `show` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_cat`
-- 

CREATE TABLE `cms_album_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `password` varchar(20) NOT NULL DEFAULT '',
  `access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `access` (`access`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_comments`
-- 

CREATE TABLE `cms_album_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_downloads`
-- 

CREATE TABLE `cms_album_downloads` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_files`
-- 

CREATE TABLE `cms_album_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `album_id` int(10) unsigned NOT NULL,
  `description` text NOT NULL,
  `img_name` varchar(100) NOT NULL DEFAULT '',
  `tmb_name` varchar(100) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `comments` tinyint(1) NOT NULL DEFAULT '1',
  `comm_count` int(10) unsigned NOT NULL DEFAULT '0',
  `access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `vote_plus` int(11) NOT NULL DEFAULT '0',
  `vote_minus` int(11) NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `downloads` int(10) unsigned NOT NULL DEFAULT '0',
  `unread_comments` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `album_id` (`album_id`),
  KEY `access` (`access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_views`
-- 

CREATE TABLE `cms_album_views` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_votes`
-- 

CREATE TABLE `cms_album_votes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `vote` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `file_id` (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_ban_ip`
-- 

CREATE TABLE `cms_ban_ip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip1` bigint(11) NOT NULL DEFAULT '0',
  `ip2` bigint(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '0',
  `link` varchar(100) NOT NULL,
  `who` varchar(25) NOT NULL,
  `reason` text NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip1` (`ip1`),
  UNIQUE KEY `ip2` (`ip2`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_ban_users`
-- 

CREATE TABLE `cms_ban_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ban_time` int(11) NOT NULL DEFAULT '0',
  `ban_while` int(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '1',
  `ban_who` varchar(30) NOT NULL DEFAULT '',
  `ban_ref` int(11) NOT NULL DEFAULT '0',
  `ban_reason` text NOT NULL,
  `ban_raz` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `ban_time` (`ban_time`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4;


-- --------------------------------------------------------
-- 
-- Table structure for table `cms_contact`
-- 

CREATE TABLE `cms_contact` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `friends` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `man` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`user_id`,`from_id`),
  KEY `time` (`time`),
  KEY `ban` (`ban`)
) ENGINE=MyISAM AUTO_INCREMENT=366 DEFAULT CHARSET=utf8mb4;



-- --------------------------------------------------------
-- 
-- Table structure for table `cms_counters`
-- 

CREATE TABLE `cms_counters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sort` int(10) NOT NULL DEFAULT '1',
  `name` varchar(30) NOT NULL,
  `link1` text NOT NULL,
  `link2` text NOT NULL,
  `mode` tinyint(4) NOT NULL DEFAULT '1',
  `switch` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;
 

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_forum_files`
-- 

CREATE TABLE `cms_forum_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat` int(10) unsigned NOT NULL DEFAULT '0',
  `subcat` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` int(10) unsigned NOT NULL DEFAULT '0',
  `post` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `filename` text NOT NULL,
  `filetype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `dlcount` int(10) unsigned NOT NULL DEFAULT '0',
  `del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat` (`cat`),
  KEY `subcat` (`subcat`),
  KEY `topic` (`topic`),
  KEY `post` (`post`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_forum_rdm`
-- 

CREATE TABLE `cms_forum_rdm` (
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic_id`,`user_id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_forum_vote`
-- 

CREATE TABLE `cms_forum_vote` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(2) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_forum_vote_users`
-- 

CREATE TABLE `cms_forum_vote_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `topic` int(11) NOT NULL,
  `vote` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_library_comments`
-- 

CREATE TABLE `cms_library_comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(11) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_library_rating`
-- 

CREATE TABLE `cms_library_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `st_id` int(11) NOT NULL,
  `point` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`st_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_mail`
-- 

CREATE TABLE `cms_mail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sys` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `delete` int(10) unsigned NOT NULL DEFAULT '0',
  `file_name` varchar(100) NOT NULL DEFAULT '',
  `count` int(10) NOT NULL DEFAULT '0',
  `size` int(10) NOT NULL DEFAULT '0',
  `them` varchar(100) NOT NULL DEFAULT '',
  `spam` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `from_id` (`from_id`),
  KEY `time` (`time`),
  KEY `read` (`read`),
  KEY `sys` (`sys`),
  KEY `delete` (`delete`)
) ENGINE=MyISAM AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4;


-- --------------------------------------------------------
-- 
-- Table structure for table `cms_news`
-- 

CREATE TABLE `cms_news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `text` text NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(11) unsigned NOT NULL,
  `reads` int(11) NOT NULL,
  `img` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `refid` (`refid`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_news_cat`
-- 

CREATE TABLE `cms_news_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `realid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `realid` (`realid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Dumping data for table `cms_news_cat`
-- 

INSERT INTO `cms_news_cat` VALUES ('1','1','Sayt yangiliklari');

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_news_comments`
-- 

CREATE TABLE `cms_news_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL,
  `time` int(11) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `time` (`time`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=246 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_sessions`
-- 

CREATE TABLE `cms_sessions` (
  `session_id` char(32) NOT NULL DEFAULT '',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` varchar(255) NOT NULL DEFAULT '',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `sestime` int(10) unsigned NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `movings` smallint(5) unsigned NOT NULL DEFAULT '0',
  `place` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;


-- --------------------------------------------------------
-- 
-- Table structure for table `cms_settings`
-- 

CREATE TABLE `cms_settings` (
  `key` tinytext NOT NULL,
  `val` text NOT NULL,
  PRIMARY KEY (`key`(30))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Dumping data for table `cms_settings`
-- 

INSERT INTO `cms_settings` VALUES ('active','1');
INSERT INTO `cms_settings` VALUES ('admp','panel');
INSERT INTO `cms_settings` VALUES ('antiflood','a:5:{s:4:"mode";i:2;s:3:"day";i:4;s:5:"night";i:31;s:7:"dayfrom";i:6;s:5:"dayto";i:23;}');
INSERT INTO `cms_settings` VALUES ('clean_time','1535623626');
INSERT INTO `cms_settings` VALUES ('copyright','Menejer.CF - Yangicha Ko&#039;rinishtagi Futbol Menejer!');
INSERT INTO `cms_settings` VALUES ('email','');
INSERT INTO `cms_settings` VALUES ('flsz','4000');
INSERT INTO `cms_settings` VALUES ('gzip','1');
INSERT INTO `cms_settings` VALUES ('homeurl','');
INSERT INTO `cms_settings` VALUES ('karma','a:6:{s:12:"karma_points";i:5;s:10:"karma_time";i:86400;s:5:"forum";i:20;s:4:"time";i:0;s:2:"on";i:1;s:3:"adm";i:0;}');
INSERT INTO `cms_settings` VALUES ('lng','uz');
INSERT INTO `cms_settings` VALUES ('mod_reg','2');
INSERT INTO `cms_settings` VALUES ('mod_forum','2');
INSERT INTO `cms_settings` VALUES ('mod_guest','0');
INSERT INTO `cms_settings` VALUES ('mod_lib','2');
INSERT INTO `cms_settings` VALUES ('mod_gal','2');
INSERT INTO `cms_settings` VALUES ('mod_down_comm','1');
INSERT INTO `cms_settings` VALUES ('mod_down','2');
INSERT INTO `cms_settings` VALUES ('mod_lib_comm','1');
INSERT INTO `cms_settings` VALUES ('mod_gal_comm','1');
INSERT INTO `cms_settings` VALUES ('meta_desc','MENEJER.CF - FUTBOL MENEJER!');
INSERT INTO `cms_settings` VALUES ('meta_key','futbol, real madrid, ronaldo, messi, futbol menejer, barselona, 2018, 2019, neymar, mbappe, kubok, turnir');
INSERT INTO `cms_settings` VALUES ('news','a:8:{s:4:"view";i:2;s:4:"size";i:200;s:8:"quantity";i:10;s:4:"days";i:0;s:6:"breaks";b:1;s:7:"smileys";b:1;s:4:"tags";b:1;s:3:"kom";b:0;}');
INSERT INTO `cms_settings` VALUES ('reg_message','');
INSERT INTO `cms_settings` VALUES ('setting_mail','');
INSERT INTO `cms_settings` VALUES ('skindef','default');
INSERT INTO `cms_settings` VALUES ('them_message','');
INSERT INTO `cms_settings` VALUES ('timeshift','0');
INSERT INTO `cms_settings` VALUES ('site_access','2');
INSERT INTO `cms_settings` VALUES ('lng_list','a:3:{s:2:"uz";s:9:"Ozbekcha";s:2:"uz";s:9:"Ozbekcha";s:2:"uz";s:9:"Ozbekcha";}');

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_users_data`
-- 

CREATE TABLE `cms_users_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(30) NOT NULL DEFAULT '',
  `val` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_users_guestbook`
-- 

CREATE TABLE `cms_users_guestbook` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_users_iphistory`
-- 

CREATE TABLE `cms_users_iphistory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `user_ip` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=2334 DEFAULT CHARSET=utf8mb4;


-- --------------------------------------------------------
-- 
-- Table structure for table `download`
-- 

CREATE TABLE `download` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL DEFAULT '0',
  `adres` text NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `type` varchar(4) NOT NULL DEFAULT '',
  `avtor` varchar(25) NOT NULL DEFAULT '',
  `ip` text NOT NULL,
  `soft` text NOT NULL,
  `text` text NOT NULL,
  `screen` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `refid` (`refid`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `fanclub`
-- 

CREATE TABLE `fanclub` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `sport` varchar(50) NOT NULL DEFAULT '',
  `count` varchar(50) NOT NULL DEFAULT '',
  `user` int(11) NOT NULL DEFAULT '0',
  `plus` int(11) NOT NULL DEFAULT '0',
  `minus` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Dumping data for table `fanclub`
-- 

INSERT INTO `fanclub` VALUES ('1','Real Madrid CF','Futbol','Ispaniya','0','7','3');
INSERT INTO `fanclub` VALUES ('2','FC Chelsea','Futbol','Angliya','0','7','1');
INSERT INTO `fanclub` VALUES ('3','FC Barcelona','Futbol','Ispaniya','0','6','2');
INSERT INTO `fanclub` VALUES ('4','Manchester United','Futbol','Angliya','0','4','1');
INSERT INTO `fanclub` VALUES ('5','FC Liverpool','Futbol','Angliya','0','5','0');
INSERT INTO `fanclub` VALUES ('6','FC Arsenal','Futbol','Angliya','0','1','1');
INSERT INTO `fanclub` VALUES ('7','Manchester City','Futbol','Angliya','0','3','1');
INSERT INTO `fanclub` VALUES ('8','Juventus','Futbol','Italiya','0','5','2');
INSERT INTO `fanclub` VALUES ('9','AC Milan','Futbol','Italiya','0','0','2');
INSERT INTO `fanclub` VALUES ('10','SSC Napoli','Futbol','Italiya','0','2','0');
INSERT INTO `fanclub` VALUES ('11','Bayern Munchen','Futbol','Germaniya','0','2','1');
INSERT INTO `fanclub` VALUES ('12','Borussiya Dortmund','Futbol','Germaniya','0','2','0');
INSERT INTO `fanclub` VALUES ('13','PSG','Futbol','Fransiya','0','2','1');
INSERT INTO `fanclub` VALUES ('14','Olympique Lyonnais','Futbol','Fransiya','0','1','1');

-- --------------------------------------------------------
-- 
-- Table structure for table `fanclub_komm`
-- 

CREATE TABLE `fanclub_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `komm` varchar(500) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `fanclub_vote`
-- 

CREATE TABLE `fanclub_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `count` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `fman_clubs`
-- 

CREATE TABLE `fman_clubs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `name` text,
  `city` text,
  `land` text,
  `budj` int(11) DEFAULT NULL,
  `stadion` text,
  `stadv` int(11) DEFAULT NULL,
  `fan` int(11) DEFAULT NULL,
  `tituls` text,
  `tren` int(11) DEFAULT NULL,
  `v` int(11) DEFAULT NULL,
  `n` int(11) DEFAULT NULL,
  `p` int(11) DEFAULT NULL,
  `zg` int(11) DEFAULT NULL,
  `pg` int(11) DEFAULT NULL,
  `o` int(11) DEFAULT NULL,
  `tak` int(11) DEFAULT NULL,
  `p1` int(11) DEFAULT NULL,
  `p2` int(11) DEFAULT NULL,
  `p3` int(11) DEFAULT NULL,
  `p4` int(11) DEFAULT NULL,
  `p5` int(11) DEFAULT NULL,
  `p6` int(11) DEFAULT NULL,
  `p7` int(11) DEFAULT NULL,
  `p8` int(11) DEFAULT NULL,
  `p9` int(11) DEFAULT NULL,
  `p10` int(11) DEFAULT NULL,
  `p11` int(11) DEFAULT NULL,
  `u2` int(11) DEFAULT NULL,
  `u3` int(11) DEFAULT NULL,
  `u4` int(11) DEFAULT NULL,
  `u5` int(11) DEFAULT NULL,
  `u6` int(11) DEFAULT NULL,
  `u7` int(11) DEFAULT NULL,
  `u8` int(11) DEFAULT NULL,
  `u9` int(11) DEFAULT NULL,
  `u10` int(11) DEFAULT NULL,
  `u11` int(11) DEFAULT NULL,
  `uvol_count` int(11) DEFAULT NULL,
  `buy_count` int(11) DEFAULT NULL,
  `trans_count` int(11) DEFAULT NULL,
  `stad_work` int(11) DEFAULT NULL,
  `union_mod` int(1) NOT NULL,
  `stad_ned` int(11) DEFAULT NULL,
  `win` int(11) NOT NULL DEFAULT '0',
  `draw` int(11) NOT NULL DEFAULT '0',
  `lose` int(11) NOT NULL DEFAULT '0',
  `oput` int(11) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=99 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Dumping data for table `fman_clubs`
-- 

INSERT INTO `fman_clubs` VALUES ('1','67','Manchester United','Manchester','en','21342950','Old Trafford','20000','151',NULL,'3','3','0','4','22','21','9','5','1','2','4','5','6','9','8','10','13','18','17','0','0','0','0','0','0','1535171185','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'2','0','3','40','1');
INSERT INTO `fman_clubs` VALUES ('2','57','FC Chelsea','London','en','22650875','Stamford Bridge','20000','159',NULL,'10','5','1','3','25','15','16','2','19','21','23','22','28','27','31','26','33','25','34','0','0','0','0','0','0','1535119355','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'1','1','4','120','1');
INSERT INTO `fman_clubs` VALUES ('3','16','Manchester City','Manchester','en','41571604','Etihad Stadium','90000','922',NULL,'3','6','1','0','27','3','19','5','35','36','37','38','40','43','2512','48','45','50','51','0','0','0','0','0','0','1535119228','1',NULL,NULL,'0','0','0','90000','0','0','5','2','0','80','1');
INSERT INTO `fman_clubs` VALUES ('4','91','FC Arsenal','London','en','21895600','Emirates Stadium','20000','140',NULL,'3','4','0','3','25','17','12','5','52','57','54','56','55','58','59','60','64','66','67','0','0','0','0','0','0','1535389269','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('5','85','Tottenham Hotspur','London','en','26242300','White Hart Lane','20000','51',NULL,'2','3','0','4','15','22','9','5','68','71','73','74','76','78','79','80','83','85','86','0','0','0','0','0','0','1535391975','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('6','92','FC Liverpool','Liverpool','en','40314550','Anfield Road','20000','583',NULL,'3','7','1','0','44','1','22','5','87','88','91','92','93','94','95','97','99','98','100','0','0','0','0','0','0','1535389807','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','1','20','1');
INSERT INTO `fman_clubs` VALUES ('7','58','FC Everton','Liverpool','en','24077500','Craven Cottage','21000','26',NULL,'3','0','1','6','5','22','1','4','102','104','107','106','110','112','115','117','122','124','123','0','0','0','0','0','0','1535203716','1',NULL,NULL,'0','0','0','21000','0','0','0','0','2','20','1');
INSERT INTO `fman_clubs` VALUES ('8','93','Leicester City','Leicester City','en','1622500','King Power Stadium','20000','37',NULL,'2','1','2','0','8','7','5','4','125','127','129','128','130','132','133','139','134','131','137','0','0','0','0','0','0','1535631513','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('9','0','AFC Hull City','Kingstone-apon-hull','en','19307500','KCOM Stadium','20000','2',NULL,'1','0','1','1','2','4','1','1','141','142','143','144','148','149','150','151','152','157','158','0','0','0','0','0','0','1535214204','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('10','116','FC Sunderland','Sunderland','en','18142500','Stadium Of Light','20000','14',NULL,'1','2','1','0','6','3','7','1','162','165','166','167','172','173','174','175','176','183','184','0','0','0','0','0','0','1535691959','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('11','0','West Bromwich Albion','West Bromwich','en','20177500','The Hawthorns','20000','0',NULL,'1','0','0','2','1','15','0','1','188','190','191','192','196','197','198','199','200','207','208','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('12','0','Burnley FC','Burnley','en','18206250','Turf Moor','20000','4',NULL,'1','0','2','1','4','5','2','1','212','214','215','216','222','223','224','225','226','232','233','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('13','0','Stoke City','Stoke-on-Trent','en','19180000','Britannia Stadium','20000','6',NULL,'1','1','0','1','3','11','3','1','237','238','239','240','245','246','247','248','249','255','256','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('14','0','Crystal Palace','London','en','18397500','Selhurst Park','20000','8',NULL,'1','1','1','1','7','13','4','1','261','262','263','264','271','272','273','274','275','280','281','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('15','0','FC Southampton','Brittania Road','en','18967500','St Marys Stadium','20000','2',NULL,'1','0','1','1','1','4','1','1','283','285','286','287','293','294','295','296','297','300','305','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('16','0','FC Watford','Watford','en','19333750','Vicarage Road','20000','2',NULL,'1','0','1','2','2','12','1','1','312','315','316','317','323','324','325','326','327','322','330','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('17','112','FC West Ham','Green Street London','en','20095000','Boleyn Ground','20000','0',NULL,'13','0','0','2','1','13','0','4','335','338','339','340','345','346','347','348','349','356','357','0','0','0','0','0','0','1535690929','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('18','0','AFC Bournemouth','Dean Court','en','18951250','Vitality Stadium','20000','8',NULL,'1','1','1','1','5','5','4','1','361','365','366','367','375','376','377','378','379','385','386','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('19','0','FC Middlesbrough','Middlesbrough','en','19206250','Riverside Stadium','20000','2',NULL,'1','0','1','2','3','16','1','1','390','393','394','395','402','403','404','405','406','411','412','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('20','0','Swansea City','Landore Swansea','en','19116250','Liberty Stadium','20000','8',NULL,'1','1','1','1','6','5','4','1','415','417','418','420','426','427','428','429','430','433','434','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('21','110','AC Milan','Milano','it','21235150','Giuseppe Meazza','20000','11',NULL,'1','0','3','0','3','3','3','1','442','443','444','445','449','450','451','452','453','457','446','0','0','0','0','0','0','1535690802','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'1','2','1','80','1');
INSERT INTO `fman_clubs` VALUES ('22','28','FC Inter','Milano','it','17842500','St Meazza','20000','14',NULL,'1','2','1','0','10','2','7','1','458','462','463','464','467','473','474','475','476','482','483','0','0','0','0','0','0','1535130495','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','1','20','1');
INSERT INTO `fman_clubs` VALUES ('23','14','SSC Napoli','Napoli','it','2047483647','San paolo','70000','267',NULL,'3','5','0','2','33','12','15','5','488','494','489','499','492','501','510','502','503','496','2509','0','0','0','0','0','0','1535124989','1',NULL,NULL,'0','0','0','70000','0','0','7','0','2','160','2');
INSERT INTO `fman_clubs` VALUES ('24','0','Udinese Calcio','Udine','it','17696250','Friuli','20000','6',NULL,'1','0','3','0','4','4','3','1','514','516','517','518','530','531','532','533','534','542','543','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('25','7','SS Lazio','Rome','it','19515350','Olimpico Di Rome','20000','51',NULL,'1','0','3','0','5','5','3','3','547','552','556','557','555','561','563','562','560','573','566','0','0','0','0','0','0','1535208220','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'1','0','2','60','1');
INSERT INTO `fman_clubs` VALUES ('26','60','AS Roma','Rome','it','17823750','Stadio Olimpico','20000','8',NULL,'1','1','1','1','5','4','4','1','574','578','579','580','588','589','590','591','592','598','600','0','0','0','0','0','0','1535121923','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('27','10','Juventus','Torino','it','29889800','Juventus Stadium','25000','324',NULL,'3','5','1','1','36','5','16','5','605','609','608','610','607','611','613','2510','618','620','617','0','0','0','0','0','0','1535119379','1',NULL,NULL,'0','0','0','25000','0','0','8','4','2','200','2');
INSERT INTO `fman_clubs` VALUES ('28','0','Palermo','Palermo','it','-29000','Renzo Barbera','27000','17',NULL,'3','2','1','0','8','1','7','1','621','631','625','626','628','630','640','639','646','650','651','0','0','0','0','0','0','1535208785','1',NULL,NULL,'0','0','0','27000','0','0','0','0','3','60','1');
INSERT INTO `fman_clubs` VALUES ('29','0','Fiorentina','Florence','it','17955000','Stadio Artemio Franchi','20000','8',NULL,'1','1','1','1','4','4','4','1','652','655','656','657','666','667','668','669','670','672','678','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('30','0','FC Genoa','Genoa','it','18206250','Stadio Luigi Ferraris','20000','4',NULL,'1','0','2','1','4','9','2','1','681','683','684','685','690','691','692','693','694','699','700','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('31','87','Empoli','Empoli','it','19142500','Carlo Castellani ','20000','25',NULL,'1','0','2','1','2','6','2','1','706','709','710','711','715','716','717','718','719','726','727','0','0','0','0','0','0','1535266547','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','1','0','1');
INSERT INTO `fman_clubs` VALUES ('32','0','FC Crotone','Crotone','it','18142500','Ezio Scida','20000','14',NULL,'1','2','1','0','8','1','7','1','732','735','736','737','741','742','743','744','745','753','754','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('33','0','Chievo Verona','Verona','it','18967500','Marcantonio Bentegodi','20000','6',NULL,'1','1','0','1','4','12','3','1','758','762','763','764','772','773','774','775','776','781','782','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('34','0','Cagliari Calcio','Cagliari','it','18142500','Stadio Sant Elia','20000','2',NULL,'1','0','1','2','2','7','1','1','787','791','792','793','800','801','802','803','804','808','809','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('35','0','FC Torino','Turin','it','18270000','Stadio Olimpico','20000','4',NULL,'1','0','2','1','4','8','2','1','813','814','815','816','824','825','826','827','828','831','832','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('36','0','FC Bologna','Bologna','it','18887500','St Renato Dall-Ara','20000','8',NULL,'1','1','1','1','6','7','4','1','837','841','842','843','852','853','854','855','856','859','860','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('37','0','Uc Sampdoria','Genova','it','20095000','Luigi Ferraris','20000','2',NULL,'1','0','1','1','2','4','1','1','867','871','872','873','877','878','879','880','881','886','887','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('38','0','Atalanta Bergamo','Bergamo','it','19333750','Atleti Azzurri','20000','10',NULL,'1','1','2','0','8','5','5','1','893','895','896','897','902','903','904','905','906','912','913','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('39','0','FC Pescara','Pescara','it','18887500','Stadio Adriatico','20000','8',NULL,'1','1','1','1','3','4','4','1','916','920','921','922','929','930','931','932','933','941','942','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('40','0','US Sassuolo','Reggio Emilia','it','17931250','Citta Del','20000','0',NULL,'1','0','0','3','2','16','0','1','946','949','950','951','957','958','959','960','961','962','963','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('41','81','Real Madrid CF','Madrid','es','6579150','Santiago Bernabeu','29000','133',NULL,'3','4','2','1','29','8','14','5','991','997','995','1006','996','1004','1005','1002','618','1015','1010','0','0','0','0','0','0','1535630059','1',NULL,NULL,'0','0','0','29000','0','0','1','0','1','40','1');
INSERT INTO `fman_clubs` VALUES ('42','103','FC Barcelona','Barselona','es','63623000','Camp Nou','20000','454',NULL,'3','7','0','0','49','2','21','5','1016','1018','1022','1019','1021','1024','1032','1028','1038','1035','1037','0','0','0','0','0','0','1535650229','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'1','0','1','40','1');
INSERT INTO `fman_clubs` VALUES ('43','106','FC Valencia','Valencia','es','20076250','Mestalla','20000','7',NULL,'1','0','2','5','2','37','2','1','1039','1041','1042','1043','1049','1050','1051','1052','1053','1057','1058','0','0','0','0','0','0','1535689234','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('44','0','FC Villarreal','Villarreal','es','20137500','El Madrigal','20000','14',NULL,'1','1','1','0','5','2','4','1','1060','1062','1063','1064','1070','1071','1072','1073','1074','1080','1081','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('45','107','FC Sevilla','Sevilla','es','20501300','Ramon Sanchez Pizjuan','20000','9',NULL,'2','0','2','0','2','2','2','2','1085','1088','1087','1089','1094','1096','1097','1099','1102','1107','1105','0','0','0','0','0','0','1535689857','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'1','2','3','120','1');
INSERT INTO `fman_clubs` VALUES ('46','3','Athletic Bilbao','Bilbao','es','18175000','Nuevo San Mames','20000','19',NULL,'1','1','2','0','6','3','5','1','1108','1110','1111','1112','1119','1120','1121','1122','1123','1129','1130','0','0','0','0','0','0','1535213412','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','2','40','1');
INSERT INTO `fman_clubs` VALUES ('47','65','Atletico Madrid','Madrid','es','19224800','Vicente Calderon','20000','152',NULL,'3','3','1','3','27','13','10','5','1133','1135','1134','1136','1143','1144','1142','1146','1148','1145','1147','0','0','0','0','0','0','1535119230','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'1','0','1','40','1');
INSERT INTO `fman_clubs` VALUES ('48','0','Espanyol Barcelona','Barcelona','es','19397500','Carnella-El Prat','20000','6',NULL,'1','1','0','2','4','14','3','1','1149','1151','1152','1153','1158','1159','1160','1161','1162','1166','1167','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('49','0','Las Palmas','Deportivo','es','18206250','Gran Canaria','20000','4',NULL,'1','0','2','1','4','5','2','1','1171','1174','1175','1176','1183','1184','1185','1186','1187','1191','1192','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('50','0','FC Celta Vigo','Vigo','es','18333750','Balaidos','20000','2',NULL,'1','0','1','2','2','10','1','1','1196','1198','1199','1200','1203','1204','1205','1206','1207','1215','1216','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('51','0','FC Malaga','Malaga','es','20010000','La Rosaleda','20000','2',NULL,'1','0','1','1','0','7','1','1','1219','1221','1222','1223','1230','1231','1232','1233','1234','1241','1242','0','0','0','0','0','0','1535218653','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('52','0','Sporting Gijon','Sporting','es','18142500','Estadio El Molinon','20000','8',NULL,'1','1','1','1','7','4','4','1','1247','1249','1250','1251','1257','1258','1259','1260','1261','1269','1270','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('53','0','Deportivo','La Coruna','es','19222500','Municipal de Riazor','20000','8',NULL,'1','1','1','0','4','1','4','1','1273','1275','1276','1277','1283','1284','1285','1286','1287','1291','1292','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('54','0','CD Leganes','Leganes','es','18397500','Butarke','20000','4',NULL,'1','0','2','1','4','6','2','1','1296','1298','1299','1300','1306','1307','1308','1309','1310','1315','1316','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('55','84','Real Sociedad','San Sebastian','es','18397500','Anoeta','20000','4',NULL,'1','0','2','1','2','12','2','1','1318','1320','1321','1322','1327','1328','1329','1330','1331','1335','1336','0','0','0','0','0','0','1535629214','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('56','0','Deportivo Alaves','Vitoria-Gasteiz','es','19015000','Mendisorrosa','20000','8',NULL,'1','1','1','1','5','7','4','1','1340','1343','1344','1345','1352','1353','1354','1355','1356','1364','1365','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('57','0','SD Eibar','Deportivo','es','20097500','Municipal de Ipurua','20000','6',NULL,'1','0','0','2','1','14','0','1','1368','1370','1371','1372','1380','1381','1382','1383','1384','1389','1390','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('58','0','FC Rayo Vallecano','Madrid','es','19397500','Campo de Futbol','20000','8',NULL,'1','1','1','1','7','5','4','1','1394','1396','1397','1398','1403','1404','1405','1406','1407','1413','1414','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('59','0','FC Real Betis','Sevilla','es','19078750','Benito Villamarin','20000','10',NULL,'1','1','2','0','6','4','5','1','1416','1419','1420','1421','1428','1429','1430','1431','1432','1439','1440','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('60','0','Espanyol','Barselona','es','19270000','Carnella-El Prat','20000','12',NULL,'1','2','0','1','6','13','6','1','1443','1445','1446','1447','1454','1455','1456','1457','1458','1463','1464','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('61','0','LOSC Lille','Villeuve','fr','19015000','St Pierre-Mauroy','20000','8',NULL,'1','1','1','1','5','9','4','1','1467','1471','1472','1473','1480','1481','1482','1483','1484','1486','1487','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('62','0','Olympique Marseille','Marseille','fr','18270000','Stade Velodrome','20000','8',NULL,'1','1','1','1','4','7','4','1','1495','1498','1499','1500','1506','1507','1508','1509','1510','1512','1513','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('63','104','Olympique Lyon','Lyon','fr','18823750','Stade de Gerland','20000','4',NULL,'1','0','2','1','5','6','2','1','1519','1522','1523','1524','1535','1536','1537','1538','1539','1544','1545','0','0','0','0','0','0','1535688187','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('64','13','Paris Saint-Germain','Paris','fr','24785075','Parc des Princes','20000','211',NULL,'3','5','0','3','29','12','15','5','1551','1552','1553','1555','1554','1560','1562','1565','1564','1566','1567','0','0','0','0','0','0','1535120520','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'3','0','4','120','1');
INSERT INTO `fman_clubs` VALUES ('65','0','SCO Angers','Angers','fr','20140000','Stade Jean-Bouin','20000','4',NULL,'1','0','2','0','2','2','2','1','1570','1572','1573','1574','1579','1580','1581','1582','1583','1588','1589','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('66','0','FC Rennais','Lorient','fr','18142500','Route de Lorient','20000','4',NULL,'1','0','2','1','1','3','2','1','1594','1597','1598','1599','1606','1607','1608','1609','1610','1615','1616','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('67','0','FC Girondins Bordeaux','Bordeaux','fr','18015000','Matmut Atlantique','20000','10',NULL,'1','1','2','0','5','4','5','1','1620','1624','1625','1626','1633','1634','1635','1636','1637','1642','1643','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('68','0','FC Toulouse','Toulouse','fr','19270000','Stadium Municipal','20000','8',NULL,'1','1','1','1','5','5','4','1','1648','1652','1653','1654','1659','1660','1661','1662','1663','1669','1670','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('69','109','AS Monaco','Monaco','fr','31979606','Stade Louis-II','20000','60',NULL,'3','1','2','0','3','1','5','2','1672','1679','1675','1676','1674','1683','1684','1685','1696','1700','1697','0','0','0','0','0','0','1535690609','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'1','0','1','0','1');
INSERT INTO `fman_clubs` VALUES ('70','0','As Saint-Etienne','Saint-Etienne','fr','18206250','Geoffroy-Guichard','20000','4',NULL,'1','0','2','1','3','5','2','1','1707','1710','1711','1712','1719','1720','1721','1722','1723','1727','1728','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('71','0','FC Lorient','Lorient','fr','18951250','Stade du Moustoir','20000','2',NULL,'1','0','1','2','4','7','1','1','1732','1735','1736','1737','1742','1743','1744','1745','1746','1752','1753','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('72','0','FCO Dijon','Dijon','fr','18206250','Stade Gaston Gerard, Dijon','20000','4',NULL,'1','0','2','1','2','4','2','1','1761','1764','1765','1766','1773','1774','1775','1776','1777','1783','1784','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('73','0','FC Nantes','Nantes','fr','18142500','De la Beaujoire','20000','6',NULL,'1','0','3','0','5','5','3','1','1786','1789','1790','1791','1799','1800','1801','1802','1803','1807','1808','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('74','0','HSC Montpellier','Montpellier','fr','18078750','	Stade de la Mosson','20000','2',NULL,'1','0','1','2','2','6','1','1','1812','1816','1817','1818','1824','1825','1826','1827','1828','1832','1833','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('75','0','AS Nancy','Tomblaine','fr','18142500','Stade Marcel Picot, Tomblaine','20000','10',NULL,'1','1','2','0','7','2','5','1','1839','1842','1843','1844','1850','1851','1852','1853','1854','1860','1861','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('76','0','SC Bastia','Furiani','fr','19015000','St Armand-Cesari','20000','14',NULL,'1','2','1','0','6','3','7','1','1865','1868','1869','1870','1879','1880','1881','1882','1883','1887','1888','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('77','0','OGC Nice','Nice','fr','19142500','Allianz Riviera','20000','6',NULL,'1','0','3','0','6','6','3','1','1893','1896','1897','1898','1904','1905','1906','1907','1908','1913','1914','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('78','0','SM Caen','Caen','fr','18887500','Michel de Ornano','20000','8',NULL,'1','1','1','1','7','6','4','1','1919','1923','1924','1925','1932','1933','1934','1935','1936','1942','1943','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('79','0','FC Metz','Ajaccio','fr','19142500','Stade Saint-Symphorien, Metz','20000','12',NULL,'1','2','0','1','6','11','6','1','1949','1952','1953','1954','1961','1962','1963','1964','1965','1971','1972','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('80','0','EA Guingamp','Guingamp','fr','18887500','Stade du Roudourou','20000','8',NULL,'1','1','1','1','3','4','4','1','1975','1979','1980','1981','1988','1989','1990','1991','1992','2001','2002','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('81','105','BVB Borussia Dortmund','Dortmund','de','20611550','Signal Iduna Park','20000','16',NULL,'2','1','2','5','5','43','5','5','2005','2007','2008','2010','2011','2022','2021','2020','2014','2019','2025','0','0','0','0','0','0','1535688423','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('82','88','Bayer 04 Leverkusen','Leverkusen','de','18130000','Bay Arena','20000','19',NULL,'1','1','2','0','6','5','5','2','2029','2031','2032','2033','2037','2038','2039','2040','2041','2045','2046','0','0','0','0','0','0','1535419034','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','1','0','1');
INSERT INTO `fman_clubs` VALUES ('83','1','Bayern Munchen','München','de','22430900','Allianz-Arena','20000','191',NULL,'1','4','0','3','27','13','12','2','2047','2056','2051','2052','2050','2054','2062','2058','2055','2064','2065','0','0','0','0','0','0','1535119333','1',NULL,NULL,'0','0','0',NULL,'0',NULL,'6','3','4','180','2');
INSERT INTO `fman_clubs` VALUES ('84','0','RB Leipzig','Leipzig','de','18951250','Red Bull Arena','20000','4',NULL,'1','0','2','1','6','7','2','1','2066','2069','2070','2071','2078','2079','2080','2081','2082','2090','2091','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('85','0','FSV Mainz 05','Mainz','de','19078750','Coface Arena','20000','10',NULL,'1','1','2','0','5','3','5','1','2095','2098','2099','2100','2107','2108','2109','2110','2111','2116','2117','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('86','0','FC Ingolstadt 04','Ingolstadt','de','18882500','Audi SportPark','20000','14',NULL,'1','1','1','0','4','3','4','1','2122','2126','2127','2128','2135','2136','2137','2138','2139','2149','2150','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('87','0','Eintracht Frankfurt','Frankfurt','de','17760000','Commerzbank Arena','20000','10',NULL,'1','1','2','0','6','3','5','1','2153','2156','2157','2158','2166','2167','2168','2169','2170','2177','2178','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('88','0','Hamburger SV','Hamburg','de','18797500','Volksparkstadion','20000','4',NULL,'1','0','2','0','2','2','2','1','2185','2188','2189','2190','2198','2199','2200','2201','2202','2214','2215','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('89','0','SV Darmstadt 98','Darmstadt','de','18206250','Merck Stadion','20000','2',NULL,'1','0','1','2','1','5','1','1','2218','2221','2222','2223','2228','2229','2230','2231','2232','2237','2238','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('90','0','FC Koln','Köln Kremer','de','19015000','Rhein Energie Stadion','20000','6',NULL,'1','0','3','0','5','5','3','1','2243','2247','2248','2249','2254','2255','2256','2257','2258','2264','2265','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('91','0','TSG 1899 Hoffenheim','Sinsheim','de','18015000','Wirsol Rhein-Neckar-Arena','20000','8',NULL,'1','1','1','1','5','6','4','1','2271','2274','2275','2276','2284','2285','2286','2287','2288','2292','2293','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('92','0','SC Freiburg',' Freiburg im Breisgau','de','19142500','Schwarzwald-Stadion','20000','8',NULL,'1','1','1','1','5','5','4','1','2299','2301','2302','2303','2311','2312','2313','2314','2315','2319','2320','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('93','0','SV Werder Bremen','Bremen','de','18632500','Weserstadion','20000','10',NULL,'1','1','2','0','5','3','5','1','2325','2328','2329','2330','2339','2340','2341','2342','2343','2352','2353','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('94','86','Schalke 04','Gelsenkirchen','de','-842900','Veltins-Arena','29000','9',NULL,'1','0','3','0','5','5','3','1','2359','2363','2364','2365','2370','2374','2375','2377','2376','2382','2384','0','0','0','0','0','0','1535265694','1',NULL,NULL,'0','0','0','29000','0','0','0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('95','0','VFL Wolfsburg','Wolfsburg','de','17118750','Volkswagen Arena','20000','8',NULL,'1','1','1','1','2','3','4','1','2389','2392','2393','2394','2395','2404','2405','2406','2407','2419','2418','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('96','0','Borussia Munchengladbach','Mönchengladbach','de','19206250','Borussia-Park','20000','0',NULL,'1','0','0','3','3','13','0','1','2431','2433','2434','2435','2441','2442','2443','2444','2445','2451','2452','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('97','0','Hertha BSC','Berlin','de','18078750','Olympiastadion Berlin','20000','6',NULL,'1','0','3','0','5','5','3','1','2456','2459','2460','2461','2467','2468','2469','2470','2471','2478','2479','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');
INSERT INTO `fman_clubs` VALUES ('98','0','FC Augusburg','Augusburg','de','19206250','WWK Arena','20000','2',NULL,'1','0','1','2','3','8','1','1','2483','2485','2486','2487','2491','2492','2493','2494','2495','2503','2504','0','0','0','0','0','0',NULL,NULL,NULL,NULL,'0','0','0',NULL,'0',NULL,'0','0','0','0','1');

-- --------------------------------------------------------
-- 
-- Table structure for table `fman_clubs_build`
-- 

CREATE TABLE `fman_clubs_build` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `club_id` int(11) NOT NULL,
  `bid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------
-- 
-- Table structure for table `fman_clubs_spons`
-- 

CREATE TABLE `fman_clubs_spons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `club_id` int(11) NOT NULL,
  `sid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- --------------------------------------------------------
-- 
-- Table structure for table `fman_lands`
-- 

CREATE TABLE `fman_lands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` text,
  `name` text,
  `rod` text,
  `lig` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Dumping data for table `fman_lands`
-- 

INSERT INTO `fman_lands` VALUES ('1','en','Angliya','Angliya','Premier-League');
INSERT INTO `fman_lands` VALUES ('2','it','Italiya','Italiya','Seria A');
INSERT INTO `fman_lands` VALUES ('3','es','Ispaniya','Ispaniya','Laliga Santander');
INSERT INTO `fman_lands` VALUES ('4','fr','Fransiya','Fransiya','Liga 1');
INSERT INTO `fman_lands` VALUES ('5','de','Germaniya','Germaniya','Bundes Liga');

-- --------------------------------------------------------
-- 
-- Table structure for table `fman_matches`
-- 

CREATE TABLE `fman_matches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) DEFAULT NULL,
  `turn` text,
  `tur` int(11) DEFAULT NULL,
  `end` int(11) DEFAULT NULL,
  `kom1` text,
  `id1` int(11) DEFAULT NULL,
  `kom2` text,
  `id2` int(11) DEFAULT NULL,
  `sc1` int(11) DEFAULT NULL,
  `sc2` int(11) DEFAULT NULL,
  `s1` text,
  `s2` text,
  `s3` text,
  `s4` text,
  `s5` text,
  `s6` text,
  `s7` text,
  `s8` text,
  `s9` text,
  `s10` text,
  `s11` text,
  `s12` text,
  `s13` text,
  `s14` text,
  `s15` text,
  `s16` text,
  `s17` text,
  `s18` text,
  `s19` text,
  `s20` text,
  `land` text,
  `turnir` int(1) DEFAULT NULL,
  `union_team1` int(1) NOT NULL,
  `union_team2` int(1) NOT NULL,
  `id_match` int(11) NOT NULL,
  `pen1` int(1) DEFAULT NULL,
  `pen2` int(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2427 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `fman_news`
-- 

CREATE TABLE `fman_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) DEFAULT NULL,
  `pl_id` int(11) DEFAULT NULL,
  `name` text,
  `id1` int(11) DEFAULT NULL,
  `id2` int(11) DEFAULT NULL,
  `cena` int(11) DEFAULT NULL,
  `club_id` int(11) DEFAULT NULL,
  `text` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1083 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `fman_players`
-- 

CREATE TABLE `fman_players` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `team_id` int(11) DEFAULT NULL,
  `name` text,
  `rait` int(11) DEFAULT NULL,
  `travm` int(11) DEFAULT NULL,
  `trans` int(11) DEFAULT NULL,
  `cena` int(11) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL,
  `zarplat` int(11) DEFAULT NULL,
  `ampl` int(11) DEFAULT NULL,
  `foto` text,
  `age` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `nationality` text,
  `forma` int(11) DEFAULT NULL,
  `ust` int(11) DEFAULT NULL,
  `nast` int(11) DEFAULT NULL,
  `u` int(11) DEFAULT NULL,
  `vyn` int(11) DEFAULT NULL,
  `drib` int(11) DEFAULT NULL,
  `pas` int(11) DEFAULT NULL,
  `ig` int(11) DEFAULT NULL,
  `otb` int(11) DEFAULT NULL,
  `priem` int(11) DEFAULT NULL,
  `f` int(11) DEFAULT NULL,
  `toch` int(11) DEFAULT NULL,
  `gk` int(11) DEFAULT NULL,
  `ball` int(11) DEFAULT NULL,
  `trans_time` int(11) DEFAULT NULL,
  `goals` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2514 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Dumping data for table `fman_players`
-- 

INSERT INTO `fman_players` VALUES ('1','1','David de Gea','20',NULL,NULL,NULL,'1',NULL,'1','https://s5o.ru/storage/simple/ru/edt/86/70/06/93/rue8a8ab62924.png','20','193','Spain','6','6','6','0','3','0','0','0','4','0','1','0','6','254',NULL,'0');
INSERT INTO `fman_players` VALUES ('2','1','Luke Shaw','20',NULL,NULL,NULL,'2',NULL,'2','https://s5o.ru/storage/simple/ru/edt/8e/92/10/d8/rue60bd9976a5.png','20','185','England','6','6','6','5','4','0','0','6','3','0','1','1','0','454',NULL,'0');
INSERT INTO `fman_players` VALUES ('3','1','Viktor Lindelof','20',NULL,NULL,NULL,'10',NULL,'2','https://s5o.ru/storage/simple/ru/edt/1f/c8/1c/79/rue7283b681aa.png','20','187','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('4','1','Marcos Rojo','20',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/images/portrait/medium/93176-1407486895.jpg','20','186','Argentina','6','6','6','5','3','0','1','7','2','0','1','0','0','454',NULL,'0');
INSERT INTO `fman_players` VALUES ('5','1','Eric Bailly','20',NULL,NULL,NULL,'3',NULL,'3','https://s5o.ru/storage/simple/ru/edt/57/79/91/12/rue45648200ff.jpg','20','188','Kot-D-Ivoire','6','6','6','4','4','0','0','5','2','0','1','1','0','1014',NULL,'0');
INSERT INTO `fman_players` VALUES ('6','1','Matteo Darmian','20',NULL,NULL,NULL,'4',NULL,'4','https://s5o.ru/storage/simple/ru/edt/84/70/47/92/ruec9409bc2c2.png','20','182','Italy','6','6','6','6','2','2','1','5','4','0','0','0','0','494',NULL,'0');
INSERT INTO `fman_players` VALUES ('7','1','Ashley Young','20',NULL,NULL,NULL,'4',NULL,'4','https://s5o.ru/storage/simple/ru/edt/73/d4/60/e7/rue438e3e21c1.png','20','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('8','1','Paul Pogba','20',NULL,NULL,NULL,'7',NULL,'7','https://s5o.ru/storage/simple/ru/edt/66/97/67/77/rue8b315d3f2c.png','20','191','France','6','6','6','4','0','3','3','5','0','3','2','2','0','480',NULL,'0');
INSERT INTO `fman_players` VALUES ('9','1','Marouane Fellaini','20',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/dd/9c/90/ae/ruece70863cde.png','20','194','Belgium','6','6','6','3','2','3','3','5','2','2','3','3','0','454',NULL,'16');
INSERT INTO `fman_players` VALUES ('10','1','Juan Mata','20',NULL,NULL,NULL,'8',NULL,'8','https://s5o.ru/storage/simple/ru/edt/cd/48/5b/a4/rue3c4842a191.png','20','170','Spain','6','6','6','3','2','3','3','3','2','2','2','2','0','1054',NULL,'23');
INSERT INTO `fman_players` VALUES ('11','1','Andreas Pereyra','20',NULL,NULL,NULL,'5',NULL,'5','https://s5o.ru/storage/simple/ru/edt/19/2b/12/f8/rue993697325b.png','20','177','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','174',NULL,'0');
INSERT INTO `fman_players` VALUES ('12','1','Fred','20',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/19/28/82/33/rueb7d8f7bf4a.jpeg','20','169','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('13','1','Alexis Sanchez','18',NULL,'0','0','10','0','9','https://s5o.ru/storage/simple/ru/edt/b5/ac/2e/3a/rued63f62284d.png','29','171','Chile','6','6','6','3','0','0','0','3','0','0','1','2','0','422','0','10');
INSERT INTO `fman_players` VALUES ('14','1','Anthony Martial','20',NULL,NULL,NULL,'7',NULL,'7','https://s5o.ru/storage/simple/ru/edt/40/3c/67/e6/rue63eaff2a92.png','20','181','France','6','6','6','1','1','2','0','4','5','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('15','1','Jesse Lingard','20',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/28/f2/2f/0e/rue112010a6b7.png','20','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('16','1','Scott Mc Tominay','20',NULL,NULL,NULL,'5',NULL,'5','https://s5o.ru/storage/simple/ru/edt/1f/64/4b/db/ruead41227af9.png','20','193','Scotland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('17','1','Romelu Lukaku','20',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/87/69/50/64/rue83db7f87ce.png','20','192','Belgium','6','6','6','6','1','2','1','5','2','1','3','3','0','334',NULL,'44');
INSERT INTO `fman_players` VALUES ('18','1','Markus Rashford','20',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/84/60/08/79/ruefa38b14b9f.png','20','180','England','6','6','6','5','2','3','1','6','2','1','3','3','0','134',NULL,'43');
INSERT INTO `fman_players` VALUES ('19','2','Kepa Arizzabalaga','18',NULL,NULL,NULL,'1',NULL,'1','https://s5o.ru/storage/simple/ru/edt/44/31/60/95/rueb2dc9aadd8.jpeg','23','189','Spain','6','6','6','0','1','0','1','0','0','0','0','0','5','952',NULL,'0');
INSERT INTO `fman_players` VALUES ('20','2','Marcos Alonso','18',NULL,NULL,NULL,'0',NULL,'2','https://s5o.ru/storage/simple/ru/edt/de/11/ab/f7/rueaf40821831.png','27','189','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('21','2','Cesar Azpilicueta','18',NULL,NULL,NULL,'2',NULL,'3','https://s5o.ru/storage/simple/ru/edt/44/49/10/77/rue91bc1ddd1c.png','28','178','Spain','6','6','6','0','1','0','3','2','4','1','0','0','0','1392',NULL,'0');
INSERT INTO `fman_players` VALUES ('22','2','Antoine Rudiger','18',NULL,NULL,NULL,'4',NULL,'4','https://s5o.ru/storage/simple/ru/edt/54/da/dd/f4/ruee322cf99e4.png','25','191','Germany','6','6','6','0','1','0','5','2','1','1','0','0','0','1392',NULL,'0');
INSERT INTO `fman_players` VALUES ('23','2','David Luiz','18',NULL,NULL,NULL,'3',NULL,'3','https://s5o.ru/storage/simple/ru/edt/3b/dd/04/61/rue12186c3093.png','31','189','Brazil','6','6','6','0','1','1','2','2','2','2','1','0','0','1632',NULL,'0');
INSERT INTO `fman_players` VALUES ('24','2','Pedro','18',NULL,NULL,NULL,'0',NULL,'9','https://s5o.ru/storage/simple/ru/edt/b7/bd/93/d4/rue55c2d703e7.png','31','169','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('25','2','Eden Hazard','18',NULL,NULL,NULL,'10',NULL,'6','https://s5o.ru/storage/simple/ru/edt/19/57/62/45/rue5c12d21d0e.png','27','170','Belgium','6','6','6','3','0','4','0','0','0','1','3','1','0','1272',NULL,'28');
INSERT INTO `fman_players` VALUES ('26','2','Willian','18',NULL,NULL,NULL,'8',NULL,'8','https://s5o.ru/storage/simple/ru/edt/95/e0/6f/19/rue2c6482707d.png','30','174','Brazil','6','6','6','3','0','3','2','0','1','2','1','1','0','1392',NULL,'13');
INSERT INTO `fman_players` VALUES ('27','2','Jorginho','18',NULL,NULL,NULL,'5',NULL,'5','https://s5o.ru/storage/simple/ru/edt/67/13/72/63/rue342e359571.jpeg','26','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','2232',NULL,'0');
INSERT INTO `fman_players` VALUES ('28','2','Ngolo Kante','18',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/00/13/11/69/ruee889c3efc0.png','27','168','France','6','6','6','0','1','0','2','1','1','2','0','0','0','1872',NULL,'10');
INSERT INTO `fman_players` VALUES ('29','2','Ross Barkley','18',NULL,NULL,NULL,'0',NULL,'7','https://s5o.ru/storage/simple/ru/edt/30/49/89/06/rue2a8b79f4c5.jpeg','24','189','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('30','2','Victor Moses','18',NULL,NULL,NULL,'0',NULL,'8','https://s5o.ru/storage/simple/ru/edt/67/e9/1f/68/rue83cb16cb26.png','27','177','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('31','2','Matheo Kovacic','18',NULL,NULL,NULL,'9',NULL,'7','https://s5o.ru/storage/simple/ru/edt/82/39/95/48/ruebb86a8ef61.png','24','178','Croatia','6','6','6','1','2','0','3','0','2','2','0','0','0','1592',NULL,'18');
INSERT INTO `fman_players` VALUES ('32','2','Ruben-Loftus Cheek','18',NULL,NULL,NULL,'0',NULL,'9','https://s5o.ru/storage/simple/ru/edt/32/58/98/37/rue7ebf4c4d6e.jpg','22','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('33','2','Alvaro Morata','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/15/82/94/08/rue63e7f41531.png','25','187','Spain','6','6','6','2','0','2','0','1','0','2','3','3','0','1352',NULL,'24');
INSERT INTO `fman_players` VALUES ('34','2','Olivier Giroud','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/06/19/72/62/rue3865426336.png','31','192','France','6','6','6','1','0','0','0','7','0','0','1','1','0','992',NULL,'25');
INSERT INTO `fman_players` VALUES ('35','3','Ederson','18',NULL,NULL,NULL,'1',NULL,'1','https://s5o.ru/storage/simple/ru/edt/78/e4/be/14/rue6e70e432a5.png','25','188','Brazil','6','6','6','0','0','0','0','0','0','5','0','0','11','1048',NULL,'0');
INSERT INTO `fman_players` VALUES ('36','3','Benjamin Mendy','18',NULL,NULL,NULL,'2',NULL,'2','https://s5o.ru/storage/simple/ru/edt/71/49/ff/c7/rue5bdd7d2933.png','24','185','France','6','6','6','9','0','0','0','12','10','0','0','0','0','928',NULL,'0');
INSERT INTO `fman_players` VALUES ('37','3','John Stones','18',NULL,NULL,NULL,'3',NULL,'3','https://s5o.ru/storage/simple/ru/edt/89/04/74/43/ruef59aa597a9.png','24','188','England','6','6','6','0','5','0','0','11','9','0','0','0','0','926',NULL,'0');
INSERT INTO `fman_players` VALUES ('38','3','Emerick Laporte','18',NULL,NULL,NULL,'3',NULL,'3','https://s5o.ru/storage/simple/ru/edt/89/07/94/65/rue63673cc473.png','24','189','France','6','6','6','0','0','0','0','12','12','2','0','0','0','1128',NULL,'0');
INSERT INTO `fman_players` VALUES ('39','82','Vincent  Kompany','18',NULL,'0','500000','0','0','3','https://s5o.ru/storage/simple/ru/edt/5c/10/7b/87/rue6eaa5eb92a.png','32','193','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535483640','0');
INSERT INTO `fman_players` VALUES ('40','3','Kyle Walker','18',NULL,NULL,NULL,'4',NULL,'4','https://s5o.ru/storage/simple/ru/edt/10/43/09/00/rueadb6b32843.png','28','178','England','6','6','6','10','0','0','0','13','0','9','0','0','0','928',NULL,'0');
INSERT INTO `fman_players` VALUES ('41','3','Bernardo Silva','18',NULL,'0','0','0','0','8','https://s5o.ru/storage/simple/ru/edt/24/51/91/00/rue06ad3e7b34.jpg','24','178','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535483700','0');
INSERT INTO `fman_players` VALUES ('42','94','David Silva','18',NULL,'0','500000','10','0','9','https://s5o.ru/storage/simple/ru/edt/76/62/54/72/rue01ac911459.png','32','173','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535483700','0');
INSERT INTO `fman_players` VALUES ('43','3','Raheem Sterling','18',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/12/88/05/94/rue84a1d9b3e4.png','23','170','England','6','6','6','7','0','0','0','14','0','0','7','7','0','888',NULL,'92');
INSERT INTO `fman_players` VALUES ('45','3','Leroy Sane','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/8c/48/1b/b7/rueb4cc087b2f.png','22','184','Germany','6','6','6','4','0','0','0','14','0','0','9','7','0','1008',NULL,'172');
INSERT INTO `fman_players` VALUES ('46','0','Riyad Mahrez','18',NULL,'1','5000000','6','17','6','https://s5o.ru/storage/simple/ru/edt/79/51/51/00/rue62c90c9eba.jpg','27','179','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535765942','0');
INSERT INTO `fman_players` VALUES ('47','3','Fernandinho','18',NULL,'0','0','0','0','7','https://s5o.ru/storage/simple/ru/edt/bc/cb/b5/7c/rue24c50cba39.jpg','33','176','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535483700','0');
INSERT INTO `fman_players` VALUES ('48','3','Kevin De Bruyne','18',NULL,NULL,NULL,'8',NULL,'8','https://s5o.ru/storage/simple/ru/edt/55/27/13/80/rue30b5a1f016.jpeg','27','180','Belgium','6','6','6','7','0','0','0','14','0','0','7','7','0','888',NULL,'77');
INSERT INTO `fman_players` VALUES ('50','3','Sergio Aguero','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/4d/0f/04/84/rue2a745b458a.png','30','170','Argentina','6','6','6','4','0','0','0','14','0','0','7','9','0','1008',NULL,'158');
INSERT INTO `fman_players` VALUES ('51','3','Gabriel Jesus','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/b5/72/e8/3a/rueb67cddd4f8.png','27','177','Brazil','6','6','6','4','0','0','0','14','0','0','7','9','0','1008',NULL,'159');
INSERT INTO `fman_players` VALUES ('52','4','Petr Cech','18',NULL,NULL,NULL,'1',NULL,'1','https://s5o.ru/storage/simple/ru/edt/2c/45/c1/e1/rue9d03b494c6.png','36','198','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','3','852',NULL,'0');
INSERT INTO `fman_players` VALUES ('53','4','Popastapopulas','18',NULL,NULL,NULL,'0',NULL,'3','https://s5o.ru/storage/simple/ru/edt/52/96/60/67/ruee10a4b23cf.jpeg','30','180','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('54','4','Skodran Mustafi','18',NULL,NULL,NULL,'3',NULL,'3','https://s5o.ru/storage/simple/ru/edt/55/26/94/98/rued3688586b0.png','26','184','Germany','6','6','6','0','0','0','0','4','0','0','0','0','0','932',NULL,'0');
INSERT INTO `fman_players` VALUES ('55','4','Hector Bellerin','18',NULL,NULL,NULL,'4',NULL,'4','https://s5o.ru/storage/simple/ru/edt/24/91/02/17/ruef555ec5b7f.png','23','177','Spain','6','6','6','4','0','0','0','0','0','0','0','0','0','932',NULL,'0');
INSERT INTO `fman_players` VALUES ('56','4','Nacho Monreal','18',NULL,NULL,NULL,'3',NULL,'3','https://s5o.ru/storage/simple/ru/edt/37/78/34/14/rue42cccebbdf.jpeg','32','179','Spain','6','6','6','0','0','0','0','4','0','0','0','0','0','932',NULL,'0');
INSERT INTO `fman_players` VALUES ('57','4','Lichsteiner','18',NULL,NULL,NULL,'2',NULL,'2','https://s5o.ru/storage/simple/ru/edt/94/70/09/05/rueb40d8704d3.png','34','182','Switzerland','6','6','6','4','0','0','0','0','0','0','0','0','0','932',NULL,'0');
INSERT INTO `fman_players` VALUES ('58','4','Henrikh Mkhitaryan','18',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/3e/45/2d/f9/rue210b8a15ee.png','29','178','Armenia','6','6','6','0','0','4','0','0','0','0','0','0','0','932',NULL,'17');
INSERT INTO `fman_players` VALUES ('59','4','Aleix Iwobi','18',NULL,NULL,NULL,'7',NULL,'7','https://s5o.ru/storage/simple/ru/edt/39/83/c6/ae/rue032714c2ba.png','22','180','Nigeria','6','6','6','0','0','0','0','0','4','0','0','0','0','932',NULL,'0');
INSERT INTO `fman_players` VALUES ('60','4','Aaron Ramsey','18',NULL,NULL,NULL,'8',NULL,'8','https://s5o.ru/storage/simple/ru/edt/48/99/20/79/rue42ed95b731.jpeg','27','178','Wales','6','6','6','0','0','4','0','0','0','0','0','0','0','932',NULL,'15');
INSERT INTO `fman_players` VALUES ('61','4','Granit Xhaka','18',NULL,NULL,NULL,'0',NULL,'5','https://s5o.ru/storage/simple/ru/edt/c6/a8/fb/89/ruefa9515875a.jpg','25','185','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('62','4','Lucas Torreiro','18',NULL,NULL,NULL,'0',NULL,'7','https://s5o.ru/storage/simple/ru/edt/96/26/75/90/rued8102082c9.jpg','22','178','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('63','4','Mattheo Genduzi','18',NULL,NULL,NULL,'0',NULL,'8','https://s5o.ru/storage/simple/ru/edt/70/81/91/73/ruee13f93c1db.jpg','19','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('64','4','Mesut Ozil','18',NULL,NULL,NULL,'10',NULL,'9','https://s5o.ru/storage/simple/ru/edt/19/05/96/65/ruea6de043198.jpg','29','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','1332',NULL,'39');
INSERT INTO `fman_players` VALUES ('65','4','Maitlend Niles','18',NULL,NULL,NULL,'0',NULL,'6','https://s5o.ru/storage/simple/ru/edt/17/fc/6c/8c/ruea4ca6db6a2.png','21','177','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('66','4','Alexander Lacazette','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/49/05/c7/9b/ruee860374d10.jpg','27','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','1332',NULL,'28');
INSERT INTO `fman_players` VALUES ('67','4','Aubameyang','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/by/edt/93/93/23/48/byeaa02645f1c.png','29','185','Gabon','6','6','6','0','0','0','0','0','0','0','0','0','0','1332',NULL,'40');
INSERT INTO `fman_players` VALUES ('68','5','Hugo Lloris','18',NULL,NULL,NULL,'1',NULL,'1','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_17965_148_2013_05_07_1.jpg','28','188','France','6','6','6','0','0','0','0','0','0','0','0','0','5','3210',NULL,'0');
INSERT INTO `fman_players` VALUES ('69','5','Michel Vorm','18',NULL,NULL,NULL,'0',NULL,'1','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_26276_2288_2013_03_07_1.jpg','32','183','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('70','5','Danny Rose','18',NULL,NULL,NULL,'0',NULL,'2','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_50174_148_2012_1.jpg','25','173','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('71','5','Ben Davies','18',NULL,NULL,NULL,'2',NULL,'2','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_192765_2288_2013_02_06_1.jpg','22','181','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'0');
INSERT INTO `fman_players` VALUES ('72','5','Eric Dier','18',NULL,NULL,NULL,'0',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_175722_336_2013_09_04_1.jpg','21','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('73','5','Toby Alderweireld','18',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_42710_610_2012_2.jpg','26','186','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'0');
INSERT INTO `fman_players` VALUES ('74','5','Jan Vertonghen','18',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_43250_148_2012_1.jpg','28','189','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'0');
INSERT INTO `fman_players` VALUES ('75','5','Federico Fazio','18',NULL,NULL,NULL,'0',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_45314_368_2012_10_25_1.jpg','28','195','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('76','5','Kyle Walker','18',NULL,NULL,NULL,'4',NULL,'4','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_95424_148_2012_1.jpg','25','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'0');
INSERT INTO `fman_players` VALUES ('77','5','Nabil Bentaleb','18',NULL,NULL,NULL,'0',NULL,'5','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_245537_148_2014_02_04_1.jpg','21','187','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('78','5','Nacer Chadli','18',NULL,NULL,NULL,'6',NULL,'6','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_59631_317_2012_2.jpg','26','187','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'9');
INSERT INTO `fman_players` VALUES ('79','5','Christian Eriksen','18',NULL,NULL,NULL,'7',NULL,'7','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_69633_610_2012_2.jpg','23','177','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'0');
INSERT INTO `fman_players` VALUES ('80','5','Dele Alli','18',NULL,NULL,NULL,'7',NULL,'7','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_207929_14983_2013_04_24_1.jpg','19','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'5');
INSERT INTO `fman_players` VALUES ('81','5','Moussa Dembele','18',NULL,NULL,NULL,'0',NULL,'7','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_19368_931_2012_2.jpg','28','185','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('82','5','Ryan Mason','18',NULL,NULL,NULL,'0',NULL,'7','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_61834_352_2013_09_23_1.jpg','24','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('83','5','Erik Lamela','18',NULL,NULL,NULL,'8',NULL,'8','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_111630_148_2013_09_26_1.jpg','23','183','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'12');
INSERT INTO `fman_players` VALUES ('84','5','Andros Townsend','18',NULL,NULL,NULL,'0',NULL,'8','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_61842_148_2013_10_18_1.jpg','24','181','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('85','5','Heung-Min Son','18',NULL,NULL,NULL,'10',NULL,'10','http://akacdn.transfermarkt.de/images/portrait/medium/91845-1437467657.jpg','23','184','South Korea','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'16');
INSERT INTO `fman_players` VALUES ('86','5','Harry Kane','18',NULL,NULL,NULL,'10',NULL,'10','http://akacdn.transfermarkt.de/images/portrait/medium/132098-1418318991.jpg','22','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','14764',NULL,'20');
INSERT INTO `fman_players` VALUES ('87','6','Allison','18',NULL,NULL,NULL,'1',NULL,'1','https://s5o.ru/storage/simple/ru/edt/63/79/75/07/rue702b781ceb.jpg','25','192','Brzail','6','6','6','0','0','0','0','0','0','0','0','0','7','1594',NULL,'0');
INSERT INTO `fman_players` VALUES ('88','6','Alberto Moreno','18',NULL,NULL,NULL,'2',NULL,'2','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_207917_368_2013_06_07_3.jpg','23','171','Spain','6','6','6','8','2','7','0','0','2','0','0','0','0','1034',NULL,'0');
INSERT INTO `fman_players` VALUES ('89','6','Jose Enrique','18',NULL,NULL,NULL,'0',NULL,'2','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_35571_31_2012_1.jpg','29','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('90','6','Martin Skrtel','18',NULL,NULL,NULL,'0',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_24180_31_2012_1.jpg','30','191','Slovakia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('91','6','Dejan Lovren','18',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_37838_180_2013_09_26_1.jpg','26','188','Croatia','6','6','6','0','2','0','0','10','4','0','0','0','0','1114',NULL,'0');
INSERT INTO `fman_players` VALUES ('92','6','Mamadou Sakho','18',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_47713_31_2013_09_26_1.jpg','25','187','France','6','6','6','2','1','0','0','10','4','0','0','0','0','1074',NULL,'0');
INSERT INTO `fman_players` VALUES ('93','6','Nathaniel Clyne','18',NULL,NULL,NULL,'4',NULL,'4','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_85177_180_2013_06_07_1.jpg','24','175','England','6','6','6','9','0','4','0','0','2','0','0','0','0','1514',NULL,'0');
INSERT INTO `fman_players` VALUES ('94','6','Sadio Mane','18',NULL,NULL,NULL,'6',NULL,'7','https://s5o.ru/storage/simple/ru/edt/39/c5/c0/53/rue6ffd4325a7.jpg','24','175','Senegal','6','6','6','8','2','7','0','0','2','0','0','0','0','1034',NULL,'75');
INSERT INTO `fman_players` VALUES ('95','6','James Milner','18',NULL,NULL,NULL,'7',NULL,'7','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_3333_281_2013_10_18_1.jpg','29','176','England','6','6','6','7','0','6','0','0','6','0','0','0','0','1034',NULL,'0');
INSERT INTO `fman_players` VALUES ('96','6','Jordan Henderson','18',NULL,NULL,NULL,'0',NULL,'7','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_61651_31_2012_2.jpg','25','182','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('97','6','Adam Lallana','18',NULL,NULL,NULL,'8',NULL,'9','http://akacdn.transfermarkt.de/images/portrait/medium/43530-1401965265.jpg','27','172','England','6','6','6','7','0','4','0','0','7','0','0','0','0','1194',NULL,'66');
INSERT INTO `fman_players` VALUES ('98','6','Roberto Firmino','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/4b/72/30/6f/rue23c787bdf8.png','26','180','Brazil','6','6','6','0','0','0','0','10','2','2','1','1','0','1314',NULL,'168');
INSERT INTO `fman_players` VALUES ('99','6','Mohammed Salah','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/dd/34/73/5a/rue9ec35493fc.png','26','175','Egypt','6','6','6','7','0','4','0','6','2','0','1','1','0','1274',NULL,'76');
INSERT INTO `fman_players` VALUES ('100','6','Daniel Sturridge','18',NULL,NULL,NULL,'10',NULL,'10','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_47082_31_2012_1.jpg','26','188','England','6','6','6','1','3','0','0','10','2','2','1','1','0','1034',NULL,'169');
INSERT INTO `fman_players` VALUES ('101','6','Divock Origi','18',NULL,NULL,NULL,'0',NULL,'10','http://akacdn.transfermarkt.de/images/portrait/medium/148368-1411386118.jpg','20','186','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('102','7','Tim Howard','18',NULL,NULL,NULL,'1',NULL,'1','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_4267_29_2009_1.jpg','36','191','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','756',NULL,'0');
INSERT INTO `fman_players` VALUES ('103','7','Joel Robles','18',NULL,NULL,NULL,'0',NULL,'1','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_101118_29_2013_10_18_1.jpg','25','195','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('104','7','Leighton Baines','18',NULL,NULL,NULL,'2',NULL,'2','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_13507_29_2009_1.jpg','30','170','England','6','6','6','0','0','0','0','0','0','0','0','0','0','756',NULL,'0');
INSERT INTO `fman_players` VALUES ('105','7','Bryan Oviedo','18',NULL,NULL,NULL,'0',NULL,'2','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_124983_29_2013_05_07_2.jpg','25','172','Costa Rica','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('106','7','Phil Jagielka','18',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_13520_29_2013_10_18_1.jpg','33','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','756',NULL,'0');
INSERT INTO `fman_players` VALUES ('107','7','John Stones','18',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_186590_29_2013_02_06_2.jpg','21','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','756',NULL,'0');
INSERT INTO `fman_players` VALUES ('108','7','Brendan Galloway','18',NULL,NULL,NULL,'0',NULL,'3','http://akacdn.transfermarkt.de/images/portrait/medium/208244-1407315902.jpg','19','186','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('109','7','Tony Hibbert','18',NULL,NULL,NULL,'0',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_3614_29_2009_1.jpg','34','173','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('110','7','Seamus Coleman','18',NULL,NULL,NULL,'4',NULL,'4','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_68390_29_2012_1.jpg','27','178','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','756',NULL,'0');
INSERT INTO `fman_players` VALUES ('111','7','Gareth Barry','18',NULL,NULL,NULL,'5',NULL,'5','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_3291_281_2013_05_14_1.jpg','34','184','England','6','6','6','0','0','0','0','0','0','0','0','0','0','414',NULL,'0');
INSERT INTO `fman_players` VALUES ('112','7','Stiven Piennar','18',NULL,NULL,NULL,'6',NULL,'6','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_4321_29_2009_1.jpg','33','170','South Africa','6','6','6','0','0','0','0','0','0','0','0','0','0','756',NULL,'5');
INSERT INTO `fman_players` VALUES ('113','7','Kevin Mirallas','18',NULL,NULL,NULL,'0',NULL,'6','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_33639_29_2013_04_09_1.jpg','28','182','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('114','7','James McCarthy','18',NULL,NULL,NULL,'0',NULL,'7','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_45333_1071_2013_02_18_1.jpg','25','180','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('115','7','Tom  Cleverley','18',NULL,NULL,NULL,'7',NULL,'7','http://akacdn.t ransfermarkt.de/images/portrait /medium /73484-1410950625.jpg','26','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','342',NULL,'0');
INSERT INTO `fman_players` VALUES ('116','7','Darron Gibson','18',NULL,NULL,NULL,'0',NULL,'7','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_42413_985_2009_1.jpg','28','183','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('117','7','Aaron Lennon','18',NULL,NULL,NULL,'8',NULL,'8','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_14221_148_2013_10_18_1.jpg','28','165','England','6','6','6','0','0','0','0','0','0','0','0','0','0','756',NULL,'3');
INSERT INTO `fman_players` VALUES ('118','7','Gerard Deulofeu','18',NULL,NULL,NULL,'0',NULL,'8','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_129476_2464_2013_02_14_1.jpg','21','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('119','7','Aiden McGeady','18',NULL,NULL,NULL,'0',NULL,'8','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_21333_232_2013_05_22_1.jpg','29','180','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('120','7','Ross Barkley','18',NULL,NULL,NULL,'9',NULL,'9','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_131978_29_2012_1.jpg','21','189','England','6','6','6','0','0','0','0','0','0','0','0','0','0','414',NULL,'4');
INSERT INTO `fman_players` VALUES ('121','7','Leon Osman','18',NULL,'0','7500000','0','0','9','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_3620_29_2013_10_18_1.jpg','34','173','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535655780','0');
INSERT INTO `fman_players` VALUES ('122','7','Steven Naismith','18',NULL,NULL,NULL,'10',NULL,'10','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_12763_29_2012_1.jpg','29','178','Scotland','6','6','6','0','0','0','0','0','0','0','0','0','0','342',NULL,'1');
INSERT INTO `fman_players` VALUES ('123','7','Romelu Lukaku','18',NULL,NULL,NULL,'10',NULL,'10','http://akacdn.transfermarkt.de/images/portrait/medium/96341-1401194535.jpg','22','191','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','756',NULL,'11');
INSERT INTO `fman_players` VALUES ('124','7','Arouna Kone','18',NULL,NULL,NULL,'10',NULL,'10','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_8552_29_2013_08_14_1.jpg','32','181','Cote DIvoire','6','6','6','0','0','0','0','0','0','0','0','0','0','756',NULL,'7');
INSERT INTO `fman_players` VALUES ('125','8','Kasper Schmeichel','18',NULL,NULL,NULL,'1',NULL,'1','http://akacdn.transfermarkt.de/images/portrait/medium/16911-1431779130.jpg','29','185','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','1','280',NULL,'0');
INSERT INTO `fman_players` VALUES ('126','8','Jeffrey Schlupp','18',NULL,NULL,NULL,'0',NULL,'2','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_157506_1003_2013_09_26_1.jpg','22','178','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('127','8','Christian Fuchs','18',NULL,NULL,NULL,'2',NULL,'2','http://tmssl.akamaized.net//images/portrait/header/6636-1406654461.jpg','30','86','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','360',NULL,'0');
INSERT INTO `fman_players` VALUES ('128','8','Danny Simpson','18',NULL,NULL,NULL,'3',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/37442-1469615760.jpg','29','177','England','6','6','6','0','0','0','0','0','0','0','0','0','0','360',NULL,'0');
INSERT INTO `fman_players` VALUES ('129','8','Wes Morgan','18',NULL,NULL,NULL,'3',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/10003-1405438663.jpg','32','185','Jamaica','6','6','6','0','0','0','0','0','0','0','0','0','0','360',NULL,'0');
INSERT INTO `fman_players` VALUES ('130','8','Robert Huth','18',NULL,NULL,NULL,'4',NULL,'4','http://tmssl.akamaized.net//images/portrait/header/2998-1463997450.jpg','32','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','360',NULL,'0');
INSERT INTO `fman_players` VALUES ('131','8','Riyad Mahrez','18',NULL,NULL,NULL,'10',NULL,'7','http://tmssl.akamaized.net//images/portrait/header/171424-1461578220.jpg','25','179','Algeria','6','6','6','0','0','0','0','2','0','0','1','1','0','160',NULL,'9');
INSERT INTO `fman_players` VALUES ('132','8','Danny Drinkwater','18',NULL,NULL,NULL,'6',NULL,'6','http://tmssl.akamaized.net//images/portrait/header/73491-1406794781.jpg','26','177','England','6','6','6','0','0','0','0','0','0','0','0','0','0','360',NULL,'5');
INSERT INTO `fman_players` VALUES ('133','8','Bartosz Kaputska','18',NULL,NULL,NULL,'5',NULL,'5','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_157506_1003_2013_09_26_1.jpg','19','179','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','360',NULL,'0');
INSERT INTO `fman_players` VALUES ('134','8','Andy King','18',NULL,NULL,NULL,'8',NULL,'8','http://tmssl.akamaized.net//images/portrait/header/56872-1456318846.jpg','28','183','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','360',NULL,'2');
INSERT INTO `fman_players` VALUES ('135','8','Matty James','18',NULL,NULL,NULL,'0',NULL,'9','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_157506_1003_2013_09_26_1.jpg','25','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('136','8','Islam Slimani','18',NULL,NULL,NULL,'0',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/174915-1445432455.jpg','28','188','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('137','8','Jamie Vardy','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/197838-1464868516.jpg','29','178','England','6','6','6','0','0','0','0','2','0','0','1','1','0','160',NULL,'12');
INSERT INTO `fman_players` VALUES ('138','8','Ahmed Musa','18',NULL,NULL,NULL,'0',NULL,'9','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_157506_1003_2013_09_26_1.jpg','24','170','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('139','8','Shinji Okazaki','18',NULL,NULL,NULL,'9',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/79642-1406741814.jpg','30','174','Japan','6','6','6','0','0','0','0','2','0','0','1','1','0','160',NULL,'13');
INSERT INTO `fman_players` VALUES ('141','9','Brad Guzan','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_39471_405_2009_1.jpg','30','193','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('142','9','Enda Stevens','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_85706_3258_2010_2.jpg','24','183','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('143','9','Alan Hutton','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_9619_148_2009_1.jpg','30','185','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('144','9','Stephen Warnock','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_3308_405_2009_1.jpg','32','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('145','9','Ciaran Clark','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','188','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('146','9','Carlos Cuollar','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_16576_405_2009_1.jpg','32','190','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('147','9','Eric Lichaj','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','180','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('148','9','Stephen Ireland','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_34838_281_2009_1.jpg','28','173','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('149','9','Jermaine Jenas','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_3461_148_2009_1.jpg','31','181','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('150','9','Charles NZogbia','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_22165_1071_2009_1.jpg','28','170','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('151','9','Marc Albrighton','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('152','9','Fabian Delph','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('153','9','Stiliyan Petrov','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_3252_405_2009_1.jpg','35','180','Bulgaria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('154','9','Barry Bannan','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','178','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('155','9','Chris Herd','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','173','Australia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('156','9','Gary Gardner','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('157','9','Robbie Keane','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3144_1061_2011_1.jpg','34','175','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('158','9','Darren Bent','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_13239_289_2009_1.jpg','30','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('159','9','Gabriel Agbonlahor','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37148_405_2009_1.jpg','28','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('160','9','Nathan Delfouneso','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_62642_405_2009_1.jpg','23','186','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('161','9','Andreas Weimann','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_49693_1010_2010_2.jpg','23','179','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('162','10','Craig Gordon','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_12589_289_2009_1.jpg','32','193','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('163','10','Keiren Westwood','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','30','188','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('164','10','Trevor Carson','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/e/n/s_41131_2007_1.jpg','26','183','Northern Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('165','10','Marcos Angeleri','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_27448_288_2009_1.jpg','31','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('166','10','Phil Bardsley','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_15773_289_2009_1.jpg','29','180','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('167','10','Michael Turner','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12127_289_2009_1.jpg','31','193','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('168','10','Wes Brown','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_3405_985_2009_1.jpg','34','184','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('169','10','Matthew Kilgallon','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_4095_289_2009_1.jpg','31','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('170','10','John OShea','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3540_985_2009_1.jpg','33','192','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('171','10','Titus Bramble','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3130_1071_2009_1.jpg','33','192','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('172','10','Lee Cattermole','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_37363_289_2009_1.jpg','26','177','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('173','10','Sebastian Larsson','17',NULL,NULL,NULL,'6',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','29','178','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('174','10','Craig Gardner','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_37171_405_2009_1.jpg','28','176','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('175','10','Kieran Richardson','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_3548_289_2009_1.jpg','30','177','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('176','10','Jack Colback','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('177','10','David Vaughan','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','31','171','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('178','10','David Meyler','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','189','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('179','10','James McClean','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','175','Northern Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('180','10','Jordan Cook','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('181','10','Ahmed Elmohamady','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/E/s/s_66333_3672_2009_1.jpg','27','182','Egypt','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('182','10','Stephane Sessagnon','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_37157_3955_2010_1.jpg','30','168','Benin','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('183','10','Fraizer Campbell','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_42411_289_2009_1.jpg','27','172','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('184','10','Connor Wickham','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_95435_9565_2010_1.jpg','21','189','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('185','10','Dong-Won Ji','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_164265_6503_2010_1.jpg','23','187','Korea, South','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('186','10','Ryan Noble','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','23','182','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('187','10','Nicklas Bendtner','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_34557_11_2009_1.jpg','26','194','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('188','11','Ben Foster','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_13572_985_2009_1.jpg','31','193','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('189','11','Marton Falep','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_17879_289_2009_1.jpg','31','198','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('190','11','Jonas Olsson','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_25248_984_2009_1.jpg','31','193','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('191','11','Gonzalo Jara','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/H/R/s_40429_2007_1.jpg','29','178','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('192','11','Nicky Shorey','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_13426_405_2009_1.jpg','33','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('193','11','Gareth McAuley','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','35','191','Northern Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('194','11','Craig Dawson','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','24','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('195','11','Gabriel Tamas','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/A/R/s_6893_2007_2.jpg','31','188','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('196','11','Somen Tchoyi','17',NULL,NULL,NULL,'5',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s/y/s_37058_409_2009_1.jpg','31','190','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('197','11','James Morrison','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_27614_984_2009_1.jpg','28','183','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('198','11','Chris Brunt','17',NULL,NULL,NULL,'7',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_36814_984_2009_1.jpg','30','185','Northern Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('199','11','Steven Reid','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_7330_1039_2009_1.jpg','32','183','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('200','11','Jerome Thomas','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_3560_984_2009_1.jpg','30','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('201','11','Scott Allan','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','175','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('202','11','Graham Dorrans','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_36608_984_2009_1.jpg','26','175','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('203','11','Youssouf Mulumbu','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/t/E/s_45272_2008_1.jpg','26','177','Congo DR','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('204','11','Zoltan Gera','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_18324_931_2009_1.jpg','34','183','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('205','11','Billy Jones','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','26','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('206','11','Paul Scharner','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_2953_1071_2009_1.jpg','33','193','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('207','11','Shane Long','18',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','26','178','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('208','11','Peter Odemwingie','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_12516_932_2010_1.jpg','32','182','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('209','11','Simon Cox','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','26','178','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('210','11','Marc-Antoine Fortune','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','32','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('211','11','Roman Bednar','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_26898_984_2009_1.jpg','30','190','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('212','12','Tim Krul','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_33027_762_2009_1.jpg','25','188','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('213','12','Rob Elliot','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','190','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('214','12','Fabricio Coloccini','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_6150_762_2009_1.jpg','31','183','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('215','12','Davide Santon','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_84344_46_2011_1.jpg','23','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('216','12','Danny Simpson','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_37442_762_2009_1.jpg','27','173','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('217','12','Mike Williamson','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s/D/s_10642_2005_1.jpg','30','193','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('218','12','James Perch','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('219','12','Ryan Taylor','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_33785_762_2009_1.jpg','29','173','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('220','12','Steven Taylor','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_17273_762_2009_1.jpg','27','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('221','12','Tamos Kedor','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','23','188','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('222','12','Danny Guthrie','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_16716_762_2009_1.jpg','26','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('223','12','Hatem Ben Arfa','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_18900_244_2009_1.jpg','26','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('224','12','Dan Gosling','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_44983_29_2009_1.jpg','23','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('225','12','Alan Smith','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_3768_762_2009_1.jpg','33','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('226','12','Jones Gutiarrez','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_26443_762_2009_1.jpg','30','183','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('227','12','Sylvain Marveaux','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_39909_273_2010_1.jpg','27','172','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('228','12','Cheik Tiota','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_33478_762_2010_1.jpg','27','180','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('229','12','Gabriel Obertan','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/Y/v/s_43261_2008_1.jpg','24','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('230','12','Haris Vuckic','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/O/T/s_76560_2007_1.jpg','21','190','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('231','12','Shane Ferguson','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','173','Northern Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('232','12','Nile Ranger','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('233','12','Peter Lavenkrands','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_9620_762_2009_1.jpg','33','181','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('234','12','Leon Best','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','185','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('235','12','Shola Ameobi','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3276_762_2009_1.jpg','32','188','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('236','12','Sam Ameobi','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','21','190','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('237','13','Asmir Begovic','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_33873_677_2009_1.jpg','26','196','Bosnia-Herzegovina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('238','13','Robert Huth','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_2998_512_2009_1.jpg','30','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('239','13','Danny Collins','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_26183_512_2009_1.jpg','33','185','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('240','13','Marc Wilson','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_30456_1020_2009_1.jpg','26','188','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('241','13','Ryan Shawcross','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45861_512_2009_1.jpg','26','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('242','13','Matthew Upson','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3273_379_2009_1.jpg','34','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('243','13','Andy Wilkinson','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_13616_512_2009_1.jpg','29','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('244','13','Jonathan Woodgate','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3224_148_2009_1.jpg','33','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('245','13','Danny Pugh','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_3546_512_2009_1.jpg','31','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('246','13','GlennW helan','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_12124_512_2009_1.jpg','30','178','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('247','13','Tom Soares','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('248','13','Jermaine Pennant','17',NULL,NULL,NULL,'8',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_3195_142_2009_1.jpg','30','173','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('249','13','Dean Whitehead','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_13683_512_2009_1.jpg','31','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('250','13','Michael Tonge','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_13544_466_2009_1.jpg','30','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('251','13','Matthew Etherington','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_3788_512_2009_1.jpg','32','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('252','13','Ryan Shotton','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('253','13','Diego Arismendi','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','189','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('254','13','Wilson Palacios','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_58361_148_2009_1.jpg','29','178','Honduras','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('255','13','Kenwyne Jones','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_28245_289_2009_1.jpg','29','187','Trinidad and Tobago','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('256','13','Ricardo Fuller','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_14014_512_2009_1.jpg','34','191','Jamaica','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('257','13','Mamady Sidiba','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_14069_512_2009_1.jpg','34','193','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('258','13','Jonathan Walters','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','30','183','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('259','13','Peter Crouch','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_4072_148_2009_1.jpg','32','202','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('260','13','Cameron Jerome','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('261','14','adom Bogdan','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_55247_1042_2009_1.jpg','26','194','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('262','14','Grotar Steinsson','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_30304_355_2009_1.jpg','32','189','Iceland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('263','14','Marcos Alonso','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_112515_6767_2010_1.jpg','23','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('264','14','Paul Rob inson','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','35','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('265','14','Ricardo Gardner','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_6264_355_2009_1.jpg','35','175','Jamaica','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('266','14','Zat Knight','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_4012_355_2009_1.jpg','33','198','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('267','14','Tyrone Mears','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/r/t/s_14050_244_2008_1.jpg','30','181','Jamaica','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('268','14','Sam Ricketts','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_30434_355_2009_1.jpg','32','185','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('269','14','Dedryck Boyata','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','23','188','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('270','14','David Wheater','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_29199_641_2010_1.jpg','26','196','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('271','14','Fabrice Muamba','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_35586_355_2009_1.jpg','25','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('272','14','Chris Eagles','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('273','14','Stuart Holden','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/M/q/s_30071_2007_1.jpg','28','178','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('274','14','Martin Petrov','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_670_281_2009_1.jpg','34','180','Bulgaria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('275','14','Mark Davies','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_36917_355_2009_1.jpg','25','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('276','14','Nigel Reo-Coker','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_14060_405_2009_1.jpg','29','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('277','14','Darren Pratley','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','186','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('278','14','Sean Davis','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_4036_355_2009_1.jpg','34','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('279','14','Chung-Yong Lee','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_81801_355_2010_1.jpg','25','180','Korea, South','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('280','14','Tuncay Sanli','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_6934_82_2010_1.jpg','32','182','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('281','14','Ivan Klasnic','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/B/t/s_690_2008_2.jpg','33','186','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('282','14','David N&#039;Gog','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_41242_31_2009_1.jpg','24','190','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('283','15','Paul Robinson','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_3630_164_2009_1.jpg','34','193','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('284','15','Mark Bunn','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_49319_350_2009_1.jpg','29','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('285','15','Martin Olsson','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_38073_164_2009_1.jpg','25','170','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('286','15','Christopher Samba','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_29016_164_2009_1.jpg','29','193','Congo','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('287','15','Gaol Givet','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5286_164_2009_1.jpg','32','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('288','15','Scott Dann','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','26','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('289','15','Grant Hanley','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','187','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('290','15','Bruno Ribeiro','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_76181_8698_2010_2.jpg','30','172','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('291','15','Jason Lowe','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('292','15','Adam Henley','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','178','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('293','15','Keith Andrews','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_8035_164_2009_1.jpg','34','183','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('294','15','Harold Goulon','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_41978_1164_2009_1.jpg','25','193','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('295','15','David Dunn','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_4243_164_2009_1.jpg','34','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('296','15','Mauro Fermica','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_55870_1286_2009_2.jpg','25','176','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('297','15','Vince Grella','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_6021_164_2009_1.jpg','34','183','Australia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('298','15','Morten Gamst Pedersen','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_22741_164_2009_1.jpg','32','180','Norway','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('299','15','Radosav Petrovic','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_75296_669_2010_1.jpg','24','193','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('300','15','Pablo Osvaldo','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37389_12_2014_1.jpg','28','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('301','15','Steven N&#039;Zonzi','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/L/I/s_73734_1416_2008_1.jpg','26','190','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('302','15','Simon Vukcevic','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_27239_336_2010_1.jpg','27','180','Montenegro','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('303','15','Josh Morris','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('304','15','Amine Linganzi','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_88596_618_2009_1.jpg','24','186','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('305','15','Jordan Slew','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','21','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('306','15','Ruben Rochina','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_67548_2464_2010_1.jpg','22','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('307','15','Marouane Chamakh','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/a/Z/s_19085_40_2009_1.jpg','31','188','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('308','15','Nick Blackman','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','24','189','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('309','15','David Hoilett','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/L/p/s_58993_2007_2.jpg','23','174','Canada','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('310','15','Yakubu Aiyegbeni','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_8559_29_2009_1.jpg','31','183','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('311','15','David Goodwillie','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','24','175','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('312','16','Chris Kirkland','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_3219_1071_2009_1.jpg','32','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('313','16','Lee Nicholls','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','21','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('314','16','Ali Al Habsi','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_26633_355_2009_1.jpg','32','194','Oman','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('315','16','Steve Gohouri','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/w/O/s_19857_2007_1.jpg','32','189','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('316','16','Antolan Alcaraz','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/J/L/s_14259_2282_2009_1.jpg','31','187','Paraguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('317','16','Gary Caldwell','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','31','185','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('318','16','Emmerson Boyce','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_19641_1071_2009_1.jpg','34','180','Barbados','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('319','16','Ronnie Stam','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_24877_317_2009_1.jpg','29','175','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('320','16','Piscu','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_44966_897_2009_1.jpg','26','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('321','16','Maynor Figueroa','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_62240_1071_2009_1.jpg','30','180','Honduras','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('322','16','Andy Carroll','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_48066_762_2009_1.jpg','26','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('323','16','Hendry Thomas','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','180','Honduras','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('324','16','Ben Watson','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('325','16','Shaun Maloney','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','30','171','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('326','16','Jordi Gomez','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('327','16','James McArthur','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','26','178','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('328','16','David Jones','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','29','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('329','16','Mohamed Diame','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/r/B/s_70950_367_2009_1.jpg','26','184','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('330','16','Callum McManaman','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('331','16','Albert Crusat','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_51536_3302_2010_2.jpg','31','165','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('332','16','Franco Di Santo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_59783_164_2009_1.jpg','24','193','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('333','16','Conor Sammon','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','26','185','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('334','16','Hugo Rodallega','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37934_1071_2009_1.jpg','28','180','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('335','17','Adrian','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/N/f/s_26412_2005_1.jpg','27','188','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('336','17','Wayne Hennessey','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/Z/W/s_45494_2008_1.jpg','26','196','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('337','17','Dorus de Vries','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_6404_543_2010_1.jpg','33','186','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('338','17','George Elokobi','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','175','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('339','17','Richard Stearman','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','26','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('340','17','Stephen Ward','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','185','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('341','17','Roger Johnson','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','30','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('342','17','Christophe Berra','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/F/B/s_36602_2007_1.jpg','28','185','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('343','17','Ronald Zubar','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/K/m/s_22645_2008_1.jpg','28','186','Guadeloupe','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('344','17','Kevin Foley','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/S/z/s_33491_2005_1.jpg','29','175','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('345','17','Eggert Gunnthor Jonsson','17',NULL,NULL,NULL,'4',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','188','Iceland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('346','17','David Edwards','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','185','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('347','17','Michael Kightly','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','173','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('348','17','Karl Henry','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/g/h/s_13582_2005_1.jpg','31','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('349','17','Stephen Hunt','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','32','175','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('350','17','Emmanuel Frimpong','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('351','17','Matt Jarvis','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/I/s/s_15921_2005_2.jpg','27','170','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('352','17','Adam Hammill','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('353','17','Nenad Milijas','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/m/t/s_36123_2008_2.jpg','30','188','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('354','17','Jamie O&#039;Hara','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('355','17','Adlane Guedioura','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_74768_172_2009_1.jpg','28','185','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('356','17','Andy Carroll','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('357','17','Sam Vokes','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','185','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('358','17','Sylvan Ebanks-Blake','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('359','17','Steven Fletcher','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s/e/s_35099_2008_1.jpg','27','185','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('360','17','Kevin Doyle','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','30','182','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('361','18','Elvijs Putnins','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','20','188','Latvia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('362','18','Paddy Kenny','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','35','185','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('363','18','Radek Cerny','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','37','187','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('364','18','Brian Murphy','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_4190_677_2009_1.jpg','30','185','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('365','18','Peter Ramage','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','30','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('366','18','Bradley Orr','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','31','182','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('367','18','Clint Hill','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','35','182','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('368','18','Fitz Hall','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','33','193','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('369','18','Danny Gabbidon','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12709_379_2009_1.jpg','34','178','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('370','18','Armand Traore','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_33783_11_2009_1.jpg','24','185','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('371','18','Bruno Perone','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_67996_134_2010_2.jpg','26','191','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('372','18','Matthew Connolly','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/z/B/s_34559_2006_1.jpg','26','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('373','18','Danny Shittu','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_13736_355_2009_1.jpg','35','191','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('374','18','Anton Ferdinand','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3698_289_2009_1.jpg','30','186','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('375','18','Lee Cook','17',NULL,NULL,NULL,'5',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/d/s/s_13783_2006_1.jpg','33','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('376','18','Hogan Ephraim','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('377','18','Adel Taarabt','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_45287_1039_2009_1.jpg','28','180','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('378','18','Kieron Dyer','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_3118_379_2009_1.jpg','35','170','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('379','18','Alejandro Faurlan','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','185','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('380','18','Jamie Mackie','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','182','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('381','18','Akos Buzseky','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','31','180','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('382','18','Joey Barton','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_3292_762_2009_1.jpg','31','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('383','18','Petter Vaagan Moen','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_26422_1100_2009_1.jpg','29','181','Norway','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('384','18','Shaun Wright-Phillips','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_3467_281_2009_1.jpg','32','168','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('385','18','Rowan Vine','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','31','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('386','18','Alessandro Pellicori','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/F/q/s_39682_2006_1.jpg','32','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('387','18','DJ Campbell','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','32','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('388','18','Jay Bothroyd','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','31','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('389','18','Patrick Agyemang','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','33','185','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('390','19','John Ruddy','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','192','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('391','19','Declan Rudd','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','23','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('392','19','Jed Steer','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','21','188','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('393','19','Russell Martin','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','183','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('394','19','Adam Drury','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','35','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('395','19','Zak Whitbread','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','30','188','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('396','19','Leon Barnett','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_33484_990_2009_1.jpg','28','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('397','19','Elliott Ward','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('398','19','Marc Tierney','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('399','19','Ritchie de Laet','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','186','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('400','19','Kyle Naughton','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','181','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('401','19','Daniel Ayala','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','23','190','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('402','19','Bradley Johnson','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','26','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('403','19','Andrew Crofts','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/i/r/s_14003_2005_1.jpg','29','175','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('404','19','Andrew Surman','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','29','178','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('405','19','Anthony Pilkington','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('406','19','Wesley Hoolahan','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','33','168','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('407','19','David Fox','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','32','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('408','19','Elliott Bennett','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('409','19','Korey Smith','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','26','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('410','19','Simon Lappin','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','32','180','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('411','19','Steve Morison','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_104725_1028_2010_1.jpg','32','188','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('412','19','James Vaughan','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_30471_29_2009_1.jpg','27','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('413','19','Grant Holt','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/o/s/s_13412_2005_1.jpg','34','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('414','19','Simeon Jackson','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','173','Canada','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('415','20','Michel Vorm','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_26276_200_2010_1.jpg','32','183','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('416','20','Jos? Moreira','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_13216_294_2010_1.jpg','31','185','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('417','20','Ashley Williams','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','31','183','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('418','20','Neil Taylor','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','28','175','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('419','20','Steven Caulker','7',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','24','191','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('420','20','Alan Tate','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','31','185','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('421','20','Garry Monk','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','34','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('422','20','Fede Bessone','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','179','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('423','20','engel Rangel','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','29','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('424','20','Ashley Richards','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','20','185','Wales','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('425','20','Darnel Situ','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_111059_826_2010_1.jpg','19','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('426','20','Ferrie Bodde','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','29','177','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('427','20','Leon Britton','17',NULL,NULL,NULL,'6',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','29','168','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('428','20','Andrea Orlandi','17',NULL,NULL,NULL,'7',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('429','20','Wayne Routledge','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','170','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('430','20','Kemy Agustien','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_24862_235_2009_1.jpg','25','178','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('431','20','Mark Gower','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','33','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('432','20','Thomas Butler','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','30','170','Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('433','20','Craig Beattie','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','183','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('434','20','Danny Graham','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/Z/Z/s_29152_2004_1.jpg','26','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('435','20','Scott Sinclair','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','177','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('436','20','Jonjo Shelvey','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','183','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('437','20','Nathan Dyer','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','24','165','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('438','20','Stephen Dobbie','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/C/j/s_12693_2007_1.jpg','29','178','Scottland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('439','20','Leroy Lita','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','27','170','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('440','20','Luke Moore','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_4075_984_2009_1.jpg','25','180','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('441','20','Rory Donnelly','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','188','Northern Ireland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('442','21','Gianluigi Donnaruma','18',NULL,NULL,NULL,'1',NULL,'1','http://tmssl.akamaized.net//images/portrait/header/315858-1439451572.jpg','17','196','Italy','6','6','6','0','0','0','0','0','0','0','0','0','1','154',NULL,'0');
INSERT INTO `fman_players` VALUES ('443','21','Gustavo Gomez','18',NULL,NULL,NULL,'2',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/215390-1474297819.jpg','23','185','Paraguay','6','6','6','0','0','0','0','2','0','0','0','0','0','114',NULL,'0');
INSERT INTO `fman_players` VALUES ('444','21','Ignazio Abate','18',NULL,NULL,NULL,'3',NULL,'4','http://tmssl.akamaized.net//images/portrait/header/16631-1455536336.jpg','29','180','Italy','6','6','6','0','0','0','0','2','0','0','0','0','0','114',NULL,'0');
INSERT INTO `fman_players` VALUES ('445','21','Rodrigo Ely','18',NULL,NULL,NULL,'4',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/176140-1448982160.jpg','23','188','Brazil','6','6','6','0','0','0','0','2','0','0','0','0','0','114',NULL,'0');
INSERT INTO `fman_players` VALUES ('446','21','Mattia De Sciglio','18',NULL,NULL,NULL,'11',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/88682-1455536736.jpg','24','183','Italy','6','6','6','0','0','0','0','2','0','0','0','0','0','114',NULL,'0');
INSERT INTO `fman_players` VALUES ('447','21','Christian Zapata','18',NULL,NULL,NULL,'0',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/34344-1455536254.jpg','30','187','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','90',NULL,'0');
INSERT INTO `fman_players` VALUES ('448','21','Luca Antonelli','18',NULL,NULL,NULL,'0',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/45565-1455536645.jpg','29','184','Italy','6','6','6','0','0','0','0','1','0','0','0','0','0','50',NULL,'0');
INSERT INTO `fman_players` VALUES ('449','21','Manuel Locatelli','18',NULL,NULL,NULL,'5',NULL,'7','http://tmssl.akamaized.net//images/portrait/header/265088-1459326814.jpg','18','186','Italy','6','6','6','2','0','0','0','0','0','0','0','0','0','114',NULL,'0');
INSERT INTO `fman_players` VALUES ('450','21','Andrea Bertolacci','18',NULL,NULL,NULL,'6',NULL,'5','http://tmssl.akamaized.net//images/portrait/header/99227-1474297569.jpg','25','179','Italy','6','6','6','2','0','0','0','0','0','0','0','0','0','114',NULL,'1');
INSERT INTO `fman_players` VALUES ('451','21','Andrea Poli','18',NULL,NULL,NULL,'7',NULL,'7','http://tmssl.akamaized.net//images/portrait/header/44834-1448982705.jpg','27','182','Italy','6','6','6','2','0','0','0','0','0','0','0','0','0','114',NULL,'0');
INSERT INTO `fman_players` VALUES ('452','21','MBaye Niang','18',NULL,NULL,NULL,'8',NULL,'5','http://tmssl.akamaized.net//images/portrait/header/157501-1448983228.jpg','21','184','France','6','6','6','2','0','0','0','0','0','0','0','0','0','114',NULL,'2');
INSERT INTO `fman_players` VALUES ('453','21','Manuel ','18',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_16922_5_2011_1.jpg','18','186','Italy','6','6','6','1','0','0','0','0','0','0','0','0','0','104',NULL,'3');
INSERT INTO `fman_players` VALUES ('454','21','Ricaardo Montolivo','18',NULL,NULL,NULL,'0',NULL,'6','http://tmssl.akamaized.net//images/portrait/header/19446-1455536395.jpg','31','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('455','21','Keisuke Honda','18',NULL,NULL,NULL,'0',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/66521-1455538386.jpg','30','182','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('456','21','Luiz Adriano','18',NULL,NULL,NULL,'0',NULL,'8','http://tmssl.akamaized.net//images/portrait/header/48974-1448983155.jpg','29','182','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('457','21','Carlos Bacca','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/119235-1448983000.jpg','30','181','Colombia','6','6','6','1','0','0','0','0','0','0','0','0','0','104',NULL,'7');
INSERT INTO `fman_players` VALUES ('458','22','Samir Handanovic','18',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_28021_410_2011_1.jpg','27','193','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','162',NULL,'0');
INSERT INTO `fman_players` VALUES ('459','22','Luca Castellazzi','18',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_6058_46_2011_1.jpg','36','192','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('460','22','Paolo Orlandoni','18',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_21797_46_2010_1.jpg','39','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('461','22','Paolo Tornaghi','18',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_45583_46_2010_1.jpg','23','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('462','22','Ivan Cerdoba','18',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5772_46_2011_1.jpg','35','173','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','162',NULL,'0');
INSERT INTO `fman_players` VALUES ('463','22','Javier Zanetti','18',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1161_46_2011_1.jpg','38','178','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','162',NULL,'0');
INSERT INTO `fman_players` VALUES ('464','22','Lacio','18',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_77_46_2011_1.jpg','33','188','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','162',NULL,'0');
INSERT INTO `fman_players` VALUES ('465','22','Maicon','18',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_18301_46_2011_1.jpg','30','184','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('466','22','Andrea Ranocchia','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_44327_46_2011_1.jpg','23','195','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('467','22','Nigel de Jong','18',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_4672_281_2009_1.jpg','30','174','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','162',NULL,'0');
INSERT INTO `fman_players` VALUES ('468','22','Walter Samuel','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5938_46_2011_1.jpg','33','183','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('469','22','Cristian Chivu','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_4314_46_2011_1.jpg','31','184','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('470','22','Davide Faraoni','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_73926_46_2011_1.jpg','20','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('471','22','Jonathan','18',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_54149_46_2011_1.jpg','25','171','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('472','22','Yuto Nagatomo','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_79522_46_2011_1.jpg','25','170','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('473','22','Dejan Stankovic','18',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_3428_46_2011_1.jpg','33','181','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','126',NULL,'0');
INSERT INTO `fman_players` VALUES ('474','22','Thiago Motta','18',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_7602_46_2011_1.jpg','29','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','126',NULL,'0');
INSERT INTO `fman_players` VALUES ('475','22','Hernanes','18',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_52897_398_2014_1.jpg','26','180','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','126',NULL,'2');
INSERT INTO `fman_players` VALUES ('476','22','Ricardo Alvarez','18',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_76077_46_2011_1.jpg','23','188','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','126',NULL,'2');
INSERT INTO `fman_players` VALUES ('477','22','Andrea Poli8','18',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_44834_46_2011_1.jpg','22','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('478','22','Esteban Cambiasso','18',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_7520_46_2011_1.jpg','31','177','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('479','22','Joel Obi','18',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_45581_46_2011_1.jpg','20','177','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('480','22','Lorenzo Crisetig','18',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_110928_21426_2010_1.jpg','18','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('481','22','Sulley Muntari','18',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_17129_46_2011_1.jpg','27','179','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('482','22','Giampaolo Pazzini','18',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_19447_46_2011_1.jpg','27','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','126',NULL,'6');
INSERT INTO `fman_players` VALUES ('483','22','Diego Forlen','18',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3408_46_2011_1.jpg','32','180','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','126',NULL,'0');
INSERT INTO `fman_players` VALUES ('484','22','Diego Milito','18',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_22202_46_2011_1.jpg','32','183','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('485','22','Mauro Zorate','18',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_26456_46_2011_1.jpg','24','176','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('486','22','Luc Castaignos','18',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_91915_46_2011_1.jpg','19','187','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('488','23','Morgan De Sanctis','18',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5880_6195_2011_1.jpg','34','190','Italy','6','6','6','0','0','0','0','0','0','0','0','0','11','715',NULL,'0');
INSERT INTO `fman_players` VALUES ('489','23','Raul Albiol','18',NULL,NULL,NULL,'3',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/15452-1418292073.jpg','31','190','Spain','6','6','6','4','0','0','0','5','5','0','0','0','0','1442',NULL,'0');
INSERT INTO `fman_players` VALUES ('490','23','Roberto Colombo','18',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_43411_6195_2011_1.jpg','36','190','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','54',NULL,'0');
INSERT INTO `fman_players` VALUES ('491','23','Antonio Rosati','18',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_6442_6195_2011_1.jpg','28','195','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','54',NULL,'0');
INSERT INTO `fman_players` VALUES ('492','23','Gianluca Grava','18',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_8207_6195_2011_1.jpg','34','172','Italy','6','6','6','5','0','5','2','0','4','0','0','0','0','1322',NULL,'0');
INSERT INTO `fman_players` VALUES ('493','23','Ignacio Fideleff','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_66960_6195_2011_1.jpg','22','188','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','54',NULL,'0');
INSERT INTO `fman_players` VALUES ('494','23','Salvatore Aronica','18',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_19182_6195_2011_1.jpg','33','181','Italy','6','6','6','5','0','5','4','0','0','2','0','0','0','1322',NULL,'0');
INSERT INTO `fman_players` VALUES ('495','23','Arkadiusz Milik','18',NULL,NULL,NULL,'0',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/191891-1407956389.jpg','22','186','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','54',NULL,'0');
INSERT INTO `fman_players` VALUES ('496','23','Jose  Callejon','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/61253-1448529945.jpg','29','178','Spain','6','6','6','1','0','0','0','10','0','0','4','2','0','282',NULL,'51');
INSERT INTO `fman_players` VALUES ('497','23','Lorenzo Insigne','18',NULL,NULL,NULL,'0',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/133964-1455552102.jpg','25','163','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','54',NULL,'0');
INSERT INTO `fman_players` VALUES ('498','23','Federico Fernandez','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_85475_6195_2011_1.jpg','22','189','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('499','23','Paolo Cannavaro','18',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5858_6195_2011_1.jpg','30','185','Italy','6','6','6','4','0','0','0','5','5','0','0','0','0','1388',NULL,'0');
INSERT INTO `fman_players` VALUES ('500','23','Miguel Britos','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_76799_6195_2011_1.jpg','26','188','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('501','23','Andrea Dossena','18',NULL,NULL,NULL,'6',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_21863_6195_2011_1.jpg','30','180','Italy','6','6','6','5','0','5','4','0','1','0','0','0','0','1348',NULL,'16');
INSERT INTO `fman_players` VALUES ('502','23','Christian Maggio','18',NULL,NULL,NULL,'8',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_21151_6195_2011_1.jpg','29','184','Italy','6','6','6','5','0','4','4','0','0','3','0','0','0','1348',NULL,'22');
INSERT INTO `fman_players` VALUES ('503','23','Marek Hamsik','18',NULL,NULL,NULL,'10',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/38593-1408608919.jpg','29','183','Slovakia','6','6','6','1','0','0','0','10','0','0','3','3','0','268',NULL,'55');
INSERT INTO `fman_players` VALUES ('504','23','Camilo Zoniga','18',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_37941_6195_2011_1.jpg','26','172','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('505','23','Blerim Dzemaili','18',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_9967_6195_2011_1.jpg','25','179','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('506','23','Wolter Gargano','18',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_52266_6195_2011_1.jpg','27','169','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('507','23','Jacopo Dezi','18',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_165531_6195_2011_1.jpg','19','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('508','23','Cristian Chavez','18',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_70132_6195_2011_1.jpg','27','171','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('509','41','Inseni','18',NULL,'0','500000','10','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_6427_6195_2011_1.jpg','21','179','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535428920','2');
INSERT INTO `fman_players` VALUES ('510','23','Gokhan Inler','18',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_19041_6195_2011_1.jpg','27','183','Switzerland','6','6','6','4','0','4','3','0','5','0','0','0','0','1348',NULL,'0');
INSERT INTO `fman_players` VALUES ('511','23','Eduardo Vargas','18',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_89718_1037_2011_1.jpg','22','175','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('512','23','Goran Pandev','18',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_12563_6195_2011_1.jpg','28','184','Macedonia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('513','23','Cristiano Lucarelli','18',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_21408_6195_2011_1.jpg','36','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('514','24','Daniele Padelli','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_27807_410_2010_1.jpg','26','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('515','24','Rafael Romo','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_101031_410_2011_1.jpg','21','197','Venezuela','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('516','24','Gabriel Silva','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_114340_1023_2010_2.jpg','20','179','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('517','24','Nikola','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','25','191','Montenegro','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('518','24','Bryan Carrasco','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_128474_6363_2011_1.jpg','20','169','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('519','24','Danilo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_32816_410_2011_1.jpg','27','184','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('520','24','Dusan Basta','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_19694_410_2011_1.jpg','27','184','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('521','24','Maurizio Domizzi','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_6750_410_2011_1.jpg','31','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('522','24','Neuton','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_105468_410_2011_1.jpg','21','182','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('523','24','Andrea Coda','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_28833_410_2011_1.jpg','26','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('524','24','Mehdi Benatia','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45124_410_2011_1.jpg','24','191','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('525','24','Jean-Alain Fanchone','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_81192_11300_2010_1.jpg','23','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('526','24','Joel Ekstrand','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_69912_410_2011_1.jpg','22','188','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('527','24','Giovanni Pasquale','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_5793_410_2011_1.jpg','30','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('528','24','Pablo Armero','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_73786_410_2011_1.jpg','25','174','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('529','24','Damiano Ferronetti','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_5948_410_2011_1.jpg','27','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('530','24','Ergon Berisha','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_66105_6890_2009_1.jpg','23','180','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('531','24','Piermario Morosini','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_35864_1386_2009_1.jpg','25','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('532','24','Mauricio Isla','17',NULL,NULL,NULL,'7',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_43722_410_2011_1.jpg','23','176','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('533','24','Emmanuel Badu','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_108484_410_2011_1.jpg','21','169','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('534','24','Gelson Fernandes','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_20081_618_2009_1.jpg','25','179','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('535','24','Cristian Battocchio','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_129868_410_2011_1.jpg','19','169','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('536','24','Kwadwo Asamoah','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_63531_410_2011_1.jpg','23','178','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('537','24','Abdoul Sissoko','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_83368_410_2011_1.jpg','21','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('538','24','Almen Abdi','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_9966_410_2011_1.jpg','25','182','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('539','24','Thierry Doubai','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_52027_410_2011_1.jpg','23','179','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('540','24','Roberto Pereyra','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_112302_11940_2010_1.jpg','21','184','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('541','24','Giampiero Pinzi','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5893_410_2011_1.jpg','30','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('542','24','Barreto','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_23345_410_2011_1.jpg','26','171','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('543','24','Antonio Di Natale','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_6031_410_2011_1.jpg','34','170','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('544','24','Gabriel Torje','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_47184_410_2010_1.jpg','22','167','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('545','24','Diego Fabbrini','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_56903_410_2011_1.jpg','21','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('546','24','Antonio Floro Flores','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_16893_410_2011_1.jpg','28','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('547','25','Alessandro Berardi','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_127217_398_2011_1.jpg','20','173','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'0');
INSERT INTO `fman_players` VALUES ('548','25','Federico Marchetti','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_22318_398_2011_1.jpg','28','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('549','25','Juan Pablo Carrizo','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/p/s/s_39118_142_2009_1.jpg','27','188','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('550','25','Ivan Artipoli','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_21682_704_2010_1.jpg','25','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('551','25','Guglielmo Stendardo','16',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_22093_398_2011_1.jpg','30','190','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('552','25','Javier Garrido','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_23218_398_2011_1.jpg','26','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'0');
INSERT INTO `fman_players` VALUES ('553','25','Modibo Diakita','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_41749_398_2011_1.jpg','24','192','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('554','25','Stefan Radu','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_44420_398_2011_1.jpg','25','183','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('555','25','Abdoulay Konko','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_22139_398_2011_1.jpg','27','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'0');
INSERT INTO `fman_players` VALUES ('556','25','Luis Pedro Cavanda','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_102192_398_2011_1.jpg','22','190','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'0');
INSERT INTO `fman_players` VALUES ('557','25','Luca Crescenzi','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'0');
INSERT INTO `fman_players` VALUES ('558','25','Federico Chirico','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('559','25','Stefano Mauri','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_6043_398_2011_1.jpg','32','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('560','25','Alvaro Gonzalez','17',NULL,NULL,NULL,'8',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_55957_398_2011_1.jpg','27','176','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'2');
INSERT INTO `fman_players` VALUES ('561','25','Senad Lulic','17',NULL,NULL,NULL,'6',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_61449_398_2011_1.jpg','25','183','Bosnia-Herzegovina','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'5');
INSERT INTO `fman_players` VALUES ('562','25','Cristian Ledesma','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_6438_398_2011_1.jpg','29','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'4');
INSERT INTO `fman_players` VALUES ('563','25','Lorik Cana','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_12149_398_2011_1.jpg','28','186','Albania','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'0');
INSERT INTO `fman_players` VALUES ('564','25','Enrico Zampa','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','175','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('565','25','Simone Del Nero','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5982_398_2011_1.jpg','30','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('566','25','Manuel Ricci','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','21','176','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'11');
INSERT INTO `fman_players` VALUES ('567','25','Emiliano Alfaro','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_74354_10663_2009_1.jpg','23','173','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('568','25','Giuseppe Sculli','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_6046_398_2011_1.jpg','30','177','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('569','25','Libor Kozak','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_63824_398_2011_1.jpg','22','193','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('570','25','Miroslav Klose','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_10_398_2011_1.jpg','33','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('571','25','Stephen Makinwa','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_17146_398_2011_1.jpg','28','186','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('572','25','Tommaso Ceccarelli','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_127222_398_2011_1.jpg','19','176','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('573','25','Djibril Cisse','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3966_398_2011_1.jpg','30','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','765',NULL,'8');
INSERT INTO `fman_players` VALUES ('574','26','Bogdan Lobont','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_4310_12_2010_1.jpg','33','185','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','204',NULL,'0');
INSERT INTO `fman_players` VALUES ('575','26','Gianluca Curci','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_24001_12_2010_1.jpg','26','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','136',NULL,'0');
INSERT INTO `fman_players` VALUES ('576','26','Maarten Stekelenburg','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_4311_12_2010_1.jpg','29','197','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','136',NULL,'0');
INSERT INTO `fman_players` VALUES ('577','26','Mirko Pigliacelli','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_165893_11997_2010_1.jpg','18','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','136',NULL,'0');
INSERT INTO `fman_players` VALUES ('578','26','Vitorino Antunes','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_44699_12_2009_1.jpg','24','175','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','204',NULL,'0');
INSERT INTO `fman_players` VALUES ('579','26','Cicinho','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_26101_12_2010_1.jpg','31','171','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','204',NULL,'0');
INSERT INTO `fman_players` VALUES ('580','26','Jose Angel','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_87469_12_2010_1.jpg','22','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','204',NULL,'0');
INSERT INTO `fman_players` VALUES ('581','26','Juan','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1599_12_2010_1.jpg','32','182','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','136',NULL,'0');
INSERT INTO `fman_players` VALUES ('582','26','Gabriel Heinze','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5555_12_2010_1.jpg','33','178','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','136',NULL,'0');
INSERT INTO `fman_players` VALUES ('583','26','Louc Nego','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_122840_12_2010_1.jpg','20','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','136',NULL,'0');
INSERT INTO `fman_players` VALUES ('584','26','Nicolos Burdisso','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3417_12_2010_1.jpg','30','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','136',NULL,'0');
INSERT INTO `fman_players` VALUES ('585','26','Simon Kjaer','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_48859_12_2010_1.jpg','22','189','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('586','26','Marco Cassetti','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_16975_12_2010_1.jpg','34','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('587','26','Aleandro Rosi','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_34239_12_2010_1.jpg','24','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('588','26','Ahmed Barusso','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/e/T/s_40979_2008_1.jpg','27','184','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'0');
INSERT INTO `fman_players` VALUES ('589','26','David Pizarro','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5896_12_2010_1.jpg','32','170','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'1');
INSERT INTO `fman_players` VALUES ('590','26','Taddei','17',NULL,NULL,NULL,'7',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_15342_12_2010_1.jpg','31','177','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'0');
INSERT INTO `fman_players` VALUES ('591','26','Miralem Pjanic','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_44162_12_2010_1.jpg','21','180','Bosnia-Herzegovina','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'0');
INSERT INTO `fman_players` VALUES ('592','26','Daniele De Rossi','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5947_12_2010_1.jpg','28','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'1');
INSERT INTO `fman_players` VALUES ('593','26','Fernando Gago','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_38954_12_2010_1.jpg','25','177','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('594','26','Leandro Greco','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_39831_12_2010_1.jpg','25','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('595','26','Fabio Simplocio','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_24716_12_2010_1.jpg','32','173','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('596','26','Federico Viviani','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_165900_21100_2010_1.jpg','19','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('597','26','Valerio Verre','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_162961_11997_2010_1.jpg','18','175','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('598','26','Gervinho','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_33481_3591_2010_1.jpg','27','179','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'3');
INSERT INTO `fman_players` VALUES ('599','26','Kevin Strootman','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_68864_383_2014_1.jpg','24','186','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('600','26','Francesco Totti','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5958_12_2010_1.jpg','35','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'0');
INSERT INTO `fman_players` VALUES ('601','26','Bojan','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_44675_12_2010_1.jpg','21','170','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('602','26','Fabio Borini','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_96754_11947_2010_1.jpg','20','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('603','26','Gianluca Caprari','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_146752_21426_2010_1.jpg','18','176','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('604','26','Stefano Okaka','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_35249_12_2010_1.jpg','22','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('605','27','Wojsiezch Szchesny','18',NULL,NULL,NULL,'1',NULL,'1','https://s5o.ru/storage/simple/ru/edt/11/42/49/86/rue12570ee89e.jpeg','28','196','Poland','6','6','6','4','2','0','1','0','4','4','1','2','6','76',NULL,'0');
INSERT INTO `fman_players` VALUES ('606','27','Neto','18',NULL,NULL,NULL,'0',NULL,'1','http://tmssl.akamaized.net//images/portrait/header/111819-1448463847.jpg','27','191','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','216',NULL,'0');
INSERT INTO `fman_players` VALUES ('607','27','Medhi Benatia','18',NULL,NULL,NULL,'4',NULL,'4','http://tmssl.akamaized.net//images/portrait/header/45124-1437471177.jpg','29','190','Marocco','6','6','6','6','3','1','3','4','6','1','2','2','0','396',NULL,'0');
INSERT INTO `fman_players` VALUES ('608','27','Giorgio Chiellini','18',NULL,NULL,NULL,'3',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/29260-1448464153.jpg','32','187','Italy','6','6','6','6','3','1','3','5','7','0','1','2','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('609','27','Alex Sandro','18',NULL,NULL,NULL,'2',NULL,'2','http://tmssl.akamaized.net//images/portrait/header/79960-1474296962.jpg','25','181','Brazil','6','6','6','6','2','2','3','4','6','2','3','3','0','116',NULL,'0');
INSERT INTO `fman_players` VALUES ('610','27','Paolo De Ceglie','18',NULL,NULL,NULL,'3',NULL,'2','http://tmssl.akamaized.net//images/portrait/header/44709-1418827584.jpg','30','184','Italy','6','6','6','6','3','1','3','3','7','3','2','2','0','76',NULL,'0');
INSERT INTO `fman_players` VALUES ('611','27','Sami Khedira','18',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/40/52/28/00/rue8eeafdad94.png','31','189','Germany','6','6','6','5','2','3','1','4','5','0','3','5','0','436',NULL,'41');
INSERT INTO `fman_players` VALUES ('612','28','Patrice Evra','18',NULL,'0','2500000','0','0','5','http://tmssl.akamaized.net//images/portrait/header/5285-1416219199.jpg','35','174','France','6','6','6','1','0','0','0','0','1','0','1','1','0','56','1535686800','0');
INSERT INTO `fman_players` VALUES ('613','27','Miralem Pjanic','18',NULL,NULL,NULL,'7',NULL,'7','http://tmssl.akamaized.net//images/portrait/header/44162-1448466304.jpg','26','180','Bosnia-Herzegovina','6','6','6','5','1','4','3','4','4','3','4','4','0','156',NULL,'0');
INSERT INTO `fman_players` VALUES ('614','28','Claudio Marchisio','18',NULL,'0','4500000','8','0','7','http://tmssl.akamaized.net//images/portrait/header/44716-1416219760.jpg','30','180','Italy','6','6','6','1','0','0','0','0','1','0','0','1','0','114','1535686860','0');
INSERT INTO `fman_players` VALUES ('2511','8','Leonardo Ulloa','18','0','0','0','10',NULL,'10','','25','180','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('616','27','Emre Jan','18',NULL,NULL,NULL,'8',NULL,'5','https://s5o.ru/storage/simple/ru/edt/59/d1/93/fc/rue6d84bed296.jpg','24','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','54',NULL,'0');
INSERT INTO `fman_players` VALUES ('617','27','Paulo Dybala','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/206050-1448465735.jpg','22','177','Argentina','6','6','6','5','2','4','1','4','5','2','3','4','0','140',NULL,'52');
INSERT INTO `fman_players` VALUES ('618','27','Cristiano Ronaldo','19',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/6e/e2/c0/9e/rue620112b2df.png','34','185','Portugal','6','6','6','5','1','4','1','7','5','3','3','5','0','146',NULL,'78');
INSERT INTO `fman_players` VALUES ('619','27','Juan Cuadrado','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/91970-1448465554.jpg','28','178','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'5');
INSERT INTO `fman_players` VALUES ('620','27','Mario Mandzukic','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/34572-1448465837.jpg','30','190','Croatia','6','6','6','5','2','3','2','5','3','2','4','5','0','20',NULL,'51');
INSERT INTO `fman_players` VALUES ('621','28','Emiliano Viviano','17',NULL,'1','0','1','0','1','http://static.transfermarkt.net/bilder/mediumfotos/s_24316_46_2011_1.jpg','26','195','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888640','0');
INSERT INTO `fman_players` VALUES ('622','0','Giacomo Brichetto','17',NULL,'1','0','0','0','1','http://static.transfermarkt.net/bilder/mediumfotos/s_100693_458_2011_2.jpg','28','194','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','527','1535888640','0');
INSERT INTO `fman_players` VALUES ('623','28','Alexandros Tzorvas','17',NULL,'1','500000','0','0','1','http://static.transfermarkt.net/bilder/mediumfotos/s_24284_458_2010_1.jpg','29','188','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888700','0');
INSERT INTO `fman_players` VALUES ('624','28','Francesco Benussi','17',NULL,'1','0','0','0','1','http://static.transfermarkt.net/bilder/mediumfotos/s_21829_458_2011_2.jpg','30','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888760','0');
INSERT INTO `fman_players` VALUES ('625','28','Milan Milanovic','17',NULL,'1','0','3','0','3','http://static.transfermarkt.net/bilder/mediumfotos/s_70574_458_2011_1.jpg','20','194','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888760','0');
INSERT INTO `fman_players` VALUES ('626','28','Andrea Mantovani','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_21935_458_2011_2.jpg','27','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','646',NULL,'0');
INSERT INTO `fman_players` VALUES ('627','28','Mateas Silvestre','17',NULL,'1','0','0','0','3','http://static.transfermarkt.net/bilder/mediumfotos/s_20003_458_2011_2.jpg','27','184','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888820','0');
INSERT INTO `fman_players` VALUES ('628','28','Mauro Cetto','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5501_458_2011_2.jpg','29','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','646',NULL,'0');
INSERT INTO `fman_players` VALUES ('629','28','Ezequiel Mueoz','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_75127_458_2011_2.jpg','21','185','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','527',NULL,'0');
INSERT INTO `fman_players` VALUES ('630','28','Carlos Labran','17',NULL,NULL,NULL,'6',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_89783_6368_2009_1.jpg','21','181','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','646',NULL,'1');
INSERT INTO `fman_players` VALUES ('631','28','Eros Pisano','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_56609_458_2011_2.jpg','24','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','646',NULL,'0');
INSERT INTO `fman_players` VALUES ('632','28','Federico Balzaretti','17',NULL,'1','0','0','0','3','http://static.transfermarkt.net/bilder/mediumfotos/s_21876_458_2011_2.jpg','30','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888880','0');
INSERT INTO `fman_players` VALUES ('633','28','?dgar Barreto','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_16120_458_2010_1.jpg','27','182','Paraguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('634','28','Francesco Della Rocca','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_56889_458_2010_1.jpg','24','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('635','28','Giulio Migliaccio','17',NULL,'1','0','0','0','7','http://static.transfermarkt.net/bilder/mediumfotos/s_21756_458_2011_2.jpg','30','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888940','0');
INSERT INTO `fman_players` VALUES ('636','28','Mateas Aguirregaray','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_74232_458_2010_1.jpg','22','174','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('637','28','Nicolas Bertolo','17',NULL,'1','0','0','0','7','http://static.transfermarkt.net/bilder/mediumfotos/s_52903_458_2011_2.jpg','26','180','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888940','0');
INSERT INTO `fman_players` VALUES ('638','28','Eran Zahavi','17',NULL,'1','0','0','0','9','http://static.transfermarkt.net/bilder/mediumfotos/s_85093_458_2011_2.jpg','24','178','Israel','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535889000','0');
INSERT INTO `fman_players` VALUES ('639','28','Franco Vazquez','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_76163_2417_2009_1.jpg','22','187','Argentina','6','6','6','0','0','0','0','0','0','0','0','1','0','79',NULL,'1');
INSERT INTO `fman_players` VALUES ('640','28','Afriyie Acquah','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_145581_458_2011_2.jpg','20','179','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','119',NULL,'0');
INSERT INTO `fman_players` VALUES ('641','28','Armin Bacinovic','17',NULL,'1','0','0','0','7','http://static.transfermarkt.net/bilder/mediumfotos/s_60074_458_2011_2.jpg','22','183','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888880','0');
INSERT INTO `fman_players` VALUES ('642','28','Luca Di Matteo','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_68862_458_2011_2.jpg','23','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('643','28','Ignacio Lores','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_139535_458_2011_2.jpg','20','182','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('644','28','Josip Ilicic','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_80351_458_2011_2.jpg','23','190','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('645','28','Adam Simon','17',NULL,'1','0','0','0','7','http://static.transfermarkt.net/bilder/mediumfotos/s_86143_458_2011_1.jpg','21','178','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888880','0');
INSERT INTO `fman_players` VALUES ('646','94','Adgar Alvarez','17',NULL,'0','1000000','8','0','8','http://static.transfermarkt.net/bilder/mediumfotos/s_28006_458_2010_1.jpg','31','171','Honduras','6','6','6','0','0','0','0','0','0','0','0','0','0','119','1535478300','0');
INSERT INTO `fman_players` VALUES ('647','28','Fabrizio Miccoli','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_6097_458_2011_2.jpg','32','168','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('648','28','Abel Hernendez','17',NULL,'1','0','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_76608_458_2011_2.jpg','21','185','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535888999','0');
INSERT INTO `fman_players` VALUES ('649','28','Igor Budan','17',NULL,'1','0','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_19437_458_2010_1.jpg','31','185','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535889060','0');
INSERT INTO `fman_players` VALUES ('650','28','Agon Mehmeti','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_72687_496_2009_1.jpg','22','184','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','119',NULL,'1');
INSERT INTO `fman_players` VALUES ('651','28','Mauricio Pinilla','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_6160_458_2011_2.jpg','27','185','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','119',NULL,'6');
INSERT INTO `fman_players` VALUES ('652','29','Artur Boruc','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','31','193','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('653','29','Edoardo Pazzagli','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/Z/B/s_54055_2007_1.jpg','22','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('654','29','Neto','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_111819_679_2010_1.jpg','22','191','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('655','29','Per Kroldrup','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12112_430_2009_1.jpg','32','194','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('656','29','Alessandro Gamberini','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_16868_430_2009_1.jpg','30','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('657','29','Cesare Natali','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_16870_430_2009_1.jpg','32','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('658','29','Matija Nastasic','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_143559_669_2010_1.jpg','18','187','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('659','29','Mattia Cassani','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_21859_458_2011_1.jpg','28','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('660','29','Felipe','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_17127_410_2009_1.jpg','27','178','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('661','29','Manuel Pasqual','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_23284_430_2009_1.jpg','29','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('662','29','Lorenzo De Silvestri','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_33571_430_2009_1.jpg','23','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('663','29','Michele Camporese','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('664','29','Nikola Gulan','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_46553_749_2009_1.jpg','22','183','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('665','29','Ramulo','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_121756_679_2010_2.jpg','24','178','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('666','29','Juan Vargas','17',NULL,NULL,NULL,'5',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_30584_430_2009_1.jpg','28','185','Peru','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('667','29','Alessio Cerci','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_21748_12_2009_1.jpg','24','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('668','29','Houssine Kharja','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_21822_252_2009_1.jpg','29','180','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('669','29','Amidu Salifu','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','174','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('670','29','Riccardo Montolivo','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_19446_430_2009_1.jpg','26','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('671','29','Gianni Munari','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_22598_1005_2009_1.jpg','28','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('672','29','Mario Gomez','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_6288_3262_2010_2.jpg','28','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('673','29','Andrea Lazzari','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_19442_430_2010_1.jpg','27','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('674','29','Daniel Kofi Agyei','16',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','20','178','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('675','29','Ryder Matos','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','18','180','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('676','29','Marco Marchionni','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_5873_430_2009_1.jpg','31','175','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('677','29','Valon Behrami','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_21905_379_2009_1.jpg','26','185','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('678','29','Khouma Babacar','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','18','191','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('679','29','Adem Ljajic','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_69374_669_2009_1.jpg','20','182','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('680','29','Boadu Maxwell Acosty','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','20','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('681','30','Sebastien Frey','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5854_252_2011_1.jpg','31','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('682','30','Cristiano Lupatelli','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5908_252_2011_1.jpg','33','189','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('683','30','Dario Dainelli','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5970_252_2011_2.jpg','32','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('684','30','Andreas Granqvist','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_29213_252_2011_1.jpg','26','192','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('685','30','Kakhaber Kaladze','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3430_252_2011_2.jpg','33','186','Georgia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('686','30','Giandomenico Mesto','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_16744_252_2011_2.jpg','29','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('687','30','Cesare Bovo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5946_252_2011_1.jpg','29','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('688','30','Luca Antonelli','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_45565_252_2011_2.jpg','24','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('689','30','Emiliano Moretti','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_5755_252_2011_2.jpg','30','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('690','30','Davide Biondini','17',NULL,NULL,NULL,'5',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_22186_1390_2011_1.jpg','28','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('691','30','Miguel Veloso','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_43848_252_2011_2.jpg','25','180','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('692','30','Marco Rossi','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_21955_252_2011_2.jpg','33','179','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('693','30','Valter Birsa','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_26105_252_2011_1.jpg','25','184','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('694','30','Felipe Seymour','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_83891_252_2011_1.jpg','24','174','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('695','30','Kevin Constant','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_43760_252_2011_1.jpg','24','184','Guine','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('696','30','Juraj Kucka','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_74943_252_2011_2.jpg','24','186','Slovakia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('697','30','Alexander Merkel','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_86926_252_2011_1.jpg','19','177','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('698','30','Stefano Sturaro','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','18','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('699','30','Danijel Aleksic','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_48119_65_2010_1.jpg','20','181','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('700','30','Lucas Pratto','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_59596_252_2011_1.jpg','23','188','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('701','30','Rodrigo Palacio','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_39099_252_2011_2.jpg','29','175','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('702','30','Za Eduardo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_30505_252_2011_1.jpg','24','179','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('703','30','Bosko Jankovic','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_19708_252_2011_2.jpg','27','183','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('704','30','Cristobal Jorquera','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_66280_252_2011_1.jpg','23','174','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('705','30','Alberto Gilardino','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5878_430_2009_1.jpg','29','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('706','31','Tomas Kosicky','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_78496_1627_2011_2.jpg','25','197','Slovakia','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'0');
INSERT INTO `fman_players` VALUES ('707','31','Mariano Andejar','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_35491_1627_2011_2.jpg','28','194','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('708','31','Pietro Terracciano','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_96254_1627_2011_1.jpg','21','192','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('709','31','Alessandro Potenza','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_16828_1627_2011_2.jpg','27','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'0');
INSERT INTO `fman_players` VALUES ('710','31','Nicolas Spolli','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_51186_1627_2011_2.jpg','28','193','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'0');
INSERT INTO `fman_players` VALUES ('711','31','Giovanni Marchese','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_21887_1627_2011_2.jpg','27','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'0');
INSERT INTO `fman_players` VALUES ('712','31','Giuseppe Bellusci','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_57354_1627_2011_2.jpg','22','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('713','31','Pablo Alvarez','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_55993_1627_2011_2.jpg','27','177','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('714','31','Ciro Capuano','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_38584_1627_2011_2.jpg','30','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('715','31','Sergio Almiran','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_5890_1627_2011_1.jpg','31','178','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'0');
INSERT INTO `fman_players` VALUES ('716','31','Mario Paglialunga','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_55213_1627_2011_1.jpg','23','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'3');
INSERT INTO `fman_players` VALUES ('717','31','Pablo Ledesma','17',NULL,NULL,NULL,'7',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_19976_1627_2011_2.jpg','27','178','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'0');
INSERT INTO `fman_players` VALUES ('718','31','Francesco Lodi','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_6033_1627_2011_2.jpg','27','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'6');
INSERT INTO `fman_players` VALUES ('719','31','Mariano Izco','17',NULL,NULL,NULL,'9',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_30853_1627_2011_2.jpg','28','177','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'4');
INSERT INTO `fman_players` VALUES ('720','31','Cristian Llama','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_30882_1627_2011_2.jpg','25','179','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('721','31','Alejandro Gomez','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_20005_1627_2011_2.jpg','23','166','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('722','31','Adrian Ricchiuti','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_30654_1627_2011_2.jpg','33','168','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('723','31','Gennaro Delvecchio','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_22080_1627_2011_2.jpg','33','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('724','31','Marco Biagianti','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_47646_1627_2011_2.jpg','27','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('725','31','Pablo Barrientos','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_19946_1627_2011_2.jpg','26','169','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('726','31','Davide Lanzafame','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61539_1627_2011_1.jpg','24','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'6');
INSERT INTO `fman_players` VALUES ('727','31','David Suazo','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_20749_1627_2011_1.jpg','32','183','Honduras','6','6','6','0','0','0','0','0','0','0','0','0','0','680',NULL,'0');
INSERT INTO `fman_players` VALUES ('728','31','Maxi Lopez','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_26263_1627_2011_2.jpg','27','185','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('729','31','Gonzalo Bergessio','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_52328_1627_2011_1.jpg','27','179','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('730','31','Andrea Catellani','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_87091_1627_2011_1.jpg','23','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('731','31','Alfredo Donnarumma','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_130485_1627_2011_1.jpg','21','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('732','32','Nicola Pavarini','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_28027_130_2011_1.jpg','37','190','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('733','32','Antonio Mirante','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_22141_130_2010_1.jpg','28','193','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('734','32','Alberto Gallinetta','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_150552_130_2011_1.jpg','19','195','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('735','32','Rolf Feltscher','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_52590_130_2011_1.jpg','21','181','Venezuela','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('736','32','Cristian Zaccardo','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_5993_130_2011_1.jpg','30','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('737','32','Gonealo Brandeo','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_14195_130_2011_1.jpg','25','182','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('738','32','Massimo Gobbi','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_28020_130_2011_1.jpg','31','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('739','32','Gabriel Paletta','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_30767_130_2011_1.jpg','25','190','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('740','32','Fabiano Santacroce','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_56817_130_2011_1.jpg','25','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('741','32','David Lefquist','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/F/a/s_75884_2719_2008_1.jpg','25','189','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('742','32','Stefano Morrone','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_6722_130_2011_1.jpg','33','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('743','32','Daniele Galloppa','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_22594_130_2011_1.jpg','26','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('744','32','Danilo Pereira','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_141050_16373_2010_1.jpg','20','187','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('745','32','Jaime Valdes','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_22131_130_2011_1.jpg','31','175','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('746','32','Manuele Blasi','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_6090_130_2011_1.jpg','31','179','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('747','32','Francesco Modesto','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_22320_130_2011_1.jpg','29','177','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('748','32','Gianluca Musacci','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_71302_130_2010_1.jpg','24','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('749','32','Abderrazzak Jadid','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_16896_130_2011_1.jpg','28','178','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('750','32','Fernando Marques','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_25414_130_2010_1.jpg','27','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('751','32','Za Eduardo','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_70203_130_2011_1.jpg','20','186','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('752','32','Francesco Valiani','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_41989_130_2011_1.jpg','31','173','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('753','32','Jonathan Biabiany','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45567_130_2011_1.jpg','23','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('754','32','Sebastian Giovinco','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_52312_130_2011_1.jpg','24','164','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('755','32','Sergio Floccari','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_30638_130_2010_1.jpg','30','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('756','32','Raffaele Palladino','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_28855_130_2011_1.jpg','27','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('757','32','Graziano Pelle','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_29594_130_2011_1.jpg','26','193','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('758','33','Jacopo Coletta','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('759','33','Christian Puggioni','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_48003_1408_2009_1.jpg','30','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('760','33','Lorenzo Squizzi','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_22092_862_2009_1.jpg','37','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('761','33','Stefano Sorrentino','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_21891_862_2009_1.jpg','32','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('762','33','Marco Andreolli','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_36356_12_2009_1.jpg','25','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('763','33','Santiago Morero','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_53139_862_2009_1.jpg','29','183','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('764','33','Davide Mandelli','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_21689_862_2009_1.jpg','34','189','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('765','33','Bostjan Cesar','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_24606_1290_2009_1.jpg','29','191','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('766','33','Bojan Jokio','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/B/G/s_44317_750_2009_1.jpg','25','176','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('767','33','Francesco Acerbi','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','23','192','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('768','33','Gennaro Sardo','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_21770_862_2009_1.jpg','32','190','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('769','33','Nicolas Frey','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_38591_862_2009_1.jpg','27','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('770','33','Nestor Djengoue','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','20','188','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('771','33','Boukary Dramr','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_33442_3499_2010_1.jpg','26','180','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('772','33','Michael Bradley','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_30593_18_2010_3.jpg','24','186','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('773','33','Paolo Sammarco','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_7101_410_2009_1.jpg','28','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('774','33','Rinaldo Cruzado','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/K/F/s_35805_2007_1.jpg','27','180','Peru','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('775','33','Luciano','17',NULL,NULL,NULL,'8',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_6233_862_2009_1.jpg','36','181','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('776','33','Luca Rigoni','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_22210_862_2009_1.jpg','27','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('777','33','Kamil Vacek','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_35645_197_2011_1.jpg','24','184','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('778','33','Perparim Hetemaj','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/U/N/s_37295_2007_1.jpg','25','179','Finland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('779','33','Simone Grippo','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_41767_4103_2010_1.jpg','23','188','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('780','33','Radoslav Kirilov','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_140109_14889_2010_1.jpg','19','170','Bulgaria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('781','33','Davide Moscardelli','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_21942_1408_2009_1.jpg','31','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('782','33','Alberto Paloschi','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_68306_130_2009_1.jpg','22','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('783','33','Sergio Pellissier','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5928_862_2009_1.jpg','32','175','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('784','33','Francesco Grandolfo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('785','33','Cyril Thereau','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_29316_172_2009_1.jpg','28','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('786','33','Fernando Uribe','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','24','181','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('787','34','Michael Agazzi','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_28862_1390_2011_1.jpg','27','189','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('788','34','Marco Ruzittu','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_119376_1390_2011_1.jpg','20','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('789','34','Mauro Vigorito','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_88595_1390_2010_2.jpg','21','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('790','34','Vlada Avramov','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_22185_1390_2011_1.jpg','32','187','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('791','34','Simone Gozzi','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_57099_1390_2011_1.jpg','25','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('792','34','Lorenzo Ariaudo','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_84921_1390_2011_1.jpg','22','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('793','34','Davide Astori','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_87210_1390_2011_1.jpg','25','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('794','34','Francesco Pisano','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_35733_1390_2011_1.jpg','25','174','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('795','34','Michele Canini','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_19438_1390_2011_1.jpg','26','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('796','34','Gabriele Perico','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_28817_1390_2011_1.jpg','27','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('797','34','Paolo Dametto','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_136099_1390_2010_1.jpg','18','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('798','34','Nicola Murru','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_171399_1390_2010_1.jpg','17','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('799','34','Alessandro Agostini','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_17171_1390_2011_1.jpg','32','174','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('800','34','Radja Nainggolan','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_41982_1390_2011_1.jpg','23','177','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('801','34','Daniele Conti','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_20730_1390_2011_1.jpg','33','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('802','34','Andrea Cossu','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_21861_1390_2011_1.jpg','31','170','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('803','34','Sebastian Eriksson','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_60534_1390_2010_1.jpg','22','185','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('804','34','Albin Ekdal','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_49275_1390_2011_2.jpg','22','186','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('805','34','Daniele Dessena','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_29962_1038_2011_1.jpg','24','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('806','34','Rui Sampaio','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_48756_1390_2011_2.jpg','24','186','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('807','34','Pablo Ceppelini','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_159773_1390_2011_1.jpg','20','180','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('808','34','Joaquen Larrivey','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_52428_1390_2011_1.jpg','27','185','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('809','34','Moestafa El Kabir','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45513_1390_2011_1.jpg','23','178','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('810','34','Nene','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45717_1390_2011_1.jpg','28','183','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('811','34','Thiago Ribeiro','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_22948_1390_2011_1.jpg','25','183','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('812','34','Vector Ibarbo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_92141_1390_2011_1.jpg','21','186','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('813','35','Nicola Ravaglia','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_42796_1429_2011_1.jpg','23','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('814','35','Michele Gabbianelli','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','190','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('815','35','Vangelis Moras','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_9850_1025_2009_1.jpg','30','193','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('816','35','Guillermo Rodriguez','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_37633_1429_2010_1.jpg','27','184','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('817','35','Maurizio Lauro','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_28823_1429_2011_1.jpg','30','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('818','35','Marco Rossi','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_33605_1429_2011_1.jpg','24','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('819','35','Steve von Bergen','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_4793_1429_2011_1.jpg','28','181','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('820','35','Yohan Benalouane','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_50477_1429_2011_1.jpg','24','185','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('821','35','Stefan Popescu','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_129248_20106_2011_1.jpg','18','180','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('822','35','Luca Ceccarelli','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_41994_1429_2011_1.jpg','28','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('823','35','Roberto Guana','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_5976_1429_2011_1.jpg','30','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('824','35','Antonio Candreva','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_25488_1429_2011_1.jpg','24','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('825','35','Giuseppe Colucci','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_6717_1429_2011_1.jpg','31','179','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('826','35','Raphael Martinho','17',NULL,NULL,NULL,'7',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_149946_1429_2011_1.jpg','23','183','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('827','35','Marco Parolo','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_84545_1429_2011_1.jpg','26','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('828','35','Tibor Cica','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_141043_20106_2011_1.jpg','18','186','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('829','35','Damjan Djokovic','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_143039_1429_2011_1.jpg','21','188','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('830','35','Jorge Martenez','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_55800_1429_2011_1.jpg','28','181','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('831','35','Ader','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37418_1429_2011_1.jpg','25','180','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('832','35','Adrian Mutu','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5879_1429_2011_1.jpg','33','180','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('833','35','Vincenzo Rennella','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61401_1429_2011_1.jpg','23','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('834','35','Dominique Malonga','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45532_1429_2011_1.jpg','23','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('835','35','Marko Livaja','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_95438_1429_2011_1.jpg','18','182','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('836','35','Abdelkader Ghezzal','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_76406_1429_2010_1.jpg','27','186','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('837','36','Jean-Franeois Gillet','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_22149_1025_2011_1.jpg','32','181','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('838','36','Federico Agliardi','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_16888_1025_2011_1.jpg','28','190','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('839','36','Dejan Stojanovic','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_115989_1025_2011_1.jpg','18','196','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('840','36','Filippo Lombardi','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_134382_1025_2011_1.jpg','21','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('841','36','Archimede Morleo','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_85066_1025_2011_1.jpg','28','172','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('842','36','Mikael Antonsson','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_19083_1025_2011_1.jpg','30','189','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('843','36','Gyergy Garics','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_2926_1025_2011_1.jpg','27','183','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('844','36','Luigi Vitale','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_80158_1025_2011_1.jpg','24','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('845','36','Nicola Cherubin','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_56854_1025_2011_1.jpg','25','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('846','36','Cesare Rickler','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_41938_1025_2011_1.jpg','24','196','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('847','36','Matteo Rubin','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_55001_130_2010_1.jpg','24','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('848','36','Simone Loria','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_20741_1025_2011_1.jpg','35','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('849','36','Jose Angel Crespo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_37397_1025_2011_1.jpg','24','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('850','36','Andrea Raggi','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_28845_1025_2011_1.jpg','27','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('851','36','Daniele Portanova','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_21696_1025_2011_1.jpg','33','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('852','36','Rene Krhin','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_73092_1025_2011_1.jpg','21','189','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('853','36','Saphir Taider','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_144779_1025_2011_1.jpg','19','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('854','36','Nico Pulzetti','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_38602_1025_2011_1.jpg','27','176','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('855','36','Diego Parez','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_20378_1025_2011_1.jpg','31','177','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('856','36','Federico Casarini','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_56853_1025_2011_1.jpg','22','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('857','36','Gaby Mudingayi','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_13749_1025_2011_1.jpg','30','180','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('858','36','Panagiotis Kone','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_19636_1025_2011_1.jpg','24','184','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('859','36','Gasten Ramirez','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_123742_1025_2011_1.jpg','21','183','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('860','36','Manuel Gavilen','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_67537_1025_2011_1.jpg','20','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('861','36','Daniele Vantaggiato','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_22155_1025_2011_1.jpg','27','177','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('862','36','Federico Rodriguez','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_159778_1025_2011_1.jpg','20','185','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('863','36','Alessandro Diamanti','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_23197_1025_2011_1.jpg','28','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('864','36','Daniele Paponi','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_35853_1025_2011_1.jpg','23','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('865','36','Henry Gimanez','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_74253_1025_2011_1.jpg','25','176','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('866','36','Robert Acquafresca','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_35703_1025_2011_1.jpg','24','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('867','37','Ugo Gabrieli','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_56678_1005_2011_1.jpg','22','190','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('868','37','Davide Petrachi','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_89181_1005_2011_1.jpg','25','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('869','37','Julio Sergio','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_20052_1005_2011_1.jpg','33','187','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('870','37','Massimiliano Benassi','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_102742_1005_2011_1.jpg','30','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('871','37','Andrea Esposito','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_35849_1005_2011_1.jpg','25','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('872','37','Stefano Ferrario','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_38647_1005_2011_1.jpg','26','190','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('873','37','Souleymane Diamoutene','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_8189_1005_2011_1.jpg','28','184','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('874','37','Davide Brivio','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_38824_1005_2011_1.jpg','23','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('875','37','Nenad Tomovic','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_47085_1005_2011_1.jpg','24','184','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('876','37','Moris Carrozzieri','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_6747_1005_2011_1.jpg','31','192','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('877','37','Manuel Giandonato','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_107873_1005_2011_1.jpg','20','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('878','37','Christian Obodo','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_6087_1005_2011_1.jpg','27','180','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('879','37','Ruben Olivera','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_5768_1005_2011_1.jpg','28','184','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('880','37','Djamel Mesbah','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_17735_1005_2011_1.jpg','27','180','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('881','37','Rodney Strasser','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_88712_1005_2011_1.jpg','21','178','Sierra Leone','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('882','37','Guillermo Giacomazzi','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_6428_1005_2011_1.jpg','34','183','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('883','37','Carlos Grossmoller','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_50791_1005_2011_1.jpg','28','184','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('884','37','Ignacio Piatti','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_37433_1005_2011_1.jpg','26','180','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('885','37','Andrea Bertolacci','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_99227_11947_2010_1.jpg','21','179','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('886','37','Juan Cuadrado','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_91970_1005_2011_1.jpg','23','176','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('887','37','Daniele Corvia','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_16863_1005_2011_1.jpg','27','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('888','37','Edward Ofere','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_35761_1005_2011_1.jpg','25','190','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('889','37','Bryan Bergougnoux','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_12132_1005_2010_1.jpg','29','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('890','37','Dawed Wencent','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_134885_5618_2010_1.jpg','17','161','Cambodja','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('891','37','Luis Muriel','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_119228_1005_2010_1.jpg','20','178','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('892','37','Cristian Pasquato','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_62379_1005_2011_1.jpg','22','174','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('893','38','Ciro Polito','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/c/y/s_22123_2007_1.jpg','32','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('894','38','Andrea Consigli','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_35865_800_2011_1.jpg','24','189','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('895','38','Stefano Lucchini','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_6012_800_2011_1.jpg','31','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('896','38','Daniele Capelli','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_30332_800_2011_1.jpg','25','184','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('897','38','Thomas Manfredini','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_5889_800_2011_1.jpg','31','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('898','38','Gianpaolo Bellini','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_19435_800_2011_1.jpg','31','178','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('899','38','Federico Peluso','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_21763_800_2011_1.jpg','27','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('900','38','Andrea Masiello','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_34198_800_2011_1.jpg','25','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('901','38','Michele Ferri','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_20920_800_2011_1.jpg','30','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('902','38','Ezequiel Schelotto','17',NULL,NULL,NULL,'5',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_119164_800_2011_1.jpg','22','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('903','38','Giacomo Bonaventura','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_57280_800_2011_1.jpg','22','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('904','38','Maximiliano Moralez','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_30687_800_2011_1.jpg','24','160','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('905','38','Carlos Carmona','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_76387_800_2011_1.jpg','24','177','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('906','38','Luca Cigarini','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_33218_800_2010_1.jpg','25','175','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('907','38','Simone Padoin','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_56703_800_2011_1.jpg','27','179','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('908','38','Leonardo Pettinari','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_54135_800_2011_1.jpg','25','177','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('909','38','Matteo Brighi','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5868_800_2010_1.jpg','30','179','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('910','38','Cristian Raimondi','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_22249_800_2011_1.jpg','30','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('911','38','Adriano Ferreira Pinto','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_22811_800_2011_1.jpg','32','178','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('912','38','German Denis','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_30873_800_2010_1.jpg','30','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('913','38','Manolo Gabbiadini','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_112343_800_2011_1.jpg','20','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('914','38','Guido Marilungo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61786_800_2011_1.jpg','22','176','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('915','38','Simone Tiribocchi','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_21700_800_2011_1.jpg','33','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('916','39','Zeljko Brkic','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_37278_448_2009_1.jpg','25','194','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('917','39','Simone Farelli','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/Z/o/s_6807_2004_1.jpg','28','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('918','39','Gianluca Pegolo','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/m/s/s_21872_2006_1.jpg','30','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('919','39','Mihail Ivanov','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','185','Bulgaria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('920','39','Roberto Vitiello','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_22217_4111_2010_1.jpg','28','177','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('921','39','Cristiano Del Grosso','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/z/v/s_34211_2007_1.jpg','28','170','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('922','39','Luca Rossettini','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/F/U/s_60128_2008_1.jpg','26','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('923','39','Nicola Belmonte','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_43082_332_2009_1.jpg','24','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('924','39','Claudio Terzi','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/E/b/s_16873_2008_1.jpg','27','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('925','39','Andrea Rossi','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/i/Z/s_44280_2008_1.jpg','25','177','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('926','39','Emanuele Pesoli','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_29619_4084_2009_1.jpg','31','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('927','39','Gabriele Angella','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_86793_749_2009_1.jpg','22','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('928','39','Matteo Contini','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_25318_142_2010_1.jpg','31','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('929','39','Luigi Giorgi','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_57389_6692_2011_1.jpg','24','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('930','39','Paul Codrea','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/h/q/s_16138_2008_1.jpg','30','174','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('931','39','Angelo','17',NULL,NULL,NULL,'7',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_32966_1005_2009_1.jpg','30','175','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('932','39','Gaetano D&#039;Agostino','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_6157_410_2009_1.jpg','29','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('933','39','Alessandro Gazzi','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_28827_332_2009_1.jpg','28','179','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('934','39','Paolo Grossi','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_126597_4541_2009_1.jpg','26','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('935','39','Joel Acosta','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','20','174','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('936','39','Francesco Bolzoni','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_49521_8970_2009_1.jpg','22','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('937','39','Francesco Parravicini','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/u/i/s_23364_2007_1.jpg','29','176','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('938','39','Daniele Mannini','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_21690_1038_2009_1.jpg','28','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('939','39','Alessio Sestu','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/Z/f/s_23367_2008_1.jpg','28','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('940','39','Reginaldo','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/q/a/s_23365_2007_1.jpg','28','175','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('941','39','Marcelo Larrondo','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','23','191','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('942','39','Emanuele Calain','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/Y/I/s_22268_2008_1.jpg','30','179','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('943','39','Pablo Gonzalez','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61478_458_2011_1.jpg','26','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('944','39','Mattia Destro','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/o/S/s_88683_5380_2009_1.jpg','20','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('945','39','Franco Brienza','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_16137_1386_2009_1.jpg','32','171','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('946','40','Samir Ujkani','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_42744_6692_2011_1.jpg','23','186','Albania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('947','40','Alberto Maria Fontana','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_21884_6692_2011_1.jpg','37','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('948','40','Achille Coser','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_23190_6692_2011_1.jpg','29','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('949','40','Leandro Rinaudo','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_21988_6195_2011_1.jpg','28','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('950','40','Giuseppe Gemiti','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_735_6692_2011_1.jpg','30','176','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('951','40','Andrea Lisuzzo','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_102777_6692_2011_1.jpg','30','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('952','40','Carlalberto Ludi','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_100737_6692_2011_1.jpg','29','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('953','40','Michel Morganella','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_47544_6692_2011_1.jpg','22','183','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('954','40','Paolo Hernan Dellafiore','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_28935_6692_2011_1.jpg','26','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('955','40','Santiago Garcea','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_90489_6692_2011_1.jpg','23','191','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('956','40','Jean-Christophe Coubronne','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_111042_6692_2011_1.jpg','22','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('957','40','Christian Jidayi','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','24','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('958','40','Filippo Porcari','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_61358_6692_2011_1.jpg','27','176','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('959','40','Andrea Mazzarani','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_92880_6692_2011_1.jpg','22','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('960','40','Simone Pesce','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_41312_6692_2011_1.jpg','29','172','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('961','40','Ivan Radovanovic','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_46105_6692_2011_1.jpg','23','186','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('962','40','Giuseppe Mascara','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_22085_6195_2011_1.jpg','32','175','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('963','40','Takayuki Morimoto','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_42417_6692_2011_1.jpg','23','183','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('964','40','Pablo Granoche','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61803_6692_2011_1.jpg','28','183','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('965','40','Jeda','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_21773_6692_2011_1.jpg','32','176','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('966','40','Riccardo Meggiorini','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_28936_6692_2011_1.jpg','26','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('967','40','Andrea Caracciolo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_6098_252_2011_1.jpg','30','194','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('968','40','Samir Ujkani','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_42744_6692_2011_1.jpg','23','186','Albania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('969','40','Alberto Maria Fontana','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_21884_6692_2011_1.jpg','37','188','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('970','40','Achille Coser','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_23190_6692_2011_1.jpg','29','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('971','40','Leandro Rinaudo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_21988_6195_2011_1.jpg','28','191','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('972','40','Giuseppe Gemiti','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_735_6692_2011_1.jpg','30','176','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('973','40','Andrea Lisuzzo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_102777_6692_2011_1.jpg','30','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('974','40','Carlalberto Ludi','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_100737_6692_2011_1.jpg','29','187','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('975','40','Michel Morganella','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_47544_6692_2011_1.jpg','22','183','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('976','40','Paolo Hernan Dellafiore','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_28935_6692_2011_1.jpg','26','186','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('977','40','Santiago Garcea','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_90489_6692_2011_1.jpg','23','191','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('978','40','Jean-Christophe Coubronne','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_111042_6692_2011_1.jpg','22','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('979','40','Christian Jidayi','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','24','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('980','40','Filippo Porcari','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_61358_6692_2011_1.jpg','27','176','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('981','40','Andrea Mazzarani','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_92880_6692_2011_1.jpg','22','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('982','40','Simone Pesce','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_41312_6692_2011_1.jpg','29','172','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('983','40','Ivan Radovanovic','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_46105_6692_2011_1.jpg','23','186','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('984','40','Giuseppe Mascara','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_22085_6195_2011_1.jpg','32','175','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('985','40','Raffaele Rubino','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_15341_6692_2011_1.jpg','34','176','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('986','40','Takayuki Morimoto','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_42417_6692_2011_1.jpg','23','183','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('987','40','Pablo Granoche','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61803_6692_2011_1.jpg','28','183','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('988','40','Jeda','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_21773_6692_2011_1.jpg','32','176','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('989','40','Riccardo Meggiorini','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_28936_6692_2011_1.jpg','26','181','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('990','40','Andrea Caracciolo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_6098_252_2011_1.jpg','30','194','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('991','41','Keylor Navas','18',NULL,NULL,NULL,'1',NULL,'1','http://akacdn.transfermarkt.de/images/portrait/medium/79422-1413205936.jpg','29','185','Costa Rica','6','6','6','0','2','0','0','0','2','0','1','2','5','470',NULL,'0');
INSERT INTO `fman_players` VALUES ('992','41','Thibaut Courtois','18',NULL,NULL,NULL,'1',NULL,'1','https://s5o.ru/storage/simple/ru/edt/d0/8a/7f/c7/rue2b8fc18ada.png','26','199','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','3','24',NULL,'0');
INSERT INTO `fman_players` VALUES ('993','41','Nacho Fernandez','18',NULL,NULL,NULL,'0',NULL,'3','http://akacdn.transfermarkt.de/images/portrait/medium/58884-1413206433.jpg','26','179','Spain','6','6','6','0','0','0','0','0','0','0','3','3','0','24',NULL,'0');
INSERT INTO `fman_players` VALUES ('994','41','Alvaro Odriozola','18',NULL,NULL,NULL,'0',NULL,'3','https://s5o.ru/storage/simple/ru/edt/f5/08/37/b9/rue0200fa1ee0.jpg','22','175','Spain','6','6','6','0','0','0','0','0','0','0','3','3','0','24',NULL,'0');
INSERT INTO `fman_players` VALUES ('995','41','Pepe','18',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/images/portrait/medium/14132-1413206357.jpg','33','187','Portugal','6','6','6','2','0','0','3','1','2','1','4','3','0','870',NULL,'0');
INSERT INTO `fman_players` VALUES ('996','41','Sergio Ramos','18',NULL,NULL,NULL,'4',NULL,'4','http://akacdn.transfermarkt.de/images/portrait/medium/25557-1413190249.jpg','30','183','Spain','6','6','6','2','1','1','2','2','4','2','2','2','0','870',NULL,'0');
INSERT INTO `fman_players` VALUES ('997','41','Marcelo','18',NULL,NULL,NULL,'2',NULL,'2','http://akacdn.transfermarkt.de/images/portrait/medium/44501-1413206117.jpg','28','174','Brazil','6','6','6','5','0','0','1','1','3','1','4','4','0','310',NULL,'0');
INSERT INTO `fman_players` VALUES ('998','41','Casemiro','18',NULL,NULL,NULL,'0',NULL,'2','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_16306_418_2013_10_02_1.jpg','24','184','Brazil','6','6','6','0','0','0','0','0','0','0','3','3','0','24',NULL,'0');
INSERT INTO `fman_players` VALUES ('999','41','Fabio Coentrao','18',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_33648_418_2010_1.jpg','23','179','Portugal','6','6','6','0','0','0','0','0','0','0','3','3','0','24',NULL,'0');
INSERT INTO `fman_players` VALUES ('1000','41','Jesus Vallejo','18',NULL,NULL,NULL,'0',NULL,'4','https://s5o.ru/storage/simple/ru/edt/bc/f8/4b/d1/rue9099c2fb1d.png','21','183','Spain','6','6','6','2','1','1','1','1','0','1','2','1','0','24',NULL,'0');
INSERT INTO `fman_players` VALUES ('1001','41','Daniel Ceballos','18',NULL,NULL,NULL,'0',NULL,'5','https://s5o.ru/storage/simple/ru/edt/82/72/f4/48/rue26be4d3852.png','22','179','Spain','6','6','6','1','1','1','1','1','1','1','1','2','0','64',NULL,'0');
INSERT INTO `fman_players` VALUES ('1002','41','Marcos Llorente','18',NULL,NULL,NULL,'8',NULL,'8','https://s5o.ru/storage/simple/ru/edt/c3/c9/57/df/rue9b3fb062db.png','23','189','Spain','6','6','6','2','2','2','2','0','1','2','1','1','0','846',NULL,'16');
INSERT INTO `fman_players` VALUES ('1003','41','Federico Valverde','18',NULL,NULL,NULL,'0',NULL,'6','https://s5o.ru/storage/simple/ru/edt/be/79/ab/90/rued02f5941f2.jpg','20','181','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1004','41','Gareth Bale','18',NULL,NULL,NULL,'6',NULL,'6','http://akacdn.transfermarkt.de/images/portrait/medium/39381-1413206659.jpg','27','183','Wales','6','6','6','1','1','1','1','2','2','1','2','2','0','886',NULL,'19');
INSERT INTO `fman_players` VALUES ('1005','41','Luka Modric','18',NULL,NULL,NULL,'7',NULL,'7','http://akacdn.transfermarkt.de/images/portrait/medium/27992-1413206775.jpg','31','172','Croatia','6','6','6','1','1','1','2','1','2','1','2','2','0','886',NULL,'0');
INSERT INTO `fman_players` VALUES ('1006','41','Raphael Varane','18',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/images/portrait/medium/164770-1413206196.jpg','23','191','France','6','6','6','2','2','1','2','1','2','1','1','1','0','886',NULL,'0');
INSERT INTO `fman_players` VALUES ('1007','41','Vinicius Junior','18',NULL,NULL,NULL,'0',NULL,'9','https://s5o.ru/storage/simple/ru/edt/b5/9f/72/5c/rue79452379e4.jpg','18','177','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1008','41','Daniel Carvajal','18',NULL,NULL,NULL,'8',NULL,'7','http://akacdn.transfermarkt.de/images/portrait/medium/138927-1413206306.jpg','24','173','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1009','41','Toni Kroos','18',NULL,NULL,NULL,'9',NULL,'9','http://akacdn.transfermarkt.de/images/portrait/medium/31909-1413206824.jpg','26','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1010','41','Marko Asensio','18',NULL,NULL,NULL,'10',NULL,'10','http://http://tmssl.akamaized.net//images/portrait/header/296622-1447228327.jpg','20','182','Spain','6','6','6','1','1','1','2','1','2','2','2','1','0','886',NULL,'31');
INSERT INTO `fman_players` VALUES ('1011','41','Isco Alarcon','18',NULL,NULL,NULL,'10',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_85288_1084_2010_2.jpg','24','180','Spain','6','6','6','1','0','0','1','0','0','0','0','0','0','28',NULL,'2');
INSERT INTO `fman_players` VALUES ('1012','41','Lucas Vazquez','18',NULL,NULL,NULL,'5',NULL,'5','http://akacdn.transfermarkt.de/images/portrait/medium/221316-1435727414.jpg','25','173','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1013','41','Borja Mayoral','18',NULL,NULL,NULL,'0',NULL,'10','https://s5o.ru/storage/simple/ru/edt/fe/32/1e/fa/rue4721e4bddc.png','21','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1014','41','Raul De Tomas','18',NULL,NULL,NULL,'0',NULL,'10','https://s5o.ru/storage/simple/ru/edt/74/91/87/47/rue4233b8890e.jpg','23','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1015','41','Karim Benzema','18',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_18922_418_2010_2.jpg','24','184','France','6','6','6','2','2','1','2','1','1','1','2','1','0','886',NULL,'23');
INSERT INTO `fman_players` VALUES ('1016','42','Marc-Andre ter Stegen','18',NULL,NULL,NULL,'1',NULL,'1','http://tmssl.akamaized.net//images/portrait/header/74857-1476949803.jpg','24','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','10','196',NULL,'0');
INSERT INTO `fman_players` VALUES ('1017','42','Jasper Cillessen','18',NULL,NULL,NULL,'0',NULL,'1','http://tmssl.akamaized.net//bilder/spielerfotos/s_146227_610_2012_2.jpg','27','185','Nedherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1018','42','Jordi Alba','18',NULL,NULL,NULL,'2',NULL,'2','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_69751_3375_2012_2.jpg','27','172','Spain','6','6','6','7','3','8','0','1','1','0','0','0','0','216',NULL,'0');
INSERT INTO `fman_players` VALUES ('1019','42','Gerard Pique','18',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_18944_131_2013_08_05_1.jpg','29','193','Spain','6','6','6','4','2','0','0','10','2','0','0','0','0','256',NULL,'0');
INSERT INTO `fman_players` VALUES ('1020','42','Clement Langlet','18',NULL,NULL,NULL,'0',NULL,'4','https://s5o.ru/storage/simple/ru/edt/24/50/92/08/rue6bf3d0940f.jpg','23','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1021','42','Nelson Semedo','18',NULL,NULL,NULL,'4',NULL,'4','https://s5o.ru/storage/simple/ru/edt/d7/27/7c/97/rue9ca8b233be.jpg','24','177','Portugal','6','6','6','7','3','8','0','1','1','0','0','0','0','216',NULL,'0');
INSERT INTO `fman_players` VALUES ('1022','42','Samuel Umtiti','18',NULL,NULL,NULL,'3',NULL,'3','https://s5o.ru/storage/simple/ru/edt/5b/bd/bb/23/rue2ba8d51523.jpg','24','182','Cameroon','6','6','6','4','2','0','0','10','2','0','0','0','0','256',NULL,'0');
INSERT INTO `fman_players` VALUES ('1023','42','Arthur Enrique Ramos','18',NULL,NULL,NULL,'0',NULL,'5','https://s5o.ru/storage/simple/ru/edt/2e/a4/50/10/rue44473cf124.jpg','22','172','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1024','42','Arturo Vidal','18',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/12/78/75/81/rue67548713a9.jpg','31','181','Chile','6','6','6','7','0','3','0','2','8','0','0','0','0','176',NULL,'43');
INSERT INTO `fman_players` VALUES ('1025','42','Thomas Vermaelen','18',NULL,NULL,NULL,'0',NULL,'3','https://s5o.ru/storage/simple/ru/edt/45/49/21/b6/rue0fe975637b.jpg','32','183','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1026','42','Andres Iniesta','18',NULL,NULL,NULL,'0',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/7600-1464872266.jpg','32','170','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1027','42','Andre Gomes','18',NULL,NULL,NULL,'0',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/221025-1447247163.jpg','23','188','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1028','42','Philippe Coutinho','18',NULL,NULL,NULL,'8',NULL,'8','https://s5o.ru/storage/simple/ru/edt/45/25/65/52/rue420643e073.jpg','26','172','Brazil','6','6','6','7','0','2','0','0','8','0','0','0','0','416',NULL,'43');
INSERT INTO `fman_players` VALUES ('1029','42','Rafael Alcantara','18',NULL,NULL,NULL,'0',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/129473-1454080405.jpg','23','174','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1030','42','Javier Mascherano','18',NULL,NULL,NULL,'0',NULL,'5','http://tmssl.akamaized.net//images/portrait/header/19981-1465280515.jpg','32','174','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1031','42','Sergio Busquets','18',NULL,NULL,NULL,'0',NULL,'5','http://tmssl.akamaized.net//images/portrait/header/65230-1453896822.jpg','28','189','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1032','42','Ivan Rakitic','18',NULL,NULL,NULL,'7',NULL,'7','http://tmssl.akamaized.net//images/portrait/header/32467-1404225054.jpg','28','184','Croatia','6','6','6','6','1','1','2','0','7','0','0','0','0','936',NULL,'0');
INSERT INTO `fman_players` VALUES ('1033','42','Sergi Roberto','18',NULL,NULL,NULL,'0',NULL,'7','http://tmssl.akamaized.net//bilder/spielerfotos/s_85370_2464_2013_02_19_1.jpg','24','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1034','42','Denis Suarez','18',NULL,NULL,NULL,'0',NULL,'7','http://tmssl.akamaized.net//images/portrait/header/165007-1447239749.jpg','22','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1035','42','Luis Suarez','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/44352-1453896733.jpg','29','181','Uruguay','6','6','6','2','0','1','0','12','0','1','0','0','0','376',NULL,'116');
INSERT INTO `fman_players` VALUES ('1036','8','Ousmane Dembele','18',NULL,NULL,NULL,'8',NULL,'9','https://s5o.ru/storage/simple/ru/edt/3b/da/80/f0/rue57aadb2ef6.jpg','21','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1038','42','Sardor Rahmonov','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/82048-1449059953.jpg?em=1449059982','21','195','Spain','6','6','6','2','0','2','0','12','0','0','0','2','0','300',NULL,'104');
INSERT INTO `fman_players` VALUES ('1039','43','Diego Alves','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_42373_1049_2010_2.jpg','26','188','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','646',NULL,'0');
INSERT INTO `fman_players` VALUES ('1040','43','Cristiano Pereira','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_100127_16374_2010_1.jpg','21','192','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','612',NULL,'0');
INSERT INTO `fman_players` VALUES ('1041','43','Hedwiges Maduro','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_19057_1049_2010_2.jpg','26','185','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','646',NULL,'0');
INSERT INTO `fman_players` VALUES ('1042','43','Adil Rami','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_51118_1049_2010_1.jpg','26','190','France','6','6','6','0','0','0','0','0','0','0','0','0','0','646',NULL,'0');
INSERT INTO `fman_players` VALUES ('1043','43','Antonio Barragen','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_32522_1049_2010_1.jpg','24','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','646',NULL,'0');
INSERT INTO `fman_players` VALUES ('1044','43','Dealbert','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_51420_1049_2010_2.jpg','29','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','612',NULL,'0');
INSERT INTO `fman_players` VALUES ('1045','43','Vector Ruiz','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_62920_1049_2010_1.jpg','22','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','612',NULL,'0');
INSERT INTO `fman_players` VALUES ('1046','43','Ricardo Costa','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_9819_1049_2010_2.jpg','30','183','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','612',NULL,'0');
INSERT INTO `fman_players` VALUES ('1047','43','J?r?my Mathieu','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_5404_1049_2010_2.jpg','28','190','France','6','6','6','0','0','0','0','0','0','0','0','0','0','612',NULL,'0');
INSERT INTO `fman_players` VALUES ('1048','43','Miguel','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_13225_1049_2010_2.jpg','32','179','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','612',NULL,'0');
INSERT INTO `fman_players` VALUES ('1049','43','Mehmet Topal','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_44402_3381_2010_1.jpg','25','187','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','646',NULL,'0');
INSERT INTO `fman_players` VALUES ('1050','43','Sofiane Feghouli','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_57162_1049_2010_2.jpg','22','178','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','34',NULL,'1');
INSERT INTO `fman_players` VALUES ('1051','43','?ver Banega','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_12249_1049_2010_1.jpg','23','173','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','34',NULL,'0');
INSERT INTO `fman_players` VALUES ('1052','43','Sergio Canales','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_66106_1049_2010_2.jpg','20','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','34',NULL,'1');
INSERT INTO `fman_players` VALUES ('1053','43','Pablo Hernandez','17',NULL,NULL,NULL,'9',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_46220_1049_2010_2.jpg','26','173','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','34',NULL,'1');
INSERT INTO `fman_players` VALUES ('1054','43','Dani Parejo','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_59561_9567_2010_2.jpg','22','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1055','43','Tino Costa','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_77003_1049_2010_2.jpg','27','176','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1056','43','Juan Bernat','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_126719_1049_2010_1.jpg','18','172','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1057','43','Jonas','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_50143_3439_2010_1.jpg','27','181','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','34',NULL,'1');
INSERT INTO `fman_players` VALUES ('1058','43','Aritz Aduriz','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_29124_1049_2010_2.jpg','30','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','34',NULL,'0');
INSERT INTO `fman_players` VALUES ('1059','43','Pablo Piatti','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_56067_1049_2010_2.jpg','22','163','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1060','44','Cesar Sanchez','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_7510_1050_2010_1.jpg','40','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1061','44','Diego Mari?o','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_59349_9567_2010_1.jpg','21','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1062','44','Gonzalo Rodriguez','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_19998_1050_2010_2.jpg','27','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1063','44','Joan Oriol','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_73215_1050_2010_2.jpg','25','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1064','44','Mateo Musacchio','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45653_1050_2010_2.jpg','21','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1065','44','Carlos Marchena','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_7572_3375_2010_1.jpg','32','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1066','44','Angel Lopez','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_15500_1050_2010_2.jpg','30','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1067','44','Cristian Zapata','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_34344_1050_2010_1.jpg','25','188','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1068','44','Mario Gaspar','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_73250_11972_2010_1.jpg','21','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1069','44','Jos Manuel Catale','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_64385_1050_2010_2.jpg','27','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1070','44','Jonathan de Guzman','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_31067_1050_2010_1.jpg','24','174','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1071','44','Cani','17',NULL,NULL,NULL,'6',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_7983_1050_2010_2.jpg','30','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1072','44','Hernan Parez','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_73636_11972_2010_1.jpg','22','180','Paraguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1073','44','Javier Camulas','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_29170_1050_2010_1.jpg','31','172','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1074','44','Wakaso Mubarak','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_45639_1050_2010_1.jpg','21','173','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('1075','44','Marcos Senna','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_7840_1050_2010_2.jpg','35','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1076','44','Borja Valero','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_40372_1050_2010_3.jpg','27','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1077','44','Bruno Soriano','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_44412_1050_2010_2.jpg','27','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1078','44','Gerard Bordas','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_73204_11972_2010_2.jpg','30','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1079','44','Marcos Gullan','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_73254_11972_2010_3.jpg','22','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1080','44','Giovani dos Santos','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_44674_630_2010_1.jpg','25','174','Mexico','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('1081','44','Nilmar','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_22750_1050_2010_3.jpg','27','180','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1082','44','Marco Ruben','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_30825_1050_2010_2.jpg','25','179','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1083','44','Giuseppe Rossi','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_19104_3376_2010_1.jpg','24','173','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1084','44','Joselu','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_143044_11972_2010_3.jpg','20','171','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1085','45','Javier Varas','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_58341_368_2010_2.jpg','29','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','1','124',NULL,'0');
INSERT INTO `fman_players` VALUES ('1086','45','Dani Jima?nez','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_126509_8519_2010_1.jpg','21','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1087','45','Federico Fazio','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45314_368_2010_2.jpg','24','195','Argentina','6','6','6','0','0','0','0','2','0','0','0','0','0','84',NULL,'0');
INSERT INTO `fman_players` VALUES ('1088','45','Fernando Navarro','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_7593_368_2010_2.jpg','29','179','Spain','6','6','6','0','0','2','0','0','0','0','0','0','0','84',NULL,'0');
INSERT INTO `fman_players` VALUES ('1089','45','Marten Coceres','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_54935_3449_2010_2.jpg','24','182','Uruguay','6','6','6','0','0','0','0','2','0','0','0','0','0','84',NULL,'0');
INSERT INTO `fman_players` VALUES ('1090','45','Alexis','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_7781_368_2010_2.jpg','26','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1091','45','Emir Spahic','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_25812_3446_2010_1.jpg','31','183','Bosnia-Herzegovina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1092','45','Julien Escudo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3573_368_2010_2.jpg','32','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1093','45','Antonio Luna','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_126516_20911_2010_1.jpg','20','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1094','45','Coke','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_71905_368_2010_2.jpg','24','182','Spain','6','6','6','0','0','1','0','0','0','0','0','0','0','96',NULL,'0');
INSERT INTO `fman_players` VALUES ('1095','45','Samu','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_85367_8519_2010_1.jpg','19','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1096','45','Gary Medel','18',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_60889_3700_2010_2.jpg','24','171','Chile','6','6','6','0','0','2','0','0','0','0','0','0','0','96',NULL,'0');
INSERT INTO `fman_players` VALUES ('1097','45','Diego Perotti','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_54984_368_2010_2.jpg','23','179','Argentina','6','6','6','1','0','1','0','0','1','0','0','0','0','84',NULL,'1');
INSERT INTO `fman_players` VALUES ('1098','45','Piotr Trochowski','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_2623_368_2010_2.jpg','27','168','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'0');
INSERT INTO `fman_players` VALUES ('1099','45','Jose Gomez','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_120095_368_2010_1.jpg','18','179','Spain','6','6','6','1','0','1','0','0','1','0','0','0','0','84',NULL,'1');
INSERT INTO `fman_players` VALUES ('1100','45','Tiberio Guarente','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_28868_368_2010_2.jpg','26','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'0');
INSERT INTO `fman_players` VALUES ('1101','45','Emiliano Armenteros','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_30747_368_2010_1.jpg','25','178','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1102','45','Jose Antonio Reyes','17',NULL,NULL,NULL,'8',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_7717_13_2010_3.jpg','28','175','Spain','6','6','6','0','0','1','0','0','0','0','0','0','0','96',NULL,'2');
INSERT INTO `fman_players` VALUES ('1103','45','Tom de Mul','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_15893_368_2010_1.jpg','25','177','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1104','45','Salva','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_81990_8519_2010_1.jpg','21','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1105','45','Frederic Kanoute','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3700_368_2010_2.jpg','34','192','Mali','6','6','6','0','0','0','0','2','0','0','0','0','0','84',NULL,'6');
INSERT INTO `fman_players` VALUES ('1106','45','Manu del Moral','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37399_368_2010_2.jpg','27','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','68',NULL,'0');
INSERT INTO `fman_players` VALUES ('1107','45','Luis Alberto','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_128220_8519_2010_2.jpg','19','182','Spain','6','6','6','1','0','0','0','0','0','0','0','0','0','96',NULL,'5');
INSERT INTO `fman_players` VALUES ('1108','46','Gorka Iraizoz','18',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_7874_621_2010_2.jpg','30','191','Spain','6','6','6','0','0','0','0','0','0','0','0','0','1','424',NULL,'0');
INSERT INTO `fman_players` VALUES ('1109','46','Raul Fernandez','18',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_54217_621_2010_2.jpg','23','196','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1110','46','Jon Aurtenetxe','18',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_89726_621_2010_2.jpg','20','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'0');
INSERT INTO `fman_players` VALUES ('1111','46','Fernando Amorebieta','18',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_35548_621_2010_2.jpg','26','192','Venezuela','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'0');
INSERT INTO `fman_players` VALUES ('1112','46','Mikel San Jose','18',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_52469_621_2010_2.jpg','22','186','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'0');
INSERT INTO `fman_players` VALUES ('1113','46','Koikili','18',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_57024_621_2010_2.jpg','31','168','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1114','46','Andoni Iraola','18',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_15804_621_2010_2.jpg','29','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1115','46','Iban Zubiaurre','18',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_47666_621_2010_1.jpg','28','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1116','46','Aitor Ocio','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_7615_621_2010_2.jpg','35','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1117','46','Xabier Castillo','18',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_30097_621_2010_2.jpg','25','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1118','46','Borja Ekiza','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_89318_621_2010_1.jpg','23','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1119','46','David Lopez','18',NULL,NULL,NULL,'5',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_25462_621_2010_2.jpg','29','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'0');
INSERT INTO `fman_players` VALUES ('1120','46','Ander Iturraspe','18',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_71571_621_2010_2.jpg','22','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'1');
INSERT INTO `fman_players` VALUES ('1121','46','Ascar de Marcos','18',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_96718_621_2010_2.jpg','22','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'0');
INSERT INTO `fman_players` VALUES ('1122','46','Igor Gabilondo','18',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_7471_621_2010_2.jpg','32','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'3');
INSERT INTO `fman_players` VALUES ('1123','46','Markel Susaeta','18',NULL,NULL,NULL,'9',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_54245_621_2010_2.jpg','24','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'5');
INSERT INTO `fman_players` VALUES ('1124','46','Iaigo Parez','18',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_71579_621_2010_2.jpg','23','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1125','46','Carlos Gurpegi','18',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_7631_621_2010_2.jpg','31','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1126','46','Ander Herrera','18',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_99343_621_2010_2.jpg','22','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1127','46','Javi Martenez','18',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_44017_621_2010_1.jpg','23','190','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1128','46','Igor Martenez','18',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_60779_621_2010_1.jpg','22','169','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1129','46','Gaizka Toquero','18',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_71840_621_2010_2.jpg','27','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'3');
INSERT INTO `fman_players` VALUES ('1130','46','Iker Muniain','18',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_54235_621_2010_2.jpg','19','169','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','504',NULL,'0');
INSERT INTO `fman_players` VALUES ('1131','46','Ibai Gomez','18',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_127837_6688_2010_2.jpg','22','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1132','0','Antonio Adan','18',NULL,'1','0','0','0','1','https://s5o.ru/storage/simple/ru/edt/04/00/25/45/rueb398e81496.jpeg','31','191','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535899859','0');
INSERT INTO `fman_players` VALUES ('1133','47','Jan Oblak','18',NULL,NULL,NULL,'1',NULL,'1','http://tmssl.akamaized.net/images/portrait/header/121483-1447152842.jpg','23','189','Slovenija','6','6','6','0','0','0','0','0','0','0','0','0','2','948',NULL,'0');
INSERT INTO `fman_players` VALUES ('1134','47','Diego Godin','18',NULL,NULL,NULL,'3',NULL,'3','http://tmssl.akamaized.net/images/portrait/header/54928-1447152630.jpg','30','187','Uruguay','6','6','6','0','0','0','0','3','0','0','0','0','0','948',NULL,'0');
INSERT INTO `fman_players` VALUES ('1135','47','Felipe Luis','18',NULL,NULL,NULL,'2',NULL,'2','http://tmssl.akamaized.net/images/portrait/header/21725-1447152742.jpg','31','182','Brazil','6','6','6','0','0','3','0','0','0','0','0','0','0','948',NULL,'0');
INSERT INTO `fman_players` VALUES ('1136','47','Jose Himenez','18',NULL,NULL,NULL,'3',NULL,'3','http://tmssl.akamaized.net/images/portrait/header/250845-1447152624.jpg','21','185','Spain','6','6','6','0','0','0','0','3','0','0','0','0','0','948',NULL,'0');
INSERT INTO `fman_players` VALUES ('1137','47','Lucas Hernandez','18',NULL,NULL,NULL,'0',NULL,'3','http://tmssl.akamaized.net/images/portrait/header/281963-1447152654.jpg','20','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1138','47','Saul Niguez','18',NULL,NULL,NULL,'0',NULL,'3','http://tmssl.akamaized.net/images/portrait/header/148928-1447152836.jpg','21','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1139','47','Stefan Savic','18',NULL,NULL,NULL,'0',NULL,'3','http://tmssl.akamaized.net/images/portrait/header/107010-1447152848.jpg','25','187','Montenegro','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1140','47','Santiago Ariaz','18',NULL,NULL,NULL,'0',NULL,'2','https://s5o.ru/storage/simple/ru/edt/60/12/24/75/rue4e598a5143.jpg','26','176','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1141','47','Gabi','18',NULL,NULL,NULL,'0',NULL,'5','http://tmssl.akamaized.net/images/portrait/header/22969-1447152522.jpg','33','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1142','47','Koke','18',NULL,NULL,NULL,'7',NULL,'7','http://tmssl.akamaized.net/images/portrait/header/74229-1447152736.jpg','24','177','Spain','6','6','6','0','0','0','0','0','1','0','0','0','0','1148',NULL,'0');
INSERT INTO `fman_players` VALUES ('1143','47','Juanfran','18',NULL,NULL,NULL,'4',NULL,'7','http://tmssl.akamaized.net/images/portrait/header/16635-1447152729.jpg','31','180','Spain','6','6','6','0','0','3','0','0','0','0','0','0','0','948',NULL,'0');
INSERT INTO `fman_players` VALUES ('1144','47','Yannick Carrasco','18',NULL,NULL,NULL,'6',NULL,'9','http://tmssl.akamaized.net/images/portrait/header/140776-1447152507.jpg','23','181','Belgium','6','6','6','0','0','0','0','0','3','0','0','0','0','948',NULL,'21');
INSERT INTO `fman_players` VALUES ('1145','47','Antoine Griezmann','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net/images/portrait/header/125781-1447152648.jpg','25','176','France','6','6','6','0','0','0','0','3','0','0','0','0','0','948',NULL,'36');
INSERT INTO `fman_players` VALUES ('1146','47','Nicola Kalinic','18',NULL,NULL,NULL,'8',NULL,'10','https://s5o.ru/storage/simple/ru/edt/68/91/75/13/ruef101aa1bb3.png','30','187','Colombia','6','6','6','0','0','0','0','0','3','0','0','0','0','948',NULL,'19');
INSERT INTO `fman_players` VALUES ('1147','47','Diego Costa','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/06/af/01/39/rue891c896799.png','29','188','Spain','6','6','6','0','0','0','0','3','0','0','0','0','0','948',NULL,'28');
INSERT INTO `fman_players` VALUES ('1148','47','Angel Correa','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net/images/portrait/header/266807-1447152515.jpg','21','172','Argentina','6','6','6','0','0','0','0','3','0','0','0','0','0','948',NULL,'40');
INSERT INTO `fman_players` VALUES ('1149','48','Carlos Kameni','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_7914_714_2010_1.jpg','27','186','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1150','48','Cristian Alvarez','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_55135_714_2010_1.jpg','26','186','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1151','48','Felipe Mattioni','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_52432_714_2010_2.jpg','23','180','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1152','48','Raul Rodriguez','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_72935_714_2010_2.jpg','24','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1153','48','Jordi Amat','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_85289_714_2010_2.jpg','19','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1154','48','Ernesto Galen','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_73009_714_2010_3.jpg','25','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1155','48','Hactor Moreno','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_51046_714_2010_1.jpg','23','184','Mexico','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1156','48','Juan Forlan','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_53332_714_2010_2.jpg','24','180','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1157','48','Dodac Vile','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_67090_9567_2010_1.jpg','22','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1158','48','Javi Marquez','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_72315_714_2010_2.jpg','25','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1159','48','Jose Rael Baena','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_74557_714_2010_2.jpg','22','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1160','48','Joan Verda','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_28005_714_2010_1.jpg','28','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1161','48','Romaric','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_15808_714_2010_1.jpg','28','187','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1162','48','Javi Lopez','17',NULL,NULL,NULL,'9',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_72310_714_2010_2.jpg','25','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1163','48','Vladimer Weiss','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_92701_3503_2010_2.jpg','22','176','Slovakia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1164','48','Jesus Detolo','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_30759_714_2010_3.jpg','27','177','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1165','48','Juan angel Alben','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_44139_714_2010_1.jpg','25','179','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1166','48','Rui Fonte','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_9335_714_2010_1.jpg','21','181','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1167','48','Alvaro','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_141835_714_2010_3.jpg','20','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1168','48','Sergio Garcia','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_7922_714_2010_2.jpg','28','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1169','48','Wolter Pandiani','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_7691_714_2010_1.jpg','35','183','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1170','48','Thievy Bifouma','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_181477_9478_2010_1.jpg','19','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1171','49','Ricardo','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_3535_331_2010_2.jpg','40','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1172','49','Asier Riesgo','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_23338_331_2010_3.jpg','28','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1173','49','Andris Fernandez','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_57522_331_2010_1.jpg','25','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1174','49','Marc Bertran','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_15761_331_2010_2.jpg','29','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1175','49','Ruban Gonzalez','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_7519_331_2010_2.jpg','29','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1176','49','Miguel Flaco','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_35600_331_2010_2.jpg','27','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1177','49','Lolo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_58789_331_2010_3.jpg','27','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1178','49','Jon Echaide','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_59527_331_2010_1.jpg','24','173','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1179','49','Roversio','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_25110_331_2010_1.jpg','27','187','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1180','49','Jukka Raitala','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_47785_331_2010_2.jpg','23','181','Finland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1181','49','Sergio','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_7544_331_2010_2.jpg','34','191','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1182','49','Damin','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_28002_331_2010_3.jpg','29','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1183','49','Javad Nekounam','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_24619_3582_2010_1.jpg','31','186','Iran','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1184','49','Masoud Shojaei','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_26574_331_2010_1.jpg','27','184','Iran','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1185','49','Patxi','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_7739_331_2010_3.jpg','36','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1186','49','Javier Calleja','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_7842_331_2010_1.jpg','33','171','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1187','49','Raul Garcea','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_34601_331_2010_2.jpg','25','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1188','49','Alvaro Cejudo','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_72779_331_2010_2.jpg','27','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1189','49','Xavier Annunziata','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_94910_331_2010_2.jpg','24','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1190','49','David Timor','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_158795_331_2010_2.jpg','22','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1191','49','Kike Sola','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_51532_331_2010_2.jpg','25','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1192','49','Dejan Lekic','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_49795_331_2010_3.jpg','26','193','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1193','49','Nino','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_29178_331_2010_2.jpg','31','171','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1194','49','Ibrahima Balde','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_134497_331_2010_3.jpg','22','190','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1195','49','Roland Lamah','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_35035_331_2010_3.jpg','24','180','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1196','50','Juan Pablo','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_27685_2448_2010_2.jpg','33','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1197','50','Ivan Cuollar','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_27493_2448_2010_2.jpg','27','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1198','50','Alberto Botea','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_53077_2448_2010_1.jpg','22','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1199','50','Alberto Lora','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_57816_2448_2010_2.jpg','24','168','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1200','50','Gregory Arnolin','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_25825_2448_2010_2.jpg','31','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1201','50','Roberto Canella','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_57785_2448_2010_2.jpg','23','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1202','50','Damien Suarez','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_76746_2448_2010_1.jpg','23','173','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1203','50','Andro Castro','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_58267_2448_2010_2.jpg','23','181','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1204','50','Alberto Rivera','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_23306_2448_2010_2.jpg','33','170','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1205','50','Carmelo','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_44038_2448_2010_2.jpg','28','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1206','50','Ayoze','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_51518_2448_2010_2.jpg','26','172','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1207','50','Sebastian Eguren','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_35590_2448_2010_3.jpg','31','186','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1208','50','Ivan Hernandez','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_29066_2448_2010_2.jpg','31','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1209','50','Sergio Alvarez','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_138935_2448_2010_1.jpg','19','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1210','50','Luis Moren','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_57826_2448_2010_2.jpg','24','172','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1211','50','Miguel de las Cuevas','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_54774_2448_2010_2.jpg','25','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1212','50','Nacho Cases','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_89473_2448_2010_2.jpg','24','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1213','50','Ricardo Leon','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_51516_2448_2010_1.jpg','28','186','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1214','50','Oscar Trejo','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_30321_2448_2010_1.jpg','23','180','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1215','50','Mate Bilic','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_7977_2448_2010_2.jpg','31','185','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1216','50','Nacho Novo','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_12844_2448_2010_3.jpg','32','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1217','50','Gasten Sangoy','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_19999_2448_2010_2.jpg','27','178','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1218','50','David Barral','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_20346_2448_2010_2.jpg','28','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1219','51','Ruban','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_8184_1084_2010_2.jpg','27','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1220','51','Willy Caballero','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_19948_1084_2010_2.jpg','30','186','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1221','51','Javier Malagueo','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_58722_1084_2010_1.jpg','29','184','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1222','51','Jesus Gomez','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_29055_1084_2010_2.jpg','26','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1223','51','Weligton','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_22550_1084_2010_2.jpg','32','186','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1224','51','Kris Stadsgaard','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_22931_1084_2010_2.jpg','26','185','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1225','51','Marten Demichelis','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_2963_1084_2010_1.jpg','31','184','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1226','51','Joris Mathijsen','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_4563_1084_2010_1.jpg','31','182','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1227','51','Nacho Monreal','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_43003_1084_2010_1.jpg','25','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1228','51','Sergio Sanchez','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_38270_1084_2010_2.jpg','25','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1229','51','Halder Rosario','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_14196_1084_2010_1.jpg','31','180','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1230','51','Ignacio Camacho','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_58874_1084_2010_2.jpg','21','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1231','51','Joaquen','17',NULL,NULL,NULL,'6',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_7663_1084_2010_2.jpg','30','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1232','51','Jaremy Toulalan','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_5513_1084_2010_1.jpg','28','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1233','51','Apolo','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_58013_1084_2010_2.jpg','27','173','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1234','51','Santi Cazorla','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_15799_1084_2010_1.jpg','27','168','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1235','51','Enzo Maresca','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_16651_1084_2010_2.jpg','31','180','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1236','51','Duda','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_7782_1084_2010_2.jpg','31','175','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1237','51','Julio Baptista','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_15952_1084_2010_2.jpg','30','185','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1238','51','Diego Buonanotte','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_45646_1084_2010_2.jpg','23','161','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1239','51','Francisco Portillo','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_138803_1084_2010_1.jpg','21','169','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1240','51','Recio','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_150948_20911_2010_1.jpg','21','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1241','51','Ruud van Nistelrooy','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3407_1084_2010_1.jpg','35','188','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1242','51','Sebastin Fernandez','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_64545_1084_2010_2.jpg','26','168','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1243','51','Eliseu','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_14192_1084_2010_1.jpg','28','175','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1244','51','Jose Saloman Ronden','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_80197_1084_2010_1.jpg','22','186','Venezuela','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1245','51','Edinho','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_29366_1084_2010_2.jpg','29','182','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1246','51','Juanmi','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_126737_1084_2010_1.jpg','18','169','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1247','52','Mario','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_57693_630_2010_2.jpg','23','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1248','52','Tojo','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_35536_630_2010_2.jpg','32','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1249','52','Jose Pican','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_89379_630_2010_2.jpg','23','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1250','52','Cristian Fernandez','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_48294_630_2010_2.jpg','26','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1251','52','Osmar Barba','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_89370_630_2010_2.jpg','23','190','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1252','52','Domingo Cisma','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_51535_630_2010_3.jpg','29','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1253','52','Alvaro Gonzalez','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_183647_630_2010_2.jpg','22','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1254','52','Francis Parez','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_29156_630_2010_3.jpg','30','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1255','52','Bernardo Espinosa','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_64598_630_2010_2.jpg','22','192','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1256','52','Marc Torrejan','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_38266_630_2010_2.jpg','25','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1257','52','Damien esmodes','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_63451_3584_2010_1.jpg','22','179','Peru','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1258','52','Papakouli Diop','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_39907_630_2010_2.jpg','25','180','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1259','52','Manuel Arana','17',NULL,NULL,NULL,'7',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_51383_630_2010_2.jpg','27','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1260','52','Gonzalo Colsa','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_7813_630_2010_2.jpg','32','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1261','52','Pedro Munitis','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_7864_630_2010_2.jpg','36','167','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1262','52','escar Serrano','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_26373_630_2010_2.jpg','30','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1263','52','Kennedy','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_17221_630_2010_4.jpg','31','181','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1264','52','Julien Luque','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_99349_630_2010_2.jpg','19','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1265','52','Edu Bedia','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_74764_630_2010_2.jpg','22','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1266','52','Alexandros Tziolis','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_12883_630_2010_2.jpg','26','189','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1267','52','Adrien Gonzelez','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_44073_630_2010_3.jpg','23','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1268','52','Jairo','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_171167_630_2010_1.jpg','18','170','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1269','52','Lautaro Acosta','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45307_630_2010_2.jpg','23','169','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1270','52','Christian Stuani','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_59323_630_2010_2.jpg','25','186','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1271','52','Ariel Nahuelpen','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_68562_630_2010_3.jpg','24','187','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1272','52','Mamadou Kone','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_171165_630_2010_1.jpg','20','177','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1273','53','Roberto Jimenez','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_37403_142_2010_1.jpg','25','191','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1274','53','Leo Franco','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_7669_142_2010_3.jpg','34','188','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1275','53','Javier Paredes','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_35512_142_2010_2.jpg','29','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1276','53','David Mateos','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45304_142_2010_2.jpg','24','191','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1277','53','Maurizio Lanzaro','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_6852_142_2010_2.jpg','28','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1278','53','Fernendo Meira','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1432_142_2010_2.jpg','33','190','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1279','53','Paulo da Silva','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_38800_142_2010_2.jpg','31','180','Paraguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1280','53','Abraham Minero','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_95483_142_2010_2.jpg','25','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1281','53','edem Pinter','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_63209_142_2010_1.jpg','23','192','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1282','53','Ivan Obradovic','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_49802_142_2010_2.jpg','23','181','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1283','53','Tomislav Dujmovic','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_27986_3556_2010_1.jpg','30','188','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1284','53','Efraen Juerez','17',NULL,NULL,NULL,'6',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_66130_142_2010_3.jpg','23','178','Mexico','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1285','53','Juan Carlos Perez','17',NULL,NULL,NULL,'7',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_126625_142_2010_2.jpg','21','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1286','53','engel Lafita','17',NULL,NULL,NULL,'8',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_35562_142_2010_3.jpg','27','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1287','53','Reben Micael','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_84491_142_2010_2.jpg','25','176','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1288','53','Antonio Tomes','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_37340_142_2010_2.jpg','27','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1289','53','Franco Zuculini','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_73083_142_2010_2.jpg','21','176','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1290','53','Kevin Lacruz','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_89743_142_2010_1.jpg','19','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1291','53','Carlos Aranda','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_7841_3368_2010_2.jpg','31','186','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1292','53','Edu Oriol','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_95488_142_2010_2.jpg','25','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1293','53','Helder Postiga','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5169_142_2010_1.jpg','29','182','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1294','53','Luis Garcea','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_8006_142_2010_2.jpg','30','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1295','53','Pablo Barrera','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_51079_142_2010_1.jpg','24','175','Mexico','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1296','54','Gustavo Munea','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_9091_3368_2010_3.jpg','33','188','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1297','54','Keylor Navas','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_79422_3368_2010_1.jpg','25','186','Costa Rica','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1298','54','Nano','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_22974_3368_2010_3.jpg','31','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1299','54','Hector Rodas','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_72286_3368_2010_2.jpg','23','190','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1300','54','Juanfran','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_7542_3368_2010_2.jpg','35','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1301','54','Asier del Horno','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_7617_3368_2010_3.jpg','30','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1302','54','Javi Venta','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_7831_3368_2010_3.jpg','36','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1303','54','Sergio Ballesteros','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_7828_3368_2010_2.jpg','36','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1304','54','Pedro Lepez','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_25412_3368_2010_2.jpg','28','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1305','54','Gustavo Cabral','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_30677_3368_2010_1.jpg','26','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1306','54','Francisco Farines','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5785_3368_2010_2.jpg','33','173','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1307','54','Miguel Pallarde','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_36756_3368_2010_2.jpg','25','173','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1308','54','Jose Javier Barkero','17',NULL,NULL,NULL,'7',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_7468_3368_2010_2.jpg','32','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1309','54','Vicente Iborra','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_65467_3368_2010_2.jpg','23','190','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1310','54','Xavi Torres','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_65301_3368_2010_2.jpg','25','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1311','54','Marc Mateu','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_96539_3368_2010_1.jpg','21','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1312','54','Juanlu','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_22568_3368_2010_2.jpg','31','172','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1313','54','Valdo','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_7528_3368_2010_3.jpg','30','184','Cape Verde','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1314','54','Nabil El Zhar','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_37917_3368_2010_2.jpg','25','170','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1315','54','Arouna Kone','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_8552_3368_2010_1.jpg','28','181','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1316','54','Rafa Jorde','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_51578_3368_2010_2.jpg','28','192','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1317','54','Ruben Suerez','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_29193_3368_2010_2.jpg','32','168','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1318','55','Eeaut Zubikarai','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_76076_681_2010_2.jpg','27','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1319','55','Toeo','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_76285_681_2010_2.jpg','25','191','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1320','55','Carlos Martenez','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_58074_681_2010_2.jpg','25','189','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1321','55','Mikel Gonzelez','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_35560_681_2010_2.jpg','26','190','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1322','55','Ion Ansotegi','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_37892_681_2010_2.jpg','29','192','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1323','55','Vadim Demidov','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_37247_681_2010_2.jpg','25','186','Norway','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1324','55','Liassine Cadamuro','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_89325_681_2010_1.jpg','23','188','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1325','55','Alberto de la Bella','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_73319_681_2010_2.jpg','26','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1326','55','Ieigo Martenez','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_158863_681_2010_1.jpg','20','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1327','55','Gorka Elustondo','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_47647_681_2010_2.jpg','24','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1328','55','Markel Bergara','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_51426_681_2010_2.jpg','25','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1329','55','Xabi Prieto','17',NULL,NULL,NULL,'7',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_15693_681_2010_2.jpg','28','186','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1330','55','Mikel Aranburu','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_7467_681_2010_2.jpg','32','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1331','55','Jeffrey Sarpong','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_35529_681_2010_2.jpg','23','175','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1332','55','David Zurutuza','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_59375_681_2010_2.jpg','25','186','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1333','55','McDonald Mariga','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_37124_681_2010_1.jpg','24','185','Kenya','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1334','55','Daniel Estrada','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_47648_681_2010_2.jpg','25','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1335','55','Antoine Griezmann','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_125781_681_2010_2.jpg','20','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1336','55','Joseba Llorente','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_7480_681_2010_2.jpg','32','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1337','55','Imanol Agirretxe','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37501_681_2010_2.jpg','24','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1338','55','Diego Ifren','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_76701_681_2010_3.jpg','24','174','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1339','55','Carlos Vela','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_35773_681_2010_1.jpg','22','177','Mexico','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1340','56','escar Ustari','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_3755_3709_2010_2.jpg','25','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1341','56','Jordi Codina','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_35462_3709_2010_1.jpg','29','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1342','56','Miguel engel Moye','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_26065_1049_2010_1.jpg','27','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1343','56','Pablo Pintos','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_76728_3709_2010_1.jpg','24','182','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1344','56','Cata Deaz','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_39087_3709_2010_1.jpg','32','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1345','56','Mane','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_51547_3709_2010_1.jpg','30','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1346','56','Miguel Torres','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45305_3709_2010_1.jpg','25','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1347','56','Alberto Lopo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_7881_897_2009_1.jpg','31','186','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1348','56','Michelangelo Albertazzi','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/t/l/s_56841_2007_1.jpg','21','185','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1349','56','Rafa','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_16315_3709_2010_1.jpg','26','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1350','56','Tsepo Masilela','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_63287_1064_2010_1.jpg','26','174','South Africa','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1351','56','Juan Valera','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_16595_13_2010_1.jpg','27','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1352','56','Mehdi Lacen','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_35539_630_2010_1.jpg','27','178','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1353','56','Pablo Sarabia','17',NULL,NULL,NULL,'6',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_74230_13711_2009_1.jpg','19','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1354','56','Jaime Gavilen','17',NULL,NULL,NULL,'7',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_15461_3709_2010_1.jpg','26','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1355','56','Pedro Mosquera','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_44069_3709_2010_1.jpg','23','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1356','56','Pedro Leen','17',NULL,NULL,NULL,'9',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_51587_418_2010_2.jpg','25','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1357','56','Pedro Reos','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_29187_3709_2010_1.jpg','30','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1358','56','Diego Castro','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_57791_2448_2010_1.jpg','29','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1359','56','Mechel','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_57818_2448_2009_1.jpg','26','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1360','56','Javier Casquero','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_7705_3709_2010_1.jpg','35','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1361','56','Juan Rodreguez','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_15983_897_2009_1.jpg','29','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1362','56','Ruben Perez','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_113045_897_2010_1.jpg','22','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1363','56','Abdelaziz Barrada','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/H/X/s_93664_8512_2009_1.jpg','22','185','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1364','56','Javier Arizmendi','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_25411_3709_2010_1.jpg','27','189','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1365','56','Miku','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_58001_3709_2010_1.jpg','26','185','Venezuela','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1366','56','Adrien Colunga','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_57866_3709_2010_1.jpg','27','172','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1367','56','Daniel Geiza','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_8186_36_2009_1.jpg','31','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1368','57','Juan Calatayud','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_15980_237_2010_1.jpg','32','190','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1369','57','Doudou Aouate','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_3495_237_2010_1.jpg','34','188','Israel','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1370','57','Edson Ramos','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_50778_585_2010_1.jpg','25','170','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1371','57','Gianni Zuiverloon','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_27304_237_2010_1.jpg','25','179','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1372','57','Ivan Ramis','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_26066_237_2010_1.jpg','27','189','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1373','57','Chico','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_51681_237_2010_1.jpg','24','187','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1374','57','Pablo Caceres','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_40790_237_2010_1.jpg','26','179','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1375','57','Nunes','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_14342_237_2010_1.jpg','34','185','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1376','57','Marte Crespe','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_58532_237_2010_1.jpg','24','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1377','57','Pau Cendres','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_73138_237_2010_1.jpg','24','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1378','57','Pedro Bigas','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_203043_8494_2010_1.jpg','21','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1379','57','Kevin','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_163654_237_2010_1.jpg','22','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1380','57','Jolo Victor','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_54996_237_2010_1.jpg','23','182','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1381','57','Tomes Pina','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_139895_237_2010_1.jpg','24','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1382','57','Michael Pereira','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_147483_237_2010_2.jpg','24','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1383','57','Chori Castro','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_28171_237_2010_1.jpg','27','177','Uruguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1384','57','Akihiro Ienaga','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_86167_237_2010_1.jpg','25','170','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1385','57','Josep Llues Marte','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_15955_237_2010_1.jpg','36','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1386','57','Fernando Tissone','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_35871_237_2010_1.jpg','25','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1387','57','Alejandro Alfaro','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_39783_237_2010_1.jpg','25','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1388','57','Sergio Tejera','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_38817_237_2010_1.jpg','21','179','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1389','57','Emilio Nsue','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_59558_237_2010_1.jpg','22','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1390','57','Marvin Ogunjimi','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_33870_1184_2010_3.jpg','24','186','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1391','57','Tomer Hemed','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_112668_237_2010_1.jpg','24','182','Israel','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1392','57','Vector Casadeses','16',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_35540_237_2010_1.jpg','26','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1393','57','Alvaro Gimonez','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/X/m/s_57935_1531_2008_1.jpg','20','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1394','58','David Cobeeo','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_37906_367_2010_2.jpg','29','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1395','58','Daniel Gimenez','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_71801_367_2010_2.jpg','28','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1396','58','Tito','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_128295_367_2010_2.jpg','26','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1397','58','Jose Manuel Casado','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_58774_367_2010_2.jpg','25','173','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1398','58','Mikel Labaka','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_23247_367_2010_1.jpg','31','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1399','58','Alejandro Arribas','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_137174_367_2010_2.jpg','22','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1400','58','Rael Bravo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3771_367_2010_1.jpg','30','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1401','58','Jordi Figueras','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_62941_367_2010_1.jpg','24','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1402','58','Sueliton Pereira','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_195604_367_2010_2.jpg','25','178','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1403','58','Rafa Garcea','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_126015_367_2010_2.jpg','26','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1404','58','Jose Movilla','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_7763_367_2010_2.jpg','36','171','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1405','58','Machel','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_8324_367_2010_2.jpg','36','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1406','58','Piti','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_58076_367_2010_2.jpg','30','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1407','58','Pedro Botelho','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_26239_367_2010_1.jpg','22','186','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1408','58','Roberto Trashorras','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_7923_367_2010_1.jpg','30','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1409','58','Javi Fuego','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_56134_367_2010_2.jpg','28','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1410','58','Michu','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_70789_367_2010_1.jpg','25','190','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1411','58','Dani Pacheco','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_28285_367_2010_1.jpg','21','168','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1412','58','Lass Bangoura','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','174','Guine','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1413','58','Raul Tamudo','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_7899_367_2010_1.jpg','34','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1414','58','Koke','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_16132_367_2010_1.jpg','28','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1415','58','Andrija Delibasic','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_10289_367_2010_1.jpg','30','187','Montenegro','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1416','59','Isaki Goitia','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_29050_150_2009_1.jpg','29','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1417','59','Casto','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_47722_150_2010_1.jpg','29','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1418','59','Fabri','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_45882_150_2010_1.jpg','24','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1419','59','Isidoro','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_48291_150_2010_1.jpg','25','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1420','59','Mario Alvarez','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_7803_150_2010_1.jpg','29','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1421','59','Antonio Amaya','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_71904_150_2010_1.jpg','28','192','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1422','59','Jose Antonio Dorado','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_70898_5358_2009_1.jpg','29','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1423','59','Ustaritz','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_35554_150_2010_1.jpg','28','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1424','59','Javi Chica','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_44860_150_2010_1.jpg','26','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1425','59','Nelson','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_17555_331_2010_3.jpg','28','172','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1426','59','Nacho','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_23287_150_2009_1.jpg','31','174','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1427','59','Miki Roque','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_33823_150_2010_1.jpg','23','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1428','59','Juanma','17',NULL,NULL,NULL,'5',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_23220_150_2010_2.jpg','30','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1429','59','Javier Matilla','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_73269_9567_2010_1.jpg','24','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1430','59','Benat Etxebarria','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_40888_150_2010_1.jpg','24','175','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1431','59','Momo','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_25319_150_2010_1.jpg','29','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1432','59','Salva Sevilla','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_58799_150_2010_2.jpg','27','178','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1433','59','Iriney','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_35515_150_2009_1.jpg','30','179','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1434','59','Jefferson Montero','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_77932_3368_2010_1.jpg','22','170','Ecuador','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1435','59','Jose Alberto Calas','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_69609_150_2010_1.jpg','24','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1436','59','Alvaro Vadillo','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_162074_14743_2010_1.jpg','17','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1437','59','Ezequiel','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_153739_12609_2010_1.jpg','21','169','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1438','59','Alejandro Pozuelo','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','20','170','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1439','59','Jonathan Pereira','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_53239_150_2010_1.jpg','24','167','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1440','59','Roque Santa Cruz','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_215_150_2010_1.jpg','30','188','Paraguay','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1441','59','Jorge Molina','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_57825_150_2010_1.jpg','29','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1442','59','Ruben Castro','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_25316_367_2009_1.jpg','30','168','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1443','60','Jose Juan Figueras','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_15499_16795_2010_4.jpg','32','183','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1444','60','Roberto Fernendez','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_57800_16795_2010_2.jpg','32','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1445','60','Allan Nyom','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_111508_16795_2010_4.jpg','23','188','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1446','60','Noe Pamarot','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_5531_16795_2010_1.jpg','32','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1447','60','Diego Maenz','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_58070_16795_2010_4.jpg','29','184','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1448','60','Guilherme Siqueira','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_44373_16795_2010_2.jpg','25','184','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1449','60','Inigo Lopez','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_75238_16795_2010_2.jpg','29','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1450','60','Pape Diakhate','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_28318_16795_2010_1.jpg','27','183','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1451','60','Jorge Ribeiro','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_17286_16795_2010_1.jpg','30','172','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1452','60','Manuel Lucena','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_72415_16795_2010_4.jpg','29','186','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1453','60','David Cortes','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_7671_16795_2010_1.jpg','32','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1454','60','Fran Rico','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_63689_16795_2010_2.jpg','24','177','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1455','60','Jaime Romero','17',NULL,NULL,NULL,'6',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_81998_16795_2010_1.jpg','21','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1456','60','Dani Benatez','17',NULL,NULL,NULL,'7',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_63695_16795_2010_3.jpg','24','181','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1457','60','Mikel Rico','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_51474_16795_2010_2.jpg','27','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1458','60','Carlos Martins','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_14511_16795_2010_1.jpg','29','172','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1459','60','Hassan Yebda','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s/k/s_12351_294_2009_1.jpg','27','187','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1460','60','Moises Hurtado','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_15764_16795_2010_1.jpg','30','185','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1461','60','Abel Gemez','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_29065_16795_2010_2.jpg','29','182','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1462','60','Richard Boateng','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_198400_16795_2010_1.jpg','19','178','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1463','60','Odion Ighalo','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_62121_16795_2010_3.jpg','22','188','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1464','60','Ikechukwu Uche','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_44027_16795_2010_1.jpg','28','175','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1465','60','Alex Geijo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_15981_16795_2010_2.jpg','29','188','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1466','60','Franco Jara','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_75035_294_2010_2.jpg','23','179','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1467','61','Mickael Landreau','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_3575_1082_2010_2.jpg','32','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1468','61','Vincent Enyeama','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_37760_1082_2010_1.jpg','29','182','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1469','61','Barel Mouko','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_31089_1082_2010_1.jpg','32','177','Congo','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1470','61','Alexandre Oukidja','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_56809_1082_2010_2.jpg','23','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1471','61','Mathieu Debuchy','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_27306_1082_2010_2.jpg','26','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1472','61','Lucas Digne','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_126664_1082_2010_1.jpg','18','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1473','61','Pape Souare','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_125868_1082_2010_2.jpg','21','178','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1474','61','Adama Soumaoro','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_126673_1082_2010_1.jpg','19','186','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1475','61','David Rozehnal','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_9659_1082_2010_2.jpg','31','191','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1476','61','Franck Beria','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12096_1082_2010_2.jpg','28','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1477','61','Laurent Bonnart','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_23898_1082_2010_1.jpg','32','171','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1478','61','Aurlien Chedjou','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45624_3434_2010_2.jpg','26','184','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1479','61','Marko Basa','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_17179_1082_2010_1.jpg','29','189','Montenegro','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1480','61','Florent Balmont','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5348_1082_2010_2.jpg','31','167','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1481','61','Idrissa Gueye','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_126665_1082_2010_2.jpg','22','174','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1482','61','Benoet Pedretti','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_5406_1082_2010_1.jpg','31','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1483','61','Rio Mavuba','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_14949_1082_2010_2.jpg','27','172','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1484','61','Joe Cole','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_3876_1082_2010_2.jpg','30','175','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1485','61','Jose Bosingwa','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_9813_631_2009_1.jpg','31','183','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1486','61','John Jairo Ruiz','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','18','174','Costa Rica','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('1487','61','Salomon Kalou','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_7971_631_2009_1.jpg','29','186','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1488','61','Florent Malouda','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_5461_631_2009_1.jpg','34','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1489','61','Dimitri Payet','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37647_1082_2010_1.jpg','24','174','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1490','61','Moussa Sow','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_22382_1082_2010_2.jpg','25','180','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1491','61','Telio de Melo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_22820_1082_2010_2.jpg','26','193','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1492','61','Gianni Bruno','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_95604_1082_2010_1.jpg','20','180','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1493','61','Ronny Rodelin','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_76055_1082_2010_1.jpg','22','192','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1494','61','Ireneusz Jelen','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_16951_1082_2010_1.jpg','30','184','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1495','62','Gennaro Bracigliano','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_28306_244_2010_1.jpg','31','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1496','62','Elinton Andrade','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_54703_244_2010_2.jpg','32','190','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1497','62','Steve Mandanda','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_23951_244_2010_2.jpg','26','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1498','62','Julien Rodriguez','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5292_244_2010_2.jpg','33','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1499','62','Nicolas Nkoulou','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_60577_244_2010_1.jpg','21','180','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1500','62','Djimi Traore','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_3598_244_2010_1.jpg','31','191','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1501','62','Jeremy Morel','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_23960_244_2010_1.jpg','27','173','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1502','62','Stephane Mbia','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_27470_244_2010_3.jpg','25','189','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1503','62','Souleymane Diawara','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12503_244_2010_3.jpg','33','187','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1504','62','Rod Fanni','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_5477_244_2010_3.jpg','30','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1505','62','Jean-Philippe Sabo','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_66947_244_2010_3.jpg','24','174','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1506','62','Alou Diarra','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_1327_244_2010_1.jpg','30','190','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1507','62','Benoet Cheyrou','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5645_244_2010_4.jpg','30','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1508','62','Lucho Gonzelez','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_26244_244_2010_3.jpg','30','185','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1509','62','Charles Kabore','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_57402_5872_2010_3.jpg','23','181','Burkina Faso','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1510','62','Morgan Amalfitano','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_39883_244_2010_1.jpg','26','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1511','62','Mathieu Valbuena','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_40687_244_2010_2.jpg','27','167','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1512','62','Brandeo','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_14948_210_2010_1.jpg','31','189','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1513','62','Andre-Pierre Gignac','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_43907_244_2010_3.jpg','26','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1514','62','Loec Remy','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45121_3377_2010_1.jpg','25','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1515','62','Andre Ayew','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45403_244_2010_3.jpg','22','176','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1516','62','Jordan Ayew','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_108354_244_2010_3.jpg','20','182','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1517','62','Billel Omrani','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_131589_244_2010_1.jpg','18','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1518','62','Chris Gadi','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_111046_244_2010_1.jpg','19','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1519','63','Mathieu Valverde','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_8540_1041_2010_1.jpg','28','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1520','63','Remy Vercoutre','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5338_1041_2010_2.jpg','31','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1521','63','Anthony Lopes','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_60561_1041_2010_1.jpg','21','184','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1522','63','Lamine Gassama','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_60539_3499_2010_1.jpg','22','181','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1523','63','Cris','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3165_1041_2010_2.jpg','34','183','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1524','63','Bakary Kone','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_57186_1041_2010_1.jpg','23','188','Burkina Faso','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1525','63','Dejan Lovren','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_37838_1041_2010_2.jpg','22','188','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1526','63','Timothoe Kolodziejczak','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_84085_1041_2010_1.jpg','20','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1527','63','Anthony Reveillere','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_5668_1041_2010_1.jpg','32','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1528','63','Mouhamadou Dabo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_33914_1041_2010_1.jpg','25','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1529','63','Aly Cissokho','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_57515_1041_2010_2.jpg','24','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1530','63','Samuel Umtiti','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_126540_1041_2010_1.jpg','18','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1531','63','John Mensah','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5917_1041_2010_1.jpg','29','180','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1532','63','Nicolas Seguin','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_60596_1041_2010_2.jpg','22','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1533','63','Sebastien Faure','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_80035_1041_2010_1.jpg','21','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1534','63','Thomas Fontaine','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_80036_1041_2010_1.jpg','20','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1535','63','Kim Kallstrem','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_3730_1041_2010_1.jpg','29','185','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1536','63','Clament Grenier','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_72479_1041_2010_2.jpg','21','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1537','63','Yoann Gourcuff','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_18912_1041_2010_2.jpg','25','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1538','63','Ederson','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_29035_1041_2010_2.jpg','26','181','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1539','63','Michel Bastos','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_12142_1041_2010_2.jpg','28','179','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1540','63','Gueoda Fofana','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_85863_1041_2010_1.jpg','20','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1541','63','Maxime Gonalons','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_60542_1041_2010_2.jpg','22','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1542','63','Sidy Kone','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_157166_1041_2010_1.jpg','19','185','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1543','63','Jaremy Pied','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_60583_1041_2010_2.jpg','22','173','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1544','63','Lisandro Lepez','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_27661_1041_2010_2.jpg','28','174','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1545','63','Alexandre Lacazette','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_93720_12764_2010_2.jpg','20','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1546','63','Bafetimbi Gomis','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_22388_1041_2010_2.jpg','26','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1547','63','Jimmy Briand','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_18909_1041_2010_3.jpg','26','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1548','63','Yannis Tafer','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_74075_1041_2010_1.jpg','20','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1549','63','Ishak Belfodil','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_111039_1041_2010_1.jpg','20','191','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1550','28','Alfonso Areola','18',NULL,'0','500000','0','0','1','https://s5o.ru/storage/simple/ru/edt/79/95/49/06/rue94fc4f9f4d.jpeg','25','195','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535453760','0');
INSERT INTO `fman_players` VALUES ('1551','64','Gianluigi Buffon','18',NULL,NULL,NULL,'1',NULL,'1','https://s5o.ru/storage/simple/ru/edt/67/95/07/28/rue14f1c9b9ac.png','40','192','Italy','6','6','6','2','0','0','1','1','0','1','1','1','5','604',NULL,'0');
INSERT INTO `fman_players` VALUES ('1552','64','Daniel Alves','18',NULL,NULL,NULL,'2',NULL,'2','https://s5o.ru/storage/simple/ru/edt/63/fa/81/80/rue2786e42b17.jpg','35','173','Brazil','6','6','6','5','1','1','1','1','1','1','1','2','0','1124',NULL,'0');
INSERT INTO `fman_players` VALUES ('1553','64','Thiago Silva','18',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_29241_5_2011_1.jpg','27','183','Brazil','6','6','6','4','0','1','2','1','1','2','2','2','0','1124',NULL,'0');
INSERT INTO `fman_players` VALUES ('1554','64','Layvin Kurzawa','18',NULL,NULL,NULL,'4',NULL,'4','https://s5o.ru/storage/simple/ru/edt/63/fa/81/80/rue2786e42b17.jpg','25','182','France','6','6','6','5','1','1','1','1','1','2','1','1','0','1124',NULL,'0');
INSERT INTO `fman_players` VALUES ('1555','64','Lassana Diarra','18',NULL,NULL,NULL,'3',NULL,'3','https://s5o.ru/storage/simple/ru/edt/74/12/19/55/rue443642d33a.jpeg','33','173','France','6','6','6','5','1','1','2','1','1','1','1','1','0','1124',NULL,'0');
INSERT INTO `fman_players` VALUES ('1556','64','Maxwell','18',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_4317_131_2010_2.jpg','30','177','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1557','64','Sylvain Armand','18',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3525_583_2010_3.jpg','31','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1558','64','Christophe Jallet','18',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_28335_583_2010_3.jpg','28','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1559','64','Jaremy Menez','18',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_16993_583_2010_2.jpg','24','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1560','64','Nene','18',NULL,NULL,NULL,'6',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_29091_583_2010_3.jpg','30','181','Brazil','6','6','6','5','1','1','1','1','1','1','2','1','0','1124',NULL,'34');
INSERT INTO `fman_players` VALUES ('1561','64','Mohamed Sissoko','18',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_6119_583_2010_5.jpg','26','187','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1562','64','Yohan Cabaye','18',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_29434_1082_2010_1.jpg','28','175','France','6','6','6','5','1','1','1','1','1','2','1','1','0','1124',NULL,'0');
INSERT INTO `fman_players` VALUES ('1563','64','Javier Pastore','18',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_55215_3437_2010_1.jpg','22','187','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1564','64','Edinson Cavani','18',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_48280_6195_2011_1.jpg','27','184','Uruguay','6','6','6','8','1','1','1','1','1','2','1','1','0','284',NULL,'39');
INSERT INTO `fman_players` VALUES ('1565','64','Angel Di Maria','18',NULL,NULL,NULL,'8',NULL,'8','https://s5o.ru/storage/simple/ru/edt/38/45/27/96/rue2e3787e4a1.jpeg','30','180','Argentina','6','6','6','8','1','1','2','1','1','1','1','1','0','284',NULL,'34');
INSERT INTO `fman_players` VALUES ('1566','64','Kylian Mbappe','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/e4/8a/77/e1/rue6c156a1465.jpg','19','178','France','6','6','6','8','1','1','1','1','1','2','1','1','0','284',NULL,'46');
INSERT INTO `fman_players` VALUES ('1567','64','Neymar Junior','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/06/1f/78/d4/rue71babd2175.png','26','175','Brazil','6','6','6','8','1','2','1','1','1','1','1','1','0','284',NULL,'57');
INSERT INTO `fman_players` VALUES ('1568','64','Jean-Christophe Bahebeck','18',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_164897_583_2010_2.jpg','18','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1569','65','Pierrick Cros','16',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_111043_750_2010_2.jpg','20','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1570','65','Teddy Richert','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5388_750_2010_2.jpg','37','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1571','65','Demba Camara','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_192540_750_2010_1.jpg','18','196','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1572','65','Sebastien Corchia','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_102744_750_2010_1.jpg','21','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1573','65','Yassin Mikari','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_2878_750_2010_2.jpg','29','172','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1574','65','Jaremie Brachet','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5339_750_2010_2.jpg','32','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1575','65','Steven Mouyokolo','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_58188_750_2010_1.jpg','24','190','Congo','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1576','65','David Sauget','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_19045_750_2010_2.jpg','32','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1577','65','Damien Perquis','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_31050_750_2010_2.jpg','27','183','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1578','65','Mathieu Peybernes','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_111026_750_2010_3.jpg','21','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1579','65','Carleo','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_52893_750_2010_2.jpg','25','182','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1580','65','Kevin Anin','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_57343_750_2010_2.jpg','25','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1581','65','Rafael Dias','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_127053_750_2010_2.jpg','20','180','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1582','65','Abdoul Camara','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_60588_750_2010_1.jpg','21','177','Guine','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1583','65','Ryad Boudebouz','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_77826_750_2010_2.jpg','21','177','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1584','65','Marvin Martin','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_77834_750_2010_2.jpg','24','171','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1585','65','Sabastien Roudet','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_17693_750_2010_1.jpg','30','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1586','65','Vincent Nogueira','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_56806_750_2010_2.jpg','23','170','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1587','65','Loec Poujol','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_109039_750_2010_2.jpg','22','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1588','65','Sloan Privat','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_66407_750_2010_1.jpg','22','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1589','65','Charlie Davies','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_46472_750_2010_1.jpg','25','178','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1590','65','Modibo Maega','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_46831_3674_2010_2.jpg','24','185','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1591','65','Edouard Butin','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_74684_750_2010_2.jpg','23','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1592','65','Cedric Bakambu','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_127048_750_2010_2.jpg','20','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1593','65','Serdar Gorler','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_98512_750_2010_2.jpg','20','173','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1594','66','Benoet Costil','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_22628_273_2010_1.jpg','24','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1595','66','Abdoulaye Diallo','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_126681_273_2010_2.jpg','19','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1596','66','Cheick N&#039;Diaye','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_34053_273_2010_1.jpg','26','191','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1597','66','Kevin Theophile-Catherine','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_60603_273_2010_2.jpg','22','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1598','66','Chris Mavinga','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_93732_273_2010_1.jpg','20','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1599','66','Onyekachi Apam','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_37460_273_2010_2.jpg','25','180','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1600','66','Kader Mangane','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_4796_273_2010_2.jpg','28','190','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1601','66','Jean-Armel Kana-Biyik','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_57404_273_2010_2.jpg','22','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1602','66','Yassine Jebbour','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_126692_23344_2010_1.jpg','20','180','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1603','66','Dimitri Foulquier','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_170472_273_2010_1.jpg','18','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1604','66','John Boye','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_85585_273_2010_2.jpg','24','184','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1605','66','Romain Danze','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_39906_273_2010_2.jpg','25','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1606','66','Alexander Tettey','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_12384_273_2010_2.jpg','25','180','Norway','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1607','66','Julien Faret','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_28328_273_2010_1.jpg','29','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1608','66','Staphane Dalmat','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_7259_273_2010_2.jpg','32','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1609','66','Georges Mandjeck','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_52112_273_2010_2.jpg','23','183','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1610','66','Yann M&#039;Vila','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_60573_273_2010_2.jpg','21','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1611','66','Yacine Brahimi','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_60517_273_2010_2.jpg','21','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1612','66','Kamal Issah','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_161327_273_2010_1.jpg','19','178','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1613','66','Vincent Pajot','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_126699_273_2010_1.jpg','21','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1614','66','Tongo Hamed Doumbia','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_103563_273_2010_2.jpg','22','192','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1615','66','Jonathan Pitroipa','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_19139_273_2010_1.jpg','25','176','Burkina Faso','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1616','66','Jiras Kembo-Ekoko','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_40446_273_2010_2.jpg','24','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1617','66','Razak Boukari','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_38536_273_2010_2.jpg','24','182','Togo','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1618','66','Youssouf Hadji','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5345_273_2010_1.jpg','31','183','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1619','66','Vector Montaeo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_18543_273_2010_2.jpg','27','177','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1620','67','Abdoulaye Keita','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_93716_10872_2010_2.jpg','21','188','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1621','67','Cedric Carrasso','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5308_40_2010_2.jpg','30','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1622','67','Kevin Olimpa','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_56807_40_2010_2.jpg','23','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1623','67','Azbe Jug','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_116918_40_2010_2.jpg','19','192','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1624','67','Mickael Ciani','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12906_40_2010_2.jpg','27','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1625','67','Henrique','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_33572_40_2010_2.jpg','28','189','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1626','67','Ludovic Sane','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_93758_40_2010_2.jpg','24','192','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1627','67','Vujadin Savic','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_68283_40_2010_2.jpg','21','193','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1628','67','Matthieu Chalme','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_5635_40_2010_2.jpg','31','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1629','67','Florian Marange','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_33942_40_2010_2.jpg','25','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1630','67','Mariano','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_54155_40_2010_1.jpg','25','177','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1631','67','Marc Planus','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12379_40_2010_2.jpg','29','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1632','67','Benoet Tremoulinas','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_43264_40_2010_2.jpg','26','173','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1633','67','Ludovic Obraniak','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_12106_1082_2010_2.jpg','27','174','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1634','67','Landry N&#039;Guemo','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_34372_40_2010_1.jpg','26','173','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1635','67','Fahid Ben Khalfallah','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_57355_40_2010_1.jpg','29','170','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1636','67','Jussie','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_20410_40_2010_2.jpg','28','181','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1637','67','Andre Biyogo Poko','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_170767_40_2010_1.jpg','19','173','Gabon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1638','67','Jaroslav Plasil','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_8885_40_2010_2.jpg','30','182','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1639','67','Nicolas Maurice-Belay','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_16591_40_2010_1.jpg','26','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1640','67','Abdou Traore','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_66415_40_2010_1.jpg','23','180','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1641','67','Gragory Sertic','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_81386_40_2010_1.jpg','22','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1642','67','Yoan Gouffran','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_23825_40_2010_2.jpg','25','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1643','67','David Bellion','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3115_40_2010_2.jpg','29','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1644','67','Cheick Diabati','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_78082_40_2010_2.jpg','23','194','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1645','67','Henri Saivet','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_51540_40_2010_2.jpg','21','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1646','67','Anthony Modeste','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_50512_40_2010_2.jpg','23','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1647','67','Emiliano Sala','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_190780_40_2010_1.jpg','21','187','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1648','68','Ramy Riou','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_18940_415_2010_1.jpg','24','191','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1649','68','Marc Vidal','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_123160_415_2010_1.jpg','20','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1650','68','Yohann Peli','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_6270_415_2010_1.jpg','29','196','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1651','68','Ali Ahamada','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_126767_415_2010_1.jpg','20','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1652','68','Mohamed Fofana','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_33905_415_2010_2.jpg','26','181','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1653','68','Daniel Congre','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_22386_415_2010_2.jpg','26','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1654','68','Jean-Daniel Akpa Akpro','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_170481_415_2010_1.jpg','19','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1655','68','Cheikh M&#039;Bengue','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_56795_3499_2010_1.jpg','23','182','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1656','68','Mickael Firmin','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_127247_415_2010_1.jpg','21','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1657','68','Aymen Abdennour','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_108830_415_2010_1.jpg','22','187','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1658','68','Pavle Ninkov','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_36039_415_2010_1.jpg','26','181','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1659','68','Paulo Machado','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_29039_415_2010_2.jpg','25','173','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1660','68','Antoine Devaux','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_57376_415_2010_2.jpg','26','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1661','68','Atienne Didot','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5672_415_2010_2.jpg','28','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1662','68','Franck Tabanou','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_66413_415_2010_1.jpg','22','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1663','68','Pantxi Sirieix','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_5431_415_2010_2.jpg','31','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1664','68','Adrien Regattin','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_126796_415_2010_1.jpg','20','166','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1665','68','Moussa Sissoko','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_46001_415_2010_1.jpg','22','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1666','68','Daniel Braaten','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_26407_415_2010_1.jpg','29','184','Norway','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1667','68','Wissam Ben Yedder','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_146854_415_2010_2.jpg','21','170','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1668','68','?tienne Capoue','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_63494_415_2010_2.jpg','23','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1669','68','Amadou Soukouna','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_105874_9371_2010_1.jpg','19','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1670','68','Umut Bulut','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_10143_415_2010_1.jpg','28','184','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1671','68','Emmanuel Rivire','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61637_415_2010_1.jpg','21','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1672','69','Subasic Danijel','18',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_28348_290_2010_2.jpg','29','191','Kroatien','6','6','6','0','2','0','0','0','0','0','0','0','9','55',NULL,'0');
INSERT INTO `fman_players` VALUES ('1673','0','Romero Sergio','18',NULL,'1','0','0','0','1','http://static.transfermarkt.net/bilder/mediumfotos/s_45106_290_2010_2.jpg','27','192','Argentinien','6','6','6','0','0','0','0','0','0','0','0','0','0','72','1535948460','0');
INSERT INTO `fman_players` VALUES ('1674','69','Codric Hengbart','18',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_22632_290_2010_2.jpg','31','183','France','6','6','6','0','0','0','0','4','3','0','2','0','0','572',NULL,'0');
INSERT INTO `fman_players` VALUES ('1675','69','Kurzawa','18',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','20','191','France','6','6','6','1','1','1','1','0','6','0','0','0','0','332',NULL,'0');
INSERT INTO `fman_players` VALUES ('1676','69','Stephane Grichting','18',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5419_290_2010_1.jpg','32','186','Switzerland','6','6','6','0','0','0','0','5','0','0','0','0','0','732',NULL,'0');
INSERT INTO `fman_players` VALUES ('1677','0','?ric Abidal','18',NULL,'1','0','0','0','3','http://static.transfermarkt.net/bilder/mediumfotos/s_5283_131_2010_2.jpg','32','186','France','6','6','6','0','0','0','0','0','1','0','0','0','0','32','1535949720','0');
INSERT INTO `fman_players` VALUES ('1678','0','Amadou Sidiba','18',NULL,'1','0','0','0','2','http://static.transfermarkt.net/bilder/mediumfotos/s_65670_290_2010_2.jpg','25','173','Mali','6','6','6','0','0','0','0','0','1','0','0','0','0','32','1535949720','0');
INSERT INTO `fman_players` VALUES ('1679','69','Jaremy Berthod','18',NULL,'0','10123456','2','0','2','http://static.transfermarkt.net/bilder/mediumfotos/s_12133_290_2010_2.jpg','27','180','France','6','6','6','2','2','1','0','0','7','0','0','0','0','0','1535689860','0');
INSERT INTO `fman_players` VALUES ('1680','69','Amara Kalle','18',NULL,'0','500000','0','0','3','http://static.transfermarkt.net/bilder/mediumfotos/s_122539_290_2010_2.jpg','21','184','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535689920','0');
INSERT INTO `fman_players` VALUES ('1681','0','Raphael Calvet','18',NULL,'1','0','0','0','3','http://static.transfermarkt.net/bilder/mediumfotos/s_157485_290_2010_1.jpg','17','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','72','1535949720','0');
INSERT INTO `fman_players` VALUES ('1682','69','Dariusz Dudka','18',NULL,NULL,NULL,'4',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_24502_290_2010_2.jpg','28','183','Poland','6','6','6','0','0','0','0','2','5','0','0','0','0','612',NULL,'0');
INSERT INTO `fman_players` VALUES ('1683','69','Kamel Chafni','18',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5399_290_2010_2.jpg','29','183','Morocco','6','6','6','1','1','1','0','6','0','0','0','0','0','340',NULL,'3');
INSERT INTO `fman_players` VALUES ('1684','69','Rudy Haddad','18',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_32198_290_2010_1.jpg','26','180','France','6','6','6','0','0','0','0','5','0','0','0','0','0','660',NULL,'0');
INSERT INTO `fman_players` VALUES ('1685','69','Christopher Missilou','18',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_111052_290_2010_1.jpg','19','180','France','6','6','6','0','0','0','0','6','0','0','0','0','0','486',NULL,'6');
INSERT INTO `fman_players` VALUES ('1686','69','?douard Cissa','18',NULL,'1','33000000','9','0','5','http://static.transfermarkt.net/bilder/mediumfotos/s_3800_290_2010_1.jpg','33','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535700960','2');
INSERT INTO `fman_players` VALUES ('1687','0','Prince Segbefia','18',NULL,'1','0','0','0','7','http://static.transfermarkt.net/bilder/mediumfotos/s_170919_290_2010_1.jpg','20','176','Togo','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535952355','0');
INSERT INTO `fman_players` VALUES ('1688','28','Omar Kossoko','18',NULL,'0','1000000','0','0','7','http://static.transfermarkt.net/bilder/mediumfotos/s_81548_290_2010_1.jpg','23','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535692080','0');
INSERT INTO `fman_players` VALUES ('1689','0','Vincent Acapandia','18',NULL,'1','0','0','0','8','http://static.transfermarkt.net/bilder/mediumfotos/s_134349_290_2010_1.jpg','21','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535700780','0');
INSERT INTO `fman_players` VALUES ('1690','0','Alain Traore','18',NULL,'1','0','0','0','6','http://static.transfermarkt.net/bilder/mediumfotos/s_43242_290_2010_2.jpg','23','176','Burkina Faso','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535952355','0');
INSERT INTO `fman_players` VALUES ('1691','0','Delvin Ndinga','18',NULL,'1','0','0','0','5','http://static.transfermarkt.net/bilder/mediumfotos/s_77835_290_2010_2.jpg','23','181','Congo','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535949720','0');
INSERT INTO `fman_players` VALUES ('1692','69','Souahilo Meita','18',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_164913_290_2010_1.jpg','17','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1693','0','Jolo Moutinho','18',NULL,'1','0','0','0','7','http://static.transfermarkt.net/bilder/mediumfotos/s_29364_720_2014_2.jpg','27','171','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535700900','0');
INSERT INTO `fman_players` VALUES ('1694','0','Kevin Chatelain','18',NULL,'1','0','0','0','7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','17','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535700960','0');
INSERT INTO `fman_players` VALUES ('1695','0','Ogou Akichi','18',NULL,'1','0','0','0','7','http://static.transfermarkt.net/bilder/mediumfotos/s_192714_290_2010_1.jpg','21','178','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535700900','0');
INSERT INTO `fman_players` VALUES ('1696','69','Anthony Le Tallec','18',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_4217_290_2010_3.jpg','27','184','France','6','6','6','0','0','0','0','5','0','1','0','3','0','380',NULL,'10');
INSERT INTO `fman_players` VALUES ('1697','69','Alexandre Licata','18',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37810_290_2009_1.jpg','28','178','France','6','6','6','0','0','0','0','4','0','0','4','4','0','60',NULL,'14');
INSERT INTO `fman_players` VALUES ('1698','0','Ben Sahar','18',NULL,'1','0','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_40436_290_2010_1.jpg','22','180','Israel','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535700660','0');
INSERT INTO `fman_players` VALUES ('1699','0','Dennis Oliech','18',NULL,'1','0','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_35748_290_2010_2.jpg','26','181','Kenya','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535700420','0');
INSERT INTO `fman_players` VALUES ('1700','69','Falcao','18',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_39152_3816_2010_1.jpg','25','177','Colombia','6','6','6','0','0','0','0','5','2','0','4','5','0','166',NULL,'10');
INSERT INTO `fman_players` VALUES ('1701','28','Yonathan del Valle','18',NULL,'0','500000','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_72643_290_2010_1.jpg','21','171','Venezuela','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535690640','0');
INSERT INTO `fman_players` VALUES ('1702','0','Geoffrey Kondogbia','18',NULL,'1','0','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','21','188','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535949900','0');
INSERT INTO `fman_players` VALUES ('1703','0','Roy Contout','18',NULL,'1','0','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_28987_290_2010_2.jpg','26','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535949900','0');
INSERT INTO `fman_players` VALUES ('1704','0','Yaya Sanogo','18',NULL,'1','0','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_127194_290_2010_1.jpg','18','191','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535949900','0');
INSERT INTO `fman_players` VALUES ('1705','0','Sebastien Haller','18',NULL,'1','0','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_181375_290_2010_1.jpg','17','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535949720','0');
INSERT INTO `fman_players` VALUES ('1706','0','Dieylani Fall','18',NULL,'1','0','0','0','10','http://static.transfermarkt.net/bilder/mediumfotos/s_150907_290_2010_1.jpg','22','190','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0','1535949720','0');
INSERT INTO `fman_players` VALUES ('1707','70','Stephane Ruffier','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_39910_618_2010_1.jpg','25','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1708','70','Jeremie Janot','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_17433_618_2010_2.jpg','34','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1709','70','Pape Coulibaly','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_77729_618_2010_2.jpg','23','192','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1710','70','Paulio','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_44700_618_2010_1.jpg','29','188','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1711','70','Sylvain Marchal','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12093_618_2010_2.jpg','31','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1712','70','Sylvain Monsoreau','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5393_618_2010_1.jpg','30','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1713','70','Jean-Pascal Mignot','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12275_618_2010_1.jpg','30','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1714','70','Faouzi Ghoulam','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_126656_618_2010_1.jpg','20','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1715','70','Yoann Andreu','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_92385_618_2010_2.jpg','22','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1716','70','Albin Ebondo','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_6978_618_2010_2.jpg','27','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1717','70','Loris Nery','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_126659_618_2010_2.jpg','20','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1718','70','Kurt Zouma','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_157509_618_2010_1.jpg','17','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1719','70','Alejandro Alonso','17',NULL,NULL,NULL,'5',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_33935_618_2010_2.jpg','29','172','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1720','70','Laurent Batlles','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5669_618_2010_2.jpg','36','174','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1721','70','Jeremy Clement','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_18901_618_2010_1.jpg','27','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1722','70','Fabien Lemoine','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_56794_618_2010_1.jpg','24','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1723','70','Josuha Guilavogui','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_93704_618_2010_2.jpg','21','192','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1724','70','Loec Perrin','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_22390_618_2010_2.jpg','26','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1725','70','Banel Nicolita','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_34758_618_2010_2.jpg','27','175','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1726','70','Bakary Sako','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_46791_618_2010_2.jpg','23','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1727','70','Max Gradel','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_28140_618_2010_1.jpg','24','180','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1728','70','Florent Sinama-Pongolle','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_4216_618_2010_1.jpg','27','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1729','70','Yoric Ravet','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_82461_618_2010_2.jpg','22','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1730','70','Boubacar Sanogo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_33245_618_2010_1.jpg','29','188','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1731','70','Lynel Kitambala','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_56789_618_2010_1.jpg','23','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1732','71','Benjamin Lecomte','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_127181_1158_2010_2.jpg','20','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1733','71','Fabien Audard','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5576_1158_2010_2.jpg','33','188','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1734','71','Florent Chaigneau','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_8498_1158_2010_1.jpg','27','197','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1735','71','Lamine Kone','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_57420_1158_2010_2.jpg','22','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1736','71','Pedrinho','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_24700_1158_2010_1.jpg','26','177','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1737','71','Bruno Ecuele Manga','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_60990_5704_2010_2.jpg','23','186','Gabon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1738','71','Gregory Bourillon','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12386_1158_2010_2.jpg','27','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1739','71','Lucas Mareque','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_39114_1158_2010_1.jpg','29','175','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1740','71','Arnaud Le Lan','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_5664_1158_2010_2.jpg','33','171','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1741','71','Maxime Baca','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_51030_1158_2010_2.jpg','28','174','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1742','71','Alaixys Romao','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_40014_3815_2010_2.jpg','27','180','Togo','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1743','71','Arnold Mvuemba','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_20622_1158_2010_2.jpg','26','172','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1744','71','Yann Jouffre','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_12508_1158_2010_2.jpg','27','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1745','71','Mathieu Coutadeur','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_39914_1158_2010_1.jpg','25','169','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1746','71','Sigamary Diarra','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_12502_1158_2010_2.jpg','28','176','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1747','71','Cheick Doukoure','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_129679_16662_2010_1.jpg','19','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1748','71','Mathias Autret','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_138171_1158_2010_2.jpg','20','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1749','71','Adama Toure','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_126649_1158_2010_1.jpg','20','185','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1750','71','Remi Mulumba','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_146099_1158_2010_2.jpg','19','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1751','71','Maxime Barthelme','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_112022_1158_2010_1.jpg','23','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1752','71','Innocent Emeghara','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_66022_1158_2010_1.jpg','22','170','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1753','71','Jeremie Aliadiere','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3266_1158_2010_1.jpg','28','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1754','71','Gilles Sunu','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_54933_1158_2010_2.jpg','20','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1755','71','Tristan Do','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_190789_1158_2010_1.jpg','18','170','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1756','71','Sebastien Dubarbier','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_55866_1158_2010_2.jpg','25','179','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1757','71','Kevin Monnet-Paquet','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_44045_1158_2010_2.jpg','23','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1758','71','Julien Quercia','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_36294_1158_2010_1.jpg','25','168','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1759','71','Fabien Robert','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_51369_1158_2010_2.jpg','23','174','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1760','71','Joel Campbell','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_131248_1158_2010_1.jpg','19','178','Costa Rica','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1761','72','Nicolas Penneteau','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5578_1423_2010_2.jpg','30','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1762','72','Jean-Louis Leca','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_27490_1423_2010_2.jpg','26','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1763','72','Arnaud Brocard','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_33818_1095_2010_1.jpg','25','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1764','72','David Ducourtioux','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_23918_1423_2010_2.jpg','33','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1765','72','Christopher Mfuyi','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_64632_3854_2010_1.jpg','22','184','Congo DR','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1766','72','Gil','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_101469_1423_2010_1.jpg','24','188','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1767','72','Rafael Schmitz','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5640_1423_2010_1.jpg','31','182','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1768','72','Mody Traore','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_43975_1423_2010_1.jpg','31','173','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1769','72','Nicolas Isimat-Mirin','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_147846_1423_2010_1.jpg','20','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1770','72','Benjamin Angoua','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_55046_3591_2010_2.jpg','25','183','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1771','72','Gaetan Bong','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_36291_1423_2010_2.jpg','23','183','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1772','72','Rudy Mater','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_43960_1423_2010_2.jpg','31','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1773','72','Dusan Djuric','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_30700_260_2010_2.jpg','27','181','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1774','72','Pape Camara','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_138410_3057_2010_1.jpg','20','190','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1775','72','Carlos Senchez','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_51226_1423_2010_2.jpg','25','182','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1776','72','Gael Danic','17',NULL,NULL,NULL,'8',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_5457_1423_2010_2.jpg','30','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1777','72','Mathieu Dossevi','17',NULL,NULL,NULL,'9',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_77828_1423_2010_2.jpg','23','172','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1778','72','Remi Gomis','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_51283_1423_2010_2.jpg','27','180','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1779','72','Foued Kadir','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_57403_1423_2010_2.jpg','28','180','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1780','72','Guillaume Loriot','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_38387_1423_2010_2.jpg','25','188','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1781','72','Jose Saez','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_5639_1423_2010_2.jpg','29','170','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1782','72','Renaud Cohade','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_18955_1423_2010_2.jpg','27','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1783','72','Vincent Aboubakar','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_147487_3434_2010_1.jpg','19','182','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1784','72','Mamadou Samassa','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_39917_1423_2010_3.jpg','25','188','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1785','72','Gregory Pujol','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5521_1423_2010_2.jpg','31','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1786','73','Guy Ndy Assembe','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_53306_1159_2010_1.jpg','25','184','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1787','73','Damien Gregorini','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5309_1159_2010_2.jpg','32','194','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1788','73','Remy Pillot','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_111027_1159_2010_2.jpg','21','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1789','73','Moustapha Bayal Sall','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_43886_618_2010_1.jpg','26','191','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1790','73','Helder','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_75096_1159_2010_1.jpg','23','175','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1791','73','Joel Sami','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45166_1159_2010_2.jpg','27','190','Congo DR','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1792','73','Jordan Lotias','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_49804_1159_2010_2.jpg','27','190','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1793','73','Andre Luiz','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_34361_1159_2010_2.jpg','31','185','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1794','73','Jean Calvu','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_35650_350_2010_1.jpg','27','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1795','73','Massadio Haidara','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_170929_1159_2010_2.jpg','19','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1796','73','Reynald Lemaetre','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_22635_1159_2010_2.jpg','28','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1797','73','Salif Sane','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_126534_1159_2010_1.jpg','21','195','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1798','73','Sebastien Puygrenier','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5667_162_2010_1.jpg','29','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1799','73','Thomas Mangani','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_18934_1159_2010_1.jpg','24','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1800','73','Aatif Chahechouhe','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_73480_1159_2010_2.jpg','25','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1801','73','Yohan Mollo','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_60570_16795_2010_1.jpg','22','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1802','73','Bakaye Traore','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_45168_1159_2010_1.jpg','26','185','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1803','73','Lossemy Karaboue','17',NULL,NULL,NULL,'9',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_60551_1159_2010_1.jpg','23','170','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1804','73','Samba Diakite','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_136589_1159_2010_2.jpg','22','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1805','73','Jonathan Brison','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_28307_1159_2010_2.jpg','28','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1806','73','Distel Zola','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_60613_1159_2010_2.jpg','22','184','Congo DR','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1807','73','Benjamin Moukandjo','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_59957_1159_2010_2.jpg','23','179','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1808','73','Benjamin Jeannot','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_111048_1159_2010_1.jpg','19','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1809','73','Djamel Bakar','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_49872_1159_2010_2.jpg','22','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1810','73','Jo-Gook Jung','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_90748_1159_2010_1.jpg','27','186','Korea, South','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1811','73','Daniel Niculae','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_34512_1159_2010_1.jpg','29','185','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1812','74','Laurent Pionnier','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5686_969_2010_2.jpg','29','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1813','74','Geoffrey Jourdren','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_23938_969_2010_2.jpg','25','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1814','74','Jonathan Ligali','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_127140_969_2010_2.jpg','20','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1815','74','Baptiste Valette','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_170509_969_2010_1.jpg','19','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1816','74','Garry Bocaly','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_38473_969_2010_2.jpg','23','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1817','74','Mapou Yanga-Mbiwa','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_57480_969_2010_1.jpg','22','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1818','74','Hilton','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_4811_969_2010_1.jpg','34','182','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1819','74','Henri Bedimo','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_6803_969_2010_1.jpg','27','180','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1820','74','Abdelhamid El Kaoutari','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_74615_3575_2010_1.jpg','21','185','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1821','74','Benjamin Stambouli','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_127160_9323_2010_1.jpg','21','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1822','74','Mathieu Deplagne','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_127128_969_2010_1.jpg','20','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1823','74','Cyril Jeunechamp','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5592_969_2010_2.jpg','36','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1824','74','Joris Marveaux','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_23955_969_2010_2.jpg','29','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1825','74','Younes Belhanda','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_118022_3575_2010_1.jpg','21','174','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1826','74','Gregory Lacombe','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_5730_969_2010_2.jpg','30','164','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1827','74','Marco Estrada','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_60885_3700_2010_2.jpg','28','177','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1828','74','Romain Pitau','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5539_969_2010_2.jpg','34','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1829','74','Jonathan Tinhan','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_120760_969_2010_1.jpg','22','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1830','74','Remy Cabella','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_113707_9323_2010_1.jpg','21','171','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1831','74','Jamel Saihi','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_57449_969_2010_2.jpg','24','181','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1832','74','John Utaka','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5495_969_2010_2.jpg','30','179','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1833','74','Hasan Kabze','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_29387_969_2010_2.jpg','29','185','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1834','74','Geoffrey Dernis','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_15275_969_2010_2.jpg','31','171','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1835','74','Olivier Giroud','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_82442_969_2010_2.jpg','25','192','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1836','74','Karim Aet-Fana','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_57337_3575_2010_1.jpg','22','175','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1837','74','Souleymane Camara','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5303_969_2010_4.jpg','29','170','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1838','74','Bengali-Fode Koita','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_79110_969_2010_2.jpg','21','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1839','75','Alexis Thebaux','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_22396_1162_2010_2.jpg','26','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1840','75','Damien Perquis','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_45247_1162_2010_2.jpg','25','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1841','75','Thomas Bosmel','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_118055_1162_2010_2.jpg','23','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1842','75','Molla Wague','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_129893_1162_2010_1.jpg','20','191','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1843','75','Thomas Heurtaux','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_109598_1162_2010_2.jpg','23','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1844','75','Branko Lazarevic','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_28686_1162_2010_2.jpg','27','185','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1845','75','Aurelien Montaroup','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_32766_1180_2011_1.jpg','26','173','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1846','75','Jerry Vandam','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_68902_1162_2010_2.jpg','23','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1847','75','Jeremy Sorbon','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_56820_1162_2010_2.jpg','28','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1848','75','Alexandre Raineau','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_56815_1162_2010_2.jpg','25','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1849','75','Gregory Leca','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_12105_1162_2010_2.jpg','31','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1850','75','Nicolas Seube','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_22642_1162_2010_2.jpg','32','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1851','75','Yannick M&#039;Bone','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_198474_1162_2010_1.jpg','18','185','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1852','75','Anthony Deroin','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_22629_1162_2010_3.jpg','32','163','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1853','75','Benjamin Nivet','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_33927_1162_2010_2.jpg','35','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1854','75','Gregory Proment','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_12107_1162_2010_1.jpg','33','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1855','75','Emeric Dudouit','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_170984_1162_2010_1.jpg','20','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1856','75','Frederic Bulot','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_111005_1162_2010_1.jpg','21','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1857','75','Romain Hamouma','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_98349_1162_2010_2.jpg','24','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1858','75','Ibrahima Tandia','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_127083_1162_2010_1.jpg','18','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1859','75','Faycal Fajr','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_174344_1162_2010_1.jpg','23','178','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1860','75','M&#039;Baye Niang','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_157501_1162_2010_1.jpg','17','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1861','75','Pierre-Alain Frau','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3901_1162_2010_1.jpg','31','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1862','75','Lenny Nangis','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_157500_1162_2010_2.jpg','17','174','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1863','75','Kandia Traore','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_38816_1162_2010_2.jpg','31','186','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1864','75','Livio Nabab','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_107548_1162_2010_2.jpg','23','185','Guadeloupe','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1865','76','Steeve Elana','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_17348_3911_2010_3.jpg','31','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1866','76','Lionel Cappone','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_31064_3911_2010_1.jpg','32','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1867','76','Joan Hartock','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_18673_3911_2010_1.jpg','24','190','Martinique','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1868','76','Tripy Makonda','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_90294_3911_2010_1.jpg','21','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1869','76','Johan Martial','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_105388_3911_2010_2.jpg','20','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1870','76','Jonathan Zebina','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_5942_3911_2010_1.jpg','33','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1871','76','Paul Baysse','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_43256_3911_2010_3.jpg','23','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1872','76','Santiago Gentiletti','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_30782_3911_2010_1.jpg','27','182','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1873','76','Moese Brou Apanga','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_81226_3911_2010_3.jpg','29','180','Gabon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1874','76','Brahim Ferradj','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_57383_3614_2010_1.jpg','24','172','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1875','76','Ousmane Coulibaly','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_92569_3911_2010_3.jpg','22','183','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1876','76','Ahmed Kantari','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_33447_3911_2010_3.jpg','26','185','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1877','76','Omar Daf','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3913_3911_2010_1.jpg','34','177','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1878','76','Gregory Lorenzi','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_15567_3911_2010_3.jpg','28','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1879','76','Abel Khaled','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1880','76','John Culma','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_96327_3911_2010_1.jpg','30','181','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1881','76','Oscar Ewolo','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_43906_3911_2010_3.jpg','33','171','Congo','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1882','76','Bruno Grougi','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_25113_3911_2010_3.jpg','28','171','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1883','76','Benoet Lesoimier','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_22636_3911_2010_3.jpg','28','173','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1884','76','Yoann Bigne','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_5670_3911_2010_3.jpg','34','168','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1885','76','Mario Licka','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_22053_3911_2010_3.jpg','29','182','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1886','76','Diallo Guidileye','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_66791_3911_2010_1.jpg','22','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1887','76','Jonathan Ayite','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_57349_3911_2010_1.jpg','26','184','Togo','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1888','76','Eden Ben Basat','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_24459_3911_2010_1.jpg','25','185','Israel','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1889','76','Larsen Toure','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37516_3911_2010_3.jpg','27','185','Guine','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1890','76','Tomas Micola','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_62789_3911_2010_2.jpg','23','178','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1891','76','Romain Poyet','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5440_3911_2010_3.jpg','31','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1892','76','Nolan Roux','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_81460_3911_2010_3.jpg','23','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1893','77','David Ospina','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_73396_417_2010_3.jpg','23','183','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1894','77','Raul Fernandez','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_82571_417_2010_2.jpg','26','185','Peru','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1895','77','Lucas Veronese','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_156489_8158_2010_1.jpg','20','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1896','77','Renato Civelli','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_30757_417_2010_3.jpg','28','195','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1897','77','Nemanja Pejcinovic','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_36881_417_2010_3.jpg','24','185','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1898','77','Kevin Gomis','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_89643_417_2010_2.jpg','22','186','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1899','77','Fabian Monzen','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_67084_3437_2010_1.jpg','24','178','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1900','77','Jonathan Quartey','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_77408_417_2010_1.jpg','23','186','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1901','77','Kevin Malaga','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_134350_417_2010_2.jpg','24','189','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1902','77','Drissa Diakite','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_37835_417_2010_4.jpg','26','175','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1903','77','Franeois Clerc','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_12134_417_2010_3.jpg','28','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1904','77','Didier Digard','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_52345_417_2010_3.jpg','25','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1905','77','Fabrice Abriel','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_40688_417_2010_2.jpg','32','176','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1906','77','David Hellebuyck','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_17429_417_2010_3.jpg','32','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1907','77','Camel Meriem','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_5376_417_2010_2.jpg','32','174','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1908','77','Emerse Fae','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_12392_417_2010_3.jpg','27','175','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1909','77','Kafoumba Coulibaly','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_66788_3591_2010_2.jpg','26','179','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1910','77','Lloyd Palun','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_165400_417_2010_2.jpg','23','184','Gabon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1911','77','Anthony Mounier','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_57110_417_2010_3.jpg','24','174','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1912','77','Julien Sable','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_17441_417_2010_3.jpg','31','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1913','77','Serge Nyuiadzi','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_131736_417_2010_1.jpg','20','178','Togo','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1914','77','Xavier Pentecete','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_33907_417_2010_2.jpg','25','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1915','77','?ric Mouloungui','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_12551_5704_2010_1.jpg','28','184','Gabon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1916','77','Franck Dja Djedje','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_18860_417_2010_2.jpg','25','176','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1917','77','Abraham Guie Gneki','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_55044_417_2010_2.jpg','25','180','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1918','77','Esmael Gonealves','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_173835_417_2010_2.jpg','20','182','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1919','78','Johann Durand','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_98356_14171_2010_2.jpg','30','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1920','78','Bertrand Laquait','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_12957_14171_2011_1.jpg','34','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1921','78','Stephan Andersen','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_17880_14171_2010_1.jpg','30','190','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1922','78','Quentin Westberg','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_33934_14171_2011_1.jpg','25','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1923','78','Guillaume Rippert','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_26328_14171_2011_1.jpg','26','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1924','78','Felipe Saad','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_57208_14171_2011_1.jpg','28','187','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1925','78','Sasa Cilinsek','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_28670_14171_2011_1.jpg','29','184','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1926','78','Aldo Angoula','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_57510_14171_2011_1.jpg','30','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1927','78','Cedric Mongongu','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_44417_14171_2010_1.jpg','22','189','Congo DR','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1928','78','Cedric Cambon','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_111283_14171_2011_1.jpg','25','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1929','78','Jonathan Mensah','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_110622_14171_2011_1.jpg','21','188','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1930','78','Brice Dja Djedje','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_93690_14171_2011_1.jpg','21','180','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1931','78','Fabrice Ehret','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_5627_14171_2011_1.jpg','32','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1932','78','Mohammed Rabiu','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_67721_14171_2011_1.jpg','22','187','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1933','78','Eric Tie Bi','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_60604_14171_2011_1.jpg','22','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1934','78','Jereme Leroy','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_5563_14171_2011_1.jpg','37','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1935','78','Thomas Kahlenberg','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_15052_82_2010_2.jpg','28','183','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1936','78','Christian Poulsen','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_1443_14171_2010_1.jpg','31','182','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1937','78','Cedric Barbosa','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_5698_14171_2011_1.jpg','35','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1938','78','Daniel Wass','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_63463_14171_2011_1.jpg','22','181','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1939','78','Guillaume Lacour','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_5622_14171_2010_2.jpg','31','173','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1940','78','Nicolas Farina','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_39921_14171_2011_1.jpg','25','168','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1941','78','Olivier Sorlin','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_5676_14171_2011_1.jpg','32','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1942','78','Ali M&#039;Madi','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_165351_14171_2011_1.jpg','21','178','Comoros','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1943','78','Sidney Govou','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_5357_14171_2011_1.jpg','32','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1944','78','Kevin Berigaud','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_98351_14171_2011_1.jpg','27','178','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1945','78','Herve Bugnet','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_14950_14171_2011_1.jpg','30','174','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1946','78','Yannick Sagbo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_60591_14171_2011_1.jpg','23','186','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1947','78','Youssef Adnane','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45254_14171_2011_1.jpg','26','178','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1948','78','Saber Khelifa','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_69101_14171_2011_1.jpg','25','183','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1949','79','Guillermo Ochoa','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_29559_1147_2010_1.jpg','26','183','Mexico','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1950','79','Thierry Debes','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_57373_1147_2010_2.jpg','38','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1951','79','David Oberhauser','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_130110_1147_2010_2.jpg','22','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1952','79','Leyti N&#039;Diaye','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_18894_1147_2010_1.jpg','26','188','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1953','79','Mickael Charvet','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_60521_1147_2010_1.jpg','23','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1954','79','Carl Medjani','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_8060_1147_2010_2.jpg','26','185','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1955','79','Yoann Poulard','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_6278_1147_2010_2.jpg','35','190','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1956','79','Anthony Lippini','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_73458_1147_2010_2.jpg','23','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1957','79','Fousseni Diawara','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_17422_1147_2010_2.jpg','31','182','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1958','79','Arnaud Maire','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45235_1147_2010_3.jpg','32','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1959','79','Samuel Bouhours','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_66386_1147_2010_1.jpg','24','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1960','79','Remi Cilia','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_84307_1147_2010_2.jpg','22','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1961','79','Benjamin Andre','17',NULL,NULL,NULL,'5',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_84301_1147_2010_2.jpg','21','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1962','79','Jean-Baptiste Pierazzi','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_44679_1147_2010_2.jpg','26','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1963','79','Christian Kinkela','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_16252_1147_2010_2.jpg','29','175','Congo DR','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1964','79','Karim El Hany','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_155755_1147_2010_2.jpg','24','170','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1965','79','Frederic Sammaritano','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_80173_1147_2010_1.jpg','25','162','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('1966','79','Fabrice Begeorgi','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_36911_1147_2010_2.jpg','24','175','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1967','79','Mehdi Mostefa','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_80191_1147_2010_1.jpg','28','181','Algeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1968','79','Johan Cavalli','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_44687_1147_2010_1.jpg','30','170','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1969','79','Paul Lasne','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_93726_1147_2010_2.jpg','22','186','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1970','79','Damien Tiberi','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_57213_1147_2010_1.jpg','26','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1971','79','Andy Delort','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_122797_1147_2010_2.jpg','20','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('1972','79','Richard Socrier','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_26799_1147_2010_2.jpg','32','186','Guadeloupe','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1973','79','Ilan','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_17244_1147_2010_1.jpg','31','183','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1974','79','Eduardo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3890_826_2010_2.jpg','31','178','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1975','80','Jean-Daniel Padovani','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_5524_2969_2010_4.jpg','31','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1976','80','Baba Tchagouni','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_132057_3815_2010_4.jpg','21','186','Togo','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1977','80','Baptiste Reynet','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_190786_2969_2010_2.jpg','21','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1978','80','Daniel Yeboah','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_15883_2969_2010_1.jpg','27','183','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1979','80','Zie Diabate','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_73980_312_2010_3.jpg','22','179','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1980','80','Abdoulaye Meete','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5315_2969_2010_2.jpg','31','185','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1981','80','Zakaria Diallo','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_137930_2969_2010_2.jpg','25','190','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1982','80','Chaher Zarour','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_111495_2969_2010_4.jpg','28','188','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1983','80','Abdoulaye Bamba','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_62351_2969_2010_2.jpg','21','182','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1984','80','Samuel Souprayen','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_60599_2969_2010_2.jpg','22','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1985','80','Steven Paulle','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_111492_2969_2010_4.jpg','25','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1986','80','Lesly Malouda','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_18265_2969_2010_4.jpg','28','172','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1987','80','Cedric Varrault','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5543_2969_2010_2.jpg','31','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1988','80','Gaol Kakuta','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_74297_355_2010_1.jpg','20','173','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1989','80','Younousse Sankhare','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_55409_2969_2010_3.jpg','22','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1990','80','Eric Bautheac','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_111482_2969_2010_4.jpg','24','169','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1991','80','Thomas Guerbert','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_185939_2969_2010_2.jpg','22','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1992','80','Hakeem Achour','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_126648_2969_2010_1.jpg','22','172','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('1993','80','Benjamin Corgnet','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_154171_2969_2010_4.jpg','24','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1994','80','Christopher Joufreau','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_187954_2969_2010_2.jpg','19','177','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1995','80','Sekou Baradji','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_23890_2969_2010_2.jpg','27','185','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1996','80','Sanaa Altama','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_126663_2969_2010_4.jpg','21','181','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1997','80','Daisuke Matsui','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_25905_2969_2010_2.jpg','30','175','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1998','80','Florin Berenguer','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_111040_2969_2010_4.jpg','22','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('1999','80','Damien Marcq','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_57534_2969_2010_2.jpg','23','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2000','80','Bennard Yao Kumordzi','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_36586_2969_2010_1.jpg','26','188','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2001','80','Koro Kona','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61005_2969_2010_1.jpg','22','178','Kot_D-Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2002','80','Brice Jovial','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_44895_2969_2010_2.jpg','27','172','Guadeloupe','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2003','80','Gregory Thil','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_57554_2969_2010_2.jpg','31','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2004','80','Mehdi Courgnaud','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_154172_2969_2010_5.jpg','21','182','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2005','81','Eric Oelschgael','18',NULL,NULL,NULL,'1',NULL,'1','https://s5o.ru/common/images/blank_icons/user.png','22','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','1170',NULL,'0');
INSERT INTO `fman_players` VALUES ('2006','81','Roman Burki','18',NULL,NULL,NULL,'0',NULL,'1','http://tmssl.akamaized.net//images/portrait/header/59027-1471508779.jpg','25','187','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','1134',NULL,'0');
INSERT INTO `fman_players` VALUES ('2007','81','Achraf Hakimi','18',NULL,NULL,NULL,'2',NULL,'2','https://s5o.ru/storage/simple/ru/edt/de/ca/e0/d8/rue21b1275f0b.png','19','179','Marocco','6','6','6','0','0','0','0','0','0','0','0','0','0','1170',NULL,'0');
INSERT INTO `fman_players` VALUES ('2008','81','Abdou Diallo','18',NULL,NULL,NULL,'3',NULL,'3','https://s5o.ru/storage/simple/ru/edt/05/35/49/58/rue45ae1a5345.jpg','22','187','France','6','6','6','0','0','0','0','0','0','0','0','0','0','1170',NULL,'0');
INSERT INTO `fman_players` VALUES ('2009','81','Matthias Ginter','18',NULL,NULL,NULL,'4',NULL,'4','http://akacdn.transfermarkt.de/images/portrait/medium/124502-1437469289.jpg','21','175','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','1170',NULL,'0');
INSERT INTO `fman_players` VALUES ('2010','81','Neven Subotic','18',NULL,NULL,NULL,'3',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/40995-1437469257.jpg','27','192','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','1134',NULL,'0');
INSERT INTO `fman_players` VALUES ('2011','81','Erik Durm','18',NULL,NULL,NULL,'4',NULL,'4','http://akacdn.transfermarkt.de/images/portrait/medium/93922-1437469316.jpg','21','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','1134',NULL,'0');
INSERT INTO `fman_players` VALUES ('2012','81','Lukasz Piszczek','18',NULL,NULL,NULL,'0',NULL,'4','http://tmssl.akamaized.net//images/portrait/header/25727-1471509758.jpg','31','184','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','1134',NULL,'0');
INSERT INTO `fman_players` VALUES ('2013','81','Manuel Akandzi','18',NULL,NULL,NULL,'6',NULL,'5','https://s5o.ru/storage/simple/ru/edt/63/ed/7b/eb/rue3b3c03ad6b.jpg','23','187','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','1170',NULL,'0');
INSERT INTO `fman_players` VALUES ('2014','81','Nuri Sahin','18',NULL,NULL,NULL,'8',NULL,'9','http://akacdn.transfermarkt.de/images/portrait/medium/31095-1437470232.jpg','25','188','Turcee','6','6','6','0','0','0','0','0','0','0','0','0','0','1170',NULL,'1');
INSERT INTO `fman_players` VALUES ('2015','81','Marcel Schmelzer','18',NULL,NULL,NULL,'0',NULL,'2','http://tmssl.akamaized.net//images/portrait/header/35208-1471509794.jpg','28','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','1134',NULL,'0');
INSERT INTO `fman_players` VALUES ('2016','81','Julian Weigl','18',NULL,NULL,NULL,'7',NULL,'5','https://s5o.ru/storage/simple/ru/edt/00/02/66/42/ruea0f62d9a69.png','22','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('2017','81','Rafael Guerreiro','18',NULL,NULL,NULL,'8',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/170986-1471508803.jpg','22','170','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('2018','81','Adnan Januzaj','18',NULL,NULL,NULL,'10',NULL,'10','http://akacdn.transfermarkt.de/bilder/spielerfotos/s_177847_9251_2013_10_21_1.jpg','20','187','Angola','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'2');
INSERT INTO `fman_players` VALUES ('2019','81','Adrian Ramos','18',NULL,NULL,NULL,'10',NULL,'10','http://akacdn.transfermarkt.de/images/portrait/medium/73782-1437470626.jpg','28','175','Cote Divoire','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'0');
INSERT INTO `fman_players` VALUES ('2020','81','Axel Witsel','18',NULL,NULL,NULL,'7',NULL,'7','https://s5o.ru/storage/simple/ru/edt/97/14/58/75/rueab3a2ec9d2.jpeg','29','186','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','36',NULL,'2');
INSERT INTO `fman_players` VALUES ('2021','81','Shinji Kagawa','18',NULL,NULL,NULL,'7',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/81785-1471508810.jpg','27','175','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2022','81','Christian Pulisich','18',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/f0/2c/2a/60/rue34b83e0a17.png','19','172','USA','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2023','81','Nuri Sahin','18',NULL,NULL,NULL,'0',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/31095-1471509788.jpg','28','180','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2024','81','Jakob Larssen','18',NULL,NULL,NULL,'0',NULL,'8','https://s5o.ru/common/images/blank_icons/user.png','19','178','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2025','81','Marco Reus','18',NULL,NULL,NULL,'10',NULL,'10','https://s5o.ru/storage/simple/ru/edt/44/52/51/10/ruecb815b4b16.jpeg','29','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2026','81','Christian Pulisic','18',NULL,NULL,NULL,'0',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/315779-1471509764.jpg','18','173','USA','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2027','81','Mario Gotze','18',NULL,NULL,NULL,'0',NULL,'9','http://tmssl.akamaized.net//images/portrait/header/74842-1471508796.jpg','24','176','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2028','81','Maximilian Phillip','18',NULL,NULL,NULL,'0',NULL,'10','https://s5o.ru/storage/simple/ru/edt/45/05/06/87/rue64c62e7879.jpg','24','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2029','82','David Yelldell','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_4746_52_2010_1.jpg','30','194','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'0');
INSERT INTO `fman_players` VALUES ('2030','82','Bernd Leno','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_72476_79_2010_1.jpg','19','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2031','82','Tin Jedvaj','17',NULL,NULL,NULL,'2',NULL,'3','http://akacdn.transfermarkt.de/images/portrait/medium/206386-1437466729.jpg','23','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'0');
INSERT INTO `fman_players` VALUES ('2032','82','Kyriakos Papadopoulos','17',NULL,NULL,NULL,'3',NULL,'3','http://akacdn.transfermarkt.de/images/portrait/medium/58489-1437468686.jpg','23','189','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'0');
INSERT INTO `fman_players` VALUES ('2033','82','Wendell','17',NULL,NULL,NULL,'3',NULL,'2','http://akacdn.transfermarkt.de/images/portrait/medium/228433-1437466802.jpg','23','184','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'0');
INSERT INTO `fman_players` VALUES ('2034','82','Giulio Donati','17',NULL,NULL,NULL,'0',NULL,'4','http://akacdn.transfermarkt.de/images/portrait/medium/88684-1437467935.jpg','32','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2035','82','Danny da Costa','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_85906_4713_2010_1.jpg','18','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2036','82','Omer Toprak','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_43512_60_2010_1.jpg','22','186','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2037','82','Simon Rolfes','17',NULL,NULL,NULL,'4',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_691_15_2010_1.jpg','29','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'0');
INSERT INTO `fman_players` VALUES ('2038','82','Christoph Kramer','17',NULL,NULL,NULL,'6',NULL,'9','http://akacdn.transfermarkt.de/images/portrait/medium/82097-1437391769.jpg','26','178','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'0');
INSERT INTO `fman_players` VALUES ('2039','82','Lars Bender','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_30059_15_2010_1.jpg','22','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'0');
INSERT INTO `fman_players` VALUES ('2040','82','Charles Aranguiz','17',NULL,NULL,NULL,'9',NULL,'9','http://akacdn.transfermarkt.de/images/portrait/medium/89701-1447748971.jpg','23','186','Chile','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'3');
INSERT INTO `fman_players` VALUES ('2041','82','Hakan Calhanoglu','17',NULL,NULL,NULL,'8',NULL,'9','http://akacdn.transfermarkt.de/images/portrait/medium/126414-1437468502.jpg','22','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'1');
INSERT INTO `fman_players` VALUES ('2042','82','Julian Brandt','17',NULL,NULL,NULL,'0',NULL,'9','http://akacdn.transfermarkt.de/images/portrait/medium/187492-1437480160.jpg','20','170','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2043','82','Kevin Kampl','17',NULL,NULL,NULL,'0',NULL,'9','http://akacdn.transfermarkt.de/images/portrait/medium/53418-1440674801.jpg','23','175','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2044','82','Karim Bellarabi','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_61087_23_2010_1.jpg','21','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2045','82','Stefan Kiessling','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/o/Z/s_6237_15_2009_1.jpg','27','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'5');
INSERT INTO `fman_players` VALUES ('2046','82','Chicharito','17',NULL,NULL,NULL,'10',NULL,'10','http://akacdn.transfermarkt.de/images/portrait/medium/50935-1413207208.jpg','23','191','Mexico','6','6','6','0','0','0','0','0','0','0','0','0','0','255',NULL,'4');
INSERT INTO `fman_players` VALUES ('2047','83','Manuel Neuer','18',NULL,NULL,NULL,'1',NULL,'1','http://tmssl.akamaized.net//images/portrait/header/17259-1471439886.JPG','30','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','5','1374',NULL,'0');
INSERT INTO `fman_players` VALUES ('2048','83','Sven Ulreich','18',NULL,NULL,NULL,'0',NULL,'1','https://s5o.ru/storage/simple/ru/edt/95/18/94/10/rueadea33bbf2.jpeg','30','192','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2049','83','Javi Martinez','18',NULL,NULL,NULL,'0',NULL,'7','http://akacdn.transfermarkt.de/images/portrait/medium/44017-1437471126.jpg','24','186','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2050','83','Juan Bernat','18',NULL,NULL,NULL,'4',NULL,'4','http://akacdn.transfermarkt.de/images/portrait/medium/126719-1437471905.jpg','23','197','Spain','6','6','6','0','0','0','0','6','6','0','0','0','0','894',NULL,'0');
INSERT INTO `fman_players` VALUES ('2051','83','Jerome Boateng','18',NULL,NULL,NULL,'3',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/26485-1471439420.JPG','28','192','Germany','6','6','6','0','0','0','0','6','6','0','0','0','0','894',NULL,'0');
INSERT INTO `fman_players` VALUES ('2052','83','Mats Hummels','18',NULL,NULL,NULL,'3',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/39728-1471439452.JPG','27','191','Germany','6','6','6','0','0','0','0','6','6','0','0','0','0','894',NULL,'0');
INSERT INTO `fman_players` VALUES ('2053','83','Holger Badstuber','18',NULL,NULL,NULL,'0',NULL,'3','http://tmssl.akamaized.net//images/portrait/header/54659-1471439391.JPG','27','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2054','83','Franck Ribery','18',NULL,NULL,NULL,'6',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_22068_27_2010_2.jpg','28','170','France','6','6','6','0','0','0','0','0','0','0','0','4','0','2012',NULL,'14');
INSERT INTO `fman_players` VALUES ('2055','83','Arjen Robben','18',NULL,NULL,NULL,'8',NULL,'8','http://tmssl.akamaized.net//images/portrait/header/4360-1471439903.JPG','32','180','Netherlands','6','6','6','0','0','0','0','6','6','0','0','0','0','894',NULL,'21');
INSERT INTO `fman_players` VALUES ('2056','83','David Alaba','18',NULL,NULL,NULL,'2',NULL,'2','http://tmssl.akamaized.net//images/portrait/header/59016-1471439227.JPG','24','180','Austria','6','6','6','0','0','0','0','6','6','0','0','0','0','894',NULL,'0');
INSERT INTO `fman_players` VALUES ('2057','83','Renato Sanches','18',NULL,NULL,NULL,'0',NULL,'7','https://s5o.ru/storage/simple/ru/edt/54/69/91/36/rue6302625728.png','21','176','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2058','83','James Rodriguez','18',NULL,NULL,NULL,'9',NULL,'9','https://s5o.ru/storage/simple/ru/edt/82/93/16/33/rue210fd45c48.jpeg','27','181','Colombia','6','6','6','0','0','0','0','6','0','0','0','6','0','894',NULL,'38');
INSERT INTO `fman_players` VALUES ('2059','83','Corentin Tolisso','18',NULL,NULL,NULL,'0',NULL,'8','https://s5o.ru/storage/simple/ru/edt/44/20/28/08/ruee60074618d.jpg','21','184','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2060','83','Leon Goretzka','18',NULL,NULL,NULL,'6',NULL,'6','https://s5o.ru/storage/simple/ru/edt/98/97/00/54/rueab0dce5828.jpeg','23','189','Germany','6','6','6','0','0','0','0','2','0','0','0','0','0','42',NULL,'3');
INSERT INTO `fman_players` VALUES ('2061','83','Kingsley Coman','18',NULL,NULL,NULL,'0',NULL,'7','http://akacdn.transfermarkt.de/images/portrait/medium/243714-1418291563.jpg','18','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2062','83','Rafinha','18',NULL,NULL,NULL,'5',NULL,'5','http://tmssl.akamaized.net//images/portrait/header/33947-1471439892.JPG','31','172','Brazil','6','6','6','0','0','0','0','6','6','0','0','0','0','894',NULL,'0');
INSERT INTO `fman_players` VALUES ('2063','83','Sandro Wagner','18',NULL,NULL,NULL,'0',NULL,'10','https://s5o.ru/storage/simple/ru/edt/48/55/72//rued4fb246516.jpeg','30','194','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2064','83','Thomas Muller','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/58358-1471439881.JPG','27','186','Germany','6','6','6','0','0','0','0','6','0','0','6','0','0','894',NULL,'49');
INSERT INTO `fman_players` VALUES ('2065','83','Robert Lewandowski','18',NULL,NULL,NULL,'10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/38253-1471439845.JPG','28','184','Poland','6','6','6','0','0','0','0','6','0','0','0','6','0','894',NULL,'42');
INSERT INTO `fman_players` VALUES ('2066','84','Ron-Robert Zieler','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_21327_42_2010_3.jpg','22','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2067','84','Markus Miller','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_2306__2011_1.jpg','29','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2068','84','Samuel Radlinger','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_77563__2011_1.jpg','19','196','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2069','84','Karim Haggui','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_17885__2011_1.jpg','27','190','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2070','84','Emanuel Pogatetz','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1094__2011_1.jpg','28','191','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2071','84','Mario Eggimann','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1587__2011_1.jpg','30','190','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2072','84','Steven Cherundolo','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_1335__2011_1.jpg','32','172','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2073','84','Christian Schulz','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1586_42_2010_3.jpg','28','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2074','84','Sofian Chahed','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_3816__2011_1.jpg','28','178','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2075','84','Christian Pander','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_2805__2011_1.jpg','28','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2076','84','Erdal Akdari','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_121271__2011_1.jpg','18','183','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2077','84','Christopher Avevor','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_94174__2011_1.jpg','19','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2078','84','Leon Andreasen','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_22837__2011_1.jpg','28','188','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2079','84','Sergio Pinto','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_277__2011_1.jpg','31','176','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2080','84','Altin Lala','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_902__2011_1.jpg','36','172','Albania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2081','84','Henning Hauger','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_41344__2011_1.jpg','26','179','Norway','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2082','84','Daniel Royer','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_74762_3383_2010_1.jpg','21','177','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('2083','84','Moritz Stoppelkamp','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_32845_42_2010_3.jpg','25','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2084','84','Carlitos','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_17352__2011_1.jpg','29','176','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2085','84','Deniz Aycicek','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_56097__2011_1.jpg','21','177','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2086','84','Lars Stindl','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_48298_42_2010_3.jpg','23','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2087','84','Jannis Pleschke','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_89660__2011_1.jpg','18','176','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2088','84','Manuel Schmiedebach','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_41507_42_2010_3.jpg','23','170','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2089','84','Konstantin Rausch','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_45668__2011_1.jpg','21','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2090','84','Artur Sobiech','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_75640_42_2010_1.jpg','21','185','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2091','84','Didier Ya Konan','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_39198_42_2010_3.jpg','27','174','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2092','84','Mame Biram Diouf','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_62049_687_2009_1.jpg','26','185','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2093','84','Jan Schlaudraff','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_3114__2011_1.jpg','28','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2094','84','Mohammed Abdellaoue','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61901_42_2011_1.jpg','26','182','Norway','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2095','85','Loris Karius','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_85864_39_2010_1.jpg','18','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2096','85','Christian Wetklo','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_1363_39_2010_2.jpg','32','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2097','85','Heinz Meller','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_892_39_2010_2.jpg','33','196','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2098','85','Bo Svensson','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_14974_39_2010_2.jpg','32','190','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2099','85','Zdenek Pospech','17',NULL,NULL,NULL,'3',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_21227_39_2010_1.jpg','33','174','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2100','85','Nikolce Noveski','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1139_39_2010_2.jpg','32','190','Macedonia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2101','85','Eugen Gopko','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_82354_39_2010_2.jpg','21','170','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2102','85','Radoslav Zabavnek','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_24856_39_2010_2.jpg','31','180','Slovakia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2103','85','Jan Kirchhoff','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_49734_39_2010_2.jpg','21','194','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2104','85','Malik Fathi','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_3817_39_2010_2.jpg','28','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2105','85','Niko Bungert','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_30070_39_2010_2.jpg','25','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2106','85','Fabian Schenheim','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_31652_39_2010_1.jpg','24','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2107','85','Marco Caligiuri','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_6287_39_2010_2.jpg','27','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2108','85','Eugen Polanski','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_19548_39_2010_2.jpg','25','183','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2109','85','Yunus Malli','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_85352_39_2010_1.jpg','19','179','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2110','85','Julian Baumgartlinger','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_34787_39_2010_1.jpg','24','183','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2111','85','Zoltan Stieber','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_61591_39_2010_1.jpg','23','175','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2112','85','Elkin Soto','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_40937_39_2010_2.jpg','31','178','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2113','85','Marcel Risse','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_51176_39_2010_2.jpg','22','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2114','85','Andreas Ivanschitz','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_2923_39_2010_2.jpg','28','184','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2115','85','Nicolai Meller','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_39426_39_2010_1.jpg','24','173','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2116','85','Sami Allagui','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_37013_39_2010_2.jpg','25','186','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'4');
INSERT INTO `fman_players` VALUES ('2117','85','Eric Maxim Choupo-Moting','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45660_3434_2010_1.jpg','22','189','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2118','85','Anthony Ujah','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_142281_39_2010_1.jpg','21','183','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2119','85','Mario Gavranovic','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61380_39_2010_1.jpg','22','175','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2120','85','adam Szalai','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_39106_39_2010_2.jpg','24','193','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2121','85','Deniz Yilmaz','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_34753_39_2010_1.jpg','23','182','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2122','86','Raphael Schefer','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_1150_4_2010_3.jpg','32','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2123','86','Patrick Rakovsky','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_85201_4_2010_2.jpg','18','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2124','86','Alexander Stephan','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_21345_4_2010_3.jpg','25','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2125','86','Benjamin Uphoff','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_120296_473_2010_1.jpg','18','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2126','86','Per Nilsson','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_18100_4_2010_3.jpg','29','190','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2127','86','Omar Gonzalez','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_99690_1061_2011_1.jpg','23','196','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2128','86','Dominic Maroh','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_41023_4_2010_3.jpg','24','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2129','86','Timm Klose','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_65255_4_2010_2.jpg','23','193','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2130','86','Juri Judt','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_31446_4_2010_3.jpg','25','173','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2131','86','Marvin Plattenhardt','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_89592_4_2010_1.jpg','19','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2132','86','Javier Pinola','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_7358_4_2010_3.jpg','28','180','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2133','86','Timothy Chandler','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_49723_4_2010_1.jpg','21','186','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2134','86','Philipp Wollscheid','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_53173_4_2010_3.jpg','22','194','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2135','86','Philipp Klement','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_60394_4_2010_1.jpg','19','176','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2136','86','Timmy Simons','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_3441_4_2010_3.jpg','35','186','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2137','86','Hanno Balitsch','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_823_15_2010_1.jpg','31','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2138','86','Markus Feulner','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_1986_4_2010_2.jpg','29','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2139','86','Jens Hegeler','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_51168_4_2010_3.jpg','23','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2140','86','Robert Mak','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_92180_24965_2010_1.jpg','20','179','Slovakia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2141','86','Mike Frantz','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_30942_4_2010_3.jpg','25','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2142','86','Almog Cohen','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_56711_4_2010_3.jpg','23','169','Israel','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2143','86','Daniel Didavi','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_57995_3817_2010_2.jpg','21','179','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2144','86','Adam Hlousek','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_62800_62_2011_1.jpg','23','188','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2145','86','Wilson Kamavuaka','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_55512_4_2010_2.jpg','21','188','Congo DR','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2146','86','Markus Mendler','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_120834_5710_2010_1.jpg','19','173','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2147','86','Manuel Zeitz','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_85960_4_2010_2.jpg','21','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2148','86','Julian Wiebmeier','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_93559_4_2010_2.jpg','19','171','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2149','86','Christian Eigler','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_4089_4_2010_3.jpg','28','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2150','86','Tomas Pekhart','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_38746_4_2010_2.jpg','22','194','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2151','86','Albert Bunjaku','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_19194_4_2010_3.jpg','28','178','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2152','86','Alexander Esswein','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45662_4_2010_2.jpg','21','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2153','87','Tobias Sippel','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_31653_2_2010_3.jpg','23','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2154','87','Marco Knaller','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_32216_2_2010_2.jpg','24','192','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2155','87','Kevin Trapp','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_45672_2_2010_3.jpg','21','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2156','87','Jan Simunek','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_56360_2_2010_3.jpg','24','189','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2157','87','Leon Jessen','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_22487_2_2010_3.jpg','25','182','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2158','87','Martin Amedick','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1323_2_2010_3.jpg','29','194','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2159','87','Mathias Abel','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1678_2_2010_3.jpg','30','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2160','87','Alexander Bugera','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_362_2_2010_3.jpg','33','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2161','87','Rodnei','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_58453_2_2010_3.jpg','26','190','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2162','87','Florian Dick','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_4979_2_2010_3.jpg','27','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2163','87','Lucas','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_143794_2_2010_3.jpg','20','194','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2164','87','Dominique Heintz','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_110036_2_2010_2.jpg','18','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2165','87','Willi Orban','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_93740_151_2010_1.jpg','19','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2166','87','Oliver Kirch','17',NULL,NULL,NULL,'5',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_2150_2_2010_3.jpg','29','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2167','87','Christian Tiffert','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_613_2_2010_3.jpg','29','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2168','87','Olcay Sahan','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_36200_2_2010_1.jpg','24','179','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2169','87','Thanos Petsos','17',NULL,NULL,NULL,'8',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_82110_2_2010_2.jpg','20','184','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2170','87','Gil Vermouth','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_44894_5547_2010_1.jpg','26','174','Israel','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2171','87','Clemens Walch','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_37831_2_2010_3.jpg','24','180','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2172','87','Jiri Bilek','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_25565_2_2010_3.jpg','28','183','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2173','87','Pierre de Wit','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_29971_2_2010_3.jpg','24','172','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2174','87','Stiven Rivic','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_20284_2_2010_3.jpg','26','181','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2175','87','Steven Zellner','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_60443_2_2010_1.jpg','20','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2176','87','Konstantinos Fortounis','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_157539_2_2010_1.jpg','19','183','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2177','87','Itay Shechter','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_44760_2_2010_1.jpg','24','178','Israel','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2178','87','Ilian Micanski','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_32597_2_2010_3.jpg','26','182','Bulgaria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2179','87','Richard Sukuta-Pasu','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_53455_2_2010_1.jpg','21','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2180','87','Nicolai Jorgensen','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_100399_15_2010_1.jpg','20','190','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2181','87','Dorge Kouemaha','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_29220_2_2010_1.jpg','28','188','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2182','87','Jakub Swierczok','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_193554_7976_2011_1.jpg','19','179','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2183','87','Adam Nemec','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_55210_3503_2010_1.jpg','26','190','Slovakia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2184','87','Julian-Maurice Derstroff','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_87650_2_2010_1.jpg','20','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2185','88','Jaroslav Drobny','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_12864_41_2010_2.jpg','32','192','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2186','88','Tom Mickel','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_44607_41_2010_1.jpg','22','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2187','88','Sven Neuhaus','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_1122_41_2010_1.jpg','33','194','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2188','88','Dennis Diekmeier','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_42044_41_2010_1.jpg','22','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2189','88','Michael Mancienne','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_38100_9565_2010_2.jpg','24','184','England','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2190','88','Heiko Westermann','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1726_41_2010_2.jpg','28','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2191','88','Jeffrey Bruma','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_88721_3379_2010_1.jpg','20','185','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2192','88','Dennis Aogo','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_19354_41_2010_2.jpg','25','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2193','88','Lennard Sowah','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_74124_389_2010_1.jpg','19','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2194','88','Slobodan Rajkovic','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_35934_41_2010_1.jpg','22','191','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2195','88','Miroslav Stepanek','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45144_389_2010_1.jpg','21','192','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2196','88','Muhamed Besic','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_93905_41_2010_3.jpg','19','180','Bosnia-Herzegovina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2197','88','Janek Sternberg','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_89542_41_2010_2.jpg','19','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2198','88','Marcell Jansen','17',NULL,NULL,NULL,'5',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_16624_41_2010_2.jpg','26','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2199','88','Tomas Rinc?n','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_75942_3504_2010_1.jpg','24','175','Venezuela','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2200','88','Ivo Ilicevic','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_30308_41_2010_1.jpg','25','174','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2201','88','Robert Tesche','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_41458_41_2010_2.jpg','24','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2202','88','David Jarolem','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_773_41_2010_2.jpg','32','174','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2203','88','Gokhan Tere','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_82130_41_2010_2.jpg','19','176','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2204','88','Romeo Castelen','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_6764_41_2010_2.jpg','28','170','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2205','88','Jacopo Sala','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_96806_41_2010_1.jpg','20','183','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2206','88','Per Ciljan Skjelbred','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_18918_41_2010_1.jpg','24','175','Norway','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2207','88','Soren Bertram','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_76143_5709_2010_1.jpg','20','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2208','88','Tolgay Arslan','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_53536_41_2010_1.jpg','21','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2209','88','Daniel Nagy','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_69377_41_2010_2.jpg','20','181','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2210','88','Kevin Ingreso','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_89653_41_2010_2.jpg','18','178','Philippines','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2211','88','Zhi Gin Lam','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_69396_389_2010_2.jpg','20','175','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2212','88','Micka?l Tavares','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_45139_41_2010_1.jpg','29','185','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2213','88','Gojko Kacar','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_28683_41_2010_2.jpg','24','185','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2214','88','Paolo Guerrero','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_2989_41_2010_2.jpg','28','185','Peru','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2215','88','Mladen Petric','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_2874_41_2010_2.jpg','31','184','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2216','88','Heung-Min Son','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_91845_41_2010_2.jpg','19','183','Korea, South','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2217','88','Marcus Berg','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_30418_41_2010_1.jpg','25','184','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2218','89','Oliver Baumann','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_55089_60_2010_1.jpg','21','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2219','89','Daniel Batz','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_90317_60_2010_1.jpg','21','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2220','89','Alexander Schwolow','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_93763_5709_2010_1.jpg','19','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2221','89','Fallou Diagne','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_82389_347_2010_2.jpg','22','185','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2222','89','Pavel Krmas','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_9697_60_2010_2.jpg','31','193','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2223','89','Felix Bastians','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_39083_60_2010_2.jpg','23','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2224','89','Beg Ferati','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_53808_60_2010_1.jpg','25','188','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2225','89','Oliver Barth','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1811_60_2010_2.jpg','32','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2226','89','Andreas Hinkel','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_599_515_2010_1.jpg','29','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2227','89','Mensur Mujdza','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_27900_3446_2010_1.jpg','27','185','Bosnia-Herzegovina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2228','89','Cadric Makiadi','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_14882_60_2010_2.jpg','27','177','Congo DR','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2229','89','Jan Rosenthal','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_31173_60_2010_2.jpg','25','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2230','89','Maximilian Nicu','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_2345_60_2010_2.jpg','29','185','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2231','89','Anton Putsila','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_59491_3450_2010_2.jpg','24','180','Belarus','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2232','89','Jonathan Schmid','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_70285_60_2010_1.jpg','21','179','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2233','89','Johannes Flum','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_38415_60_2010_3.jpg','24','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2234','89','Julian Schuster','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_29865_60_2010_2.jpg','26','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2235','89','Christian Bickel','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_83415_5709_2010_1.jpg','20','178','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2236','89','Daniel Caligiuri','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_38410_60_2010_2.jpg','23','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2237','89','Papiss Demba Ciss?','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_33952_60_2010_2.jpg','26','183','Senegal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2238','89','Garra Dembalo','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61375_3674_2010_1.jpg','25','187','Mali','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2239','89','Kisho Yano','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_61900_60_2010_2.jpg','27','185','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2240','89','Erik Jendrisek','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_41369_60_2010_2.jpg','25','176','Slovakia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2241','89','Stefan Reisinger','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_1568_60_2010_2.jpg','30','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2242','89','Simon Brandstetter','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_57977_60_2010_1.jpg','21','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2243','90','Michael Rensing','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_2421_3_2010_1.jpg','27','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2244','90','Miro Varvodic','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_45841_3_2010_2.jpg','22','191','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2245','90','Daniel Schwabke','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_52861_3_2010_1.jpg','22','192','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2246','90','Timo Horn','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_84938_3_2010_1.jpg','18','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2247','90','Miso Brecko','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_15300_3_2010_1.jpg','27','178','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2248','90','Ammar Jemal','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_66319_452_2010_2.jpg','24','185','Tunisia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2249','90','Christian Eichner','17',NULL,NULL,NULL,'4',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_10893_3_2010_1.jpg','29','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2250','90','Andrazinho','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_56200_3_2010_1.jpg','30','173','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2251','90','Henrique Sereno','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_48931_720_2010_1.jpg','26','187','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2252','90','Geromel','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_32568_3_2010_2.jpg','26','190','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2253','90','Kevin McKenna','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_177_3_2010_2.jpg','31','189','Canada','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2254','90','Sascha Riether','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_1662_82_2010_1.jpg','28','174','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2255','90','Kevin Pezzoni','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_42739_3_2010_2.jpg','22','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2256','90','Petit','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_13917_3_2010_2.jpg','35','178','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2257','90','Martin Lanig','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_3942_3_2010_2.jpg','27','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2258','90','Slawomir Peszko','17',NULL,NULL,NULL,'9',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_16956_3_2010_1.jpg','26','172','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2259','90','Mato Jajalo','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_47513_1387_2010_1.jpg','23','182','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2260','90','Adil Chihi','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_28907_3_2010_2.jpg','23','183','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2261','90','Adam Matuschyk','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_52830_3_2010_2.jpg','22','183','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2262','90','Odise Roshi','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_99003_3_2010_1.jpg','20','187','Albania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2263','90','Christopher Buchtmann','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_72094_438_2010_1.jpg','19','175','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2264','90','Sebastian Freis','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_25468_3_2010_2.jpg','26','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2265','90','Lukas Podolski','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_15185_3_2010_1.jpg','26','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2266','90','Milivoje Novakovic','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_16162_3_2010_1.jpg','32','192','Slovenia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2267','90','Mikael Ishak','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_153637_4380_2010_1.jpg','18','183','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2268','90','Christian Clemens','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_44713_3_2010_3.jpg','20','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2269','90','Mark Uth','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_112935_3_2010_1.jpg','20','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2270','90','Thiemo-Jereme Kialka','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_47290_3_2010_1.jpg','23','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2271','91','Daniel Haas','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_1464_533_2010_2.jpg','28','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2272','91','Koen Casteels','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_108880_983_2010_1.jpg','19','196','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2273','91','Tom Starke','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_80_533_2010_2.jpg','30','194','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2274','91','Andreas Beck','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_31182_533_2010_2.jpg','24','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2275','91','Matthias Jaissle','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_40673_533_2010_1.jpg','23','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2276','91','Stefan Thesker','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','20','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2277','91','Marvin Compper','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_9340_533_2010_2.jpg','26','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2278','91','Fabian Johnson','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_31041_533_2010_1.jpg','24','183','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2279','91','Isaac Vorsah','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_52151_3441_2010_1.jpg','23','192','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2280','91','Andreas Ibertsberger','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_2970_533_2010_2.jpg','29','178','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2281','91','Edson Braafheid','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_16731_533_2010_4.jpg','28','176','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2282','91','Jannik Vestergaard','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_99331_20902_2010_1.jpg','19','197','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2283','91','Manuel Gulde','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45683_533_2010_2.jpg','20','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2284','91','Sebastian Rudy','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_57051_533_2010_2.jpg','21','179','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2285','91','Boris Vukcevic','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_58163_533_2010_2.jpg','21','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2286','91','Daniel Williams','17',NULL,NULL,NULL,'7',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_38383_533_2010_1.jpg','22','182','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2287','91','Tobias Weis','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_20444_533_2010_2.jpg','26','170','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2288','91','Dominik Kaiser','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_52200_533_2010_1.jpg','23','170','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2289','91','Roberto Firmino','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_131789_533_2010_2.jpg','20','181','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2290','91','Sejad Salihovic','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_9354_533_2010_2.jpg','27','182','Bosnia-Herzegovina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2291','91','Sandro Wieser','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_130227_26_2010_1.jpg','18','185','Liechtenstein','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2292','91','Wellington','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_67207_3197_2010_1.jpg','23','186','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('2293','91','Knowledge Musona','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_120785_3583_2010_2.jpg','21','174','Zimbabwe','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2294','91','Sven Schipplock','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_52530_533_2010_1.jpg','23','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2295','91','Ryan Babel','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_16135_533_2010_2.jpg','25','185','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2296','91','Peniel Mlapa','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_70280_533_2010_2.jpg','20','195','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2297','91','Vedad Ibisevic','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_21175_533_2010_2.jpg','27','188','Bosnia-Herzegovina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2298','91','Denis Thomalla','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_94030_533_2010_1.jpg','19','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2299','92','Sven Ulreich','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_40680_79_2010_2.jpg','23','192','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2300','92','Marc Ziegler','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_162_79_2010_2.jpg','35','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2301','92','Gotoku Sakai','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_103310_8344_2010_1.jpg','20','176','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2302','92','Cristian Molinaro','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_21972_79_2010_2.jpg','28','182','Italy','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2303','92','Serdar Tasci','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_34593_79_2010_1.jpg','24','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2304','92','Georg Niedermeier','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_31570_79_2010_1.jpg','25','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2305','92','Maza','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_28163_79_2010_1.jpg','30','191','Mexico','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2306','92','Arthur Boka','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_13038_79_2010_2.jpg','28','166','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2307','92','Matthieu Delpierre','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_5636_79_2010_1.jpg','30','193','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2308','92','Khalid Boulahrouz','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_4489_79_2010_1.jpg','30','183','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2309','92','Stefano Celozzi','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_33729_79_2010_2.jpg','23','171','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2310','92','Patrick Bauer','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_94603_79_2010_1.jpg','19','192','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2311','92','William Kvist','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_36787_79_2010_1.jpg','26','184','Denmark','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2312','92','Zdravko Kuzmanovic','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_25441_3438_2010_1.jpg','24','185','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2313','92','Johan Audel','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_5544_79_2010_1.jpg','28','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2314','92','Timo Gebhart','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_42463_79_2010_1.jpg','22','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2315','92','Ibrahima Traore','17',NULL,NULL,NULL,'9',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_47285_3856_2010_1.jpg','23','172','Guine','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2316','92','Christian Gentner','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_19112_79_2010_2.jpg','26','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2317','92','Mamadou Bah','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_51282_79_2010_1.jpg','23','182','Guine','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2318','92','Tamos Hajnal','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_264_79_2010_1.jpg','30','168','Hungary','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2319','92','Martin Harnik','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_31159_79_2010_4.jpg','24','185','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('2320','92','Cacau','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_1426_79_2010_1.jpg','30','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2321','92','Julian Schieber','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_58124_79_2010_1.jpg','22','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2322','92','Pavel Pogrebnyak','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_15074_79_2010_1.jpg','28','188','Russia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2323','92','Shinji Okazaki','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_79642_79_2010_1.jpg','25','174','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2324','92','Christoph Hemlein','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_58030_79_2010_1.jpg','21','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2325','93','Tim Wiese','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_1474_86_2010_1.jpg','30','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2326','93','Sebastian Mielitz','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_42079_86_2010_2.jpg','22','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2327','93','Christian Vander','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_643_86_2010_2.jpg','31','195','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2328','93','Sebastian Boenisch','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_36914_86_2010_1.jpg','24','191','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2329','93','Naldo','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_32213_86_2010_2.jpg','29','198','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2330','93','Clemens Fritz','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_1277_86_2010_2.jpg','31','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2331','93','Lukas Schmitz','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_49867_86_2010_1.jpg','23','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2332','93','Sebastian Predl','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_37981_86_2010_2.jpg','24','194','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2333','93','Mika?l Silvestre','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_3393_86_2010_2.jpg','34','183','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2334','93','Sokratis','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_34322_86_2010_1.jpg','23','183','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2335','93','Andreas Wolf','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1572_86_2010_1.jpg','29','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2336','93','Florian Hartherz','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_93571_86_2010_1.jpg','18','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2337','93','Leon-Aderemi Balogun','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_56100_87_2010_3.jpg','23','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2338','93','Clemens Schoppenhauer','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_89522_87_2010_2.jpg','19','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2339','93','Wesley','17',NULL,NULL,NULL,'5',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_52929_86_2010_2.jpg','24','177','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2340','93','Tim Borowski','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_692_86_2010_2.jpg','31','194','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2341','93','Marko Marin','17',NULL,NULL,NULL,'7',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_35251_86_2010_2.jpg','22','170','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2342','93','Aaron Hunt','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_4687_86_2010_2.jpg','25','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2343','93','Aleksandar Ignjovski','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_74295_9566_2010_1.jpg','20','175','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2344','93','Felix Kroos','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_31910_86_2010_3.jpg','20','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2345','93','Mehmet Ekici','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_39724_86_2010_1.jpg','21','180','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2346','93','Tom Trybull','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_93831_86_2010_3.jpg','18','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2347','93','Predrag Stevanovic','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_68649_87_2010_1.jpg','20','178','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2348','93','Ozkan Yildirim','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_83256_86_2010_2.jpg','18','172','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2349','93','Aleksandar Stevanovic','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_86895_86_2010_2.jpg','19','175','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2350','93','Florian Trinks','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_64248_87_2010_2.jpg','19','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2351','93','Philipp Bargfrede','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_42033_86_2010_1.jpg','22','176','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2352','93','Marko Arnautovic','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_41384_86_2010_2.jpg','22','192','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2353','93','Denni Avdic','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_41511_86_2010_2.jpg','23','192','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2354','93','Markus Rosenberg','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_27505_86_2010_3.jpg','29','185','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2355','93','Sandro Wagner','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_39743_86_2010_2.jpg','24','194','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2356','93','Claudio Pizarro','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_532_86_2010_2.jpg','33','186','Peru','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2357','93','Lennart Thy','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_23553_86_2010_1.jpg','19','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2358','93','Onur Ayik','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_52006_86_2010_3.jpg','21','183','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2359','94','Ralf Fehrmann','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_39015_33_2010_1.jpg','23','196','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','323',NULL,'0');
INSERT INTO `fman_players` VALUES ('2360','94','Mathias Schober','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_322_33_2010_2.jpg','35','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2361','94','Timo Hildebrand','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_598_336_2010_1.jpg','32','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2362','94','Lars Unnerstall','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_53696_33_2010_2.jpg','21','198','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2363','94','Hans Sarpei','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_707_33_2010_1.jpg','35','178','Ghana','6','6','6','0','0','0','0','0','0','0','0','0','0','323',NULL,'0');
INSERT INTO `fman_players` VALUES ('2364','94','Sergio Escudero','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/v/s/s_93935_171_2009_1.jpg','22','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','323',NULL,'0');
INSERT INTO `fman_players` VALUES ('2365','94','Benedikt Hewedes','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_39020_33_2010_1.jpg','23','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','323',NULL,'0');
INSERT INTO `fman_players` VALUES ('2366','94','Tim Hoogland','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_18833_33_2010_2.jpg','26','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2367','94','Marco Heger','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_55510_33_2010_1.jpg','22','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2368','94','Kyriakos Papadopoulos','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_58489_33_2010_2.jpg','19','183','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2369','94','Christoph Metzelder','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_123_33_2010_2.jpg','31','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2370','94','Atsuto Uchida','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_27800_33_2010_2.jpg','23','176','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','272',NULL,'0');
INSERT INTO `fman_players` VALUES ('2371','94','Christian Fuchs','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_6636_3383_2010_2.jpg','25','186','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2372','94','Joel Matip','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_82105_33_2010_2.jpg','20','193','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2373','94','Lewis Holtby','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_55508_33_2010_1.jpg','21','176','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','51',NULL,'0');
INSERT INTO `fman_players` VALUES ('2374','94','Alexander Baumjohann','17',NULL,NULL,NULL,'6',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_16474_33_2010_2.jpg','24','178','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','323',NULL,'1');
INSERT INTO `fman_players` VALUES ('2375','94','Jermaine Jones','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_1321_33_2010_1.jpg','30','183','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','323',NULL,'0');
INSERT INTO `fman_players` VALUES ('2376','94','Jose Manuel Jurado','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_28261_33_2010_1.jpg','25','176','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','323',NULL,'2');
INSERT INTO `fman_players` VALUES ('2377','94','Rafael van der Vaart','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_4192_418_2009_2.jpg','31','176','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','323',NULL,'2');
INSERT INTO `fman_players` VALUES ('2378','94','Peer Kluge','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_1095_33_2010_2.jpg','31','179','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2379','94','Christoph Moritz','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_55519_33_2010_2.jpg','21','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2380','94','Levan Kenia','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_30732_33_2010_1.jpg','21','176','Georgia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2381','94','Julian Draxler','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_85148_33_2010_2.jpg','18','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2382','94','Rael','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_7349_33_2010_2.jpg','34','180','Spain','6','6','6','0','0','0','0','0','0','0','0','0','0','323',NULL,'6');
INSERT INTO `fman_players` VALUES ('2383','94','Ciprian Marica','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_16833_79_2010_2.jpg','26','185','Romania','6','6','6','0','0','0','0','0','0','0','0','0','0','51',NULL,'0');
INSERT INTO `fman_players` VALUES ('2384','94','Jefferson Farfen','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_16649_33_2010_1.jpg','27','178','Peru','6','6','6','0','0','0','0','0','0','0','0','0','0','272',NULL,'1');
INSERT INTO `fman_players` VALUES ('2385','94','Chinedu Obasi','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_41663_533_2010_2.jpg','25','188','Nigeria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2386','94','Teemu Pukki','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_46972_1008_2010_1.jpg','21','180','Finland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2387','94','Klaas-Jan Huntelaar','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_4357_3379_2010_1.jpg','28','186','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2388','94','Andreas Wiegel','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_45698_33_2010_1.jpg','20','179','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2389','95','Diego Benaglio','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_1667_82_2010_2.jpg','28','194','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2390','95','Andre Lenz','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_921_82_2010_2.jpg','38','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2391','95','Marwin Hitz','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_59238_82_2010_2.jpg','24','192','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2392','95','Marcel Schefer','17',NULL,NULL,NULL,'2',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_8317_82_2010_2.jpg','27','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2393','95','Sotirios Kyrgiakos','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_9706_82_2010_1.jpg','32','193','Greece','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2394','95','Alexander Madlung','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_2767_82_2010_2.jpg','29','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2395','95','Luiz Gustavo','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_10471_27_2014_1.jpg','24','187','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2396','95','Ricardo Rodreguez','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_86784_260_2010_2.jpg','19','180','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2397','95','Marco Russ','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_16520_82_2010_1.jpg','26','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2398','95','Chris','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3233_82_2010_1.jpg','33','185','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2399','95','Hrvoje Cale','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_24609_82_2010_1.jpg','26','184','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2400','95','Robin Knoche','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_94201_143_2010_1.jpg','19','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2401','95','Bjarne Thoelke','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_94210_82_2010_1.jpg','19','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2402','95','Michael Schulze','17',NULL,NULL,NULL,'0',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_45758_82_2010_1.jpg','23','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2403','95','Felipe Lopes','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_45448_982_2010_1.jpg','24','189','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2404','95','Patrick Ochs','17',NULL,NULL,NULL,'6',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_2358_82_2010_1.jpg','27','179','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2405','95','Ja-Cheol Koo','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_91841_82_2010_1.jpg','22','183','Korea, South','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2406','95','Slobodan Medojevic','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_48164_448_2009_1.jpg','21','183','Serbia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2407','95','Josue','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_52910_82_2010_2.jpg','32','169','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2408','95','Ibrahim Sissoko','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_157058_2990_2010_2.jpg','20','177','Cote d&#039;Ivoire','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2409','95','Thomas Hitzlsperger','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_1573_82_2010_1.jpg','29','184','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2410','95','Hasan Salihamidzic','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_214_82_2010_1.jpg','35','176','Bosnia-Herzegovina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2411','95','Makoto Hasebe','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_39259_82_2010_2.jpg','27','180','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2412','95','Vieirinha','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_35247_1091_2011_1.jpg','25','173','Portugal','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2413','95','Christian Tresch','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_38440_3262_2010_2.jpg','24','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2414','95','Petr Jiracek','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_63737_941_2011_1.jpg','25','180','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2415','95','Mateusz Klich','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_92738_3442_2010_1.jpg','21','183','Poland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2416','95','Ashkan Dejagah','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_13979_82_2010_2.jpg','25','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2417','95','Maximilian Arnold','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','17','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2418','95','Kevin de Bruyne','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','22','180','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2419','95','Ivica Olic','18',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_7427_27_2010_1.jpg','32','182','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2420','95','Jan Polak','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_3530_82_2010_1.jpg','30','181','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2421','95','Yohandry Orozco','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_72638_82_2010_2.jpg','20','164','Venezuela','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2422','95','Sebastian Schindzielorz','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/B/v/s_637_143_2009_1.jpg','32','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2423','95','Ferhan Hasani','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','21','183','Macedonia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2424','95','Giovanni Sio','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_76293_321_2010_3.jpg','22','180','France','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2425','95','Srdjan Lakic','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_34579_82_2010_1.jpg','28','186','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2426','95','Mario Mandzukic','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_34572_82_2010_1.jpg','25','186','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2427','95','Rasmus Jensson','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_72457_82_2010_1.jpg','21','192','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2428','95','Kevin Scheidhauer','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_94205_82_2010_1.jpg','19','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2429','95','Patrick Helmes','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_6322_82_2010_1.jpg','27','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2430','95','Sebastian Polter','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_60957_82_2010_1.jpg','20','192','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2431','96','Janis Blaswich','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_81173_18_2010_1.jpg','20','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2432','96','Christofer Heimeroth','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_1144_18_2010_2.jpg','30','194','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2433','96','Matthias Zimmermann','17',NULL,NULL,NULL,'2',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_86848_18_2010_1.jpg','19','178','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2434','96','Filip Daems','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_7028_18_2010_2.jpg','33','180','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2435','96','Roel Brouwers','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_4607_18_2010_2.jpg','30','192','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2436','96','Oscar Wendt','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_19305_18_2010_1.jpg','26','181','Sweden','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2437','96','Tony Jantschke','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_47587_3817_2010_1.jpg','21','177','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2438','96','Dante','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_16136_18_2010_2.jpg','28','188','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2439','96','Niklas Dams','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_57683_1006_2010_1.jpg','21','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2440','96','Martin Stranzl','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_568_18_2010_1.jpg','31','190','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2441','96','Alexander Ring','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_82113_1008_2010_1.jpg','20','173','Finland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2442','96','Tolga Cigerci','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_94199_5710_2010_2.jpg','19','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2443','96','Patrick Herrmann','17',NULL,NULL,NULL,'7',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_32711_18_2010_1.jpg','20','177','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2444','96','Lukas Rupp','17',NULL,NULL,NULL,'8',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_82863_5709_2010_1.jpg','21','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2445','96','Roman Neustadter','17',NULL,NULL,NULL,'9',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_40478_18_2010_2.jpg','23','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2446','96','Thorben Marx','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_837_18_2010_2.jpg','30','182','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2447','96','Havard Nordtveit','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_42234_18_2010_1.jpg','21','188','Norway','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2448','96','Juan Arango','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_26063_18_2010_1.jpg','31','180','Venezuela','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2449','96','Yuki Otsu','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_82999_6632_2010_1.jpg','21','180','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2450','96','Julian Korb','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_77809_18_2010_1.jpg','19','177','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2451','96','Rael Bobadilla','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_51356_18_2010_2.jpg','24','180','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'3');
INSERT INTO `fman_players` VALUES ('2452','96','Igor de Camargo','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_13023_18_2010_2.jpg','28','187','Belgium','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2453','96','Mike Hanke','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_1428_18_2010_1.jpg','28','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2454','96','Mathew Leckie','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_126214_18_2010_1.jpg','20','180','Australia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2455','96','Elias Kachunga','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_49501_1006_2010_1.jpg','19','177','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2456','97','Maikel Aerts','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_4155_44_2010_2.jpg','35','196','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2457','97','Sascha Burchert','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_36898_44_2010_2.jpg','22','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2458','97','Thomas Kraft','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_39732_44_2010_1.jpg','23','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2459','97','Christian Lell','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_2233_44_2010_2.jpg','27','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2460','97','Levan Kobiashvili','17',NULL,NULL,NULL,'3',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_411_44_2010_2.jpg','34','183','Georgia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2461','97','Roman Hubnak','17',NULL,NULL,NULL,'4',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_24667_44_2010_2.jpg','27','192','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2462','97','Andre Mijatovic','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_24617_44_2010_2.jpg','32','191','Croatia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2463','97','Christoph Janker','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_14977_44_2010_2.jpg','26','185','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2464','97','Maik Franz','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_1381_44_2010_1.jpg','30','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2465','97','Sebastian Neumann','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_83440_3817_2010_1.jpg','20','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2466','97','John Anthony Brooks','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_124732_44_2010_1.jpg','18','193','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2467','97','Andreas Ottl','17',NULL,NULL,NULL,'5',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_14856_44_2010_1.jpg','26','186','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2468','97','Raffael','17',NULL,NULL,NULL,'6',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_19819_44_2010_2.jpg','26','174','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2469','97','Ronny','17',NULL,NULL,NULL,'7',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_43847_44_2010_2.jpg','25','175','Brazil','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2470','97','Nikita Rukavytsya','17',NULL,NULL,NULL,'8',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_50135_44_2010_1.jpg','24','183','Australia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2471','97','Anis Ben-Hatira','17',NULL,NULL,NULL,'9',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_35872_41_2010_1.jpg','23','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2472','97','Peter Niemeyer','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_4691_44_2010_2.jpg','28','191','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2473','97','Patrick Ebert','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_32622_44_2010_2.jpg','24','176','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2474','97','Fanol Perdedaj','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_62934_44_2010_1.jpg','20','172','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2475','97','Nico Schulz','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_85867_44_2010_2.jpg','18','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2476','97','Alfredo Morales','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_58500_45_2010_1.jpg','21','183','United States','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2477','97','Fabian Lustenberger','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_42203_44_2010_2.jpg','23','180','Switzerland','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2478','97','Adrian Ramos','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_73782_3816_2010_1.jpg','25','185','Colombia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'2');
INSERT INTO `fman_players` VALUES ('2479','97','Tunay Torun','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_39247_44_2010_1.jpg','21','179','Turkey','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2480','97','Pierre-Michel Lasogga','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_73013_44_2010_2.jpg','20','189','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2481','97','Marco Djuricin','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_92989_44_2010_1.jpg','19','181','Austria','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2482','97','Abu Bakarr Kargbo','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_74844_44_2010_1.jpg','19','183','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2483','98','Mohamed Amsif','17',NULL,NULL,NULL,'1',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_45674_167_2010_2.jpg','22','187','Morocco','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2484','98','Ioannis Gelios','17',NULL,NULL,NULL,'0',NULL,'1','http://static.transfermarkt.net/bilder/mediumfotos/s_156676_167_2010_1.jpg','19','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2485','98','Paul Verhaegh','17',NULL,NULL,NULL,'2',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_18021_167_2010_2.jpg','28','178','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2486','98','Gibril Sankoh','17',NULL,NULL,NULL,'3',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_21590_167_2010_2.jpg','28','186','Sierra Leone','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2487','98','Dominik Reinhardt','17',NULL,NULL,NULL,'4',NULL,'4','http://static.transfermarkt.net/bilder/mediumfotos/s_4208_167_2010_2.jpg','27','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2488','98','Sebastian Langkamp','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_39094_167_2010_1.jpg','23','190','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2489','98','Marcel de Jong','17',NULL,NULL,NULL,'0',NULL,'2','http://static.transfermarkt.net/bilder/mediumfotos/s_16968_167_2010_2.jpg','25','174','Canada','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2490','98','Jan-Ingwer Callsen-Bracker','17',NULL,NULL,NULL,'0',NULL,'3','http://static.transfermarkt.net/bilder/mediumfotos/s_3851_167_2010_2.jpg','27','188','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2491','98','Jan Moravek','17',NULL,NULL,NULL,'5',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_63022_2_2010_1.jpg','22','180','Czech Republic','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2492','98','Hajime Hosogai','17',NULL,NULL,NULL,'6',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_79355_167_2010_2.jpg','25','176','Japan','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2493','98','Axel Bellinghausen','17',NULL,NULL,NULL,'7',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_6457_167_2010_2.jpg','28','181','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2494','98','Daniel Baier','17',NULL,NULL,NULL,'8',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_4018_167_2010_2.jpg','27','175','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2495','98','Tobias Werner','17',NULL,NULL,NULL,'9',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_26878_167_2010_2.jpg','26','177','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2496','98','Marcel Ndjeng','17',NULL,NULL,NULL,'0',NULL,'8','http://static.transfermarkt.net/bilder/mediumfotos/s_2334_167_2010_2.jpg','29','180','Cameroon','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2497','98','Daniel Brinkmann','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/s_18654_167_2010_2.jpg','25','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2498','98','Dawda Bah','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_49270_167_2010_1.jpg','28','187','The Gambia','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2499','98','Lorenzo Davids','17',NULL,NULL,NULL,'0',NULL,'6','http://static.transfermarkt.net/bilder/mediumfotos/s_34377_167_2010_2.jpg','25','180','Netherlands','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2500','98','Akaki Gogia','17',NULL,NULL,NULL,'0',NULL,'9','http://static.transfermarkt.net/bilder/mediumfotos/s_92472_167_2010_1.jpg','19','178','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2501','98','Moritz Nebel','17',NULL,NULL,NULL,'0',NULL,'5','http://static.transfermarkt.net/bilder/mediumfotos/s_32713_167_2010_2.jpg','20','178','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2502','98','Marco Thiede','17',NULL,NULL,NULL,'0',NULL,'7','http://static.transfermarkt.net/bilder/mediumfotos/somebody.jpg','19','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2503','98','Torsten Oehrl','17',NULL,NULL,NULL,'10',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_31451_167_2010_2.jpg','26','193','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'1');
INSERT INTO `fman_players` VALUES ('2504','98','Nando Rafael','17',NULL,NULL,NULL,'11',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_2712_167_2010_2.jpg','28','180','Angola','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2505','98','Edmond Kapllani','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_18248_167_2010_2.jpg','29','185','Albania','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2506','98','Sascha Malders','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_17689_167_2010_1.jpg','26','187','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2507','98','Stephan Hain','17',NULL,NULL,NULL,'0',NULL,'10','http://static.transfermarkt.net/bilder/mediumfotos/s_50199_167_2010_2.jpg','23','180','Germany','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2510','27','Doglas kosta','18','0','0','0','8',NULL,'6','','25','180','Brazil','6','6','6','4','3','4','3','3','4','2','3','5','0','126',NULL,'33');
INSERT INTO `fman_players` VALUES ('2509','23','Insine','18','0','0','0','10',NULL,'10','','25','190','Italiya','6','6','6','8','0','0','0','20','0','1','20','12','0','1462',NULL,'85');
INSERT INTO `fman_players` VALUES ('2513','42','Lionel Messi','19','0','0','0','10',NULL,'10','http://tmssl.akamaized.net//images/portrait/header/28003-1477905784.jpg','29','169','Argentina','6','6','6','0','0','0','0','0','0','0','0','0','0','0',NULL,'0');
INSERT INTO `fman_players` VALUES ('2512','3','Ilkay Gundogan','18','0','0','0','7',NULL,'7','','28','180','Germaniya','6','6','6','7','0','0','0','10','10','0','6','6','0','888',NULL,'0');

-- --------------------------------------------------------
-- 
-- Table structure for table `fman_spons`
-- 

CREATE TABLE `fman_spons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `pic` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `pay` int(11) NOT NULL,
  `plus` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------
-- 
-- Dumping data for table `fman_spons`
-- 

INSERT INTO `fman_spons` VALUES ('1','Fly Emirates','nopic.jpg','10000000','100000');
INSERT INTO `fman_spons` VALUES ('2','Qatar Airways','nopic.jpg','10000000','50000');
INSERT INTO `fman_spons` VALUES ('3','Jeep','nopic.jpg','20000000','250000');


-- --------------------------------------------------------
-- 
-- Table structure for table `forum`
-- 

CREATE TABLE `forum` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` char(1) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from` varchar(25) NOT NULL DEFAULT '',
  `realid` int(3) NOT NULL DEFAULT '0',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `soft` text NOT NULL,
  `text` text NOT NULL,
  `close` tinyint(1) NOT NULL DEFAULT '0',
  `close_who` varchar(25) NOT NULL DEFAULT '',
  `vip` tinyint(1) NOT NULL DEFAULT '0',
  `edit` text NOT NULL,
  `tedit` int(10) unsigned NOT NULL DEFAULT '0',
  `kedit` int(2) unsigned NOT NULL DEFAULT '0',
  `curators` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `close` (`close`),
  KEY `user_id` (`user_id`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `gallery`
-- 

CREATE TABLE `gallery` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `type` varchar(2) NOT NULL DEFAULT '',
  `avtor` varchar(25) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `name` text NOT NULL,
  `user` binary(1) NOT NULL DEFAULT '\0',
  `ip` text NOT NULL,
  `soft` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `avtor` (`avtor`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;



-- --------------------------------------------------------
-- 
-- Table structure for table `guest`
-- 

CREATE TABLE `guest` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adm` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(25) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `browser` tinytext NOT NULL,
  `admin` varchar(25) NOT NULL DEFAULT '',
  `otvet` text NOT NULL,
  `otime` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_who` varchar(20) NOT NULL DEFAULT '',
  `edit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_count` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `ip` (`ip`),
  KEY `adm` (`adm`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `karma_users`
-- 

CREATE TABLE `karma_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `karma_user` int(10) unsigned NOT NULL DEFAULT '0',
  `points` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `karma_user` (`karma_user`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4;



-- --------------------------------------------------------
-- 
-- Table structure for table `knb_games`
-- 

CREATE TABLE `knb_games` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `create_user_id` int(10) NOT NULL,
  `create_user_name` varchar(25) NOT NULL,
  `stavka` int(10) NOT NULL,
  `choice` varchar(10) NOT NULL,
  `opponent_user_id` int(10) NOT NULL,
  `opponent_user_name` varchar(25) NOT NULL,
  `opponent_choice` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `knb_users`
-- 

CREATE TABLE `knb_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `name` varchar(25) NOT NULL,
  `games` int(10) NOT NULL DEFAULT '0',
  `win` int(10) NOT NULL DEFAULT '0',
  `draw` int(10) NOT NULL DEFAULT '0',
  `loss` int(10) NOT NULL DEFAULT '0',
  `balans` int(10) NOT NULL DEFAULT '100',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `library_cats`
-- 

CREATE TABLE `library_cats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `dir` tinyint(1) NOT NULL DEFAULT '0',
  `pos` int(10) unsigned NOT NULL DEFAULT '0',
  `user_add` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `library_tags`
-- 

CREATE TABLE `library_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lib_text_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tag_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `lib_text_id` (`lib_text_id`),
  KEY `tag_name` (`tag_name`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `library_texts`
-- 

CREATE TABLE `library_texts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` mediumtext NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `announce` text,
  `uploader` varchar(100) NOT NULL DEFAULT '',
  `uploader_id` int(10) unsigned NOT NULL DEFAULT '0',
  `count_views` int(10) unsigned NOT NULL DEFAULT '0',
  `premod` tinyint(1) NOT NULL DEFAULT '0',
  `comments` tinyint(1) NOT NULL DEFAULT '0',
  `count_comments` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `text` (`text`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `lider`
-- 

CREATE TABLE `lider` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `text` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `m_chat`
-- 

CREATE TABLE `m_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `guest_id` int(11) NOT NULL,
  `message` varchar(500) NOT NULL,
  `cid` int(11) NOT NULL,
  `private` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `news_fanclub`
-- 

CREATE TABLE `news_fanclub` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tema` varchar(200) NOT NULL,
  `text` varchar(10000) NOT NULL,
  `cid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Table structure for table `notebook`
-- 

CREATE TABLE `notebook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `priority` varchar(1) NOT NULL,
  `name` text NOT NULL,
  `text` text NOT NULL,
  `star` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Dumping data for table `notebook`
-- 

INSERT INTO `notebook` VALUES ('5','1','1535285328','1','Adminlar info','1. [url=http://menejer.cf/users/profile.php?user=14]Akash_96[/url]\nIsmi: Olimjon\nTelefon: +998 (91) 131-04-06\n\n2. [url=http://menejer.cf/users/profile.php?user=16]Leo[/url]\nIsmi: Anvar\nTelefon: +998 (91) 456-03-34\n\n3. [url=http://menejer.cf/users/profile.php?user=30]ANTUAN[/url]\nIsmi: Sardor\nTelefon: +998 (99) 832-97-33','1');

-- --------------------------------------------------------
-- 
-- Table structure for table `privat`
-- 

CREATE TABLE `privat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(25) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `time` varchar(25) NOT NULL DEFAULT '',
  `author` varchar(25) NOT NULL DEFAULT '',
  `type` char(3) NOT NULL DEFAULT '',
  `chit` char(3) NOT NULL DEFAULT '',
  `temka` text NOT NULL,
  `otvet` binary(1) NOT NULL DEFAULT '\0',
  `me` varchar(25) NOT NULL DEFAULT '',
  `cont` varchar(25) NOT NULL DEFAULT '',
  `ignor` varchar(25) NOT NULL DEFAULT '',
  `attach` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `me` (`me`),
  KEY `ignor` (`ignor`)
) ENGINE=MyISAM AUTO_INCREMENT=1937 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Table structure for table `r_bilet`
-- 

CREATE TABLE `r_bilet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_cup` int(11) NOT NULL,
  `id_team` int(11) NOT NULL,
  `union_team` int(2) NOT NULL,
  `name_team` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=215 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Table structure for table `r_cup`
-- 

CREATE TABLE `r_cup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_cup` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `ot` int(2) NOT NULL,
  `do` int(2) NOT NULL,
  `name` varchar(50) NOT NULL,
  `priz` int(11) NOT NULL,
  `win` int(11) NOT NULL,
  `status` varchar(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `r_cupgame`
-- 

CREATE TABLE `r_cupgame` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_chemp` varchar(15) NOT NULL,
  `s_chemp` varchar(15) NOT NULL,
  `p_chemp` varchar(15) NOT NULL,
  `time` int(11) NOT NULL,
  `id_team1` int(11) NOT NULL,
  `id_team2` int(11) NOT NULL,
  `name_team1` varchar(50) NOT NULL,
  `name_team2` varchar(50) NOT NULL,
  `rez1` varchar(2) NOT NULL,
  `rez2` varchar(2) NOT NULL,
  `pen1` varchar(2) NOT NULL,
  `pen2` varchar(2) NOT NULL,
  `id_report` varchar(11) NOT NULL,
  `win` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=148 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `r_priz`
-- 

CREATE TABLE `r_priz` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_cup` varchar(11) NOT NULL,
  `id_union` int(50) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `priz` int(11) NOT NULL,
  `win` int(11) NOT NULL,
  `url` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;


-- --------------------------------------------------------
-- 
-- Table structure for table `shop`
-- 

CREATE TABLE `shop` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `price` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Dumping data for table `shop`
-- 

INSERT INTO `shop` VALUES ('1','500');
INSERT INTO `shop` VALUES ('2','500');
INSERT INTO `shop` VALUES ('3','300');
INSERT INTO `shop` VALUES ('4','400');
INSERT INTO `shop` VALUES ('5','20');
INSERT INTO `shop` VALUES ('6','15');
INSERT INTO `shop` VALUES ('7','15');
INSERT INTO `shop` VALUES ('8','10');
INSERT INTO `shop` VALUES ('9','5');
INSERT INTO `shop` VALUES ('10','200');
INSERT INTO `shop` VALUES ('11','100');
INSERT INTO `shop` VALUES ('12','100');
INSERT INTO `shop` VALUES ('13','30');

-- --------------------------------------------------------
-- 
-- Table structure for table `table_m`
-- 

CREATE TABLE `table_m` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `team` text NOT NULL,
  `i` int(10) NOT NULL DEFAULT '0',
  `o` int(10) NOT NULL DEFAULT '0',
  `goals` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------
-- 
-- Table structure for table `users`
-- 

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL DEFAULT '',
  `name_lat` varchar(40) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `rights` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `failed_login` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `imname` varchar(50) NOT NULL DEFAULT '',
  `sex` varchar(2) NOT NULL DEFAULT '',
  `komm` int(10) unsigned NOT NULL DEFAULT '0',
  `postforum` int(10) unsigned NOT NULL DEFAULT '0',
  `postguest` int(10) unsigned NOT NULL DEFAULT '0',
  `postchat` int(11) NOT NULL,
  `yearofbirth` int(4) NOT NULL DEFAULT '0',
  `datereg` int(10) unsigned NOT NULL DEFAULT '0',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `mail` varchar(50) NOT NULL DEFAULT '',
  `icq` int(10) unsigned NOT NULL DEFAULT '0',
  `skype` varchar(50) NOT NULL DEFAULT '',
  `jabber` varchar(50) NOT NULL DEFAULT '',
  `www` varchar(50) NOT NULL DEFAULT '',
  `about` text NOT NULL,
  `live` varchar(100) NOT NULL DEFAULT '',
  `mibile` varchar(50) NOT NULL DEFAULT '',
  `status` varchar(100) NOT NULL DEFAULT '',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` text NOT NULL,
  `preg` tinyint(1) NOT NULL DEFAULT '0',
  `regadm` varchar(25) NOT NULL DEFAULT '',
  `mailvis` tinyint(1) NOT NULL DEFAULT '0',
  `dayb` int(2) NOT NULL DEFAULT '0',
  `monthb` int(2) NOT NULL DEFAULT '0',
  `sestime` int(10) unsigned NOT NULL DEFAULT '0',
  `total_on_site` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost` int(10) unsigned NOT NULL DEFAULT '0',
  `rest_code` varchar(32) NOT NULL DEFAULT '',
  `rest_time` int(10) unsigned NOT NULL DEFAULT '0',
  `movings` int(10) unsigned NOT NULL DEFAULT '0',
  `place` varchar(30) NOT NULL DEFAULT '',
  `set_user` text NOT NULL,
  `set_forum` text NOT NULL,
  `set_mail` text NOT NULL,
  `karma_plus` int(11) NOT NULL DEFAULT '0',
  `karma_minus` int(11) NOT NULL DEFAULT '0',
  `karma_time` int(10) unsigned NOT NULL DEFAULT '0',
  `karma_off` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `comm_count` int(10) unsigned NOT NULL DEFAULT '0',
  `comm_old` int(10) unsigned NOT NULL DEFAULT '0',
  `smileys` text NOT NULL,
  `balans` int(11) NOT NULL DEFAULT '0',
  `manager2` int(11) NOT NULL,
  `award` int(11) NOT NULL,
  `money_time` int(11) NOT NULL DEFAULT '0',
  `cnick` varchar(25) NOT NULL DEFAULT '0',
  `cstat` varchar(25) NOT NULL DEFAULT '0',
  `comments` int(11) NOT NULL,
  `forecasts` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name_lat` (`name_lat`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`)
) ENGINE=MyISAM AUTO_INCREMENT=119 DEFAULT CHARSET=utf8mb4;