<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

define('_IN_JOHNCMS', 1);

require('incfiles/core.php');
$textl = $lng['registration'];
$headmod = 'registration';
require('incfiles/head.php');
$lng_reg = core::load_lng('registration');

if(core::$user_id){
    header('Location: index.php');
}
// Если регистрация закрыта, выводим предупреждение
if (core::$deny_registration || !$set['mod_reg'] || core::$user_id) {
    echo '<p>' . $lng_reg['registration_closed'] . '</p>';
    require('incfiles/end.php');
    exit;
}

$reg_nick = isset($_POST['nick']) ? trim($_POST['nick']) : '';
$lat_nick = functions::rus_lat(mb_strtolower($reg_nick));
$reg_pass = isset($_POST['password']) ? trim($_POST['password']) : '';
$reg_name = isset($_POST['imname']) ? trim($_POST['imname']) : '';
$reg_live = isset($_POST['live']) ? trim($_POST['live']) : '';
$reg_sex = isset($_POST['sex']) ? functions::check(mb_substr(trim($_POST['sex']), 0, 2)) : '';
$reg_dayb = isset($_POST['dayb']) ? functions::check(mb_substr(trim($_POST['dayb']), 0, 2)) : '';
$reg_monthb = isset($_POST['monthb']) ? functions::check(mb_substr(trim($_POST['monthb']), 0, 2)) : '';
$reg_yearofbirth = isset($_POST['yearofbirth']) ? functions::check(mb_substr(trim($_POST['yearofbirth']), 0, 4)) : '';

echo '<div class="phdr">' . $lng['registration'] . '</div>';
if (isset($_POST['submit'])) {
    // Принимаем переменные
    $error = array();

    // Проверка Логина
    if (empty($reg_nick)) {
        $error['login'][] = $lng_reg['error_nick_empty'];
    } elseif (mb_strlen($reg_nick) < 2 || mb_strlen($reg_nick) > 15) {
        $error['login'][] = $lng_reg['error_nick_lenght'];
    }
	
	if (preg_match('/[^\da-z\-\@\*\(\)\?\!\~\_\=\[\]]+/', $lat_nick)) {
        $error['login'][] = $lng['error_wrong_symbols'];
    }
	
	// Проверка имя
    if (empty($reg_name)) {
        $error['imya'][] = $lng_reg['error_name_empty'];
    } elseif (mb_strlen($reg_name) < 2 || mb_strlen($reg_name) > 20) {
        $error['imya'][] = $lng_reg['error_name_lenght'];
    }
	
	// Проверка сити
	if (empty($reg_live)) {
        $error['live'][] = $lng_reg['error_live_empty'];
    } elseif (mb_strlen($reg_live) < 2 || mb_strlen($reg_live) > 50) {
        $error['live'][] = $lng_reg['error_live_lenght'];
    }
	
	// Проверка дата рождения
if (empty($reg_dayb)) {
        $error['dayb'] = $lng_reg['error_empty_dayb'];
}
if (empty($reg_monthb)) {
        $error['monthb'] = $lng_reg['error_empty_monthb'];
}
if (empty($reg_yearofbirth)) {
        $error['yearofbirth'] = $lng_reg['error_empty_yearofbirth'];
}		
	
    // Проверка пароля
    if (empty($reg_pass)) {
        $error['password'][] = $lng_reg['error_empty_password'];
    } elseif (mb_strlen($reg_pass) < 3 || mb_strlen($reg_pass) > 10) {
        $error['password'][] = $lng_reg['error_wrong_lenght'];
    }

    if (preg_match('/[^\dA-Za-z]+/', $reg_pass)) {
        $error['password'][] = $lng_reg['error_wrong_symbols'];
    }

    // Проверка пола
    if ($reg_sex != 'm' && $reg_sex != 'zh') {
        $error['sex'] = $lng_reg['error_sex'];
    }


    // Проверка переменных
    if (empty($error)) {
        $pass = md5(md5($reg_pass));
        $reg_name = functions::check(mb_substr($reg_name, 0, 20));
        $reg_live = functions::check(mb_substr($reg_live, 0, 50));
        // Проверка, занят ли ник
        $req = mysql_query("SELECT * FROM `users` WHERE `name_lat`='" . mysql_real_escape_string($lat_nick) . "'");
        if (mysql_num_rows($req) != 0) {
            $error['login'][] = $lng_reg['error_nick_occupied'];
        }
    }
    if (empty($error)) {
        $preg = $set['mod_reg'] > 1 ? 1 : 0;
        mysql_query("INSERT INTO `users` SET
            `name` = '" . mysql_real_escape_string($reg_nick) . "',
            `name_lat` = '" . mysql_real_escape_string($lat_nick) . "',
            `password` = '" . mysql_real_escape_string($pass) . "',
            `imname` = '$reg_name',
            `live` = '$reg_live',
            `sex` = '$reg_sex',
			`dayb` = '$reg_dayb',
            `monthb` = '$reg_monthb',
            `yearofbirth` = '$reg_yearofbirth',
            `rights` = '0',
            `ip` = '" . core::$ip . "',
            `ip_via_proxy` = '" . core::$ip_via_proxy . "',
            `browser` = '" . mysql_real_escape_string($agn) . "',
            `datereg` = '" . time() . "',
            `lastdate` = '" . time() . "',
            `sestime` = '" . time() . "',
            `preg` = '$preg',
            `set_user` = '',
            `set_forum` = '',
            `set_mail` = '',
            `smileys` = ''
        ") or exit(__LINE__ . ': ' . mysql_error());
        $usid = mysql_insert_id();

        // Отправка системного сообщения
        $set_mail = unserialize($set['setting_mail']);

        if (!isset($set_mail['message_include'])) {
            $set_mail['message_include'] = 0;
        }

        if ($set_mail['message_include']) {
            $array = array('{LOGIN}', '{TIME}');
            $array_replace = array($reg_nick, '{TIME=' . time() . '}');

            if (empty($set['them_message'])) {
                $set['them_message'] = $lng_mail['them_message'];
            }

            if (empty($set['reg_message'])) {
                $set['reg_message'] = $lng['hi'] . ", {LOGIN}\r\n" . $lng_mail['pleased_see_you'] . "\r\n" . $lng_mail['come_my_site'] . "\r\n" . $lng_mail['respectfully_yours'];
            }

            $theme = str_replace($array, $array_replace, $set['them_message']);
            $system = str_replace($array, $array_replace, $set['reg_message']);
            mysql_query("INSERT INTO `cms_mail` SET
			    `user_id` = '0',
			    `from_id` = '" . $usid . "',
			    `text` = '" . mysql_real_escape_string($system) . "',
			    `time` = '" . time() . "',
			    `sys` = '1',
			    `them` = '" . mysql_real_escape_string($theme) . "'
			");
        }

        echo '<div class="menu"><p><h3>' . $lng_reg['you_registered'] . '</h3>' . $lng_reg['your_id'] . ': <b>' . $usid . '</b><br/>' . $lng_reg['your_login'] . ': <b>' . $reg_nick . '</b><br/>' . $lng_reg['your_password'] . ': <b>' . $reg_pass . '</b></p>';

        if ($set['mod_reg'] == 1) {
            echo '<p><span class="red"><b>' . $lng_reg['moderation_note'] . '</b></span></p>';
        } else {
            $_SESSION['uid'] = $usid;
            $_SESSION['ups'] = md5(md5($reg_pass));
            echo '<p><a href="' . $home . '">' . $lng_reg['enter'] . '</a></p>';
        }

        echo '</div>';
        require('incfiles/end.php');
        exit;
    }
}

/*
-----------------------------------------------------------------
Форма регистрации
-----------------------------------------------------------------
*/
if ($set['mod_reg'] == 1) echo '<div class="rmenu"><p>' . $lng_reg['moderation_warning'] . '</p></div>';
echo '<form action="reg.php" method="post"><div class="gmenu">' .
    '<p><h3>' . $lng_reg['login'] . '</h3>' .
    (isset($error['login']) ? '<span class="red"><small>' . implode('<br />', $error['login']) . '</small></span><br />' : '') .
    '<input type="text" name="nick" maxlength="15" value="' . htmlspecialchars($reg_nick) . '"' . (isset($error['login']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '<small>' . $lng_reg['login_help'] . '</small></p>' .
    '<p><h3>' . $lng_reg['password'] . '</h3>' .
    (isset($error['password']) ? '<span class="red"><small>' . implode('<br />', $error['password']) . '</small></span><br />' : '') .
    '<input type="text" name="password" maxlength="20" value="' . htmlspecialchars($reg_pass) . '"' . (isset($error['password']) ? ' style="background-color: #FFCCCC"' : '') . '/><br/>' .
    '<small>' . $lng_reg['password_help'] . '</small></p>' .
    '<p><h3>' . $lng_reg['sex'] . '</h3>' .
    (isset($error['sex']) ? '<span class="red"><small>' . $error['sex'] . '</small></span><br />' : '') .
    '<select name="sex"' . (isset($error['sex']) ? ' style="background-color: #FFCCCC"' : '') . '>' .
    '<option value="?">-?-</option>' .
    '<option value="m"' . ($reg_sex == 'm' ? ' selected="selected"' : '') . '>' . $lng_reg['sex_m'] . '</option>' .
    '<option value="zh"' . ($reg_sex == 'zh' ? ' selected="selected"' : '') . '>' . $lng_reg['sex_w'] . '</option>' .
    '</select></p></div>' .
    '<div class="menu">' .
    '<p><h3>' . $lng_reg['name'] . '</h3>' .
	(isset($error['imya']) ? '<span class="red"><small>' . implode('<br />', $error['imya']) . '</small></span><br />' : '') .
    '<input type="text" name="imname" maxlength="30" value="' . htmlspecialchars($reg_name) . '"' . (isset($error['imya']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '<small>' . $lng_reg['name_help'] . '</small></p>' .
    '<p><h3>' . $lng_reg['live'] . '</h3>' .
	(isset($error['live']) ? '<span class="red"><small>' . implode('<br />', $error['live']) . '</small></span><br />' : '') .
    '<input type="text" name="live" maxlength="50" value="' . htmlspecialchars($reg_live) . '"' . (isset($error['live']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '
	<p><h3>' . $lng_reg['data_birth'] . '</h3>' .
	(isset($error['dayb']) ? '<span class="red"><small>' . $error['dayb'] . '</small></span><br />' : '') .
	(isset($error['monthb']) ? '<span class="red"><small>' . $error['monthb'] . '</small></span><br />' : '') .
	(isset($error['yearofbirth']) ? '<span class="red"><small>' . $error['yearofbirth'] . '</small></span><br />' : '') .
    '<select name="dayb"' . (isset($error['dayb']) ? ' style="background-color: #FFCCCC"' : '') . '>' .
	'<option value="">- ? -</option>' .
    '<option value="01"' . ($reg_dayb == '01' ? ' selected="selected"' : '') . '>1</option>' .
    '<option value="02"' . ($reg_dayb == '02' ? ' selected="selected"' : '') . '>2</option>' .
    '<option value="03"' . ($reg_dayb == '03' ? ' selected="selected"' : '') . '>3</option>' .
    '<option value="04"' . ($reg_dayb == '04' ? ' selected="selected"' : '') . '>4</option>' .
    '<option value="05"' . ($reg_dayb == '05' ? ' selected="selected"' : '') . '>5</option>' .
    '<option value="06"' . ($reg_dayb == '06' ? ' selected="selected"' : '') . '>6</option>' .
    '<option value="07"' . ($reg_dayb == '07' ? ' selected="selected"' : '') . '>7</option>' .
    '<option value="08"' . ($reg_dayb == '08' ? ' selected="selected"' : '') . '>8</option>' .
    '<option value="09"' . ($reg_dayb == '09' ? ' selected="selected"' : '') . '>9</option>' .
    '<option value="10"' . ($reg_dayb == '10' ? ' selected="selected"' : '') . '>10</option>' .
    '<option value="11"' . ($reg_dayb == '11' ? ' selected="selected"' : '') . '>11</option>' .
    '<option value="12"' . ($reg_dayb == '12' ? ' selected="selected"' : '') . '>12</option>' .
    '<option value="13"' . ($reg_dayb == '13' ? ' selected="selected"' : '') . '>13</option>' .
    '<option value="14"' . ($reg_dayb == '14' ? ' selected="selected"' : '') . '>14</option>' .
    '<option value="15"' . ($reg_dayb == '15' ? ' selected="selected"' : '') . '>15</option>' .
    '<option value="16"' . ($reg_dayb == '16' ? ' selected="selected"' : '') . '>16</option>' .
    '<option value="17"' . ($reg_dayb == '17' ? ' selected="selected"' : '') . '>17</option>' .
    '<option value="18"' . ($reg_dayb == '18' ? ' selected="selected"' : '') . '>18</option>' .
    '<option value="19"' . ($reg_dayb == '19' ? ' selected="selected"' : '') . '>19</option>' .
    '<option value="20"' . ($reg_dayb == '20' ? ' selected="selected"' : '') . '>20</option>' .
    '<option value="21"' . ($reg_dayb == '21' ? ' selected="selected"' : '') . '>21</option>' .
    '<option value="22"' . ($reg_dayb == '22' ? ' selected="selected"' : '') . '>22</option>' .
    '<option value="23"' . ($reg_dayb == '23' ? ' selected="selected"' : '') . '>23</option>' .
    '<option value="24"' . ($reg_dayb == '24' ? ' selected="selected"' : '') . '>24</option>' .
    '<option value="25"' . ($reg_dayb == '25' ? ' selected="selected"' : '') . '>25</option>' .
    '<option value="26"' . ($reg_dayb == '26' ? ' selected="selected"' : '') . '>26</option>' .
    '<option value="27"' . ($reg_dayb == '27' ? ' selected="selected"' : '') . '>27</option>' .
    '<option value="28"' . ($reg_dayb == '28' ? ' selected="selected"' : '') . '>28</option>' .
    '<option value="29"' . ($reg_dayb == '29' ? ' selected="selected"' : '') . '>29</option>' .
    '<option value="30"' . ($reg_dayb == '30' ? ' selected="selected"' : '') . '>30</option>' .
    '<option value="31"' . ($reg_dayb == '31' ? ' selected="selected"' : '') . '>31</option>' .
    '</select>&nbsp;' .
	'<select name="monthb"' . (isset($error['monthb']) ? ' style="background-color: #FFCCCC"' : '') . '>' .
	'<option value="">- ? -</option>' .
    '<option value="01"' . ($reg_monthb == '01' ? ' selected="selected"' : '') . '>'.$lng['january'].'</option>' .
    '<option value="02"' . ($reg_monthb == '02' ? ' selected="selected"' : '') . '>'.$lng['february'].'</option>' .
    '<option value="03"' . ($reg_monthb == '03' ? ' selected="selected"' : '') . '>'.$lng['march'].'</option>' .
    '<option value="04"' . ($reg_monthb == '04' ? ' selected="selected"' : '') . '>'.$lng['april'].'</option>' .
    '<option value="05"' . ($reg_monthb == '05' ? ' selected="selected"' : '') . '>'.$lng['may'].'</option>' .
    '<option value="06"' . ($reg_monthb == '06' ? ' selected="selected"' : '') . '>'.$lng['june'].'</option>' .
    '<option value="07"' . ($reg_monthb == '07' ? ' selected="selected"' : '') . '>'.$lng['july'].'</option>' .
    '<option value="08"' . ($reg_monthb == '08' ? ' selected="selected"' : '') . '>'.$lng['august'].'</option>' .
    '<option value="09"' . ($reg_monthb == '09' ? ' selected="selected"' : '') . '>'.$lng['september'].'</option>' .
    '<option value="10"' . ($reg_monthb == '10' ? ' selected="selected"' : '') . '>'.$lng['october'].'</option>' .
    '<option value="11"' . ($reg_monthb == '11' ? ' selected="selected"' : '') . '>'.$lng['november'].'</option>' .
    '<option value="12"' . ($reg_monthb == '12' ? ' selected="selected"' : '') . '>'.$lng['december'].'</option>' .
    '</select>&nbsp;' .
	'<select name="yearofbirth"' . (isset($error['yearofbirth']) ? ' style="background-color: #FFCCCC"' : '') . '>' .
	'<option value="">- ? -</option>' .
    '<option value="1960"' . ($reg_yearofbirth == '1960' ? ' selected="selected"' : '') . '>1960</option>' .
    '<option value="1961"' . ($reg_yearofbirth == '1961' ? ' selected="selected"' : '') . '>1961</option>' .
    '<option value="1962"' . ($reg_yearofbirth == '1962' ? ' selected="selected"' : '') . '>1962</option>' .
    '<option value="1963"' . ($reg_yearofbirth == '1963' ? ' selected="selected"' : '') . '>1963</option>' .
    '<option value="1964"' . ($reg_yearofbirth == '1964' ? ' selected="selected"' : '') . '>1964</option>' .
    '<option value="1965"' . ($reg_yearofbirth == '1965' ? ' selected="selected"' : '') . '>1965</option>' .
    '<option value="1966"' . ($reg_yearofbirth == '1966' ? ' selected="selected"' : '') . '>1966</option>' .
    '<option value="1967"' . ($reg_yearofbirth == '1967' ? ' selected="selected"' : '') . '>1967</option>' .
    '<option value="1968"' . ($reg_yearofbirth == '1968' ? ' selected="selected"' : '') . '>1968</option>' .
	'<option value="1969"' . ($reg_yearofbirth == '1969' ? ' selected="selected"' : '') . '>1969</option>' .
    '<option value="1970"' . ($reg_yearofbirth == '1970' ? ' selected="selected"' : '') . '>1970</option>' .
    '<option value="1971"' . ($reg_yearofbirth == '1971' ? ' selected="selected"' : '') . '>1971</option>' .
    '<option value="1972"' . ($reg_yearofbirth == '1972' ? ' selected="selected"' : '') . '>1972</option>' .
    '<option value="1973"' . ($reg_yearofbirth == '1973' ? ' selected="selected"' : '') . '>1973</option>' .
    '<option value="1974"' . ($reg_yearofbirth == '1974' ? ' selected="selected"' : '') . '>1974</option>' .
    '<option value="1975"' . ($reg_yearofbirth == '1975' ? ' selected="selected"' : '') . '>1975</option>' .
    '<option value="1976"' . ($reg_yearofbirth == '1976' ? ' selected="selected"' : '') . '>1976</option>' .
    '<option value="1977"' . ($reg_yearofbirth == '1977' ? ' selected="selected"' : '') . '>1977</option>' .
    '<option value="1978"' . ($reg_yearofbirth == '1978' ? ' selected="selected"' : '') . '>1978</option>' .
    '<option value="1979"' . ($reg_yearofbirth == '1979' ? ' selected="selected"' : '') . '>1979</option>' .
    '<option value="1980"' . ($reg_yearofbirth == '1980' ? ' selected="selected"' : '') . '>1980</option>' .
    '<option value="1981"' . ($reg_yearofbirth == '1981' ? ' selected="selected"' : '') . '>1981</option>' .
    '<option value="1982"' . ($reg_yearofbirth == '1982' ? ' selected="selected"' : '') . '>1982</option>' .
    '<option value="1983"' . ($reg_yearofbirth == '1983' ? ' selected="selected"' : '') . '>1983</option>' .
    '<option value="1984"' . ($reg_yearofbirth == '1984' ? ' selected="selected"' : '') . '>1984</option>' .
    '<option value="1985"' . ($reg_yearofbirth == '1985' ? ' selected="selected"' : '') . '>1985</option>' .
    '<option value="1986"' . ($reg_yearofbirth == '1986' ? ' selected="selected"' : '') . '>1986</option>' .
    '<option value="1987"' . ($reg_yearofbirth == '1987' ? ' selected="selected"' : '') . '>1987</option>' .
    '<option value="1988"' . ($reg_yearofbirth == '1988' ? ' selected="selected"' : '') . '>1988</option>' .
    '<option value="1989"' . ($reg_yearofbirth == '1989' ? ' selected="selected"' : '') . '>1989</option>' .
    '<option value="1990"' . ($reg_yearofbirth == '1990' ? ' selected="selected"' : '') . '>1990</option>' .
    '<option value="1991"' . ($reg_yearofbirth == '1991' ? ' selected="selected"' : '') . '>1991</option>' .
    '<option value="1992"' . ($reg_yearofbirth == '1992' ? ' selected="selected"' : '') . '>1992</option>' .
    '<option value="1993"' . ($reg_yearofbirth == '1993' ? ' selected="selected"' : '') . '>1993</option>' .
    '<option value="1994"' . ($reg_yearofbirth == '1994' ? ' selected="selected"' : '') . '>1994</option>' .
    '<option value="1995"' . ($reg_yearofbirth == '1995' ? ' selected="selected"' : '') . '>1995</option>' .
    '<option value="1996"' . ($reg_yearofbirth == '1996' ? ' selected="selected"' : '') . '>1996</option>' .
    '<option value="1997"' . ($reg_yearofbirth == '1997' ? ' selected="selected"' : '') . '>1997</option>' .
    '<option value="1998"' . ($reg_yearofbirth == '1998' ? ' selected="selected"' : '') . '>1998</option>' .
    '<option value="1999"' . ($reg_yearofbirth == '1999' ? ' selected="selected"' : '') . '>1999</option>' .
    '<option value="2000"' . ($reg_yearofbirth == '2000' ? ' selected="selected"' : '') . '>2000</option>' .
    '<option value="2001"' . ($reg_yearofbirth == '2001' ? ' selected="selected"' : '') . '>2001</option>' .
    '<option value="2002"' . ($reg_yearofbirth == '2002' ? ' selected="selected"' : '') . '>2002</option>' .
    '<option value="2003"' . ($reg_yearofbirth == '2003' ? ' selected="selected"' : '') . '>2003</option>' .
    '<option value="2004"' . ($reg_yearofbirth == '2004' ? ' selected="selected"' : '') . '>2004</option>' .
    '<option value="2005"' . ($reg_yearofbirth == '2005' ? ' selected="selected"' : '') . '>2005</option>' .
    '<option value="2006"' . ($reg_yearofbirth == '2006' ? ' selected="selected"' : '') . '>2006</option>' .
    '<option value="2007"' . ($reg_yearofbirth == '2007' ? ' selected="selected"' : '') . '>2007</option>' .
    '<option value="2008"' . ($reg_yearofbirth == '2008' ? ' selected="selected"' : '') . '>2008</option>' .
    '<option value="2009"' . ($reg_yearofbirth == '2009' ? ' selected="selected"' : '') . '>2009</option>' .
    '<option value="2010"' . ($reg_yearofbirth == '2010' ? ' selected="selected"' : '') . '>2010</option>' .    
	'<option value="2011"' . ($reg_yearofbirth == '2011' ? ' selected="selected"' : '') . '>2011</option>' .
    '<option value="2012"' . ($reg_yearofbirth == '2012' ? ' selected="selected"' : '') . '>2012</option>' .
    '<option value="2013"' . ($reg_yearofbirth == '2013' ? ' selected="selected"' : '') . '>2013</option>' .
	
    '</select>&nbsp;</div>' .
    '<div class="gmenu">'.
    '<p><input type="submit" name="submit" value="' . $lng_reg['registration'] . '"/></p></div></form>' .
    '<div class="phdr"><small>' . $lng_reg['registration_terms'] . '</small></div>';

require('incfiles/end.php');
