<?php

/**
* @package     JohnCMS
* @link        http://johncms.com
* @copyright   Copyright (C) 2008-2011 JohnCMS Community
* @license     LICENSE.txt (see attached file)
* @version     VERSION.txt (see attached file)
* @author      http://johncms.com/about
*/

defined('_IN_JOHNCMS') or die('Error: restricted access');

$textl = htmlspecialchars($user['name']) . ': ' . $lng_profile['profile_edit'];
require('../incfiles/head.php');

/*
-----------------------------------------------------------------
Проверяем права доступа для редактирования Профиля
-----------------------------------------------------------------
*/
if (!empty($ban) || $user['id'] != $user_id && ($rights < 7 || $user['rights'] >= $rights)) {
    echo functions::display_error($lng_profile['error_rights']);
    require('../incfiles/end.php');
    exit;
}

/*
-----------------------------------------------------------------
Сброс настроек
-----------------------------------------------------------------
*/
if ($rights >= 7 && $rights > $user['rights'] && $act == 'reset') {
    mysql_query("UPDATE `users` SET `set_user` = '', `set_forum` = '', `set_chat` = '' WHERE `id` = '" . $user['id'] . "'");
    echo '<div class="gmenu"><p>' . $lng['settings_default'] . '<br /><a href="profile.php?user=' . $user['id'] . '">' . $lng['to_form'] . '</a></p></div>';
    require('../incfiles/end.php');
    exit;
}

echo '<div class="phdr"><a href="profile.php?user=' . $user['id'] . '"><b>' . ($user['id'] != $user_id ? $lng['profile'] : $lng_profile['my_profile']) . '</b></a> | ' . $lng['edit'] . '</div>';

if (isset($_GET['delavatar'])) {
    /*
    -----------------------------------------------------------------
    Удаляем аватар
    -----------------------------------------------------------------
    */
    @unlink('../files/users/avatar/' . $user['id'] . '.png');
    echo '<div class="rmenu">' . $lng_profile['avatar_deleted'] . '</div>';
} elseif (isset($_GET['delphoto'])) {
    /*
    -----------------------------------------------------------------
    Удаляем фото
    -----------------------------------------------------------------
    */
    @unlink('../files/users/photo/' . $user['id'] . '.jpg');
    @unlink('../files/users/photo/' . $user['id'] . '_small.jpg');
    echo '<div class="rmenu">' . $lng_profile['photo_deleted'] . '</div>';
} elseif (isset($_POST['submit'])) {
    /*
    -----------------------------------------------------------------
    Принимаем данные из формы, проверяем и записываем в базу
    -----------------------------------------------------------------
    */
    $error = array ();
    $user['imname'] = isset($_POST['imname']) ? functions::check(mb_substr($_POST['imname'], 0, 25)) : '';
    $user['live'] = isset($_POST['live']) ? functions::check(mb_substr($_POST['live'], 0, 50)) : '';
    $user['dayb'] = isset($_POST['dayb']) ? functions::check(mb_substr($_POST['dayb'], 0, 2)) : '';
    $user['status'] = isset($_POST['status']) ? functions::check(mb_substr($_POST['status'], 0, 50)) : '';
	$user['monthb'] = isset($_POST['monthb']) ? functions::check(mb_substr($_POST['monthb'], 0, 2)) : '';
    $user['yearofbirth'] = isset($_POST['yearofbirth']) ? functions::check(mb_substr($_POST['yearofbirth'], 0, 4)) : '';
    $user['about'] = isset($_POST['about']) ? functions::check(mb_substr($_POST['about'], 0, 500)) : '';
    $user['mibile'] = isset($_POST['mibile']) ? functions::check(mb_substr($_POST['mibile'], 0, 40)) : '';
    $user['mail'] = isset($_POST['mail']) ? functions::check(mb_substr($_POST['mail'], 0, 40)) : '';
    $user['mailvis'] = isset($_POST['mailvis']) ? 1 : 0;
    $user['icq'] = isset($_POST['icq']) ? intval($_POST['icq']) : 0;
    $user['skype'] = isset($_POST['skype']) ? functions::check(mb_substr($_POST['skype'], 0, 40)) : '';
    $user['jabber'] = isset($_POST['jabber']) ? functions::check(mb_substr($_POST['jabber'], 0, 40)) : '';
    $user['www'] = isset($_POST['www']) ? functions::check(mb_substr($_POST['www'], 0, 40)) : '';
    // Данные юзера (для Администраторов)
    $user['name'] = isset($_POST['name']) ? functions::check(mb_substr($_POST['name'], 0, 20)) : $user['name'];
    
	$user['balans'] = isset($_POST['balans']) ? functions::check(mb_substr($_POST['balans'], 0, 11)) : '';
    $user['sex'] = isset($_POST['sex']) && $_POST['sex'] == 'm' ? 'm' : 'zh';
    $user['rights'] = isset($_POST['rights']) ? abs(intval($_POST['rights'])) : $user['rights'];
    // Проводим необходимые проверки
    if($user['rights'] > $rights || $user['rights'] > 9 || $user['rights'] < 0)
        $user['rights'] = 0;
    if ($rights >= 7) {
        if (mb_strlen($user['name']) < 2 || mb_strlen($user['name']) > 20)
            $error[] = $lng_profile['error_nick_lenght'];
        $lat_nick = functions::rus_lat(mb_strtolower($user['name']));
        if (preg_match("/[^0-9a-z\-\@\*\(\)\?\!\~\_\=\[\]]+/", $lat_nick))
            $error[] = $lng_profile['error_nick_symbols'];
    }
    if ($user['dayb'] || $user['monthb'] || $user['yearofbirth']) {
        if ($user['dayb'] < 1 || $user['dayb'] > 31 || $user['monthb'] < 1 || $user['monthb'] > 12)
            $error[] = $lng_profile['error_birth'];
    }

		// Проверка имя
    if (empty($user['imname'])) {
        $error[] = $lng_reg['error_name_empty'];
    } elseif (mb_strlen($user['imname']) < 2 || mb_strlen($user['imname']) > 20) {
        $error[] = $lng_reg['error_name_lenght'];
    }
	
	// Проверка сити
	if (empty($user['live'])) {
        $error[] = $lng_reg['error_live_empty'];
    } elseif (mb_strlen($user['live']) < 2 || mb_strlen($user['live']) > 50) {
        $error[] = $lng_reg['error_live_lenght'];
    }
	
	
	// Проверка дата рождения
if (empty($user['dayb'])) {
        $error[] = $lng_reg['error_empty_dayb'];
}
if (empty($user['monthb'])) {
        $error[] = $lng_reg['error_empty_monthb'];
}
if (empty($user['yearofbirth'])) {
        $error[] = $lng_reg['error_empty_yearofbirth'];
}
	
	
    if (!$error) {
        mysql_query("UPDATE `users` SET
            `imname` = '" . $user['imname'] . "',
            `live` = '" . $user['live'] . "',
            `dayb` = '" . $user['dayb'] . "',
            `status` = '" . $user['status'] . "',
			`monthb` = '" . $user['monthb'] . "',
            `yearofbirth` = '" . $user['yearofbirth'] . "',
            `about` = '" . $user['about'] . "',
            `mibile` = '" . $user['mibile'] . "',
            `mail` = '" . $user['mail'] . "',
            `mailvis` = '" . $user['mailvis'] . "',
            `icq` = '" . $user['icq'] . "',
            `skype` = '" . $user['skype'] . "',
            `jabber` = '" . $user['jabber'] . "',
            `www` = '" . $user['www'] . "'
            WHERE `id` = '" . $user['id'] . "'
        ");
        if ($rights >= 7) {
            mysql_query("UPDATE `users` SET
                `name` = '" . $user['name'] . "',
                `balans` = '" . $user['balans'] . "',				
                `sex` = '" . $user['sex'] . "',
                `rights` = '" . $user['rights'] . "'
                WHERE `id` = '" . $user['id'] . "'
            ");
        }
        echo '<div class="gmenu">' . $lng_profile['data_saved'] . '</div>';
    } else {
        echo functions::display_error($error);
    }
    header('Location: profile.php?act=edit&user=' . $user['id']);
    exit;
}

/*
-----------------------------------------------------------------
Форма редактирования анкеты пользователя
-----------------------------------------------------------------
*/
echo '<form action="profile.php?act=edit&amp;user=' . $user['id'] . '" method="post">' .
     '<div class="gmenu"><p>' .
    $lng['login_name'] . ': <b>' . $user['name_lat'] . '</b><br />';
if ($rights >= 7) {
    echo $lng['nick'] . ': (' . $lng_profile['nick_lenght'] . ')<br /><input type="text" value="' . $user['name'] . '" name="name" /><br />';
} else {
    echo '<span class="gray">' . $lng['nick'] . ':</span> <b>' . $user['name'] . '</b><br />';
}
echo'<span class="gray">'.$lng['status'] . ': (' . $lng_profile['status_lenght'] . ')<br /><input type="text" value="' . $user['status'] . '" name="status" /><br />';
echo '</p><p>' . $lng['avatar'] . ':<br />';
$link = '';
if (file_exists(('../files/users/avatar/' . $user['id'] . '.png'))) {
    echo '<img src="../files/users/avatar/' . $user['id'] . '.png" width="32" height="32" alt="' . $user['name'] . '" /><br />';
    $link = ' | <a href="profile.php?act=edit&amp;user=' . $user['id'] . '&amp;delavatar">' . $lng['delete'] . '</a>';
}
echo '<small><a href="profile.php?act=images&amp;mod=avatar&amp;user=' . $user['id'] . '">' . $lng_profile['upload'] . '</a>';
if($user['id'] == $user_id)
    echo ' | <a href="../pages/faq.php?act=avatars">' . $lng['select'] . '</a>';
echo $link . '</small></p>';
echo '<p>' . $lng_profile['photo'] . ':<br />';
$link = '';
if (file_exists('../files/users/photo/' . $user['id'] . '_small.jpg')) {
    echo '<a href="../files/users/photo/' . $user['id'] . '.jpg"><img src="../files/users/photo/' . $user['id'] . '_small.jpg" alt="' . $user['name'] . '" border="0" /></a><br />';
    $link = ' | <a href="profile.php?act=edit&amp;user=' . $user['id'] . '&amp;delphoto">' . $lng['delete'] . '</a>';
}
echo '<small><a href="profile.php?act=images&amp;mod=up_photo&amp;user=' . $user['id'] . '">' . $lng_profile['upload'] . '</a>' . $link . '</small><br />' .
    '</p></div>' .
    '<div class="menu">' .
    '<p><h3><img src="../images/contacts.png" width="16" height="16" class="left" />&#160;' . $lng_profile['personal_data'] . '</h3>' .
    $lng_profile['name'] . ':<br /><input type="text" value="' . $user['imname'] . '" name="imname" /></p>' .
    '<p>' . $lng_profile['birth_date'] . '<br /><select name="dayb">' .
	'<option value="">- ? -</option>' .
    '<option value="01"' . ($user['dayb'] == '01' ? ' selected="selected"' : '') . '>1</option>' .
    '<option value="02"' . ($user['dayb'] == '02' ? ' selected="selected"' : '') . '>2</option>' .
    '<option value="03"' . ($user['dayb'] == '03' ? ' selected="selected"' : '') . '>3</option>' .
    '<option value="04"' . ($user['dayb'] == '04' ? ' selected="selected"' : '') . '>4</option>' .
    '<option value="05"' . ($user['dayb'] == '05' ? ' selected="selected"' : '') . '>5</option>' .
    '<option value="06"' . ($user['dayb'] == '06' ? ' selected="selected"' : '') . '>6</option>' .
    '<option value="07"' . ($user['dayb'] == '07' ? ' selected="selected"' : '') . '>7</option>' .
    '<option value="08"' . ($user['dayb'] == '08' ? ' selected="selected"' : '') . '>8</option>' .
    '<option value="09"' . ($user['dayb'] == '09' ? ' selected="selected"' : '') . '>9</option>' .
    '<option value="10"' . ($user['dayb'] == '10' ? ' selected="selected"' : '') . '>10</option>' .
    '<option value="11"' . ($user['dayb'] == '11' ? ' selected="selected"' : '') . '>11</option>' .
    '<option value="12"' . ($user['dayb'] == '12' ? ' selected="selected"' : '') . '>12</option>' .
    '<option value="13"' . ($user['dayb'] == '13' ? ' selected="selected"' : '') . '>13</option>' .
    '<option value="14"' . ($user['dayb'] == '14' ? ' selected="selected"' : '') . '>14</option>' .
    '<option value="15"' . ($user['dayb'] == '15' ? ' selected="selected"' : '') . '>15</option>' .
    '<option value="16"' . ($user['dayb'] == '16' ? ' selected="selected"' : '') . '>16</option>' .
    '<option value="17"' . ($user['dayb'] == '17' ? ' selected="selected"' : '') . '>17</option>' .
    '<option value="18"' . ($user['dayb'] == '18' ? ' selected="selected"' : '') . '>18</option>' .
    '<option value="19"' . ($user['dayb'] == '19' ? ' selected="selected"' : '') . '>19</option>' .
    '<option value="20"' . ($user['dayb'] == '20' ? ' selected="selected"' : '') . '>20</option>' .
    '<option value="21"' . ($user['dayb'] == '21' ? ' selected="selected"' : '') . '>21</option>' .
    '<option value="22"' . ($user['dayb'] == '22' ? ' selected="selected"' : '') . '>22</option>' .
    '<option value="23"' . ($user['dayb'] == '23' ? ' selected="selected"' : '') . '>23</option>' .
    '<option value="24"' . ($user['dayb'] == '24' ? ' selected="selected"' : '') . '>24</option>' .
    '<option value="25"' . ($user['dayb'] == '25' ? ' selected="selected"' : '') . '>25</option>' .
    '<option value="26"' . ($user['dayb'] == '26' ? ' selected="selected"' : '') . '>26</option>' .
    '<option value="27"' . ($user['dayb'] == '27' ? ' selected="selected"' : '') . '>27</option>' .
    '<option value="28"' . ($user['dayb'] == '28' ? ' selected="selected"' : '') . '>28</option>' .
    '<option value="29"' . ($user['dayb'] == '29' ? ' selected="selected"' : '') . '>29</option>' .
    '<option value="30"' . ($user['dayb'] == '30' ? ' selected="selected"' : '') . '>30</option>' .
    '<option value="31"' . ($user['dayb'] == '31' ? ' selected="selected"' : '') . '>31</option>' .
    '</select>&nbsp;' .
	'<select name="monthb">' .
	'<option value="">- ? -</option>' .
    '<option value="01"' . ($user['monthb'] == '01' ? ' selected="selected"' : '') . '>'.$lng['january'].'</option>' .
    '<option value="02"' . ($user['monthb'] == '02' ? ' selected="selected"' : '') . '>'.$lng['february'].'</option>' .
    '<option value="03"' . ($user['monthb'] == '03' ? ' selected="selected"' : '') . '>'.$lng['march'].'</option>' .
    '<option value="04"' . ($user['monthb'] == '04' ? ' selected="selected"' : '') . '>'.$lng['april'].'</option>' .
    '<option value="05"' . ($user['monthb'] == '05' ? ' selected="selected"' : '') . '>'.$lng['may'].'</option>' .
    '<option value="06"' . ($user['monthb'] == '06' ? ' selected="selected"' : '') . '>'.$lng['june'].'</option>' .
    '<option value="07"' . ($user['monthb'] == '07' ? ' selected="selected"' : '') . '>'.$lng['july'].'</option>' .
    '<option value="08"' . ($user['monthb'] == '08' ? ' selected="selected"' : '') . '>'.$lng['august'].'</option>' .
    '<option value="09"' . ($user['monthb'] == '09' ? ' selected="selected"' : '') . '>'.$lng['september'].'</option>' .
    '<option value="10"' . ($user['monthb'] == '10' ? ' selected="selected"' : '') . '>'.$lng['october'].'</option>' .
    '<option value="11"' . ($user['monthb'] == '11' ? ' selected="selected"' : '') . '>'.$lng['november'].'</option>' .
    '<option value="12"' . ($user['monthb'] == '12' ? ' selected="selected"' : '') . '>'.$lng['december'].'</option>' .
    '</select>&nbsp;' .
	'<select name="yearofbirth">' .
	'<option value="">- ? -</option>' .
	'<option value="1960"' . ($user['yearofbirth'] == '1960' ? ' selected="selected"' : '') . '>1960</option>' .
    '<option value="1961"' . ($user['yearofbirth'] == '1961' ? ' selected="selected"' : '') . '>1961</option>' .
    '<option value="1962"' . ($user['yearofbirth'] == '1962' ? ' selected="selected"' : '') . '>1962</option>' .
    '<option value="1963"' . ($user['yearofbirth'] == '1963' ? ' selected="selected"' : '') . '>1963</option>' .
    '<option value="1964"' . ($user['yearofbirth'] == '1964' ? ' selected="selected"' : '') . '>1964</option>' .
    '<option value="1965"' . ($user['yearofbirth'] == '1965' ? ' selected="selected"' : '') . '>1965</option>' .
    '<option value="1966"' . ($user['yearofbirth'] == '1966' ? ' selected="selected"' : '') . '>1966</option>' .
    '<option value="1967"' . ($user['yearofbirth'] == '1967' ? ' selected="selected"' : '') . '>1967</option>' .
    '<option value="1968"' . ($user['yearofbirth'] == '1968' ? ' selected="selected"' : '') . '>1968</option>' .
	'<option value="1969"' . ($user['yearofbirth'] == '1969' ? ' selected="selected"' : '') . '>1969</option>' .
    '<option value="1970"' . ($user['yearofbirth'] == '1970' ? ' selected="selected"' : '') . '>1970</option>' .
    '<option value="1971"' . ($user['yearofbirth'] == '1971' ? ' selected="selected"' : '') . '>1971</option>' .
    '<option value="1972"' . ($user['yearofbirth'] == '1972' ? ' selected="selected"' : '') . '>1972</option>' .
    '<option value="1973"' . ($user['yearofbirth'] == '1973' ? ' selected="selected"' : '') . '>1973</option>' .
    '<option value="1974"' . ($user['yearofbirth'] == '1974' ? ' selected="selected"' : '') . '>1974</option>' .
    '<option value="1975"' . ($user['yearofbirth'] == '1975' ? ' selected="selected"' : '') . '>1975</option>' .
    '<option value="1976"' . ($user['yearofbirth'] == '1976' ? ' selected="selected"' : '') . '>1976</option>' .
    '<option value="1977"' . ($user['yearofbirth'] == '1977' ? ' selected="selected"' : '') . '>1977</option>' .
    '<option value="1978"' . ($user['yearofbirth'] == '1978' ? ' selected="selected"' : '') . '>1978</option>' .
    '<option value="1979"' . ($user['yearofbirth'] == '1979' ? ' selected="selected"' : '') . '>1979</option>' .
    '<option value="1980"' . ($user['yearofbirth'] == '1980' ? ' selected="selected"' : '') . '>1980</option>' .
    '<option value="1981"' . ($user['yearofbirth'] == '1981' ? ' selected="selected"' : '') . '>1981</option>' .
    '<option value="1982"' . ($user['yearofbirth'] == '1982' ? ' selected="selected"' : '') . '>1982</option>' .
    '<option value="1983"' . ($user['yearofbirth'] == '1983' ? ' selected="selected"' : '') . '>1983</option>' .
    '<option value="1984"' . ($user['yearofbirth'] == '1984' ? ' selected="selected"' : '') . '>1984</option>' .
    '<option value="1985"' . ($user['yearofbirth'] == '1985' ? ' selected="selected"' : '') . '>1985</option>' .
    '<option value="1986"' . ($user['yearofbirth'] == '1986' ? ' selected="selected"' : '') . '>1986</option>' .
    '<option value="1987"' . ($user['yearofbirth'] == '1987' ? ' selected="selected"' : '') . '>1987</option>' .
    '<option value="1988"' . ($user['yearofbirth'] == '1988' ? ' selected="selected"' : '') . '>1988</option>' .
    '<option value="1989"' . ($user['yearofbirth'] == '1989' ? ' selected="selected"' : '') . '>1989</option>' .
    '<option value="1990"' . ($user['yearofbirth'] == '1990' ? ' selected="selected"' : '') . '>1990</option>' .
    '<option value="1991"' . ($user['yearofbirth'] == '1991' ? ' selected="selected"' : '') . '>1991</option>' .
    '<option value="1992"' . ($user['yearofbirth'] == '1992' ? ' selected="selected"' : '') . '>1992</option>' .
    '<option value="1993"' . ($user['yearofbirth'] == '1993' ? ' selected="selected"' : '') . '>1993</option>' .
    '<option value="1994"' . ($user['yearofbirth'] == '1994' ? ' selected="selected"' : '') . '>1994</option>' .
    '<option value="1995"' . ($user['yearofbirth'] == '1995' ? ' selected="selected"' : '') . '>1995</option>' .
    '<option value="1996"' . ($user['yearofbirth'] == '1996' ? ' selected="selected"' : '') . '>1996</option>' .
    '<option value="1997"' . ($user['yearofbirth'] == '1997' ? ' selected="selected"' : '') . '>1997</option>' .
    '<option value="1998"' . ($user['yearofbirth'] == '1998' ? ' selected="selected"' : '') . '>1998</option>' .
    '<option value="1999"' . ($user['yearofbirth'] == '1999' ? ' selected="selected"' : '') . '>1999</option>' .
    '<option value="2000"' . ($user['yearofbirth'] == '2000' ? ' selected="selected"' : '') . '>2000</option>' .
    '<option value="2001"' . ($user['yearofbirth'] == '2001' ? ' selected="selected"' : '') . '>2001</option>' .
    '<option value="2002"' . ($user['yearofbirth'] == '2002' ? ' selected="selected"' : '') . '>2002</option>' .
    '<option value="2003"' . ($user['yearofbirth'] == '2003' ? ' selected="selected"' : '') . '>2003</option>' .
    '<option value="2004"' . ($user['yearofbirth'] == '2004' ? ' selected="selected"' : '') . '>2004</option>' .
    '<option value="2005"' . ($user['yearofbirth'] == '2005' ? ' selected="selected"' : '') . '>2005</option>' .
    '<option value="2006"' . ($user['yearofbirth'] == '2006' ? ' selected="selected"' : '') . '>2006</option>' .
    '<option value="2007"' . ($user['yearofbirth'] == '2007' ? ' selected="selected"' : '') . '>2007</option>' .
    '<option value="2008"' . ($user['yearofbirth'] == '2008' ? ' selected="selected"' : '') . '>2008</option>' .
    '<option value="2009"' . ($user['yearofbirth'] == '2009' ? ' selected="selected"' : '') . '>2009</option>' .
    '<option value="2010"' . ($user['yearofbirth'] == '2010' ? ' selected="selected"' : '') . '>2010</option>' .
	'<option value="2011"' . ($user['yearofbirth'] == '2011' ? ' selected="selected"' : '') . '>2011</option>' .
    '<option value="2012"' . ($user['yearofbirth'] == '2012' ? ' selected="selected"' : '') . '>2012</option>' .
    '<option value="2013"' . ($user['yearofbirth'] == '2013' ? ' selected="selected"' : '') . '>2013</option>' .
    '</select>&nbsp;' .
    '<p>' . $lng_profile['city'] . ':<br /><input type="text" value="' . $user['live'] . '" name="live" /></p>' .
    '<p><h3><img src="../images/mail.png" width="16" height="16" class="left" />&#160;' . $lng_profile['communication'] . '</h3>' .
    $lng_profile['phone_number'] . ':<br /><input type="text" value="' . $user['mibile'] . '" name="mibile" /><br />' .
    '</p><p>E-mail:<br /><small>' . $lng_profile['email_warning'] . '</small><br />' .
    '<input type="text" value="' . $user['mail'] . '" name="mail" /><br />' .
    '<input name="mailvis" type="checkbox" value="1" ' . ($user['mailvis'] ? 'checked="checked"' : '') . ' />&#160;' . $lng_profile['show_in_profile'] . '</p>' .
    '</div>';
// Административные функции
if ($rights >= 7) {
	if ($rights == 9) {
    echo '<div class="phdr"><i class="fa fa-cog"></i>&#160;' . $lng['settings'] . '</div>';
    echo '<div class="list2"><i class="fa fa-circle-o"></i>&nbsp;&nbsp;<a href="profile.php?act=password&amp;user=' . $user['id'] . '">' . $lng['change_password'] . '</a><p>';
    echo '<i class="fa fa-circle-o"></i>&nbsp;&nbsp;<a href="profile.php?act=reset&amp;user=' . $user['id'] . '">' . $lng['reset_settings'] . '</a></div>';
    echo '<div class="phdr"><i class="fa fa-mars"></i>&#160;<i class="fa fa-venus"></i>&nbsp;&nbsp;' . $lng_profile['specify_sex'] . ':</div>' .
        '<input type="radio" value="m" name="sex" ' . ($user['sex'] == 'm' ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['sex_m'] . '<br />' .
        '<input type="radio" value="zh" name="sex" ' . ($user['sex'] == 'zh' ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['sex_w'] . '' .
        '<p>';
	echo '<div class="phdr"><i class="fa fa-money"></i>&#160;' . $lng['balance'] . '</div>';
	echo'<div class="list2"><input type="text" maxlenght="11" value="' . $user['balans'] . '" name="balans" /></div>';}
	
	
    if ($user['id'] != $user_id) {
        echo '<div class="phdr"><i class="fa fa-cogs"></i>&#160;' . $lng_profile['rank'] . '</div><div class="list2">' .
            '<input type="radio" value="0" name="rights" ' . (!$user['rights'] ? 'checked="checked"' : '') . '/>&#160;<b>' . $lng_profile['rank_0'] . '</b><br />' .
            '<input type="radio" value="3" name="rights" ' . ($user['rights'] == 3 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_3'] . '<br />' .
            '<input type="radio" value="4" name="rights" ' . ($user['rights'] == 4 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_4'] . '<br />' .
            '<input type="radio" value="5" name="rights" ' . ($user['rights'] == 5 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_5'] . '<br />' .
            '<input type="radio" value="6" name="rights" ' . ($user['rights'] == 6 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_6'] . '<br />';
        if ($rights == 9) {
            echo '<input type="radio" value="7" name="rights" ' . ($user['rights'] == 7 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_7'] . '<br />' .
                '<input type="radio" value="9" name="rights" ' . ($user['rights'] == 9 ? 'checked="checked"' : '') . '/>&#160;<span class="red"><b>' . $lng_profile['rank_9'] . '</b></span><br />';
        }
        echo '</div>';
    }

}
echo '<div class="list2"><input type="submit" class="write" value="' . $lng['save'] . '" name="submit" /></div>' .
    '</form>' .
    '<div class="phdr"><a href="profile.php?user=' . $user['id'] . '">' . $lng['to_form'] . '</a></div>';
?>