<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

define('_IN_JOHNCMS', 1);

require('incfiles/core.php');
$textl = $lng['registration'];
$headmod = 'registration';
require('incfiles/head.php');
$lng_reg = core::load_lng('registration');

// Если регистрация закрыта, выводим предупреждение
if (core::$deny_registration || !$set['mod_reg'] || core::$user_id) {
    echo '' . $lng_reg['registration_closed'] . '';
    require('incfiles/end.php');
    exit;
}

//$captcha = isset($_POST['captcha']) ? trim($_POST['captcha']) : NULL;
$reg_nick = isset($_POST['nick']) ? trim($_POST['nick']) : '';
$lat_nick = functions::rus_lat(mb_strtolower($reg_nick));
$reg_pass = isset($_POST['password']) ? trim($_POST['password']) : '';
$reg_name = isset($_POST['imname']) ? trim($_POST['imname']) : '';
$reg_about = isset($_POST['about']) ? trim($_POST['about']) : '';
$reg_sex = isset($_POST['sex']) ? functions::check(mb_substr(trim($_POST['sex']), 0, 2)) : '';

$user['dayb'] = isset($_POST['dayb']) ? intval($_POST['dayb']) : 0;
$user['monthb'] = isset($_POST['monthb']) ? intval($_POST['monthb']) : 0;
$user['yearofbirth'] = isset($_POST['yearofbirth']) ? intval($_POST['yearofbirth']) : 0;
$user['live'] = isset($_POST['live']) ? functions::check(mb_substr($_POST['live'], 0, 50)) : '';



echo '<div class="phdr"><b>' . $lng['registration'] . '</b></div>';
if (isset($_POST['submit'])) {
    // Принимаем переменные
    $error = array();

    // Проверка Логина
    if (empty($reg_nick)) {
        $error['login'][] = $lng_reg['error_nick_empty'];
    } elseif (mb_strlen($reg_nick) < 2 || mb_strlen($reg_nick) > 15) {
        $error['login'][] = $lng_reg['error_nick_lenght'];
    }

    if (preg_match('/[^\da-z\-\@\*\(\)\?\!\~\_\=\[\]]+/', $lat_nick)) {
        $error['login'][] = $lng['error_wrong_symbols'];
    }

    // Проверка пароля
    if (empty($reg_pass)) {
        $error['password'][] = $lng['error_empty_password'];
    } elseif (mb_strlen($reg_pass) < 3 || mb_strlen($reg_pass) > 10) {
        $error['password'][] = $lng['error_wrong_lenght'];
    }

    if (preg_match('/[^\dA-Za-z]+/', $reg_pass)) {
        $error['password'][] = $lng['error_wrong_symbols'];
    }

    // Проверка пола
    if ($reg_sex != 'm' && $reg_sex != 'zh') {
        $error['sex'] = $lng_reg['error_sex'];
    }

    // Проверка кода CAPTCHA
   /* if (!$captcha
        || !isset($_SESSION['code'])
        || mb_strlen($captcha) < 4
        || $captcha != $_SESSION['code']
    ) {
        $error['captcha'] = $lng['error_wrong_captcha'];
    }
    unset($_SESSION['code']);*/

    // Проверка переменных
    if (empty($error)) {
        $pass = md5(md5($reg_pass));
        $reg_name = functions::check(mb_substr($reg_name, 0, 20));
        $reg_about = functions::check(mb_substr($reg_about, 0, 500));
        // Проверка, занят ли ник
        $req = mysql_query("SELECT * FROM `users` WHERE `name_lat`='" . mysql_real_escape_string($lat_nick) . "'");
        if (mysql_num_rows($req) != 0) {
            $error['login'][] = $lng_reg['error_nick_occupied'];
        }
    }
    if (empty($error)) {
        $preg = $set['mod_reg'] > 1 ? 1 : 0;
        mysql_query("INSERT INTO `users` SET
            `name` = '" . mysql_real_escape_string($reg_nick) . "',
            `name_lat` = '" . mysql_real_escape_string($lat_nick) . "',
            `password` = '" . mysql_real_escape_string($pass) . "',
            `imname` = '$reg_name',
            `about` = '$reg_about',
            `sex` = '$reg_sex',
            `dayb` = '" . $user['dayb'] . "',
            `monthb` = '" . $user['monthb'] . "',
            `yearofbirth` = '" . $user['yearofbirth'] . "',
            `live` = '" . $user['live'] . "',
            `rights` = '0',
            `ip` = '" . core::$ip . "',
            `ip_via_proxy` = '" . core::$ip_via_proxy . "',
            `browser` = '" . mysql_real_escape_string($agn) . "',
            `datereg` = '" . time() . "',
            `lastdate` = '" . time() . "',
            `sestime` = '" . time() . "',
            `preg` = '$preg',
            `set_user` = '',
            `set_forum` = '',
            `set_mail` = '',
            `smileys` = ''
        ") or exit(__LINE__ . ': ' . mysql_error());
        $usid = mysql_insert_id();

        // Отправка системного сообщения
        $set_mail = unserialize($set['setting_mail']);

        if (!isset($set_mail['message_include'])) {
            $set_mail['message_include'] = 0;
        }

        if ($set_mail['message_include']) {
            $array = array('{LOGIN}', '{TIME}');
            $array_replace = array($reg_nick, '{TIME=' . time() . '}');

            if (empty($set['them_message'])) {
                $set['them_message'] = $lng_mail['them_message'];
            }

            if (empty($set['reg_message'])) {
                $set['reg_message'] = $lng['hi'] . ", {LOGIN}\r\n" . $lng_mail['pleased_see_you'] . "\r\n" . $lng_mail['come_my_site'] . "\r\n" . $lng_mail['respectfully_yours'];
            }

            $theme = str_replace($array, $array_replace, $set['them_message']);
            $system = str_replace($array, $array_replace, $set['reg_message']);
            mysql_query("INSERT INTO `cms_mail` SET
    `user_id` = '0',
    `from_id` = '" . $usid . "',
    `text` = '" . mysql_real_escape_string($system) . "',
    `time` = '" . time() . "',
    `sys` = '1',
    `them` = '" . mysql_real_escape_string($theme) . "'
");
        }

        echo '<div class="menu"><h3 style="margin-top: 0.5pc;">' . $lng_reg['you_registered'] . '</h3>' . $lng_reg['your_id'] . ': <b>' . $usid . '</b><br/>' . $lng_reg['your_login'] . ': <b>' . $reg_nick . '</b><br/>' . $lng_reg['your_password'] . ': <b>' . $reg_pass . '</b>';

        if ($set['mod_reg'] == 1) {
            echo '<span class="red"><b>' . $lng_reg['moderation_note'] . '</b></span>';
        } else {
            $_SESSION['uid'] = $usid;
            $_SESSION['ups'] = md5(md5($reg_pass));
            echo '<br /><a href="' . $home . '">' . $lng_reg['enter'] . '</a>';
        }

        echo '</div>';
        require('incfiles/end.php');
        exit;
    }
}

/*
-----------------------------------------------------------------
Форма регистрации
-----------------------------------------------------------------
*/
$qizil_yulduzcha = '<span class="red">*</span>'; // ' .$qizil_yulduzcha. '
if ($set['mod_reg'] == 1) echo '<div class="rmenu">' . $lng_reg['moderation_warning'] . '</div>';
echo '<form action="registration.php" method="post"><div class="menu">' .
    '<h3>' . $lng_reg['login'] . ' ' .$qizil_yulduzcha. '</h3>' .
    (isset($error['login']) ? '<span class="red"><small>' . implode('<br />', $error['login']) . '</small></span><br />' : '') .
    '<input type="text" name="nick" maxlength="15" value="' . htmlspecialchars($reg_nick) . '"' . (isset($error['login']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '' .
    '<h3 style="margin-top: 0.5pc;">' . $lng_reg['password'] . ' ' .$qizil_yulduzcha. '</h3>' .
    (isset($error['password']) ? '<span class="red"><small>' . implode('<br />', $error['password']) . '</small></span><br />' : '') .
    '<input type="text" name="password" maxlength="20" value="' . htmlspecialchars($reg_pass) . '"' . (isset($error['password']) ? ' style="background-color: #FFCCCC"' : '') . '/><br/>' .
    '' .
    '<h3 style="margin-top: 0.5pc;">Jinis` ' .$qizil_yulduzcha. '</h3>' .
    (isset($error['sex']) ? '<span class="red"><small>' . $error['sex'] . '</small></span><br />' : '') .
    '<select name="sex"' . (isset($error['sex']) ? ' style="background-color: #FFCCCC"' : '') . '>' .
    '' .
    '<option value="m"' . ($reg_sex == 'm' ? ' selected="selected"' : '') . '>Erkak</option>' .
    '<option value="zh"' . ($reg_sex == 'zh' ? ' selected="selected"' : '') . '>Ayol</option>' .
    '</select>' .
    '<h3 style="margin-top: 0.5pc;">' . $lng_reg['name'] . ' ' .$qizil_yulduzcha. '</h3>' .
    '<input type="text" name="imname" maxlength="30" value="' . htmlspecialchars($reg_name) . '" /><br />

    <h3 style="margin-top: 0.5pc;">Tuwilg`an sana yil oy</h3>

    <select name="dayb">';
    for ($i = 1; $i < 32; $i++) {
        echo '<option name="dayb" value="'.$i.'" ' . ($user['dayb'] == $i ? ' selected="selected"' : '') . '>'.$i.'</option>'."\n";
    } echo '
    </select>
    -
    <select name="monthb">
        <option name="monthb" value="1" ' . ($user['monthb'] == '1' ? ' selected="selected"' : '') . '>Yanvar</option>
        <option name="monthb" value="2" ' . ($user['monthb'] == '2' ? ' selected="selected"' : '') . '>Fevral</option>
        <option name="monthb" value="3" ' . ($user['monthb'] == '3' ? ' selected="selected"' : '') . '>Mart</option>
        <option name="monthb" value="4" ' . ($user['monthb'] == '4' ? ' selected="selected"' : '') . '>Aprel</option>
        <option name="monthb" value="5" ' . ($user['monthb'] == '5' ? ' selected="selected"' : '') . '>May</option>
        <option name="monthb" value="6" ' . ($user['monthb'] == '6' ? ' selected="selected"' : '') . '>Iyun</option>
        <option name="monthb" value="7" ' . ($user['monthb'] == '7' ? ' selected="selected"' : '') . '>Iyul</option>
        <option name="monthb" value="8" ' . ($user['monthb'] == '8' ? ' selected="selected"' : '') . '>Avgust</option>
        <option name="monthb" value="9" ' . ($user['monthb'] == '9' ? ' selected="selected"' : '') . '>Sentyabr</option>
        <option name="monthb" value="10" ' . ($user['monthb'] == '10' ? ' selected="selected"' : '') . '>Oktyabr</option>
        <option name="monthb" value="11" ' . ($user['monthb'] == '11' ? ' selected="selected"' : '') . '>Noyabr</option>
        <option name="monthb" value="12" ' . ($user['monthb'] == '12' ? ' selected="selected"' : '') . '>Dekabr</option>
    </select>'; echo '
    -
    <select name="yearofbirth">';
        for ($i = 1980; $i < 2010; $i++) {
            echo '<option name="monthb" value="'.$i.'" ' . ($user['yearofbirth'] == $i ? ' selected="selected"' : '') . '>'.$i.'</option>'."\n";
        } echo '
    </select>

<h3 style="margin-top: 0.5pc;">Davlatni tanlang</h3>
<select name="live">
<option name="live" value="Toshkent" ' . ($user['live'] == 'Toshkent' ? ' selected="selected"' : '') . '>Toshkent</option>
<option name="live" value="Samarxand" ' . ($user['live'] == 'Samarxand' ? ' selected="selected"' : '') . '>Samarxand</option>
<option name="live" value="Buxora" ' . ($user['live'] == 'Buxora' ? ' selected="selected"' : '') . '>Buxora</option>
<option name="live" value="Namangan" ' . ($user['live'] == 'Namangan' ? ' selected="selected"' : '') . '>Namangan</option>
<option name="live" value="Jizzax" ' . ($user['live'] == 'Jizzax' ? ' selected="selected"' : '') . '>Jizzax</option>
<option name="live" value="Nukus" ' . ($user['live'] == 'Nukus' ? ' selected="selected"' : '') . '>Nukus</option><option name="live" value="Navoyi" ' . ($user['live'] == 'Navoyi' ? ' selected="selected"' : '') . '>Navoyi</option></select>
<br/>

<h3 style="margin-top: 0.5pc;">Saytka kirishta maxsat</h3>
<select name="about"><option name="about" value="Latifa yozish" ' . ($user['about'] == 'Latifa yozish' ? ' selected="selected"' : '') . '>Latifa yozish</option>
<option name="about" value="Shunshakiy kirdim" ' . ($user['about'] == 'Shunshakiy kirdim' ? ' selected="selected"' : '') . '>Shunshakiy kirdim</option>
</select>
<br/><input type="submit" name="submit" value="O`tish"/></div></form>';
require('incfiles/end.php');