<?php

/**
* @package     JohnCMS
* @link        http://johncms.com
* @copyright   Copyright (C) 2008-2011 JohnCMS Community
* @license     LICENSE.txt (see attached file)
* @version     VERSION.txt (see attached file)
* @author      http://johncms.com/about
*/

defined('_IN_JOHNCMS') or die('Error: restricted access');

$textl = htmlspecialchars($user['name']) . ': ' . $lng_profile['profile_edit'];
require('../incfiles/head.php');

/*
-----------------------------------------------------------------
Проверяем права доступа для редактирования Профиля
-----------------------------------------------------------------
*/
if (!empty($ban) || $user['id'] != $user_id && ($rights < 7 || $user['rights'] >= $rights)) {
    echo functions::display_error($lng_profile['error_rights']);
    require('../incfiles/end.php');
    exit;
}

/*
-----------------------------------------------------------------
Сброс настроек
-----------------------------------------------------------------
*/
if ($rights >= 7 && $rights > $user['rights'] && $act == 'reset') {
    mysql_query("UPDATE `users` SET `set_user` = '', `set_forum` = '', `set_chat` = '' WHERE `id` = '" . $user['id'] . "'");
    echo '<div class="gmenu"><p>' . $lng['settings_default'] . '<br /><a href="profile.php?user=' . $user['id'] . '">' . $lng['to_form'] . '</a></p></div>';
    require('../incfiles/end.php');
    exit;
}

echo '<div class="phdr"><a href="profile.php?user=' . $user['id'] . '"><b>' . ($user['id'] != $user_id ? $lng['profile'] : $lng_profile['my_profile']) . '</b></a> | ' . $lng['edit'] . '</div>';

if (isset($_GET['delavatar'])) {
    /*
    -----------------------------------------------------------------
    Удаляем аватар
    -----------------------------------------------------------------
    */
    @unlink('../files/users/avatar/' . $user['id'] . '.png');
    echo '<div class="rmenu">' . $lng_profile['avatar_deleted'] . '</div>';
} elseif (isset($_GET['delphoto'])) {
    /*
    -----------------------------------------------------------------
    Удаляем фото
    -----------------------------------------------------------------
    */
    @unlink('../files/users/photo/' . $user['id'] . '.jpg');
    @unlink('../files/users/photo/' . $user['id'] . '_small.jpg');
    echo '<div class="rmenu">' . $lng_profile['photo_deleted'] . '</div>';
} elseif (isset($_POST['submit'])) {
    /*
    -----------------------------------------------------------------
    Принимаем данные из формы, проверяем и записываем в базу
    -----------------------------------------------------------------
    */
    $error = array ();
    $user['imname'] = isset($_POST['imname']) ? functions::check(mb_substr($_POST['imname'], 0, 25)) : '';
$user['balans'] = isset($_POST['balans']) ? functions::check(mb_substr($_POST['balans'], 0, 50)) : '';
$user['rasm'] = isset($_POST['rasm']) ? functions::check(mb_substr($_POST['rasm'], 0, 50)) : '';
    $user['live'] = isset($_POST['live']) ? functions::check(mb_substr($_POST['live'], 0, 50)) : '';
    $user['dayb'] = isset($_POST['dayb']) ? intval($_POST['dayb']) : 0;
    $user['monthb'] = isset($_POST['monthb']) ? intval($_POST['monthb']) : 0;
    $user['yearofbirth'] = isset($_POST['yearofbirth']) ? intval($_POST['yearofbirth']) : 0;
    $user['about'] = isset($_POST['about']) ? functions::check(mb_substr($_POST['about'], 0, 500)) : '';
    $user['mibile'] = isset($_POST['mibile']) ? functions::check(mb_substr($_POST['mibile'], 0, 40)) : '';
    $user['mail'] = isset($_POST['mail']) ? functions::check(mb_substr($_POST['mail'], 0, 40)) : '';
    $user['mailvis'] = isset($_POST['mailvis']) ? 1 : 0;
    $user['icq'] = isset($_POST['icq']) ? intval($_POST['icq']) : 0;
    $user['skype'] = isset($_POST['skype']) ? functions::check(mb_substr($_POST['skype'], 0, 40)) : '';
    $user['jabber'] = isset($_POST['jabber']) ? functions::check(mb_substr($_POST['jabber'], 0, 40)) : '';
    $user['www'] = isset($_POST['www']) ? functions::check(mb_substr($_POST['www'], 0, 40)) : '';
    // Данные юзера (для Администраторов)
    $user['name'] = isset($_POST['name']) ? functions::check(mb_substr($_POST['name'], 0, 20)) : $user['name'];
    $user['status'] = isset($_POST['status']) ? functions::check(mb_substr($_POST['status'], 0, 50)) : '';
    $user['karma_off'] = isset($_POST['karma_off']) ? 1 : 0;
    $user['sex'] = isset($_POST['sex']) && $_POST['sex'] == 'm' ? 'm' : 'zh';
    $user['rights'] = isset($_POST['rights']) ? abs(intval($_POST['rights'])) : $user['rights'];
    // Проводим необходимые проверки
    if($user['rights'] > $rights || $user['rights'] > 9 || $user['rights'] < 0)
        $user['rights'] = 0;
    if ($rights >= 7) {
        if (mb_strlen($user['name']) < 2 || mb_strlen($user['name']) > 20)
            $error[] = $lng_profile['error_nick_lenght'];
        $lat_nick = functions::rus_lat(mb_strtolower($user['name']));
        if (preg_match("/[^0-9a-z\-\@\*\(\)\?\!\~\_\=\[\]]+/", $lat_nick))
            $error[] = $lng_profile['error_nick_symbols'];
    }
    if ($user['dayb'] || $user['monthb'] || $user['yearofbirth']) {
        if ($user['dayb'] < 1 || $user['dayb'] > 31 || $user['monthb'] < 1 || $user['monthb'] > 12)
            $error[] = $lng_profile['error_birth'];
    }
    if ($user['icq'] && ($user['icq'] < 10000 || $user['icq'] > 999999999))
        $error[] = $lng_profile['error_icq'];
    if (!$error) {
        mysql_query("UPDATE `users` SET
            `imname` = '" . $user['imname'] . "',
            `live` = '" . $user['live'] . "',
            `dayb` = '" . $user['dayb'] . "',
            `monthb` = '" . $user['monthb'] . "',
            `yearofbirth` = '" . $user['yearofbirth'] . "',
            `about` = '" . $user['about'] . "',
            `mibile` = '" . $user['mibile'] . "',
            `mail` = '" . $user['mail'] . "',
            `mailvis` = '" . $user['mailvis'] . "',
            `icq` = '" . $user['icq'] . "',
            `skype` = '" . $user['skype'] . "',
`jabber` = '" . $user['jabber'] . "',
`balans` = '" . $user['balans'] . "',
            `rasm` = '" . $user['rasm'] . "',
            `www` = '" . $user['www'] . "'
            WHERE `id` = '" . $user['id'] . "'
        ");
        if ($rights >= 7) {
            mysql_query("UPDATE `users` SET
                `name` = '" . $user['name'] . "',
                `status` = '" . $user['status'] . "',
                `karma_off` = '" . $user['karma_off'] . "',
                `sex` = '" . $user['sex'] . "',
                `rights` = '" . $user['rights'] . "'
                WHERE `id` = '" . $user['id'] . "'
            ");
        }
        echo '<div class="gmenu">' . $lng_profile['data_saved'] . '</div>';
    } else {
        echo functions::display_error($error);
    }
    header('Location: profile.php?act=edit&user=' . $user['id']);
    exit;
}

/*
-----------------------------------------------------------------
Форма редактирования анкеты пользователя
-----------------------------------------------------------------
*/
echo '<form action="profile.php?act=edit&amp;user=' . $user['id'] . '" method="post">' .
    '<div class="menu">' .
    $lng['login_name'] . ': <b>' . $user['name_lat'] . '</b><br />';
if ($rights >= 7) {
    echo $lng['nick'] . ': (' . $lng_profile['nick_lenght'] . ')<br /><input type="text" value="' . $user['name'] . '" name="name" /><br />';
}
echo '<h3 style="margin-top: 0.5pc;">Ism</h3><input type="text" value="' . $user['imname'] . '" name="imname" /><br/><h3 style="margin-top: 0.5pc;">E-mail:</h3><small>' . $lng_profile['email_warning'] . '</small><br />
<input type="text" value="' . $user['mail'] . '" name="mail" /><br /><h3 style="margin-top: 0.5pc;">Tuwilg`an sana yil oy</h3>

    <select name="dayb">';
    for ($i = 1; $i < 32; $i++) {
        echo '<option name="dayb" value="'.$i.'" ' . ($user['dayb'] == $i ? ' selected="selected"' : '') . '>'.$i.'</option>'."\n";
    } echo '
    </select>
    -
    <select name="monthb">
        <option name="monthb" value="1" ' . ($user['monthb'] == '1' ? ' selected="selected"' : '') . '>Yanvar</option>
        <option name="monthb" value="2" ' . ($user['monthb'] == '2' ? ' selected="selected"' : '') . '>Fevral</option>
        <option name="monthb" value="3" ' . ($user['monthb'] == '3' ? ' selected="selected"' : '') . '>Mart</option>
        <option name="monthb" value="4" ' . ($user['monthb'] == '4' ? ' selected="selected"' : '') . '>Aprel</option>
        <option name="monthb" value="5" ' . ($user['monthb'] == '5' ? ' selected="selected"' : '') . '>May</option>
        <option name="monthb" value="6" ' . ($user['monthb'] == '6' ? ' selected="selected"' : '') . '>Iyun</option>
        <option name="monthb" value="7" ' . ($user['monthb'] == '7' ? ' selected="selected"' : '') . '>Iyul</option>
        <option name="monthb" value="8" ' . ($user['monthb'] == '8' ? ' selected="selected"' : '') . '>Avgust</option>
        <option name="monthb" value="9" ' . ($user['monthb'] == '9' ? ' selected="selected"' : '') . '>Sentyabr</option>
        <option name="monthb" value="10" ' . ($user['monthb'] == '10' ? ' selected="selected"' : '') . '>Oktyabr</option>
        <option name="monthb" value="11" ' . ($user['monthb'] == '11' ? ' selected="selected"' : '') . '>Noyabr</option>
        <option name="monthb" value="12" ' . ($user['monthb'] == '12' ? ' selected="selected"' : '') . '>Dekabr</option>
    </select>'; echo '
    -
    <select name="yearofbirth">';
        for ($i = 1980; $i < 2010; $i++) {
            echo '<option name="monthb" value="'.$i.'" ' . ($user['yearofbirth'] == $i ? ' selected="selected"' : '') . '>'.$i.'</option>'."\n";
        } echo '
    </select>

<h3 style="margin-top: 0.5pc;">Davlatni tanlang</h3>
<select name="live">
<option name="live" value="Toshkent" ' . ($user['live'] == 'Toshkent' ? ' selected="selected"' : '') . '>Toshkent</option>
<option name="live" value="Samarxand" ' . ($user['live'] == 'Samarxand' ? ' selected="selected"' : '') . '>Samarxand</option>
<option name="live" value="Buxora" ' . ($user['live'] == 'Buxora' ? ' selected="selected"' : '') . '>Buxora</option>
<option name="live" value="Namangan" ' . ($user['live'] == 'Namangan' ? ' selected="selected"' : '') . '>Namangan</option>
<option name="live" value="Jizzax" ' . ($user['live'] == 'Jizzax' ? ' selected="selected"' : '') . '>Jizzax</option>
<option name="live" value="Nukus" ' . ($user['live'] == 'Nukus' ? ' selected="selected"' : '') . '>Nukus</option><option name="live" value="Navoyi" ' . ($user['live'] == 'Navoyi' ? ' selected="selected"' : '') . '>Navoyi</option></select>
<br/>

<h3 style="margin-top: 0.5pc;">Saytka kirishta maxsat</h3>
<select name="about"><option name="about" value="Latifa yozish" ' . ($user['about'] == 'Latifa yozish' ? ' selected="selected"' : '') . '>Latifa yozish</option>
<option name="about" value="Shunshaki kirdim" ' . ($user['about'] == 'Shunshaki kirdim' ? ' selected="selected"' : '') . '>Shunshaki kirdim</option>
</select>
</div>';

// Административные функции
    if ($rights == 7) {
echo '<div class="rmenu"><p><h3><img src="../images/settings.png" width="16" height="16" class="left" />&#160;' . $lng['settings'] . '</h3><ul>';
    if ($rights == 9) {
        echo '<li><input name="karma_off" type="checkbox" value="1" ' . ($user['karma_off'] ? 'checked="checked"' : '') . ' />&#160;<span class="red"><b>' . $lng_profile['deny_karma'] . '</b></span></li>';
    }
    echo '<li><a href="profile.php?act=password&amp;user=' . $user['id'] . '">' . $lng['change_password'] . '</a></li>';
    if($rights > $user['rights'])
        echo '<li><a href="profile.php?act=reset&amp;user=' . $user['id'] . '">' . $lng['reset_settings'] . '</a></li>';
    echo '<li>' . $lng_profile['specify_sex'] . ':<br />' .
        '<input type="radio" value="m" name="sex" ' . ($user['sex'] == 'm' ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['sex_m'] . '<br />' .
        '<input type="radio" value="zh" name="sex" ' . ($user['sex'] == 'zh' ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['sex_w'] . '</li>' .
        '</ul></p>';
    if ($user['id'] != $user_id) {
        echo '<p><h3><img src="../images/forbidden.png" width="16" height="16" class="left" />&#160;' . $lng_profile['rank'] . '</h3><ul>' .
            '<input type="radio" value="0" name="rights" ' . (!$user['rights'] ? 'checked="checked"' : '') . '/>&#160;<b>' . $lng_profile['rank_0'] . '</b><br />' .
            '<input type="radio" value="3" name="rights" ' . ($user['rights'] == 3 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_3'] . '<br />' .
            '<input type="radio" value="4" name="rights" ' . ($user['rights'] == 4 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_4'] . '<br />' .
            '<input type="radio" value="5" name="rights" ' . ($user['rights'] == 5 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_5'] . '<br />' .
            '<input type="radio" value="6" name="rights" ' . ($user['rights'] == 6 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_6'] . '<br />';
        if ($rights == 9) {
            echo '<input type="radio" value="7" name="rights" ' . ($user['rights'] == 7 ? 'checked="checked"' : '') . '/>&#160;' . $lng_profile['rank_7'] . '<br />' .
                '<input type="radio" value="9" name="rights" ' . ($user['rights'] == 9 ? 'checked="checked"' : '') . '/>&#160;<span class="red"><b>' . $lng_profile['rank_9'] . '</b></span><br />';
        }
        echo '</ul></p>';
    }
    echo '</div>';
}
echo '<div class="gmenu"><input type="submit" value="' . $lng['save'] . '" name="submit" /></div>' .
    '</form></div>';
?>