/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import com.phonegap.DroidGap;
import com.phonegap.api.LOG;

public class LinearLayoutSoftKeyboardDetect
extends LinearLayout {
    private static final String TAG = "SoftKeyboardDetect";
    private int oldHeight = 0;
    private int oldWidth = 0;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private DroidGap app = null;

    public LinearLayoutSoftKeyboardDetect(Context context, int width, int height) {
        super(context);
        this.screenWidth = width;
        this.screenHeight = height;
        this.app = (DroidGap)context;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        LOG.v(TAG, "We are in our onMeasure method");
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        LOG.v(TAG, "Old Height = %d", this.oldHeight);
        LOG.v(TAG, "Height = %d", height);
        LOG.v(TAG, "Old Width = %d", this.oldWidth);
        LOG.v(TAG, "Width = %d", width);
        if (this.oldHeight == 0 || this.oldHeight == height) {
            LOG.d(TAG, "Ignore this event");
        } else if (this.screenHeight == width) {
            int tmp_var = this.screenHeight;
            this.screenHeight = this.screenWidth;
            this.screenWidth = tmp_var;
            LOG.v(TAG, "Orientation Change");
        } else if (height > this.oldHeight) {
            if (this.app != null) {
                this.app.sendJavascript("PhoneGap.fireDocumentEvent('hidekeyboard');");
            }
        } else if (height < this.oldHeight && this.app != null) {
            this.app.sendJavascript("PhoneGap.fireDocumentEvent('showkeyboard');");
        }
        this.oldHeight = height;
        this.oldWidth = width;
    }
}

