/********************************************************************
 * Font Awesome Picker
 ====================================================================
 * Creation date: 07-02-2015 by octazid
 * Last update: 08-02-2015 by octazid  
 ====================================================================
 * Simple dialog to browse through the icons and select the name
 * 
 ********************************************************************/

var text
var txt = ""
var pos = 0
var lastselected

//------------Create the Dialog-------------
function Fontawesomepicker(control)
{
    text = app.ReadFile("All519FontAwesomeIcons.txt");
    text = text.split(",");
    var self = this;
    this.control = control;
    this.dlg = app.CreateDialog("Fontawesomepicker");
    this.lay = app.CreateLayout( "linear", "fillx" );
    this.txtpic = app.CreateText("",0.3,-1,"Center,Fontawesome");
    this.txtpic.SetTextSize(40);
    this.txtpic.SetMargins(0,0.01,0,0);
    this.txtpic.SetTextColor( "#FF63FC14" );
    this.txtpic.parent = self;
    this.lay.AddChild(this.txtpic);
    this.txt = app.CreateText("",0.6,-1,"Center,Autoscale");
    this.txt.SetTextSize(24);
    this.txt.parent = self;
    this.lay.AddChild(this.txt);
    for (var i = 0; i < text.length - 1; i++)
        {
        txt = txt + "[" + text[i] + "]:<br>" + text[i] + "<br><br>" + 
              "Nr. " + [i+1] + ":null," 
        }
    this.lst = app.CreateList(txt , 0.6, 0.4, "Html, FontAwesome" );
    this.lst.parent = self;
    this.lst.SetTextColor( "#FF880000" ); 
    this.lst.SetBackColor("#FF141414");
    this.lst.SetTextSize( 20 ); 
    this.lst.SetOnTouch(lst_OnTouch);  
    this.lst.SelectItemByIndex(pos, true);
    this.lay.AddChild(this.lst);
    this.btnlay = app.CreateLayout( "linear", "horizontal,fillxy" );
    this.dlgbtn = app.CreateButton("OK", 0.3);
    this.dlgbtn.parent = self;
    this.dlgbtn.SetOnTouch(dlgbtn_OnTouch);
    this.btnlay.AddChild(this.dlgbtn);
    this.dlgbtnCancel = app.CreateButton("Chancel",0.3);
    this.dlgbtnCancel.parent = self;
    this.dlgbtnCancel.SetOnTouch(dlgbtn_OnTouch);
    this.btnlay.AddChild(this.dlgbtnCancel);
    this.lay.AddChild(this.btnlay)
    this.dlg.AddLayout(this.lay);
    this.Show = function(){self.dlg.Show();}
    this.Hide = function(){self.dlg.Hide();}
    lastselected = GetListItemCount(text,pos);
    this.txtpic.SetText("[" + lastselected + "]");
    this.txt.SetText(lastselected);
}//function Fontawesomepicker()


//Called if a listitem is touched
function lst_OnTouch(title, body, type, index)
{
    result = GetListItemCount(text,index);
    pos = index;
    var par = this.parent;
    par.txtpic.SetText("[" + result + "]");
    par.txt.SetText(result);
    par.lst.SelectItemByIndex(pos);
}//lst_OnTouch


//returns the name of the selected item taken from the array
function GetListItemCount(text,i)
{
    return text[i];
}


//Called if a Button is touched
function dlgbtn_OnTouch()
{
    var par = this.parent;
    par.Hide();
    if(this.GetText() == "OK")
    {
      par.control.InsertText("[" + par.txt.GetText() + "]", par.control.GetCursorPos());
    } 
}//function dlgbtn_OnTouch