app.LoadPlugin( "BarcodeReader" );

//Called when application is started.
function OnStart()
{
    //Fix orientation to landscape.
    app.SetOrientation( "Landscape" );
    
    //Stop screen turning off.
    app.PreventScreenLock( true );
    
    //Create a layout to fill the screen.
    lay = app.CreateLayout( "Absolute", "FillXY" );

    //Create the barcode reader.    
    reader = app.CreateObject( "BarcodeReader" );
   
    //Create camera view control
    //(UseYUV is required for use with BarcodeReader)
    cam = app.CreateCameraView( 0.8, 1.0, "VGA, UseYUV" );
    cam.SetPosition( 0.1, 0 );
    cam.SetOnReady( cam_OnReady );
    lay.AddChild( cam );
     
    //Add main layout to app.
    app.AddLayout( lay );   
}

//Called when camera is ready.
function cam_OnReady()
{
    //Create an image control over the top of the 
    //camera view with transparency (alpha) so
    //we can show a framed area.
    img = app.CreateImage( null, 1.0, 1.0 );  
    img.SetAlpha( 0.5 );  
    lay.AddChild( img );     
    img.SetPaintColor( "#ff0000"  );
    img.SetPaintStyle( "Line" );
    img.SetLineWidth( 2.5 );
    img.DrawRectangle( 0.2, 0.2, 0.8, 0.8 );
    
    //Create a layout for instruction text
    //and flash checkbox.
    overlay = app.CreateLayout( "Linear", "FillXY" );
    lay.AddChild(overlay);
    
    //Create the instruction text.
    txt = app.CreateText( "Position a barcode in the frame to read it" );
    txt.SetMargins( 0,0.05,0,0 );
    txt.SetPadding( 0.01,0,0.01,0 );
    txt.SetTextColor( "#ffffff" );
    txt.SetBackColor( "#44000000" );
    txt.SetTextSize( 18 );
    overlay.AddChild( txt );
    
    //Create Use Flash check box.
    chkFlash = app.CreateCheckBox( "Use Flash" );
    chkFlash.SetMargins( 0,0.75,0,0 );
    chkFlash.SetPadding( 0.01,0,0.01,0 );
    chkFlash.SetTextColor( "#ffffff" );
    chkFlash.SetBackColor( "#44000000" );
    chkFlash.SetTextSize( 18 );
    chkFlash.SetOnTouch( chkFlash_OnTouch );
    overlay.AddChild( chkFlash );
    
    //Start preview.
    cam.StartPreview();
    
    //Macro focus mode works best for 
    //reading barcodes.
    cam.SetFocusMode( "macro" );
        
    //Start decoding the camera preview.
    DecodeFromCamera();
}

//Handle Use Flash checkbox touch
function chkFlash_OnTouch( value )
{
    cam.SetFlash( value );
}

function DecodeFromCamera()
{
    //Attempt to detect a barcode in the 
    //camera preview.
    var result = reader.Decode( cam );
    
    //If result is not null, a barcode 
    //was detected.
    if( result != null )
    {
        //Vibrate and show result dialog.
        app.Vibrate( "0,100,30,100,50,300" );
        ShowResult( result );
    }
    else
    {
        //Decode again in 200 milliseconds.
        setTimeout( DecodeFromCamera, 200 );
    }
}

function ShowResult( result )
{
    //Create dialog window.
    resultDlg = app.CreateDialog( result.barcodeType, "NoCancel" );
    
    //Create a layout for dialog.
    layDlg = app.CreateLayout( "Linear", "Vertical, FillXY" );
    layDlg.SetPadding( 0.02, 0, 0.02, 0.02 );
    resultDlg.AddLayout( layDlg );
    
    //Create text for the content type name.
    txtDlg = app.CreateText( result.contentType );
    txtDlg.SetTextSize( 22 );
    txtDlg.SetTextColor( "#0099CC" );
    layDlg.AddChild( txtDlg );
    
    //Create a scroller for the content.
    scrDlg = app.CreateScroller( 0.4, 0.45 );
    scrDlg.SetMargins( 0, 0.01, 0, 0 );
    layDlg.AddChild( scrDlg );

    //Create text for the content.
    txtDlg = app.CreateText( result.content, 0.4, -1, "Multiline" );
    txtDlg.SetTextSize( 18 );
    scrDlg.AddChild( txtDlg );
    
    //Create an Ok button to dismiss the dialog.
    btnDlg = app.CreateButton( "Ok" );
    btnDlg.SetOnTouch( resultDlg_OnOk );
    layDlg.AddChild( btnDlg );
    
    //Show dialog.
    resultDlg.Show();
}

//Called when the result dialog Ok button is pressed 
function resultDlg_OnOk()
{
    resultDlg.Dismiss();
  
    //Start decoding again.
    DecodeFromCamera();
}

