
//Load the plugin.
app.LoadPlugin( "ImageGrid" );

//Called when application is started.
function OnStart()
{
	//Create a layout with objects vertically centered.
	lay = app.CreateLayout( "linear", "VCenter,FillXY" );	

    //Get list of photos.
    var files = app.ListFolder( "/sdcard/DCIM/Camera", ".jpg", 1000, "FullPath" );
 
    //Create Image grid with 3 columns and 5 rows per screen.
    grid = app.CreateImageGrid( files, 1, 0.7, 3, 5 );
    grid.SetOnTouch( grid_OnTouch );
    grid.SetOnLongTouch( grid_OnLongTouch );
    lay.AddChild( grid );
	
	//Add layout to app.	
	app.AddLayout( lay );
}

//Handle image touch.
function grid_OnTouch( fileName )
{
    alert( fileName );
}

//Handle image long touch.
function grid_OnLongTouch( fileName )
{
    alert( fileName );
}
