

//Add CreatePlayCanvas method to global app object.
app.CreateMapView = function( apiKey, width, height, options ) 
{ 
    if( !app.IsPremium() ) { alert("MapView is a Premium plugin!"); return null }
    return new _MapView( apiKey, width, height, options );
}

//Globals for webview callacks
var _MapView_isDebug = false
var _MapView_onMarker = null

//Plugin wrapper class.
function _MapView( apiKey, width, height, options )
{
    var self = this
    var onReady = null
    var loaded = false
    options = options ? options.toLowerCase() : ""
    
    //Create a layout to hold webview.
    var lay = app.CreateLayout( "Linear" )
    
    //Create a webview control.
	var web = app.CreateWebView( width, height, "NoScrollbar,IgnoreErrors" );
	lay.AddChild( web )
	
	//Fire callback when map is loaded.
	web.SetOnProgress( function(p){ if(p==100 && onReady && !loaded ) {onReady(); loaded=true} } )
    
	//Replacing certain keywords in html file.
	var dbg = _MapView_isDebug
	var plugDir = app.GetPrivateFolder( "Plugins" )+"/mapview/"
	var html = app.ReadFile( (dbg ? "Map.html" : plugDir+"Map_.html") )
	app.WriteFile( plugDir+"Map.html", html )
	app.ReplaceInFile( plugDir+"Map.html", "@OPTIONS@", options, dbg?"":"decrypt" )
	app.ReplaceInFile( plugDir+"Map.html", "@KEY@", apiKey, dbg?"":"decrypt" )
	
	//Load the HTML page 
	web.LoadUrl( "file://"+plugDir+"Map.html", dbg?"":"decrypt" )
	
	//Define public methods.
	lay.GetVersion = function( num, txt ) { return 0.1; }
	lay.GetView = function() { return web } 
	lay.SetOnReady = function( callback ) { onReady = callback } 
	lay.SetOnMarker = function( callback ) { _MapView_onMarker = callback } 
    lay.SetZoom = function( zoom ) { web.Execute("SetZoom("+zoom+")") }
    lay.SetCenter = function( latitude, longitude ) { web.Execute("SetCenter("+latitude+","+longitude+")") }
    
    lay.DrawPolygon = function( points, strokeColor, strokeOpacity, strokeWeight, fillColor, fillOpacity  ) {
        web.Execute("DrawPolygon('"+JSON.stringify(points)+"',\""+strokeColor+"\",\""+fillColor+"\","+strokeOpacity
            +","+fillOpacity+","+strokeWeight+")" ) 
    }
    
    lay.DrawPolyLine = function( points, strokeColor, strokeOpacity, strokeWeight ) {
        web.Execute("DrawPolyLine('"+JSON.stringify(points)+"',\""+strokeColor+"\","+strokeOpacity+","+strokeWeight+")" ) 
    }
    
    lay.DrawCircle = function( latitude, longitude, radius, strokeColor, strokeOpacity, strokeWeight, fillColor, fillOpacity ) {
        web.Execute("DrawCircle("+latitude+","+longitude+","+radius+",\""+strokeColor+"\","+strokeOpacity+","
            +strokeWeight+",\""+fillColor+"\","+fillOpacity+")" ) 
    }
    
    lay.IsLocationVisible = function( latitude, longitude, callback ) { 
        web.Execute("IsLocationVisible("+latitude+","+longitude+")", callback ) 
    }
    
    lay.AddMarker = function( title, id, latitude, longitude, options ) { 
        web.Execute("AddMarker(\""+title+"\",\""+id+"\","+latitude+","+longitude+",\""+options+"\")") 
    }
    
    //Return the wrapper layout control.
    return lay
}


