// *    Author: MasterOS

app.LoadPlugin( "Support" );
// global var to save. confirm. compare.
var mypin="123456";
var verify_mypin="";

//Called when application is started.
function OnStart() {
    //Create a layout with objects vertically centered.
    lay = app.CreateLayout( "linear", "VCenter,FillXY" );    
    //Create a text label and add it to layout.
    txt = app.CreateText( "PIN CODE test" );
    txt.SetTextSize( 32 );
    lay.AddChild( txt );
    
    //Add layout to app.    
    app.AddLayout( lay );

    // call our function. confirm. compare both.
    EnableGetPincode();
PinCode(6,"");

}

 sup = app.CreateSupport();

// called if user completed entry on pin code.
function pincodeComplete () {
    if (mypin==""){
        mypin=GetPincodeSecret();
        PinCode(6,"");
    }
    if (mypin>"") { 
        verify_mypin=GetPincodeSecret();
        if ((mypin>"") && (verify_mypin>"")){
            if (mypin==verify_mypin)
             sup.Alert( "PIN Code match\n"+"Code entered was: " +mypin, "Confirm", "Close" );
            else
                sup.Alert( "PIN Codes not match\n" +"1st Code:  " +"******"+"\n2nd Code: "+verify_mypin, "Wrong", "Close" );
           
        }
    }
}

//Author: MasterOS

// pincode position
var obj_pincode = {"pos":1, "len":0, "disp":false, "sound": true, "userget":false, "secret":"", "pin":[]};
var button = app.CreateMediaPlayer();
    button.SetFile("Snd/button_click.mp3");

// pincode length size. dialog msg (ei. getting, resetting, confirming)
function PinCode(size,diamsg,option) {
    var ar_pinBtn = [];
    
    // minimum pincode length should be 4
    // maximum pincode length can be 15
    // larger than that it goes off the screen on a 5" phone
    if ((size<4) || (size>15)) {
        alert("Minimum PIN Code length should be 4, Maximum can be up to 15");
        return;
    }
    
    // reset entries when this is called. dont reset the sound
    obj_pincode.pos=0;        // reset to start pos
    obj_pincode.len=size;   // size of secret code
    obj_pincode.disp=false;   // dont display the secret
    obj_pincode.secret="";  // reset the secret code
    obj_pincode.pin=[];     // reset the pin code

    //Create dialog window.
    if (option=="notitle") 
        dlgTxt = app.CreateDialog( diamsg,"nocancel,notitle" );
    else
        dlgTxt = app.CreateDialog( diamsg,"nocancel" );
    
    //Create a layout for dialog.
    layV_pc = app.CreateLayout( "linear", "vertical,fillxy,left" );
    layV_pc.SetSize( 0.7,0.5 );
    dlgTxt.AddLayout( layV_pc );

    // show the pincode entry
    if (option=="notitle") {
        txt0 = app.CreateText( " PIN CODE ",0.6,-1,"fillx,center");
        txt0.SetTextSize(20);
        txt0.SetTextColor("#00FF00");
        txt0.SetBackColor("#00FF0000");
        txt0.SetPadding(0.05,0,0.05,0);
        layV_pc.AddChild(txt0);
    }

    // show the pincode entry
    ss="";
    for (i=0; i<obj_pincode.len; i++) {
        ss+="-";
        obj_pincode.pin.push("-");
    }

    layH0 = app.CreateLayout( "linear", "horizontal,fillx,center" );
    pincode = app.CreateText(ss,"fillx,center");
    pincode.SetTextColor( "#00ff00" );
    pincode.SetTextSize(40);
    layH0.AddChild( pincode );
    layV_pc.AddChild(layH0);
    
    // create the buttons
    for (i=0; i<=9; i++) {
        ar_pinBtn[i]= app.CreateButton( i, 0.2, 0.1);
        ar_pinBtn[i].num=i;
        ar_pinBtn[i].SetOnTouch(btn_pincode);
    }
    
    // create the display or hide code button
    ar_pinBtn[10]=app.CreateButton( "❓", 0.2,0.1);
    ar_pinBtn[10].num=10;
    ar_pinBtn[10].SetOnTouch(btn_pincode);
    
    // create the back key
    ar_pinBtn[11]=app.CreateButton( "⬅", 0.2,0.1);
    ar_pinBtn[11].num=11;
    ar_pinBtn[11].SetOnTouch(btn_pincode);

    layH1 = app.CreateLayout( "linear", "horizontal,fillx,center" );
    layH2 = app.CreateLayout( "linear", "horizontal,fillx,center" );
    layH3 = app.CreateLayout( "linear", "horizontal,fillx,center" );
    layH4 = app.CreateLayout( "linear", "horizontal,fillx,center" );

    // make the buttons. reccursive 3 rows
    for (i=1; i<=3; i++) {
        for (ii=1; ii<=3; ii++) {
            switch (i) {
                case 1:
                    layH1.AddChild(ar_pinBtn[ii]);
                    break;
                case 2:
                    layH2.AddChild(ar_pinBtn[3+ii]);
                    break;
                case 3:
                    layH3.AddChild(ar_pinBtn[6+ii]); 
                    break;
            }
                    
        }
    }

    // make the last row of buttons
    layV_pc.AddChild(layH1);
    layV_pc.AddChild(layH2);
    layV_pc.AddChild(layH3);
    layH4.AddChild( ar_pinBtn[10] );
    layH4.AddChild( ar_pinBtn[0] );
    layH4.AddChild( ar_pinBtn[11] );
    layV_pc.AddChild(layH4);

    // Show dialog
    dlgTxt.Show();
} // function PinCode(size,diamsg,option)

// button press. do something
function btn_pincode () {
    
    // generate sound when we press a button
    if (obj_pincode.sound) {
        button.Stop(); button.Play();
    }
    
    // button press action here
    switch (this.num) {
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 0:
            obj_pincode.pin[obj_pincode.pos]=this.num;
            if (obj_pincode.pos<obj_pincode.len)
                obj_pincode.pos++;
            break;
        case 10:
            if (obj_pincode.disp)
                obj_pincode.disp=false;
            else
                obj_pincode.disp=true;
            break;
        case 11:
            if (obj_pincode.pos>0)
                obj_pincode.pos--;
            obj_pincode.pin[obj_pincode.pos]="-";
            break;
    }

    // display the pin code or display secret
    var ss="";
    if (obj_pincode.disp) {
        for (i=0; i<obj_pincode.len; i++) {
            ss+=obj_pincode.pin[i];
        }
    } else {
        for (i=0; i<obj_pincode.len; i++) {
            if (obj_pincode.pin[i]=="-")
                ss+=obj_pincode.pin[i];
            else
                ss+="●";
        }
    }
    pincode.SetText(ss);

    // pincode complete. save the secret
    if (obj_pincode.pos==obj_pincode.len) {
        var ss="";
        for (i=0; i<obj_pincode.len; i++) {
            ss+=obj_pincode.pin[i];
        }
        obj_pincode.secret=ss;
        dlgTxt.Hide();
        dlgTxt.Destroy();
        app.RemoveLayout(dlgTxt);
        app.RemoveLayout(layV_pc);
        
        // call the user function after pin code completion
        // if the user want something done
        if ((obj_pincode.userget) && (obj_pincode.pos==obj_pincode.len))
            pincodeComplete();
    }
} // function btn_pincode ()

// output the secret code as string
function GetPincodeSecret () {
    return obj_pincode.secret;
}

// enable sound or silent pincode entry
function pincodeSound (snd) {
    obj_pincode.sound = snd;
}

// enable user to handle something after competion of pincode
function EnableGetPincode () {
    obj_pincode.userget = true;
}