<?php

include_once '../sys/inc/start.php';
$doc = new document(groups::max());
$doc->title = 'Список изменений';


$files = array();
$files_g = (array) glob(H . '/sys/docs/changelog/*.txt');
foreach ($files_g as $path) {
    if (preg_match("#([^/]*?)\.txt#", $path, $m)) {
        $files[] = $m[1];
    }
}

$files = array_reverse($files);

if (!empty($_GET['ver'])) {
    if (!in_array($_GET['ver'], $files)) {
        $doc->err('Список изменения к данной версии не найден');
    } else {
        $fname = $_GET['ver'];
        $bb = new bb(H . '/sys/docs/changelog/'.$fname.'.txt');
        if ($bb->title) {
            $doc->title = $bb->title;
        }
        $bb->display();
        $doc->ret('Список версий', '?');
        $doc->ret('Админка', './');
        exit;
    }
}

$posts = array();

$icon = array('size' => 'small', 'src' => '/sys/images/icons/changelog.png');
foreach ($files AS $name) {
    $posts[] = array('title' => '<a href="?ver=' . urlencode($name) . '">' . for_value($name) . '</a>', 'icon' => $icon, 'url' => '?ver=' . urlencode($name));
}
if (!$posts) {
    $posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Списки отсутствуют');
}
$show = new design();
$show->assign('post', $posts);
$show->display('design.listing.tpl');
$doc->ret('Админка', './');
?>
