<?php
include_once '../sys/inc/start.php';
dpanel::check_access();
$doc = new document(6);
$doc->title = 'Загрузка таблиц';

$tables_exists = new tables();
$table_files = (array)glob(H . '/sys/preinstall/base.create.*.ini');
$tables = array();
foreach ($table_files as $table_file) {
    preg_match('#base.create\.(.+)\.ini#ui', $table_file, $m);
    $tables[] = $m[1];
}

if (!empty($_POST)) {
    foreach ($_POST as $table => $val) {
        // echo $table."<br />";
        if (!$val)continue;
        if (in_array($table, $tables)) {
            if (function_exists('set_time_limit'))set_time_limit(600);

            if (!empty($_POST['load'])) {
                if (!is_file(H . '/sys/preinstall/base.create.' . $table . '.ini'))continue;

                $tab = new table_structure(H . '/sys/preinstall/base.create.' . $table . '.ini');
                $sql = $tab->getSQLQueryCreate();
                // если такая таблица уже существует, то переименовываем ее
                if (in_array($table, $tables_exists->tables)) {
                    mysql_query("ALTER TABLE `" . my_esc($table) . "` RENAME `" . '~' . TIME . '~' . my_esc($table) . "`");
                    $doc->msg('Существующая таблица "' . $table . '" была переименована');
                }

                if (mysql_query($sql)) {
                    $doc->msg('Запрос на создание таблицы "' . $table . '" успешно выполнен');
                    $tables_exists = new tables();
                    if (in_array($table, $tables_exists->tables))
                        $doc->msg('Таблица "' . $table . '" успешно создана');
                    else
                        $doc->err('Таблица "' . $table . '" не создана');
                }
            }
        }
    }
}

$posts = array();

foreach ($tables as $table) {
    $posts[] = array('title' => $table, 'checkbox' => array('name' => $table, 'checked' => !in_array($table, $tables_exists->tables)));
}

if (!$posts)$posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Таблицы отсутствуют');

$show = new design();
$show->assign('post', $posts);
echo "<form method='post' action='?" . passgen() . "'>";
$show->display('design.listing.tpl');
echo "* При совпадении имени загружаемой таблицы с существующей, существующая таблица будет переименована.<br />";
echo "** Проверяются файлы sys/preinstall/base.create.[имя таблицы].ini<br />";
echo "<input type='submit' name='load' value='Загрузить' /></form>";

$doc->ret('Админка', './');

?>
