<?php

include_once '../sys/inc/start.php';
dpanel::check_access();
$doc = new document(6);
$groups = groups::load_ini();
$doc->title = 'Редактор меню';
// поиск файлов меню, подготовка списка (массива)
$menu_files = (array) glob(H . '/sys/ini/menu.*.ini');
$menus = array();
foreach ($menu_files as $menu_path) {
    if (!preg_match('#menu\.(.+?)\.ini$#ui', $menu_path, $m))
        continue;
    $menus[] = $m[1];
}

if (!empty($_GET['menu'])) {
    $menu = (string) $_GET['menu'];

    if (!in_array($menu, $menus)) {
        $doc->err('Запрошенное меню не найдено');
        exit;
    }
    $doc->title = 'Меню "' . $menu . '" - редактирование';
    $m_obj = new menu($menu);

    if (!empty($_GET['item'])) {
        $item_name = (string) $_GET['item'];
        if (!isset($m_obj->menu_arr[$item_name])) {
            $doc->err('Ошибка при выборе пункта меню');
        }

        $item = $m_obj->menu_arr[$item_name];
        $doc->title = 'Меню: "' . $menu . '" - ' . $item_name;
        if (!empty($_POST['delete'])) {
            if (empty($_POST['captcha']) || empty($_POST['captcha_session']) || !captcha::check($_POST['captcha'], $_POST['captcha_session'])) {
                $design->err('Проверочное число введено неверно');
            } else {
                $ini = ini::read(H . '/sys/ini/menu.' . $menu . '.ini', true);
                unset($ini[$item_name]);
                if (ini::save(H . '/sys/ini/menu.' . $menu . '.ini', $ini, true)) {
                    $doc->msg('Пункт меню успешно удален');
                } else {
                    $doc->err('Ошибка при сохранении файла');
                }
                header('Refresh: 1; url=?menu=' . urlencode($menu) . '&amp;' . passgen());
                $doc->ret('Меню "' . $menu . '"', '?menu=' . urlencode($menu) . '&amp;' . passgen());
                $doc->ret('Список меню', '?' . passgen());
                $doc->ret('Админка', './?' . passgen());
                exit;
            }
        }
        if (!empty($_POST['save'])) {
            $name = text::input_text(@$_POST['name']);
            $url = text::input_text(@$_POST['url']);
            $icon = text::input_text(@$_POST['icon']);
            $razdel = (int) !empty($_POST['razdel']);
            $is_vip = (int) !empty($_POST['is_vip']);
            $group = (int) @$_POST['group'];
            $position = (int) @$_POST['position'];
            if (empty($name)) {
                $doc->err('Название не может быть пустым');
            } elseif ($name != $item_name && isset($m_obj->menu_arr[$name])) {
                $doc->err('Выбранное название меню уже занято');
            } else {
                $ini = ini::read(H . '/sys/ini/menu.' . $menu . '.ini', true);
                if ($name != $item_name) {
                    unset($ini[$item_name]);
                }



                $ini[$name] = array('url' => $url,
                    'icon' => $icon,
                    'razdel' => $razdel,
                    'is_vip' => $is_vip,
                    'group' => $group
                );
                arraypos::setPosition($ini, $name, $position);
                if (ini::save(H . '/sys/ini/menu.' . $menu . '.ini', $ini, true)) {
                    $doc->msg('Изменения успешно приняты');
                } else {
                    $doc->err('Ошибка при сохранении файла');
                }
                header('Refresh: 1; url=?menu=' . urlencode($menu) . '&amp;' . passgen());
                $doc->ret('Меню "' . $menu . '"', '?menu=' . urlencode($menu) . '&amp;' . passgen());
                $doc->ret('Список меню', '?' . passgen());
                $doc->ret('Админка', './?' . passgen());
                exit;
            }
        }



        if (isset($_GET['act']) && $_GET['act'] == 'delete') {
            $doc->title = 'Удаление пункта ' . $item_name;
            $smarty = new design();
            $smarty->assign('method', 'post');
            $smarty->assign('action', '?menu=' . urlencode($menu) . '&amp;item=' . urlencode($item_name) . '&amp;' . passgen());
            $elements = array();
            $elements[] = array('type' => 'captcha', 'session' => captcha::gen(), 'br' => 1);
            $elements[] = array('type' => 'submit', 'br' => 0, 'info' => array('name' => 'delete', 'value' => 'Удалить')); // кнопка
            $smarty->assign('el', $elements);
            $smarty->display('input.form.tpl');
        } else {


            $form = new design ();
            $form->assign('method', 'post');
            $form->assign('action', '?menu=' . urlencode($menu) . '&amp;item=' . urlencode($item_name) . '&amp;' . passgen());
            $elements = array();

            $elements [] = array('type' => 'input_text', 'title' => 'Название', 'br' => 1, 'info' => array('name' => 'name', 'value' => $item_name));
            $elements [] = array('type' => 'input_text', 'title' => 'Позиция', 'br' => 1, 'info' => array('name' => 'position', 'value' => arraypos::getPosition($m_obj->menu_arr, $item_name)));
            $elements [] = array('type' => 'input_text', 'title' => 'Ссылка', 'br' => 1, 'info' => array('name' => 'url', 'value' => $item['url']));


            $icons = (array) glob(H . '/sys/images/icons/*.png');
            $options = array();
            $options[] = array('', '[Отсутствует]');
            foreach ($icons as $icon_path) {
                $icon = str_replace(H . '/sys/images/icons/', '', filesystem::unixpath($icon_path));
                $options[] = array($icon, $icon, $icon == @$item['icon']);
            }
            $elements[] = array('type' => 'select', 'br' => 1, 'title' => 'Иконка', 'info' => array('name' => 'icon', 'options' => $options));

            $elements [] = array('type' => 'checkbox', 'br' => 1, 'info' => array('value' => 1, 'checked' => @$item['razdel'], 'name' => 'razdel', 'text' => 'Разделитель'));
            $elements [] = array('type' => 'checkbox', 'br' => 1, 'info' => array('value' => 1, 'checked' => @$item['is_vip'], 'name' => 'is_vip', 'text' => 'Только для VIP'));

            $options = array();
            foreach ($groups as $group => $value) {
                $options[] = array($group, $value['name'], $group == @$item['group']);
            }
            $elements[] = array('type' => 'select', 'br' => 1, 'title' => 'Для группы (и выше)*', 'info' => array('name' => 'group', 'options' => $options));


            $elements[] = array('type' => 'text', 'value' => '* Регулируется только отображение ссылки.', 'br' => 1);
            $elements [] = array('type' => 'submit', 'br' => 0, 'info' => array('name' => 'save', 'value' => 'Применить')); // кнопка
            $form->assign('el', $elements);
            $form->display('input.form.tpl');
        }




        $doc->ret('Меню "' . $menu . '"', '?menu=' . urlencode($menu) . '&amp;' . passgen());
        $doc->ret('Список меню', '?' . passgen());
        $doc->ret('Админка', './?' . passgen());
        exit;
    }

    if (isset($_GET['item_add'])) {
        $doc->title = 'Новый пункт меню ' . $menu;
        if (!empty($_POST['create'])) {
            $name = text::input_text(@$_POST['name']);
            $url = text::input_text(@$_POST['url']);
            $icon = text::input_text(@$_POST['icon']);
            $razdel = (int) !empty($_POST['razdel']);
            $is_vip = (int) !empty($_POST['is_vip']);
            $group = (int) @$_POST['group'];
            $position = (int) @$_POST['position'];
            if (empty($name)) {
                $doc->err('Название не может быть пустым');
            } elseif (isset($m_obj->menu_arr[$name])) {
                $doc->err('Выбранное название меню уже занято');
            } else {
                $ini = ini::read(H . '/sys/ini/menu.' . $menu . '.ini', true);


                $ini[$name] = array('url' => $url,
                    'icon' => $icon,
                    'razdel' => $razdel,
                    'is_vip' => $is_vip,
                    'group' => $group
                );
                arraypos::setPosition($ini, $name, $position);
                if (ini::save(H . '/sys/ini/menu.' . $menu . '.ini', $ini, true)) {
                    $doc->msg('Изменения успешно приняты');
                } else {
                    $doc->err('Ошибка при сохранении файла');
                }
                header('Refresh: 1; url=?menu=' . urlencode($menu) . '&amp;' . passgen());
                $doc->ret('Меню "' . $menu . '"', '?menu=' . urlencode($menu) . '&amp;' . passgen());
                $doc->ret('Список меню', '?' . passgen());
                $doc->ret('Админка', './?' . passgen());
                exit;
            }
        }







        $form = new design ();
        $form->assign('method', 'post');
        $form->assign('action', '?menu=' . urlencode($menu) . '&amp;item_add&amp;' . passgen());
        $elements = array();

        $elements [] = array('type' => 'input_text', 'title' => 'Название', 'br' => 1, 'info' => array('name' => 'name'));
        $elements [] = array('type' => 'input_text', 'title' => 'Позиция', 'br' => 1, 'info' => array('name' => 'position', 'value' => count($m_obj->menu_arr) + 1));
        $elements [] = array('type' => 'input_text', 'title' => 'Ссылка', 'br' => 1, 'info' => array('name' => 'url', 'value' => 'http://'));


        $icons = (array) glob(H . '/sys/images/icons/*.png');
        $options = array();
        $options[] = array('', '[Отсутствует]');
        foreach ($icons as $icon_path) {
            $icon = str_replace(H . '/sys/images/icons/', '', filesystem::unixpath($icon_path));
            $options[] = array($icon, $icon);
        }
        $elements[] = array('type' => 'select', 'br' => 1, 'title' => 'Иконка', 'info' => array('name' => 'icon', 'options' => $options));

        $elements [] = array('type' => 'checkbox', 'br' => 1, 'info' => array('value' => 1, 'name' => 'razdel', 'text' => 'Разделитель'));
        $elements [] = array('type' => 'checkbox', 'br' => 1, 'info' => array('value' => 1, 'name' => 'is_vip', 'text' => 'Только для VIP'));

        $options = array();
        foreach ($groups as $group => $value) {
            $options[] = array($group, $value['name']);
        }
        $elements[] = array('type' => 'select', 'br' => 1, 'title' => 'Для группы (и выше)*', 'info' => array('name' => 'group', 'options' => $options));
        $elements[] = array('type' => 'text', 'value' => '* Регулируется только отображение ссылки.', 'br' => 1);
        $elements [] = array('type' => 'submit', 'br' => 0, 'info' => array('name' => 'create', 'value' => 'Создать')); // кнопка
        $form->assign('el', $elements);
        $form->display('input.form.tpl');

        $doc->ret('Меню "' . $menu . '"', '?menu=' . urlencode($menu) . '&amp;' . passgen());
        $doc->ret('Список меню', '?' . passgen());
        $doc->ret('Админка', './?' . passgen());
        exit;
    }


    if (isset($_GET['up']) || isset($_GET['down'])) {
        $ini = ini::read(H . '/sys/ini/menu.' . $menu . '.ini', true);

        if (isset($_GET['up'])) {
            $item_name = $_GET['up'];
            if (misc::array_key_move($ini, $item_name, - 1)) {
                $doc->msg('Пункт "' . $item_name . '" успешно перемещен вверх');
            } else {
                $doc->err('Пункт "' . $item_name . '" уже находится вверху');
            }
        }

        if (isset($_GET['down'])) {
            $item_name = $_GET['down'];
            if (misc::array_key_move($ini, $item_name, 1)) {
                $doc->msg('Пункт "' . $item_name . '" успешно перемещен вниз');
            } else {
                $doc->err('Пункт "' . $item_name . '" уже находится внизу');
            }
        }
        if (ini::save(H . '/sys/ini/menu.' . $menu . '.ini', $ini, true)) {
            $doc->msg('Изменения успешно приняты');
        } else {
            $doc->err('Ошибка при сохранении файла');
        }
        $m_obj = new menu($menu);
    }

    $posts = array();

    foreach ($m_obj->menu_arr as $name => $item) {
        $title = '<a href="?menu=' . urlencode($menu) . '&amp;item=' . urlencode($name) . '">' . for_value($name) . '</a>'; // заголовок
        $icon = false; // иконка
        $new = false;
        $act = array();
        $act[] = array('up', '?menu=' . urlencode($menu) . '&amp;up=' . urlencode($name) . '&amp;' . passgen());
        $act[] = array('down', '?menu=' . urlencode($menu) . '&amp;down=' . urlencode($name) . '&amp;' . passgen());
        $act[] = array('delete', '?menu=' . urlencode($menu) . '&amp;item=' . urlencode($name) . '&amp;act=delete&amp;' . passgen());
        if (empty($item['razdel'])) {
            $post = "Ссылка: $item[url]\n";
            if (!empty($item['icon'])) {
                $icon = array('size' => 'small', 'src' => '/sys/images/icons/' . $item['icon']);
            }
        } else {
            $post = "[b]Разделитель[/b]\n";
            $new = true;
        }

        if (!empty($item['for_vip'])) {
            $post .= "Только для [b]VIP[/b]-пользователей\n";
        }

        if (!empty($item['group'])) {
            $post .= "Только для группы [b]" . groups::name($item['group']) . "[/b] ($item[group])\n";
        }

        $posts[] = array('title' => $title, 'icon' => $icon, 'post' => output_text($post), 'url' => '?menu=' . urlencode($menu) . '&amp;item=' . urlencode($name), 'act' => $act, 'new' => $new);
    }

    if (!$posts)
        $posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'),
            'title' => 'Меню пусто');

    $show = new design();
    $show->assign('post', $posts);
    $show->display('design.listing.tpl');

    $doc->act('Добавить пункт', '?menu=' . urlencode($menu) . '&amp;item_add&amp;' . passgen());


    $doc->ret('Список меню', '?' . passgen());
    $doc->ret('Админка', './?' . passgen());
    exit;
}

$posts = array();
$icon = array('size' => 'small', 'src' => '/sys/images/icons/menu.editor.png');
foreach ($menus as $menu) {
    $posts[] = array('title' => '<a href="?menu=' . urlencode($menu) . '">' . for_value($menu) . '</a>', 'url' => '?menu=' . urlencode($menu), 'icon' => $icon);
}

if (!$posts) {
    $posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Нет меню для редактирования');
}
$show = new design();
$show->assign('post', $posts);
$show->display('design.listing.tpl');
$doc->ret('Админка', './?' . passgen());
?>