<?php

include_once 'sys/inc/start.php';
$doc = new document(1); // инициализация документа для браузера
$doc->title = 'Мой аватар';

$avatar_file_name = $user->id . '.jpg';
$avatars_path = FILES . '/.avatars'; // папка с аватарами
$avatars_dir = new files($avatars_path);



if (!empty($_FILES ['file'])) {
    if ($_FILES ['file'] ['error']) {
        $doc->err('Ошибка при загрузке');
    } elseif (!$_FILES ['file'] ['size']) {
        $doc->err('Содержимое файла пусто');
    } elseif (!preg_match('#\.jpe?g$#ui', $_FILES ['file'] ['name'])) {
        $doc->err('Неверное расширение файла');
    } elseif (!$img = @imagecreatefromjpeg($_FILES ['file'] ['tmp_name'])) {
        $doc->err('Файл не является изображением JPEG');
    } elseif (@imagesx($img) < 128) {
        $doc->err('Ширина изображения должна быть не менее 128 px');
    } elseif (@imagesy($img) < 128) {
        $doc->err('Высота изображения должна быть не менее 128 px');
    } else {
        if ($avatars_dir->is_file($avatar_file_name)) {
            $avatar = new files_file($avatars_path, $avatar_file_name);
            $avatar->delete(); // удаляем старый аватар
        }

        if ($files_ok = $avatars_dir->filesAdd(array($_FILES ['file'] ['tmp_name'] => $avatar_file_name))) {
            $files_ok [$_FILES ['file'] ['tmp_name']]->id_user = $user->id;
            $files_ok [$_FILES ['file'] ['tmp_name']]->group_edit = max($user->group, $album->group_write, 2);

            unset($files_ok);
            $doc->msg('Аватар успешно установлен');
        } else {
            $doc->err('Не удалось сохранить выгруженный файл');
        }
    }
}







// Аватар 
if ($path = $user->getAvatar($doc->img_max_width())) {


    if (!empty($_POST ['delete'])) {
        $avatar = new files_file($avatars_path, $avatar_file_name);
        if (empty($_POST ['captcha']) || empty($_POST ['captcha_session']) || !captcha::check($_POST ['captcha'], $_POST ['captcha_session']))
            $doc->err('Проверочное число введено неверно');
        elseif ($avatar->delete()) {
            $doc->msg('Аватар успешно удален');

            $doc->ret('Мой аватар', '?' . passgen());
            header('Refresh: 1; url=?' . passgen());
            exit;
        } else {

            $doc->err('Не удалось удалить аватар');
        }
    }




    echo "<img class='photo' src='" . $path . "' alt='Мой аватар' /><br />\n";

    $smarty = new design ();
    $smarty->assign('method', 'post');
    $smarty->assign('action', '?' . passgen());
    $elements = array();
    $elements [] = array('type' => 'captcha', 'session' => captcha::gen(), 'br' => 1);
    $elements [] = array('type' => 'submit', 'br' => 0, 'info' => array('name' => 'delete', 'value' => 'Удалить аватар')); // кнопка
    $smarty->assign('el', $elements);
    $smarty->display('input.form.tpl');
}


$smarty = new design ();
$smarty->assign('method', 'post');
$smarty->assign('files', 1);
$smarty->assign('action', '?' . passgen());
$elements = array();
$elements [] = array('type' => 'file', 'title' => 'Аватар (*.jpg)', 'br' => 1, 'info' => array('name' => 'file'));
$elements [] = array('type' => 'submit', 'br' => 0, 'info' => array('value' => 'Выгрузить')); // кнопка
$smarty->assign('el', $elements);
$smarty->display('input.form.tpl');
?>
