<?php
include_once '../sys/inc/start.php';
$doc = new document ();
$doc->title = 'Фотоальбомы';

if (! empty ( $_GET ['id'] )) {
	$ank = new user ( ( int ) $_GET ['id'] );
} else {
	$ank = $user;
}

if (! $ank->group) {
	$doc->access_denied ( 'Ошибка пользователя' );
}

if ($ank->id == $user->id) {
	$doc->title = 'Мои фотоальбомы';
} else {
	$doc->title = $ank->login . ' - Фотоальбомы';
}


$doc->description = 'Фотоальбомы пользователя '.$ank->login;
$doc->keywords[] = $ank->login;


// папка фотоальбомов пользователей
$photos = new files ( FILES . '/.photos' );
// папка альбомов пользователя
$albums_path = FILES . '/.photos/' . $ank->id;

if (! @is_dir ( $albums_path )) {
	if (! $albums_dir = $photos->mkdir ( $ank->login, $ank->id ))
		$doc->access_denied ( 'Не удалось создать папку под фотоальбомы пользователя' );
	$albums_dir->group_show = 0;
	$albums_dir->group_write = max ( $ank->group, 2 );
	$albums_dir->group_edit = max ( $ank->group, 4 );
	$albums_dir->id_user = $ank->id;
	unset ( $albums_dir );
}

$albums_dir = new files ( $albums_path );

// создание альбома
if ($ank->id == $user->id && ! empty ( $_GET ['act'] ) && $_GET ['act'] == 'create') {
	$doc->title .= ' - Новый альбом';
	
	if (! empty ( $_POST ['name'] )) {
		$name = text::for_name ( $_POST ['name'] );
		
		if (! $name)
			$doc->err ( 'Название состоит из запрещенных символов' );
		elseif (! $album = $albums_dir->mkdir ( $name ))
			$dir->err ( 'Не удалось создать альбом' );
		else {
			$doc->ret ( 'К альбому ' . $name, 'photos.php?id=' . $ank->id . '&mp;album=' . urlencode ( $album->name ) );
			$doc->ret ( 'К альбомам', '?id=' . $ank->id );
			header ( 'Refresh: 1; url=photos.php?id=' . $ank->id . '&album=' . urlencode ( $album->name ) );
			$doc->msg ( 'Альбом "' . $name . '" успешно создан' );
			exit ();
		}
	}
	
	$smarty = new design ();
	$smarty->assign ( 'method', 'post' );
	
	$smarty->assign ( 'action', '?id=' . $ank->id . '&amp;act=create&amp;' . passgen () );
	$elements = array ();
	
	$elements [] = array ('type' => 'input_text', 'title' => 'Название альбома', 'br' => 1, 'info' => array ('name' => 'name' ) );
	$elements [] = array ('type' => 'submit', 'br' => 0, 'info' => array ('value' => 'Создать' ) );
	$smarty->assign ( 'el', $elements );
	$smarty->display ( 'input.form.tpl' );
	
	$doc->ret ( 'К альбомам', '?id=' . $ank->id . '&amp;' . passgen () );
	exit ();
}

$content = $albums_dir->getList ( 'time_add:desc' );
$dirs = &$content ['dirs'];

$count = count ( $dirs );

for($i = 0; $i < $count; $i ++) {
	$posts [] = array ('icon' => $dirs [$i]->icon (), 'title' => "<a href='photos.php?id={$ank->id}&amp;album=" . urlencode ( $dirs [$i]->name ) . "'>" . for_value ( $dirs [$i]->runame ) . "</a>", 'post' => false );
}

if (! $posts) {
	$posts [] = array ('icon' => array ('size' => 'small', 'src' => '/sys/images/icons/empty.png' ), 'title' => 'Фотоальбомы отсутствуют' );
}

$show = new design ();
$show->assign ( 'post', $posts );
$show->display ( 'design.listing.tpl' );

if ($user->id == $ank->id) {
	$doc->act ( 'Создать альбом', '?id=' . $ank->id . '&amp;act=create' );
}

?>