<?php

include_once '../sys/inc/start.php';
$doc = new document ();
$doc->title = 'Фотоальбомы';



if (!empty($_GET ['id'])) {
    $ank = new user((int) $_GET ['id']);
} else {
    $ank = $user;
}

if (!$ank->group) {
    $doc->access_denied('Ошибка пользователя');
}

// папка фотоальбомов пользователей
$photos = new files(FILES . '/.photos');
// папка альбомов пользователя
$albums_path = FILES . '/.photos/' . $ank->id;

if (!@is_dir($albums_path)) {
    if (!$albums_dir = $photos->mkdir($ank->login, $ank->id)) {
        $doc->access_denied('Не удалось создать папку под фотоальбомы пользователя');
    }
    $albums_dir->group_show = 0;
    $albums_dir->group_write = max($ank->group, 2);
    $albums_dir->group_edit = max($ank->group, 4);
    $albums_dir->id_user = $ank->id;
    unset($albums_dir);
}

$albums_dir = new files($albums_path);

if (empty($_GET ['album']) || !$albums_dir->is_dir($_GET ['album'])) {
    $doc->err('Запрошеный альбом не существует');
    $doc->ret('К альбомам ' . $name, 'albums.php?id=' . $ank->id);
    header('Refresh: 1; url=albums.php?id=' . $ank->id);
    exit();
}

$album_name = (string) $_GET ['album'];
$album = new files($albums_path . '/' . $album_name);
$doc->title = $album->runame;

$doc->description = 'Фотоальбом пользователя ' . $ank->login . ':' . $album->runame;
$doc->keywords [] = $album->runame;
$doc->keywords [] = $ank->login;

if (!empty($_GET ['act']) && $ank->id == $user->id) {
    switch ($_GET ['act']) {
        case 'prop' :
            $doc->title .= ' - Параметры';

            $doc->ret('В альбом', '?id=' . $ank->id . '&amp;album=' . urlencode($album->name));
            exit();
        case 'photo_add' :
            $doc->title .= ' - Выгрузка фото';

            if (!empty($_FILES ['file'])) {
                if ($_FILES ['file'] ['error']) {
                    $doc->err('Ошибка при загрузке');
                } elseif (!$_FILES ['file'] ['size']) {
                    $doc->err('Содержимое файла пусто');
                } elseif (!preg_match('#\.jpe?g$#ui', $_FILES ['file'] ['name'])) {
                    $doc->err('Неверное расширение файла');
                } elseif (!$img = @imagecreatefromjpeg($_FILES ['file'] ['tmp_name'])) {
                    $doc->err('Файл не является изображением JPEG');
                } elseif (@imagesx($img) < 128) {
                    $doc->err('Ширина изображения должна быть не менее 128 px');
                } elseif (@imagesy($img) < 128) {
                    $doc->err('Высота изображения должна быть не менее 128 px');
                } else {
                    if ($files_ok = $album->filesAdd(array($_FILES ['file'] ['tmp_name'] => $_FILES ['file'] ['name']))) {
                        $files_ok [$_FILES ['file'] ['tmp_name']]->id_user = $ank->id;
                        $files_ok [$_FILES ['file'] ['tmp_name']]->group_edit = max($ank->group, $album->group_write, 2);

                        unset($files_ok);
                        $doc->msg('Фотография "' . $_FILES ['file'] ['name'] . '" успешно добавлена');
                    } else {
                        $doc->err('Не удалось сохранить выгруженный файл');
                    }
                }
            }

            $smarty = new design ();
            $smarty->assign('method', 'post');


            $smarty->assign('files', 1);
            $smarty->assign('action', '?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;act=photo_add&amp;' . passgen());
            $elements = array();
            $elements [] = array('type' => 'file', 'title' => 'Фотография (*.jpg)', 'br' => 1, 'info' => array('name' => 'file'));
            $elements [] = array('type' => 'submit', 'br' => 0, 'info' => array('value' => 'Выгрузить')); // кнопка
            $smarty->assign('el', $elements);
            $smarty->display('input.form.tpl');

            $doc->ret('В альбом', '?id=' . $ank->id . '&amp;album=' . urlencode($album->name));
            exit();
        case 'delete' :
            $doc->title .= ' - Удаление';

            if (!empty($_POST ['delete'])) {

                if (empty($_POST ['captcha']) || empty($_POST ['captcha_session']) || !captcha::check($_POST ['captcha'], $_POST ['captcha_session']))
                    $doc->err('Проверочное число введено неверно');
                elseif ($album->delete()) {
                    $doc->msg('Альбом успешно удален');
                    $doc->ret('Альбомы ' . $ank->login, 'albums.php?id=' . $ank->id);
                    header('Refresh: 1; url=albums.php?id=' . $ank->id . '&' . passgen());
                } else {

                    $doc->err('Не удалось удалить альбом');
                    $doc->ret('В альбом', '?id=' . $ank->id . '&amp;album=' . urlencode($album->name));
                    $doc->ret('Альбомы ' . $ank->login, 'albums.php?id=' . $ank->id);
                    header('Refresh: 1; url=?id=' . $ank->id . '&album=' . urlencode($album->name) . '&' . passgen());
                }

                exit();
            }

            $smarty = new design ();
            $smarty->assign('method', 'post');
            $smarty->assign('action', '?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;act=delete&amp;' . passgen());
            $elements = array();
            $elements [] = array('type' => 'captcha', 'session' => captcha::gen(), 'br' => 1);
            $elements [] = array('type' => 'submit', 'br' => 0, 'info' => array('name' => 'delete', 'value' => 'Удалить альбом')); // кнопка
            $smarty->assign('el', $elements);
            $smarty->display('input.form.tpl');

            $doc->ret('В альбом', '?id=' . $ank->id . '&amp;album=' . urlencode($album->name));
            exit();
    } // switch
}

$list = $album->getList('time_add:desc'); // получение содержимого папки альбома
$files = $list ['files']; // получение только файлов
$posts = array();
$pages = new pages ();
$pages->posts = count($files);
$pages->this_page();
$start = $pages->my_start();
$end = $pages->end();
for ($i = $start; $i < $end && $i < $pages->posts; $i++) {
    $post = '';

    if ($comments = $files [$i]->comments) {
        $post .= $comments . ' комментари' . misc::number($comments, 'й', 'я', 'ев') . "\n";
    }

    if ($properties = $files [$i]->properties) {
        // Параметры файла (только основное)
        $post .= $properties . "\n";
    }

    $posts [] = array('icon' => $files [$i]->icon(), 'title' => "<a href='photo.php?id=$ank->id&amp;album=" . urlencode($album->name) . "&amp;photo=" . urlencode($files [$i]->name) . "'>" . for_value($files [$i]->runame) . "</a>", 'post' => output_text($post));
}
if (!$posts)
    $posts [] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Фотографии отсутствуют');

$show = new design ();
$show->assign('post', $posts);
$show->display('design.listing.tpl');

$pages->listing('?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;'); // вывод страниц


if ($ank->id == $user->id) {
    $doc->act('Выгрузить фото', '?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;act=photo_add');
    $doc->act('Параметры', '?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;act=prop');
    $doc->act('Удалить альбом', '?id=' . $ank->id . '&amp;album=' . urlencode($album->name) . '&amp;act=delete');
}

$doc->ret('Альбомы ' . $ank->login, 'albums.php?id=' . $ank->id);
?>