<?php

list ( $msec, $sec ) = explode(chr(32), microtime()); // время запуска скрипта
define('DCMS', true);
define('REQUIRE_PHP_VERSION', '5.2'); // запрашиваемая версия PHP
define('TIME_START', $sec + $msec);
define('H', $_SERVER ['DOCUMENT_ROOT']); // корневая директория сайта
define('TEMP', H . '/sys/tmp'); // временная папка
define('TMP', H . '/sys/tmp'); // временная папка
// папка со всеми пользовательскими файлами
define('FILES', realpath(H . '/sys/files'));

define('TIME', time()); // временная метка unix
define('DAY_TIME', mktime(0, 0, 0)); // временная метка на начало текущих суток
define('IS_MAIN', $_SERVER ['SCRIPT_NAME'] == '/index.php'); // главная страница
// время жизни сессии, а также время последней активности пользователей, считающихся онлайн
define('SESSION_LIFE_TIME', 600);

define('SESSION_NAME', 'DCMS_SESSION'); // имя сессии
define('SESSION_ID_USER', 'DCMS_SESSION_ID_USER'); // ключ сессий, в котором хранится идентификатор пользователя
define('COOKIE_ID_USER', 'DCMS_COOKIE_ID_USER'); // идентификатор пользователя в COOKIE
define('COOKIE_USER_PASSWORD', 'DCMS_COOKIE_USER_PASSWORD'); // пароль пользователя в COOKIE


define('URL', urlencode($_SERVER ['REQUEST_URI']));

error_reporting(E_STRICT);

if (@function_exists('ini_set')) {
    ini_set('session.cache_expire', SESSION_LIFE_TIME);
    ini_set('date.timezone', 'Europe/Moscow');
    ini_set('ignore_repeated_errors', true);
    ini_set('display_errors', false);
}

if (function_exists('mb_internal_encoding')) {
    mb_internal_encoding('UTF-8');
}
if (function_exists('iconv')) {
    iconv_set_encoding('internal_encoding', 'UTF-8');
}

version_compare(phpversion(), REQUIRE_PHP_VERSION, '>=') or die('Требуется PHP >= ' . REQUIRE_PHP_VERSION);

// автоматическая загрузка классов
function dcmsAutoload($class_name) {
    @include_once (H . '/sys/plugins/classes/' . strtolower($class_name) . '.class.php');
}

spl_autoload_register('dcmsAutoload');

// генератор пароля
function passgen($len = 32) {
    $password = '';
    $small = 'abcdefghijklmnopqrstuvwxyz';
    $large = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $numbers = '1234567890';
    // $symbols='_)(%^*!-';
    for ($i = 0; $i < $len; $i++) {
        switch (mt_rand(1, 3)) {
            // case 4:$password.=$symbols[mt_rand(0,8)];break;
            case 3 :
                $password .= $large [mt_rand(0, 25)];
                break;
            case 2 :
                $password .= $small [mt_rand(0, 25)];
                break;
            case 1 :
                $password .= $numbers [mt_rand(0, 9)];
                break;
        }
    }
    return $password;
}

/* Переназначение функций */

// упрощенный вариант
function my_esc($str) {
    return mysql_real_escape_string($str);
}

// фильтрование текста для полей ввода
function for_value($text) {
    return text::for_value($text);
}

// фильтрование и форматирование текста
function output_text($text) {
    return text::output_text($text);
}

// получение названия месяца
function rus_mes($mes, $v = 1) {
    return misc::rus_mes($mes, $v);
}

// получение читабельного представления времени
function vremja($t) {
    return misc::vremja($t);
}

// размер данных в байтах, килобайтах, мегабайтах...
function size_data($filesize = 0) {
    return misc::size_data($filesize);
}

// запись массива в ini файл 
function ini_file_write($path, $array) {
    return ini::save($path, $array);
}

/* ---------------------- */

/* Инициализация механизма сессий  */
session_name(SESSION_NAME) or die('Невозможно инициализировать сессии');
@session_start() or die('Невозможно инициализировать сессии');
define('SESS', preg_replace('#[^a-z0-9]#i', '', session_id()));
/* ------------------------------- */

$cache = new cache (); // работа с кэшем


$dcms = new dcms (); // загрузка основного класса с настройками


$ban_by_ip = new ban_by_ip (); // бан по IP  (инициализация)
// бан по IP
if ($msg = $ban_by_ip->is_ban($dcms->ip_long))
    exit('Ваш IP адрес заблокирован. Причина: ' . $msg);
// Anti-DoS (не путать с DDoS) - Защита от большого кол-ва запросов с одного IP адреса
if ($dcms->antidos)
    $antidos = new antidos ();
// этот параметр будут влиять на счетчики
if ($dcms->new_time_as_date) {
    define('NEW_TIME', DAY_TIME); // новые файлы, темы и т.д. будут отображаться только за текущее число
} else {
    define('NEW_TIME', TIME - 86400); // новые файлы, темы и т.д. будут отображаться только за последние 24 часа
}

@mysql_connect($dcms->mysql_host, $dcms->mysql_user, $dcms->mysql_pass) or die('Нет соединения с сервером базы');
@mysql_select_db($dcms->mysql_base) or die('Нет доступа к выбранной базе данных');
mysql_query('SET NAMES "utf8"');

// отправка писем из очереди
mail::queue_process();

// запись рефералов
if ($dcms->log_of_referers)
    $log_of_referers = new log_of_referers ();
// запись посещений
if ($dcms->log_of_visits) {
    $log_of_visits = new log_of_visits ();
    // подведение итогов (хоть раз в сутки, чтобы не забивалась таблица)
    if (!$cache->get('log_of_visits')) {
        $cache_time = mt_rand(82800, 86400); // переменное время хранения кэша (от 23 до 24 часов)
        $log_of_visits->tally(); // подведение итогов (хоть раз в сутки, чтобы не забивалась таблица)
        $cache->set('log_of_visits', true, $cache_time);
    }
}

// очистка от устаревших временных файлов (чтобы не забивалась папка sys/tmp)
if ($dcms->clear_tmp_dir && !$cache->get('clear_tmp_dir')) {
    $cache_time = mt_rand(82800, 86400); // переменное время хранения кэша (от 23 до 24 часов)
    $cache->set('clear_tmp_dir', true, $cache_time);
    $old_files = filesystem::getOldTmpFiles();
    foreach ($old_files as $path) {
        @unlink($path);
    }
}
// авторизация пользователя
if (!empty($_SESSION [SESSION_ID_USER])) {
    // авторизация по сессии
    $user = new user($_SESSION [SESSION_ID_USER]);
} elseif (!empty($_COOKIE [COOKIE_ID_USER]) && !empty($_COOKIE [COOKIE_USER_PASSWORD]) && $_SERVER ['SCRIPT_NAME'] !== '/login.php' && $_SERVER ['SCRIPT_NAME'] !== '/captcha.php') {
    // авторизация по COOKIE (получение сессии, по которой пользователь авторизуется)
    $user = new user(false);
    header('Location: /login.php?return=' . URL);
    exit();
} else {
    // пользователь будет являться гостем
    $user = new user(false);
}
// удаляем сессию пользователя, если по ней не удалось авторизоваться
if (!$user->group && isset($_SESSION [SESSION_ID_USER])) {
    unset($_SESSION [SESSION_ID_USER]);
}
// удаление пользователей, вышедших из онлайна
mysql_query("DELETE FROM `users_online` WHERE `time_last` < '" . (TIME - SESSION_LIFE_TIME) . "'");
// обработка данных пользователя
if ($user->group) {
    $user->last_visit = TIME; // запись последнего посещения
    $user->conversions++; // счетчик посещений
    $q = mysql_query("SELECT * FROM `users_online` WHERE `id_user` = '{$user->id}' LIMIT 1");
    if (mysql_num_rows($q)) {
        mysql_query("UPDATE `users_online` SET `conversions` = `conversions` + '1' , `time_last` = '" . TIME . "', `id_browser` = '$dcms->browser_id', `ip_long` = '$dcms->ip_long', `request` = '" . my_esc($_SERVER ['REQUEST_URI']) . "' WHERE `id_user` = '$user->id' LIMIT 1");
    } else {
        mysql_query("INSERT INTO `users_online` (`id_user`, `time_last`, `time_login`, `request`, `id_browser`, `ip_long`) VALUES ('$user->id', '" . TIME . "', '" . TIME . "', '" . my_esc($_SERVER ['REQUEST_URI']) . "', '$dcms->browser_id', '$dcms->ip_long')");
        $user->count_visit++;
    }
} else {
    // обработка гостя
    // зачистка гостей, вышедших из онлайна
    mysql_query("DELETE FROM `guest_online` WHERE `time_last` < '" . (TIME - SESSION_LIFE_TIME) . "'");

    $q = mysql_query("SELECT * FROM `guest_online` WHERE `ip_long` = '{$dcms->ip_long}' AND `browser` = '" . my_esc($dcms->browser) . "' LIMIT 1");
    if (mysql_num_rows($q)) {
        mysql_query("UPDATE `guest_online` SET `time_last` = '" . TIME . "', `request` = '" . my_esc($_SERVER ['REQUEST_URI']) . "', `conversions` = `conversions` + 1 WHERE  `ip_long` = '{$dcms->ip_long}' AND `browser` = '{$dcms->browser}' LIMIT 1");
    } else {
        mysql_query("INSERT INTO `guest_online` (`ip_long`, `browser`, `time_last`, `time_start`, `request` ) VALUES ('{$dcms->ip_long}', '" . my_esc($dcms->browser) . "', '" . TIME . "', '" . TIME . "', '" . my_esc($_SERVER ['REQUEST_URI']) . "')");
    }
}

if ($user->is_ban_full && $_SERVER ['SCRIPT_NAME'] != '/ban.php') {
    // при полном бане никуда кроме страницы бана нельзя
    header('Location: /ban.php?' . SID);
    exit();
}
// включаем показ ошибок для создателя, если включено в админке
if ($dcms->display_errors && $user->group == groups::max() && @function_exists('ini_set')) {
    ini_set('display_errors', true);
}
?>