<?php

/**
 * bbcode
 * Обработка BBcode
 *
 * @package
 * @author Павлов Дмитрий
 * @copyright DCMS (c) 2011
 * @version $Id$
 * @access public
 */
abstract class bbcode {

    /**
     * bbcode::output()
     * Разбор кода
     *
     * @param string $str
     * @return string Отформатированный xHTML код
     */
    static public function output($str) {
        return preg_replace_callback('#
\[([a-z_0-9]+)
(=((?:&quot;|")?)
([^\]\3]+)
\3
)?
\]
(?:
(.+?)
(\[/\1\])
)?
#xuis', array('bbcode', 'back'), $str);
    }

    /**
     * bbcode::back()
     * применение действий к строке в зависимости от тега
     *
     * @param array $in
     * @return string отформатированный код
     */
    static private function back($in) {

        if (!trim($in [5])) {
            $icons = array('fix', 'del', 'change', 'add', 'secure');
            if (in_array($in [1], $icons)) {
                return '<img src="http://' . $_SERVER['HTTP_HOST'] . '/sys/images/icons/bb.' . $in [1] . '.png" alt="' . $in [1] . '" />';
            }
            return $in [0];
        }


        switch ($in [1]) {
            case 'nobb' :
                return (!empty($in [5]) ? $in [5] : $in [0]);
            case 'i' :
                if (!empty($in [5]))
                    return '<span style="font-style:italic">' . self::output($in [5]) . '</span>';
            case 'b' :
                if (!empty($in [5]))
                    return '<span style="font-weight:bold">' . self::output($in [5]) . '</span>';
            case 'u' :
                if (!empty($in [5]))
                    return '<span style="text-decoration:underline">' . self::output($in [5]) . '</span>';
            case 'no' :
                if (!empty($in [5]))
                    return '<span style="text-decoration:line-through">' . self::output($in [5]) . '</span>';
            case 'mark' :
                if (!empty($in [5]))
                    return '<span class="mark">' . self::output($in [5]) . '</span>';
            case 'url' :
                if (!empty($in [5]) && !empty($in [4]))
                    return self::url($in);
            case 'smile' :
                if (!empty($in [4]))
                    return self::smiles($in);
            case 'color' :
                if (!empty($in [5]) && !empty($in [4]))
                    return self::color($in);
            case 'php' :
                if (!empty($in [5]))
                    return self::code_php($in);
            case 'vremja' :
                if (!empty($in [5]) && is_numeric($in [5]))
                    return vremja($in [5]);
            case 'user' :
                if (!empty($in [5]) && is_numeric($in [5]))
                    return self::user($in [5]);
            case 'small' :
                if (!empty($in [5]))
                    return '<span style="font-size:xx-small">' . self::output($in [5]) . '</span>';
            case 'big' :
                if (!empty($in [5]))
                    return '<span style="font-size:xx-large">' . self::output($in [5]) . '</span>';
        }
        if (isset($in [5]) && preg_match('#quote(_([0-9]+))?#ui', $in [1]))
            return self::quote($in);

        return!empty($in [5]) ? self::output($in [5]) : $in [0];
    }

    /**
     * bbcode::quote()
     * Цитирование
     *
     * @return string
     */
    static private function quote($arr) {
        if (!empty($arr [4]) && preg_match('#^([0-9]+):([0-9]+):(.+)$#ui', $arr [4], $log))
            $title = "<span class='quote'><a href='/profile.view.php?id=$log[2]'>" . text::for_value($log [3]) . "</a> (" . vremja($log [1]) . ")</span>:";
        else
            $title = '';
        return '<div class="quote">' . $title . self::output($arr [5]) . '</div>';
    }

    /**
     * bbcode::code_php()
     * Подсветка PHP кода
     *
     * @return string
     */
    static private function code_php($arr) {
        $arr [5] = "<?php\n" . trim(preg_replace('#^\<\?(php)?|\?\>$#i', '', html_entity_decode($arr [5], ENT_QUOTES, 'UTF-8'))) . "\n?>";
        $code = highlight_string($arr [5], true);
        $code = preg_replace('#<code>(.*?)</code>#si', '<div class="code_php">\\1</div>', $code);
        $code = preg_replace("#[\n\r\t]+#", '', $code);
        return $code;
    }

    /**
     * bbcode::smiles()
     * Подстановка смайлов
     *
     * @return string
     */
    static private function smiles($arr) {
        return smiles::bbcode($arr);
        // return $arr[0];
    }

    /**
     * bbcode::url()
     * Обработка ссылок
     *
     * @return string
     */
    static private function url($arr) {
        if (empty($arr [4]) || empty($arr [5]))
            return $arr [0];
        global $dcms;
        $arr [4] = str_replace(array("\n", "\r", "\t"), '', $arr [4]);

        if (preg_match('#^ *(javascript|data)#', $arr [4]))
            return '!!! Javascript запрещен !!!';

        if (!preg_match('#://#', $arr [4]))
            return '<a href="' . preg_replace('#^http://' . preg_quote($_SERVER ['HTTP_HOST']) . '(/|$)#ui', '/', $arr [4]) . '">' . self::output($arr [5]) . '</a>';
        else
            return '<a' . (@$dcms->browser_type == 'web' ? ' target="_blank"' : null) . ' href="http://' . $_SERVER ['HTTP_HOST'] . '/link.ext.php?url=' . urlencode(html_entity_decode($arr [4])) . '">' . self::output($arr [5]) . '</a>';
    }

    /**
     * bbcode::color()
     * Применение цвета к тексту
     *
     * @return string
     */
    static private function color($arr) {
        if (preg_match('/^#[0-9a-f]{6}$/ui', $arr [4]))
            return '<span style="color:' . $arr [4] . '">' . $arr [5] . '</span>';
        return $arr [0];
    }

    /**
     * bbcode::user()
     * Вывод ника пользователя по ID
     *
     * @return string
     */
    static private function user($id) {
        $ank = new user($id);
        return '<a href="/profile.view.php?id=' . $ank->id . '">' . $ank->nick() . '</a>';
    }

}

?>