<?php
class check_sys {
    var $errors = array(); // ошибки, при кооторых система не может работать
    var $notices = array(); // ошибки, при которых система может работать нестабильно или могут не работать некоторые дополнительные возможности
    var $oks = array(); // отчет о работоспособности проверяемого модуля
    function __construct()
    {
        $this->_checkSys();
    }
    static public function getChmodErr($path, $errorIfNotExists = false)
    {
        $err = array();

        if (is_file(H . '/' . $path)) {
            if (!is_writable(H . '/' . $path))
                $err[] = 'Нет прав на запись: ' . $path;
        } elseif (is_dir(H . '/' . $path)) {
            $od = opendir(H . '/' . $path);
            while ($rd = readdir($od)) {
                if ($rd {
                        0} === '.')continue;
                $err = array_merge($err, self::getChmodErr($path . '/' . $rd, $errorIfNotExists));
            }
            closedir($od);
        } elseif ($errorIfNotExists) {
            $err[] = $path . ' отсутствует';
        }

        return $err;
    }

    protected function _checkSys()
    {
        // проверка версии PHP
        if (version_compare(phpversion(), REQUIRE_PHP_VERSION, '>='))
            $this->oks[] = 'PHP >= ' . REQUIRE_PHP_VERSION . ': ОК (' . phpversion() . ')';
        else
            $this->errors[] = 'Требуется PHP >= ' . REQUIRE_PHP_VERSION . ' (сейчас ' . phpversion() . ')';
        // проверка MySQL
        if (function_exists('mysql_info'))
            $this->oks[] = 'MySQL: OK';
        else
            $this->errors[] = 'Невозможно получить информацию о MySQL';
        // работа с графикой
        if (function_exists('gd_info'))
            $this->oks[] = 'GD: OK';
        else
            $this->errors[] = 'Нет библиотеки GD';
        // Работа с HTTP
        if (function_exists('curl_init'))
            $this->oks[] = 'cURL: OK';
        else
            $this->notices[] = 'Отсутствие cURL может вызвать проблемы с подключением к внешним ресурсам';
        // снятие ограничения по времени выполнения скрипта
        if (function_exists('set_time_limit'))
            $this->oks[] = 'set_time_limit: OK';
        else
            $this->notices[] = 'Функция set_time_limit() не доступна. Могут возникнуть проблемы при обработке ресурсоемких задач.';
        // функции для работы с UTF
        if (function_exists('mb_internal_encoding') && function_exists('iconv'))
            $this->oks[] = 'mbstring и Iconv: OK';
        elseif (!function_exists('mb_internal_encoding') && !function_exists('iconv'))
            $this->errors[] = 'Необходим по крайней мере один из модулей: mbstring или Iconv';
        elseif (function_exists('mb_internal_encoding'))
            $this->oks[] = 'mbstring: OK';
        elseif (function_exists('iconv'))
            $this->oks[] = 'Iconv: OK';
        // обработка видео (снятие скриншотов)
        if (class_exists('ffmpeg_movie'))
            $this->oks[] = 'FFmpeg: OK';
        else
            $this->notices[] = 'Без FFmpeg автоматическое создание скриношотов к видео недоступно';
      // передача сессии в URI
        if (ini_get('session.use_trans_sid'))
            $this->oks[] = 'session.use_trans_sid: OK';
        else
            $this->notice[] = 'Параметр session.use_trans_sid установлен в 0. Будет теряться сессия на браузерах без поддержки COOKIE';
        // экранирование кавычек'
        if (!ini_get('magic_quotes_gpc'))
            $this->oks[] = 'magic_quotes_gpc = 0: OK';
        else
            $this->notice[] = 'Параметр magic_quotes_gpc установлен в 1. Экранирование кавычек будет добавлять обратный слэш перед каждой кавычкой.';

        if (ini_get('arg_separator.output') == '&amp;')
            $this->oks[] = 'arg_separator.output: &amp;amp;: OK';
        else
            $this->notice[] = 'arg_separator.output: ' . output_text(ini_get('arg_separator.output')) . ' Возможно появление xml ошибок';
    }
}

?>
