<?php

/**
 * curl
 * Работа с HTTP протоколом
 * Преимущественно используется cURL (при отсутствии работа через сокеты)
 * @package
 * @author Дмитрий
 * @copyright Copyright (c) 2011
 * @version $Id$
 * @access public
 */
class curl {

    var $ua = 'DCMSSeven/cURLmodule'; // USER AGENT
    var $timeout = 3; // таймаут запроса (сек)
    var $location = false; // обработка переадресаций (только curl)
    var $referer = '';
    var $errn;
    var $errs;
    protected $_url;
    protected $_post = array(); // массив с POST
    protected $_cookie = array(); // массив с COOKIE
    protected $_curl_supported = false; // будет ли использоваться cURL
    protected $_curl_init = false;
    protected $_fsock = false;

    /**
     * curl::__construct()
     * Инициализация
     * @param string $url Запрашиваемый адрес
     */
    function __construct($url, $no_curl = false) {
        $this->_url = $url;

        if (!$no_curl && function_exists('curl_init')) {
            // если есть cURL, то будем пользоваться им
            $this->_curl_supported = true;
            $this->_curl_init = curl_init($this->_url);
        } else {
            // иначе будем работать напрямую через сокеты
            $purl = @parse_url($this->_url);
            if (!empty($purl['host'])) {
                $port = empty($purl['port']) ? 80 : $purl['port'];


                $scheme = empty($purl['scheme']) ? 'http' : $purl['scheme'] . '://';
                $this->_fsock = @fsockopen($scheme . $purl['host'], $port, $this->errn, $this->errs, $this->timeout);
            }
        }
    }

    /**
     * curl::set_post()
     * Установка переменной POST
     * @param string $name Название
     * @param string $value Значение
     * @return bool
     */
    public function set_post($name, $value = null) {
        $this->_post[] = urlencode($name) . '=' . urlencode($value);
    }

    /**
     * curl::set_cookie()
     * Установка переменной COOKIE
     * @param string $name Название
     * @param string $value Значение
     * @return bool
     */
    public function set_cookie($name, $value = null) {
        $this->_cookie[] = urlencode($name) . '=' . urlencode($value);
    }

    /**
     * curl::save_content()
     * Сохраняет полученную информацию в файл
     * @param string $file_path Путь к файлу
     * @return bool
     */
    public function save_content($file_path) {
        if (!$fo = @fopen($file_path, 'wb'))
            return false;

        if ($this->_curl_supported) {
            $this->_curlOptions();

            curl_setopt($this->_curl_init, CURLOPT_HEADER, false);
            curl_setopt($this->_curl_init, CURLOPT_NOBODY, false);
            curl_setopt($this->_curl_init, CURLOPT_RETURNTRANSFER, false);
            curl_setopt($this->_curl_init, CURLOPT_FILE, $fo);
            $ce = curl_exec($this->_curl_init);
            fclose($fo);
            return $ce;
        } elseif ($this->_fsock) {
            fputs($this->_fsock, $this->_getOutputHeaders());
            // echo nl2br($this -> _getOutputHeaders());
            // пропускаем заголовки
            while (!feof($this->_fsock)) {
                $data = fgets($this->_fsock, 2048);
                if ($data == "\r\n")
                    break;
            }
            // сохраняем контент
            while (!feof($this->_fsock)) {
                $data = fgets($this->_fsock, 4096);
                if (!@fwrite($fo, $data))
                    return false;
            }

            fclose($fo);
            return true;
        }
    }

    /**
     * curl::getHeaders()
     * Получение заголовков
     * @return string
     */
    public function getHeaders() {
        return $this->get_headers();
    }

    /**
     * curl::getContent()
     * Получение содержимого
     * @return string
     */
    public function getContent() {
        return $this->get_content();
    }

    /**
     * curl::get_content()
     * Получение содержимого
     * @return string
     */
    public function get_content() {
        if ($this->_curl_supported) {

            $this->_curlOptions();
            curl_setopt($this->_curl_init, CURLOPT_HEADER, false);
            curl_setopt($this->_curl_init, CURLOPT_NOBODY, false);
            curl_setopt($this->_curl_init, CURLOPT_RETURNTRANSFER, true);
            return curl_exec($this->_curl_init);
        } elseif ($this->_fsock) {
            $time_start = time();

            fputs($this->_fsock, $this->_getOutputHeaders());
            $content_all = '';
            while (!feof($this->_fsock) && $time_start - time() < $this->timeout) {
                $content_all .= fgets($this->_fsock, 4096);
            }
            list ($header, $content) = explode("\r\n\r\n", $content_all, 2);
            // echo $content;
            return $content;
        }
    }

    /**
     * curl::get_headers()
     * Получение заголовков
     * @return string
     */
    public function get_headers() {
        if ($this->_curl_supported) {
            $this->_curlOptions();
            curl_setopt($this->_curl_init, CURLOPT_HEADER, true);
            curl_setopt($this->_curl_init, CURLOPT_NOBODY, true);
            curl_setopt($this->_curl_init, CURLOPT_RETURNTRANSFER, true);
            return curl_exec($this->_curl_init);
        } elseif ($this->_fsock) {
            $time_start = time();

            fputs($this->_fsock, $this->_getOutputHeaders());
            $headers = '';
            while (!feof($this->_fsock) && $time_start - time() < $this->timeout) {
                $data = fgets($this->_fsock, 2048);
                if ($data == "\r\n")
                    break;
                $headers .= $data;
            }

            return $headers;
        }
    }

    /**
     * curl::_getOutputHeaders()
     * Формирование отправляемого заголовка
     * @return string
     */
    protected function _getOutputHeaders() {
        $headers = array();
        $purl = @parse_url($this->_url);
        $path = empty($purl['path']) ? '/' : $purl['path'];
        $query = empty($purl['query']) ? '' : '?' . $purl['query'];
        $headers[] = ($this->_post ? 'POST' : 'GET') . ' ' . $path . $query . ' HTTP/1.0';
        // Хост
        $host = empty($purl['host']) ? '' : $purl['host'];
        $headers[] = 'Host: ' . $host;


        // Реферер
        if ($this->referer)
            $headers[] = 'Referer: ' . $this->referer;
        // Печеньки
        if ($this->_cookie) {
            $headers[] = 'Cookie: ' . implode(';', $this->_cookie);
        }
        // Браузер
        if ($this->ua)
            $headers[] = 'User-Agent: ' . $this->ua;




        // формируем POST данные

        if ($this->_post) {
            $post_data = implode('&', $this->_post);
            $headers[] = 'Content-Type: application/x-www-form-urlencoded';
            $headers[] = 'Content-Length: ' . strlen($post_data);
        }
        // HTTP авторизация
        if (isset($purl['user']) && isset($purl['pass'])) {
            $headers[] = 'Authorization: Basic ' . base64_encode($purl['user'] . ':' . $purl['pass']);
        }
        // поддержание подключения (позволяет отправлять несколько запросов за одно подключение)
        $headers[] = 'Connection: Keep-Alive';
        $header = implode("\r\n", $headers) . "\r\n\r\n";
        // данные, переданные с помощью POST
        if (!empty($post_data))
            $header .= $post_data;

        // echo '<pre>'.print_r($header,true).'</pre>';


        return $header;
    }

    /**
     * curl::_curlOptions()
     * Установка опций для cURL
     * @return
     */
    protected function _curlOptions() {
        if ($this->_post) {
            curl_setopt($this->_curl_init, CURLOPT_POST, true);
            curl_setopt($this->_curl_init, CURLOPT_POSTFIELDS, implode('&', $this->_post));
        }

        if ($this->_cookie) {
            curl_setopt($this->_curl_init, CURLOPT_COOKIE, implode(';', $this->_cookie));
        }

        curl_setopt($this->_curl_init, CURLOPT_USERAGENT, $this->ua);
        curl_setopt($this->_curl_init, CURLOPT_TIMEOUT, $this->timeout);
        curl_setopt($this->_curl_init, CURLOPT_FOLLOWLOCATION, $this->location);
        curl_setopt($this->_curl_init, CURLOPT_REFERER, $this->referer);
    }

}

?>