<?php
include_once H . '/sys/plugins/smarty/Smarty.class.php';
class design extends Smarty {
	var $theme_obj;
	
	function __construct() {
		parent::__construct ();
		global $dcms, $user;
		
		static $theme, $theme_obj;
		$this->theme_obj = &$theme_obj;
		if (empty ( $theme )) {
			// попытка загрузить тему, выбранную пользователем
			$theme_obj = new theme ( $user->theme );
			if ($theme_obj->is_avaible ()) {
				$this->theme_obj = $theme_obj;
				$theme = $user->theme;
			} else {
				// попытка загрузить тему, выбранную по умолчанию для конкретного типа браузера
				$theme_obj = new theme ( $dcms->theme );
				if ($theme_obj->is_avaible ()) {
					$this->theme_obj = $theme_obj;
					$theme = $dcms->theme;
				} else {
					// поиск доступных тем для данного типа браузера
					if ($themes_list = $this->getThemes ( $dcms->browser_type )) {
						$theme_obj = new theme ( $themes_list [0] ['name'] );
						if ($theme_obj->is_avaible ()) {
							$this->theme_obj = $theme_obj;
							$theme = $themes_list [0] ['name'];
						} else {
							// поиск доступных тем не зависимо от браузера
							if ($themes_list = $this->getThemes ()) {
								$theme_obj = new theme ( $themes_list [0] ['name'] );
								if ($theme_obj->is_avaible ()) {
									$this->theme_obj = $theme_obj;
									$theme = $themes_list [0] ['name'];
								}
							}
						}
					}
				}
			}
		}
		$this->template_dir = H . '/sys/themes/' . $theme . '/tpl/';
		$this->compile_dir = H . '/sys/themes/' . $theme . '/tpl_c/';
		$this->config_dir = H . '/sys/themes/' . $theme . '/tpl_conf/';
		$this->cache_dir = H . '/sys/themes/' . $theme . '/tpl_cache/';
		
		$this->setCaching ( Smarty::CACHING_OFF );
		$this->setCompileCheck ( true );
		$this->allow_php_tag = true;
		$this->error_reporting = false;
		
		$this->assign ( 'URL', URL );
		$this->assignByRef ( 'theme', $this->theme_obj );
		$this->assignByRef ( 'dcms', $dcms );
		$this->assignByRef ( 'user', $user );
		$this->assign ( 'SESSION_NAME', SESSION_NAME );
		$this->assign ( 'SESS', SESS );
		$this->assign ( 'path', '/sys/themes/' . $theme );
	}
	// получение массива с темами
	function getThemes($type = 'all') {
		switch ($type) {
			case 'web' :
				$type = 'web';
				break;
			case 'pda' :
				$type = 'pda';
				break;
			case 'wap' :
				$type = 'wap';
				break;
			default :
				$type = 'all';
				break;
		}
		$themes = array ();
		$od = opendir ( H . '/sys/themes' );
		while ( $rd = readdir ( $od ) ) {
			if ($rd {0} == '.' || is_file ( H . '/sys/themes/' . $rd ))
				continue;
			
			$theme = new theme ( $rd );
			
			if ($theme->browser !== 'all' && $theme->browser !== $type)
				continue;
			$themes [] = array ('type' => $theme->browser, 'name' => $theme->name, 'runame' => $theme->runame, 'dir' => H . '/sys/themes/' . $rd );
		}
		closedir ( $od );
		return $themes;
	}
	
	function img_max_width() {
		global $dcms;
		return min ( $this->theme_obj->img_width_max, $dcms->img_max_width );
	}
}

?>