<?php
abstract class files_types {
    // для того, чтобы не читать файл при каждом вызове
    protected static function _getIni()
    {
        static $ini;
        if (!isset($ini))$ini = ini::read(H . '/sys/ini/files.types.ini', true);
        return $ini;
    }
    // получение обработчика описания файла по расширению файла из пути
    public static function getPropertiesType($path)
    {
        $pinfo = pathinfo(strtolower($path));
        $ini = self::_getIni();
        if (!empty($pinfo['extension']) && !empty($ini[$pinfo['extension']]['prop']))return $ini[$pinfo['extension']]['prop'];
    }
    // получение обработчика скриншота файла по расширению файла из пути
    public static function getScreenType($path)
    {
        $pinfo = pathinfo(strtolower($path));
        $ini = self::_getIni();
        if (!empty($pinfo['extension']) && !empty($ini[$pinfo['extension']]['screen']))return $ini[$pinfo['extension']]['screen'];
    }
    // получение типа иконки по расширению
    public static function getIconType($path)
    {
        $pinfo = pathinfo(strtolower($path));
        $ini = self::_getIni();
        if (!empty($pinfo['extension']) && !empty($ini[$pinfo['extension']]['icon']))return $ini[$pinfo['extension']]['icon'];
        return 'file';
    }
}

?>
