<?php
abstract class filesystem {
	
	// получение оптимального CHMOD, разрешающего запись
	static function getChmodToWrite($is_dir = false) {
		if (preg_match ( '#mpm#i', @$_SERVER ['SERVER_SOFTWARE'] )) {
			if ($is_dir) {
				return 0770;
			} else {
				return 0660;
			}
		
		} else {
			if ($is_dir) {
				return 0777;
			} else {
				return 0666;
			}
		}
	}
	
	// получение оптимального CHMOD, разрешающего чтение файла
	static function getChmodToRead($is_dir = false) {
		if (preg_match ( '#mpm#i', @$_SERVER ['SERVER_SOFTWARE'] )) {
			if ($is_dir) {
				return 0550;
			} else {
				return 0440;
			}
		
		} else {
			if ($is_dir) {
				return 0555;
			} else {
				return 0444;
			}
		}
	}
	
	// получаем путь в стиле *UNIX
	static function unixpath($path) {
		return str_replace ( '\\', '/', $path );
	}
	// создание папки с установкой прав на запись
	static function mkdir($p) {
		if (@mkdir ( $p, filesystem::getChmodToWrite ( true ) )) {
			@chmod ( $p, filesystem::getChmodToWrite ( true ) );
			return true;
		}
	}
	// рекурсивное удаление папки
	static function rmdir($dir, $delete_this_dir = true) {
		$dir = realpath ( $dir );
		$od = opendir ( $dir );
		while ( $rd = readdir ( $od ) ) {
			if ($rd == '.' || $rd == '..')
				continue;
			if (is_dir ( $dir . '/' . $rd )) {
				self::rmdir ( $dir . '/' . $rd );
			} else {
				chmod ( $dir . '/' . $rd, filesystem::getChmodToWrite () );
				unlink ( $dir . '/' . $rd );
			}
		}
		closedir ( $od );
		if ($delete_this_dir) {
			sleep ( 1 );
			chmod ( $dir, filesystem::getChmodToWrite ( 1 ) );
			return rmdir ( $dir );
		} else
			return true;
	}
	// получаем общий размер устаревших временных файлов
	static function getOldTmpFilesSize() {
		$files = self::getOldTmpFiles ();
		$size = 0;
		foreach ( $files as $path ) {
			$size += @filesize ( $path );
		}
		return $size;
	}
	// получаем список устаревших временных файлов в виде массива путей
	static function getOldTmpFiles() {
		$yesterday = TIME - 86400;
		$files = array ();
		
		// получаем список папок, в которых могут содержаться временные файлы
		$dirs = array (H . '/sys/tmp' );
		
		$th_o = opendir ( H . '/sys/themes' );
		while ( $th_r = readdir ( $th_o ) ) {
			if ($th_r {0} === '.')
				continue;
			if (! is_dir ( H . '/sys/themes/' . $th_r . '/tpl_cache' ))
				continue;
			$dirs [] = H . '/sys/themes/' . $th_r . '/tpl_cache';
		}
		closedir ( $th_o );
		
		
		$count = count ( $dirs );
		for($i = 0; $i < $count; $i ++) {
			$od = opendir ( $dirs [$i] );
			while ( $rd = readdir ( $od ) ) {
				if ($rd {0} === '.')
					continue;
				if (filemtime ( $dirs [$i] . '/' . $rd ) > $yesterday)
					continue;
				$files [] = $dirs [$i] . '/' . $rd;
			}
			closedir ( $od );
		}
		
		return $files;
	}
}

?>