<?php
/**
 * класс позволяет читать/сохранять массивы из/в INI файл(а)
 * (array) = ini::read(string file [, bool is_sectionize])
 * (bool) = ini::save(string file, array to_save[, bool is_sectionize])
 */
abstract class ini {
	static function value_encode($str) {
		$str = str_replace ( "\n", '\n', $str );
		$str = str_replace ( "\r", '\r', $str );
		return htmlentities ( $str, ENT_QUOTES, 'UTF-8' );
	}
	
	static function value_decode($str) {
		$str = str_replace ( '\n', "\n", $str );
		$str = str_replace ( '\r', "\r", $str );
		return html_entity_decode ( $str, ENT_QUOTES, 'UTF-8' );
	}
	static function read($file, $sect = false) {
		$arr = @parse_ini_file ( $file, $sect );
		
		if ($arr) {
			if ($sect) {
				foreach ( $arr as $key => $value ) {
					foreach ( $value as $key2 => $value2 ) {
						$arr [$key] [$key2] = self::value_decode ( $value2 );
					}
				}
			} else {
				foreach ( $arr as $key => $value ) {
					$arr [$key] = self::value_decode ( $value );
				}
			}
		}
		return $arr;
	}
	static function save($file, $array, $sect = false) {
		$ini = array ();
		
		if ($sect) {
			foreach ( $array as $key => $value ) {
				$ini [] = '[' . self::value_encode ( $key ) . ']';
				foreach ( $value as $key2 => $value2 ) {
					$ini [] = "$key2 = \"" . self::value_encode ( $value2, ENT_QUOTES, 'UTF-8' ) . "\";";
				}
			}
		} else {
			foreach ( $array as $key => $value ) {
				$ini [] = "$key = \"" . self::value_encode ( $value, ENT_QUOTES, 'UTF-8' ) . "\";";
			}
		}
		$result = @file_put_contents ( $file, implode ( "\r\n", $ini ) );
		@chmod ( $file, filesystem::getChmodToWrite () );
		return $result;
	}
}

?>
