<?php

abstract class misc {

    

    // перемещение ключа $key массива $array на $step шагов
    static function array_key_move(&$array, $key, $step = 1) {
        return arraypos::move(&$array, $key, $step);
    }

    static function number($num, $one, $two, $more) {
        $num = (int) $num;
        $l2 = substr($num, strlen($num) - 2, 2);

        if ($l2 >= 5 && $l2 <= 20)
            return $more;
        $l = substr($num, strlen($num) - 1, 1);
        switch ($l) {
            case 1:return $one;
                break;
            case 2:return $two;
                break;
            case 3:return $two;
                break;
            case 4:return $two;
                break;
            default:return $more;
                break;
        }
    }

    // получение возраста
    static function get_age($g, $m, $d, $read = 0) {
        if (strlen($g) == 2)
            $g += 1900;
        if (strlen($g) == 3)
            $g += 1000;
        $age = date('Y') - $g;
        if (date('n') < $m)
            $age--; // год не полный, если текущий месяц меньше
        elseif (date('n') == $m && date('j') < $d)
            $age--; // год не полный, если текущий месяц совпадает, но день меньше
        if ($read)
            return $age . ' ' . self::number($age, 'год', 'года', 'лет');

        return $age;
    }

    // читабельное представление размера информации
    static function size_data($filesize = 0) {
        $filesize_ed = 'байт';
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Кб';
        }
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Мб';
        }
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Гб';
        }
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Тб';
        }
        if ($filesize >= 1024) {
            $filesize = round($filesize / 1024, 2);
            $filesize_ed = 'Пб';
        }

        return $filesize . ' ' . $filesize_ed;
    }

    // читабельное представление времени
    static function vremja($time = null) {
        if ($time > TIME) {
            $time -= TIME;
            $mes = 0;
            $day = 0;
            $hour = 0;
            $min = 0;
            $sec = 0;
            if ($time)
                $sec = $time % 60;
            if ($time >= 60)
                $min = floor($time / 60 % 60);
            if ($time >= 3600)
                $hour = floor($time / 3600 % 24);
            if ($time >= 86400)
                $day = floor($time / 86400 % 30);
            if ($time >= 2592000)
                $mes = floor($time / 2592000 % 12);

            if ($mes)
                return $mes . ' месяц' . self::number($mes, '', 'а', 'ев') . ($day ? (', ' . $day . ' ' . self::number($day, 'день', 'дня', 'дней') . ($hour ? ' и ' . $hour . ' час' . self::number($hour, '', 'а', 'ов') : '')) : '');
            if ($day)
                return $day . ' ' . self::number($day, 'день', 'дня', 'дней') . ($hour ? (', ' . $hour . ' час' . self::number($hour, '', 'а', 'ов') . ($min ? ' и ' . $min . ' минут' . self::number($min, 'а', 'ы', '') : '')) : '');
            if ($hour)
                return $hour . ' час' . self::number($hour, '', 'а', 'ов') . ($min ? (', ' . $min . ' минут' . self::number($min, 'а', 'ы', '') . ($sec ? ' и ' . $sec . ' секунд' . self::number($sec, 'а', 'ы', '') : '')) : '');
            if ($min)
                return $min . ' минут' . self::number($min, 'а', 'ы', '') . ($sec ? ' и ' . $sec . ' секунд' . self::number($sec, 'а', 'ы', '') : '');
            return $sec . ' секунд' . self::number($sec, 'а', 'ы', '');
        } else {
            global $user;
            if (!$time)
                $time = TIME;
            if ($user->group)
                $time_shift = $user->time_shift;
            else
                $time_shift = 0;
            $time = $time + $time_shift * 3600;
            $vremja = date('j M Y в H:i', $time);
            $time_p[0] = date('j n Y', $time);
            $time_p[1] = date('H:i', $time);
            if ($time_p[0] == date('j n Y', TIME + $time_shift * 60 * 60))
                $vremja = date('H:i:s', $time);
            if ($time_p[0] == date('j n Y', TIME - 60 * 60 * (24 - $time_shift)))
                $vremja = "Вчера в $time_p[1]";
            $vremja = str_replace('Jan', 'Янв', $vremja);
            $vremja = str_replace('Feb', 'Фев', $vremja);
            $vremja = str_replace('Mar', 'Марта', $vremja);
            $vremja = str_replace('May', 'Мая', $vremja);
            $vremja = str_replace('Apr', 'Апр', $vremja);
            $vremja = str_replace('Jun', 'Июня', $vremja);
            $vremja = str_replace('Jul', 'Июля', $vremja);
            $vremja = str_replace('Aug', 'Авг', $vremja);
            $vremja = str_replace('Sep', 'Сент', $vremja);
            $vremja = str_replace('Oct', 'Окт', $vremja);
            $vremja = str_replace('Nov', 'Ноября', $vremja);
            $vremja = str_replace('Dec', 'Дек', $vremja);
            return $vremja;
        }
    }

    // вывод названия месяца по-русски
    static function rus_mes($num, $v = 1) {
        switch ($num) {
            case 1:return 'Январ' . ($v ? 'я' : 'ь');
            case 2:return 'Феврал' . ($v ? 'я' : 'ь');
            case 3:return 'Март' . ($v ? 'а' : '');
            case 4:return 'Апрел' . ($v ? 'я' : 'ь');
            case 5:return 'Ма' . ($v ? 'я' : 'й');
            case 6:return 'Июн' . ($v ? 'я' : 'ь');
            case 7:return 'Июл' . ($v ? 'я' : 'ь');
            case 8:return 'Август' . ($v ? 'а' : '');
            case 9:return 'Сентябр' . ($v ? 'я' : 'ь');
            case 10:return 'Октябр' . ($v ? 'я' : 'ь');
            case 11:return 'Ноябр' . ($v ? 'я' : 'ь');
            case 12:return 'Декабр' . ($v ? 'я' : 'ь');
            default:return false;
        }
    }

}

?>