<?php

class piechart extends chart {
    var $font_color = array(44, 39, 135);
    var $bg_color = array(255, 255, 255);

    private $img; // изображение
    private $w; // ширина изображения
    private $h; // высота изображения
    private $wd; // ширина эллипса
    private $hd; // высота эллипса
    private $elements_names = array(); // имена частей
    private $elements_values = array(); // значения частей
    private $elements_parts = array(); // значение в соотношении угла
    function piechart($width, $height, $elements)
    {
        $this->chart();
        $this->w = $width;
        $this->hd = $this->h = $height;
        $this->wd = intval($width * 0.6);
        $this->hd = intval($height * 0.8);

        foreach ($elements as $key => $value) {
            $this->elements_names[] = $key;
            $this->elements_values[] = $value;
        }
    }
    function draw($q = 100)
    {
        header('Content-Type: image/jpeg');

        imagejpeg($this->img, null, $q);
    }

    function createimage()
    {
        $this->parts(); // высчитываем углы пирога
        $this->img = imagecreatetruecolor($this->w, $this->h);
        $white = imagecolorallocate($this->img, $this->bg_color[0], $this->bg_color[1], $this->bg_color[2]);

        imagefill($this->img, 0, 0, $white);
        $st = 0; // старт
        for ($i = 0;$i < count($this->elements_parts);$i++) {
            $end = $st + $this->elements_parts[$i];
            $col = imagecolorallocate($this->img, $this->colors[$i][0], $this->colors[$i][1], $this->colors[$i][2]);

            $this->add_part($st, $end, $col);

            $this->add_label($this->elements_names[$i], $this->elements_values[$i], $i * 8, $col);
            // echo "$st - $end<br />";
            $st += $this->elements_parts[$i];
        }
    }

    private function add_part($s, $e, $c)
    {
        // рисуем часть эллипса
        imagefilledarc ($this->img, $this->wd / 2, $this->hd / 2, $this->wd, $this->hd, $s, $e, $c, IMG_ARC_PIE);
    }

    private function add_label($label, $value, $y, $c)
    {
        // добавляем метку
        imagefilledrectangle($this->img, $this->wd, $y + 2, $this->wd + 2, $y + 4, $c);
        $lc = imagecolorallocate($this->img, $this->font_color[0], $this->font_color[1], $this->font_color[2]);

        imagestring($this->img, 1, $this->wd + 5, $y, $label . ' ' . $value, $lc);
    }

    private function parts()
    {
        // суммарное значение элементов (предварительное)
        $sum = array_sum($this->elements_values);
        $values = array();

        foreach ($this->elements_values as $key => $value) {
            // ограничиваем низший предел, чтобы небыло невидимых частей
            $values[$key] = max($value, @$sum / max(count($this->elements_values), 20));
        }
        // повторное вычисление суммарного значения элементов
        $sum = array_sum($values);

        foreach ($values as $key => $value) {
            $this->elements_parts[$key] = round($value / $sum * 360);
        }
    }
}

?>