<?php
class widget {
	protected $_data = array ();
	
	function __construct($path) {
		$this->_data ['path_abs'] = realpath ( $path );
		$this->_data ['runame'] = $this->_data ['name'] = basename ( $this->_data ['path_abs'] );
		$this->_data ['version'] = '1.0'; // версия
		$this->_data ['autor'] = false; // автор
		$this->_data ['script'] = 'index.php'; // исполняемый скрипт
		$this->_data ['screen'] = false; // скриншот
		$this->_data ['cache_by_user'] = false; // отдельный кэш для каждого пользователя
		$this->_data ['cache_by_group'] = false; // отдельный кэш для каждой группы
		$this->_data ['cache_by_browser_type'] = false; // отдельный кэш для каждого типа браузера
		$this->_data ['cache_time'] = rand ( 10, 30 ); // время хранения кэша в секундах
		if ($config = ini::read ( $this->_data ['path_abs'] . '/config.ini' )) {
			// загружаем конфиг
			$this->_data = array_merge ( $this->_data, ( array ) @$config );
		}
	}
	// отображаем виджет
	function display() {
		if ($content = $this->getContent ()){
		$widget = new design ();
		$widget->assign ( 'content', $content );
		$widget->assign ( 'name', $this->_data ['runame'] );
		$widget->display ( 'widget.tpl' );
    }
	}
	// получаем содержимое виджета
	function getContent() {
		global $user, $dcms, $cache;
		$cache_id = $this->_getCacheId ();
		if ($cache_content = $cache->get ( $cache_id ))
			return $cache_content;
		
		ob_start ();
		include $this->_data ['path_abs'] . '/' . $this->_data ['script'];
		$content = ob_get_contents ();
		ob_end_clean ();
		
		$cache->set ( $cache_id, $content, $this->_data ['cache_time'] );
		return $content;
	}
	// получаем уникальный идентификатор в кэше
	protected function _getCacheId() {
		global $user, $dcms;
		$cache_id = array ();
		$cache_id [] = 'widget-' . $this->_data ['name'];
		
		if ($this->_data ['cache_by_browser_type'])
			$cache_id [] = 'browser-' . $dcms->browser_type;
		
		if ($this->_data ['cache_by_user'])
			$cache_id [] = 'user-' . $user->id;
		
		if ($this->_data ['cache_by_group'])
			$cache_id [] = 'group-' . intval ( $user->group );
		
		return implode ( '.', $cache_id );
	}
	
	function __get($n) {
		return isset ( $this->_data [$n] ) ? $this->_data [$n] : false;
	}
	
	function __set($n, $v) {
		if (! isset ( $this->_data [$n] ))
			return false;
		$this->_data [$n] = $v;
	}
	
	function saveData() {
		return ini::save ( $this->_data ['path_abs'] . '/config.ini', $this->_data );
	}
}

?>
