<?php
/**
* @package     CleverCMS
* @link        https://t.me/clevercms
* @copyright   Copyright (C) 2018 CleverCMS
* @author      Clever Software
*/
require_once('../system/start.php');
switch($act) {
	default:
		$tmp->header('Yangiliklar');
		$count_news = DB::run()->querySingle("SELECT COUNT(`id`) FROM `news`");
		if($count_news != 0) 
		{
			$tmp->div('phdr', 'Yangiliklar ('.$count_news.')');
			$result = DB::run()->query("SELECT `id`, `title`, `msg`, `user_id` FROM `news` ORDER BY `id` DESC LIMIT $start, $kmess");
			while ($news = $result->fetch()) 
			{
				$news_comments = DB::run()->querySingle("SELECT COUNT(`id`) FROM `news_comments` WHERE `news_id` = ?", array($news['id']));
				$ank = DB::run()->queryFetch("SELECT * FROM `users` WHERE `user_id` = ?", array($news['user_id']));
				$tmp->div('menu', img('/images/news.png').'<a href="/news/'.$news['id'].'/view/">'.$news['title'].'</a><br />'.text($news['msg']).'<br /><b>Yaratdi</b>: '.$ank['nick'].'<br />'.img('/images/comments.png').'<a href="/news/'.$news['id'].'/comments/">Fikrlar</a> '.$news_comments.'');
			}
		} else {
			$tmp->div('menu', 'Yangiliklar yo`q');
		}
		if ($count_news > $kmess) $tmp->div('menu', $tmp->navigator('?', $start, $count_news, $kmess));
		if($user['level'] >= 7)
		{
			$tmp->div('menu', '&raquo; <a href="/news/add/">Yangilik kiritish</a>');
		}
	break;
	
	case 'add':
		$tmp->header('Yangilik kiritish');
		check_auth();
		User::level(7, '/news/');
		if (isset($_POST['add'])) 
		{
			$title = html($_POST['title']);
			$msg = html($_POST['msg']);
			if($msg=="") {
				$err = 'Xabar matnini kiritmadingiz!';
			} elseif(mb_strlen($msg, 'UTF-8') > 2000) {
				$err ='Xabar 2000 belgidan oshmasligi lozim!';
			} elseif(mb_strlen($msg, 'UTF-8') < 2) {
				$err ='Xabar matni juda qisqa';
			} else {
				DB::run()->query("INSERT INTO `news` (`user_id`, `title`, `msg`, `date`) VALUES (?, ?, ?, ?)", array($user['user_id'], $title, $msg, time()));
				header("Location: /news/");
				exit();
			}
		}
		$tmp->error();
		$tmp->div('menu', '<form method="POST" action="">
		Nomi: <br/> <input class="input" type="text" name="title"><br />
		Matni: <br /><textarea class="textarea" name="msg"></textarea><br/>
		<input class="submit" name="add" type="submit" value="Qo`shish"></form>');
	break;
	
	case 'view':
		$news = DB::run()->queryFetch("SELECT `id`, `title`, `msg`, `user_id`, `date` FROM `news` WHERE `id` = ?", array($id));
		$tmp->header('Yangiliklar / '.$news['title']);
		if(!$news) 
		{
			$tmp->div('menu', 'Bunday yangilik saytimiz bazasida mavjud emas!<br />&laquo; <a href="/news/">Yangiliklar arxiviga qaytish</a>');
			$tmp->footer();
			exit;
		}
		$news_comments = DB::run()->querySingle("SELECT COUNT(`id`) FROM `news_comments` WHERE `news_id` = ?", array($news['id']));
		$ank = DB::run()->queryFetch("SELECT * FROM `users` WHERE `user_id` = ?", array($news['user_id']));
		$tmp->div('menu', text($news['msg']));
		$tmp->div('menu', '<b>Yaratdi</b>: '.$ank['nick'].'<br /><b>Yaratilgan sana</b>: '.times($news['date']).'<br />'.img('/images/comments.png').'<a href="/news/'.$news['id'].'/comments/">Bildirilgan fikrlar</a> '.$news_comments.'');
		if($user['level'] >= 7)
		{
			$tmp->div('menu', '&raquo; <a href="/news/'.$news['id'].'/delete/">O`chirish</a><br />&raquo; <a href="/news/'.$news['id'].'/edit/">Taxrirlash</a>');
		}
	break;
	
	case 'delete':
		$news = DB::run()->queryFetch("SELECT `id`, `title` FROM `news` WHERE `id` = ?", array($id));
		$tmp->header('Yangiliklar / '.$news['title'].' / O`chirish');
		check_auth();
		User::level(7, '/news/'.$id.'/view/');
		if(!$news)
		{
			$tmp->div('menu', 'Bunday yangilik saytimiz bazasida mavjud emas!<br />&laquo; <a href="/news/">Yangiliklar arxiviga qaytish</a>');
			$tmp->footer();
			exit;
		}
		DB::run()->query("DELETE FROM `news` WHERE `id` = ?", array($news['id']));
		header('location: /news/');
	break;
	
	case 'edit':
		$news_edit = DB::run()->queryFetch("SELECT `id`, `title`, `msg` FROM `news` WHERE `id` = ?", array($id));
		$tmp->header('Yangiliklar / '.$news_edit['title'].' / Taxrirlash');
		check_auth();
		User::level(7, '/news/'.$id.'/view/');
		if(!$news_edit)
		{
			$tmp->div('menu', 'Bunday yangilik saytimiz bazasida mavjud emas!<br />&laquo; <a href="/news/">Yangiliklar arxiviga qaytish</a>');
			$tmp->footer();
			exit;
		}
		if(isset($_POST['edit']))
		{
			$title = html($_POST['title']);
			$msg = html($_POST['msg']);
			if(empty($title)) {
				$err = 'Yangilik nomini kiritmadingiz!';
			}  elseif(mb_strlen($title, 'UTF-8') < 3) {
				$err ='Yangilik nomi juda qisqa';
			} elseif(empty($msg)) {
				$err = 'Yangilik matnini kiritmadingiz!';
			} elseif(mb_strlen($msg, 'UTF-8') > 2000) {
				$err ='Yangilik matni 2000 belgidan oshmasligi lozim!';
			} elseif(mb_strlen($msg, 'UTF-8') < 2) {
				$err ='Yangilik matni juda qisqa';
			} else {
				DB::run()->query("UPDATE news SET `title` = ?, `msg` = ? WHERE `id` = ?", array($title, $msg, $news_edit['id']));
				header('Location: /news/'.$news_edit['id'].'/view/');
				exit();
			}
		}
		$tmp->error();
		$tmp->div('menu', '<form method="POST" action="/news/'.$news_edit['id'].'/edit/" name="message">
		Nomi: <br />
		<input class="input" type="title" style="width: 180px;" value="'.$news_edit['title'].'" name="title"><br />
		Matni:<br />
		<textarea class="textarea" style="width: 180px;" name="msg">'.$news_edit['msg'].'</textarea><br/>
		<input class="submit" type="submit" name="edit" value="Saqlash"></form>');
	break;
	
	case 'comments':
		$news = DB::run()->queryFetch("SELECT `id`, `title` FROM `news` WHERE `id` = ?", array($id));
		$tmp->header('Bildirilgan fikrlar / Yangiliklar '.$news['title'].'');
		check_auth();
		if(!$news)
		{
			$tmp->div('menu', 'Bunday yangilik saytimiz bazasida mavjud emas!<br />&laquo; <a href="/news/">Yangiliklar arxiviga qaytish</a>');
			$tmp->footer();
			exit;
		}
		if(isset($_POST['add']))
		{
			$msg = text($_POST['msg']);
			if($msg=="") {
				$err = 'Xabar matnini kiritmadingiz!';
			} elseif(mb_strlen($msg, 'UTF-8') > 2000) {
				$err ='Xabar 2000 belgidan oshmasligi lozim!';
			} elseif(mb_strlen($msg, 'UTF-8') < 2) {
				$err ='Xabar matni juda qisqa';
			} else {
				DB::run()->query("INSERT INTO `news_comments` SET `msg` = ?, `news_id` = ?, user_id = ?, date = ?", array($msg, $news['id'], $user['user_id'], time()));
				header('Location: /news/' . $id . '/comments/');
			}
		}
		$tmp->error();
		$tmp->div('menu', '<form method="POST" action="">
		<b>Fikringiz</b>:<br />
		<textarea class="textarea" style="width: 180px;" name="msg"></textarea><br />
		<input class="submit" type="submit" name="add" value="Qoldirish"></form>');
		$tmp->div('menu', '<a href="/smiles/">Smayllar</a> / <a href="/bb_codes/">BB kodlar</a>');
		$tmp->div('phdr', 'Fikrlar');
		$count = DB::run()->querySingle("SELECT COUNT(id) FROM news_comments WHERE news_id = '".$news['id']."'");
		if($count != 0)
		{
			$result = DB::run()->query("SELECT `id`, `news_id`, `user_id`, `msg`, `date` FROM `news_comments` ORDER BY `id` DESC LIMIT $start, $kmess");
			while($cs = $result->fetch())
			{
				$ank = DB::run()->queryFetch("SELECT * FROM `users` WHERE `user_id` = ?", array($cs['user_id']));
				echo '<div class="menu">';
				echo ''.User::name($ank['user_id'], 'info').' <font color="#d4232f"><small>('.times($cs['date']).')</small></font><br />'.text($cs['msg']) .'';
				if($user['level'] >= 7) {
					$tmp->div('sub', '<a href="/comments/' . $cs['id'] . '/delete/">O`chirish</a>');
				}
				echo '</div>';
			}
		} else {
			$tmp->div('menu', 'Fikrlar mavjud emas!');
		}
		if ($count > $kmess) $tmp->div('menu', $tmp->navigator('?', $start, $count, $kmess));
	break;
	
	case 'comments_delete':
		$cs = DB::run()->queryFetch("SELECT `id`, `news_id` FROM `news_comments` WHERE `id` = ?", array($id));
		$news = DB::run()->queryFetch("SELECT `id` FROM `news` WHERE `id` = ?", array($cs['news_id']));
		$tmp->header('Bildirilgan fikrni o`chirish');
		check_auth();
		User::level(7, '/news/'.$news['id'].'/comments/');
		if(!$cs)
		{
			$tmp->div('menu', 'Bunday Bildirlgan fikr saytimiz bazasida mavjud emas!<br />&laquo; <a href="/news/">Yangiliklarga qaytish</a>');
			$tmp->footer();
			exit();
		}
		DB::run()->query("DELETE FROM `news_comments` WHERE `id` = ?", array($id));
		header('Location: /news/' . $news['id'] . '/comments/');
	break;
}
$tmp->footer();
?>