<?php
include_once '../sys/inc/start.php';
dpanel::check_access();
$doc = new document(6);
$doc->title = 'Сохранение таблиц';

$tables = new tables();

if (!empty($_POST)) {
    foreach ($_POST as $table => $val) {
        // echo $table."<br />";
        if (!$val)continue;
        if (in_array($table, $tables->tables)) {
            if (function_exists('set_time_limit'))set_time_limit(600);

            if (!empty($_POST['create'])) {
                $tab = new table_structure();
                $tab->loadFromBase($table);
                $tab->saveToIniFile(H . '/sys/preinstall/base.create.' . $table . '.ini');
            }
            if (!empty($_POST['data'])) {
                $tables->save_data(H . '/sys/preinstall/base.data.' . $table . '.sql', $table);
            }
        }
    }

    if (!empty($_POST['create'])) {
        $doc->msg("Структура таблиц успешно сохранена");
    }
    if (!empty($_POST['data'])) {
        $doc->msg("Содержимое таблиц успешно сохранено");
    }

    if (@copy(H . '/sys/ini/settings.ini', H . '/sys/preinstall/settings.ini'))
        $doc->msg("Предустановочные параметры успешно сохранены");
}

$posts = array();

foreach ($tables->tables as $table) {
    if ($table {
            0} == '~')continue;

    $posts[] = array('title' => $table, 'checkbox' => array('name' => $table, 'checked' => 1));
}

if (!$posts)$posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Таблицы отсутствуют');

$show = new design();
$show->assign('post', $posts);
echo "<form method='post' action='?" . passgen() . "'>";
$show->display('design.listing.tpl');
echo "Структура и данные таблиц сохранятся в папке sys/preinstall и в дальнейшем могут быть использованы для установки движка с существующими данными.<br />";
echo "<input type='submit' name='create' value='Структура' />";
echo "<input type='submit' name='data' value='Данные' /></form>";

$doc->ret('Админка', './');

?>
