<?php
include_once '../sys/inc/start.php';
dpanel::check_access();
$doc = new document(6);
$doc->title = 'Обновление структуры таблиц';

$tables_exists = new tables();
$table_files = (array)glob(H . '/sys/preinstall/base.create.*.ini');
$tables = array();
foreach ($table_files as $table_file) {
    preg_match('#base.create\.(.+)\.ini#ui', $table_file, $m);
    $tables[] = $m[1];
}

if (!empty($_POST)) {
    foreach ($_POST as $table => $val) {
        // echo $table."<br />";
        if (!$val)continue;
        if (in_array($table, $tables)) {
            if (function_exists('set_time_limit'))set_time_limit(600);

            if (!empty($_POST['load'])) {
                if (!is_file(H . '/sys/preinstall/base.create.' . $table . '.ini'))continue;

                $tab = new table_structure(H . '/sys/preinstall/base.create.' . $table . '.ini');
                // если такая таблица уже существует, то получаем запрос на ее изменение
                if (in_array($table, $tables_exists->tables)) {
                    $tab_old = new table_structure();
                    $tab_old->loadFromBase($table);
                    $sql = $tab_old->getSQLQueryChange($tab);
                }else
                    $sql = $tab->getSQLQueryCreate();

                if (mysql_query($sql)) {
                    $doc->msg('Запрос на изменение таблицы "' . $table . '" успешно выполнен');
                    $tables_exists = new tables();
                    if (in_array($table, $tables_exists->tables))
                        $doc->msg('Таблица "' . $table . '" успешно изменена');
                    else
                        $doc->err('Таблица "' . $table . '" не создана');
                }
            }
        }
    }
}

$posts = array();

foreach ($tables as $table) {
    $checked = false;
    $sql = false;
    if (!in_array($table, $tables_exists->tables)) {
        // таблица не существует в базе, значит нужно создать
        $checked = true;
    }else {
        $tab_old = new table_structure();
        $tab_old->loadFromBase($table);

        $tab_new = new table_structure(H . '/sys/preinstall/base.create.' . $table . '.ini');
        // если есть изменения, то обновляем
        if ($sql = $tab_old->getSQLQueryChange($tab_new))
            $checked = true;
    }

    $post = empty($sql)?'': '<pre>' . output_text($sql) . '</pre>';
    if ($post)
        $posts[] = array('title' => $table, 'post' => $post, 'checkbox' => array('name' => $table, 'checked' => $checked));
}

if (!$posts)$posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'),
        'title' => 'Таблицы находятся в актуальном состоянии');

$show = new design();
$show->assign('post', $posts);
echo "<form method='post' action='?" . passgen() . "'>";
$show->display('design.listing.tpl');
echo "* Изменится только структура таблицы. Данные, для которых не предусмотрено место в новой версии таблиц, будут утеряны.<br />";
echo "** Проверяются файлы sys/preinstall/base.create.[имя таблицы].ini<br />";
echo "<input type='submit' name='load' value='Выполнить запросы' /></form>";

$doc->ret('Админка', './');

?>
