<?php
include_once '../sys/inc/start.php';
dpanel::check_access();
$smiles = smiles::get_ini();
$doc = new document(5);
$doc->title = 'Смайлы';

$smiles_a = array();
// загружаем список смайлов
$smiles_gl = (array)glob(H . '/sys/images/smiles/*.gif');

foreach($smiles_gl as $path) {
    preg_match('#/([^/]+)\.gif$#', $path, $m);
    $smiles_a[$m[1]] = $path;
}

if (!empty($_GET['smile']) && isset($smiles_a[$_GET['smile']])) {
    $sm = $_GET['smile'];

    if (isset($_GET['act']) && $_GET['act'] == 'delete' && !empty($_GET['phrase'])) {
        $phrase = (string)$_GET['phrase'];
        if (!empty($smiles[$phrase])) {
            if ($smiles[$phrase] != $sm)$design->err('Фраза относится к другому смайлу');
            else {
                unset($smiles[$phrase]);
                $sm_ini = array();
                foreach ($smiles as $key => $value) {
                    $sm_ini[] = "$key=\"$value\"";
                }
                if (file_put_contents(H . '/sys/ini/smiles.ini', implode(";\r\n", $sm_ini))) {
                    $doc->msg('Фраза успешно удалена');
                }else
                    $doc->err('Нет прав на запись в файл smiles.ini');
            }
        }else {
            $doc->err('Фраза уже удалена');
        }
    }

    if (!empty($_POST['phrase'])) {
        $phrase = text::for_value($_POST['phrase']);
        if ($phrase) {
            if ($phrase == 'null' || $phrase == 'yes')$doc->err('Запрещено использовать данную фразу');
            elseif (!empty($smiles[$phrase]))$doc->err('Данная фраза используется для смайла "' . $smiles[$phrase] . '"');
            else {
                $smiles[$phrase] = $sm;
                $sm_ini = array();
                foreach ($smiles as $key => $value) {
                    $sm_ini[] = "$key=\"$value\"";
                }
                if (file_put_contents(H . '/sys/ini/smiles.ini', implode(";\r\n", $sm_ini))) {
                    $doc->msg('Фраза успешно добавлена');
                }else
                    $doc->err('Нет прав на запись в файл smiles.ini');
            }
        }
    }

    $doc->title = 'Смайл "' . $sm . '"';

    $phrases = array_keys($smiles, $sm);
    $posts = array();
    foreach ($phrases as $text) {
        $posts[] = array('title' => $text, 'act' => array(array('delete', '?smile=' . urlencode($sm) . '&amp;phrase=' . urlencode($text) . '&amp;act=delete')));
    }
    if (!$posts)$posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Фразы отсутствуют');
    $show = new design();
    $show->assign('post', $posts);
    $show->display('design.listing.tpl');

    $smarty = new design();
    $smarty->assign('method', 'post');
    $smarty->assign('action', '?' . passgen() . '&amp;smile=' . urlencode($sm) . '&amp;act=add');
    $elements = array();
    $elements[] = array('type' => 'input_text', 'title' => 'Фраза', 'br' => 1, 'info' => array('name' => 'phrase'));
    $elements[] = array('type' => 'submit', 'br' => 0, 'info' => array('value' => 'Добавить')); // кнопка
    $smarty->assign('el', $elements);
    $smarty->display('input.form.tpl');

    $doc->ret('Смайлы', '?');
    $doc->ret('Админка', './');
    exit;
}

$posts = array();

foreach ($smiles_a as $name => $path) {
    $icon = array('size' => 'big', 'src' => '/sys/images/smiles/' . $name . '.gif');
    $post = 'Варианты: ' . implode(', ', array_keys ($smiles, $name));
    $posts[] = array('title' => '<a href="?smile=' . urlencode($name) . '">' . $name . '</a>', 'post' => $post, 'icon' => $icon);
}
if (!$posts)$posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Смайлы отсутствуют');
$show = new design();
$show->assign('post', $posts);
$show->display('design.listing.tpl');

$doc->ret('Админка', './');

?>
