<?php
include_once '../sys/inc/start.php';
dpanel::check_access ();
$groups = groups::load_ini ();
$doc = new document ( 4 );
$doc->title = 'Профиль';

$browser_types = array ('wap', 'pda', 'web' );

if (isset ( $_GET ['id_ank'] ))
	$ank = new user ( $_GET ['id_ank'] );
else
	$ank = $user;

if (! $ank->group) {
	if (isset ( $_GET ['return'] ))
		header ( 'Refresh: 1; url=' . $_GET ['return'] );
	else
		header ( 'Refresh: 1; url=/' );
	
	$doc->err ( 'Нет данных' );
	exit ();
}

$doc->title .= ' "' . $ank->login . '"';

if ($ank->group >= $user->group) {
	if (isset ( $_GET ['return'] ))
		header ( 'Refresh: 1; url=' . $_GET ['return'] );
	else
		header ( 'Refresh: 1; url=/' );
	
	$doc->err ( 'Ваш статус не позволяет производить действия с данным пользователем' );
	exit ();
}

if (isset ( $_POST ['save'] )) {
	$ank->realname = text::for_name ( @$_POST ['realname'] );
	$ank->icq_uin = text::icq_uin ( @$_POST ['icq'] );
	$ank->balls = abs ( ( int ) @$_POST ['balls'] );
	
	if (isset ( $_POST ['ank_d_r'] )) {
		if ($_POST ['ank_d_r'] == null)
			$ank->ank_d_r = null;
		else {
			$ank_d_r = ( int ) $_POST ['ank_d_r'];
			if ($ank_d_r >= 1 && $ank_d_r <= 31)
				$ank->ank_d_r = $ank_d_r;
			else
				$doc->err ( 'Не корректный формат дня рождения' );
		}
	}
	
	if (isset ( $_POST ['ank_m_r'] )) {
		if ($_POST ['ank_m_r'] == null)
			$ank->ank_m_r = null;
		else {
			$ank_m_r = ( int ) $_POST ['ank_m_r'];
			if ($ank_m_r >= 1 && $ank_m_r <= 12)
				$ank->ank_m_r = $ank_m_r;
			else
				$doc->err ( 'Не корректный формат месяца рождения' );
		}
	}
	
	if (isset ( $_POST ['ank_g_r'] )) {
		if ($_POST ['ank_g_r'] == null)
			$ank->ank_g_r = null;
		else {
			$ank_g_r = ( int ) $_POST ['ank_g_r'];
			if ($ank_g_r >= date ( 'Y' ) - 100 && $ank_g_r <= date ( 'Y' ))
				$ank->ank_g_r = $ank_g_r;
			else
				$doc->err ( 'Не корректный формат года рождения' );
		}
	}
	
	if (! empty ( $_POST ['skype'] )) {
		if (! is_valid::skype ( $_POST ['skype'] ))
			$doc->err ( 'Указан не корректный логин Skype' );
		else {
			$ank->skype = $_POST ['skype'];
		}
	}
	
	if (! empty ( $_POST ['email'] )) {
		if (! is_valid::mail ( $_POST ['email'] ))
			$doc->err ( 'Указан не корректный E-mail' );
		else {
			$ank->email = $_POST ['email'];
		}
	}
	if (isset ( $_POST ['wmid'] )) {
		if (empty ( $_POST ['wmid'] ))
			$ank->wmid = '';
		elseif (! is_valid::wmid ( $_POST ['wmid'] ))
			$doc->err ( 'Указан не корректный идентификатор WebMoney' );
		else {
			$ank->wmid = $_POST ['wmid'];
		}
	}
	if (! empty ( $_POST ['reg_mail'] )) {
		if (! is_valid::mail ( $_POST ['reg_mail'] ))
			$doc->err ( 'Указан не корректный Primary E-mail' );
		else {
			$ank->reg_mail = $_POST ['reg_mail'];
		}
	}
	
	foreach ( $browser_types as $type ) {
		$t = "items_per_page_$type";
		// количество пунктов на страницу
		if (! empty ( $_POST [$t] )) {
			$ipp = ( int ) $_POST [$t];
			if ($ipp >= 5 && $ipp <= 99)
				$ank->$t = $ipp;
			else
				$doc->err ( 'Недопустимое количество пунктов на страницу' );
		}
		
		$t = "theme_$type";
		// тема оформления
		if (! empty ( $_POST [$t] )) {
			$theme = ( string ) $_POST [$t];
			$themes = $doc->getThemes ( $t );
			for($i = 0; $i < count ( $themes ); $i ++) {
				if ($themes [$i] ['name'] == $theme) {
					$ank->$t = $theme;
					break;
				}
			}
		}
	}
	// временной сдвиг
	if (! empty ( $_POST ['time_shift'] )) {
		$ipp = ( int ) $_POST ['time_shift'];
		if ($ipp >= - 12 && $ipp <= 12)
			$ank->time_shift = $ipp;
		else
			$doc->err ( 'Недопустимое время' );
	}
	
	$ank->vis_email = ( int ) ! empty ( $_POST ['vis_email'] );
	$ank->vis_icq = ( int ) ! empty ( $_POST ['vis_icq'] );
	$ank->vis_friends = ( int ) ! empty ( $_POST ['vis_friends'] );
	$ank->vis_skype = ( int ) ! empty ( $_POST ['vis_skype'] );
	
	$dcms->log ( 'Пользователи', 'Изменение профиля пользователя [url=/profile.view.php?id=' . $ank->id . ']' . $ank->login . '[/url]' );
	
	$doc->msg ( 'Профиль успешно изменен' );
}

$smarty = new design ();
$smarty->assign ( 'method', 'post' );
$smarty->assign ( 'action', "?id_ank=$ank->id&amp;" . passgen () . (isset ( $_GET ['return'] ) ? '&amp;return=' . urlencode ( $_GET ['return'] ) : null) );
$elements = array ();

foreach ( $browser_types as $type ) {
	$t = "items_per_page_$type";
	$elements [] = array ('type' => 'input_text', 'title' => 'Пунктов на страницу (' . $type . ') [5-99]', 'br' => 1, 'info' => array ('name' => $t, 'value' => $ank->$t ) );
}
foreach ( $browser_types as $type ) {
	$t = 'theme_' . $type;
	$options = array (); // темы оформления
	$themes_list = $doc->getThemes ( $type ); // только для определенного типа браузера
	foreach ( $themes_list as $theme )
		$options [] = array ($theme ['name'], $theme ['runame'], $ank->$t == $theme ['dir'] );
	$elements [] = array ('type' => 'select', 'title' => 'Тема оформления (' . $type . ')', 'br' => 1, 'info' => array ('name' => $t, 'options' => $options ) );
}

$options = array (); // Врменной сдвиг
for($i = - 12; $i < 12; $i ++)
	$options [] = array ($i, date ( 'G:i', TIME + $i * 60 * 60 ), $ank->time_shift == $i );
$elements [] = array ('type' => 'select', 'title' => 'Время', 'br' => 1, 'info' => array ('name' => 'time_shift', 'options' => $options ) );

$elements [] = array ('type' => 'input_text', 'title' => 'Реальное имя', 'br' => 1, 'info' => array ('name' => 'realname', 'value' => $ank->realname ) );

$elements [] = array ('type' => 'text', 'value' => 'Дата рождения:', 'br' => 1 );
$elements [] = array ('type' => 'input_text', 'br' => 0, 'info' => array ('name' => 'ank_d_r', 'value' => $ank->ank_d_r, 'size' => 2, 'maxlength' => 2 ) );
$elements [] = array ('type' => 'input_text', 'br' => 0, 'info' => array ('name' => 'ank_m_r', 'value' => $ank->ank_m_r, 'size' => 2, 'maxlength' => 2 ) );
$elements [] = array ('type' => 'input_text', 'br' => 1, 'info' => array ('name' => 'ank_g_r', 'value' => $ank->ank_g_r, 'size' => 4, 'maxlength' => 4 ) );

$elements [] = array ('type' => 'input_text', 'br' => 1, 'title' => 'Баллы', 'info' => array ('name' => 'balls', 'value' => $ank->balls ) );

$elements [] = array ('type' => 'input_text', 'title' => 'Номер ICQ', 'br' => 1, 'info' => array ('name' => 'icq', 'value' => $ank->icq_uin ) );

$elements [] = array ('type' => 'checkbox', 'br' => 1, 'info' => array ('value' => 1, 'checked' => $ank->vis_icq, 'name' => 'vis_icq', 'text' => 'Показывать ICQ в анкете' ) );

$elements [] = array ('type' => 'input_text', 'title' => 'Skype логин', 'br' => 1, 'info' => array ('name' => 'skype', 'value' => $ank->skype ) );

$elements [] = array ('type' => 'checkbox', 'br' => 1, 'info' => array ('value' => 1, 'checked' => $ank->vis_skype, 'name' => 'vis_skype', 'text' => 'Показывать Skype в анкете' ) );

$elements [] = array ('type' => 'input_text', 'title' => 'Primary E-mail', 'br' => 1, 'info' => array ('name' => 'reg_mail', 'value' => $ank->reg_mail ) );

$elements [] = array ('type' => 'input_text', 'title' => 'E-mail', 'br' => 1, 'info' => array ('name' => 'email', 'value' => $ank->email ) );

$elements [] = array ('type' => 'input_text', 'title' => 'WebMoney ID', 'br' => 1, 'info' => array ('name' => 'wmid', 'value' => $ank->wmid ) );
$elements [] = array ('type' => 'checkbox', 'br' => 1, 'info' => array ('value' => 1, 'checked' => $ank->vis_email, 'name' => 'vis_email', 'text' => 'Показывать Email в анкете' ) );

$elements [] = array ('type' => 'checkbox', 'br' => 1, 'info' => array ('value' => 1, 'checked' => $ank->vis_friends, 'name' => 'vis_friends', 'text' => 'Отображать список друзей' ) );

$elements [] = array ('type' => 'submit', 'br' => 0, 'info' => array ('name' => 'save', 'value' => 'Изменить' ) ); // кнопка
$smarty->assign ( 'el', $elements );
$smarty->display ( 'input.form.tpl' );

$doc->ret ( 'Действия', 'user.actions.php?id=' . $ank->id );
$doc->ret ( 'Анкета "' . $ank->login . '"', '/profile.view.php?id=' . $ank->id );
$doc->ret ( 'Админка', '/dpanel/' );

?>
