<?php
include_once '../sys/inc/start.php';
dpanel::check_access();
$smiles = smiles::get_ini();
$doc = new document(5);
$doc->title = 'Виджеты';
$doc->ret('Админка', '/dpanel/');
// загружаем список виджетов из конфигурации
$widgets_conf = (array)ini::read(H . '/sys/ini/widgets.ini');
// производим поиск виджетов в соответствующей директории
$widgets = array();
$wod = opendir(H . '/sys/widgets');
while ($rd = readdir($wod)) {
    if ($rd {
            0} === '.')continue;
    if (!is_file(H . '/sys/widgets/' . $rd . '/config.ini'))continue;

    $widgets[$rd] = new widget(H . '/sys/widgets/' . $rd);
}
closedir($wod);
// проверяем список виджетов и удаляем отсутствующие
foreach ($widgets_conf as $widget => $show) {
    if (!isset($widgets[$widget])) {
        $widgets_conf_need_save = true; // необходимо сохранить список
        unset($widgets_conf[$widget]);
    }
}
// добавляем отсутствующие виджеты в список, но по-умолчанию делаем их неактивными
foreach ($widgets as $widget_name => $widget) {
    if (!isset($widgets_conf[$widget_name])) {
        $widgets_conf_need_save = true; // сохраним обновленный список
        $widgets_conf[$widget_name] = 0;
    }
}

if (!empty($widgets_conf_need_save)) {
    if (ini::save(H . '/sys/ini/widgets.ini', $widgets_conf))
        $doc->msg('Список виджетов успешно обновлен');
    else
        $doc->err('Невозможно сохранить список виджетов');
    unset ($widgets_conf_need_save);
}

if (!empty($_GET['widget']) && isset($widgets_conf[$_GET['widget']]) && !empty($_GET['act'])) {
    switch ($_GET['act']) {
        case 'up':
            if (misc::array_key_move($widgets_conf, $_GET['widget'], - 1)) {
                $widgets_conf_need_save = true;
                $doc->msg('Виджет "' . $widgets[$_GET['widget']]->runame . '" успешно перемещен вверх');
            }else
                $doc->err('Виджет "' . $widgets[$_GET['widget']]->runame . '" уже находится вверху');
            break;

        case 'down':
            if (misc::array_key_move($widgets_conf, $_GET['widget'], 1)) {
                $widgets_conf_need_save = true;
                $doc->msg('Виджет "' . $widgets[$_GET['widget']]->runame . '" успешно перемещен вниз');
            }else
                $doc->err('Виджет "' . $widgets[$_GET['widget']]->runame . '" уже находится внизу');
            $widgets_conf_need_save = true;
            break;

        case 'hide':
            $doc->msg('Виджет "' . $widgets[$_GET['widget']]->runame . '" успешно скрыт');
            $widgets_conf[$_GET['widget']] = 0;
            $widgets_conf_need_save = true;
            break;

        case 'show':
            $doc->msg('Виджет "' . $widgets[$_GET['widget']]->runame . '" будет отображаться');
            $widgets_conf[$_GET['widget']] = 1;
            $widgets_conf_need_save = true;
            break;
    }

    if (!empty($widgets_conf_need_save)) {
        if (ini::save(H . '/sys/ini/widgets.ini', $widgets_conf))
            $doc->msg('Новый список виджетов успешно сохранен');
        else
            $doc->err('Невозможно сохранить новый список виджетов');
        unset ($widgets_conf_need_save);
    }
    $doc->ret('Вернуться', '?' . passgen());
    header('Refresh: 1; url=?' . passgen());
    exit;
}

foreach ($widgets_conf as $name => $show) {
    $act = array();
    $icon = array('size' => 'small', 'src' => '/sys/images/icons/widget.png');

    $widget = $widgets[$name];
    $title = $widget->runame;

    $post = array();

    if ($autor = $widget->autor)
        $post[] = 'Автор: ' . for_value($autor);

    if ($version = $widget->version)
        $post[] = 'Версия: ' . for_value($version);

    if ($show)
        $act[] = array('hide', '?widget=' . urlencode($name) . '&amp;act=hide');
    else
        $act[] = array('show', '?widget=' . urlencode($name) . '&amp;act=show');

    $act[] = array('up', '?widget=' . urlencode($name) . '&amp;act=up');
    $act[] = array('down', '?widget=' . urlencode($name) . '&amp;act=down');

    $posts[] = array('title' => $title, 'post' => implode("<br />\n", $post), 'icon' => $icon, 'hide' => !$show, 'act' => $act);
}
if (!$posts)$posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'),
        'title' => 'Виджеты отсутствуют');
$show = new design();
$show->assign('post', $posts);
$show->display('design.listing.tpl');

?>