<?php

defined('DCMS') or die();
$dir = new files($abs_path);



if ($dir->group_show > $user->group)
    $doc->access_denied('У Вас нет прав для просмотра данной папки');

$doc->title = $dir->runame;
include H . '/files/inc/dir_act.php';

$order_keys = $dir->getKeys();
if (!empty($_GET ['order']) && isset($order_keys [$_GET ['order']]))
    $order = $_GET ['order'];
else
    $order = 'runame:asc';

if ($screens = $dir->getScreens()) {
    
}

if ($description = $dir->description) {
    echo output_text($description) . "<br />";
}

$search = false;
if (!empty($_GET ['search']))
    $search = text::input_text($_GET ['search']);

$smarty = new design ();
$smarty->assign('method', 'get');
$smarty->assign('action', '?');
$elements = array();
$elements [] = array('type' => 'hidden', 'info' => array('name' => 'order', 'value' => $order));
$elements [] = array('type' => 'input_text', 'title' => 'Имя файла (или его часть)', 'br' => 0, 'info' => array('name' => 'search', 'value' => $search));
$elements [] = array('type' => 'submit', 'br' => 0, 'info' => array('value' => 'Поиск')); // кнопка
$smarty->assign('el', $elements);
if (empty($_GET ['act']))
    $smarty->display('input.form.tpl');

if ($search)
    $doc->msg('Результаты поиска по запросу: ' . $search);

$content = $dir->getList($order, $search);

$dirs = &$content ['dirs'];
$files = &$content ['files'];
$posts = array();

$pages = new pages ();
$pages->posts = count($files);
$pages->this_page();
// меню сортировки
$ord = array();
$order_keys = $dir->getKeys();
foreach ($order_keys as $key => $name) {
    $ord [] = array("?order=$key&amp;page={$pages->this_page}" . (!empty($search) ? '&amp;search=' . urlencode($search) : ''), $name, $order == $key);
}

$or = new design ();
$or->assign('order', $ord);
if (empty($_GET ['act']) && $pages->posts)
    $or->display('design.order.tpl');

if ($pages->this_page == 1) {
    // показываем все папки (без листинга) только на первой странице
    $c_dirs = count($dirs);
    for ($i = 0; $i < $c_dirs; $i++) {
        $description = '';
        if ($dirs [$i]->group_show)
            $description = '[b]Доступ только группе ' . groups::name($dirs [$i]->group_show) . " и выше[/b]\n";

        $description .= $dirs [$i]->description;

        $count = '(' . $dirs [$i]->count() . ')';
        if ($count_of_dir = $dirs [$i]->count(NEW_TIME))
            $count .= " <a href='/files" . $dirs [$i]->getPath() . "?order=time_add:desc'>+" . $count_of_dir . '</a>';

        $posts [] = array('icon' => $dirs [$i]->icon(), 'title' => "<a href='/files" . $dirs [$i]->getPath() . "'>" . for_value($dirs [$i]->runame) . "</a> " . $count, 'post' => output_text($description));
    }
}

$start = $pages->my_start();
$end = $pages->end();

$show_key = strtok($order, ':');
$time_new = mktime(- 24);
for ($i = $start; $i < $end && $i < $pages->posts; $i++) {
    switch ($show_key) {
        case 'comments' :
            $post = 'Комментариев: ' . intval($files [$i]->comments) . "\n";
            break;
        case 'title' :
            $post = 'Заголовок: ' . for_value($files [$i]->title) . "\n";
            break;
        case 'track_number' :
            $post = 'Номер трека: ' . for_value($files [$i]->track_number) . "\n";
            break;
        case 'genre' :
            $post = 'Жанр: ' . for_value($files [$i]->genre) . "\n";
            break;
        case 'album' :
            $post = 'Альбом: ' . for_value($files [$i]->album) . "\n";
            break;
        case 'band' :
            $post = 'Группа: ' . for_value($files [$i]->band) . "\n";
            break;
        case 'artist' :
            $post = 'Исполнители: ' . for_value($files [$i]->artist) . "\n";
            break;
        case 'size' :
            $post = 'Размер: ' . size_data($files [$i]->size) . "\n";
            break;
        case 'time_add' :
            $post = 'Файл добавлен: ' . vremja($files [$i]->time_add) . "\n";
            break;
        case 'time_create' :
            $post = 'Файл создан: ' . vremja($files [$i]->time_create) . "\n";
            break;
        case 'downloads' :
            $post = 'Файл скачан: ' . intval($files [$i]->downloads) . ' ' . misc::number($files [$i]->downloads, 'раз', 'раза', 'раз') . "\n";
            break;
        case 'id_user' :
            $ank = new user($files [$i]->id_user);
            $post = 'Добавил: ' . $ank->login . "\n";
            break;
        default :
            $post = '';
            break;
    }

    if ($properties = $files [$i]->properties)
        ; // Параметры файла (только основное)
    $post .= $properties . "\n";

    if ($description = $files [$i]->description)
        $post .= $description . "\n";

    $posts [] = array('icon' => $files [$i]->icon(), 'title' => "<a href='/files" . $files [$i]->getPath() . ".htm?order=$order'>" . for_value($files [$i]->runame) . "</a>", 'post' => output_text($post), 'new' => $files [$i]->time_add > $time_new);
}

if (!$dirs && !$files)
    $posts [] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Папка пуста');

if (empty($_GET ['act'])) {
    $show = new design ();
    $show->assign('post', $posts);
    $show->display('design.listing.tpl');

    $pages->listing('?order=' . $order . '&amp;' . (!empty($search) ? 'search=' . urlencode($search) . '&amp;' : '')); // вывод страниц
} else {
    $doc->ret(for_value($dir->runame), '?' . passgen());
}

$return = $dir->ret(5); // последние 5 ссылок пути


for ($i = 0; $i < count($return); $i++) {
    $doc->ret($return [$i] ['runame'], '/files' . $return [$i] ['path']);
}

include H . '/files/inc/dir_form.php';
exit();
?>