<?php
defined('DCMS') or die;
$pathinfo = pathinfo($abs_path);
$dir = new files($pathinfo['dirname']);

if ($dir->group_show > $user->group)$doc->access_denied('У Вас нет прав для просмотра файлов в данной папке');

$order_keys = $dir->getKeys();
if (!empty($_GET['order']) && isset($order_keys[$_GET['order']]))
    $order = $_GET['order'];
else $order = 'runame:asc';

$file = new files_file($pathinfo['dirname'], $pathinfo['basename']);

if ($file->group_show > $user->group)$doc->access_denied('У Вас нет прав для просмотра данного файла');

if (isset($_GET['act']) && $_GET['act'] == 'edit_screens') {
    if ($file->group_edit > $user->group && (!$file->id_user || $file->id_user != $user->id))$doc->access_denied('У Вас нет прав для изменения параметров данного файла');
    include 'inc/screens_edit.php';
}

$doc->title = 'Файл ' . $file->runame . ' - скачать';



$doc->description = 'Скачать файл ' . $file->runame . ' (' . $file->name . ')';

include 'inc/file_act.php';

if (empty($_GET['act'])) {
    $screens_count = $file->getScreensCount();

    $query_screen = (int)@$_GET['screen_num'];
    if ($screens_count) {
        if ($query_screen < 0 || $query_screen >= $screens_count)$query_screen = 0;

        if ($screen = $file->getScreen($doc->img_max_width(), $query_screen)) {
            echo "<img class='photo' src='" . $screen . "' alt='Скриншот $query_screen' /><br />\n";
        }

        if ($screens_count > 1) {
            $select = array();

            for ($i = 0 ;$i < $screens_count ;$i++) {
                $select[] = array('?order=' . $order . '&amp;screen_num=' . $i, $i + 1, $query_screen == $i);
            }

            $show = new design();
            $show->assign('select', $select);
            $show->display('design.select_bar.tpl');
        }
    }

    if ($description = $file->description)
        echo 'Описание: ' . output_text($description) . "<br />\n";

    if ($title = $file->title)
        echo 'Заголовок: ' . for_value($title) . "<br />\n";

    if ($artist = $file->artist) {
        echo 'Исполнители: ' . for_value($artist) . "<br />\n";
        $doc->keywords[] = $artist;
    }

    if ($band = $file->band) {
        echo 'Группа: ' . for_value($band) . "<br />\n";
        $doc->keywords[] = $band;
    }

    if ($album = $file->album) {
        echo 'Альбом: ' . for_value($album) . "<br />\n";
        $doc->keywords[] = $album;
    }

    if ($year = $file->year)
        echo 'Год: ' . for_value($year) . "<br />\n";

    if ($genre = $file->genre)
        echo 'Жанр: ' . for_value($genre) . "<br />\n";

    if ($comment = $file->comment)
        echo 'Комментарий: ' . output_text($comment) . "<br />\n";

    if ($track_number = (int)$file->track_number)
        echo 'Номер трека: ' . $track_number . "<br />\n";

    if ($language = $file->language)
        echo 'Язык: ' . for_value($language) . "<br />\n";

    if ($url = $file->url)
        echo 'Ссылка: ' . output_text($url) . "<br />\n";

    if ($copyright = $file->copyright)
        echo 'Копирайт: ' . output_text($copyright) . "<br />\n";

    if ($vendor = $file->vendor)
        echo 'Производитель: ' . for_value($vendor) . "<br />\n";

    if (($width = (int)$file->width) && ($height = (int)$file->height))
        echo 'Разрешение: ' . $width . 'x' . $height . "<br />\n";

    if ($frames = (int)$file->frames)
        echo 'Кол-во кадров: ' . $frames . "<br />\n";

    if ($playtime_string = $file->playtime_string)
        echo 'Продолжительность: ' . for_value($playtime_string) . "<br />\n";

    if (($video_bitrate = (int)$file->video_bitrate) && ($video_bitrate_mode = $file->video_bitrate_mode))
        echo 'Видео битрейт: ' . size_data($video_bitrate) . "/s (" . $video_bitrate_mode . ")<br />\n";

    if ($video_codec = $file->video_codec)
        echo 'Видео кодек: ' . for_value($video_codec) . "<br />\n";

    if ($video_frame_rate = $file->video_frame_rate)
        echo 'Частота: ' . round($video_frame_rate / 60) . " кадр./сек<br />\n";

    if (($audio_bitrate = (int)$file->audio_bitrate) && ($audio_bitrate_mode = $file->audio_bitrate_mode))
        echo 'Аудио битрейт: ' . size_data($audio_bitrate) . "/s (" . $audio_bitrate_mode . ")<br />\n";

    if ($audio_codec = $file->audio_codec)
        echo 'Аудио кодек: ' . for_value($audio_codec) . "<br />\n";

    if ($file->id_user) {
        $ank = new user($file->id_user);
        echo "Добавил <a href='/profile.view.php?id=$ank->id'>{$ank -> nick}</a> (" . vremja($file->time_add) . ")<br />\n";
    }
    
    echo "Кол-во скачиваний: ".intval($file->downloads) . ' ' . misc::number($file->downloads, 'раз', 'раза', 'раз'). "<br />\n";
    echo "Размер файла: " . size_data($file->size). "<br />\n";
    

    
    $smarty = new design();
    $elements = array();
    
    $elements[] = array('type' => 'input_text', 'br' => 0, 'title' => 'Скопировать ссылку', 'info' => array('value' => 'http://'.$_SERVER['HTTP_HOST'].'/files'.$file->getPath()));
    $smarty->assign('el', $elements);
    $smarty->display('input.form.tpl');
    
    $smarty = new design();
    $smarty->assign('method', 'get');
    $smarty->assign('action', '/files' . $file->getPath());
    $elements = array();
    $elements[] = array('type' => 'submit', 'br' => 0, 'info' => array('value' => 'Скачать '.$file->name)); // кнопка
    $smarty->assign('el', $elements);
    $smarty->display('input.form.tpl');
}


 $can_write = true;
    if (!$user->is_writeable) {
        $doc->msg('Писать запрещено','write_denied');
        $can_write = false;
    }


// комменты к файлу
if ($can_write && isset($_POST['send']) && isset($_POST['message']) && $user->group) {
    $message = text::input_text($_POST['message']);

    if ($file->id_user && $file->id_user != $user->id && (empty($_POST['captcha']) || empty($_POST['captcha_session']) || !captcha::check($_POST['captcha'], $_POST['captcha_session'])))
        $doc->err('Проверочное число введено неверно');
    elseif ($mat = is_valid::mat($message))$doc->err('Обнаружен мат: ' . $mat);
    elseif ($message) {
        $user->balls ++;
        mysql_query("INSERT INTO `files_comments` (`id_file`, `id_user`, `time`, `text`) VALUES ('$file->id','$user->id', '" . TIME . "', '" . my_esc($message) . "')");
        $doc->msg('Комментарий успешно оставлен');
        $file->comments ++;

        if ($file->id_user && $file->id_user != $user->id) { // уведомляем автора о комментарии
            $ank = new user($file->id_user);
            $ank->mess("$user->login оставил" . ($user->sex?'':'а') . " комментарий к Вашему файлу [url=/files{$file->getPath()}.htm]$file->runame[/url]");
        }
    }else {
        $doc->err('Комментарий пуст');
    }
}

if (empty($_GET['act'])) {
    // комменты будут отображаться только когда над файлом не производится никаких действий
    if ($can_write && $user->group) {
        $smarty = new design();
        $smarty->assign('method', 'post');
        $smarty->assign('action', '?order=' . $order . '&amp;screen_num=' . $query_screen . '&amp;' . passgen());
        $elements = array();
        $elements[] = array('type' => 'textarea', 'title' => 'Комментарий', 'br' => 1, 'info' => array('name' => 'message'));

        if ($file->id_user && $file->id_user != $user->id)$elements[] = array('type' => 'captcha', 'session' => captcha::gen(), 'br' => 1);

        $elements[] = array('type' => 'submit', 'br' => 0, 'info' => array('name' => 'send', 'value' => 'Отправить')); // кнопка
        $smarty->assign('el', $elements);
        $smarty->display('input.form.tpl');
    }

    if (!empty($_GET['delete_comm']) && $user->group >= $file->group_edit) {
        $delete_comm = (int)$_GET['delete_comm'];
        if (mysql_result(mysql_query("SELECT COUNT(*) FROM `files_comments` WHERE `id` = '$delete_comm' AND `id_file` = '$file->id' LIMIT 1"), 0)) {
            mysql_query("DELETE FROM `files_comments` WHERE `id` = '$delete_comm' LIMIT 1");
        	$file->comments --;
            $doc->msg('Комментарий успешно удален');
        }else
            $doc->err('Комментарий уже удален');
    }

    $posts = array();
    $pages = new pages;
    $pages->posts = mysql_result(mysql_query("SELECT COUNT(*) FROM `files_comments` WHERE `id_file` = '$file->id'"), 0); // количество сообщений
    $pages->this_page(); // получаем текущую страницу

    $q = mysql_query("SELECT * FROM `files_comments` WHERE `id_file` = '$file->id' ORDER BY `id` DESC LIMIT {$pages->my_start()}, {$pages->items_per_page}");
    while ($comment = mysql_fetch_assoc($q)) {
        $ank = new user($comment['id_user']);
        $act = array();
        if ($user->group >= $file->group_edit)
            $act[] = array('delete', '?order=' . $order . '&amp;screen_num=' . $query_screen . '&amp;delete_comm=' . $comment['id']);

        $posts[] = array('title' => $ank->show() . ' (' . vremja($comment['time']) . ')', 'icon' => $ank->icon(), 'post' => output_text($comment['text']), 'act' => $act);
    }
    if (!$posts)$posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Комментарии отсутствуют');

    $show = new design();
    $show->assign('post', $posts);
    $show->display('design.listing.tpl');

    $pages->listing('?order=' . $order . '&amp;screen_num=' . $query_screen . '&amp;'); // вывод страниц
}
// переход к рядом лежащим файлам в папке
$content = $dir->getList($order);
$files = &$content['files'];
$count = count($files);

if ($count > 1) {
    for($i = 0;$i < $count;$i++) {
        if ($file->name == $files[$i]->name)$fileindex = $i;
    }

    if (isset($fileindex)) {
        $select = array();

        if ($fileindex >= 1) {
            $last_index = $fileindex - 1;
            $select[] = array('./' . urlencode($files[$last_index]->name) . '.htm?order=' . $order, for_value($files[$last_index]->runame));
        }

        $select[] = array('?order=' . $order, for_value($file->runame), true);

        if ($fileindex < $count - 1) {
            $next_index = $fileindex + 1;
            $select[] = array('./' . urlencode($files[$next_index]->name) . '.htm?order=' . $order, for_value($files[$next_index]->runame));
        }

        $show = new design();
        $show->assign('select', $select);
        $show->display('design.select_bar.tpl');
    }
}

$doc->ret($dir->runame, './?order=' . $order); // возвращение в папку
$return = $dir->ret(5); // последние 5 ссылок пути
for ($i = 0;$i < count($return) ;$i++) {
    $doc->ret($return[$i]['runame'], '/files' . $return[$i]['path']);
}

include 'inc/file_form.php';
exit;

?>
