<?php
$doc->title = 'Файл ' . $file->runame . ' - скриншоты';

if (!empty($_FILES['file'])) {
    if ($_FILES['file']['error'])$doc->err('Ошибка при загрузке');
    elseif (!$_FILES['file']['size'])$doc->err('Содержимое файла пусто');
    else {
        $info = pathinfo($_FILES['file']['name']);

        switch (strtolower($info['extension'])) {
            case 'jpg':$img_screen = @imagecreatefromjpeg($_FILES['file']['tmp_name']);
                break;
            case 'jpeg':$img_screen = @imagecreatefromjpeg($_FILES['file']['tmp_name']);
                break;
            case 'gif':$img_screen = @imagecreatefromgif($_FILES['file']['tmp_name']);
                break;
            case 'png':$img_screen = @imagecreatefrompng($_FILES['file']['tmp_name']);
                break;
            default: $doc->err('Расширение файла не опознано');
                break;
        }

        if (!empty($img_screen)) {
            if ($file->screenAdd($img_screen)) {
                header('Refresh: 1; url=?order=' . $order . '&act=edit_screens&' . SID);
                $doc->ret('Вернуться', '?order=' . $order . '&amp;act=edit_screens');

                $doc->msg('Скриншот успешно добавлен');
                exit;
            }else
                $doc->err('Ошибка при добавлении скриншота');
        }
    }
}

if (isset($_GET['delete'])) {
    if ($file->screenDelete($_GET['delete'])) {
        header('Refresh: 1; url=?order=' . $order . '&act=edit_screens&' . SID);
        $doc->ret('Вернуться', '?order=' . $order . '&amp;act=edit_screens');

        $doc->msg('Скриншот успешно удален');
        exit;
    }else
        $doc->err('Ошибка при удалении скриншота');
}

$screens_count = $file->getScreensCount();

$posts = array();
for ($i = 0;$i < $screens_count; $i++) {
    $icon = array('size' => 'big', 'src' => $file->getScreen(48, $i));
    $title = 'Скриншот №' . ($i + 1);
    $act = array();
    $act[] = array('delete', '?order=' . $order . '&amp;act=edit_screens&amp;delete=' . $i);
    $posts[] = array('icon' => $icon, 'title' => $title, 'act' => $act);
}

if (!$posts)$posts[] = array('icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'), 'title' => 'Скриншоты отсутствуют');

$show = new design();
$show->assign('post', $posts);
$show->display('design.listing.tpl');

$smarty = new design();
$smarty->assign('method', 'post');
$smarty->assign('files', 1);
$smarty->assign('action', '?order=' . $order . '&amp;act=edit_screens&amp;' . passgen());
$elements = array();
$elements[] = array('type' => 'file', 'title' => 'Скриншот', 'br' => 1, 'info' => array('name' => 'file'));
$elements[] = array('type' => 'submit', 'br' => 0, 'info' => array('value' => 'Добавить')); // кнопка
$smarty->assign('el', $elements);
$smarty->display('input.form.tpl');

$doc->ret('К описанию', '?order=' . $order);
exit;

?>
