<?php
include_once '../sys/inc/start.php';

$doc = new document();
$doc->title = 'Новые файлы';
// абсолютный путь к папке загруз-центра с учетом выбора пользователя
$abs_path = realpath(FILES . '/' . @$_GET['dir']);
// если в строку $abs_path не входит FILES, то это попытка залезть на уровень выше дозволеного,
// поэтому $abs_path будет корнем загруз-центра
if (strpos($abs_path, FILES) !== 0 || !file_exists($abs_path)) {
    header('Location: ../?' . SID);
    exit;
} //$abs_path = FILES;
$dir = new files($abs_path);

if ($dir->group_show > $user->group)$doc->access_denied('У Вас нет прав для просмотра новых файлов в данной папке');

$doc->title = $dir->runame . ' - Новые файлы';

$content = $dir->getNewFiles(NEW_TIME);

$files = &$content['files'];
$posts = array();

$pages = new pages;
$pages->posts = count($files);
$pages->this_page();

$start = $pages->my_start();
$end = $pages->end();
for($i = $start;$i < $end && $i < $pages->posts;$i++) {
    $ank = new user($files[$i]->id_user);
    $post1 = 'Файл добавлен: ' . vremja($files[$i]->time_add) . ($ank->id?' ('.$ank->nick.')':'') ."<br />\n";

    
    
    $post = '';
    if ($properties = $files[$i]->properties); // Параметры файла (только основное)
    $post .= $properties . "\n";

    if ($description = $files[$i]->description)
        $post .= $description . "\n";

    $posts[] = array('icon' => $files[$i]->icon(),
        'title' => "<a href='/files" . $files[$i]->getPath() . ".htm'>" . for_value($files[$i]->runame) . "</a>",
        'post' => $post1 . output_text($post)
        );
}

if (!$files)$posts[] = array(
        'icon' => array('size' => 'small', 'src' => '/sys/images/icons/empty.png'),
        'title' => 'За последние сутки небыло добавлено ни одного файла');

$show = new design();
$show->assign('post', $posts);
$show->display('design.listing.tpl');

$pages->listing('?dir=' . $dir->path_rel . '&amp;'); // вывод страниц


?>
