<?php

/**
 * Шаблон xHTML документа
 */
class document extends design {

    var $title = 'Заголовок';
    var $description = '';
    var $keywords = array();
    protected $err = array();
    protected $msg = array();
    protected $outputed = false;
    protected $actions = array();
    protected $returns = array();

    function __construct($group = 0) {
        parent::__construct();
        global $user, $dcms;
        $this->title = $dcms->title;
        if ($group > $user->group)
            $this->access_denied('Доступ к данной странице запрещен');
        ob_start();
    }

    // добавление в список ошибок
    function err($err, $help = false) {
        $this->err[] = array('text' => $err, 'help' => $help);
    }

    // добавление в список сообщений
    function msg($msg, $help = false) {
        $this->msg[] = array('text' => $msg, 'help' => $help);
    }

    function ret($name, $link) {
        $this->returns[] = array($name, $link);
    }

    function act($name, $link) {
        $this->actions[] = array($name, $link);
    }

    function access_denied($err) {
        if (isset($_GET['return'])) {
            header('refresh:2;url=' . $_GET['return']);
        }
        $this->err($err);
        $this->output();
        exit;
    }

    private function output() {
        if ($this->outputed) {
            return false;
        }
        $this->outputed = true;

        global $dcms, $user;

        header('Cache-Control: no-store, no-cache, must-revalidate');
        header('Expires: ' . date('r'));
        // для осла (IE) как обычно отдельное условие
        if ($dcms->browser == 'Microsoft Internet Explorer') {
            header('Content-Type: text/html; charset=utf-8');
        } else {
            switch ($this->theme_obj->content) {
                case 'wml':header('Content-Type: text/vnd.wap.wml; charset=utf-8');
                    break;
                case 'xhtml':header('Content-Type: application/xhtml+xml; charset=utf-8');
                    break;
                default:header('Content-Type: text/html; charset=utf-8');
                    break;
            }
        }

        $this->assignByRef('adt', new adt()); // реклама
        $this->assign('description', $this->description); // описание страницы (meta)
        $this->assign('keywords', implode(', ', $this->keywords)); // ключевые слова (meta)
        $this->assign('actions', $this->actions); // ссылки к действию
        $this->assign('returns', $this->returns); // ссылки для возврата
        $this->assign('err', $this->err); // сообщения об ошибке
        $this->assign('msg', $this->msg); // сообщения
        $this->assign('title', $this->title); // заголовок страницы
        $this->assign('content', @ob_get_clean());
        list($msec, $sec) = explode(chr(32), microtime());
        $this->assign('document_generation_time', round($msec + $sec - TIME_START, 3));

        $this->display('document.tpl');
        // exit;
    }

    function clean() {
        $this->outputed = true;
        @ob_clean();
    }

    function __destruct() {
        $this->output();
    }

}

?>