<?php

class ispmanager {

    protected $_host;
    protected $_user;
    protected $_pass;
    protected $_session;

    function __construct($host, $user, $pass) {
        $this->_host = $host;
        $this->_user = $user;
        $this->_pass = $pass;
        $this->_Auth();
    }

    protected function _Auth() {
        $params = array();
        $params['func'] = 'auth';
        $params['username'] = $this->_user;
        $params['password'] = $this->_pass;
        $result = $this->_request($params);
        //echo '<pre>' . print_r($result, 1) . '</pre>';
        if (isset($result->auth)) {
            $this->_session = $result->auth;
        }
    }

    public function Restart() {
        $parms = array();
        $parms ['func'] = 'restart';
        $result = $this->_request($parms);
      //  echo '<pre>' . print_r($result, 1) . '</pre>';
        return (isset($result->result) && $result->result == 'OK');
    }

    public function GetAdministrators() {
        $parms = array();
        $parms ['func'] = 'mgradmin';
        return $this->_request($parms)->elem;
    }

    public function GetUsers() {
        $parms = array();
        $parms ['func'] = 'user';
        return $this->_request($parms)->elem;
    }

    public function AddUser($name, $parms) {
        $parms_default = array();
        $parms_default ['func'] = 'user.edit';
        $parms_default ['sok'] = 'yes';
        $parms = array_merge($parms_default, (array) $parms);
        $result = $this->_request($parms);
      //  echo '<pre>' . print_r($result, 1) . '</pre>';

        return (isset($result->result) && $result->result == 'OK');
    }

    public function GetPresets() {
        $parms = array();
        $parms ['func'] = 'preset';
        return $this->_request($parms)->elem;
    }

    public function GetPreset($name) {
        $parms_default = array();
        $parms_default ['func'] = 'preset.edit';
        $parms_default ['elid'] = $name;
        $parms = array_merge($parms_default, (array) $parms);
        return $this->_request($parms);
    }

    public function EditPreset($name, $parms) {
        $parms_default = array();
        $parms_default ['func'] = 'preset.edit';
        $parms_default ['sok'] = 'yes';
        $parms_default ['elid'] = $name;
        $parms = array_merge($parms_default, (array) $parms);
        $result = $this->_request($parms);
        return empty($result->error);
    }

    public function DeletePreset($name) {
        $parms = array();
        $parms ['func'] = 'preset.delete';
        $parms ['elid'] = $name;
        $result = $this->_request($parms);
        return empty($result->error);
    }

    public function AddPreset($name, $parms) {
        $parms_default = array();
        $parms_default ['func'] = 'preset.edit';
        $parms_default ['sok'] = 'yes';
        $parms = array_merge($parms_default, (array) $parms);
        $result = $this->_request($parms);
        return empty($result->error);
    }

    protected function _request($parms = false) {
        $parms_default = array();
        if ($this->_session) {
            $parms_default ['auth'] = $this->_session; // для авторизации
        }
        $parms_default ['out'] = 'json';

        $parms = array_merge($parms_default, (array) $parms);
        $get = array();
        foreach ($parms as $name => $val) {
            $get [] = urlencode($name) . '=' . urlencode($val);
        }
        
        $url = "ssl://$this->_host:443/manager/ispmgr?" . implode('&', $get);
       // echo output_text($url)."<br />";
        
        
        $curl = new curl($url);
        $content = $curl->getContent();
        $json = new JSON ();
        $object = $json->unserialize($content);
        if (isset($object->ok) && $object->ok == 'restart') {
            // непонятно по какой блядской логике панель вместо того, чтобы самой перезапустить апач просит это сделать вручную.
            $this->Restart();
        }
        return $object;
    }

}

?>