<?php

class menu {

    var $tpl = 'design.listing.tpl';
    var $icons = true; // отображение иконок меню
    var $file; // путь к ini файлу меню
    var $menu_arr = array(); // загруженный INI файл меню в массив
    protected $_posts = array(); // массив меню для обработки шаблоном
    protected $_menu = array();
    protected $_values = array(); // переменные, доступные в строках меню

    function __construct($menu_name) {
        $this->menu($menu_name);
    }

    public function menu($menu_name) {
        $this->file = H . '/sys/ini/menu.' . $menu_name . '.ini';
        if ($menu_arr = ini::read($this->file, true)) {
            $this->menu_arr = $menu_arr;
        } else
            $this->menu_arr = array('Ошибка загрузки меню ' . $menu_name => array('icon' => 'err.png'));
    }

    /**
     * menu::processing()
     * Преобразование массива INI в массив, понятный шаблону и фильтрация пунктов меню
     * @return void
     */
    private function processing() {
        global $user, $dcms;
        foreach ($this->menu_arr as $key => $value) {
            if ($user->group < @$value['group']) {
                continue;
            }
            if (!empty($value['for_vip']) && !$user->is_vip) {
                continue;
            }





            $url = false;
            if (empty($value['razdel'])) {
                $url = for_value(@$this->value($value['url']));
                $title = '<a href="' . $url . '">' . $key . '</a>';
            } else {
                $title = '<span style="font-weight:bold">' . $key . '</span>';
            }
            $icon = ($this->icons && !empty($value['icon'])) ? array('size' => 'small', 'src' => '/sys/images/icons/' . $value['icon']) : false;
            $this->_posts[] = array(
                'title' => $title,
                'icon' => $icon,
                'url' => $url
            );





            $this->_menu[] = array(
                'razdel' => @$value['razdel'],
                'name' => $key,
                'url' => $url,
                'icon' => ($this->icons && !empty($value['icon'])) ? '/sys/images/icons/' . $value['icon'] : false
            );
        }
        // print_r($this->menu_arr);
    }

    private function value($str) {
        if (!$this->_values)
            return $str;
        return preg_replace('#\{\$(.+?)\}#e', '$this->_values[\\1]', $str);
    }

    /**
     * menu::display()

     * Отображение меню
     * @return void
     */
    public function display() {
        $this->processing();
        $tpl = new design();
        $tpl->assign('menu', $this->_menu);
        $tpl->assign('post', $this->_posts);
        $tpl->display($this->tpl);
    }

    /**
     * menu::value_add()
     * Добавляем переменную
     * @param string $name имя переменной
     * @param string $value значение переменной
     * @return void
     */
    public function value_add($name, $value) {
        $this->_values[$name] = $value;
    }

}

?>