<?php

abstract class text {

    static function icq_uin($icq) {
        if (preg_match('#[0-9]{5,9}#', $icq, $res))
            return $res[0];
        return null;
    }

    static function for_opis($text) {
        global $dcms;
        $text = self::substr($text, $dcms->browser_type == 'web' ? 10000 : 2048);
        $text = self::output_text($text);
        return $text;
    }

    static function strlen($str) {
        if (function_exists('mb_substr'))
            return mb_strlen($str);
        if (function_exists('iconv'))
            return iconv_strlen($str);
        return strlen($str);
    }

    static function substr($text, $len, $start = 0, $mn = ' (...)') {
        $text = trim($text);
        if (function_exists('mb_substr'))
            return mb_substr($text, $start, $len) . (mb_strlen($text) > $len - $start ? $mn : null);
        if (function_exists('iconv'))
            return iconv_substr($text, $start, $len) . (iconv_strlen($text) > $len - $start ? $mn : null);

        return $text;
    }

    static function input_text($str) {
        // обработка входящего текста
        $str = (string) $str;
        $str = preg_replace_callback('#^([a-zа-яё][a-zа-яё0-9\-\_\ ]{2,31}),#uim', array('text', 'nick'), $str);

        return preg_replace("#(^( |\r|\n)+)|(( |\r|\n)+$)|([^0-9a-zа-яёїієґ\r\n" . preg_quote(' []|`@\'"-_+=~!#:;$%^&*()?/\\.,<>{}©', '#') . "]+)#ui", '', $str);
    }

    // вывод обработанного текста
    static function output_text($str) {
        $str = htmlentities($str, ENT_QUOTES, 'UTF-8');
        $str = trim($str);
        $str = smiles::input($str);
        // обработка URL
        $str = preg_replace('#(^|\s|\(|\])([a-z]+://([^ \r\n\t`\'"<]+))(,|\[|<|\s|$)#iuU', '\1[url="\2"]\2[/url]\4', $str);
        // обработка bbcode
        $str = bbcode::output($str);
        $str = nl2br($str);
        return $str;
    }

    // поиск ника в базе, ссылка на анкету
    static function nick($value) {
        if (!@mysql_ping()) {
            return false;
        }
        $nick = $value[1];
        $q = mysql_query("SELECT `id` FROM `users` WHERE `login` = '" . my_esc($nick) . "' LIMIT 1");
        if ($ank = mysql_fetch_assoc($q)) {
            return '[user]' . $ank['id'] . '[/user],';
        }else
            return $nick . ',';
    }

    // для input value
    static function for_value($str) {
        return trim(htmlentities($str, ENT_QUOTES, 'UTF-8'));
    }

    // для названия в базе
    static function for_name($text) {
        return trim(preg_replace('#[^0-9a-zа-яёïієґ\=\?\!\@\#\$^\*\(\)\-_\+ ,\.:;]+#ui', '', $text));
    }

    static function for_filename($text) {
        return trim(preg_replace('#(^\.)|[^a-z0-9_\-\(\)\.]+#ui', '_', self::translit($text)));
    }

    static function translit($string) {
        $table = array(
            'А' => 'A',
            'Б' => 'B',
            'В' => 'V',
            'Г' => 'G',
            'Д' => 'D',
            'Е' => 'E',
            'Ё' => 'YO',
            'Ж' => 'ZH',
            'З' => 'Z',
            'И' => 'I',
            'Й' => 'J',
            'К' => 'K',
            'Л' => 'L',
            'М' => 'M',
            'Н' => 'N',
            'О' => 'O',
            'П' => 'P',
            'Р' => 'R',
            'С' => 'S',
            'Т' => 'T',
            'У' => 'U',
            'Ф' => 'F',
            'Х' => 'H',
            'Ц' => 'C',
            'Ч' => 'CH',
            'Ш' => 'SH',
            'Щ' => 'CSH',
            'Ь' => '',
            'Ы' => 'Y',
            'Ъ' => '',
            'Э' => 'E',
            'Ю' => 'YU',
            'Я' => 'YA',
            'а' => 'a',
            'б' => 'b',
            'в' => 'v',
            'г' => 'g',
            'д' => 'd',
            'е' => 'e',
            'ё' => 'yo',
            'ж' => 'zh',
            'з' => 'z',
            'и' => 'i',
            'й' => 'j',
            'к' => 'k',
            'л' => 'l',
            'м' => 'm',
            'н' => 'n',
            'о' => 'o',
            'п' => 'p',
            'р' => 'r',
            'с' => 's',
            'т' => 't',
            'у' => 'u',
            'ф' => 'f',
            'х' => 'h',
            'ц' => 'c',
            'ч' => 'ch',
            'ш' => 'sh',
            'щ' => 'csh',
            'ь' => '',
            'ы' => 'y',
            'ъ' => '',
            'э' => 'e',
            'ю' => 'yu',
            'я' => 'ya',
        );
        return str_replace(array_keys($table), array_values($table), $string);
    }

}

?>