<?php
class theme {
    protected $_config = array();
    protected $_vars = array();
    protected $_need_save = false;
    protected $_is_avaible = false; // доступность темы
    var $name;
    var $runame;
    var $content;
    var $browser;
    var $img_width_max = 300;

    function __construct($name)
    {
        $this->name = $name; // имя папки темы
        $this->runame = $name; // имя темы (отображаемое)
        $this->content = 'html'; // выдаваемый контент темы (html, xhtml, wml)
        $this->img_width_max = '300';
        $this->browser = 'all'; // тип браузера, на который ориентирована тема (wap, pda, web)
        if ($data = ini::read(H . '/sys/themes/' . $this->name . '/config.ini', true)) {
            $this->_config = array_merge($this->_config, (array)$data['CONFIG']);
            $this->_vars = array_merge($this->_vars, (array)$data['VARS']);
            $this->_is_avaible = true;
        }
        if (!empty($this->_config['runame']))$this->runame = $this->_config['runame'];
        if (!empty($this->_config['content']))$this->content = $this->_config['content'];
        if (!empty($this->_config['img_width_max']))$this->img_width_max = $this->_config['img_width_max'];
        if (!empty($this->_config['browser']))$this->browser = $this->_config['browser'];
    }
    // доступность темы
    function is_avaible()
    {
        return $this->_is_avaible;
    }

    function __get($n)
    {
        return isset($this->_vars[$n])?$this->_vars[$n]:false;
    }

    function __set($n, $v)
    {
        $this->_vars[$n] = $v;
        $this->_need_save = true;
    }

    function setConfig($n, $v)
    {
        $this->_config[$n] = $v;
        $this->_need_save = true;
    }
    // сохранение настроек
    function saveSettings()
    {
        if (!$this->_need_save)return true;
        return ini::save(H . '/sys/themes/' . $this->name . '/config.ini', array('CONFIG' => $this->_config, 'VARS' => $this->_vars), true);
    }

    function __destruct()
    {
        $this->saveSettings();
    }
}

?>
