<?php
/**
 * Класс для кэширования данных во временной папке.
 * По сути является костылем при отсутствии встроенного в php механизма кэширования.
 */
class tmp_cache {
	function get($key) {
		$path = self::path ( $key );
		// чтение данных из файла
		if (! $content = @file_get_contents ( $path ))
			return false;
			// разбор данных
		if (! $data = @unserialize ( $content ))
			return false;
			// проверка актуальности данных
		if ($data ['a'] < TIME) {
			@unlink ( $path );
			return false;
		}
		
		return $data ['d'];
	}
	
	function set($key, $data, $ttl) {
		$path = self::path ( $key );
		
		// удаленный кэш все равно вернет false, поэтому в целях незахламления папки tmp лучше файл удалить
		if ($data === false)
			return @unlink ( $path );
		
		$data2 ['d'] = $data;
		$data2 ['a'] = TIME + $ttl;
		
		return @file_put_contents ( $path, serialize ( $data2 ) );
	}
	// получение пути к файлу кэша по ключу
	static function path($key) {
		return TEMP . '/' . urlencode ( $key ) . '.cache';
	}
}

?>
