-- Структура таблицы `worldkassa`
CREATE TABLE IF NOT EXISTS `worldkassa` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Внутренний ID платежа',
  `id_bill` int(11) unsigned NOT NULL COMMENT 'ID платежа в Worldkassa',
  `init` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Время инициализации платежа',
  `payment` datetime NOT NULL COMMENT 'Время оплаты',
  `summa` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT 'Сумма',
  `days` int(11) NOT NULL DEFAULT '0' COMMENT 'Количество дней',
  `expire` datetime NOT NULL COMMENT 'Истекает',
  `url` varchar(50) NOT NULL COMMENT 'Адрес сайта',
  `name` varchar(32) NOT NULL COMMENT 'Название ссылки',
  `color` varchar(20) NOT NULL COMMENT 'Цвет ссылки',
  `bold` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Жирный',
  `italic` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Курсивный',
  PRIMARY KEY (`id`),
  KEY `time_expire` (`expire`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Статистика платежей через WorldKassa';