<?php
function clean($string) {
$trans1= array("'",'`',',',' ',"Ё","Ж","Ч","Ш","Щ","Э","Ю","Я","ё","ж","ч","ш","щ","э","ю","я","А","Б","В","Г","Д","Е","З","И","Й","К","Л","М","Н","О","П","Р","С","Т","У","Ф","Х","Ц","Ь","Ы","а","б","в","г","д","е","з","и","й","к","л","м","н","о","п","р","с","т","у","ф","х","ц","ь","ы");
$trans2= array('_','_','_','_',"JO","ZH","CH","SH","SCH","Je","Jy","Ja","jo","zh","ch","sh","sch","je","jy","ja","A","B","V","G","D","E","Z","I","J","K","L","M","N","O","P","R","S","T","U","F","H","C","","Y","a","b","v","g","d","e","z","i","j","k","l","m","n","o","p","r","s","t","u","f","h","c","","y");
   $string = str_replace($trans1,$trans2,$string); // Replaces all spaces with hyphens.
   $string = str_replace(' ', '_', $string); // Replaces all spaces with hyphens.
   return preg_replace('/[^A-Za-z0-9\-.]/', '_', $string); // Removes special chars.
}
 function size($bytes){
        if ($bytes >= 1073741824) $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        elseif ($bytes >= 1048576) $bytes = number_format($bytes / 1048576, 2) . ' MB';
        elseif ($bytes >= 1024) $bytes = number_format($bytes / 1024, 2) . ' kB';
        elseif ($bytes > 1) $bytes = $bytes . ' bytes';
        elseif ($bytes == 1) $bytes = $bytes . ' byte';
        else $bytes = '0 bytes';
        return $bytes;
}

function CombineMultipleMP3sTo($FilenameOut, $FilenamesIn) {
	foreach ($FilenamesIn as $nextinputfilename) {
		if (is_array($nextinputfilename)) {
			$nextinputfilename = $nextinputfilename[0];
		}
		if (!is_readable($nextinputfilename)) {
			echo 'Cannot read "'.$nextinputfilename.'"<BR>';
			return false;
		}
	}
	if ((file_exists($FilenameOut) && !is_writeable($FilenameOut)) || (!file_exists($FilenameOut) && !is_writeable(dirname($FilenameOut)))) {
		echo 'Cannot write "'.$FilenameOut.'"<BR>';
		return false;
	}
	require_once('getid3/getid3.php');
	ob_start();
	if ($fp_output = fopen($FilenameOut, 'wb')) {
		ob_end_clean();
		// Initialize getID3 engine
		$getID3 = new getID3;
		foreach ($FilenamesIn as $nextinputfilename) {
			$startoffset = 0;
			$length_seconds      = 0;
			if (is_array($nextinputfilename)) {
				@list($nextinputfilename, $startoffset, $length_seconds)  = $nextinputfilename;
			}
			$CurrentFileInfo = $getID3->analyze($nextinputfilename);
			if ($CurrentFileInfo['fileformat'] == 'mp3') {
				ob_start();
				if ($fp_source = fopen($nextinputfilename, 'rb')) {
					ob_end_clean();
					$CurrentOutputPosition = ftell($fp_output);
					// copy audio data from first file
					$start_offset_bytes = $CurrentFileInfo['avdataoffset'];
					if ($startoffset > 0) { // start X seconds from start of audio
						$start_offset_bytes = $CurrentFileInfo['avdataoffset'] + round($CurrentFileInfo['bitrate'] / 8 * $startoffset);
					} elseif ($startoffset < 0) { // start X seconds from end of audio
						$start_offset_bytes = $CurrentFileInfo['avdataend'] + round($CurrentFileInfo['bitrate'] / 8 * $startoffset);
					}
					$start_offset_bytes = max($CurrentFileInfo['avdataoffset'], min($CurrentFileInfo['avdataend'], $start_offset_bytes));
					$end_offset_bytes = $CurrentFileInfo['avdataend'];
					if ($length_seconds > 0) { // seconds from start of audio
						$end_offset_bytes = $start_offset_bytes + round($CurrentFileInfo['bitrate'] / 8 * $length_seconds);
					} elseif ($length_seconds < 0) { // seconds from start of audio
						$end_offset_bytes = $CurrentFileInfo['avdataend'] + round($CurrentFileInfo['bitrate'] / 8 * $startoffset);
					}
					$end_offset_bytes = max($CurrentFileInfo['avdataoffset'], min($CurrentFileInfo['avdataend'], $end_offset_bytes));
					if ($end_offset_bytes <= $start_offset_bytes) {
						echo 'failed to copy '.$nextinputfilename.' from '.$startoffset.'-seconds start for '.$length_seconds.'-seconds length (not enough data)';
						fclose($fp_source);
						fclose($fp_output);
						return false;
					}
					fseek($fp_source, $start_offset_bytes, SEEK_SET);
					while (!feof($fp_source) && (ftell($fp_source) < $end_offset_bytes)) {
						fwrite($fp_output, fread($fp_source, min(32768, $end_offset_bytes - ftell($fp_source))));
					}
					fclose($fp_source);
				} else {
					$errormessage = ob_get_contents();
					ob_end_clean();
					echo 'failed to open '.$nextinputfilename.' for reading';
					fclose($fp_output);
					return false;
				}
			} else {
				echo $nextinputfilename.' is not MP3 format';
				fclose($fp_output);
				return false;
			}
		}
	} else {
		$errormessage = ob_get_contents();
		ob_end_clean();
		echo 'failed to open '.$FilenameOut.' for writing';
		return false;
	}
	fclose($fp_output);
	return true;
}


?>