DROP TABLE IF EXISTS `cms_ads`;

CREATE TABLE `cms_ads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `view` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `layout` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `count_link` int(10) unsigned NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `link` text NOT NULL,
  `to` int(10) unsigned NOT NULL DEFAULT '0',
  `color` varchar(10) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `day` int(10) unsigned NOT NULL DEFAULT '0',
  `mesto` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `bold` tinyint(1) NOT NULL DEFAULT '0',
  `italic` tinyint(1) NOT NULL DEFAULT '0',
  `underline` tinyint(1) NOT NULL DEFAULT '0',
  `show` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO cms_ads VALUES("1","1","0","0","8","0","uzclub","http://uzclub.ru","0","ff0000","1475636289","0","1","1","1","0","0");



DROP TABLE IF EXISTS `cms_album_cat`;

CREATE TABLE `cms_album_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `password` varchar(20) NOT NULL DEFAULT '',
  `access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `access` (`access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_comments`;

CREATE TABLE `cms_album_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_downloads`;

CREATE TABLE `cms_album_downloads` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_files`;

CREATE TABLE `cms_album_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `album_id` int(10) unsigned NOT NULL,
  `description` text NOT NULL,
  `img_name` varchar(100) NOT NULL DEFAULT '',
  `tmb_name` varchar(100) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `comments` tinyint(1) NOT NULL DEFAULT '1',
  `comm_count` int(10) unsigned NOT NULL DEFAULT '0',
  `access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `vote_plus` int(11) NOT NULL DEFAULT '0',
  `vote_minus` int(11) NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `downloads` int(10) unsigned NOT NULL DEFAULT '0',
  `unread_comments` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `album_id` (`album_id`),
  KEY `access` (`access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_views`;

CREATE TABLE `cms_album_views` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_votes`;

CREATE TABLE `cms_album_votes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `vote` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `file_id` (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_ban_ip`;

CREATE TABLE `cms_ban_ip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip1` bigint(11) NOT NULL DEFAULT '0',
  `ip2` bigint(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '0',
  `link` varchar(100) NOT NULL,
  `who` varchar(25) NOT NULL,
  `reason` text NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip1` (`ip1`),
  UNIQUE KEY `ip2` (`ip2`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_ban_users`;

CREATE TABLE `cms_ban_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ban_time` int(11) NOT NULL DEFAULT '0',
  `ban_while` int(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '1',
  `ban_who` varchar(30) NOT NULL DEFAULT '',
  `ban_ref` int(11) NOT NULL DEFAULT '0',
  `ban_reason` text NOT NULL,
  `ban_raz` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `ban_time` (`ban_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_contact`;

CREATE TABLE `cms_contact` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `friends` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `man` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`user_id`,`from_id`),
  KEY `time` (`time`),
  KEY `ban` (`ban`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO cms_contact VALUES("1","2","1","1475595863","1","0","0","0");
INSERT INTO cms_contact VALUES("2","1","2","1475595863","1","0","0","0");



DROP TABLE IF EXISTS `cms_counters`;

CREATE TABLE `cms_counters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sort` int(10) NOT NULL DEFAULT '1',
  `name` varchar(30) NOT NULL,
  `link1` text NOT NULL,
  `link2` text NOT NULL,
  `mode` tinyint(4) NOT NULL DEFAULT '1',
  `switch` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO cms_counters VALUES("1","1","live","<center><!--LiveInternet counter--><script type=\"text/javascript\"><!--\r\ndocument.write(\"<a href=\'//www.liveinternet.ru/click\' \"+\r\n\"target=_blank><img src=\'//counter.yadro.ru/hit?t26.6;r\"+\r\nescape(document.referrer)+((typeof(screen)==\"undefined\")?\"\":\r\n\";s\"+screen.width+\"*\"+screen.height+\"*\"+(screen.colorDepth?\r\nscreen.colorDepth:screen.pixelDepth))+\";u\"+escape(document.URL)+\r\n\";\"+Math.random()+\r\n\"\' alt=\'\' title=\'LiveInternet: показано число посетителей за\"+\r\n\" сегодня\' \"+\r\n\"border=\'0\' width=\'88\' height=\'15\'><\\/a>\")\r\n//--></script><!--/LiveInternet-->\r\n</center>","<center><!--LiveInternet counter--><script type=\"text/javascript\"><!--\r\ndocument.write(\"<a href=\'//www.liveinternet.ru/click\' \"+\r\n\"target=_blank><img src=\'//counter.yadro.ru/hit?t26.6;r\"+\r\nescape(document.referrer)+((typeof(screen)==\"undefined\")?\"\":\r\n\";s\"+screen.width+\"*\"+screen.height+\"*\"+(screen.colorDepth?\r\nscreen.colorDepth:screen.pixelDepth))+\";u\"+escape(document.URL)+\r\n\";\"+Math.random()+\r\n\"\' alt=\'\' title=\'LiveInternet: показано число посетителей за\"+\r\n\" сегодня\' \"+\r\n\"border=\'0\' width=\'88\' height=\'15\'><\\/a>\")\r\n//--></script><!--/LiveInternet-->\r\n</center>","1","1");



DROP TABLE IF EXISTS `cms_forum_files`;

CREATE TABLE `cms_forum_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat` int(10) unsigned NOT NULL DEFAULT '0',
  `subcat` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` int(10) unsigned NOT NULL DEFAULT '0',
  `post` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `filename` text NOT NULL,
  `filetype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `dlcount` int(10) unsigned NOT NULL DEFAULT '0',
  `del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat` (`cat`),
  KEY `subcat` (`subcat`),
  KEY `topic` (`topic`),
  KEY `post` (`post`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_forum_rdm`;

CREATE TABLE `cms_forum_rdm` (
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic_id`,`user_id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_forum_vote`;

CREATE TABLE `cms_forum_vote` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(2) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_forum_vote_users`;

CREATE TABLE `cms_forum_vote_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `topic` int(11) NOT NULL,
  `vote` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_library_comments`;

CREATE TABLE `cms_library_comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(11) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_library_rating`;

CREATE TABLE `cms_library_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `st_id` int(11) NOT NULL,
  `point` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`st_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_mail`;

CREATE TABLE `cms_mail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sys` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `delete` int(10) unsigned NOT NULL DEFAULT '0',
  `file_name` varchar(100) NOT NULL DEFAULT '',
  `count` int(10) NOT NULL DEFAULT '0',
  `size` int(10) NOT NULL DEFAULT '0',
  `them` varchar(100) NOT NULL DEFAULT '',
  `spam` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `from_id` (`from_id`),
  KEY `time` (`time`),
  KEY `read` (`read`),
  KEY `sys` (`sys`),
  KEY `delete` (`delete`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO cms_mail VALUES("1","2","1","Topaman bayiby. :D","1475594793","1","0","0","","0","0","","0");
INSERT INTO cms_mail VALUES("2","1","2","xaxaxa","1475595863","0","0","0","","0","0","","0");
INSERT INTO cms_mail VALUES("3","0","1","К файлу в загрузках оставили комментарий. [url=http://uztivi.ru/download/komm.php?id=1]Смотреть[/url]","1475604161","1","1","0","","0","0","","0");



DROP TABLE IF EXISTS `cms_news`;

CREATE TABLE `cms_news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `text` text NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `refid` (`refid`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO cms_news VALUES("1","1","","","1","1324717200");
INSERT INTO cms_news VALUES("2","1","test","teest","1","1475589389");
INSERT INTO cms_news VALUES("3","1","asdasdasdasdasdasdasdas","asdadasdasdsadasd","3","1534269158");
INSERT INTO cms_news VALUES("4","1","efefefefefefefefefef","efefefefefefeefefef","1","1534273227");
INSERT INTO cms_news VALUES("5","2","Xaxa","Xexe","1","1534277271");



DROP TABLE IF EXISTS `cms_news_cat`;

CREATE TABLE `cms_news_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `realid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `desc_enable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `realid` (`realid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO cms_news_cat VALUES("1","1","PREMYERA","1");
INSERT INTO cms_news_cat VALUES("2","2","Foydali","0");



DROP TABLE IF EXISTS `cms_news_comments`;

CREATE TABLE `cms_news_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL,
  `time` int(11) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `time` (`time`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_news_rating`;

CREATE TABLE `cms_news_rating` (
  `id_rate` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `news` int(11) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `golos` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id_rate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_sessions`;

CREATE TABLE `cms_sessions` (
  `session_id` char(32) NOT NULL DEFAULT '',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` varchar(255) NOT NULL DEFAULT '',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `sestime` int(10) unsigned NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `movings` smallint(5) unsigned NOT NULL DEFAULT '0',
  `place` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO cms_sessions VALUES("4823b9a94169efa5c1d506cc156cce21","1476061520","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534424070","1534424070","0","1","mainpage");
INSERT INTO cms_sessions VALUES("b26f5e78f67b7b7369cdfb2d7a8c2a1f","1123631703","0","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1534424200","1534424200","0","1","news");
INSERT INTO cms_sessions VALUES("eefa35b5ccd9f9af245a6dc25fa3fdd8","1123631702","0","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1534428620","1534428610","0","2","");
INSERT INTO cms_sessions VALUES("392c5688909c0daa704d4d72ae59ad8d","100662017","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534419464","1534419464","0","1","mainpage");
INSERT INTO cms_sessions VALUES("7097be35a85bde9b364c4e9072a52455","1297615242","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534415282","1534415282","0","1","mainpage");
INSERT INTO cms_sessions VALUES("535bc8ccedec845b7075d9108f8048ed","621377048","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots)","1534359761","1534359761","0","0","mainpage");
INSERT INTO cms_sessions VALUES("1b8bcbe0d4c76be9e11c0947ac171fec","100662019","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534485621","1534485621","0","1","mainpage");
INSERT INTO cms_sessions VALUES("ed3a06a1b322d6ddcf52fa75ce65accb","1607850674","2956666506","Mozilla/5.0 (Linux; U; Android 7.1.1; en-US; SM-J510FN Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.108 UCBrowser","1534365813","1534365813","0","0","mainpage");
INSERT INTO cms_sessions VALUES("898f35b99470e588fef2fd45752714aa","2388506304","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36","1534372437","1534372437","0","0","mainpage");
INSERT INTO cms_sessions VALUES("65d60dc212aea55f17eb14d2284a1f24","586523837","0","Python/3.6 aiohttp/2.3.2","1534379071","1534379071","0","0","mainpage");
INSERT INTO cms_sessions VALUES("aeabc6571006952b777cb13670a0481b","2901793048","0","Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:55.0) Gecko/20100101 Firefox/55.0","1534382052","1534382052","0","0","mainpage");
INSERT INTO cms_sessions VALUES("d0361ad31fe165aa40b28627b52144fa","3120221752","0","Not Recognised","1534382297","1534382297","0","0","mainpage");
INSERT INTO cms_sessions VALUES("8056ff0d3fe54a89ba017448d68c7ced","3334127719","0","Not Recognised","1534469040","1534469040","0","1","mainpage");
INSERT INTO cms_sessions VALUES("fcd6c992d229d909500d66b1a8d93432","2071807790","0","Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)","1534386720","1534386720","0","0","mainpage");
INSERT INTO cms_sessions VALUES("55bfc55be85f93b34e3ac19dad78541a","3588640601","0","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36 OPR/40.0.2308.90","1534390830","1534390720","0","11","mainpage");
INSERT INTO cms_sessions VALUES("433b8a68faf1028c5c5924ee54d0ac93","2655380870","0","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.34 Safari/537.36","1534395693","1534395693","0","0","mainpage");
INSERT INTO cms_sessions VALUES("abaf42142411f67255a074bd0f134fa0","1113982714","136703278","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1534396276","1534396276","0","0","mainpage");
INSERT INTO cms_sessions VALUES("dd3e41c9af10af6b8826b9009d8fe599","1123636055","2995084792","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1534397161","1534397161","0","0","mainpage");
INSERT INTO cms_sessions VALUES("2d1009f337f945207d18044a34a7b217","1113983259","1412854507","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1534398281","1534398281","0","0","mainpage");
INSERT INTO cms_sessions VALUES("dd7b7474ec5f021d7383f812a119644d","1385287842","628019754","Opera Mini: Nokia206/2.0 (04.52) Profile/MIDP-2.1 Configuration/CLDC-1.1","1534401666","1534401666","0","0","mainpage");
INSERT INTO cms_sessions VALUES("b7e394c23b28a5fb8ffeb7598631140e","628019785","0","Nokia7610/2.0 (5.0509.0) SymbianOS/7.0s Series60/2.1 Profile/MIDP-2.0 Configuration/CLDC-1.0","1534402062","1534402062","0","0","mainpage");
INSERT INTO cms_sessions VALUES("8adbf48fcf937050bd1277fd330d38e4","1607850662","531457348","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; 4027D Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/12.8.5.1121 U3/0.8.0 Mob","1534402543","1534402520","0","2","mainpage");
INSERT INTO cms_sessions VALUES("b793fbfa5c44ef8231ce2572d5dc8f90","3108354608","0","Mozilla/5.0 (Linux; U; Android 7.1.2; ru-ru; Redmi 5 Build/N2G47H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.128 Mobile Safa","1534402747","1534402747","0","0","mainpage");
INSERT INTO cms_sessions VALUES("b993828a630f01ea98774e40b3cd9a6d","621377053","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots)","1534402902","1534402902","0","0","mainpage");
INSERT INTO cms_sessions VALUES("61110ee7d34f8035619c7930fa314755","1476061509","0","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1534407048","1534407048","0","0","mainpage");
INSERT INTO cms_sessions VALUES("3dbeb398b8ee69bd1c2fa0382da4d8ff","1476064267","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534438559","1534438559","0","1","mainpage");
INSERT INTO cms_sessions VALUES("b62a9321a4907c4a6fec600e7275ec72","1123638619","1434721162","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1534407214","1534407214","0","0","mainpage");
INSERT INTO cms_sessions VALUES("6431b320dc843ef4471d5811e805081b","3702877294","0","Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)","1534410921","1534410921","0","0","mainpage");
INSERT INTO cms_sessions VALUES("974caaaeba81610b9ed0e0661d2ca727","1607850590","3161587677","NokiaC2-01/5.0 (11.40) Profile/MIDP-2.1 Configuration/CLDC-1.1 UCWEB/2.0 (Java; U; MIDP-2.0; ru; nokiac2-01) U2/1.0.0 UCBrowser/8.9.0.251 U2/1.0.0 Mob","1534411975","1534411974","0","4","mainpage");
INSERT INTO cms_sessions VALUES("41025dd6fa38d26311e2157d30a769c2","2918783021","0","Mozilla/5.0 (Windows NT 8.0; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0","1534419247","1534419243","0","3","guestbook");
INSERT INTO cms_sessions VALUES("67af041910d8fac40dc24e93a11beb71","2366147978","0","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1534419555","1534419555","0","0","downsearch");
INSERT INTO cms_sessions VALUES("3c03da1865e7bd15e11f6c8d76d44c67","875940174","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36","1534420229","1534420229","0","0","mainpage");
INSERT INTO cms_sessions VALUES("9b1c38f9c208b00b67ea5dbade335ad2","774546917","0","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 YaBrowser/17.10.1.1204 Yowser/2.5 Safari/537.36","1534422329","1534422329","0","0","mainpage");
INSERT INTO cms_sessions VALUES("b674e4a9df12aa7c69b2e35840f58bbd","1123631701","0","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1534448211","1534448210","0","2","mainpage");
INSERT INTO cms_sessions VALUES("94c6686359a045411467673ad83aaff1","1588892610","0","Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)","1534426726","1534426726","0","0","mainpage");
INSERT INTO cms_sessions VALUES("7140a1a1d08634fb1e6667b9575b214e","1427809324","0","Mozilla/5.0 (Windows NT 6.2; ARM; Trident/7.0; Touch; rv:11.0; WPDesktop; Lumia 435 Dual SIM) like Gecko","1534430093","1534430093","0","0","mainpage");
INSERT INTO cms_sessions VALUES("7a2a4f7b31af3699cc6edc7f681928c5","1607850607","3161585666","UCWEB/2.0 (MIDP-2.0; U; Adr 5.1.1; ru; SM-J320H) U2/1.0.0 UCBrowser/9.3.0.440 U2/1.0.0 Mobile","1534432166","1534432121","0","9","mainpage");
INSERT INTO cms_sessions VALUES("426e4899406fedddcc3ff72d8b5759d4","628021010","0","Mozilla/5.0 (Linux; Android 5.1; HUAWEI CUN-L21 Build/HUAWEICUN-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.110 Mobile Safari/537.36 ","1534433231","1534433170","0","4","mainpage");
INSERT INTO cms_sessions VALUES("2f64f8fd69551925f143924e48033a23","86887185","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534433917","1534433917","0","0","mainpage");
INSERT INTO cms_sessions VALUES("170121ec0d43b6b0bc4f0efb318a81d5","1113983255","628019800","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1534436134","1534436134","0","0","mainpage");
INSERT INTO cms_sessions VALUES("5b08eecd0cbd8af4003f4d2b48110eb8","1161474618","0","Mozilla/5.0 (compatible; ips-agent)","1534436323","1534436311","0","2","load");
INSERT INTO cms_sessions VALUES("ba49331e155f56a09a250e2445b3b2b1","2834026400","628021064","Nokia2700c-2/2.0 (09.98) Profile/MIDP-2.1 Configuration/CLDC-1.1 UCWEB/2.0 (Java; U; MIDP-2.0; en-US; Nokia2700c-2) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.","1534439648","1534439646","0","6","mainpage");
INSERT INTO cms_sessions VALUES("459b3c98c13d7d98590b4b141cd234e8","1113983259","520982618","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1534441540","1534441540","0","0","mainpage");
INSERT INTO cms_sessions VALUES("4574b139e844f4411933d579830a8460","1607850674","2956666226","Mozilla/5.0 (Linux; U; Android 7.1.1; en-US; SM-J510FN Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.108 UCBrowser","1534442540","1534442540","0","0","mainpage");
INSERT INTO cms_sessions VALUES("360650f1ffafc67937ad9d4b4cbd35d0","1476061510","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534460267","1534460267","0","1","mainpage");
INSERT INTO cms_sessions VALUES("c7d7f398c7ce4f69f6fa3e64836df7af","1123631662","0","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1534445327","1534445327","0","0","mainpage");
INSERT INTO cms_sessions VALUES("97b53c6e890422258ffa33f71d3ce29a","86887183","0","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1534446872","1534446872","0","0","news");
INSERT INTO cms_sessions VALUES("36ffcf5bcaa2e4f252b6e9432cb0fc84","86887186","0","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1534446877","1534446877","0","0","news");
INSERT INTO cms_sessions VALUES("3a36be257d9b08b2f97db4c8529be82c","1297615235","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534447561","1534447561","0","0","mainpage");
INSERT INTO cms_sessions VALUES("0c44ccdb2ff00dc84c8fa2525c9e4007","1607850662","1402283480","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; 4027D Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/12.8.5.1121 U3/0.8.0 Mob","1534451863","1534451862","0","2","mainpage");
INSERT INTO cms_sessions VALUES("ac65d03005861853f5d16a53b3184e65","1607850674","2956667453","Mozilla/5.0 (Linux; U; Android 7.1.1; en-US; SM-J510FN Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.108 UCBrowser","1534450840","1534450756","0","7","mainpage");
INSERT INTO cms_sessions VALUES("e120663db67489ff2e6efee3682d9e47","1123638615","85517760","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1534451223","1534451223","0","0","mainpage");
INSERT INTO cms_sessions VALUES("ab7641cfefda278ca1763707705c5d2d","2366147975","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534451810","1534451810","0","0","mainpage");
INSERT INTO cms_sessions VALUES("3865e10ac71a8a9f02d80b4109c4b095","2938776116","0","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.89 Safari/537.1","1534453292","1534453292","0","0","mainpage");
INSERT INTO cms_sessions VALUES("3aaef34d1d93199f1cd435d1b597ca0c","1604583277","0","Mozilla/5.0 (compatible; Linux x86_64; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)","1534453319","1534453319","0","0","mainpage");
INSERT INTO cms_sessions VALUES("e71d5ea71762fa900ffe7fd7dc760ac7","1604583271","0","Mozilla/5.0 (compatible; Linux x86_64; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)","1534453326","1534453326","0","0","mainpage");
INSERT INTO cms_sessions VALUES("bf11b280287f366046b351f32b69cb29","1476064259","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534455916","1534455916","0","0","mainpage");
INSERT INTO cms_sessions VALUES("443d49909dcb8a4d324759bfaff8e2f1","1123631623","0","Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.96 Mobile Safari/537.36 (compatible;","1534457946","1534457946","0","0","mainpage");
INSERT INTO cms_sessions VALUES("2c582cb79ed8dddd695534d698e46583","1123631634","0","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1534462713","1534462713","0","0","mainpage");
INSERT INTO cms_sessions VALUES("9c36ddaab171cebaaa72e2e73dca3982","1123631634","0","Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.96 Mobile Safari/537.36 (compatible;","1534462768","1534462768","0","0","mainpage");
INSERT INTO cms_sessions VALUES("5476250c50167d869b00e03d574737d4","86887177","0","Mozilla/5.0 (compatible; YandexImages/3.0; +http://yandex.com/bots)","1534464139","1534464139","0","0","mainpage");
INSERT INTO cms_sessions VALUES("2e29ded99f3b587fb8e736ef767f4b36","86887172","0","Mozilla/5.0 (compatible; YandexImages/3.0; +http://yandex.com/bots)","1534464145","1534464145","0","0","mainpage");
INSERT INTO cms_sessions VALUES("4364cc8d23daa36b3da9ad2ee5d2701c","1297615239","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534464833","1534464833","0","0","mainpage");
INSERT INTO cms_sessions VALUES("5f3ca7c9024798d1bd9f28425fbe0d7d","1476064263","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534502451","1534502451","0","1","mainpage");
INSERT INTO cms_sessions VALUES("02dba001b86a32bd36dca96ec9dd1c98","1123631775","0","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1534471779","1534471779","0","0","mainpage");
INSERT INTO cms_sessions VALUES("a977d0452517f7b362ee046a234c5ca5","1123631774","0","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1534471823","1534471823","0","0","Valyutalar kursi 24 ta davlatlar puli - Ajoyib.Ru");
INSERT INTO cms_sessions VALUES("fd1a5a0be850f4c75292dc996377f9ec","100662022","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534506600","1534506600","0","1","mainpage");
INSERT INTO cms_sessions VALUES("c0fa9d06ed36eeb846832ccfe908b682","1123631773","0","Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.96 Mobile Safari/537.36 (compatible;","1534473412","1534473412","0","0","mainpage");
INSERT INTO cms_sessions VALUES("094224e779ccf20c3bf0848f2c903096","100662027","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534494117","1534494117","0","1","mainpage");
INSERT INTO cms_sessions VALUES("6409cea63b34b4757b93f8ca13e6b52f","602384372","0","Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4) Gecko/20030624","1534478993","1534478993","0","1","mainpage");
INSERT INTO cms_sessions VALUES("153d20aad137eee60f82d67b8c3e0d6b","1412854402","0","Nokia6303iclassic/5.0 (09.83) Profile/MIDP-2.1 Configuration/CLDC-1.1 Mozilla/5.0 AppleWebKit/420+ (KHTML, like Gecko) Safari/420+","1534479296","1534479149","0","6","loadtop");
INSERT INTO cms_sessions VALUES("13acc344e2c64b777d6a8a17c6064f4e","1607850673","3648413019","Mozilla/5.0 (Linux; U; Android 7.0; en-US; BQru_BQru-5058 Build/NRD90M) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.5.850 U3/0.8","1534479968","1534479880","0","4","");
INSERT INTO cms_sessions VALUES("7baa3b2bc0543bb8da1b63ecef557dbf","86887172","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534490125","1534490125","0","1","mainpage");
INSERT INTO cms_sessions VALUES("c15fe6a4b134fe93e1143137989d670d","532213271","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36","1534483830","1534483829","0","3","guestbook");
INSERT INTO cms_sessions VALUES("2d55fd23a8555d9a43e8a3f3e35d2039","1806131727","1833233401","Opera Mini: Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; Hit Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30","1534485883","1534485852","0","2","mainpage");
INSERT INTO cms_sessions VALUES("0469491af184923ef09a49073a6eee9c","1806132165","1833233401","Opera Mini: Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; Hit Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30","1534486057","1534486057","0","0","mainpage");
INSERT INTO cms_sessions VALUES("591272d35ab3b503e9ff81d0d48c0ec1","1607850674","2956666522","Mozilla/5.0 (Linux; U; Android 7.1.1; en-US; SM-J510FN Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.108 UCBrowser","1534489825","1534489822","0","1","mainpage");
INSERT INTO cms_sessions VALUES("b084cdb103f0bd0e4d19f479d67ed671","2953769778","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:57.0) Gecko/20100101 Firefox/57.0","1534490904","1534490904","0","0","mainpage");
INSERT INTO cms_sessions VALUES("89d4861dc7cce337a82ad6b09fd3afe1","1310252033","0","Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)","1534499188","1534499188","0","0","mainpage");
INSERT INTO cms_sessions VALUES("9e59ecbb3669b6536bdf87522431884c","1476064261","0","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1534499976","1534499976","0","0","Valyutalar kursi 24 ta davlatlar puli - Ajoyib.Ru");
INSERT INTO cms_sessions VALUES("9d22731eab9946c413fea2548b4b34bf","908367494","0","Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)","1534500803","1534500803","0","0","mainpage");
INSERT INTO cms_sessions VALUES("61002855b44de21e23da3a929e13c19d","1476064265","0","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1534511958","1534511958","0","1","chat");
INSERT INTO cms_sessions VALUES("b69c63e20707f3eea554fd6817f54a7f","1607850674","2956668563","Mozilla/5.0 (Linux; U; Android 7.1.1; en-US; SM-J510FN Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.108 UCBrowser","1534505901","1534505901","0","0","mainpage");
INSERT INTO cms_sessions VALUES("c613edcabe317e8c6c135dbc838589ba","86887181","0","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1534506058","1534506058","0","0","registration");
INSERT INTO cms_sessions VALUES("23343c79a8715a6fb00df5bacd7a892e","1476061514","0","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots yabs01)","1534510810","1534510810","0","0","mainpage");
INSERT INTO cms_sessions VALUES("b907541be3aea0606df77412801f1659","2152060646","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:57.0) Gecko/20100101 Firefox/57.0","1534511243","1534511243","0","0","mainpage");



DROP TABLE IF EXISTS `cms_settings`;

CREATE TABLE `cms_settings` (
  `key` tinytext NOT NULL,
  `val` text NOT NULL,
  PRIMARY KEY (`key`(30))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO cms_settings VALUES("active","1");
INSERT INTO cms_settings VALUES("admp","panel");
INSERT INTO cms_settings VALUES("antiflood","a:5:{s:4:\"mode\";i:2;s:3:\"day\";i:10;s:5:\"night\";i:30;s:7:\"dayfrom\";i:10;s:5:\"dayto\";i:22;}");
INSERT INTO cms_settings VALUES("clean_time","1534445327");
INSERT INTO cms_settings VALUES("copyright","PREMYERA.NET - EXCLUSIVE PORTAL!");
INSERT INTO cms_settings VALUES("email","@");
INSERT INTO cms_settings VALUES("flsz","4000");
INSERT INTO cms_settings VALUES("gzip","1");
INSERT INTO cms_settings VALUES("homeurl","http://premyera.net");
INSERT INTO cms_settings VALUES("karma","a:6:{s:12:\"karma_points\";i:5;s:10:\"karma_time\";i:86400;s:5:\"forum\";i:20;s:4:\"time\";i:0;s:2:\"on\";i:1;s:3:\"adm\";i:0;}");
INSERT INTO cms_settings VALUES("lng","ru");
INSERT INTO cms_settings VALUES("mod_reg","2");
INSERT INTO cms_settings VALUES("mod_forum","2");
INSERT INTO cms_settings VALUES("mod_guest","2");
INSERT INTO cms_settings VALUES("mod_lib","2");
INSERT INTO cms_settings VALUES("mod_gal","2");
INSERT INTO cms_settings VALUES("mod_down_comm","1");
INSERT INTO cms_settings VALUES("mod_down","2");
INSERT INTO cms_settings VALUES("mod_lib_comm","1");
INSERT INTO cms_settings VALUES("mod_gal_comm","1");
INSERT INTO cms_settings VALUES("meta_desc","PREMYERA.NET");
INSERT INTO cms_settings VALUES("meta_key","PREMYER.NET");
INSERT INTO cms_settings VALUES("news","a:8:{s:4:\"view\";i:1;s:4:\"size\";i:200;s:8:\"quantity\";i:5;s:4:\"days\";i:3;s:6:\"breaks\";i:1;s:7:\"smileys\";i:1;s:4:\"tags\";i:1;s:3:\"kom\";i:1;}");
INSERT INTO cms_settings VALUES("reg_message","");
INSERT INTO cms_settings VALUES("setting_mail","");
INSERT INTO cms_settings VALUES("skindef","DPR");
INSERT INTO cms_settings VALUES("them_message","");
INSERT INTO cms_settings VALUES("timeshift","0");
INSERT INTO cms_settings VALUES("site_access","2");



DROP TABLE IF EXISTS `cms_users_data`;

CREATE TABLE `cms_users_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(30) NOT NULL DEFAULT '',
  `val` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_users_guestbook`;

CREATE TABLE `cms_users_guestbook` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_users_iphistory`;

CREATE TABLE `cms_users_iphistory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `user_ip` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

INSERT INTO cms_users_iphistory VALUES("20","1","1412854423","0","1534275496");
INSERT INTO cms_users_iphistory VALUES("21","1","2365590757","1412854428","1534277576");
INSERT INTO cms_users_iphistory VALUES("22","1","2365590773","1412854419","1534286032");
INSERT INTO cms_users_iphistory VALUES("23","1","3105535198","1412854418","1534510143");



DROP TABLE IF EXISTS `down_bookmarks`;

CREATE TABLE `down_bookmarks` (
  `user` int(11) NOT NULL,
  `file` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `downfiles`;

CREATE TABLE `downfiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(2) NOT NULL DEFAULT '0',
  `pathid` int(11) NOT NULL,
  `way` text NOT NULL,
  `name` text NOT NULL,
  `desc` text NOT NULL,
  `time` int(11) NOT NULL,
  `rating` varchar(3) NOT NULL DEFAULT '0',
  `gol` text NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  `size` int(11) NOT NULL DEFAULT '0',
  `login` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '1',
  `themeid` int(11) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `pathid` (`pathid`),
  KEY `time` (`time`),
  KEY `type_status` (`type`,`status`),
  FULLTEXT KEY `desc` (`desc`),
  FULLTEXT KEY `way` (`way`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `downkomm`;

CREATE TABLE `downkomm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `text` text NOT NULL,
  `plus` int(11) NOT NULL,
  `minus` int(11) NOT NULL,
  `golos` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO downkomm VALUES("1","1","1475604161","1","test","0","0","");



DROP TABLE IF EXISTS `download`;

CREATE TABLE `download` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL DEFAULT '0',
  `adres` text NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `type` varchar(4) NOT NULL DEFAULT '',
  `avtor` varchar(25) NOT NULL DEFAULT '',
  `ip` text NOT NULL,
  `soft` text NOT NULL,
  `text` text NOT NULL,
  `screen` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `refid` (`refid`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `downpath`;

CREATE TABLE `downpath` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `way` text NOT NULL,
  `name` text NOT NULL,
  `desc` text NOT NULL,
  `position` int(11) NOT NULL,
  `dost` int(11) NOT NULL DEFAULT '0',
  `types` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `ref` (`refid`),
  KEY `position` (`position`),
  FULLTEXT KEY `way` (`way`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO downpath VALUES("1","0","MUZIKA/","МУЗЫКА","узбекский ,зарубежный,...","0","1","mp3");
INSERT INTO downpath VALUES("2","0","klip/","Музыкальные клипы","","0","1","3gp,mp4");
INSERT INTO downpath VALUES("3","0","kinolar/","Кино , Сериал , Трейлер","","0","1","3gp,mp4");
INSERT INTO downpath VALUES("4","0","zagruzki/","Бесплатной загрузки","","0","1","mp3");



DROP TABLE IF EXISTS `downscreen`;

CREATE TABLE `downscreen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileid` int(11) NOT NULL,
  `way` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO downscreen VALUES("1","1","Teri-Meri_(xindcha).mp3.png");



DROP TABLE IF EXISTS `forum`;

CREATE TABLE `forum` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` char(1) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from` varchar(25) NOT NULL DEFAULT '',
  `realid` int(3) NOT NULL DEFAULT '0',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `soft` text NOT NULL,
  `text` text NOT NULL,
  `close` tinyint(1) NOT NULL DEFAULT '0',
  `close_who` varchar(25) NOT NULL DEFAULT '',
  `vip` tinyint(1) NOT NULL DEFAULT '0',
  `edit` text NOT NULL,
  `tedit` int(10) unsigned NOT NULL DEFAULT '0',
  `kedit` int(2) unsigned NOT NULL DEFAULT '0',
  `curators` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `close` (`close`),
  KEY `user_id` (`user_id`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO forum VALUES("1","0","f","0","0","","1","0","0","Свободное общение на любую тему","Общение","0","","0","","0","0","");
INSERT INTO forum VALUES("2","1","r","0","0","","2","0","0","","О разном","0","","0","","0","0","");
INSERT INTO forum VALUES("3","1","r","0","0","","1","0","0","","Знакомства","0","","0","","0","0","");
INSERT INTO forum VALUES("4","0","f","0","0","","2","0","0","","Жизнь ресурса","0","","0","","0","0","");
INSERT INTO forum VALUES("5","4","r","0","0","","1","0","0","","Новости","0","","0","","0","0","");
INSERT INTO forum VALUES("6","4","r","0","0","","2","0","0","","Предложения и пожелания","0","","0","","0","0","");
INSERT INTO forum VALUES("7","4","r","0","0","","3","0","0","","Разное","0","","0","","0","0","");
INSERT INTO forum VALUES("8","3","t","1260814062","1","JohnCMS","0","0","0","","Привет всем!","0","","0","","0","0","");
INSERT INTO forum VALUES("9","8","m","1260814062","1","JohnCMS","0","1270","0","Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.2.15 Version/10.10","Мы рады приветствовать Вас на нашем сайте :)\r\nДавайте знакомиться!","0","","0","","0","0","");



DROP TABLE IF EXISTS `gallery`;

CREATE TABLE `gallery` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `type` varchar(2) NOT NULL DEFAULT '',
  `avtor` varchar(25) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `name` text NOT NULL,
  `user` binary(1) NOT NULL DEFAULT '\0',
  `ip` text NOT NULL,
  `soft` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `avtor` (`avtor`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO gallery VALUES("2","0","1216913224","rz","","Картинки","","\0","","");
INSERT INTO gallery VALUES("3","2","1216913232","al","","Природа","","\0","","");
INSERT INTO gallery VALUES("4","2","1216913245","al","","Животные","","\0","","");
INSERT INTO gallery VALUES("5","2","1216913260","al","","Креатив","","\0","","");



DROP TABLE IF EXISTS `guest`;

CREATE TABLE `guest` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adm` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(25) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `browser` tinytext NOT NULL,
  `admin` varchar(25) NOT NULL DEFAULT '',
  `otvet` text NOT NULL,
  `otime` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_who` varchar(20) NOT NULL DEFAULT '',
  `edit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_count` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `ip` (`ip`),
  KEY `adm` (`adm`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO guest VALUES("1","1","1217060516","1","admin","Добро пожаловать в Админ Клуб!\r\nСюда имеют доступ ТОЛЬКО Модераторы и Администраторы.\r\nПростым пользователям доступ сюда закрыт.","2130706433","Opera/9.51","","","0","","0","0");
INSERT INTO guest VALUES("2","0","1217060536","1","admin","Добро пожаловать в Гостевую!","2130706433","Opera/9.51","admin","Проверка ответа Администратора","1217064021","","0","0");
INSERT INTO guest VALUES("3","0","1217061125","1","admin","Для зарегистрированных пользователей Гостевая поддерживает BBcode:\r\n[b]жирный[/b]\r\n[i]курсив[/i]\r\n[u]подчеркнутый[/u]\r\n[red]красный[/red]\r\n[green]зеленый[/green]\r\n[blue]синий[/blue]\r\n\r\nи ссылки:\r\nhttp://gazenwagen.com\r\n\r\nДля гостей, эти функции закрыты.","2130706433","Opera/9.51","","","0","","0","0");
INSERT INTO guest VALUES("4","0","1534332393","0","Test","Test","1607850674","Mozilla/5.0 (Linux; U; Android 7.1.1; en-US; SM-J510FN Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.108 UCBrowser","","","0","","0","0");
INSERT INTO guest VALUES("5","0","1534419247","0","Lavrovmi44","[url=http://bit.ly/2NLmL8O]Английский За 4 Недели 2в1[/url]","2918783021","Mozilla/5.0 (Windows NT 8.0; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0","","","0","","0","0");
INSERT INTO guest VALUES("6","0","1534483830","0","Evelynoxype","Привет. Представляем вашему вниманию наши услуги в области международных грузоперевозок. \nОказываем услуги международных перевозок грузов по основным маршрутам: Россия (Челябинск, Екатеринбург, Пермь, Новосибирск, Красноярск, Омск, Тюмень, Томск) - Беларусь - Казахстан. \nОднако готовы выполнить перевозку грузов по любым иным направлениям. \nНаиболее расширенно предлагаем посмотреть на сайте компании \"МиТур\" - https://mityr-trans.com \nНевероятно рады обслуживать Вас в числе наших клиентов.","532213271","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36","","","0","","0","0");



DROP TABLE IF EXISTS `karma_users`;

CREATE TABLE `karma_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `karma_user` int(10) unsigned NOT NULL DEFAULT '0',
  `points` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `karma_user` (`karma_user`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `library_cats`;

CREATE TABLE `library_cats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `dir` tinyint(1) NOT NULL DEFAULT '0',
  `pos` int(10) unsigned NOT NULL DEFAULT '0',
  `user_add` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO library_cats VALUES("1","0","exclusive maqola","foydali maqola","0","1","0");



DROP TABLE IF EXISTS `library_tags`;

CREATE TABLE `library_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lib_text_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tag_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `lib_text_id` (`lib_text_id`),
  KEY `tag_name` (`tag_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `library_texts`;

CREATE TABLE `library_texts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` mediumtext NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `announce` text,
  `uploader` varchar(100) NOT NULL DEFAULT '',
  `uploader_id` int(10) unsigned NOT NULL DEFAULT '0',
  `count_views` int(10) unsigned NOT NULL DEFAULT '0',
  `premod` tinyint(1) NOT NULL DEFAULT '0',
  `comments` tinyint(1) NOT NULL DEFAULT '0',
  `count_comments` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `text` (`text`,`name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO library_texts VALUES("1","1","design dpr remont qvoti","sayta remont","design dpr remont qvoti","Admin","1","1","1","1","0","1534274751");



DROP TABLE IF EXISTS `m_chat`;

CREATE TABLE `m_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `message` varchar(500) NOT NULL,
  `cid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO m_chat VALUES("5","3","asdasdasdd","0","1534269103");



DROP TABLE IF EXISTS `main`;

CREATE TABLE `main` (
  `key` tinytext NOT NULL,
  `val` text NOT NULL,
  PRIMARY KEY (`key`(30))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO main VALUES("status","1");
INSERT INTO main VALUES("amatn","80");
INSERT INTO main VALUES("ulimit","5");
INSERT INTO main VALUES("notfound","http://site.uz/empty.jpeg");
INSERT INTO main VALUES("onid","0");
INSERT INTO main VALUES("oncat","0");
INSERT INTO main VALUES("cat","1");
INSERT INTO main VALUES("cuser","1");



DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `avt` varchar(25) NOT NULL DEFAULT '',
  `name` text NOT NULL,
  `text` text NOT NULL,
  `kom` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL DEFAULT '',
  `name_lat` varchar(40) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `rights` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `failed_login` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `imname` varchar(50) NOT NULL DEFAULT '',
  `sex` varchar(2) NOT NULL DEFAULT '',
  `komm` int(10) unsigned NOT NULL DEFAULT '0',
  `postforum` int(10) unsigned NOT NULL DEFAULT '0',
  `postguest` int(10) unsigned NOT NULL DEFAULT '0',
  `postchat` int(11) NOT NULL,
  `yearofbirth` int(4) NOT NULL DEFAULT '0',
  `datereg` int(10) unsigned NOT NULL DEFAULT '0',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `mail` varchar(50) NOT NULL DEFAULT '',
  `icq` int(10) unsigned NOT NULL DEFAULT '0',
  `skype` varchar(50) NOT NULL DEFAULT '',
  `jabber` varchar(50) NOT NULL DEFAULT '',
  `www` varchar(50) NOT NULL DEFAULT '',
  `about` text NOT NULL,
  `live` varchar(100) NOT NULL DEFAULT '',
  `mibile` varchar(50) NOT NULL DEFAULT '',
  `status` varchar(100) NOT NULL DEFAULT '',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` text NOT NULL,
  `preg` tinyint(1) NOT NULL DEFAULT '0',
  `regadm` varchar(25) NOT NULL DEFAULT '',
  `mailvis` tinyint(1) NOT NULL DEFAULT '0',
  `dayb` int(2) NOT NULL DEFAULT '0',
  `monthb` int(2) NOT NULL DEFAULT '0',
  `sestime` int(10) unsigned NOT NULL DEFAULT '0',
  `total_on_site` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost` int(10) unsigned NOT NULL DEFAULT '0',
  `rest_code` varchar(32) NOT NULL DEFAULT '',
  `rest_time` int(10) unsigned NOT NULL DEFAULT '0',
  `movings` int(10) unsigned NOT NULL DEFAULT '0',
  `place` varchar(30) NOT NULL DEFAULT '',
  `set_user` text NOT NULL,
  `set_forum` text NOT NULL,
  `set_mail` text NOT NULL,
  `karma_plus` int(11) NOT NULL DEFAULT '0',
  `karma_minus` int(11) NOT NULL DEFAULT '0',
  `karma_time` int(10) unsigned NOT NULL DEFAULT '0',
  `karma_off` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `comm_count` int(10) unsigned NOT NULL DEFAULT '0',
  `comm_old` int(10) unsigned NOT NULL DEFAULT '0',
  `smileys` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name_lat` (`name_lat`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO users VALUES("1","Admin","admin","1131243b1cc230e05d8a7eb304d401db","9","0","admin","m","0","0","0","0","0","1534269336","1534511115","","0","","","","admin","","","kycgb","1385291131","1412854429","Opera Mini: Nokia311/07.36","1","","0","0","0","1534511053","3165","1534274751","","0","2","users","","","","0","0","1534510143","0","0","0","");



